/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifndef _DEPOT_TARGETDB_H
#define _DEPOT_TARGETDB_H

/* $Id: TargetDB.h,v 1.9 1994/10/11 15:19:22 ww0r Exp $ 
 * 
 * Author: Sohan C. Ramakrishna Pillai
 */

#define TARGETDBVERSIONSTRING	"TargetDBVersion-1.0"
/* Magic number for compressed database (taken from gzip.h) */
#define	TARGETDB_COMPRESS_MAGIC     "\037\213" 

typedef struct TargetSource
{
  char *path;
  unsigned int update_spec;
  int collection_id;
  unsigned int status;
  unsigned int update_spec_old;
  struct TargetSource *secondary_source;
} TARGETSOURCE;


typedef struct TargetSourceList
{
  unsigned int nsources;
  TARGETSOURCE **source;
} TARGETSOURCELIST;


typedef struct TargetDBEntry
{
  unsigned int childcount;
  char *name;
  unsigned int update_spec;
  SENTENCE *filter;
  FILESTAT *filestatus;
  unsigned int status;
  TARGETSOURCELIST *sourcelist;
  unsigned int update_spec_old;
  FILESTAT *filestatus_old;
  struct TargetDBEntry **children;
} TARGETDBENTRY, TARGETDB;


#define TARGETSOURCE_Path(sp) ((sp)->path)
#define TARGETSOURCE_UpdateSpec(sp) ((sp)->update_spec)
#define TARGETSOURCE_CollectionId(sp) ((sp)->collection_id)
#define TARGETSOURCE_Status(sp) ((sp)->status)
#define TARGETSOURCE_OldUpdateSpec(sp) ((sp)->update_spec_old)
#define TARGETSOURCE_SecondarySource(sp) ((sp)->secondary_source)

#define TARGETSOURCELIST_NSources(sp) ((sp)->nsources)
#define TARGETSOURCELIST_SourceArray(sp) ((sp)->source)
#define TARGETSOURCELIST_Source(sp,n) (*((sp)->source+(n)))

#define TARGETDB_Name(tp) ((tp)->name)
#define TARGETDB_Filter(tp) ((tp)->filter)
#define TARGETDB_UpdateSpec(tp) ((tp)->update_spec)
#define TARGETDB_FileStatus(tp) ((tp)->filestatus)
#define TARGETDB_Status(tp) ((tp)->status)
#define TARGETDB_SourceList(tp) ((tp)->sourcelist)
#define TARGETDB_OldUpdateSpec(tp) ((tp)->update_spec_old)
#define TARGETDB_OldFileStatus(tp) ((tp)->filestatus_old)
#define TARGETDB_ChildCount(tp) ((tp)->childcount)
#define TARGETDB_Children(tp) ((tp)->children)


#define U_NULL		0x000000
#define U_NOOP		0x000001
#define U_DELETE	0x000002
#define U_MAP		0x000004
#define U_MAPCOPY	0x000008
#define U_MAPLINK	0x000010
#define U_SPECIAL	0x000020
#define U_MKDIR		0x000040
#define U_COMMAND	0x000080
#define U_HARDLINK	0x000100
#define U_GROUP		0x000200
#define U_OWNER		0x000400
#define U_MODE		0x000800
#define U_SETSTICKY	0x001000
#define U_SETGID	0x002000
#define U_SETUID	0x004000
#define U_TARGET	0x008000
#define U_NONVIRGIN	0x010000
#define U_SPECIALPATH	0x020000
#define U_NOOPPATH	0x040000
#define U_COMMANDPATH	0x080000
#define U_STATUSPATH	0x100000
#define U_VIRGINLINK	0x200000
#define U_IMMACULATE	0x400000


#define S_NULL		0x0000
#define S_ANTIQUE	0x0001
#define S_MODIFIED	0x0002
#define S_MODIFIEDCHILDREN 0x004
#define S_TARGETISDIR	0x0008
#define S_HARDLINKSOURCE	0x0010

#define S_OBSOLETE	0x00100
#define S_ENDURINGSUBTREE 0x00200
#define S_UNOBSOLETEDSUBTREE 0x00400
#define S_UPTODATE	0x00800
#define S_UPDATEDTHISRUN	0x00800
#define S_OUTOFDATE	0x01000
#define S_OUTOFDATECHILDREN	0x02000

/*
 * status info which does not need to be saved off-line,
 * but which are needed by depot during operation.
 */
#define S_VOLATILE	(S_OBSOLETE|S_ENDURINGSUBTREE|S_UNOBSOLETEDSUBTREE|S_OUTOFDATE|S_OUTOFDATECHILDREN)


/* modes for operations on the database tree */
#define TDB_LOCATE	0x0001
#define TDB_CREATE	0x0002
#define TDB_LAX		0x0004
#define TDB_CHECK	0x0008
#define TDB_SHOWACTIONS	0x0010
#define TDB_USEMODTIMES	0x0020
#define TDB_BUILD	0x0040
#define TDB_REPAIR	0x0080
#define TDB_TRUSTTDB	0x0100


extern TARGETDB *TargetDB_Read();
extern int TargetDB_Write();

extern TARGETDBENTRY *TargetDB_LocateNode();
extern TARGETDBENTRY *TargetDB_LocateChildNode();
extern int TargetDB_LocateIndexToChildNode();

extern TARGETDB *TargetDB_DeleteTargetPath();
TARGETDBENTRY *TargetDB_RemoveChildByIndex();

extern TARGETDB *TargetDB_Merge();

extern TARGETDB *TargetDB_ObsoleteCollection();
extern TARGETDB *TargetDB_UnObsoleteCollection();
extern Boolean TargetDB_UnObsoleteSource();

extern TARGETDB *TargetDB_PruneCollection();
extern void TargetDB_SortByOverrides();
extern Boolean TargetDB_CheckSourceConsistency();
extern TARGETDB *TargetDB_PruneTargets();

extern TARGETDB *TargetDB_CreateTargetPath();
extern TARGETDB *TargetDB_ProtectSpecialTargets();
extern TARGETDB *TargetDB_SetTargetMappings();
extern TARGETDB *TargetDB_SetTargetFileStatus();

extern void TargetDB_Apply();
extern void TargetDB_ReportMergeConflict();
extern void TargetDB_ReportFileConflict();
extern void TargetDB_ReportUpdateConflict();

extern TARGETSOURCE *SourceList_SourceToUse();
extern TARGETSOURCE *HardLink_SourceToUse();
extern void HardLink_GetPathInSameDirectory();
extern Boolean TargetDB_CheckNoop();
extern Boolean TargetDB_CheckDelete();
extern Boolean TargetDB_CheckMaintainDir();
extern Boolean TargetDB_CheckMkdir();
extern Boolean TargetDB_CheckHardLink();
extern Boolean TargetDB_CheckCopyFile();
extern Boolean TargetDB_CheckLinkFile();
extern Boolean TargetDB_CheckPathHierarchy();
extern Boolean TargetDB_Noop();
extern Boolean TargetDB_Delete();
extern Boolean TargetDB_MaintainDir();
extern Boolean TargetDB_Mkdir();
extern Boolean TargetDB_HardLink();
extern Boolean TargetDB_CopyFile();
extern Boolean TargetDB_LinkFile();

extern Boolean TargetDB_CommandTargetExists();
extern Boolean TargetDB_CommandTargetModified();

extern TARGETDB *TargetDB();
extern TARGETDB *TargetDB_Create();
extern void TargetDB_Free();

extern TARGETSOURCELIST *SourceList_AppendSource();

extern int SourceList_FindIndexToCollectionId();
extern int SourceList_FindIndexToSource();

extern TARGETSOURCELIST *SourceList_Merge();
extern TARGETSOURCELIST *SourceList_PruneCollection();
extern TARGETSOURCELIST *SourceList_SortByOverrides();
extern Boolean SourceList_CheckConsistency();

extern TARGETSOURCELIST *SourceList();
extern TARGETSOURCELIST *SourceList_SubList();
extern STRINGSET *TargetSourceList_PathSet();
extern void SourceList_Free();

extern TARGETSOURCE *TargetSource();
extern TARGETSOURCE *TargetSource_Create();
extern Boolean TargetSource_Comparator();
extern Boolean TargetSource_DuplicateComparator();
extern void TargetSource_Free();

#endif /* _DEPOT_TARGETDB_H */
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/014/src/lib/TargetDB/RCS/TargetDB.h,v $ */
