/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: SourceList_SortByOverrides.c,v 1.10 1994/10/14 18:07:37 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"
#include "Preference.h"

static Boolean Source_Override();

static Boolean 
Source_Override(sourcep1, sourcep2,
		preferencedb,
		collectionlistp)
     TARGETSOURCE *sourcep1, *sourcep2;
     PREFERENCEDB *preferencedb;
     COLLECTIONLIST *collectionlistp;
{
  int collectionid1, collectionid2;
  char *collectionname1, *collectionname2;
  Boolean OverridingSourcePair;

  collectionid1 = TARGETSOURCE_CollectionId(sourcep1);
  collectionid2 = TARGETSOURCE_CollectionId(sourcep2);

  if (collectionid1 == collectionid2) {
    OverridingSourcePair = FALSE;
  } else {
    collectionname1 =
      COLLECTION_Name(COLLECTIONLIST_Collection(collectionlistp,
						collectionid1));
    collectionname2 =
      COLLECTION_Name(COLLECTIONLIST_Collection(collectionlistp,
						collectionid2));

    OverridingSourcePair = PreferenceDB_Override(collectionname1,
						 collectionname2,
						 preferencedb);
  }

  return (PROGRAM_ErrorNo == E_NULL) ? OverridingSourcePair : FALSE;
}



TARGETSOURCELIST *
SourceList_SortByOverrides(sourcelistp,
			   preferencedb,
			   collectionlistp,
			   PreSortedSourceList)
     TARGETSOURCELIST *sourcelistp;
     PREFERENCEDB *preferencedb;
     COLLECTIONLIST *collectionlistp;
     Boolean *PreSortedSourceList;
{
  register int i;
  register int from, count;

  TARGETSOURCELIST *sortedsourcelistp;

  int collectionid;
  Boolean LocatedInsertPoint;
  int InsertPoint;
  int nsortedsources;


  if ((sourcelistp == NULL) || (TARGETSOURCELIST_NSources(sourcelistp) <= 1)) {
    sortedsourcelistp = NULL;
    *PreSortedSourceList = TRUE;
  } else {
    *PreSortedSourceList = TRUE;	/* until proven otherwise */
    sortedsourcelistp = (TARGETSOURCELIST *) emalloc(sizeof(TARGETSOURCELIST));
    if (PROGRAM_ErrorNo == E_NULL) {
      TARGETSOURCELIST_NSources(sortedsourcelistp) =
	TARGETSOURCELIST_NSources(sourcelistp);
      TARGETSOURCELIST_SourceArray(sortedsourcelistp) =
	(TARGETSOURCE **)
	emalloc(TARGETSOURCELIST_NSources(sortedsourcelistp)
		* sizeof(TARGETSOURCE *));
      (void)memset(TARGETSOURCELIST_SourceArray(sortedsourcelistp), 0, 
		   TARGETSOURCELIST_NSources(sortedsourcelistp)
		   * sizeof(TARGETSOURCE *));
    }
    /* copy sources from sourcelistp to sortedsourcelistp in sorted order */
    /* 
     * from is the index to the start of sources for the current collection,
     * count counts the number of sources from that collection,
     * nsortedsources keeps track of the number of sources sorted so far.
     */
    from = 0;
    nsortedsources = 0;
    while ((PROGRAM_ErrorNo == E_NULL)
	   && (from < TARGETSOURCELIST_NSources(sourcelistp))) {
      collectionid =
	TARGETSOURCE_CollectionId(TARGETSOURCELIST_Source(sourcelistp,
							  from));
      /* extract contribution of collectionid */
      count = 1;
      while ((PROGRAM_ErrorNo == E_NULL)
	     && ((from + count) < TARGETSOURCELIST_NSources(sourcelistp))
	     && (TARGETSOURCE_CollectionId
		 (TARGETSOURCELIST_Source(sourcelistp,
					  from + count)) == collectionid))
	count++;

      /* locate point at which to insert collection contribution */
      i = 0;
      LocatedInsertPoint = FALSE;
      while ((PROGRAM_ErrorNo == E_NULL)
	     && !LocatedInsertPoint && (i < nsortedsources)) {
	if (Source_Override(TARGETSOURCELIST_Source(sortedsourcelistp, i),
			    TARGETSOURCELIST_Source(sourcelistp, from),
			    preferencedb,
			    collectionlistp)) {
	  LocatedInsertPoint = TRUE;
	  InsertPoint = i;
	  *PreSortedSourceList = FALSE;
	} else {
	  while ((PROGRAM_ErrorNo == E_NULL)
		 && (i < (nsortedsources - 1))
		 && (TARGETSOURCE_CollectionId
		     (TARGETSOURCELIST_Source(sortedsourcelistp, i))
		     == TARGETSOURCE_CollectionId
		     (TARGETSOURCELIST_Source(sortedsourcelistp, i + 1))))
	    i++;
	  i++;
	}
      }
      if ((PROGRAM_ErrorNo == E_NULL) && !LocatedInsertPoint) {
	LocatedInsertPoint = TRUE;
	InsertPoint = nsortedsources;
      }
      /* insert collection's sources into sortedsourcelistp at InsertPoint */
      if ((PROGRAM_ErrorNo == E_NULL) && LocatedInsertPoint) {
	/* push out sources to squeeze in collection's sources */
	for (i = nsortedsources - 1;
	     (PROGRAM_ErrorNo == E_NULL) && (i >= InsertPoint);
	     i--) {
	  TARGETSOURCELIST_Source(sortedsourcelistp, i + count)
	    = TARGETSOURCELIST_Source(sortedsourcelistp, i);
	  TARGETSOURCELIST_Source(sortedsourcelistp, i) = NULL;
	}
	/* insert collection's sources at InsertPoint */
	for (i = 0;
	     (PROGRAM_ErrorNo == E_NULL) && (i < count);
	     i++) {
	  TARGETSOURCELIST_Source(sortedsourcelistp, InsertPoint + i)
	    = TargetSource(TARGETSOURCELIST_Source(sourcelistp, from + i));
	}
      }
      from += count;
      nsortedsources += count;
    }

    /* swap sortedsourcelistp with  sourcelistp */
    if (sourcelistp != NULL) {
      SourceList_Free(sourcelistp);
    }
    sourcelistp = sortedsourcelistp;
  }
  
  return (PROGRAM_ErrorNo == E_NULL) ? sourcelistp : NULL;
}
/* $Source: /afs/andrew/system/src/local/depot2/014/src/lib/TargetDB/RCS/SourceList_SortByOverrides.c,v $ */
