/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: HintDB_Write.c,v 1.3 1994/08/12 18:02:12 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "Hint.h"

static char HintSpecialChars[] =
{
  ' ', '\t', '\n',  '\'', '\"', '\\',
  '\0'
};

static int NHintSpecialChars =
      sizeof(HintSpecialChars)/
      sizeof(HintSpecialChars[0]) - 1;


static int Hint_Write();


static int Hint_Write(fp, hintp)
     FILE *fp;
     HINT *hintp;
{

  if (hintp == NULL)
    {
      FatalError(E_NULLHINT, "Attempt to write NULL hint.\n");
    }
  else
    {
      if (HINT_PathName(hintp) == NULL)
	{
	  FatalError(E_BADHINTNAME, "Attempt to write hint with no path.\n");
	}
      else
	{
	  String_Write(fp, HINT_PathName(hintp),
		       '\\', ' ',
		       HintSpecialChars, NHintSpecialChars);
	}
      /* leave a space */
      putc(' ', fp);
      if (HINT_UniqueID(hintp) == NULL)
	{
	  FatalError(E_BADHINTID, "Attempt to write hint with no id.\n");
	}
      else
	{
	  String_Write(fp, HINT_UniqueID(hintp),
		       '\\', ' ',
		       HintSpecialChars, NHintSpecialChars);
	}
      /* leave a space */
      putc(' ', fp);
      if (PROGRAM_ErrorNo == E_NULL)
	{
	  fprintf(fp, "%d\n", HINT_ModTime(hintp));
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
}



/*
 * Write hint database from file
 */
int HintDB_Write(fp, hintdb)
     FILE *fp;
     HINTDB hintdb;
{
  register HINTDB hpp;
  register unsigned int i;
  unsigned int hintdbsize;

  hintdbsize = HintDB_Size(hintdb);
  fprintf(fp, "%d\n", hintdbsize);

  for (i = 0, hpp = hintdb;
       (i < hintdbsize) && (PROGRAM_ErrorNo == E_NULL);
       i++, hpp++)
    {
      if (Hint_Write(fp, *hpp) < 0)
	{
	  FatalError(E_HINTWRITEFAILED, "Error while writing hint database.\n");
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/Hint/RCS/HintDB_Write.c,v $ */
