/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: FileSystemImageUtil.c,v 1.3 1994/08/12 14:25:03 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 *
 * Author: Sohan C. Ramakrishna Pillai
 *
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"


void FileSystemImage_Free(fsimagep)
     FILESYSTEMIMAGE *fsimagep;
{
  register FILESYSTEMIMAGE *ip, *np;

  if (fsimagep == NULL)
    {
      FatalError(E_BADFILESYSTEMIMAGE,
		 "Attempt to free NULL file system image.\n");
    }

  ip = fsimagep;
  while ((PROGRAM_ErrorNo == E_NULL) && (ip != NULL))
    {
      np = FILESYSTEMIMAGE_Next(ip);
      if (FILESYSTEMIMAGE_Name(ip) != NULL)
	String_Free(FILESYSTEMIMAGE_Name(ip));
      if (FILESYSTEMIMAGE_Link(ip) != NULL)
	String_Free(FILESYSTEMIMAGE_Link(ip));
      /* FILESYSTEMIMAGE_FSMountID is a reuse of FILESYSTEMIMAGE_Link */
      if (FILESYSTEMIMAGE_Child(ip) != NULL)
	FileSystemImage_Free(FILESYSTEMIMAGE_Child(ip));
      (void)free((void *)ip);
      ip = np;
    }

  return;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/FileSystemImage/RCS/FileSystemImageUtil.c,v $ */
