/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: DepotDB_Write.c,v 1.6 1994/10/11 15:19:54 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Preference.h"
#include "DepotConf.h"
#include "Hint.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"
#include "DepotDB.h"


static int DepotDB_LongSkipSize();


static int DepotDB_LongSkipSize()
{
  int skipsize;
  char buffer[BUFSIZ];

  /*
   * Doing it this way makes the intent clearer than taking
   * log to base 10 etc. - may even be faster :-) -- Sohan
   */
  sprintf(buffer, "%ld", MAXLONG);
  skipsize = strlen(buffer);

  return skipsize;
}


int DepotDB_Write(fp, DepotDB, compress)
     FILE *fp;
     DEPOTDB *DepotDB;
     Boolean compress;
{
  int noffsets = 4;
  long OffsetOffset, PreferenceDBOffset, DepotConfDBOffset;
  long CollectionListOffset, TargetDBOffset;

  if (DepotDB == NULL)
    {
      FatalError(E_NULLDEPOTDB,
		 "Attempt to write NULL depot database.\n");
    }

  if (PROGRAM_ErrorNo == E_NULL)
    {
      fprintf(fp, "%s\n", DEPOTDBVERSIONSTRING);
 
      OffsetOffset = ftell(fp);
      if ( fseek(fp,
		 noffsets*(long)DepotDB_LongSkipSize() /* the offset values */
		 + noffsets /* noffsets-1 spaces between longs + 1 return */,
		 SEEK_CUR) < 0)
	{
	  FatalError(E_FSEEKFAILED,
		     "Could not fseek to location in depot database.\n");
	}
    }

  (void)putc(0, fp); /* write a NUL */

  if (PROGRAM_ErrorNo == E_NULL)
    {
      PreferenceDBOffset = ftell(fp);
      PreferenceDB_Write(fp, DEPOTDB_PreferenceDB(DepotDB));
    }
  
  if (PROGRAM_ErrorNo == E_NULL)
    (void)putc(0, fp); /* write a NUL */

  if (PROGRAM_ErrorNo == E_NULL)
    {
      DepotConfDBOffset = ftell(fp);
      if (DEPOTDB_DepotConfDB(DepotDB) != NULL)
	{ GlobalDepotConfDB_Write(fp, DEPOTDB_DepotConfDB(DepotDB)); }
    }

  if (PROGRAM_ErrorNo == E_NULL)
    (void)putc(0, fp); /* write a NUL */

  if (PROGRAM_ErrorNo == E_NULL)
    {
      CollectionListOffset = ftell(fp);
      CollectionList_Write(fp, DEPOTDB_CollectionList(DepotDB));
    }

  if (PROGRAM_ErrorNo == E_NULL)
    (void)putc(0, fp); /* write a NUL */
  
  if (PROGRAM_ErrorNo == E_NULL)
    {
      TargetDBOffset = ftell(fp);
      TargetDB_Write(fp, DEPOTDB_TargetDB(DepotDB), compress);
    }

  /* fseek back to OffsetOffset and print offsets */
  if ((PROGRAM_ErrorNo == E_NULL)
      && (fseek(fp, OffsetOffset, SEEK_SET) < 0))
    {
      FatalError(E_FSEEKFAILED,
		 "Could not fseek to location in depot database.\n");
    }
  if (PROGRAM_ErrorNo == E_NULL)
    {
      fprintf(fp, "%d %d %d %d\n",
	      PreferenceDBOffset, DepotConfDBOffset,
	      CollectionListOffset, TargetDBOffset);
    }

  if (PROGRAM_ErrorNo != E_NULL)
    {
      FatalError(E_DEPOTDBWRITEFAILED,
		 "Attempt to write depot database file failed.\n");
    }
  
  return (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/014/src/lib/DepotDB/RCS/DepotDB_Write.c,v $ */
