/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: DepotDB_OpenClose.c,v 1.5 1994/10/31 20:47:51 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Preference.h"
#include "DepotConf.h"
#include "Hint.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"
#include "DepotDB.h"


DEPOTDBHANDLE *
DepotDB_Open(path)
     char *path;
{
  DEPOTDBHANDLE *dbh;
  char *DepotDBVersionString;

  dbh = (DEPOTDBHANDLE *) emalloc(sizeof(DEPOTDBHANDLE));

  if (PROGRAM_ErrorNo == E_NULL) {
    DEPOTDBHANDLE_FP(dbh) = efopen(path, "r");
    if (PROGRAM_ErrorNo != E_NULL) {
      FatalError(E_DEPOTDBOPENFAILED,
		 "Could not open depot database file: %s\n", path);
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    DepotDBVersionString = efgetstring(DEPOTDBHANDLE_FP(dbh),
				       '\\' /* quotechar */ );
    if ((PROGRAM_ErrorNo == E_NULL)
	&& (strcmp(DepotDBVersionString, DEPOTDBVERSIONSTRING) != 0)) {
      FatalError(E_DEPOTDBVERSION,
	 "depot database version %s is out of date; please update to %s.\n",
		 DepotDBVersionString, DEPOTDBVERSIONSTRING);
    }
    free(DepotDBVersionString);
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    DEPOTDBHANDLE_OFF_PREFERENCE(dbh) = efgetunsigned(DEPOTDBHANDLE_FP(dbh));
    DEPOTDBHANDLE_OFF_DEPOTCONF(dbh) = efgetunsigned(DEPOTDBHANDLE_FP(dbh));
    DEPOTDBHANDLE_OFF_COLLECTIONLIST(dbh) = efgetunsigned(DEPOTDBHANDLE_FP(dbh));
    DEPOTDBHANDLE_OFF_TARGET(dbh) = efgetunsigned(DEPOTDBHANDLE_FP(dbh));
    if (PROGRAM_ErrorNo != E_NULL) {
      FatalError(E_BADDEPOTDBFILE,
		 "Error reading offsets in depot database file: %s\n", path);
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? dbh : NULL;
}


int 
DepotDB_Close(dbh)
     DEPOTDBHANDLE *dbh;
{
  fclose(DEPOTDBHANDLE_FP(dbh));
  (void) free((void *) dbh);

  return (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
}

/* $Source: /afs/andrew/system/src/local/depot2/016/src/lib/DepotDB/RCS/DepotDB_OpenClose.c,v $ */
