/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: DepotConf.c,v 1.5 1994/10/19 19:17:02 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "DepotConf.h"



DEPOTCONFDB *
DepotConfDB_Map(confdbp, collection_name, source, target)
     DEPOTCONFDB *confdbp;
     char *collection_name;
     char *source, *target;
{
  DEPOTCONF **dp;
  int confdbsize;

  if (confdbp == NULL) {
    FatalError(E_BADDEPOTCONFDB,
	       "Attempt to update NULL depot.conf database\n");
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (*confdbp == NULL) {	/* allocate array of length 1 */
      *confdbp = (DEPOTCONFDB) emalloc(sizeof(DEPOTCONF *));
      if (PROGRAM_ErrorNo == E_NULL)
	**confdbp = NULL;
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    confdbsize = DepotConfDB_Size(confdbp) + 1;
    confdbsize++;
    *confdbp = (DEPOTCONFDB) erealloc((void *) *confdbp,
				      (unsigned) confdbsize
				      * sizeof(DEPOTCONF *));
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    dp = *confdbp + confdbsize - 2;
    *dp = (DEPOTCONF *) emalloc(sizeof(DEPOTCONF));
    if (*dp != NULL) {
      DEPOTCONF_CollectionName(*dp) = String(collection_name,
					     strlen(collection_name));
      DEPOTCONF_Spec(*dp) = DC_MAP;
      DEPOTCONF_ConfValue(*dp) = NULL;
      DEPOTCONF_ConfValue(*dp) =
	StringArray_AppendString(DEPOTCONF_ConfValue(*dp), source);
      DEPOTCONF_ConfValue(*dp) =
	StringArray_AppendString(DEPOTCONF_ConfValue(*dp), target);
    }
    *(dp + 1) = NULL;
  }
  return (PROGRAM_ErrorNo == E_NULL) ? confdbp : NULL;
}


DEPOTCONFDB *
DepotConfDB_Delete(confdbp, collection_name, target)
     DEPOTCONFDB *confdbp;
     char *collection_name;
     char *target;
{
  DEPOTCONF **dp;
  int confdbsize;

  if (confdbp == NULL) {
    FatalError(E_BADDEPOTCONFDB,
	       "Attempt to update NULL depot.conf database\n");
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (*confdbp == NULL) {	/* allocate array of length 1 */
      *confdbp = (DEPOTCONFDB) emalloc(sizeof(DEPOTCONF *));
      if (PROGRAM_ErrorNo == E_NULL)
	**confdbp = NULL;
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    confdbsize = DepotConfDB_Size(confdbp) + 1;
    confdbsize++;
    *confdbp = (DEPOTCONFDB) erealloc((void *) *confdbp,
				      (unsigned) confdbsize
				      * sizeof(DEPOTCONF *));
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    dp = *confdbp + confdbsize - 2;
    *dp = (DEPOTCONF *) emalloc(sizeof(DEPOTCONF));
    if (*dp != NULL) {
      DEPOTCONF_CollectionName(*dp) = String(collection_name,
					     strlen(collection_name));
      DEPOTCONF_Spec(*dp) = DC_DELETE;
      DEPOTCONF_ConfValue(*dp) = StringArray_AppendString(NULL, target);
    }
    *(dp + 1) = NULL;
  }
  return (PROGRAM_ErrorNo == E_NULL) ? confdbp : NULL;
}


DEPOTCONFDB *
DepotConfDB_Command(confdbp, collection_name,
		    commandlabel, targetlist)
     DEPOTCONFDB *confdbp;
     char *collection_name;
     char *commandlabel;
     STRINGSET *targetlist;
{
  register char **tp;
  DEPOTCONF **dp;
  int confdbsize;

  if (confdbp == NULL) {
    FatalError(E_BADDEPOTCONFDB,
	       "Attempt to update NULL depot.conf database\n");
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (*confdbp == NULL) {	/* allocate array of length 1 */
      *confdbp = (DEPOTCONFDB) emalloc(sizeof(DEPOTCONF *));
      if (PROGRAM_ErrorNo == E_NULL)
	**confdbp = NULL;
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    confdbsize = DepotConfDB_Size(confdbp) + 1;
    confdbsize++;
    *confdbp = (DEPOTCONFDB) erealloc((void *) *confdbp,
				      (unsigned) confdbsize
				      * sizeof(DEPOTCONF *));
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    dp = *confdbp + confdbsize - 2;
    *dp = (DEPOTCONF *) emalloc(sizeof(DEPOTCONF));
    if (*dp != NULL) {
      DEPOTCONF_CollectionName(*dp) = String(collection_name,
					     strlen(collection_name));
      DEPOTCONF_Spec(*dp) = DC_COMMAND;
      DEPOTCONF_ConfValue(*dp) = StringArray_AppendString(NULL,
							  commandlabel);
      if ((targetlist != NULL) && (STRINGARRAY_Size(targetlist) > 0)) {
	for (tp = STRINGARRAY_Values(targetlist); *tp != NULL; tp++) {
	  DEPOTCONF_ConfValue(*dp) =
	    StringArray_AppendString(DEPOTCONF_ConfValue(*dp), *tp);
	}
      }
    }
    *(dp + 1) = NULL;
  }
  return (PROGRAM_ErrorNo == E_NULL) ? confdbp : NULL;
}


DEPOTCONFDB *
DepotConfDB_DeleteCommand(confdbp, collection_name, commandlabel)
     DEPOTCONFDB *confdbp;
     char *collection_name;
     char *commandlabel;
{
  DEPOTCONF **dp;
  int confdbsize;

  if (confdbp == NULL) {
    FatalError(E_BADDEPOTCONFDB,
	       "Attempt to update NULL depot.conf database\n");
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (*confdbp == NULL) {	/* allocate array of length 1 */
      *confdbp = (DEPOTCONFDB) emalloc(sizeof(DEPOTCONF *));
      if (PROGRAM_ErrorNo == E_NULL)
	**confdbp = NULL;
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    confdbsize = DepotConfDB_Size(confdbp) + 1;
    confdbsize++;
    *confdbp = (DEPOTCONFDB) erealloc((void *) *confdbp,
				      (unsigned) confdbsize
				      * sizeof(DEPOTCONF *));
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    dp = *confdbp + confdbsize - 2;
    *dp = (DEPOTCONF *) emalloc(sizeof(DEPOTCONF));
    if (*dp != NULL) {
      DEPOTCONF_CollectionName(*dp) = String(collection_name,
					     strlen(collection_name));
      DEPOTCONF_Spec(*dp) = DC_DELETECOMMAND;
      DEPOTCONF_ConfValue(*dp) = StringArray_AppendString(NULL,
							  commandlabel);
    }
    *(dp + 1) = NULL;
  }
  return (PROGRAM_ErrorNo == E_NULL) ? confdbp : NULL;
}

/* $Source: /afs/andrew/system/src/local/depot2/015/src/lib/DepotConf/RCS/DepotConf.c,v $ */
