/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: Collection_DeleteTarget.c,v 1.7 1994/10/25 19:45:32 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"


TARGETDB *
Collection_DeleteTarget(targetdbp,
			target,
			collectionp)
     TARGETDB *targetdbp;
     char *target;
     COLLECTION *collectionp;
{
  TARGETDB *newtargetdbp = NULL;

  if (collectionp == NULL) {
    FatalError(E_NULLCOLLECTION,
	       "Attempt to delete target for a NULL collection.\n");
  } 
  if (target == NULL) {
    FatalError(E_NULLTARGET,
	       "Attempt to delete NULL target from collection: %s\n", 
	       COLLECTION_Name(collectionp));
  }
  if ((PROGRAM_ErrorNo == E_NULL) && (targetdbp != NULL)) {
    newtargetdbp = TargetDB_DeleteTargetPath(targetdbp,
					     target,
					     TDB_LOCATE | TDB_LAX);
  }

  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/Collection/RCS/Collection_DeleteTarget.c,v $ */
