.\"
.\" $Header: /afs/andrew/system/src/local/depot2/009/RCS/COLLECTION.man,v 1.1 1993/09/20 21:21:58 sohan Exp $
.\" $Source: /afs/andrew/system/src/local/depot2/009/RCS/COLLECTION.man,v $
.\"
.\"/***********************************************************
.\"        Copyright 1991 by Carnegie Mellon University
.\"
.\"                      All Rights Reserved
.\"
.\"Permission to use, copy, modify, and distribute this software and its
.\"documentation for any purpose and without fee is hereby granted,
.\"provided that the above copyright notice appear in all copies and that
.\"both that copyright notice and this permission notice appear in
.\"supporting documentation, and that the name of CMU not be
.\"used in advertising or publicity pertaining to distribution of the
.\"software without specific, written prior permission.
.\"
.\"CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
.\"ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
.\"CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
.\"ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
.\"WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
.\"ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\"SOFTWARE.
.\"******************************************************************/
.\"
.\" Author: Sohan C. Ramakrishna Pillai
.\"
.TH COLLECTION 7
.SH Name
COLLECTION - information pertaining to a collection
.SH Description
The
.PN COLLECTION
structure is used to store information pertaining to a collection.
The components of
.PN COLLECTION
are:
.nf
typedef struct Collection
{
	u_short id;
	char *name;
	char *path;
	unsigned mapmethod;
	HINTDB hintdb;
	FILESYSTEMIMAGE *image;
	DEPOTCONFDB *depotconfdb;
	STRINGSET *commandlist;
	TARGETDB *targetdb;
	unsigned status;
} COLLECTION;

#define COLLECTION_Id(cp)               ((cp)->id)
#define COLLECTION_Name(cp)             ((cp)->name)
#define COLLECTION_Path(cp)             ((cp)->path)
#define COLLECTION_MapMethod(cp)        ((cp)->mapmethod)
#define COLLECTION_HintDB(cp)           ((cp)->hintdb)
#define COLLECTION_Image(cp)            ((cp)->image)
#define COLLECTION_DepotConfDB(cp)      ((cp)->depotconfdb)
#define COLLECTION_CommandList(cp)      ((cp)->commandlist)
#define COLLECTION_TargetDB(cp)         ((cp)->targetdb)
#define COLLECTION_Status(cp)           ((cp)->status)
.fi

.SH Author
Sohan C. Ramakrishna-Pillai
.SH See Also
TARGETDB(7), HINT(7), FILESYSTEMIMAGE(7), DEPOTCONFDB(7)
