.\"
.\" $Header: /afs/andrew/system/src/local/depot2/009/RCS/Compress.man,v 1.1 1993/09/20 21:22:36 sohan Exp $
.\" $Source: /afs/andrew/system/src/local/depot2/009/RCS/Compress.man,v $
.\"
.\"/***********************************************************
.\"        Copyright 1991 by Carnegie Mellon University
.\"
.\"                      All Rights Reserved
.\"
.\"Permission to use, copy, modify, and distribute this software and its
.\"documentation for any purpose and without fee is hereby granted,
.\"provided that the above copyright notice appear in all copies and that
.\"both that copyright notice and this permission notice appear in
.\"supporting documentation, and that the name of CMU not be
.\"used in advertising or publicity pertaining to distribution of the
.\"software without specific, written prior permission.
.\"
.\"CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
.\"ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
.\"CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
.\"ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
.\"WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
.\"ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\"SOFTWARE.
.\"******************************************************************/
.\"
.\" Author: Sohan C. Ramakrishna Pillai
.\"
.TH Compress 3
.SH Name
Compress, DeCompress - compress/decompress from one file descriptor to another
.SH Syntax
.nf
.B #include <compress.h>
.PP
.B int Compress (\fIfdin, fdout\fP)
.br
.B int \fIfdin, fdout\fP;
.PP
.B int DeCompress (\fIfdin, fdout\fP)
.br
.B int \fIfdin, fdout\fP;
.fi
.SH Description
The
.PN Compress
routine reads in data from the file descriptor \fIfdin\fP and writes out
the data in compressed form onto the file descriptor \fIfdout\fP.
.PP
The
.PN DeCompress
routine reads in data compressed by the
.PN Compress
function from the file
descriptor \fIfdin\fP and writes out the original uncompressed data onto the
file descriptor \fIfdout\fP.
.PP
Compression and decompression are performed using the Lempel-Ziv algorithm as
implemented in the gzip distribution, version 1.2.2 of the GNU Project.
.SH Return Values
0 on success, 1 if an error occurs and 2 to indicate a warning.
.SH Author
Sohan C. Ramakrishna-Pillai
