.\"
.\" $Id: depot.man,v 2.2 1995/02/28 22:26:42 ww0r Exp $
.\" $Source: /afs/andrew.cmu.edu/system/src/local/depot2/020/man/man1/RCS/depot.man,v $
.\"
.\"        Copyright 1991 by Carnegie Mellon University
.\"
.\"                      All Rights Reserved
.\"
.\"Permission to use, copy, modify, and distribute this software and its
.\"documentation for any purpose and without fee is hereby granted,
.\"provided that the above copyright notice appear in all copies and that
.\"both that copyright notice and this permission notice appear in
.\"supporting documentation, and that the name of CMU not be
.\"used in advertising or publicity pertaining to distribution of the
.\"software without specific, written prior permission.
.\"
.\"CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
.\"ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
.\"CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
.\"ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
.\"WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
.\"ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\"SOFTWARE.
.\"
.\"
.\" Author: Sohan C. Ramakrishna Pillai
.\"
.TH DEPOT 1 "29 Jun 1993"
.SH NAME
\fBdepot\fP  \- manages software collections
.SH SYNOPSIS
.B depot
[ 
options
]
[
\-T targetdir
]
.SH DESCRIPTION
\fBdepot\fP
manages the unified installation of diverse software collections into
a single location.
.PP
Software collections may be any combination of files under a common
location, but are usually composed of files associated with a single
application. \fBdepot\fP can be used to control the mapping of
software from a diverse set of such collections onto the target
location, \fI[targetdir]\fP, specified by the \fB-T\fP option. This
provides a consistent view of software at the target location. In the
absence of a \fB-T\fP option, the \fI[targetdir]\fP defaults to one
directory level above the current working directory.
.PP
Mapping of software from collections to the \fI[targetdir]\fP may be
achieved by either making the appropriate symbolic links or by
appropriately copying files from the collections to the target
location. This and other aspects used to customize the installation of
software by \fIdepot\fP may be specified in a file called
\fIdepot.pref\fP in a special directory called \fBdepot\fP under the
\fI[targetdir]\fP.  A description of possible customizations is
available in \fIdepot.pref\fR(5).
.PP
For each collection, the manner in which software under the
collection's directory tree is mapped onto the software tree at the
\fI[targetdir]\fP is specified in a file called \fBdepot.conf\fP.
This file is located at the top level of the collection's directory
tree.  If no \fBdepot.conf\fP file exists, the entire directory tree
of the collection is mapped onto the software tree at the
\fI[targetdir]\fP.  The \fIdepot.conf\fP file is described in further
detail in \fIdepot.conf\fR(5).

.SH OPTIONS
.sp 1
.TP
.B \-T targetdir
sets the target location onto which \fBdepot\fP maps collections. This location is the \fI[targetdir]\fP. Defaults to one level above the current working
directory. The \fItargetdir\fR value should be set to the top level of
the environment (e.g. \fI\-T /usr/local\fR)
.TP
.B \-h
prints a help message
.TP
.B \-n
causes \fBdepot\fP to print out update actions, without actually doing
any updating, no update mode.
.TP
.B \-v
causes \fBdepot\fP to send messages to the standard
output describing its actions; verbose mode.
.TP
.B \-x
prints a help and usage message.
.TP
.B \-Q
trades off consistency of the target directory for speed. As a result,
it does not detect if files are removed in the \fI[targetdir]\fP. This
option may only be used after a successful run of \fBdepot\fP without
the \fB-Q\fP option.

.SH PREFERENCE OPTIONS
.sp 1
The following command line arguments can override the values specified
in the \fIdepot.pref\fR preference file. The preference is specified
by using the full preference name after two dashes (--).  The value of
the preference option is specified after an equal sign (=).
.PP
A description of the preference options can be found in the
\fIdepot.pref\fR(5) man page.
.PP
For BOOLEAN preference options, the value after the equal sign can be
either 'TRUE' or 'FALSE'.
.PP
Only the following  preference options are supported from the command
line:
.TP
.B \-\-usemodtimes=BOOLEAN
The default value is TRUE.
.TP
.B \-\-keepcopiedfileattributes=BOOLEAN
The default value is TRUE.
.TP
.B \-\-compresstargetdb=BOOLEAN
The default value is TRUE.
.PP

.SH LOCKING OPTIONS
.sp 1
.TP
.B \-l
locks the \fI[targetdir]\fP, thereby inhibiting further \fBdepot\fP
updates on the \fI[targetdir]\fP.
.TP
.B \-i 
implicitly locked mode; enables the user to perform \fBdepot\fP
updates on \fI[targetdir]\fP, even if a previous lock by that user is
in place.
.TP
.B \-u
unlocks the \fI[targetdir]\fP, if and only if it was previously locked
by the same user.
.TP
.B \-U 
breaks a lock on \fI[targetdir]\fP set by another user. 
.TP
.B \-L
breaks a lock on \fI[targetdir]\fP however, unlike \fB-U\fP above, it
replaces the lock with a new one for the current user.
.PP
After a successful \fBdepot\fR run has finished the lock file is
removed from the environment, unless \fB\-n\fR was specified.

.SH COMPRESSION OPTIONS
.sp 1 
.PP 
The following options deal with changing the default compression
behavior the target database (targetdb) in the depot.db file. These
environment variables are \fBNOT\fR mandatory.  Compression of this
section of the depot database usually results in a 50% to 80% savings
in disk space but is not required.
.PP
If present at compile time, the GNU zip (gzip) suite will be
used. Otherwise, the stock UNIX compress suite is used. If neither is
present, no compression will be done by default.
.TP
.B DEPOT_COMPRESS
specifies the full path to the compression program to be used and any
flags necessary to read the input from standard in and send the output
to standard out. 
.TP
.B DEPOT_DECOMPRESS
specifies the full path to the decompression program to be used and
any flags necessary to read the input from standard in and send the
output to standard out. 
.PP
Depot will exit with an error if the compression/decompression program
does not understand the input so, for example, do \fBNOT\fR expect
depot to properly decompress a targetdb compressed with gzip using
uncompress. 
.SH FILES
.nf
.ta \w'depot.pref.proto   'u
\fIdepot.pref\fR	environment configuration file
\fIdepot.conf\fR	generated collection configuration file
\fIdepot.db\fR	depot database file 
\fIdepot.lock\fR	lock file for depot

.SH "SEE ALSO"
fsi_generate(1), hintservice(1), dpp(1), depot.pref(5), depot.conf(5)
.SH AUTHOR
Sohan C. Ramakrishna-Pillai

