/*
 * \brief   DDE/IDE gen hd replacement
 * \author  Bjoern Doebel <doebel@os.inf.tu-dresden.de>, Dirk Vogt <dvogt@few.vu.nl>
 * \date    2008-01-29
 */

#include <linux/blkdev.h>
#include <linux/init.h>
#include <linux/genhd.h>
#include <linux/hdreg.h>

#define MAX_DISKS 10

/*
 * Array for storing all known block devices
 */
struct gendisk *_disks[MAX_DISKS];

static void ddekit_print_disk(struct gendisk *disk)
{
	struct block_device *bdev = bdget_disk(disk, 0);

	ddekit_printf("disk: %p (maj %x, min %x, max_min %x)\n",
			disk, disk->major, disk->first_minor, disk->minors);
	ddekit_printf("\tdisk name '%s'", disk->disk_name);
	ddekit_printf("\tpartitions @ %p, fops @ %p\n",
			disk->part_tbl, disk->fops);
	ddekit_printf("\trq @ %p, privdata @ %p\n",
			disk->queue, disk->private_data);
	ddekit_printf("\tcapacity %d, flags %x, dev %p\n",
			get_capacity(disk), disk->flags, disk->driverfs_dev);
}

void ddekit_add_disk(struct gendisk *disk)
{
	int i, err;

	for (i = 0; i < MAX_DISKS; ++i) {
		if (_disks[i] == NULL)
			break;
	}	

	if (i == MAX_DISKS)
	{
		ddekit_printf("too much disks added\n");
		return;
	}

	_disks[i] = disk;
/*
	ddekit_print_disk(disk);
*/
	ddekit_printf("USB disk ready to use.\n");
}

struct gendisk* ddekit_find_disk(const char* name, int partno)
{
	struct gendisk *disk = NULL;
	int i, err;
	struct block_device *bdev;

	for (i = 0; i < MAX_DISKS; ++i)
	{
		if (!_disks[i])
			continue;
		//ddekit_printf("look at:<%s>\n", known_disks[i]->disk_name);

		if (!strcmp(_disks[i]->disk_name, name)) {
			disk = _disks[i];
			break;
		}
	}

	if (!disk)
	{
		ddekit_printf("disk <%s> not found\n", name);
		return 0;
	}

	bdev = bdget_disk(disk, partno);
	if (!bdev)
	{
		ddekit_printf("partition not found %d\n", partno);
		return 0;
	}

	//bdev->bd_invalidated = 0;
	bdev->bd_disk = disk;
	err = blkdev_get(bdev, FMODE_WRITE);
	if (err)
	{
		ddekit_printf("block device not available\n");
		return 0;
	}

	return disk;
}

void ddekit_release_disk(struct gendisk *disk,  int partno) 
{
	int i, err;
	struct block_device *bdev;


	if (!disk)
	{
		return;
	}

#if 0
	for (i = 0; i < MAX_DISKS; ++i)
	{
		if (_disks[i] == disk) {
			_disks[i] = NULL;
		}
	}
#endif



	bdev = bdget_disk(disk, partno);
	if (!bdev)
	{
		ddekit_printf("partition not found %d\n", partno);
		return;
	}

	err = blkdev_put(bdev, FMODE_WRITE);

}

void __init ddekit_disk_init(void)
{
	int i;
	for (i = 0; i < MAX_DISKS; ++i)
		_disks[i] = NULL;
}

subsys_initcall(ddekit_disk_init);
