#include <ddekit/ddekit.h>
#include <ddekit/initcall.h>
#include <minix/drivers.h>
#include <minix/driver.h>

#include <dde/linux26/dde26.h>

void ddekit_minix_wait_exit(void);

static int sef_cb_init(int type, sef_init_info_t *info)
{
    chardriver_announce();

    /* Initialization completed successfully. */
    return 0;
}


/** ddeusb_vhcd_init relies on the linux module_init 
 *  mechanism but currently linkers optimized this 
 *  code away. Read about module init here 
 *  http://linuxgazette.net/157/amurray.html
 *  and the linked documentation about declaring
 *  attributes of functions.
 *
 *  Until the code gest sorted we created a dummy
 *  function to ensure the code does not get optimized
 *  away
 **/
static void alibi_init() {
	volatile int never=0;
	if (never) {
		ddeusb_vhcd_init();
	}
}

void dde_block_init();
void ddekit_shutdown();
void my_evdev_init();
int main(int argc, char **argv)
{
	/*
	 * Before we init dde set the sef callbacks.
	 * ...sef_startup is called by dde.
	 */
	sef_setcb_init_fresh(sef_cb_init);
	sef_setcb_signal_handler(ddekit_shutdown);

	alibi_init();

	l4dde26_init();
	l4dde26_kmalloc_init();
	l4dde26_process_init();
	l4dde26_init_timers();
	l4dde26_softirq_init();
	l4dde26_do_initcalls();
	my_evdev_init();
	ddekit_minix_wait_exit();
	ddekit_printf("Bye!\n");
	return 0;
}

