/*-
 * Copyright (c) 2003-2005 MAEKAWA Masahide <maekawa@cvsync.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef __CONFIG_COMMON_H__
#define	__CONFIG_COMMON_H__

struct config;

struct config_args {
	FILE				*ca_fp;
	time_t				ca_mtime;
	const struct token_keyword	*ca_key;
	struct token			ca_token;
	char				*ca_buffer;
	size_t				ca_bufsize;
};

struct config_args *config_open(const char *);
bool config_close(struct config_args *);

bool config_insert_collection(struct config *, struct collection *);
bool config_parse_base(struct config_args *, struct config *);
bool config_parse_base_prefix(struct config_args *, struct config *);
bool config_parse_errormode(struct config_args *, struct collection *);
bool config_parse_hash(struct config_args *, struct config *);
bool config_parse_release(struct config_args *, struct collection *);
bool config_parse_umask(struct config_args *, struct collection *);
bool config_resolv_prefix(struct config *, struct collection *, bool);
bool config_resolv_scanfile(struct config *, struct collection *);
bool config_set_string(struct config_args *);

#endif /* __CONFIG_COMMON_H__ */
