static char version[] = "cn2jp 1.4 (Aug 1, 1996)";

/*
  Copyright (C) 1996      Seke Wei      (seke@sys.es.osaka-u.ac.jp)

  b2g-util.c: provide related routines for Big5 Chinese to GB Chinese conversion

	char    *lang_big5_to_gb(istr)
		;translate Big5 in istr to GB in allocated buffer
		;the allocated buffer is returned and valid until next call

  This program is free for general distribution.

  This program runs on UNIX. You are welcome to port it to other operating
  systems.

*/

#include <stdio.h>
#include "lang-util.h"

int	seq_big();

/*
	translate big5 in istr to gb in allocated buffer
*/

char *
lang_big5_to_gb(istr)
char	*istr;
{
	static	loaded=0;

	if(!loaded) {
		memcpy(&b2gtbl, &b2gtbl_static, sizeof(struct code_table));
		b2gtbl.src_seq = seq_big;
		b2gtbl.src_seq_to_dest = src_seq_to_dest;
		b2gtbl.src_to_dest = src_to_dest;

		memcpy(&uzpjtbl, &uzpjtbl_static, sizeof(struct uzpj_table));

		loaded=1;
	}

	return (*b2gtbl.src_to_dest)(&b2gtbl, istr);
}
