/*
    Copyright 2004 Brian Smith (brian@smittyware.com)
    This file is part of CM2GPX.

    CM2GPX is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    CM2GPX is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CM2GPX; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _XMLNODE_H_INCLUDED_
#define _XMLNODE_H_INCLUDED_

class CXmlNode;

typedef std::list<CXmlNode*> XmlNodeList;

class CXmlNode  
{
public:
	CXmlNode();
	CXmlNode(string sName, string sContent = "");
	virtual ~CXmlNode();

	string m_sName;
	string m_sContent;
	int m_bAttr;

	CXmlNode* GetParent();
	CXmlNode* GetChildByIndex(int nIndex);
	CXmlNode* GetChildByNameIndex(string sName, int nIndex=0);
	int GetChildCount(string sName = "");

	void AddChild(CXmlNode *pNode);
	CXmlNode* AddChild(string sName, string sValue = "");

	void InsertChild(CXmlNode *pNode);
	CXmlNode* InsertChild(string sName, string sValue = "");

	string GetXML(int nIndent = 0);

	void AddAttr(string sName, string sValue);
	int GetAttrValue(string sName, string &rValue);
	CXmlNode* GetAttrNode(string sName);

private:
	XmlNodeList m_Kids;
	CXmlNode *m_pParent;

	string EncodeUTF8(string sData);
	void ReplaceString(string &rStr, string sOld, string sNew);
	string CheckForSpecialCharacters(string sStr);
	WCHAR_T* StringToWCS(string sStr, int &rLen);
};

#endif // _XMLNODE_H_INCLUDED_
