/*
    Copyright 2004 Brian Smith (brian@smittyware.com)
    This file is part of CM2GPX.

    CM2GPX is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    CM2GPX is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CM2GPX; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _PDBREADER_H_INCLUDED_
#define _PDBREADER_H_INCLUDED_

#include "pdb.h"
#include "dates.h"

// Record fields
#define FLD_NAME        0 
#define FLD_WAYPOINT    1 
#define FLD_COORD       2 
#define FLD_DESC        3 
#define FLD_HINTS       4 
#define FLD_TYPE        5 
#define FLD_NOTES       6 
#define FLD_TERRAIN     7 
#define FLD_DIFFICULTY  8 
#define FLD_LOGS        9 
#define FLD_OWNER	10
#define FLD_DATE	11
#define FLD_STATE	12
#define FLD_COUNTRY	13
#define FLD_CONTAINER	14
#define FLD_BUGS	15
#define FLD_STATUS	16

#define NUM_DB_FIELDS	10
#define NUM_FIELDS	17

class CPDBRecord
{
friend class CPDBReader;
public:
	CPDBRecord();
	~CPDBRecord();

	// Raw data
	char *m_pData;

	// Stuff from main DB record header
	UInt32 m_nFlags;
	UInt16 m_nLogYear;
	UInt16 m_nLogMonth;
	UInt16 m_nLogDay;
	UInt16 m_nLogStartHour;
	UInt16 m_nLogStartMin;
	UInt16 m_nLogEndHour;
	UInt16 m_nLogEndMin;

	// Processed record data
	string m_aFields[NUM_FIELDS];
	double m_dLat, m_dLon;
	string m_sCategory;

protected:
	int ProcessRawRecord(int nType, CDateParser *pDate);
	int ParseCoords();
	void ParseDescHeaders(CDateParser *pDate);
};

typedef std::list<CPDBRecord*> RecordList;

class CPDBReader
{
public:
	CPDBReader();
	~CPDBReader();

	// Configuration
	int m_bFoundFilt;
	int m_bBkmkFilt;
	string m_sCategFilt;
	int m_bExactMatch;

	// Info from PDB file
	RecordList m_entries;
	int m_nType;
	string m_sDBName;
	
	int ReadFile(string sPath, int bQuiet);

private:
	u_long m_nFileLen;
	ItemAppInfoType m_AppInfo;
	CDateParser m_Date;

	PDBHeader* ReadHeader(int fd);
	void ReadAppInfoBlock(int fd, PDBHeader *pHdr);
	int ReadRecords(int fd, PDBHeader *pHdr);
	int CheckFilterString(string sFilter, string sCheck);
	void GetDBName(PDBHeader *pHdr);
};

// CacheMate file type constants
#define CM_UNKNOWN	0
#define CM_MAIN_DB	1
#define CM_IMPORT_DB	2

#endif // _PDBREADER_H_INCLUDED_
