/*
    Copyright 2004 Brian Smith (brian@smittyware.com)
    This file is part of CM2GPX.

    CM2GPX is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    CM2GPX is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CM2GPX; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _GPXWRITER_H_INCLUDED_
#define _GPXWRITER_H_INCLUDED_

#include "pdbreader.h"
#include "xmlnode.h"

class CGPXWriter
{
public:
	CGPXWriter();

	int m_bToStdout;
	int m_bFudgeTZ;
	int m_bKeepName;
	int m_bCategInType;
	string m_sDefType;
	string m_sDefSymbol;

	int WriteGPX(string sFile, RecordList &rList);

private:
	double m_dMinLat, m_dMinLon, m_dMaxLat, m_dMaxLon;

	CXmlNode* BuildRecord(CPDBRecord *pRec);
	CXmlNode* BuildGroundspeakExt(CPDBRecord *pRec);
	CXmlNode* BuildLogExt(CPDBRecord *pRec);

	string FormatDouble(double v);
};

#endif // _GPXWRITER_H_INCLUDED_

