#ifndef _COMMON_H_INCLUDED_
#define _COMMON_H_INCLUDED_

#include "config.h"

#include <stdio.h>
#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#if HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#if STDC_HEADERS
# include <stdlib.h>
# include <stddef.h>
#else
# if HAVE_STDLIB_H
#  include <stdlib.h>
# endif
#endif
#if HAVE_STRING_H
# if !STDC_HEADERS && HAVE_MEMORY_H
#  include <memory.h>
# endif
# include <string.h>
#endif
#if HAVE_STRINGS_H
# include <strings.h>
#endif
#if HAVE_INTTYPES_H
# include <inttypes.h>
#else
# if HAVE_STDINT_H
#  include <stdint.h>
# endif
#endif
#if HAVE_UNISTD_H
# include <unistd.h>
#endif

#if STDC_HEADERS
# include <string.h>
#else
# if !HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr (), *strrchr ();
# if !HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
# if HAVE_MEMSET
#  define bzero(p, n) memset((p), 0, (n))
# endif
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_FCNTL_H
#include <fcntl.h>   
#endif

#include "cm2gpx-stdint.h"

#include <string>
using namespace std;

#include <list>
typedef list<string> StringList;

#ifdef HAVE_WCHAR_H
# include <wchar.h>
typedef wchar_t WCHAR_T;
#else
typedef unsigned short WCHAR_T;
#endif

#ifdef WIN32_BUILD
# define PATH_SEP ('\\')
# define PDB_OPEN_FLAGS (_O_RDONLY | _O_BINARY)
#else
# define PATH_SEP ('/')
# define PDB_OPEN_FLAGS (O_RDONLY)
#endif

#endif // _COMMON_H_INCLUDED_
