#ifndef _HAD_PARRAY_H
#define _HAD_PARRAY_H

/*
  parray.h -- array of pointers
  Copyright (C) 2005 Dieter Baron and Thomas Klausner

  This file is part of ckmame, a program to check rom sets for MAME.
  The authors can be contacted at <ckmame@nih.at>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
  3. The name of the author may not be used to endorse or promote
     products derived from this software without specific prior
     written permission.
 
  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/



struct parray {
    void **entry;
    int nentry;
    int alloc_len;
};

typedef struct parray parray_t;



#define parray_get(a, i)	((a)->entry[i])
#define parray_get_last(a)	\
	(parray_length(a) ? parray_get((a), parray_length(a)-1) : NULL)
#define parray_length(a)	((a)->nentry)
#define parray_sort(a, cmp)	(parray_sort_real((a), 0, -1, -1, (cmp)))
#define parray_sort_part(a, lo, hi, cmp) \
	(parray_sort_real((a), 0, (lo), (hi), (cmp)))
#define parray_sort_unique(a, cmp) (parray_sort_real((a), 1, -1, -1, (cmp)))
#define parray_new()		(parray_new_sized(0))

/* function arguments not specified to avoid lots of casts */
void parray_delete(parray_t *, int, void (*)(/* void * */));
void parray_free(parray_t *, void (*)(/* void * */));
int parray_index(const parray_t *, const void *,
		 int (*cmp)(/* const void *, const void * */));
int parray_index_sorted(const parray_t *, const void *,
			int (*)(/* const void *, const void * */));
parray_t *parray_new_sized(int);
parray_t *parray_new_from_data(void **, int);
void *parray_pop(parray_t *);
void parray_push(parray_t *, void *);
void parray_set_length(parray_t *, int, void *(*)(void),
		       void (*)(/* void * */));
void parray_sort_real(parray_t *, int, int, int,
		      int (*)(/* const void *, const void * */));

#endif /* parray.h */
