.\" Copyright (c) 2005-2011 Dieter Baron and Thomas Klausner.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above
.\"    copyright notice, this list of conditions and the following
.\"    disclaimer in the documentation and/or other materials provided
.\"    with the distribution.
.\" 3. The name of the author may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THOMAS KLAUSNER ``AS IS'' AND ANY
.\" EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR
.\" CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
.\" SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
.\" LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
.\" USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
.\" ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
.\" OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
.\" OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.TH MKMAMEDB 1 "February 8, 2011" NiH
.SH "NAME"
mkmamedb \- create database for use by ckmame
.SH "SYNOPSIS"
.B mkmamedb
[\fB-hV\fR]
[\fB-C\fR \fBhashtypes\fR]
[\fB-F\fR \fBoutputformat\fR]
[\fB-o\fR \fBdbfile\fR]
[\fB-x\fR \fBpat\fR]
[\fB--detector\fR \fBfile\fR]
[\fB--exclude\fR \fBpat\fR]
[\fB--hash\-types\fR \fBtypes\fR]
[\fB--help\fR]
[\fB--output\fR \fBdbfile\fR]
[\fB--prog\-name\fR \fBname\fR]
[\fB--prog\-version\fR \fBversion\fR]
[\fB--version\fR]
[\fBrominfo\-file ...\fR]
.SH "DESCRIPTION"
.B mkmamedb
converts ROM set descriptions from one format to another.
.PP
The ROM set description is read from the specified files (or
directories) or the standard input if no files are specified.
The default output file is
\fBmame.db\fR.
You can override it with the
\fB-o\fR
option or the
\fBMAMEDB\fR
environment variable.
.PP
Supported input formats are:
.RS
.IP \(bu 
CMPro dat file
.IP \(bu 
MAME XML file
.IP \(bu 
MESS Softlist XML file
.IP \(bu 
Romcenter dat file
.IP \(bu 
ckmame(1)
database format
.IP \(bu 
directory of zip archives
.RE
Supported output formats are:
.RS
.IP \(bu 
CMPro dat file
.IP \(bu 
ckmame(1)
database format
.RE
.PP
The CMPro file format is described at
\fBhttp://www.logiqx.com/FAQs/CMPro.shtml\fR,
the DTD for MAME xml can be found in
\fBPREFIX/share/doc/ckmame/\fR.
.SS "OPTIONS"
.B mkmamedb
supports the following options:
.RS
.TP 31
\fB-C\fR \fBtypes, \fB--hash\-types\fR Ar types\fR
A comma separated list of hash types to compute when creating a ROM
set description from a directory of zip archives.
Supported hash types are: crc, md5, sha1.
Default are all.
.TP 31
\fB-F\fR \fBoutputformat, \fB--format\fR Ar outputformat\fR
Specify output format.
Supported formats are: db (ckmame database) and cm (clrmamepro dat file).
Default is cm.
.TP 31
\fB--detector\fR \fBfile\fR
Use CMPro XML header skip detector description from
\fBfile.\fR
This overrides any detectors given in the file itself.
.B mkmamedb
looks for the detector in the input file (if it is a zip file) or
the directory of the input file.
.TP 31
\fB-h\fR, \fB--help\fR
Display a short help message.
.TP 31
\fB-o\fR \fBdbfile, \fB--output\fR Ar dbfile\fR
Write to database
\fBdbfile\fR
instead of the default
``\fBmame.db\fR.''
.TP 31
\fB--prog\-name\fR \fBname\fR
Set name of the program the ROM info is from.
.TP 31
\fB--prog\-version\fR \fBversion\fR
Set version of the program the ROM info is from.
.TP 31
\fB-V\fR, \fB--version\fR
Display program name and version number.
.TP 31
\fB-x\fR \fBpat, \fB--exclude\fR Ar pat\fR
Exclude games with names matching
\fBpat\fR
from the created database.
.RE
.SH "ENVIRONMENT"
.RS
.TP 12
Ev MAMEDB
Location for the database file.
Can be overridden with the
\fB-o\fR
option.
Defaults to
``\fBmame.db\fR.''
.RE
.SH "EXAMPLES"
Get an input file for
mkmamedb(1)
from MAME and convert it to the internal database format:
.Bd \-literal
# mame \-listxml | mkmamedb
.Ed
.SH "SEE ALSO"
ckmame(1),
dumpgame(1)
.SH "AUTHORS"

.B mkmamedb
was written by
Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at.>
