.\" Copyright (c) 2007, 2008 Dieter Baron and Thomas Klausner.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above
.\"    copyright notice, this list of conditions and the following
.\"    disclaimer in the documentation and/or other materials provided
.\"    with the distribution.
.\" 3. The name of the author may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THOMAS KLAUSNER ``AS IS'' AND ANY
.\" EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR
.\" CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
.\" SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
.\" LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
.\" USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
.\" ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
.\" OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
.\" OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.TH DETECTIVE 1 "June 4, 2008" NiH
.SH "NAME"
detective \- list zip archive contents with headers skipped
.SH "SYNOPSIS"
.B detective
[\fB-hV\fR]
[\fB-C\fR \fBhashtypes\fR]
[\fB-D\fR \fBdbfile\fR]
[\fB--db\fR \fBdbfile\fR]
[\fB--detector\fR \fBfile\fR]
[\fB--hash-types\fR \fBtypes\fR]
[\fBzip-archive Op ...\fR]
.SH "DESCRIPTION"
.B detective
lists the contents of zip archives in a format similar to
dumpgame(1),
optionally applying a header skip detector.
.PP
If no hash types or detector are given via command line options,
they are taken from the
ckmame(1)
database.
.SS "OPTIONS"
.B detective
supports the following options:
.RS
.TP 31
\fB-C\fR \fBtypes, \fB--hash-types\fR Ar types\fR
A comma separated list of hash types to compute when creating a ROM
set description from a directory of zip archives.
Supported hash types are: crc, md5, sha1.
.TP 31
\fB-D\fR \fBdbfile, \fB--db\fR Ar dbfile\fR
Use
\fBdbfile\fR
as database file.
.TP 31
\fB--detector\fR \fBfile\fR
Use CMPro XML header skip detector description from
\fBfile.\fR
.RE
.SH "ENVIRONMENT"
.RS
.TP 12
Ev MAMEDB
Location for the database file.
Can be overridden with the
\fB-D\fR
option.
Defaults to
``\fBmame.db\fR.''
.RE
.SH "SEE ALSO"
ckmame(1),
dumpgame(1)
.SH "AUTHORS"

.B detective
was written by
Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at.>
