/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/trace.h,v $
 * $Id: trace.h,v 3.7 1999/10/20 23:59:03 heiner Exp $
 *
 *	tracing and interface to supervisor process
 */
#ifndef CHEST_trace_h_INCLUDED
#define CHEST_trace_h_INCLUDED

#include "types.h"
#include "stats.h"

#ifndef HAS_INTERFACE
# define HAS_INTERFACE		0	/* CF */
#endif

/*
 * Exported variables:
 */

#if HAS_INTERFACE
  Extern int	f_ic;		/* whether we talk to an interactive chest */
  Extern int	f_ic_skip;	/* interactive chest */
  Extern int	f_no_trc;
#else	/* ! HAS_INTERFACE */
# define	f_ic		0
# define	f_ic_skip	0
# define	f_no_trc	0
#endif	/* ! HAS_INTERFACE */


/*
 * Exported functions:
 */

Extern void	trc_init (const char* argv0);	/* initialize module */

Extern void	trc_into_analyse (const Board* bp, int depth);
Extern void	trc_restart   (void);
Extern void	trc_att_start (int depth);	/* implies trc_restart */
Extern void	trc_att_end   (void);
Extern void	trc_def_start (void);		/* no implicit trc_restart */
Extern void	trc_def_end   (void);
Extern void	trc_att_moves (const Board* bp, const Movelist* lp);
Extern void	trc_def_moves (const Board* bp, const Movelist* lp);
Extern void	trc_outof_analyse (const Board*, int retval, const Movelist*);
Extern void	trc_move_exec (const Board* bp, const Move* mp);
Extern void	trc_move_undo (void);
Extern void	trc_move_flush(void);

/*
 * Macros, which may be faster:
 */

#if TRC_GENUINE

# define TRC_INTO_ANALYSE(bp,dep)	trc_into_analyse(bp,dep)
# define TRC_RESTART()			trc_restart()
# define TRC_ATT_START(dep)		trc_att_start(dep)
# define TRC_ATT_END()			trc_att_end()
# define TRC_DEF_START()		trc_def_start()
# define TRC_DEF_END()			trc_def_end()
# define TRC_ATT_MOVES(bp,lp)		trc_att_moves(bp,lp)
# define TRC_DEF_MOVES(bp,lp)		trc_def_moves(bp,lp)
# define TRC_OUTOF_ANALYSE(bp,rv,lp)	trc_outof_analyse(bp,rv,lp)
# define TRC_MOVE_EXEC(bp,mp)		trc_move_exec(bp,mp)
# define TRC_MOVE_UNDO()		trc_move_undo()

#else	/* ! TRC_GENUINE */

# define TRC_INTO_ANALYSE(bp,dep)	/*empty*/
# define TRC_RESTART()			if(      f_mvtrace)trc_restart()
# define TRC_ATT_START(dep)		if(f_ic||f_mvtrace)trc_att_start(dep)
# define TRC_ATT_END()			/*empty*/
# if HAS_INTERFACE
#  define TRC_DEF_START()		if(f_no_trc);else trc_def_start()
#  define TRC_DEF_END()			if(f_no_trc);else trc_def_end()
#  define TRC_ATT_MOVES(bp,lp)		if(f_ic&&!f_no_trc)trc_att_moves(bp,lp)
#  define TRC_DEF_MOVES(bp,lp)		if(      !f_no_trc)trc_def_moves(bp,lp)
# else
#  define TRC_DEF_START()		/*empty*/
#  define TRC_DEF_END()			/*empty*/
#  define TRC_ATT_MOVES(bp,lp)		/*empty*/
#  define TRC_DEF_MOVES(bp,lp)		/*empty*/
# endif
# define TRC_OUTOF_ANALYSE(bp,rv,lp)	/*empty*/
# define TRC_MOVE_EXEC(bp,mp)		trc_move_exec(bp,mp)
# define TRC_MOVE_UNDO()		trc_move_undo()
# define TRC_MOVE_FLUSH()		trc_move_flush()

#endif	/* ! TRC_GENUINE */

#endif	/* ndef CHEST_trace_h_INCLUDED */
