/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/refu.h,v $
 * $Id: refu.h,v 1.8 1999/12/04 23:07:17 heiner Exp $
 *
 *	Refutation table management
 */

#ifndef CHEST_refu_h_INCLUDED
#define CHEST_refu_h_INCLUDED

#include "board.h"		/* Move, MAX_MOVES */
#include "timing.h"		/* TimeSecs */
#include "cost.h"		/* AnaCost */


typedef struct RefuMove		RefuMove;
typedef struct RefuList		RefuList;

/*
 * Normal analysis:
 * refu Per key move there is at most one normal refutation.
 * solu Independantly, for any pair (key,answer), which is not a refutation,
 *	(because there is a (probably short) subsolution), this
 *	is an interesting information: the subsolution should be guaranteed
 *	to be of minimum depth, and hence unique.
 *	We try to collect all such non-refutations ("solu"), but restrict
 *	somewhat the total space for this.
 *
 * Inverted analysis (prove "lost"):
 * lost A "key" move followed by a solution (of min depth).
 *	If we restrict to only one sub-solution, this corresponds exactly
 *	to a "refu".
 * safe A "key" move followed by all legal moves and failure
 *	indicators of various depths.  This corresponds somewhat to
 *	normal "solu"s, but will occupy much more space.
 *	This could be reduced by only storing those moves, for which
 *	the failure depth is not the expected (default) value.
 *	FFS: time/cost info is lost, that way.
 *	BUT: (at least currently) we do not list all the failing second
 *	moves along with different depthes, but rather just a place holder
 *	(standing for all the moves) along with the total depth of the
 *	failed analysis.  Thus, the "safe" entries in ntab[] are 1-1.
 *
 * 1-1 rtab[]	refu N-		lost N+
 * 1-N ntab[]	solu N+		safe N-
 */
#define MAX_NONREFU	(4*MAX_MOVES)

/*
 * Values found in "refutyp"...
 */
#define REFUT_MOVE	 0	/* move (& analysis) */
#define REFUT_NONE	 1	/* NOT a refutation (is solution) */
#define REFUT_ANAKED	 2	/* attacker naked */
#define REFUT_DNAKED	 3	/* defender naked */
#define REFUT_NOMOVE	 4	/* no legal move */
#define REFUT_NOTCHECK	 5	/* not a check move */
#define REFUT_DITO	 6	/* same as above (beaten prom) */
#define REFUT_FACKM	 7	/* fac: K will be checked */
#define REFUT_FACT	 8	/* fac: same again */
#define REFUT_FAC	 9	/* fac: fatal check */
#define REFUT_M2PIECE	10	/* mate2: piece is no cand */
#define REFUT_M2MOVE	11	/* mate2: move is no cand */
#define REFUT_SMFACT	12	/* fac: same again (selfmate) */
#define REFUT_SM1	13	/* special 1-selfmate test */
#define REFUT_CHECK	14	/* is a check move */

struct RefuMove
{
    Move	key;		/* this candidate key move */
    Move	refu;		/* refuted by this move */
    int		anares;		/* result of sub-analysis */
    int8	refutyp;	/* type of refutation */
    Flag	isinv;		/* inverted style */
#if 0	/*FFS*/
    TimeSecs	secs;
    AnaCost	cost;
#endif
};

struct RefuList			/* all collected refutation info */
{
    int		rfull;			/* so many filled in "rtab" */
    int		nfull;			/* so many filled in "ntab" */
    RefuMove	rtab[MAX_MOVES];	/* (1-1) known refutations */
    RefuMove	ntab[MAX_NONREFU];	/* (1-N) known non-refutations */
};


Extern void	refu_clear( RefuList* );

Extern void	refu_fail ( RefuList*, const Move*, const Move*, int subres);
Extern void	refu_move ( RefuList*, const Move*, const Move*, int subres);
Extern void	refu_note ( RefuList*, const Move*, int reason, int dep);

Extern void	refu_lost ( RefuList*, const Move*, const Move*, int subres);
Extern void	refu_safe ( RefuList*, const Move*, int subres);

Extern void	put_refulist( Board*, RefuList*);


#if 0
# define REFU(x)		/*empty*/

# define refu_clear(rlp )			/*empty*/
# define refu_move( rlp, ap, dp, subres)	/*empty*/
# define refu_note( rlp, ap, reason, dep)	/*empty*/
# define put_refulist(bp, rlp)			/*empty*/
#else
# if 0
#  define REFU(x)		x
# endif
#endif

#endif	/* ndef CHEST_refu_h_INCLUDED */
