dnl
dnl ce-specific tests
dnl

dnl Check type of signal routines (posix, 4.2bsd, 4.1bsd or v7)
AC_DEFUN(CE_SIGNAL_CHECK,
[AC_REQUIRE([AC_TYPE_SIGNAL])
AC_MSG_CHECKING(for type of signal functions)
AC_CACHE_VAL(ce_cv_signal_vintage,
[
  AC_TRY_LINK([#include <signal.h>],[
    sigset_t ss;
    struct sigaction sa;
    sigemptyset(&ss); sigsuspend(&ss);
    sigaction(SIGINT, &sa, (struct sigaction *) 0);
    sigprocmask(SIG_BLOCK, &ss, (sigset_t *) 0);
  ], ce_cv_signal_vintage=posix,
  [
    AC_TRY_LINK([#include <signal.h>], [
	int mask = sigmask(SIGINT);
	sigsetmask(mask); sigblock(mask); sigpause(mask);
    ], ce_cv_signal_vintage=4.2bsd,
    [
      AC_TRY_LINK([
	#include <signal.h>
	RETSIGTYPE foo() { }], [
		int mask = sigmask(SIGINT);
		sigset(SIGINT, foo); sigrelse(SIGINT);
		sighold(SIGINT); sigpause(SIGINT);
        ], ce_cv_signal_vintage=svr3, ce_cv_signal_vintage=v7
    )]
  )]
)
])
AC_MSG_RESULT($ce_cv_signal_vintage)
if test "$ce_cv_signal_vintage" = posix; then
AC_DEFINE(HAVE_POSIX_SIGNALS)
elif test "$ce_cv_signal_vintage" = "4.2bsd"; then
AC_DEFINE(HAVE_BSD_SIGNALS)
elif test "$ce_cv_signal_vintage" = svr3; then
AC_DEFINE(HAVE_USG_SIGHOLD)
fi
])

AC_DEFUN(CE_JOB_CONTROL_MISSING,
[AC_REQUIRE([CE_SIGNAL_CHECK])
AC_MSG_CHECKING(for presence of necessary job control definitions)
AC_CACHE_VAL(ce_cv_job_control_missing,
[AC_TRY_RUN([
#include <sys/types.h>
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <signal.h>

/* Add more tests in here as appropriate. */
main()
{
/* signal type */
#if !defined (HAVE_POSIX_SIGNALS) && !defined (HAVE_BSD_SIGNALS)
exit(1);
#endif

/* signals and tty control. */
#if !defined (SIGTSTP) || !defined (SIGSTOP) || !defined (SIGCONT)
exit (1);
#endif

/* process control */
#if !defined (WNOHANG) || !defined (WUNTRACED) 
exit(1);
#endif

exit(0);
}],ce_cv_job_control_missing=present, ce_cv_job_control_missing=missing,
        AC_MSG_ERROR(cannot check job control if cross-compiling))
])
AC_MSG_RESULT($ce_cv_job_control_missing)
if test $ce_cv_job_control_missing = missing; then
AC_DEFINE(JOB_CONTROL_MISSING)
fi
])

AC_DEFUN(CE_CHECK_LIB_TERMCAP,
[
if test "X$ce_cv_termcap_lib" = "X"; then
_ce_needmsg=yes
else
AC_MSG_CHECKING(which library has the termcap functions)
_ce_needmsg=
fi
AC_CACHE_VAL(ce_cv_termcap_lib,
[AC_CHECK_LIB(termcap, tgetent, ce_cv_termcap_lib=libtermcap,
    [AC_CHECK_LIB(curses, tgetent, ce_cv_termcap_lib=libcurses,
        [AC_CHECK_LIB(ncurses, tgetent, ce_cv_termcap_lib=libncurses,
            ce_cv_termcap_lib=termcap)])])])
if test "X$_ce_needmsg" = "Xyes"; then
AC_MSG_CHECKING(which library has the termcap functions)
fi
AC_MSG_RESULT(using $ce_cv_termcap_lib)
if test $ce_cv_termcap_lib = libtermcap && test -z "$prefer_curses"; then
TERMCAP_LIB=-ltermcap
elif test $ce_cv_termcap_lib = libncurses; then
TERMCAP_LIB=-lncurses
else
TERMCAP_LIB=-lcurses
fi  
])

AC_DEFUN(CE_TYPE_U_INT16_T,
[
if test "$ac_cv_sizeof_short" = 2; then
  AC_CHECK_TYPE(u_int16_t, unsigned short)
elif test "$ac_cv_sizeof_char" = 2; then
  AC_CHECK_TYPE(u_int16_t, unsigned char)
else
  AC_CHECK_TYPE(u_int16_t, unsigned short)
fi
])

AC_DEFUN(CE_TYPE_INT32_T,
[
if test "$ac_cv_sizeof_int" = 4; then
  AC_CHECK_TYPE(int32_t, int)
elif test "$ac_cv_sizeof_long" = 4; then
  AC_CHECK_TYPE(int32_t, long)
else
  AC_CHECK_TYPE(int32_t, int)
fi
])

AC_DEFUN(CE_TYPE_U_INT32_T,
[
if test "$ac_cv_sizeof_int" = 4; then
  AC_CHECK_TYPE(u_int32_t, unsigned int)
elif test "$ac_cv_sizeof_long" = 4; then
  AC_CHECK_TYPE(u_int32_t, unsigned long)
else
  AC_CHECK_TYPE(u_int32_t, unsigned int)
fi
])

AC_DEFUN(CE_TYPE_BITS64_T,
[
if test "$ac_sv_sizeof_char_p" = 8; then
  AC_CHECK_TYPE(bits64_t, char *)
elif test "$ac_cv_sizeof_double" = 8; then
  AC_CHECK_TYPE(bits64_t, double)
elif test "$ac_cv_sizeof_long" = 8; then
  AC_CHECK_TYPE(bits64_t, long)
else  
  AC_CHECK_TYPE(bits64_t, double)
fi
])

dnl
dnl Check if dup2() does not clear the close on exec flag
dnl
AC_DEFUN(CE_DUP2_CLOEXEC_CHECK,
[AC_MSG_CHECKING(if dup2 fails to clear the close-on-exec flag)
AC_CACHE_VAL(ce_cv_dup2_broken,
[AC_TRY_RUN([
#include <sys/types.h>
#include <fcntl.h>
main()
{
  int fd1, fd2, fl;
  fd1 = open("/dev/null", 2);
  if (fcntl(fd1, 2, 1) < 0)
    exit(1);
  fd2 = dup2(fd1, 1);
  if (fd2 < 0)
    exit(2);
  fl = fcntl(fd2, 1, 0);
  /* fl will be 1 if dup2 did not reset the close-on-exec flag. */
  exit(fl != 1);
}
], ce_cv_dup2_broken=yes, ce_cv_dup2_broken=no,
    AC_MSG_ERROR(cannot check dup2 if cross compiling))
])
AC_MSG_RESULT($ce_cv_dup2_broken)
if test $ce_cv_dup2_broken = yes; then
AC_DEFINE(DUP2_BROKEN)
fi
])

AC_DEFUN(CE_FUNC_LSTAT,
[dnl Cannot use AC_CHECK_FUNCS(lstat) because Linux defines lstat() as an
dnl inline function in <sys/stat.h>.
AC_CACHE_CHECK([for lstat], ce_cv_func_lstat,
[AC_TRY_LINK([
#include <sys/types.h>
#include <sys/stat.h>
],[ lstat(".",(struct stat *)0); ],
ce_cv_func_lstat=yes, ce_cv_func_lstat=no)])
if test $ce_cv_func_lstat = yes; then
  AC_DEFINE(HAVE_LSTAT)
fi
])
