/*
 * recursion.c -- part of the C sources generated from the CDL3 sources,
 *              used to bootstrap CDL3
 * Copyright (C) 2000  C.H.A. Koster
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cdl3rts.h"
#include "predef.h"


static char* module_name = "recursion";

/*
** GLOBALS
*/

	static long undefined[] = {2047};
long G_recursion_REM_REC_NR0 = 0;
long G_recursion_REM_FUN_NR1 = 0;
value G_recursion_IS_DONE_NR2 = undefined;
long G_recursion_XCOUNT_NR3 = 0;
long G_recursion_CUR_FRAMESIZE_NR4 = 0;
long G_recursion_FRAME_FROM_NR5B = 0;
value G_recursion_FRAME_FROM_NR5 = &G_recursion_FRAME_FROM_NR5B;
long G_recursion_PAR_FROM_NR6B = 0;
value G_recursion_PAR_FROM_NR6 = &G_recursion_PAR_FROM_NR6B;
long G_recursion_FRAME_COUNT_NR7A = 1;
value G_recursion_FRAME_COUNT_NR7 = &G_recursion_FRAME_COUNT_NR7A;
long G_recursion_PAR_COUNT_NR8A = 1;
value G_recursion_PAR_COUNT_NR8 = &G_recursion_PAR_COUNT_NR8A;
long G_recursion_TEXT_NR2896[] = {Tag(1,T_TEXT),21,(long)"Removing recursion..."};
long G_recursion_TEXT_NR2897[] = {Tag(1,T_TEXT),8,(long)"Removed "};
long G_recursion_TEXT_NR2898[] = {Tag(1,T_TEXT),21,(long)" right recursions in "};
long G_recursion_TEXT_NR2899[] = {Tag(1,T_TEXT),8,(long)" rules.\n"};
long G_recursion_TEXT_NR2900[] = {Tag(1,T_TEXT),6,(long)"Found "};
long G_recursion_TEXT_NR2901[] = {Tag(1,T_TEXT),39,(long)" recursive calls followed by detaches.\n"};
long G_recursion_TEXT_NR2902[] = {Tag(1,T_TEXT),9,(long)"Before RR"};
long G_recursion_TEXT_NR2903[] = {Tag(1,T_TEXT),8,(long)"After RR"};
long G_recursion_TEXT_NR2904[] = {Tag(1,T_TEXT),9,(long)"RECURSION"};
long G_recursion_MAPLIST_NR2905[] = {Tag(1,1)};
long G_recursion_INSTRUCTION_NR2906[] = {Tag(1,0)};
long G_recursion_INSTRUCTION_NR2907[] = {Tag(1,15)};
long G_recursion_FRAME_FROM_NR2908[] = {Tag(1,1)};
long G_recursion_PAR_FROM_NR2909[] = {Tag(1,2)};
long G_recursion_PAR_FROM_NR2910[] = {Tag(1,2)};
long G_recursion_PAR_FROM_NR2911[] = {Tag(1,2)};
long G_recursion_FRAME_FROM_NR2912[] = {Tag(1,1)};
long G_recursion_FRAME_FROM_NR2913[] = {Tag(1,1)};
long G_recursion_FRAME_FROM_NR2914[] = {Tag(1,1)};
long G_recursion_TEXT_NR2915[] = {Tag(1,T_TEXT),22,(long)"Input cycle resolved.\n"};
long G_recursion_PAR_FROM_NR2916[] = {Tag(1,2)};
long G_recursion_TEXT_NR2917[] = {Tag(1,T_TEXT),25,(long)": Output cycle resolved.\n"};
long G_recursion_FRAME_FROM_NR2918[] = {Tag(1,1)};
long G_recursion_PAR_FROM_NR2919[] = {Tag(1,2)};

/*
** ATTACH/DETACH/EQUAL
*/
/****IS_DONE(recursion)****/

int EQ_Mrecursion_T3(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Mrecursion_T3(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("yes ");
       case 1:
WRITE("no ");
    };
  return 0;
}

int XD_Mrecursion_T3(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mrecursion_T3(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrecursion_T3(x);
}

/****FRAME_FROM(recursion)****/

int EQ_Mrecursion_T6(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Mrecursion_T6(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("frame ");
W_INT(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Mrecursion_T6(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mrecursion_T6(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrecursion_T6(x);
}

/****PAR_FROM(recursion)****/

int EQ_Mrecursion_T7(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1));
       case 1:
         return (Part(x,1) == Part(y,1));
       case 2:
         return 1;
    };
  return 0;
}

int W_Mrecursion_T7(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("par ");
W_INT(Part(x,1));
WRITE(" ");
       case 1:
WRITE("frame ");
W_INT(Part(x,1));
WRITE(" ");
       case 2:
WRITE("none ");
    };
  return 0;
}

int XD_Mrecursion_T7(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,2);
            break;
          case 1:
            Free(x,2);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Mrecursion_T7(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrecursion_T7(x);
}

/****MAPLIST(recursion)****/

int EQ_Mrecursion_T17(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2))&&(Part(x,3) == Part(y,3))&&EQ_Mrecursion_T17(Part(x,4),Part(y,4));
       case 1:
         return 1;
    };
  return 0;
}

int W_Mrecursion_T17(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("maps ");
WRITE("to ");
WRITE("parameter ");
W_INT(Part(x,2));
WRITE(" ");
W_INT(Part(x,3));
WRITE(" ");
WRITE("and ");
W_Mrecursion_T17(Part(x,4));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Mrecursion_T17(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mcode_T20(Part(x,1));
D_Mrecursion_T17(Part(x,4));
            Free(x,5);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mrecursion_T17(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mrecursion_T17(x);
}


/*
** PROTOTYPES
*/

_PROTOTYPE(int Mrecursion_P_remove_right_recursion,());
_PROTOTYPE(int Mrecursion_P_remove_right_recursion_RULENR_LOCATION,(value P0,value P1));
_PROTOTYPE(int Mrecursion_P_init,());
_PROTOTYPE(int Mrecursion_P_exit,());
_PROTOTYPE(int Mrecursion_P_remove_right_recursion_HEADER,(value P0));
_PROTOTYPE(int Mrecursion_P_remove_right_recursion_HEADER_RULENR_LOCATION,(value P0,value P1,value *P2));
_PROTOTYPE(int Mrecursion_P_debug_TEXT_RULENR,(value P0,value P1));
_PROTOTYPE(int Mrecursion_P_search_tail_recursion_LOCATION_RULENR_ENTRY_PARAMETER_MAP_LOCATION,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(int Mrecursion_P_search_next_tail_recursion_LOCATION_RULENR_PARAMETER_MAP_LABEL_LOCATION,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(int Mrecursion_P_is_tail_recursion_LOCATION_MAPLIST_LOCATION_ADDRESSES,(value P0,value *P1,value *P2,value P3));
_PROTOTYPE(int Mrecursion_P_is_a_parameter_ADDRESS_ADDRESSES,(value P0,value P1));
_PROTOTYPE(int Mrecursion_P_detach_is_tail_recursion_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(int Mrecursion_P_remove_first_recursion_LOCATION_ENTRY_RULENR_ADDRESSES_MAPLIST_PARAMETER_MAP_LABEL,(value P0,value P1,value P2,value P3,value P4,value P5,value *P6));
_PROTOTYPE(int Mrecursion_P_remove_recursive_call_LOCATION_RULENR_ADDRESSES_MAPLIST_PARAMETER_MAP_LABEL,(value P0,value P1,value P2,value P3,value P4,value P5));
_PROTOTYPE(int Mrecursion_P_copy_parameters_FRAMESIZE_INT_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(int Mrecursion_P_generate_mapping_ADDRESSES_PARAMETERS_PARAMETER_MAP_MAPLIST_INT,(value P0,value P1,value P2,value P3,value P4));
_PROTOTYPE(int Mrecursion_P_find_initial_location_INT_PARAMETER_MAP_ADDRESS,(value P0,value P1,value *P2));
_PROTOTYPE(int Mrecursion_P_find_ultimate_destination_ADDRESS_MAPLIST_INT,(value P0,value P1,value *P2));
_PROTOTYPE(int Mrecursion_P_find_next_rule_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(int Mrecursion_P_expect_failure_LABEL,(value P0));
_PROTOTYPE(int Mrecursion_P_expect_failure_LOCATION,(value P0));
_PROTOTYPE(int Mrecursion_P_clear_tables_FRAMESIZE,(value P0));
_PROTOTYPE(int Mrecursion_P_clear_tables_INT_ADDRESSES_INT,(value P0,value P1,value *P2));
_PROTOTYPE(int Mrecursion_P_generate_output_copies_INT_LOCATION,(value P0,value P1));
_PROTOTYPE(int Mrecursion_P_generate_input_copies_INT_LOCATION,(value P0,value P1));
_PROTOTYPE(int Mrecursion_P_input_recursion_INT_LOCATION,(value P0,value P1));
_PROTOTYPE(int Mrecursion_P_output_recursion_INT_LOCATION,(value P0,value P1));
_PROTOTYPE(int Mrecursion_P_resolve_input_cycle_LOCATION_INT_INT,(value P0,value P1,value P2));
_PROTOTYPE(int Mrecursion_P_resolve_output_cycle_LOCATION_INT_INT,(value P0,value P1,value P2));


/*
**EXTERNAL PROTOTYPES**
*/

_PROTOTYPE(extern int E1_open_input_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E2_open_output_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E3_open_standard_output_FILE,(value *P0));
_PROTOTYPE(extern int E4_open_standard_error_FILE,(value *P0));
_PROTOTYPE(extern int E5_open_standard_input_FILE,(value *P0));
_PROTOTYPE(extern int E8_pipe_to_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E28_pipe_from_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E9_close_pipe_FILE,(value P0));
_PROTOTYPE(extern int E6_close_FILE,(value P0));
_PROTOTYPE(extern int E7_seek_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E10_write_TEXT,(value P0));
_PROTOTYPE(extern int E11_write_INT,(value P0));
_PROTOTYPE(extern int E12_write_FILE_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E13_write_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E14_formatted_write_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E15_write_char_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E16_write_char_INT,(value P0));
_PROTOTYPE(extern int E20_trace_TEXT,(value P0));
_PROTOTYPE(extern int E21_trace_INT,(value P0));
_PROTOTYPE(extern int E22_formatted_trace_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E30_read_line_TEXT,(value *P0));
_PROTOTYPE(extern int E31_read_line_FILE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E32_read_char_FILE_INT,(value P0,value *P1));
_PROTOTYPE(extern int E33_read_char_INT,(value *P0));
_PROTOTYPE(extern int E40_less_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E41_lesseq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E42_greater_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E43_greatereq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E58_length_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E51_extract_TEXT_INT_INT_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int E52_is_subtext_TEXT_INT_TEXT,(value P0,value *P1,value P2));
_PROTOTYPE(extern int E53_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E54_not_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E55_before_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E56_is_prefix_TEXT_TEXT_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E57_prefix_TEXT_INT_TEXT_TEXT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int E59_asciicode_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E60_bindec_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E61_decbin_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E70_hash_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E80_command_arg_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E81_exit_INT,(value P0));
_PROTOTYPE(extern int E82_get_from_environment_TEXT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E83_time_INT,(value *P0));
_PROTOTYPE(extern int E85_file_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E84_execute_TEXT,(value P0));
_PROTOTYPE(extern int E200_get_key_TEXT,(value *P0));
_PROTOTYPE(extern int Mmodules_P_init_modules,());
_PROTOTYPE(extern int Mmodules_P_is_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_set_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_new_id_MODULENR_ID,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_order_MODULENR_MODULEORDER,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_convert_MODULE_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_add_import_for_module_MODULENR_MODULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_store_versionid_MODULENR_VERSIONTEXT,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_module_exports_rule_MODULENR_RULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_MODULE,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_module_name_MODULENR_MODULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_VERSIONTEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_EXPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_IMPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_first_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_next_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_error_MODULENR,(value P0));
_PROTOTYPE(extern int Mcode_P_start_coding,());
_PROTOTYPE(extern int Mcode_P_new_LABEL,(value *P0));
_PROTOTYPE(extern int Mcode_P_error_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_error_MONADIC_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_store_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_append_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_overwrite_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_move_LOCATION_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_current_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_set_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_get_LOCATION_INSTRUCTION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_next_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_is_end_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_first_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_next_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_is_associative_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS,(value P0));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_alias_LABEL_LABEL,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int Mcode_P_called_once_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_get_label_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_no_effect_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_write_ADDRESS,(value P0));
_PROTOTYPE(extern int Mcode_P_get_ADDRESS_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_get_ADDRESSES_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_dump_code_MODULENR_TEXT,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_dump_instruction_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_dump_code_TEXT_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_make_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mcode_P_request_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mrules_P_propagate_rules,());
_PROTOTYPE(extern int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(extern int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(extern int Mrules_P_is_external_RULENR_EXTNR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_in_interface_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_is_fixed_RULENR_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR,(value P0,value *P1,value *P2,value *P3,value *P4,value *P5,value *P6));
_PROTOTYPE(extern int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULETYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_PARAMETERS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mrules_P_get_preludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_postludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_interludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_error_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_error_RULENAME,(value P0));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENAME_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_definition_errors,());
_PROTOTYPE(extern int Mrules_P_set_root_error_handler_HANDLER,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_error_handler_HANDLER,(value *P0));
_PROTOTYPE(extern int Mrules_P_set_root_rule_ROOT,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_rule_ROOT,(value *P0));
_PROTOTYPE(extern int Merrors_P_status_message_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_int_INT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_error_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_int_INT,(value P0));
_PROTOTYPE(extern int Mtypes_P_propagate_types,());
_PROTOTYPE(extern int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_is_imported_abstract_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_abstract_type_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_special_type_TYPENR_STYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_external_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_integer_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_undefined_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_exported_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_same_TYPE_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_same_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_integer_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_is_text_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_text_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_equal_types_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPENAME_MODULENR,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_first_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_next_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_error_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_build_type_TYPENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_type_errors,());
_PROTOTYPE(extern int Minline_P_declare_rule_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_register_call_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_inline_TEXT,(value P0));
_PROTOTYPE(extern int Minline_P_inline_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_disable_inlining,());
_PROTOTYPE(extern int Minline_P_ignore_unreachable_code,());
_PROTOTYPE(extern int Minline_P_rule_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_call_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_resolve_call_graph_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_is_recursive_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_rule_is_reachable_RULENR,(value P0));
_PROTOTYPE(extern int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));
_PROTOTYPE(extern int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value *P1,value *P2,value *P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_set_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_not_local_VARIABLENR,(value P0));
_PROTOTYPE(extern int Mvariables_P_is_constant_VARIABLENR_VALUE,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_global_VARIABLENR_REFNO,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_first_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_next_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_error_INSTANCE,(value P0));
_PROTOTYPE(extern int Mvariables_P_build_instance_INSTANCE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcoder_P_no_code,());
_PROTOTYPE(extern int Mcoder_P_no_gc,());
_PROTOTYPE(extern int Mcoder_P_trace_on,());
_PROTOTYPE(extern int Mcoder_P_produce_statistics,());
_PROTOTYPE(extern int Mcoder_P_profile_on,());
_PROTOTYPE(extern int Mcoder_P_just_compile_and_no_object,());
_PROTOTYPE(extern int Mcoder_P_extension_TEXT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_external_names_do_not_start_with_underscore,());
_PROTOTYPE(extern int Mcoder_P_optimize_array_references,());
_PROTOTYPE(extern int Mcoder_P_code_MODULENR,(value P0));
_PROTOTYPE(extern int Mfiles_P_paths_PATHS,(value *P0));
_PROTOTYPE(extern int Mfiles_P_init_files,());
_PROTOTYPE(extern int Mfiles_P_strip_path_TEXT_TEXT_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mfiles_P_set_lib_path_TEXT,(value P0));
_PROTOTYPE(extern int Mfiles_P_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mfiles_P_open_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int Mscanner_P_syntax_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Mscanner_P_current_line_LINENR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_open_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_close,());
_PROTOTYPE(extern int Mscanner_P_end_of_file,());
_PROTOTYPE(extern int Mscanner_P_is_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_ahead_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_should_be_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME_INSTANCE,(value *P0,value *P1));
_PROTOTYPE(extern int Mscanner_P_is_placeholder_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TERMINAL,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_MODULE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_SIZE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_EXTNR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_NUMBER,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_STRING,(value *P0));
_PROTOTYPE(extern int Manalyzer_P_semantic_errors,());
_PROTOTYPE(extern int Manalyzer_P_analyse_main_MODULENR_ROOT,(value P0,value P1));
_PROTOTYPE(extern int Manalyzer_P_analyse_rules_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_resolve_call_ahead_NODENR_RULENR,(value P0,value *P1));
_PROTOTYPE(extern int Manalyzer_P_warnings_on,());
_PROTOTYPE(extern int Mnodes_P_new_NODENR,(value *P0));
_PROTOTYPE(extern int Mnodes_P_store_NODENR_LINENR_NODE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mnodes_P_get_NODENR_LINENR_NODE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mnodes_P_append_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_append_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_pass_two_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_error_SUBEXPRESSION,(value P0));
_PROTOTYPE(extern int Mnodes_P_error_EXPRESSION,(value P0));
_PROTOTYPE(extern int Mterminals_P_convert_TERMINAL_TERMINALNR,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_get_TERMINALNR_TERMINAL,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_error_terminal_TERMINALNR,(value P0));
_PROTOTYPE(extern int Mbitmap_P_new_BITMAP,(value *P0));
_PROTOTYPE(extern int Mbitmap_P_new_INT_BITMAP,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_INT_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_exclude_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_or_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_and_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_equal_BITMAP_BITMAP,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_set_BITMAP_INT,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_empty_BITMAP,(value P0));
_PROTOTYPE(extern int Mbitmap_P_clear_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_set_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_write_BITMAP,(value P0));

/*
** CODE
*/

int Mrecursion_P_remove_right_recursion()
{
  value L0;
  L0 = G_recursion_TEXT_NR2896;
  Merrors_P_status_message_TEXT(L0);
  return 1;
}

int Mrecursion_P_remove_right_recursion_RULENR_LOCATION(P0,P1)
value P0;
value P1;
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  if (!Minline_P_is_recursive_RULENR(L0)) goto LAB1;
  Mcode_P_get_LOCATION_INSTRUCTION(L1,&L2);
  switch (Alternative(L2)) {
  case 4: goto LAB2;
  default: goto LAB3;
  };
LAB2:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  Mcode_P_next_LOCATION_LOCATION(L1,&L6);
  Mcode_P_get_LOCATION_INSTRUCTION(L6,&L7);
  switch (Alternative(L7)) {
  case 35: goto LAB5;
  default: goto LAB6;
  };
LAB5:
  L8 = (value)(L7[1]);
  L9 = (value)(L7[2]);
  L10 = (value)(L7[3]);
  G_recursion_CUR_FRAMESIZE_NR4 = (long)L4;
  Mrecursion_P_search_tail_recursion_LOCATION_RULENR_ENTRY_PARAMETER_MAP_LOCATION(L10,L3,L10,L8,&L11);
if(DecrRefs(L7)<0)
XD_Mcode_T14(L7);
  Create(&L12,4,3);
  *(value *)(L12+1) = L3;
  L13 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  *(value *)(L12+2) = L13;
  *(value *)(L12+3) = L5;
if(DecrRefs(L2)<0)
XD_Mcode_T14(L2);
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L1,L12);
if(DecrRefs(L12)<0)
XD_Mcode_T14(L12);
  return 1;
LAB3:
if(DecrRefs(L2)<0)
XD_Mcode_T14(L2);
  return 1;
LAB6:
if(DecrRefs(L7)<0)
XD_Mcode_T14(L7);
if(DecrRefs(L2)<0)
XD_Mcode_T14(L2);
  return 1;
LAB1:
  return 1;
}

int Mrecursion_P_init()
{
  value L2;
  value L1;
  value L0;
  L0 = C_INT(0);
  G_recursion_REM_REC_NR0 = (long)L0;
  L1 = C_INT(0);
  G_recursion_REM_FUN_NR1 = (long)L1;
  L2 = C_INT(0);
  G_recursion_XCOUNT_NR3 = (long)L2;
  return 1;
}

int Mrecursion_P_exit()
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = G_recursion_TEXT_NR2897;
  Merrors_P_error_text_TEXT(L0);
  L1 = (value)G_recursion_REM_REC_NR0;
  Merrors_P_error_int_INT(L1);
  L2 = G_recursion_TEXT_NR2898;
  Merrors_P_error_text_TEXT(L2);
  L3 = (value)G_recursion_REM_FUN_NR1;
  Merrors_P_error_int_INT(L3);
  L4 = G_recursion_TEXT_NR2899;
  Merrors_P_error_text_TEXT(L4);
  L5 = G_recursion_TEXT_NR2900;
  Merrors_P_error_text_TEXT(L5);
  L6 = (value)G_recursion_XCOUNT_NR3;
  Merrors_P_error_int_INT(L6);
  L7 = G_recursion_TEXT_NR2901;
  Merrors_P_error_text_TEXT(L7);
  return 1;
}

int Mrecursion_P_remove_right_recursion_HEADER(P0)
value P0;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  if (!Mcode_P_is_end_LOCATION(L0)) goto LAB9;
  return 1;
LAB9:
  Mcode_P_get_LOCATION_INSTRUCTION(L0,&L1);
  switch (Alternative(L1)) {
  case 4: goto LAB10;
  default: goto LAB11;
  };
LAB10:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  L4 = (value)(L1[3]);
  Mrecursion_P_remove_right_recursion_HEADER_RULENR_LOCATION(L0,L2,&L5);
if(DecrRefs(L1)<0)
XD_Mcode_T14(L1);
  L6 = L5;
  if (!Mcode_P_next_LOCATION(&L6)) goto LAB13;
  Mrecursion_P_remove_right_recursion_HEADER(L6);
  return 1;
LAB11:
if(DecrRefs(L1)<0)
XD_Mcode_T14(L1);
LAB12:
  L7 = L0;
  if (!Mcode_P_next_LOCATION(&L7)) goto LAB15;
  Mrecursion_P_remove_right_recursion_HEADER(L7);
  return 1;
LAB13:
  return 1;
  return 1;
LAB15:
  return 1;
  return 1;
}

int Mrecursion_P_remove_right_recursion_HEADER_RULENR_LOCATION(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  if (!Minline_P_is_recursive_RULENR(L1)) goto LAB18;
  L2 = L0;
  if (!Mcode_P_next_LOCATION(&L2)) goto LAB19;
  Mcode_P_get_LOCATION_INSTRUCTION(L2,&L3);
  switch (Alternative(L3)) {
  case 35: goto LAB21;
  default: goto LAB22;
  };
LAB21:
  L4 = (value)(L3[1]);
  L5 = (value)(L3[2]);
  L6 = (value)(L3[3]);
  L7 = G_recursion_TEXT_NR2902;
  Mrecursion_P_debug_TEXT_RULENR(L7,L1);
  Mrecursion_P_search_tail_recursion_LOCATION_RULENR_ENTRY_PARAMETER_MAP_LOCATION(L6,L1,L6,L4,&L8);
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  L9 = G_recursion_TEXT_NR2903;
  Mrecursion_P_debug_TEXT_RULENR(L9,L1);
  *P2 = L8;
  return 1;
LAB19:
LAB18:
  Mrecursion_P_find_next_rule_LOCATION_LOCATION(L0,&L10);
  *P2 = L10;
  return 1;
LAB22:
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  Abort(89, module_name);
  Abort(89, module_name);
}

int Mrecursion_P_debug_TEXT_RULENR(P0,P1)
value P0;
value P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = G_recursion_TEXT_NR2904;
  if (!E82_get_from_environment_TEXT_TEXT(L2,&L3)) goto LAB25;
  if (!E61_decbin_TEXT_INT(L3,&L4)) goto LAB26;
D_TEXT(L3);
  if (!(L4 == L1)) goto LAB25;
  L5 = C_INT(1);
  Mcode_P_dump_code_MODULENR_TEXT(L5,L0);
  return 1;
LAB26:
D_TEXT(L3);
  return 1;
LAB25:
  return 1;
}

int Mrecursion_P_search_tail_recursion_LOCATION_RULENR_ENTRY_PARAMETER_MAP_LOCATION(P0,P1,P2,P3,P4)
value P0;
value P1;
value P2;
value P3;
value *P4;
{
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
LAB563:
  Mcode_P_get_LOCATION_INSTRUCTION(L0,&L4);
  switch (Alternative(L4)) {
  case 5: goto LAB30;
  case 11: goto LAB33;
  case 10: goto LAB40;
  default: goto LAB42;
  };
LAB30:
if(DecrRefs(L4)<0)
XD_Mcode_T14(L4);
  *P4 = L0;
  return 1;
LAB33:
  L5 = (value)(L4[1]);
  L6 = (value)(L4[2]);
  if (!(L1 == L5)) goto LAB42;
  if (!Mrecursion_P_is_tail_recursion_LOCATION_MAPLIST_LOCATION_ADDRESSES(L0,&L7,&L8,L6)) goto LAB42;
  Mrecursion_P_remove_first_recursion_LOCATION_ENTRY_RULENR_ADDRESSES_MAPLIST_PARAMETER_MAP_LABEL(L8,L2,L1,L6,L7,L3,&L9);
if(DecrRefs(L7)<0)
XD_Mrecursion_T17(L7);
if(DecrRefs(L4)<0)
XD_Mcode_T14(L4);
  Mcode_P_delete_LOCATION(L0);
  Mrecursion_P_search_next_tail_recursion_LOCATION_RULENR_PARAMETER_MAP_LABEL_LOCATION(L8,L1,L3,L9,&L10);
  *P4 = L10;
  return 1;
LAB40:
  L11 = (value)(L4[1]);
  L12 = (value)(L4[2]);
  L13 = (value)(L4[3]);
  if (!(L1 == L11)) goto LAB42;
  if (!Mrecursion_P_expect_failure_LABEL(L13)) goto LAB42;
  if (!Mrecursion_P_is_tail_recursion_LOCATION_MAPLIST_LOCATION_ADDRESSES(L0,&L14,&L15,L12)) goto LAB42;
  Mrecursion_P_remove_first_recursion_LOCATION_ENTRY_RULENR_ADDRESSES_MAPLIST_PARAMETER_MAP_LABEL(L15,L2,L1,L12,L14,L3,&L16);
if(DecrRefs(L14)<0)
XD_Mrecursion_T17(L14);
  Mcode_P_remove_goto_LABEL_LOCATION(L13,L0);
if(DecrRefs(L4)<0)
XD_Mcode_T14(L4);
  Mcode_P_delete_LOCATION(L0);
  Mrecursion_P_search_next_tail_recursion_LOCATION_RULENR_PARAMETER_MAP_LABEL_LOCATION(L15,L1,L3,L16,&L17);
  *P4 = L17;
  return 1;
LAB42:
if(DecrRefs(L4)<0)
XD_Mcode_T14(L4);
  L18 = L0;
  if (!Mcode_P_next_LOCATION(&L18)) goto LAB49;
  L0 = L18;
  goto LAB563;
LAB49:
  Abort(128, module_name);
  Abort(128, module_name);
}

int Mrecursion_P_search_next_tail_recursion_LOCATION_RULENR_PARAMETER_MAP_LABEL_LOCATION(P0,P1,P2,P3,P4)
value P0;
value P1;
value P2;
value P3;
value *P4;
{
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
LAB562:
  Mcode_P_get_LOCATION_INSTRUCTION(L0,&L4);
  switch (Alternative(L4)) {
  case 5: goto LAB51;
  case 11: goto LAB54;
  case 10: goto LAB61;
  default: goto LAB63;
  };
LAB51:
if(DecrRefs(L4)<0)
XD_Mcode_T14(L4);
  *P4 = L0;
  return 1;
LAB54:
  L5 = (value)(L4[1]);
  L6 = (value)(L4[2]);
  if (!(L1 == L5)) goto LAB63;
  if (!Mrecursion_P_is_tail_recursion_LOCATION_MAPLIST_LOCATION_ADDRESSES(L0,&L7,&L8,L6)) goto LAB63;
  Mrecursion_P_remove_recursive_call_LOCATION_RULENR_ADDRESSES_MAPLIST_PARAMETER_MAP_LABEL(L8,L1,L6,L7,L2,L3);
if(DecrRefs(L7)<0)
XD_Mrecursion_T17(L7);
if(DecrRefs(L4)<0)
XD_Mcode_T14(L4);
  Mcode_P_delete_LOCATION(L0);
  L0 = L8;
  goto LAB562;
LAB61:
  L10 = (value)(L4[1]);
  L11 = (value)(L4[2]);
  L12 = (value)(L4[3]);
  if (!(L1 == L10)) goto LAB63;
  if (!Mrecursion_P_expect_failure_LABEL(L12)) goto LAB63;
  if (!Mrecursion_P_is_tail_recursion_LOCATION_MAPLIST_LOCATION_ADDRESSES(L0,&L13,&L14,L11)) goto LAB63;
  Mrecursion_P_remove_recursive_call_LOCATION_RULENR_ADDRESSES_MAPLIST_PARAMETER_MAP_LABEL(L14,L1,L11,L13,L2,L3);
if(DecrRefs(L13)<0)
XD_Mrecursion_T17(L13);
  Mcode_P_remove_goto_LABEL_LOCATION(L12,L0);
if(DecrRefs(L4)<0)
XD_Mcode_T14(L4);
  Mcode_P_delete_LOCATION(L0);
  L0 = L14;
  goto LAB562;
LAB63:
if(DecrRefs(L4)<0)
XD_Mcode_T14(L4);
  L16 = L0;
  if (!Mcode_P_next_LOCATION(&L16)) goto LAB70;
  L0 = L16;
  goto LAB562;
LAB70:
  Abort(156, module_name);
  Abort(156, module_name);
}

int Mrecursion_P_is_tail_recursion_LOCATION_MAPLIST_LOCATION_ADDRESSES(P0,P1,P2,P3)
value P0;
value *P1;
value *P2;
value P3;
{
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P3;
LAB385:
  L2 = L0;
  if (!Mcode_P_next_LOCATION(&L2)) goto LAB72;
  Mcode_P_get_LOCATION_INSTRUCTION(L2,&L3);
  switch (Alternative(L3)) {
  case 15: goto LAB74;
  case 1: goto LAB77;
  case 12: goto LAB82;
  case 32: goto LAB87;
  case 33: goto LAB92;
  case 27: goto LAB97;
  case 28: goto LAB107;
  default: goto LAB109;
  };
LAB74:
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  L4 = G_recursion_MAPLIST_NR2905;
  *P2 = L2;
  *P1 = L4;
  ATTACH(L4);
  return 1;
LAB72:
  return 0;
LAB77:
  L5 = (value)(L3[1]);
  if (!Mrecursion_P_is_tail_recursion_LOCATION_MAPLIST_LOCATION_ADDRESSES(L2,&L6,&L7,L1)) goto LAB109;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  L8 = G_recursion_INSTRUCTION_NR2906;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L2,L8);
  Mcode_P_prev_LOCATION_LOCATION(L2,&L9);
  *P2 = L9;
  *P1 = L6;
  return 1;
LAB82:
  L10 = (value)(L3[1]);
  Mcode_P_get_label_LABEL_LOCATION(L10,&L11);
  if (!Mrecursion_P_is_tail_recursion_LOCATION_MAPLIST_LOCATION_ADDRESSES(L11,&L12,&L13,L1)) goto LAB85;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  *P2 = L2;
  *P1 = L12;
  return 1;
LAB85:
LAB109:
  if (!Mcode_P_no_effect_INSTRUCTION(L3)) goto LAB117;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  L0 = L2;
  goto LAB385;
LAB87:
  L14 = (value)(L3[1]);
  L15 = (value)(L3[2]);
  if (!Mrecursion_P_is_tail_recursion_LOCATION_MAPLIST_LOCATION_ADDRESSES(L2,&L16,&L17,L1)) goto LAB109;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  *P2 = L17;
  *P1 = L16;
  return 1;
LAB92:
  L18 = (value)(L3[1]);
  L19 = (value)(L3[2]);
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  L20 = G_recursion_INSTRUCTION_NR2907;
  if (!Mrecursion_P_detach_is_tail_recursion_LOCATION_INSTRUCTION(L2,L20)) goto LAB96;
  L37 = (value)G_recursion_XCOUNT_NR3;
  L38 = C_INT(1);
  L39 = C_INT(Int(L37) + Int(L38));
  G_recursion_XCOUNT_NR3 = (long)L39;
  return 0;
  return 0;
LAB96:
  return 0;
LAB97:
  L21 = (value)(L3[1]);
  L22 = (value)(L3[2]);
  L23 = (value)(L3[3]);
  switch (Alternative(L23)) {
  case 4: goto LAB100;
  default: goto LAB109;
  };
LAB100:
  L24 = (value)(L23[1]);
  if (!Mrecursion_P_is_tail_recursion_LOCATION_MAPLIST_LOCATION_ADDRESSES(L2,&L25,&L26,L1)) goto LAB109;
  L40 = L21;
  L41 = L1;
LAB362:
  switch (Alternative(L41)) {
  case 2: goto LAB106;
  case 0: goto LAB366;
  default: goto LAB369;
  };
LAB366:
  L42 = (value)(L41[1]);
  L43 = (value)(L41[2]);
  if (!EQ_Mcode_T20(L42,L40)) goto LAB370;
LAB361:
  Mcode_P_delete_LOCATION(L2);
  Create(&L27,0,4);
  *(value *)(L27+1) = L21;
  ATTACH(L21);
  *(value *)(L27+2) = L24;
  *(value *)(L27+3) = L22;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  *(value *)(L27+4) = L25;
  *P2 = L26;
  *P1 = L27;
  return 1;
LAB370:
  L41 = L43;
  goto LAB362;
LAB369:
  Abort(208, module_name);
LAB106:
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  *P2 = L26;
  *P1 = L25;
  return 1;
LAB107:
  L28 = (value)(L3[1]);
  L29 = (value)(L3[2]);
  switch (Alternative(L29)) {
  case 4: goto LAB110;
  default: goto LAB109;
  };
LAB110:
  L30 = (value)(L29[1]);
  if (!Mrecursion_P_is_tail_recursion_LOCATION_MAPLIST_LOCATION_ADDRESSES(L2,&L31,&L32,L1)) goto LAB109;
  L44 = L28;
  L45 = L1;
LAB374:
  switch (Alternative(L45)) {
  case 2: goto LAB116;
  case 0: goto LAB378;
  default: goto LAB381;
  };
LAB378:
  L46 = (value)(L45[1]);
  L47 = (value)(L45[2]);
  if (!EQ_Mcode_T20(L46,L44)) goto LAB382;
LAB373:
  Mcode_P_delete_LOCATION(L2);
  Create(&L33,0,4);
  *(value *)(L33+1) = L28;
  ATTACH(L28);
  *(value *)(L33+2) = L30;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  L34 = C_INT(1);
  *(value *)(L33+3) = L34;
  *(value *)(L33+4) = L31;
  *P2 = L32;
  *P1 = L33;
  return 1;
LAB382:
  L45 = L47;
  goto LAB374;
LAB381:
  Abort(208, module_name);
LAB116:
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  *P2 = L32;
  *P1 = L31;
  return 1;
LAB117:
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  return 0;
  return 0;
  return 0;
}

int Mrecursion_P_is_a_parameter_ADDRESS_ADDRESSES(P0,P1)
value P0;
value P1;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB360:
  switch (Alternative(L1)) {
  case 2: goto LAB121;
  case 0: goto LAB124;
  default: goto LAB126;
  };
LAB121:
  return 0;
LAB124:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  if (!EQ_Mcode_T20(L2,L0)) goto LAB128;
  return 1;
LAB128:
  L1 = L3;
  goto LAB360;
  return 0;
LAB126:
  Abort(208, module_name);
}

int Mrecursion_P_detach_is_tail_recursion_LOCATION_INSTRUCTION(P0,P1)
value P0;
value P1;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB358:
  L2 = L0;
  if (!Mcode_P_next_LOCATION(&L2)) goto LAB131;
  Mcode_P_get_LOCATION_INSTRUCTION(L2,&L3);
  if (!EQ_Mcode_T14(L3,L1)) goto LAB134;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  return 1;
LAB131:
  return 0;
LAB134:
  switch (Alternative(L3)) {
  case 12: goto LAB135;
  case 32: goto LAB140;
  case 33: goto LAB145;
  case 27: goto LAB150;
  case 28: goto LAB158;
  default: goto LAB160;
  };
LAB135:
  L4 = (value)(L3[1]);
  Mcode_P_get_label_LABEL_LOCATION(L4,&L5);
  if (!Mrecursion_P_detach_is_tail_recursion_LOCATION_INSTRUCTION(L5,L1)) goto LAB138;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  return 1;
LAB138:
LAB160:
  if (!Mcode_P_no_effect_INSTRUCTION(L3)) goto LAB166;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  L0 = L2;
  goto LAB358;
LAB140:
  L6 = (value)(L3[1]);
  L7 = (value)(L3[2]);
  if (!Mrecursion_P_detach_is_tail_recursion_LOCATION_INSTRUCTION(L2,L1)) goto LAB160;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  return 1;
LAB145:
  L8 = (value)(L3[1]);
  L9 = (value)(L3[2]);
  if (!Mrecursion_P_detach_is_tail_recursion_LOCATION_INSTRUCTION(L2,L1)) goto LAB160;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  return 1;
LAB150:
  L10 = (value)(L3[1]);
  L11 = (value)(L3[2]);
  L12 = (value)(L3[3]);
  switch (Alternative(L12)) {
  case 4: goto LAB153;
  default: goto LAB160;
  };
LAB153:
  L13 = (value)(L12[1]);
  if (!Mrecursion_P_detach_is_tail_recursion_LOCATION_INSTRUCTION(L2,L1)) goto LAB160;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  return 1;
LAB158:
  L14 = (value)(L3[1]);
  L15 = (value)(L3[2]);
  switch (Alternative(L15)) {
  case 4: goto LAB161;
  default: goto LAB160;
  };
LAB161:
  L16 = (value)(L15[1]);
  if (!Mrecursion_P_detach_is_tail_recursion_LOCATION_INSTRUCTION(L2,L1)) goto LAB160;
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  return 1;
LAB166:
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  return 0;
  return 0;
  return 0;
}

int Mrecursion_P_remove_first_recursion_LOCATION_ENTRY_RULENR_ADDRESSES_MAPLIST_PARAMETER_MAP_LABEL(P0,P1,P2,P3,P4,P5,P6)
value P0;
value P1;
value P2;
value P3;
value P4;
value P5;
value *P6;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L4 = P4;
  L5 = P5;
  Mcode_P_new_LABEL(&L6);
  Create(&L7,1,1);
  *(value *)(L7+1) = L6;
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L1,L7);
if(DecrRefs(L7)<0)
XD_Mcode_T14(L7);
  Mcode_P_register_label_LABEL_LOCATION(L6,L1);
  Mrecursion_P_remove_recursive_call_LOCATION_RULENR_ADDRESSES_MAPLIST_PARAMETER_MAP_LABEL(L0,L2,L3,L4,L5,L6);
  L8 = (value)G_recursion_REM_FUN_NR1;
  L9 = C_INT(1);
  L10 = C_INT(Int(L8) + Int(L9));
  G_recursion_REM_FUN_NR1 = (long)L10;
  *P6 = L6;
  return 1;
}

int Mrecursion_P_remove_recursive_call_LOCATION_RULENR_ADDRESSES_MAPLIST_PARAMETER_MAP_LABEL(P0,P1,P2,P3,P4,P5)
value P0;
value P1;
value P2;
value P3;
value P4;
value P5;
{
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L4 = P4;
  L5 = P5;
  Mrules_P_get_RULENR_PARAMETERS(L1,&L6);
  L10 = L0;
  L11 = L2;
  L12 = L6;
  L13 = L4;
  L14 = L3;
  L15 = L5;
  L20 = L10;
  L21 = L11;
  L22 = L12;
  L23 = L13;
  L24 = L14;
  L28 = L21;
  L29 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  L32 = L29;
LAB543:
  switch (Int(L32)) {
  case 0: goto LAB546;
  default: goto LAB547;
  };
LAB547:
  L33 = G_recursion_FRAME_FROM_NR2908;
  L34 = C_INT(1);
  L35 = C_INT(Int(L32) - Int(L34));
  L36 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L35));
  ATTACH(L33);
if(DecrRefs(*((value*)L36))<0)
XD_Mrecursion_T6(*((value*)L36));
  *((value *)L36) = L33;
  L37 = C_INT(0);
  L38 = C_INT(1);
  L39 = C_INT(Int(L32) - Int(L38));
  L40 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L39));
  *((value *)L40) = L37;
  L41 = C_INT(1);
  L42 = C_INT(Int(L32) - Int(L41));
  L32 = L42;
  goto LAB543;
LAB546:
  L30 = C_INT(0);
  L43 = L30;
  L44 = L28;
LAB548:
  switch (Alternative(L44)) {
  case 2: goto LAB549;
  case 0: goto LAB553;
  default: goto LAB555;
  };
LAB549:
  L31 = L43;
LAB551:
  L25 = L31;
LAB556:
  L26 = C_INT(0);
  Mrecursion_P_generate_mapping_ADDRESSES_PARAMETERS_PARAMETER_MAP_MAPLIST_INT(L21,L22,L23,L24,L26);
  L27 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  Mrecursion_P_copy_parameters_FRAMESIZE_INT_LOCATION(L27,L25,L20);
LAB557:
  Mcode_P_get_LOCATION_INSTRUCTION(L10,&L16);
  switch (Alternative(L16)) {
  case 12: goto LAB558;
  default: goto LAB559;
  };
LAB553:
  L45 = (value)(L44[1]);
  L46 = (value)(L44[2]);
  L47 = G_recursion_PAR_FROM_NR2909;
  L48 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L43));
  ATTACH(L47);
if(DecrRefs(*((value*)L48))<0)
XD_Mrecursion_T7(*((value*)L48));
  *((value *)L48) = L47;
  L49 = C_INT(0);
  L50 = (value) Addr((value*)&G_recursion_PAR_COUNT_NR8,Int(L43));
  *((value *)L50) = L49;
  L51 = C_INT(1);
  L52 = C_INT(Int(L43) + Int(L51));
  L44 = L46;
  L43 = L52;
  goto LAB548;
LAB555:
  Abort(390, module_name);
LAB558:
  L17 = (value)(L16[1]);
  Mcode_P_remove_goto_LABEL_LOCATION(L17,L10);
if(DecrRefs(L16)<0)
XD_Mcode_T14(L16);
  Create(&L18,12,1);
  *(value *)(L18+1) = L15;
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L10,L18);
if(DecrRefs(L18)<0)
XD_Mcode_T14(L18);
  Mcode_P_register_goto_LABEL_LOCATION(L15,L10);
  goto LAB542;
LAB559:
if(DecrRefs(L16)<0)
XD_Mcode_T14(L16);
LAB560:
  Create(&L19,12,1);
  *(value *)(L19+1) = L15;
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L10,L19);
if(DecrRefs(L19)<0)
XD_Mcode_T14(L19);
  Mcode_P_register_goto_LABEL_LOCATION(L15,L10);
LAB542:
if(DecrRefs(L6)<0)
XD_Mrules_T21(L6);
  L7 = (value)G_recursion_REM_REC_NR0;
  L8 = C_INT(1);
  L9 = C_INT(Int(L7) + Int(L8));
  G_recursion_REM_REC_NR0 = (long)L9;
  return 1;
}

int Mrecursion_P_copy_parameters_FRAMESIZE_INT_LOCATION(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB526:
  L3 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  L11 = L3;
  L12 = L1;
  L13 = L2;
  L14 = C_INT(1);
  L15 = C_INT(Int(L11) - Int(L14));
  Mrecursion_P_generate_input_copies_INT_LOCATION(L15,L13);
  L16 = C_INT(1);
  L17 = C_INT(Int(L12) - Int(L16));
  Mrecursion_P_generate_output_copies_INT_LOCATION(L17,L13);
LAB519:
  L4 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  L5 = C_INT(1);
  L6 = C_INT(Int(L4) - Int(L5));
  if (!Mrecursion_P_input_recursion_INT_LOCATION(L6,L2)) goto LAB174;
  L7 = C_INT(1);
  L8 = C_INT(Int(L1) - Int(L7));
  if (!Mrecursion_P_output_recursion_INT_LOCATION(L8,L2)) goto LAB526;
  goto LAB526;
LAB174:
  L9 = C_INT(1);
  L10 = C_INT(Int(L1) - Int(L9));
  if (!Mrecursion_P_output_recursion_INT_LOCATION(L10,L2)) goto LAB178;
  goto LAB526;
LAB178:
  return 1;
}

int Mrecursion_P_generate_mapping_ADDRESSES_PARAMETERS_PARAMETER_MAP_MAPLIST_INT(P0,P1,P2,P3,P4)
value P0;
value P1;
value P2;
value P3;
value P4;
{
  value L128;
  value L127;
  value L126;
  value L125;
  value L124;
  value L123;
  value L122;
  value L121;
  value L120;
  value L119;
  value L118;
  value L117;
  value L116;
  value L115;
  value L114;
  value L113;
  value L112;
  value L111;
  value L110;
  value L109;
  value L108;
  value L107;
  value L106;
  value L105;
  value L104;
  value L103;
  value L102;
  value L101;
  value L100;
  value L99;
  value L98;
  value L97;
  value L96;
  value L95;
  value L94;
  value L93;
  value L92;
  value L91;
  value L90;
  value L89;
  value L88;
  value L87;
  value L86;
  value L85;
  value L84;
  value L83;
  value L82;
  value L81;
  value L80;
  value L79;
  value L78;
  value L77;
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L4 = P4;
  switch (Alternative(L1)) {
  case 2: goto LAB179;
  case 0: goto LAB185;
  default: goto LAB187;
  };
LAB179:
  switch (Alternative(L0)) {
  case 2: goto LAB182;
  default: goto LAB187;
  };
LAB182:
  return 1;
LAB185:
  L5 = (value)(L1[1]);
  L6 = (value)(L1[2]);
  L7 = (value)(L1[3]);
  L8 = (value)(L1[4]);
  switch (Alternative(L0)) {
  case 0: goto LAB188;
  default: goto LAB187;
  };
LAB188:
  L9 = (value)(L0[1]);
  L10 = (value)(L0[2]);
  switch (Alternative(L5)) {
  case 0: goto LAB191;
  case 1: goto LAB194;
  case 2: goto LAB199;
  default: goto LAB201;
  };
LAB191:
  L11 = C_INT(1);
  L12 = C_INT(Int(L4) + Int(L11));
  Mrecursion_P_generate_mapping_ADDRESSES_PARAMETERS_PARAMETER_MAP_MAPLIST_INT(L10,L8,L2,L3,L12);
  L23 = L4;
  L24 = L2;
LAB417:
  switch (Alternative(L24)) {
  case 2: goto LAB418;
  case 0: goto LAB421;
  case 1: goto LAB426;
  default: goto LAB429;
  };
LAB418:
  Abort(317, module_name);
LAB421:
  L25 = (value)(L24[1]);
  L26 = (value)(L24[2]);
  L27 = (value)(L24[3]);
  if (!(L23 == L25)) goto LAB425;
  Create(&L28,2,1);
  *(value *)(L28+1) = L26;
  L13 = L28;
  goto LAB416;
LAB425:
  L24 = L27;
  goto LAB417;
LAB426:
  L30 = (value)(L24[1]);
  L31 = (value)(L24[2]);
  L32 = (value)(L24[3]);
  if (!(L23 == L30)) goto LAB430;
  Create(&L33,2,1);
  *(value *)(L33+1) = L31;
  L13 = L33;
LAB416:
  L35 = L9;
  L36 = L13;
  L37 = L6;
  if (!EQ_Mcode_T20(L35,L36)) goto LAB433;
  goto LAB431;
LAB430:
  L24 = L32;
  goto LAB417;
LAB429:
  Abort(326, module_name);
LAB433:
  switch (Alternative(L36)) {
  case 2: goto LAB434;
  default: goto LAB440;
  };
LAB434:
  L38 = (value)(L36[1]);
  switch (Alternative(L35)) {
  case 2: goto LAB436;
  default: goto LAB440;
  };
LAB436:
  L39 = (value)(L35[1]);
  L40 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L38));
  L41 = *((value*)L40);
  ATTACH(L41);
  switch (Alternative(L41)) {
  case 1: goto LAB438;
  default: goto LAB439;
  };
LAB438:
if(DecrRefs(L41)<0)
XD_Mrecursion_T6(L41);
  L42 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L39));
  L43 = *((value*)L42);
  L44 = C_INT(1);
  L45 = C_INT(Int(L43) + Int(L44));
  *((value *)L42) = L45;
  Create(&L46,0,2);
  *(value *)(L46+1) = L39;
  *(value *)(L46+2) = L37;
if(DecrRefs(*((value*)L40))<0)
XD_Mrecursion_T6(*((value*)L40));
  *((value *)L40) = L46;
LAB431:
if(DecrRefs(L13)<0)
XD_Mcode_T20(L13);
  return 1;
LAB439:
if(DecrRefs(L41)<0)
XD_Mrecursion_T6(L41);
  Abort(411, module_name);
  Abort(411, module_name);
LAB440:
  Abort(412, module_name);
LAB194:
  L14 = C_INT(1);
  L15 = C_INT(Int(L4) + Int(L14));
  Mrecursion_P_generate_mapping_ADDRESSES_PARAMETERS_PARAMETER_MAP_MAPLIST_INT(L10,L8,L2,L3,L15);
  L47 = L9;
  L48 = L3;
LAB445:
  switch (Alternative(L48)) {
  case 1: goto LAB198;
  case 0: goto LAB449;
  default: goto LAB452;
  };
LAB449:
  L49 = (value)(L48[1]);
  L50 = (value)(L48[2]);
  L51 = (value)(L48[3]);
  L52 = (value)(L48[4]);
  if (!EQ_Mcode_T20(L47,L49)) goto LAB453;
  L16 = L50;
LAB444:
  L54 = L16;
  L55 = L4;
  if (!(L54 == L55)) goto LAB458;
  return 1;
LAB453:
  L48 = L52;
  goto LAB445;
LAB452:
  Abort(336, module_name);
LAB458:
  L56 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L55));
  L57 = *((value*)L56);
  ATTACH(L57);
  switch (Alternative(L57)) {
  case 2: goto LAB459;
  default: goto LAB460;
  };
LAB459:
if(DecrRefs(L57)<0)
XD_Mrecursion_T7(L57);
  L58 = (value) Addr((value*)&G_recursion_PAR_COUNT_NR8,Int(L54));
  L59 = *((value*)L58);
  L60 = C_INT(1);
  L61 = C_INT(Int(L59) + Int(L60));
  *((value *)L58) = L61;
  Create(&L62,0,1);
  *(value *)(L62+1) = L54;
if(DecrRefs(*((value*)L56))<0)
XD_Mrecursion_T7(*((value*)L56));
  *((value *)L56) = L62;
  return 1;
LAB460:
if(DecrRefs(L57)<0)
XD_Mrecursion_T7(L57);
  Abort(397, module_name);
  Abort(397, module_name);
  return 1;
LAB198:
  L63 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  L64 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  L65 = C_INT(1);
  L66 = C_INT(Int(L64) + Int(L65));
  G_recursion_CUR_FRAMESIZE_NR4 = (long)L66;
  L67 = G_recursion_FRAME_FROM_NR2913;
  L68 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L63));
  ATTACH(L67);
if(DecrRefs(*((value*)L68))<0)
XD_Mrecursion_T6(*((value*)L68));
  *((value *)L68) = L67;
  L69 = C_INT(0);
  L70 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L63));
  *((value *)L70) = L69;
  L17 = L63;
LAB462:
  L71 = L17;
  L72 = L4;
  L73 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L72));
  L74 = *((value*)L73);
  ATTACH(L74);
  switch (Alternative(L74)) {
  case 2: goto LAB464;
  default: goto LAB465;
  };
LAB464:
if(DecrRefs(L74)<0)
XD_Mrecursion_T7(L74);
  Create(&L75,1,1);
  *(value *)(L75+1) = L71;
if(DecrRefs(*((value*)L73))<0)
XD_Mrecursion_T7(*((value*)L73));
  *((value *)L73) = L75;
  return 1;
LAB465:
if(DecrRefs(L74)<0)
XD_Mrecursion_T7(L74);
  Abort(402, module_name);
  Abort(402, module_name);
  return 1;
LAB199:
  L18 = C_INT(1);
  L19 = C_INT(Int(L4) + Int(L18));
  Mrecursion_P_generate_mapping_ADDRESSES_PARAMETERS_PARAMETER_MAP_MAPLIST_INT(L10,L8,L2,L3,L19);
  L76 = L4;
  L77 = L2;
LAB468:
  switch (Alternative(L77)) {
  case 2: goto LAB469;
  case 0: goto LAB472;
  case 1: goto LAB477;
  default: goto LAB480;
  };
LAB469:
  Abort(317, module_name);
LAB472:
  L78 = (value)(L77[1]);
  L79 = (value)(L77[2]);
  L80 = (value)(L77[3]);
  if (!(L76 == L78)) goto LAB476;
  Create(&L81,2,1);
  *(value *)(L81+1) = L79;
  L20 = L81;
  goto LAB467;
LAB476:
  L77 = L80;
  goto LAB468;
LAB477:
  L83 = (value)(L77[1]);
  L84 = (value)(L77[2]);
  L85 = (value)(L77[3]);
  if (!(L76 == L83)) goto LAB481;
  Create(&L86,2,1);
  *(value *)(L86+1) = L84;
  L20 = L86;
LAB467:
  L88 = L9;
  L89 = L20;
  L90 = L6;
  if (!EQ_Mcode_T20(L88,L89)) goto LAB484;
  goto LAB482;
LAB481:
  L77 = L85;
  goto LAB468;
LAB480:
  Abort(326, module_name);
LAB484:
  switch (Alternative(L89)) {
  case 2: goto LAB485;
  default: goto LAB491;
  };
LAB485:
  L91 = (value)(L89[1]);
  switch (Alternative(L88)) {
  case 2: goto LAB487;
  default: goto LAB491;
  };
LAB487:
  L92 = (value)(L88[1]);
  L93 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L91));
  L94 = *((value*)L93);
  ATTACH(L94);
  switch (Alternative(L94)) {
  case 1: goto LAB489;
  default: goto LAB490;
  };
LAB489:
if(DecrRefs(L94)<0)
XD_Mrecursion_T6(L94);
  L95 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L92));
  L96 = *((value*)L95);
  L97 = C_INT(1);
  L98 = C_INT(Int(L96) + Int(L97));
  *((value *)L95) = L98;
  Create(&L99,0,2);
  *(value *)(L99+1) = L92;
  *(value *)(L99+2) = L90;
if(DecrRefs(*((value*)L93))<0)
XD_Mrecursion_T6(*((value*)L93));
  *((value *)L93) = L99;
LAB482:
if(DecrRefs(L20)<0)
XD_Mcode_T20(L20);
  L100 = L9;
  L101 = L3;
LAB495:
  switch (Alternative(L101)) {
  case 1: goto LAB203;
  case 0: goto LAB499;
  default: goto LAB502;
  };
LAB490:
if(DecrRefs(L94)<0)
XD_Mrecursion_T6(L94);
  Abort(411, module_name);
  Abort(411, module_name);
LAB491:
  Abort(412, module_name);
LAB499:
  L102 = (value)(L101[1]);
  L103 = (value)(L101[2]);
  L104 = (value)(L101[3]);
  L105 = (value)(L101[4]);
  if (!EQ_Mcode_T20(L100,L102)) goto LAB503;
  L21 = L103;
LAB494:
  L107 = L21;
  L108 = L4;
  if (!(L107 == L108)) goto LAB508;
  return 1;
LAB503:
  L101 = L105;
  goto LAB495;
LAB502:
  Abort(336, module_name);
LAB508:
  L109 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L108));
  L110 = *((value*)L109);
  ATTACH(L110);
  switch (Alternative(L110)) {
  case 2: goto LAB509;
  default: goto LAB510;
  };
LAB509:
if(DecrRefs(L110)<0)
XD_Mrecursion_T7(L110);
  L111 = (value) Addr((value*)&G_recursion_PAR_COUNT_NR8,Int(L107));
  L112 = *((value*)L111);
  L113 = C_INT(1);
  L114 = C_INT(Int(L112) + Int(L113));
  *((value *)L111) = L114;
  Create(&L115,0,1);
  *(value *)(L115+1) = L107;
if(DecrRefs(*((value*)L109))<0)
XD_Mrecursion_T7(*((value*)L109));
  *((value *)L109) = L115;
  return 1;
LAB510:
if(DecrRefs(L110)<0)
XD_Mrecursion_T7(L110);
  Abort(397, module_name);
  Abort(397, module_name);
  return 1;
LAB203:
  L116 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  L117 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  L118 = C_INT(1);
  L119 = C_INT(Int(L117) + Int(L118));
  G_recursion_CUR_FRAMESIZE_NR4 = (long)L119;
  L120 = G_recursion_FRAME_FROM_NR2913;
  L121 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L116));
  ATTACH(L120);
if(DecrRefs(*((value*)L121))<0)
XD_Mrecursion_T6(*((value*)L121));
  *((value *)L121) = L120;
  L122 = C_INT(0);
  L123 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L116));
  *((value *)L123) = L122;
  L22 = L116;
LAB512:
  L124 = L22;
  L125 = L4;
  L126 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L125));
  L127 = *((value*)L126);
  ATTACH(L127);
  switch (Alternative(L127)) {
  case 2: goto LAB514;
  default: goto LAB515;
  };
LAB514:
if(DecrRefs(L127)<0)
XD_Mrecursion_T7(L127);
  Create(&L128,1,1);
  *(value *)(L128+1) = L124;
if(DecrRefs(*((value*)L126))<0)
XD_Mrecursion_T7(*((value*)L126));
  *((value *)L126) = L128;
  return 1;
LAB515:
if(DecrRefs(L127)<0)
XD_Mrecursion_T7(L127);
  Abort(402, module_name);
  Abort(402, module_name);
  return 1;
LAB201:
  Abort(306, module_name);
LAB187:
  Abort(307, module_name);
}

int Mrecursion_P_find_initial_location_INT_PARAMETER_MAP_ADDRESS(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB415:
  switch (Alternative(L1)) {
  case 2: goto LAB204;
  case 0: goto LAB207;
  case 1: goto LAB212;
  default: goto LAB214;
  };
LAB204:
  Abort(317, module_name);
LAB207:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  L4 = (value)(L1[3]);
  if (!(L0 == L2)) goto LAB211;
  Create(&L5,2,1);
  *(value *)(L5+1) = L3;
  *P2 = L5;
  return 1;
LAB211:
  L1 = L4;
  goto LAB415;
LAB212:
  L7 = (value)(L1[1]);
  L8 = (value)(L1[2]);
  L9 = (value)(L1[3]);
  if (!(L0 == L7)) goto LAB216;
  Create(&L10,2,1);
  *(value *)(L10+1) = L8;
  *P2 = L10;
  return 1;
LAB216:
  L1 = L9;
  goto LAB415;
LAB214:
  Abort(326, module_name);
}

int Mrecursion_P_find_ultimate_destination_ADDRESS_MAPLIST_INT(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB443:
  switch (Alternative(L1)) {
  case 1: goto LAB217;
  case 0: goto LAB220;
  default: goto LAB222;
  };
LAB217:
  return 0;
LAB220:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  L4 = (value)(L1[3]);
  L5 = (value)(L1[4]);
  if (!EQ_Mcode_T20(L0,L2)) goto LAB224;
  *P2 = L3;
  return 1;
LAB224:
  L1 = L5;
  goto LAB443;
  return 0;
LAB222:
  Abort(336, module_name);
}

int Mrecursion_P_find_next_rule_LOCATION_LOCATION(P0,P1)
value P0;
value *P1;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mcode_P_get_LOCATION_INSTRUCTION(L0,&L1);
  switch (Alternative(L1)) {
  case 5: goto LAB227;
  default: goto LAB228;
  };
LAB227:
if(DecrRefs(L1)<0)
XD_Mcode_T14(L1);
  *P1 = L0;
  return 1;
LAB228:
if(DecrRefs(L1)<0)
XD_Mcode_T14(L1);
LAB229:
  L2 = L0;
  if (!Mcode_P_next_LOCATION(&L2)) goto LAB230;
  Mrecursion_P_find_next_rule_LOCATION_LOCATION(L2,&L3);
  *P1 = L3;
  return 1;
LAB230:
  Abort(346, module_name);
  Abort(346, module_name);
}

int Mrecursion_P_expect_failure_LABEL(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  Mcode_P_get_label_LABEL_LOCATION(L0,&L1);
  if (!Mrecursion_P_expect_failure_LOCATION(L1)) goto LAB232;
  return 1;
LAB232:
  return 0;
  return 0;
}

int Mrecursion_P_expect_failure_LOCATION(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB561:
  L1 = L0;
  if (!Mcode_P_next_LOCATION(&L1)) goto LAB234;
  Mcode_P_get_LOCATION_INSTRUCTION(L1,&L2);
  switch (Alternative(L2)) {
  case 16: goto LAB236;
  case 1: goto LAB239;
  case 12: goto LAB244;
  default: goto LAB246;
  };
LAB236:
if(DecrRefs(L2)<0)
XD_Mcode_T14(L2);
  return 1;
LAB234:
  Abort(365, module_name);
LAB239:
  L3 = (value)(L2[1]);
  if (!Mrecursion_P_expect_failure_LOCATION(L1)) goto LAB246;
if(DecrRefs(L2)<0)
XD_Mcode_T14(L2);
  return 1;
LAB244:
  L4 = (value)(L2[1]);
  if (!Mrecursion_P_expect_failure_LABEL(L4)) goto LAB246;
if(DecrRefs(L2)<0)
XD_Mcode_T14(L2);
  return 1;
LAB246:
  if (!Mcode_P_no_effect_INSTRUCTION(L2)) goto LAB249;
if(DecrRefs(L2)<0)
XD_Mcode_T14(L2);
  L0 = L1;
  goto LAB561;
LAB249:
if(DecrRefs(L2)<0)
XD_Mcode_T14(L2);
  return 0;
  return 0;
  Abort(365, module_name);
}

int Mrecursion_P_clear_tables_FRAMESIZE(P0)
value P0;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB386:
  switch (Int(L0)) {
  case 0: goto LAB253;
  default: goto LAB255;
  };
LAB253:
  return 1;
LAB255:
  L1 = G_recursion_FRAME_FROM_NR2908;
  L2 = C_INT(1);
  L3 = C_INT(Int(L0) - Int(L2));
  L4 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L3));
  ATTACH(L1);
if(DecrRefs(*((value*)L4))<0)
XD_Mrecursion_T6(*((value*)L4));
  *((value *)L4) = L1;
  L5 = C_INT(0);
  L6 = C_INT(1);
  L7 = C_INT(Int(L0) - Int(L6));
  L8 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L7));
  *((value *)L8) = L5;
  L9 = C_INT(1);
  L10 = C_INT(Int(L0) - Int(L9));
  L0 = L10;
  goto LAB386;
}

int Mrecursion_P_clear_tables_INT_ADDRESSES_INT(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB392:
  switch (Alternative(L1)) {
  case 2: goto LAB256;
  case 0: goto LAB259;
  default: goto LAB261;
  };
LAB256:
  *P2 = L0;
  return 1;
LAB259:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  L4 = G_recursion_PAR_FROM_NR2909;
  L5 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L0));
  ATTACH(L4);
if(DecrRefs(*((value*)L5))<0)
XD_Mrecursion_T7(*((value*)L5));
  *((value *)L5) = L4;
  L6 = C_INT(0);
  L7 = (value) Addr((value*)&G_recursion_PAR_COUNT_NR8,Int(L0));
  *((value *)L7) = L6;
  L8 = C_INT(1);
  L9 = C_INT(Int(L0) + Int(L8));
  L1 = L3;
  L0 = L9;
  goto LAB392;
LAB261:
  Abort(390, module_name);
}

int Mrecursion_P_generate_output_copies_INT_LOCATION(P0,P1)
value P0;
value P1;
{
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB518:
  L2 = C_INT(-1);
  if (!(L0 == L2)) goto LAB282;
  return 1;
LAB282:
  L3 = (value) Addr((value*)&G_recursion_PAR_COUNT_NR8,Int(L0));
  L4 = *((value*)L3);
  switch (Int(L4)) {
  case 0: goto LAB283;
  default: goto LAB284;
  };
LAB283:
  L5 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L0));
  L6 = *((value*)L5);
  ATTACH(L6);
  switch (Alternative(L6)) {
  case 2: goto LAB286;
  default: goto LAB287;
  };
LAB286:
if(DecrRefs(L6)<0)
XD_Mrecursion_T7(L6);
  L7 = C_INT(1);
  L8 = C_INT(Int(L0) - Int(L7));
  L0 = L8;
  goto LAB518;
LAB284:
LAB285:
  L31 = C_INT(1);
  L32 = C_INT(Int(L0) - Int(L31));
  L0 = L32;
  goto LAB518;
LAB287:
if(DecrRefs(L6)<0)
XD_Mrecursion_T7(L6);
LAB288:
  L9 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L0));
  L10 = *((value*)L9);
  ATTACH(L10);
  switch (Alternative(L10)) {
  case 0: goto LAB289;
  default: goto LAB290;
  };
LAB289:
  L11 = (value)(L10[1]);
  Create(&L12,28,2);
  Create(&L13,5,1);
  *(value *)(L13+1) = L11;
if(DecrRefs(L10)<0)
XD_Mrecursion_T7(L10);
  *(value *)(L12+1) = L13;
  Create(&L14,5,1);
  *(value *)(L14+1) = L0;
  *(value *)(L12+2) = L14;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L1,L12);
if(DecrRefs(L12)<0)
XD_Mcode_T14(L12);
  L15 = G_recursion_PAR_FROM_NR2910;
  ATTACH(L15);
if(DecrRefs(*((value*)L9))<0)
XD_Mrecursion_T7(*((value*)L9));
  *((value *)L9) = L15;
  L16 = (value) Addr((value*)&G_recursion_PAR_COUNT_NR8,Int(L11));
  L17 = *((value*)L16);
  L18 = C_INT(1);
  L19 = C_INT(Int(L17) - Int(L18));
  *((value *)L16) = L19;
  Mrecursion_P_generate_output_copies_INT_LOCATION(L11,L1);
  L20 = C_INT(1);
  L21 = C_INT(Int(L0) - Int(L20));
  L0 = L21;
  goto LAB518;
LAB290:
if(DecrRefs(L10)<0)
XD_Mrecursion_T7(L10);
LAB291:
  L22 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L0));
  L23 = *((value*)L22);
  ATTACH(L23);
  switch (Alternative(L23)) {
  case 1: goto LAB292;
  default: goto LAB293;
  };
LAB292:
  L24 = (value)(L23[1]);
  Create(&L25,28,2);
  Create(&L26,12,1);
  *(value *)(L26+1) = L24;
if(DecrRefs(L23)<0)
XD_Mrecursion_T7(L23);
  *(value *)(L25+1) = L26;
  Create(&L27,5,1);
  *(value *)(L27+1) = L0;
  *(value *)(L25+2) = L27;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L1,L25);
if(DecrRefs(L25)<0)
XD_Mcode_T14(L25);
  L28 = G_recursion_PAR_FROM_NR2911;
  ATTACH(L28);
if(DecrRefs(*((value*)L22))<0)
XD_Mrecursion_T7(*((value*)L22));
  *((value *)L22) = L28;
  L29 = C_INT(1);
  L30 = C_INT(Int(L0) - Int(L29));
  L0 = L30;
  goto LAB518;
LAB293:
if(DecrRefs(L23)<0)
XD_Mrecursion_T7(L23);
  Abort(429, module_name);
  Abort(429, module_name);
}

int Mrecursion_P_generate_input_copies_INT_LOCATION(P0,P1)
value P0;
value P1;
{
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB517:
  L2 = C_INT(-1);
  if (!(L0 == L2)) goto LAB296;
  return 1;
LAB296:
  L3 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L0));
  L4 = *((value*)L3);
  switch (Int(L4)) {
  case 0: goto LAB297;
  default: goto LAB298;
  };
LAB297:
  L5 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L0));
  L6 = *((value*)L5);
  ATTACH(L6);
  switch (Alternative(L6)) {
  case 1: goto LAB300;
  default: goto LAB301;
  };
LAB300:
if(DecrRefs(L6)<0)
XD_Mrecursion_T6(L6);
  L7 = C_INT(1);
  L8 = C_INT(Int(L0) - Int(L7));
  L0 = L8;
  goto LAB517;
LAB298:
LAB299:
  L23 = C_INT(1);
  L24 = C_INT(Int(L0) - Int(L23));
  L0 = L24;
  goto LAB517;
LAB301:
if(DecrRefs(L6)<0)
XD_Mrecursion_T6(L6);
LAB302:
  L9 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L0));
  L10 = *((value*)L9);
  ATTACH(L10);
  switch (Alternative(L10)) {
  case 0: goto LAB303;
  default: goto LAB304;
  };
LAB303:
  L11 = (value)(L10[1]);
  L12 = (value)(L10[2]);
  Create(&L13,27,3);
  Create(&L14,2,1);
  *(value *)(L14+1) = L11;
  *(value *)(L13+1) = L14;
  *(value *)(L13+2) = L12;
if(DecrRefs(L10)<0)
XD_Mrecursion_T6(L10);
  Create(&L15,2,1);
  *(value *)(L15+1) = L0;
  *(value *)(L13+3) = L15;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L1,L13);
if(DecrRefs(L13)<0)
XD_Mcode_T14(L13);
  L16 = G_recursion_FRAME_FROM_NR2912;
  ATTACH(L16);
if(DecrRefs(*((value*)L9))<0)
XD_Mrecursion_T6(*((value*)L9));
  *((value *)L9) = L16;
  L17 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L11));
  L18 = *((value*)L17);
  L19 = C_INT(1);
  L20 = C_INT(Int(L18) - Int(L19));
  *((value *)L17) = L20;
  Mrecursion_P_generate_input_copies_INT_LOCATION(L11,L1);
  L21 = C_INT(1);
  L22 = C_INT(Int(L0) - Int(L21));
  L0 = L22;
  goto LAB517;
LAB304:
if(DecrRefs(L10)<0)
XD_Mrecursion_T6(L10);
  Abort(443, module_name);
  Abort(443, module_name);
}

int Mrecursion_P_input_recursion_INT_LOCATION(P0,P1)
value P0;
value P1;
{
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB522:
  L2 = C_INT(-1);
  if (!(L0 == L2)) goto LAB307;
  return 0;
LAB307:
  L3 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L0));
  L4 = *((value*)L3);
  ATTACH(L4);
  switch (Alternative(L4)) {
  case 1: goto LAB308;
  default: goto LAB309;
  };
LAB308:
if(DecrRefs(L4)<0)
XD_Mrecursion_T6(L4);
  L5 = C_INT(1);
  L6 = C_INT(Int(L0) - Int(L5));
  L0 = L6;
  goto LAB522;
LAB309:
if(DecrRefs(L4)<0)
XD_Mrecursion_T6(L4);
LAB310:
  L7 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L0));
  L8 = *((value*)L7);
  ATTACH(L8);
  switch (Alternative(L8)) {
  case 0: goto LAB313;
  default: goto LAB314;
  };
  return 0;
LAB313:
  L9 = (value)(L8[1]);
  L10 = (value)(L8[2]);
  L11 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L0));
  L12 = *((value*)L11);
  switch (Int(L12)) {
  case 1: goto LAB316;
  default: goto LAB317;
  };
LAB316:
  L28 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  L29 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  L30 = C_INT(1);
  L31 = C_INT(Int(L29) + Int(L30));
  G_recursion_CUR_FRAMESIZE_NR4 = (long)L31;
  L32 = G_recursion_FRAME_FROM_NR2913;
  L33 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L28));
  ATTACH(L32);
if(DecrRefs(*((value*)L33))<0)
XD_Mrecursion_T6(*((value*)L33));
  *((value *)L33) = L32;
  L34 = C_INT(0);
  L35 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L28));
  *((value *)L35) = L34;
  L13 = L28;
LAB520:
  L14 = G_recursion_FRAME_FROM_NR2914;
  ATTACH(L14);
if(DecrRefs(*((value*)L7))<0)
XD_Mrecursion_T6(*((value*)L7));
  *((value *)L7) = L14;
  L15 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L9));
  L16 = *((value*)L15);
  L17 = C_INT(1);
  L18 = C_INT(Int(L16) - Int(L17));
  *((value *)L15) = L18;
  Create(&L19,27,3);
  Create(&L20,2,1);
  *(value *)(L20+1) = L9;
  *(value *)(L19+1) = L20;
  *(value *)(L19+2) = L10;
if(DecrRefs(L8)<0)
XD_Mrecursion_T6(L8);
  Create(&L21,2,1);
  *(value *)(L21+1) = L13;
  *(value *)(L19+3) = L21;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L1,L19);
if(DecrRefs(L19)<0)
XD_Mcode_T14(L19);
  Mrecursion_P_resolve_input_cycle_LOCATION_INT_INT(L1,L9,L0);
  L22 = G_recursion_TEXT_NR2915;
  Merrors_P_error_text_TEXT(L22);
  Create(&L23,27,3);
  Create(&L24,2,1);
  *(value *)(L24+1) = L13;
  *(value *)(L23+1) = L24;
  *(value *)(L23+2) = L10;
  Create(&L25,2,1);
  *(value *)(L25+1) = L0;
  *(value *)(L23+3) = L25;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L1,L23);
if(DecrRefs(L23)<0)
XD_Mcode_T14(L23);
  return 1;
LAB314:
if(DecrRefs(L8)<0)
XD_Mrecursion_T6(L8);
  Abort(468, module_name);
LAB317:
LAB318:
if(DecrRefs(L8)<0)
XD_Mrecursion_T6(L8);
  L26 = C_INT(1);
  L27 = C_INT(Int(L0) - Int(L26));
  L0 = L27;
  goto LAB522;
  return 0;
  Abort(468, module_name);
}

int Mrecursion_P_output_recursion_INT_LOCATION(P0,P1)
value P0;
value P1;
{
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB525:
  L2 = C_INT(-1);
  if (!(L0 == L2)) goto LAB322;
  return 0;
LAB322:
  L3 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L0));
  L4 = *((value*)L3);
  ATTACH(L4);
  switch (Alternative(L4)) {
  case 2: goto LAB323;
  default: goto LAB324;
  };
LAB323:
if(DecrRefs(L4)<0)
XD_Mrecursion_T7(L4);
  L5 = C_INT(1);
  L6 = C_INT(Int(L0) - Int(L5));
  L0 = L6;
  goto LAB525;
LAB324:
if(DecrRefs(L4)<0)
XD_Mrecursion_T7(L4);
LAB325:
  L7 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L0));
  L8 = *((value*)L7);
  ATTACH(L8);
  switch (Alternative(L8)) {
  case 1: goto LAB328;
  default: goto LAB329;
  };
  return 0;
LAB328:
  L9 = (value)(L8[1]);
if(DecrRefs(L8)<0)
XD_Mrecursion_T7(L8);
  Abort(474, module_name);
LAB329:
if(DecrRefs(L8)<0)
XD_Mrecursion_T7(L8);
LAB330:
  L10 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L0));
  L11 = *((value*)L10);
  ATTACH(L11);
  switch (Alternative(L11)) {
  case 0: goto LAB331;
  default: goto LAB332;
  };
LAB331:
  L12 = (value)(L11[1]);
  L13 = (value) Addr((value*)&G_recursion_PAR_COUNT_NR8,Int(L0));
  L14 = *((value*)L13);
  switch (Int(L14)) {
  case 1: goto LAB334;
  default: goto LAB335;
  };
LAB334:
  L30 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  L31 = (value)G_recursion_CUR_FRAMESIZE_NR4;
  L32 = C_INT(1);
  L33 = C_INT(Int(L31) + Int(L32));
  G_recursion_CUR_FRAMESIZE_NR4 = (long)L33;
  L34 = G_recursion_FRAME_FROM_NR2913;
  L35 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L30));
  ATTACH(L34);
if(DecrRefs(*((value*)L35))<0)
XD_Mrecursion_T6(*((value*)L35));
  *((value *)L35) = L34;
  L36 = C_INT(0);
  L37 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L30));
  *((value *)L37) = L36;
  L15 = L30;
LAB523:
  L16 = G_recursion_PAR_FROM_NR2916;
  ATTACH(L16);
if(DecrRefs(*((value*)L10))<0)
XD_Mrecursion_T7(*((value*)L10));
  *((value *)L10) = L16;
  L17 = (value) Addr((value*)&G_recursion_PAR_COUNT_NR8,Int(L12));
  L18 = *((value*)L17);
  L19 = C_INT(1);
  L20 = C_INT(Int(L18) - Int(L19));
  *((value *)L17) = L20;
  Create(&L21,28,2);
  Create(&L22,5,1);
  *(value *)(L22+1) = L12;
if(DecrRefs(L11)<0)
XD_Mrecursion_T7(L11);
  *(value *)(L21+1) = L22;
  Create(&L23,2,1);
  *(value *)(L23+1) = L15;
  *(value *)(L21+2) = L23;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L1,L21);
if(DecrRefs(L21)<0)
XD_Mcode_T14(L21);
  Mrecursion_P_resolve_output_cycle_LOCATION_INT_INT(L1,L12,L0);
  Merrors_P_error_int_INT(L0);
  L24 = G_recursion_TEXT_NR2917;
  Merrors_P_error_text_TEXT(L24);
  Create(&L25,28,2);
  Create(&L26,2,1);
  *(value *)(L26+1) = L15;
  *(value *)(L25+1) = L26;
  Create(&L27,5,1);
  *(value *)(L27+1) = L0;
  *(value *)(L25+2) = L27;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L1,L25);
if(DecrRefs(L25)<0)
XD_Mcode_T14(L25);
  return 1;
LAB332:
if(DecrRefs(L11)<0)
XD_Mrecursion_T7(L11);
  Abort(486, module_name);
LAB335:
LAB336:
if(DecrRefs(L11)<0)
XD_Mrecursion_T7(L11);
  L28 = C_INT(1);
  L29 = C_INT(Int(L0) - Int(L28));
  L0 = L29;
  goto LAB525;
  return 0;
  Abort(486, module_name);
}

int Mrecursion_P_resolve_input_cycle_LOCATION_INT_INT(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB521:
  L3 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L1));
  L4 = *((value*)L3);
  ATTACH(L4);
  switch (Alternative(L4)) {
  case 1: goto LAB339;
  default: goto LAB340;
  };
LAB339:
if(DecrRefs(L4)<0)
XD_Mrecursion_T6(L4);
  Abort(490, module_name);
LAB340:
if(DecrRefs(L4)<0)
XD_Mrecursion_T6(L4);
LAB341:
  L5 = (value) Addr((value*)&G_recursion_FRAME_FROM_NR5,Int(L1));
  L6 = *((value*)L5);
  ATTACH(L6);
  switch (Alternative(L6)) {
  case 0: goto LAB342;
  default: goto LAB343;
  };
LAB342:
  L7 = (value)(L6[1]);
  L8 = (value)(L6[2]);
  L9 = (value) Addr((value*)&G_recursion_FRAME_COUNT_NR7,Int(L7));
  L10 = *((value*)L9);
  L11 = C_INT(1);
  L12 = C_INT(Int(L10) - Int(L11));
  *((value *)L9) = L12;
  L13 = G_recursion_FRAME_FROM_NR2918;
  ATTACH(L13);
if(DecrRefs(*((value*)L5))<0)
XD_Mrecursion_T6(*((value*)L5));
  *((value *)L5) = L13;
  Create(&L14,27,3);
  Create(&L15,2,1);
  *(value *)(L15+1) = L7;
  *(value *)(L14+1) = L15;
  *(value *)(L14+2) = L8;
if(DecrRefs(L6)<0)
XD_Mrecursion_T6(L6);
  Create(&L16,2,1);
  *(value *)(L16+1) = L1;
  *(value *)(L14+3) = L16;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L0,L14);
if(DecrRefs(L14)<0)
XD_Mcode_T14(L14);
  if (!(L2 == L7)) goto LAB346;
  return 1;
LAB343:
if(DecrRefs(L6)<0)
XD_Mrecursion_T6(L6);
  Abort(497, module_name);
LAB346:
  L1 = L7;
  goto LAB521;
  Abort(497, module_name);
}

int Mrecursion_P_resolve_output_cycle_LOCATION_INT_INT(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB524:
  L3 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L1));
  L4 = *((value*)L3);
  ATTACH(L4);
  switch (Alternative(L4)) {
  case 2: goto LAB347;
  default: goto LAB348;
  };
LAB347:
if(DecrRefs(L4)<0)
XD_Mrecursion_T7(L4);
  Abort(501, module_name);
LAB348:
if(DecrRefs(L4)<0)
XD_Mrecursion_T7(L4);
LAB349:
  L5 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L1));
  L6 = *((value*)L5);
  ATTACH(L6);
  switch (Alternative(L6)) {
  case 1: goto LAB350;
  default: goto LAB351;
  };
LAB350:
  L7 = (value)(L6[1]);
if(DecrRefs(L6)<0)
XD_Mrecursion_T7(L6);
  Abort(502, module_name);
LAB351:
if(DecrRefs(L6)<0)
XD_Mrecursion_T7(L6);
LAB352:
  L8 = (value) Addr((value*)&G_recursion_PAR_FROM_NR6,Int(L1));
  L9 = *((value*)L8);
  ATTACH(L9);
  switch (Alternative(L9)) {
  case 0: goto LAB353;
  default: goto LAB354;
  };
LAB353:
  L10 = (value)(L9[1]);
  L11 = (value) Addr((value*)&G_recursion_PAR_COUNT_NR8,Int(L10));
  L12 = *((value*)L11);
  L13 = C_INT(1);
  L14 = C_INT(Int(L12) - Int(L13));
  *((value *)L11) = L14;
  L15 = G_recursion_PAR_FROM_NR2919;
  ATTACH(L15);
if(DecrRefs(*((value*)L8))<0)
XD_Mrecursion_T7(*((value*)L8));
  *((value *)L8) = L15;
  Create(&L16,28,2);
  Create(&L17,5,1);
  *(value *)(L17+1) = L10;
if(DecrRefs(L9)<0)
XD_Mrecursion_T7(L9);
  *(value *)(L16+1) = L17;
  Create(&L18,5,1);
  *(value *)(L18+1) = L1;
  *(value *)(L16+2) = L18;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L0,L16);
if(DecrRefs(L16)<0)
XD_Mcode_T14(L16);
  if (!(L10 == L2)) goto LAB357;
  return 1;
LAB354:
if(DecrRefs(L9)<0)
XD_Mrecursion_T7(L9);
  Abort(509, module_name);
LAB357:
  L1 = L10;
  goto LAB524;
  Abort(509, module_name);
}

