/*
 * inline.c -- part of the C sources generated from the CDL3 sources,
 *              used to bootstrap CDL3
 * Copyright (C) 2000  C.H.A. Koster
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cdl3rts.h"
#include "predef.h"


static char* module_name = "inline";

/*
** GLOBALS
*/

	static long undefined[] = {5119};
long G_inline_RULE_CALLS_NR0B = 0;
value G_inline_RULE_CALLS_NR0 = &G_inline_RULE_CALLS_NR0B;
long G_inline_RULE_CALL_NODE_NR1B = 0;
value G_inline_RULE_CALL_NODE_NR1 = &G_inline_RULE_CALL_NODE_NR1B;
long G_inline_RULE_CALLED_BY_NR2B = 0;
value G_inline_RULE_CALLED_BY_NR2 = &G_inline_RULE_CALLED_BY_NR2B;
long G_inline_PROCESSED_NR3B = 0;
value G_inline_PROCESSED_NR3 = &G_inline_PROCESSED_NR3B;
long G_inline_HEADERS_NR4B = 0;
value G_inline_HEADERS_NR4 = &G_inline_HEADERS_NR4B;
long G_inline_MAX_FRAME_NR5A = 1;
value G_inline_MAX_FRAME_NR5 = &G_inline_MAX_FRAME_NR5A;
long G_inline_INLINED_NR6B = 0;
value G_inline_INLINED_NR6 = &G_inline_INLINED_NR6B;
long G_inline_INLINABLE_NR7B = 0;
value G_inline_INLINABLE_NR7 = &G_inline_INLINABLE_NR7B;
long G_inline_CURRENT_MODULE_NR8 = 0;
long G_inline_CURRENT_RULE_NR9 = 0;
long G_inline_COUNT_NR10 = 0;
long G_inline_SMALL_LIMIT_NR11 = 0;
long G_inline_REACHES_NR12B = 0;
value G_inline_REACHES_NR12 = &G_inline_REACHES_NR12B;
long G_inline_WORKING_NR13B = 0;
value G_inline_WORKING_NR13 = &G_inline_WORKING_NR13B;
value G_inline_DONE_REC_NR14 = undefined;
value G_inline_DONE_GL_NR15 = undefined;
value G_inline_UNREACHABLE_NR16 = undefined;
long G_inline_INLINE_NR17 = 0;
value G_inline_NOINLINE_NR18 = undefined;
long G_inline_MOD_GLOBAL_NR19B = 0;
value G_inline_MOD_GLOBAL_NR19 = &G_inline_MOD_GLOBAL_NR19B;
long G_inline_MOD_DEP_NR20B = 0;
value G_inline_MOD_DEP_NR20 = &G_inline_MOD_DEP_NR20B;
long G_inline_CUR_RULE_NR21 = 0;
long G_inline_RULENRS_NR2896[] = {Tag(1,1)};
long G_inline_NODENRS_NR2897[] = {Tag(1,1)};
long G_inline_RULENRS_NR2898[] = {Tag(1,1)};
long G_inline_PROCESSED_NR2899[] = {Tag(1,1)};
long G_inline_INLINED_NR2900[] = {Tag(1,1)};
long G_inline_INLINABLE_NR2901[] = {Tag(1,2)};
long G_inline_HEADERS_NR2902[] = {Tag(1,1)};
long G_inline_NOINLINE_NR2903[] = {Tag(1,1)};
long G_inline_TEXT_NR2904[] = {Tag(1,T_TEXT),23,(long)"Usage: -inline <level>\n"};
long G_inline_TEXT_NR2905[] = {Tag(1,T_TEXT),13,(long)"Inlining...  "};
long G_inline_NOINLINE_NR2906[] = {Tag(1,0)};
long G_inline_UNREACHABLE_NR2907[] = {Tag(1,1)};
long G_inline_UNREACHABLE_NR2908[] = {Tag(1,0)};
long G_inline_NOINLINE_NR2909[] = {Tag(1,1)};
long G_inline_TEXT_NR2910[] = {Tag(1,T_TEXT),9,(long)"CDL3USAGE"};
long G_inline_TEXT_NR2911[] = {Tag(1,T_TEXT),8,(long)"Inlined "};
long G_inline_TEXT_NR2912[] = {Tag(1,T_TEXT),12,(long)" functions.\n"};
long G_inline_PROCESSED_NR2913[] = {Tag(1,0)};
long G_inline_RULENRS_NR2914[] = {Tag(1,1)};
long G_inline_RULENRS_NR2915[] = {Tag(1,1)};
long G_inline_TEXT_NR2916[] = {Tag(1,T_TEXT),6,(long)"before"};
long G_inline_TEXT_NR2917[] = {Tag(1,T_TEXT),5,(long)"after"};
long G_inline_TEXT_NR2918[] = {Tag(1,T_TEXT),6,(long)"INLINE"};
long G_inline_INLINED_NR2919[] = {Tag(1,0)};
long G_inline_INLINABLE_NR2920[] = {Tag(1,1)};
long G_inline_INLINABLE_NR2921[] = {Tag(1,0)};
long G_inline_INLINABLE_NR2922[] = {Tag(1,0)};
long G_inline_INLINABLE_NR2923[] = {Tag(1,1)};
long G_inline_NEW_LABELS_NR2924[] = {Tag(1,0)};
long G_inline_TEXT_NR2925[] = {Tag(1,T_TEXT),11,(long)"Undefined.\n"};
long G_inline_TEXT_NR2926[] = {Tag(1,T_TEXT),7,(long)"Deleted"};
long G_inline_TEXT_NR2927[] = {Tag(1,T_TEXT),2,(long)".\n"};
long G_inline_TEXT_NR2928[] = {Tag(1,T_TEXT),18,(long)"begin ... end ...\n"};
long G_inline_NEW_LABELS_NR2929[] = {Tag(1,0)};
long G_inline_TEXT_NR2930[] = {Tag(1,T_TEXT),33,(long)"Starting resolving recursion... ["};
long G_inline_TEXT_NR2931[] = {Tag(1,T_TEXT),2,(long)"] "};
long G_inline_DONE_NR2932[] = {Tag(1,0)};
long G_inline_DONE_NR2933[] = {Tag(1,0)};
long G_inline_TEXT_NR2934[] = {Tag(1,T_TEXT),9,(long)" Done...\n"};
long G_inline_DONE_NR2935[] = {Tag(1,0)};
long G_inline_DONE_NR2936[] = {Tag(1,0)};
long G_inline_TEXT_NR2937[] = {Tag(1,T_TEXT),1,(long)"."};
long G_inline_DONE_NR2938[] = {Tag(1,0)};
long G_inline_TEXT_NR2939[] = {Tag(1,T_TEXT),1,(long)"+"};
long G_inline_TEXT_NR2940[] = {Tag(1,T_TEXT),1,(long)"-"};
long G_inline_TEXT_NR2941[] = {Tag(1,T_TEXT),1,(long)"?"};
long G_inline_DONE_NR2942[] = {Tag(1,1)};
long G_inline_TEXT_NR2943[] = {Tag(1,T_TEXT),1,(long)"{"};
long G_inline_TEXT_NR2944[] = {Tag(1,T_TEXT),5,(long)"} | {"};
long G_inline_TEXT_NR2945[] = {Tag(1,T_TEXT),1,(long)"}"};
long G_inline_TEXT_NR2946[] = {Tag(1,T_TEXT),1,(long)"["};
long G_inline_TEXT_NR2947[] = {Tag(1,T_TEXT),1,(long)"!"};
long G_inline_TEXT_NR2948[] = {Tag(1,T_TEXT),3,(long)"end"};
long G_inline_TEXT_NR2949[] = {Tag(1,T_TEXT),3,(long)"<M>"};
long G_inline_TEXT_NR2950[] = {Tag(1,T_TEXT),1,(long)"("};
long G_inline_TEXT_NR2951[] = {Tag(1,T_TEXT),3,(long)"<D>"};
long G_inline_TEXT_NR2952[] = {Tag(1,T_TEXT),1,(long)")"};
long G_inline_TEXT_NR2953[] = {Tag(1,T_TEXT),1,(long)"("};
long G_inline_TEXT_NR2954[] = {Tag(1,T_TEXT),1,(long)")"};
long G_inline_TEXT_NR2955[] = {Tag(1,T_TEXT),3,(long)"<V>"};
long G_inline_TEXT_NR2956[] = {Tag(1,T_TEXT),3,(long)"<T>"};
long G_inline_TEXT_NR2957[] = {Tag(1,T_TEXT),4,(long)"<Cn>"};
long G_inline_TEXT_NR2958[] = {Tag(1,T_TEXT),4,(long)"<Cs>"};

/*
** ATTACH/DETACH/EQUAL
*/
/****PROCESSED(inline)****/

int EQ_Minline_T4(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Minline_T4(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("true ");
       case 1:
WRITE("false ");
    };
  return 0;
}

int XD_Minline_T4(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Minline_T4(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Minline_T4(x);
}

/****HEADERS(inline)****/

int EQ_Minline_T5(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2));
       case 1:
         return 1;
       case 2:
         return (Part(x,1) == Part(y,1));
    };
  return 0;
}

int W_Minline_T5(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("begin ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("end ");
W_INT(Part(x,2));
WRITE(" ");
       case 1:
WRITE("undefined ");
       case 2:
WRITE("deleted ");
W_INT(Part(x,1));
WRITE(" ");
    };
  return 0;
}

int XD_Minline_T5(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,2);
            break;
    };
}

int D_Minline_T5(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Minline_T5(x);
}

/****INLINED(inline)****/

int EQ_Minline_T7(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Minline_T7(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("true ");
       case 1:
WRITE("false ");
    };
  return 0;
}

int XD_Minline_T7(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Minline_T7(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Minline_T7(x);
}

/****INLINABLE(inline)****/

int EQ_Minline_T8(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
       case 2:
         return 1;
    };
  return 0;
}

int W_Minline_T8(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("yes ");
       case 1:
WRITE("no ");
       case 2:
WRITE("maybe ");
    };
  return 0;
}

int XD_Minline_T8(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Minline_T8(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Minline_T8(x);
}

/****UNREACHABLE(inline)****/

int EQ_Minline_T17(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Minline_T17(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("true ");
       case 1:
WRITE("false ");
    };
  return 0;
}

int XD_Minline_T17(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Minline_T17(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Minline_T17(x);
}

/****NOINLINE(inline)****/

int EQ_Minline_T19(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Minline_T19(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("true ");
       case 1:
WRITE("false ");
    };
  return 0;
}

int XD_Minline_T19(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Minline_T19(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Minline_T19(x);
}

/****NODENRS(inline)****/

int EQ_Minline_T39(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Minline_T39(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Minline_T39(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_Minline_T39(Part(x,2));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Minline_T39(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Minline_T39(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Minline_T39(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Minline_T39(x);
}

/****DONE(inline)****/

int EQ_Minline_T41(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Minline_T41(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("yes ");
       case 1:
WRITE("no ");
    };
  return 0;
}

int XD_Minline_T41(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Minline_T41(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Minline_T41(x);
}

/****NEW_LABELS(inline)****/

int EQ_Minline_T49(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Minline_T49(Part(x,3),Part(y,3));
    };
  return 0;
}

int W_Minline_T49(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("none ");
       case 1:
W_INT(Part(x,1));
WRITE(" ");
WRITE("becomes ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("and ");
W_Minline_T49(Part(x,3));
WRITE(" ");
    };
  return 0;
}

int XD_Minline_T49(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
D_Minline_T49(Part(x,3));
            Free(x,4);
            break;
    };
}

int D_Minline_T49(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Minline_T49(x);
}


/*
** PROTOTYPES
*/

_PROTOTYPE(int Minline_P_declare_rule_RULENR,(value P0));
_PROTOTYPE(int Minline_P_register_call_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(int Minline_P_inline_TEXT,(value P0));
_PROTOTYPE(int Minline_P_inline_MODULENR,(value P0));
_PROTOTYPE(int Minline_P_disable_inlining,());
_PROTOTYPE(int Minline_P_ignore_unreachable_code,());
_PROTOTYPE(int Minline_P_rule_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(int Minline_P_call_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(int Minline_P_resolve_call_graph_MODULENR,(value P0));
_PROTOTYPE(int Minline_P_is_recursive_RULENR,(value P0));
_PROTOTYPE(int Minline_P_rule_is_reachable_RULENR,(value P0));
_PROTOTYPE(int Minline_P_init,());
_PROTOTYPE(int Minline_P_exit,());
_PROTOTYPE(int Minline_P_go_for_it_RULENRS,(value P0));
_PROTOTYPE(int Minline_P_resolve_externals_RULENR,(value P0));
_PROTOTYPE(int Minline_P_resolve_call_graph_RULENRS,(value P0));
_PROTOTYPE(int Minline_P_resolve_call_graph_RULENR,(value P0));
_PROTOTYPE(int Minline_P_resolve_calls_RULENR_NODENRS_RULENRS,(value P0,value P1,value *P2));
_PROTOTYPE(int Minline_P_add_RULENR_RULENRS_RULENRS,(value P0,value P1,value *P2));
_PROTOTYPE(int Minline_P_remove_inlined_rules_RULENR,(value P0));
_PROTOTYPE(int Minline_P_scan_headers_LOCATION,(value P0));
_PROTOTYPE(int Minline_P_scan_rule_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(int Minline_P_inline_RULENR,(value P0));
_PROTOTYPE(int Minline_P_beep_TEXT_RULENR,(value P0,value P1));
_PROTOTYPE(int Minline_P_inline_rule_RULENR,(value P0));
_PROTOTYPE(int Minline_P_inline_rule_RULENR_LOCATION,(value P0,value P1));
_PROTOTYPE(int Minline_P_inline_instruction_RULENR_LOCATION_INSTRUCTION,(value P0,value P1,value P2));
_PROTOTYPE(int Minline_P_inline_called_functions_RULENR_RULENR,(value P0,value P1));
_PROTOTYPE(int Minline_P_one_caller_RULENR_RULENRS,(value P0,value P1));
_PROTOTYPE(int Minline_P_count_callers_RULENR_RULENRS_INT,(value P0,value P1,value *P2));
_PROTOTYPE(int Minline_P_small_rule_INT_LOCATION_LOCATION_RULENR,(value P0,value P1,value P2,value P3));
_PROTOTYPE(int Minline_P_insert_function_RULENR_RULENR_LOCATION_ADDRESSES_SUCCEED_FAIL,(value P0,value P1,value P2,value P3,value P4,value P5));
_PROTOTYPE(int Minline_P_insert_function_LOCATION_LOCATION_ADDRESSES_ADJUST_SUCCEED_FAIL_NEW_LABELS,(value P0,value P1,value P2,value P3,value P4,value P5,value P6));
_PROTOTYPE(int Minline_P_replace_ADDRESS_ADDRESSES_ADJUST,(value *P0,value P1,value P2));
_PROTOTYPE(int Minline_P_replace_ADDRESSES_ADDRESSES_ADJUST,(value *P0,value P1,value P2));
_PROTOTYPE(int Minline_P_replace_LABEL_NEW_LABELS,(value *P0,value *P1));
_PROTOTYPE(int Minline_P_replace_LABELS_NEW_LABELS,(value *P0,value *P1));
_PROTOTYPE(int Minline_P_get_parameter_ADDRESSES_INT_ADDRESS,(value P0,value P1,value *P2));
_PROTOTYPE(int Minline_P_resolve_recursion,());
_PROTOTYPE(int Minline_P_initialise_recursion_check_RULENR,(value P0));
_PROTOTYPE(int Minline_P_resolve_recursion_RULENR,(value P0));
_PROTOTYPE(int Minline_P_fast_resolve_recursion_RULENR,(value P0));
_PROTOTYPE(int Minline_P_resolve_recursion_pass_RULENR,(value P0));
_PROTOTYPE(int Minline_P_fast_resolve_recursion_pass_RULENR,(value P0));
_PROTOTYPE(int Minline_P_equal_BITMAP_BITMAP_DONE,(value *P0,value P1,value *P2));
_PROTOTYPE(int Minline_P_resolve_recursion_rule_RULENRS_BITMAP_BITMAP,(value P0,value *P1,value *P2));
_PROTOTYPE(int Minline_P_fast_resolve_recursion_rule_RULENRS_BITMAP,(value P0,value *P1));
_PROTOTYPE(int Minline_P_build_recursion_rule_RULENRS_BITMAP,(value P0,value *P1));
_PROTOTYPE(int Minline_P_gather_global_info_RULENR,(value P0));
_PROTOTYPE(int Minline_P_gather_global_info_RULENRS_BITMAP,(value P0,value *P1));
_PROTOTYPE(int Minline_P_scan_globals_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(int Minline_P_scan_node_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(int Minline_P_scan_parameters_RULENR_PARAMETERS_EXPRESSIONS,(value P0,value P1,value P2));
_PROTOTYPE(int Minline_P_scan_destination_RULENR_EXPRESSION,(value P0,value P1));
_PROTOTYPE(int Minline_P_scan_destination_RULENR_SUBEXPRESSION,(value P0,value P1));
_PROTOTYPE(int Minline_P_scan_destination_RULENR_VARIABLE,(value P0,value P1));
_PROTOTYPE(int Minline_P_scan_destination_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(int Minline_P_dump_expression_EXPRESSION,(value P0));
_PROTOTYPE(int Minline_P_dump_expression_SUBEXPRESSION,(value P0));


/*
**EXTERNAL PROTOTYPES**
*/

_PROTOTYPE(extern int E1_open_input_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E2_open_output_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E3_open_standard_output_FILE,(value *P0));
_PROTOTYPE(extern int E4_open_standard_error_FILE,(value *P0));
_PROTOTYPE(extern int E5_open_standard_input_FILE,(value *P0));
_PROTOTYPE(extern int E8_pipe_to_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E28_pipe_from_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E9_close_pipe_FILE,(value P0));
_PROTOTYPE(extern int E6_close_FILE,(value P0));
_PROTOTYPE(extern int E7_seek_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E10_write_TEXT,(value P0));
_PROTOTYPE(extern int E11_write_INT,(value P0));
_PROTOTYPE(extern int E12_write_FILE_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E13_write_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E14_formatted_write_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E15_write_char_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E16_write_char_INT,(value P0));
_PROTOTYPE(extern int E20_trace_TEXT,(value P0));
_PROTOTYPE(extern int E21_trace_INT,(value P0));
_PROTOTYPE(extern int E22_formatted_trace_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E30_read_line_TEXT,(value *P0));
_PROTOTYPE(extern int E31_read_line_FILE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E32_read_char_FILE_INT,(value P0,value *P1));
_PROTOTYPE(extern int E33_read_char_INT,(value *P0));
_PROTOTYPE(extern int E40_less_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E41_lesseq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E42_greater_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E43_greatereq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E58_length_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E51_extract_TEXT_INT_INT_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int E52_is_subtext_TEXT_INT_TEXT,(value P0,value *P1,value P2));
_PROTOTYPE(extern int E53_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E54_not_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E55_before_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E56_is_prefix_TEXT_TEXT_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E57_prefix_TEXT_INT_TEXT_TEXT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int E59_asciicode_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E60_bindec_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E61_decbin_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E70_hash_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E80_command_arg_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E81_exit_INT,(value P0));
_PROTOTYPE(extern int E82_get_from_environment_TEXT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E83_time_INT,(value *P0));
_PROTOTYPE(extern int E85_file_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E84_execute_TEXT,(value P0));
_PROTOTYPE(extern int E200_get_key_TEXT,(value *P0));
_PROTOTYPE(extern int Mrules_P_propagate_rules,());
_PROTOTYPE(extern int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(extern int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(extern int Mrules_P_is_external_RULENR_EXTNR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_in_interface_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_is_fixed_RULENR_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR,(value P0,value *P1,value *P2,value *P3,value *P4,value *P5,value *P6));
_PROTOTYPE(extern int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULETYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_PARAMETERS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mrules_P_get_preludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_postludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_interludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_error_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_error_RULENAME,(value P0));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENAME_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_definition_errors,());
_PROTOTYPE(extern int Mrules_P_set_root_error_handler_HANDLER,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_error_handler_HANDLER,(value *P0));
_PROTOTYPE(extern int Mrules_P_set_root_rule_ROOT,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_rule_ROOT,(value *P0));
_PROTOTYPE(extern int Merrors_P_status_message_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_int_INT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_error_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_int_INT,(value P0));
_PROTOTYPE(extern int Mnodes_P_new_NODENR,(value *P0));
_PROTOTYPE(extern int Mnodes_P_store_NODENR_LINENR_NODE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mnodes_P_get_NODENR_LINENR_NODE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mnodes_P_append_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_append_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_pass_two_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_error_SUBEXPRESSION,(value P0));
_PROTOTYPE(extern int Mnodes_P_error_EXPRESSION,(value P0));
_PROTOTYPE(extern int Manalyzer_P_semantic_errors,());
_PROTOTYPE(extern int Manalyzer_P_analyse_main_MODULENR_ROOT,(value P0,value P1));
_PROTOTYPE(extern int Manalyzer_P_analyse_rules_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_resolve_call_ahead_NODENR_RULENR,(value P0,value *P1));
_PROTOTYPE(extern int Manalyzer_P_warnings_on,());
_PROTOTYPE(extern int Mcode_P_start_coding,());
_PROTOTYPE(extern int Mcode_P_new_LABEL,(value *P0));
_PROTOTYPE(extern int Mcode_P_error_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_error_MONADIC_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_store_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_append_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_overwrite_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_move_LOCATION_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_current_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_set_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_get_LOCATION_INSTRUCTION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_next_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_is_end_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_first_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_next_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_is_associative_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS,(value P0));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_alias_LABEL_LABEL,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int Mcode_P_called_once_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_get_label_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_no_effect_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_write_ADDRESS,(value P0));
_PROTOTYPE(extern int Mcode_P_get_ADDRESS_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_get_ADDRESSES_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_dump_code_MODULENR_TEXT,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_dump_instruction_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_dump_code_TEXT_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_make_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mcode_P_request_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mmodules_P_init_modules,());
_PROTOTYPE(extern int Mmodules_P_is_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_set_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_new_id_MODULENR_ID,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_order_MODULENR_MODULEORDER,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_convert_MODULE_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_add_import_for_module_MODULENR_MODULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_store_versionid_MODULENR_VERSIONTEXT,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_module_exports_rule_MODULENR_RULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_MODULE,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_module_name_MODULENR_MODULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_VERSIONTEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_EXPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_IMPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_first_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_next_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_error_MODULENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_propagate_types,());
_PROTOTYPE(extern int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_is_imported_abstract_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_abstract_type_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_special_type_TYPENR_STYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_external_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_integer_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_undefined_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_exported_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_same_TYPE_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_same_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_integer_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_is_text_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_text_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_equal_types_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPENAME_MODULENR,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_first_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_next_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_error_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_build_type_TYPENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_type_errors,());
_PROTOTYPE(extern int Mbitmap_P_new_BITMAP,(value *P0));
_PROTOTYPE(extern int Mbitmap_P_new_INT_BITMAP,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_INT_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_exclude_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_or_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_and_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_equal_BITMAP_BITMAP,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_set_BITMAP_INT,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_empty_BITMAP,(value P0));
_PROTOTYPE(extern int Mbitmap_P_clear_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_set_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_write_BITMAP,(value P0));
_PROTOTYPE(extern int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));
_PROTOTYPE(extern int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value *P1,value *P2,value *P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_set_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_not_local_VARIABLENR,(value P0));
_PROTOTYPE(extern int Mvariables_P_is_constant_VARIABLENR_VALUE,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_global_VARIABLENR_REFNO,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_first_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_next_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_error_INSTANCE,(value P0));
_PROTOTYPE(extern int Mvariables_P_build_instance_INSTANCE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion,());
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion_RULENR_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mterminals_P_convert_TERMINAL_TERMINALNR,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_get_TERMINALNR_TERMINAL,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_error_terminal_TERMINALNR,(value P0));
_PROTOTYPE(extern int Mscanner_P_syntax_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Mscanner_P_current_line_LINENR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_open_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_close,());
_PROTOTYPE(extern int Mscanner_P_end_of_file,());
_PROTOTYPE(extern int Mscanner_P_is_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_ahead_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_should_be_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME_INSTANCE,(value *P0,value *P1));
_PROTOTYPE(extern int Mscanner_P_is_placeholder_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TERMINAL,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_MODULE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_SIZE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_EXTNR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_NUMBER,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_STRING,(value *P0));
_PROTOTYPE(extern int Mcoder_P_no_code,());
_PROTOTYPE(extern int Mcoder_P_no_gc,());
_PROTOTYPE(extern int Mcoder_P_trace_on,());
_PROTOTYPE(extern int Mcoder_P_produce_statistics,());
_PROTOTYPE(extern int Mcoder_P_profile_on,());
_PROTOTYPE(extern int Mcoder_P_just_compile_and_no_object,());
_PROTOTYPE(extern int Mcoder_P_extension_TEXT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_external_names_do_not_start_with_underscore,());
_PROTOTYPE(extern int Mcoder_P_optimize_array_references,());
_PROTOTYPE(extern int Mcoder_P_code_MODULENR,(value P0));
_PROTOTYPE(extern int Mfiles_P_paths_PATHS,(value *P0));
_PROTOTYPE(extern int Mfiles_P_init_files,());
_PROTOTYPE(extern int Mfiles_P_strip_path_TEXT_TEXT_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mfiles_P_set_lib_path_TEXT,(value P0));
_PROTOTYPE(extern int Mfiles_P_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mfiles_P_open_TEXT_FILE,(value P0,value *P1));

/*
** CODE
*/

int Minline_P_declare_rule_RULENR(P0)
value P0;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_inline_RULENRS_NR2896;
  L2 = (value) Addr((value*)&G_inline_RULE_CALLS_NR0,Int(L0));
  ATTACH(L1);
if(DecrRefs(*((value*)L2))<0)
XD_Mrules_T3(*((value*)L2));
  *((value *)L2) = L1;
  L3 = G_inline_NODENRS_NR2897;
  L4 = (value) Addr((value*)&G_inline_RULE_CALL_NODE_NR1,Int(L0));
  ATTACH(L3);
if(DecrRefs(*((value*)L4))<0)
XD_Minline_T39(*((value*)L4));
  *((value *)L4) = L3;
  L5 = G_inline_RULENRS_NR2898;
  L6 = (value) Addr((value*)&G_inline_RULE_CALLED_BY_NR2,Int(L0));
  ATTACH(L5);
if(DecrRefs(*((value*)L6))<0)
XD_Mrules_T3(*((value*)L6));
  *((value *)L6) = L5;
  L7 = G_inline_PROCESSED_NR2899;
  L8 = (value) Addr((value*)&G_inline_PROCESSED_NR3,Int(L0));
  ATTACH(L7);
if(DecrRefs(*((value*)L8))<0)
XD_Minline_T4(*((value*)L8));
  *((value *)L8) = L7;
  L9 = G_inline_INLINED_NR2900;
  L10 = (value) Addr((value*)&G_inline_INLINED_NR6,Int(L0));
  ATTACH(L9);
if(DecrRefs(*((value*)L10))<0)
XD_Minline_T7(*((value*)L10));
  *((value *)L10) = L9;
  L11 = G_inline_INLINABLE_NR2901;
  L12 = (value) Addr((value*)&G_inline_INLINABLE_NR7,Int(L0));
  ATTACH(L11);
if(DecrRefs(*((value*)L12))<0)
XD_Minline_T8(*((value*)L12));
  *((value *)L12) = L11;
  Mbitmap_P_new_BITMAP(&L13);
  L14 = (value) Addr((value*)&G_inline_MOD_GLOBAL_NR19,Int(L0));
if(DecrRefs(*((value*)L14))<0)
XD_Mbitmap_T1(*((value*)L14));
  *((value *)L14) = L13;
  L15 = G_inline_HEADERS_NR2902;
  L16 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L0));
  ATTACH(L15);
if(DecrRefs(*((value*)L16))<0)
XD_Minline_T5(*((value*)L16));
  *((value *)L16) = L15;
  return 1;
}

int Minline_P_register_call_RULENR_NODENR(P0,P1)
value P0;
value P1;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Create(&L2,0,2);
  *(value *)(L2+1) = L1;
  L3 = (value) Addr((value*)&G_inline_RULE_CALL_NODE_NR1,Int(L0));
  L4 = *((value*)L3);
  ATTACH(L4);
  *(value *)(L2+2) = L4;
if(DecrRefs(*((value*)L3))<0)
XD_Minline_T39(*((value*)L3));
  *((value *)L3) = L2;
  return 1;
}

int Minline_P_inline_TEXT(P0)
value P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  if (!E61_decbin_TEXT_INT(L0,&L1)) goto LAB1;
  L2 = G_inline_NOINLINE_NR2903;
  ATTACH(L2);
if(DecrRefs(G_inline_NOINLINE_NR18)<0)
XD_Minline_T19(G_inline_NOINLINE_NR18);
  G_inline_NOINLINE_NR18 = L2;
  G_inline_INLINE_NR17 = (long)L1;
  return 1;
LAB1:
  L3 = G_inline_TEXT_NR2904;
  Merrors_P_error_text_TEXT(L3);
  Exit();
}

int Minline_P_inline_MODULENR(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mcode_P_first_LOCATION(&L1);
  if (!Mrules_P_first_rule_RULENR(&L2)) goto LAB2;
  G_inline_CURRENT_MODULE_NR8 = (long)L0;
  Minline_P_scan_headers_LOCATION(L1);
  L4 = G_inline_NOINLINE_NR18;
  switch (Alternative(L4)) {
  case 1: goto LAB702;
  default: goto LAB5;
  };
LAB702:
  L3 = G_inline_TEXT_NR2905;
  Merrors_P_status_message_TEXT(L3);
  Minline_P_inline_RULENR(L2);
  Minline_P_remove_inlined_rules_RULENR(L2);
  return 1;
LAB2:
  return 1;
LAB5:
  Minline_P_remove_inlined_rules_RULENR(L2);
  return 1;
  return 1;
}

int Minline_P_disable_inlining()
{
  value L0;
  L0 = G_inline_NOINLINE_NR2906;
  ATTACH(L0);
if(DecrRefs(G_inline_NOINLINE_NR18)<0)
XD_Minline_T19(G_inline_NOINLINE_NR18);
  G_inline_NOINLINE_NR18 = L0;
  return 1;
}

int Minline_P_ignore_unreachable_code()
{
  value L0;
  L0 = G_inline_UNREACHABLE_NR2907;
  ATTACH(L0);
if(DecrRefs(G_inline_UNREACHABLE_NR16)<0)
XD_Minline_T17(G_inline_UNREACHABLE_NR16);
  G_inline_UNREACHABLE_NR16 = L0;
  return 1;
}

int Minline_P_rule_changes_global_RULENR_VARIABLENR(P0,P1)
value P0;
value P1;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  if (!Mvariables_P_is_global_VARIABLENR_REFNO(L1,&L2)) goto LAB7;
  L3 = (value) Addr((value*)&G_inline_MOD_GLOBAL_NR19,Int(L0));
  L4 = *((value*)L3);
  if (!Mbitmap_P_is_set_BITMAP_INT(L4,L2)) goto LAB9;
  return 1;
LAB9:
  return 0;
LAB7:
  Abort(794, module_name);
}

int Minline_P_call_changes_global_RULENR_VARIABLENR(P0,P1)
value P0;
value P1;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  if (!Mvariables_P_is_global_VARIABLENR_REFNO(L1,&L2)) goto LAB11;
  L3 = (value) Addr((value*)&G_inline_MOD_DEP_NR20,Int(L0));
  L4 = *((value*)L3);
  if (!Mbitmap_P_is_set_BITMAP_INT(L4,L2)) goto LAB13;
  return 1;
LAB13:
  return 0;
LAB11:
  Abort(788, module_name);
}

int Minline_P_resolve_call_graph_MODULENR(P0)
value P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  if (!Mmodules_P_is_root_module_MODULENR(L0)) goto LAB15;
  Mrules_P_get_root_rule_ROOT(&L1);
  Mrules_P_get_RULEID_RULENRS(L1,&L2);
  Minline_P_go_for_it_RULENRS(L2);
if(DecrRefs(L2)<0)
XD_Mrules_T3(L2);
  Minline_P_resolve_recursion();
  return 1;
LAB15:
  Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS(L0,&L3);
  Minline_P_go_for_it_RULENRS(L3);
if(DecrRefs(L3)<0)
XD_Mrules_T3(L3);
  Minline_P_resolve_recursion();
  return 1;
}

int Minline_P_is_recursive_RULENR(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_inline_REACHES_NR12,Int(L0));
  L2 = *((value*)L1);
  if (!Mbitmap_P_is_set_BITMAP_INT(L2,L0)) goto LAB17;
  return 1;
LAB17:
  return 0;
}

int Minline_P_rule_is_reachable_RULENR(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_inline_PROCESSED_NR3,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 0: goto LAB18;
  default: goto LAB20;
  };
LAB18:
  return 1;
LAB20:
  return 0;
}

int Minline_P_init()
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = G_inline_UNREACHABLE_NR2908;
  ATTACH(L0);
if(DecrRefs(G_inline_UNREACHABLE_NR16)<0)
XD_Minline_T17(G_inline_UNREACHABLE_NR16);
  G_inline_UNREACHABLE_NR16 = L0;
  L1 = G_inline_NOINLINE_NR2909;
  ATTACH(L1);
if(DecrRefs(G_inline_NOINLINE_NR18)<0)
XD_Minline_T19(G_inline_NOINLINE_NR18);
  G_inline_NOINLINE_NR18 = L1;
  L2 = C_INT(0);
  G_inline_INLINE_NR17 = (long)L2;
  L3 = C_INT(0);
  G_inline_COUNT_NR10 = (long)L3;
  return 1;
}

int Minline_P_exit()
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = G_inline_TEXT_NR2910;
  if (!E82_get_from_environment_TEXT_TEXT(L0,&L1)) goto LAB22;
D_TEXT(L1);
  L2 = G_inline_TEXT_NR2911;
  Merrors_P_error_text_TEXT(L2);
  L3 = (value)G_inline_COUNT_NR10;
  Merrors_P_error_int_INT(L3);
  L4 = G_inline_TEXT_NR2912;
  Merrors_P_error_text_TEXT(L4);
  return 1;
LAB22:
  return 1;
}

int Minline_P_go_for_it_RULENRS(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Minline_P_resolve_call_graph_RULENRS(L0);
  Mrules_P_get_preludes_RULENRS(&L1);
  Minline_P_resolve_call_graph_RULENRS(L1);
if(DecrRefs(L1)<0)
XD_Mrules_T3(L1);
  Mrules_P_get_interludes_RULENRS(&L2);
  Minline_P_resolve_call_graph_RULENRS(L2);
if(DecrRefs(L2)<0)
XD_Mrules_T3(L2);
  Mrules_P_get_postludes_RULENRS(&L3);
  Minline_P_resolve_call_graph_RULENRS(L3);
if(DecrRefs(L3)<0)
XD_Mrules_T3(L3);
  if (!Mrules_P_first_rule_RULENR(&L4)) goto LAB1026;
  Minline_P_resolve_externals_RULENR(L4);
  return 1;
LAB1026:
  return 1;
}

int Minline_P_resolve_externals_RULENR(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1025:
  if (!Mrules_P_in_interface_RULENR(L0)) goto LAB26;
  Minline_P_resolve_call_graph_RULENR(L0);
  L1 = L0;
  if (!Mrules_P_next_rule_RULENR(&L1)) goto LAB27;
  L0 = L1;
  goto LAB1025;
LAB27:
  return 1;
  return 1;
LAB26:
  L2 = L0;
  if (!Mrules_P_next_rule_RULENR(&L2)) goto LAB29;
  L0 = L2;
  goto LAB1025;
LAB29:
  return 1;
  return 1;
}

int Minline_P_resolve_call_graph_RULENRS(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1024:
  switch (Alternative(L0)) {
  case 1: goto LAB31;
  case 0: goto LAB34;
  default: goto LAB36;
  };
LAB31:
  return 1;
LAB34:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Minline_P_resolve_call_graph_RULENR(L1);
  L0 = L2;
  goto LAB1024;
LAB36:
  Abort(151, module_name);
}

int Minline_P_resolve_call_graph_RULENR(P0)
value P0;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_inline_PROCESSED_NR3,Int(L0));
  L2 = *((value*)L1);
  ATTACH(L2);
  switch (Alternative(L2)) {
  case 0: goto LAB37;
  default: goto LAB38;
  };
LAB37:
if(DecrRefs(L2)<0)
XD_Minline_T4(L2);
  return 1;
LAB38:
if(DecrRefs(L2)<0)
XD_Minline_T4(L2);
LAB39:
  L3 = G_inline_PROCESSED_NR2913;
  L4 = (value) Addr((value*)&G_inline_PROCESSED_NR3,Int(L0));
  ATTACH(L3);
if(DecrRefs(*((value*)L4))<0)
XD_Minline_T4(*((value*)L4));
  *((value *)L4) = L3;
  L5 = (value) Addr((value*)&G_inline_RULE_CALL_NODE_NR1,Int(L0));
  L6 = *((value*)L5);
  ATTACH(L6);
  Minline_P_resolve_calls_RULENR_NODENRS_RULENRS(L0,L6,&L7);
if(DecrRefs(L6)<0)
XD_Minline_T39(L6);
  L8 = (value) Addr((value*)&G_inline_RULE_CALLS_NR0,Int(L0));
if(DecrRefs(*((value*)L8))<0)
XD_Mrules_T3(*((value*)L8));
  *((value *)L8) = L7;
  L9 = *((value*)L8);
  ATTACH(L9);
  Minline_P_resolve_call_graph_RULENRS(L9);
if(DecrRefs(L9)<0)
XD_Mrules_T3(L9);
  return 1;
}

int Minline_P_resolve_calls_RULENR_NODENRS_RULENRS(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1023:
  switch (Alternative(L1)) {
  case 1: goto LAB40;
  case 0: goto LAB43;
  default: goto LAB45;
  };
LAB40:
  L2 = G_inline_RULENRS_NR2914;
  *P2 = L2;
  ATTACH(L2);
  return 1;
LAB43:
  L3 = (value)(L1[1]);
  L4 = (value)(L1[2]);
  if (!Manalyzer_P_resolve_call_ahead_NODENR_RULENR(L3,&L5)) goto LAB47;
  Create(&L6,0,2);
  *(value *)(L6+1) = L0;
  L7 = (value) Addr((value*)&G_inline_RULE_CALLED_BY_NR2,Int(L5));
  L8 = *((value*)L7);
  ATTACH(L8);
  *(value *)(L6+2) = L8;
if(DecrRefs(*((value*)L7))<0)
XD_Mrules_T3(*((value*)L7));
  *((value *)L7) = L6;
  Minline_P_resolve_calls_RULENR_NODENRS_RULENRS(L0,L4,&L9);
  Minline_P_add_RULENR_RULENRS_RULENRS(L5,L9,&L10);
if(DecrRefs(L9)<0)
XD_Mrules_T3(L9);
  *P2 = L10;
  return 1;
LAB47:
  L1 = L4;
  goto LAB1023;
LAB45:
  Abort(174, module_name);
}

int Minline_P_add_RULENR_RULENRS_RULENRS(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  switch (Alternative(L1)) {
  case 1: goto LAB48;
  case 0: goto LAB51;
  default: goto LAB53;
  };
LAB48:
  Create(&L2,0,2);
  *(value *)(L2+1) = L0;
  L3 = G_inline_RULENRS_NR2915;
  *(value *)(L2+2) = L3;
  ATTACH(L3);
  *P2 = L2;
  return 1;
LAB51:
  L4 = (value)(L1[1]);
  L5 = (value)(L1[2]);
  if (!(L0 == L4)) goto LAB55;
  Create(&L6,0,2);
  *(value *)(L6+1) = L4;
  *(value *)(L6+2) = L5;
  ATTACH(L5);
  *P2 = L6;
  return 1;
LAB55:
  Minline_P_add_RULENR_RULENRS_RULENRS(L0,L5,&L7);
  Create(&L8,0,2);
  *(value *)(L8+1) = L4;
  *(value *)(L8+2) = L7;
  *P2 = L8;
  return 1;
LAB53:
  Abort(187, module_name);
}

int Minline_P_remove_inlined_rules_RULENR(P0)
value P0;
{
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1022:
  L2 = L0;
  if (!Mrules_P_in_interface_RULENR(L2)) goto LAB1011;
  goto LAB1009;
LAB1011:
  if (!Minline_P_is_recursive_RULENR(L2)) goto LAB1013;
  goto LAB1009;
LAB1013:
  Mrules_P_get_RULENR_MODULENR(L2,&L3);
  L4 = (value)G_inline_CURRENT_MODULE_NR8;
  if (!(L4 == L3)) goto LAB1009;
  L5 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L2));
  L6 = *((value*)L5);
  ATTACH(L6);
  switch (Alternative(L6)) {
  case 0: goto LAB1015;
  default: goto LAB1016;
  };
LAB1015:
  L7 = (value)(L6[1]);
  L8 = (value)(L6[2]);
  L9 = (value) Addr((value*)&G_inline_INLINABLE_NR7,Int(L2));
  L10 = *((value*)L9);
  ATTACH(L10);
  switch (Alternative(L10)) {
  case 0: goto LAB1017;
  default: goto LAB1018;
  };
LAB1017:
if(DecrRefs(L10)<0)
XD_Minline_T8(L10);
  Create(&L11,2,1);
  L12 = C_INT(1);
  *(value *)(L11+1) = L12;
if(DecrRefs(*((value*)L5))<0)
XD_Minline_T5(*((value*)L5));
  *((value *)L5) = L11;
  Mcode_P_delete_LOCATION_LOCATION(L7,L8);
if(DecrRefs(L6)<0)
XD_Minline_T5(L6);
  goto LAB1009;
LAB1016:
if(DecrRefs(L6)<0)
XD_Minline_T5(L6);
  goto LAB1009;
LAB1018:
if(DecrRefs(L10)<0)
XD_Minline_T8(L10);
if(DecrRefs(L6)<0)
XD_Minline_T5(L6);
LAB1009:
  L1 = L0;
  if (!Mrules_P_next_rule_RULENR(&L1)) goto LAB56;
  L0 = L1;
  goto LAB1022;
LAB56:
  return 1;
  return 1;
}

int Minline_P_scan_headers_LOCATION(P0)
value P0;
{
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB701:
  if (!Mcode_P_is_end_LOCATION(L0)) goto LAB71;
  return 1;
LAB71:
  Mcode_P_get_LOCATION_INSTRUCTION(L0,&L1);
  L2 = L0;
  L3 = L2;
  L4 = L1;
  switch (Alternative(L4)) {
  case 4: goto LAB684;
  default: goto LAB691;
  };
LAB684:
  L5 = (value)(L4[1]);
  L6 = (value)(L4[2]);
  L7 = (value)(L4[3]);
  Minline_P_scan_rule_LOCATION_LOCATION(L3,&L8);
  L26 = L5;
  L27 = (value) Addr((value*)&G_inline_PROCESSED_NR3,Int(L26));
  L28 = *((value*)L27);
  switch (Alternative(L28)) {
  case 0: goto LAB688;
  default: goto LAB692;
  };
LAB688:
  Create(&L9,0,2);
  *(value *)(L9+1) = L3;
  *(value *)(L9+2) = L8;
  L10 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L5));
if(DecrRefs(*((value*)L10))<0)
XD_Minline_T5(*((value*)L10));
  *((value *)L10) = L9;
  L11 = (value) Addr((value*)&G_inline_MAX_FRAME_NR5,Int(L5));
  *((value *)L11) = L6;
  Mcode_P_next_LOCATION_LOCATION(L8,&L12);
  L2 = L12;
  goto LAB683;
LAB692:
  if (!Mrules_P_in_interface_RULENR(L5)) goto LAB694;
  Create(&L13,2,1);
  L14 = C_INT(2);
  *(value *)(L13+1) = L14;
  L15 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L5));
if(DecrRefs(*((value*)L15))<0)
XD_Minline_T5(*((value*)L15));
  *((value *)L15) = L13;
  Mcode_P_next_LOCATION_LOCATION(L8,&L16);
  L2 = L16;
  goto LAB683;
LAB694:
  L29 = G_inline_UNREACHABLE_NR16;
  switch (Alternative(L29)) {
  case 0: goto LAB697;
  default: goto LAB700;
  };
LAB697:
  Create(&L17,0,2);
  *(value *)(L17+1) = L3;
  *(value *)(L17+2) = L8;
  L18 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L5));
if(DecrRefs(*((value*)L18))<0)
XD_Minline_T5(*((value*)L18));
  *((value *)L18) = L17;
  L19 = (value) Addr((value*)&G_inline_MAX_FRAME_NR5,Int(L5));
  *((value *)L19) = L6;
  Mcode_P_next_LOCATION_LOCATION(L8,&L20);
  L2 = L20;
  goto LAB683;
LAB700:
  Mcode_P_next_LOCATION_LOCATION(L8,&L21);
  Mcode_P_delete_LOCATION_LOCATION(L3,L8);
  Create(&L22,2,1);
  L23 = C_INT(3);
  *(value *)(L22+1) = L23;
  L24 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L5));
if(DecrRefs(*((value*)L24))<0)
XD_Minline_T5(*((value*)L24));
  *((value *)L24) = L22;
  L2 = L21;
  goto LAB683;
LAB691:
  Mcode_P_next_LOCATION_LOCATION(L3,&L25);
  L2 = L25;
LAB683:
if(DecrRefs(L1)<0)
XD_Mcode_T14(L1);
  L0 = L2;
  goto LAB701;
}

int Minline_P_scan_rule_LOCATION_LOCATION(P0,P1)
value P0;
value *P1;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB674:
  if (!Mcode_P_is_end_LOCATION(L0)) goto LAB82;
  *P1 = L0;
  return 1;
LAB82:
  Mcode_P_get_LOCATION_INSTRUCTION(L0,&L1);
  switch (Alternative(L1)) {
  case 5: goto LAB83;
  default: goto LAB85;
  };
LAB83:
if(DecrRefs(L1)<0)
XD_Mcode_T14(L1);
  *P1 = L0;
  return 1;
LAB85:
if(DecrRefs(L1)<0)
XD_Mcode_T14(L1);
  L2 = L0;
  if (!Mcode_P_next_LOCATION(&L2)) goto LAB86;
  L0 = L2;
  goto LAB674;
LAB86:
  Abort(263, module_name);
  Abort(263, module_name);
}

int Minline_P_inline_RULENR(P0)
value P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1008:
  L1 = G_inline_TEXT_NR2916;
  Minline_P_beep_TEXT_RULENR(L1,L0);
  Minline_P_inline_rule_RULENR(L0);
  L2 = G_inline_TEXT_NR2917;
  Minline_P_beep_TEXT_RULENR(L2,L0);
  L3 = L0;
  if (!Mrules_P_next_rule_RULENR(&L3)) goto LAB88;
  L0 = L3;
  goto LAB1008;
LAB88:
  return 1;
  return 1;
}

int Minline_P_beep_TEXT_RULENR(P0,P1)
value P0;
value P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = G_inline_TEXT_NR2918;
  if (!E82_get_from_environment_TEXT_TEXT(L2,&L3)) goto LAB91;
  if (!E61_decbin_TEXT_INT(L3,&L4)) goto LAB92;
D_TEXT(L3);
  if (!(L1 == L4)) goto LAB91;
  L5 = C_INT(1);
  Mcode_P_dump_code_MODULENR_TEXT(L5,L0);
  return 1;
LAB92:
D_TEXT(L3);
  return 1;
LAB91:
  return 1;
}

int Minline_P_inline_rule_RULENR(P0)
value P0;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_inline_INLINED_NR6,Int(L0));
  L2 = *((value*)L1);
  ATTACH(L2);
  switch (Alternative(L2)) {
  case 0: goto LAB96;
  default: goto LAB97;
  };
LAB96:
if(DecrRefs(L2)<0)
XD_Minline_T7(L2);
  return 1;
LAB97:
if(DecrRefs(L2)<0)
XD_Minline_T7(L2);
LAB98:
  if (!Mrules_P_is_external_RULENR_EXTNR(L0,&L3)) goto LAB100;
if(DecrRefs(L3)<0)
XD_Mrules_T19(L3);
  return 1;
LAB100:
  Mrules_P_get_RULENR_MODULENR(L0,&L4);
  L5 = (value)G_inline_CURRENT_MODULE_NR8;
  if (!(L4 == L5)) goto LAB102;
  L6 = G_inline_INLINED_NR2919;
  L7 = (value) Addr((value*)&G_inline_INLINED_NR6,Int(L0));
  ATTACH(L6);
if(DecrRefs(*((value*)L7))<0)
XD_Minline_T7(*((value*)L7));
  *((value *)L7) = L6;
  L8 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L0));
  L9 = *((value*)L8);
  ATTACH(L9);
  switch (Alternative(L9)) {
  case 0: goto LAB103;
  default: goto LAB104;
  };
LAB103:
  L10 = (value)(L9[1]);
  L11 = (value)(L9[2]);
  Minline_P_inline_rule_RULENR_LOCATION(L0,L10);
  L15 = L0;
  L16 = L10;
  if (!Minline_P_is_recursive_RULENR(L15)) goto LAB1005;
  Mrecursion_P_remove_right_recursion_RULENR_LOCATION(L15,L16);
LAB1005:
if(DecrRefs(L9)<0)
XD_Minline_T5(L9);
  return 1;
LAB104:
if(DecrRefs(L9)<0)
XD_Minline_T5(L9);
LAB105:
  L12 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L0));
  L13 = *((value*)L12);
  ATTACH(L13);
  switch (Alternative(L13)) {
  case 2: goto LAB106;
  default: goto LAB107;
  };
LAB106:
  L14 = (value)(L13[1]);
if(DecrRefs(L13)<0)
XD_Minline_T5(L13);
  return 1;
LAB107:
if(DecrRefs(L13)<0)
XD_Minline_T5(L13);
  Abort(291, module_name);
  Abort(291, module_name);
LAB102:
  return 1;
}

int Minline_P_inline_rule_RULENR_LOCATION(P0,P1)
value P0;
value P1;
{
  value L84;
  value L83;
  value L82;
  value L81;
  value L80;
  value L79;
  value L78;
  value L77;
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1004:
  Mcode_P_get_LOCATION_INSTRUCTION(L1,&L2);
  L4 = L0;
  L5 = L1;
  L6 = L2;
  switch (Alternative(L6)) {
  case 0: goto LAB889;
  case 1: goto LAB893;
  case 2: goto LAB896;
  case 3: goto LAB899;
  case 4: goto LAB902;
  case 5: goto LAB109;
  case 6: goto LAB908;
  case 7: goto LAB911;
  case 8: goto LAB914;
  case 9: goto LAB917;
  case 10: goto LAB920;
  case 11: goto LAB929;
  case 12: goto LAB938;
  case 13: goto LAB941;
  case 14: goto LAB944;
  case 15: goto LAB889;
  case 16: goto LAB889;
  case 17: goto LAB889;
  case 18: goto LAB956;
  case 19: goto LAB959;
  case 20: goto LAB962;
  case 21: goto LAB965;
  case 22: goto LAB968;
  case 23: goto LAB971;
  case 24: goto LAB974;
  case 25: goto LAB977;
  case 26: goto LAB980;
  case 27: goto LAB983;
  case 29: goto LAB986;
  case 30: goto LAB989;
  case 31: goto LAB992;
  case 32: goto LAB995;
  case 33: goto LAB998;
  case 35: goto LAB1001;
  default: goto LAB1003;
  };
LAB893:
  L7 = (value)(L6[1]);
  goto LAB889;
LAB896:
  L8 = (value)(L6[1]);
  L9 = (value)(L6[2]);
  L10 = (value)(L6[3]);
  Abort(305, module_name);
LAB899:
  Abort(306, module_name);
LAB902:
  L11 = (value)(L6[1]);
  L12 = (value)(L6[2]);
  L13 = (value)(L6[3]);
  goto LAB889;
LAB908:
  L14 = (value)(L6[1]);
  Abort(309, module_name);
LAB911:
  Abort(310, module_name);
LAB914:
  Abort(311, module_name);
LAB917:
  L15 = (value)(L6[1]);
  Abort(312, module_name);
LAB920:
  L16 = (value)(L6[1]);
  L17 = (value)(L6[2]);
  L18 = (value)(L6[3]);
  Minline_P_inline_called_functions_RULENR_RULENR(L4,L16);
  L64 = L4;
  L65 = L16;
  L66 = L5;
  L67 = L17;
  L68 = L18;
  Mrules_P_get_RULENR_MODULENR(L65,&L69);
  L70 = (value)G_inline_CURRENT_MODULE_NR8;
  if (!(L69 == L70)) goto LAB889;
  L71 = (value) Addr((value*)&G_inline_INLINABLE_NR7,Int(L65));
  L72 = *((value*)L71);
  ATTACH(L72);
  switch (Alternative(L72)) {
  case 0: goto LAB923;
  default: goto LAB924;
  };
LAB923:
if(DecrRefs(L72)<0)
XD_Minline_T8(L72);
  Mcode_P_new_LABEL(&L73);
  Minline_P_insert_function_RULENR_RULENR_LOCATION_ADDRESSES_SUCCEED_FAIL(L64,L65,L66,L67,L73,L68);
  Mcode_P_remove_goto_LABEL_LOCATION(L68,L66);
  Create(&L74,1,1);
  *(value *)(L74+1) = L73;
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L66,L74);
if(DecrRefs(L74)<0)
XD_Mcode_T14(L74);
  Mcode_P_register_label_LABEL_LOCATION(L73,L66);
  goto LAB889;
LAB924:
if(DecrRefs(L72)<0)
XD_Minline_T8(L72);
  goto LAB889;
LAB929:
  L19 = (value)(L6[1]);
  L20 = (value)(L6[2]);
  Minline_P_inline_called_functions_RULENR_RULENR(L4,L19);
  L75 = L4;
  L76 = L19;
  L77 = L5;
  L78 = L20;
  Mrules_P_get_RULENR_MODULENR(L76,&L79);
  L80 = (value)G_inline_CURRENT_MODULE_NR8;
  if (!(L79 == L80)) goto LAB889;
  L81 = (value) Addr((value*)&G_inline_INLINABLE_NR7,Int(L76));
  L82 = *((value*)L81);
  ATTACH(L82);
  switch (Alternative(L82)) {
  case 0: goto LAB932;
  default: goto LAB933;
  };
LAB932:
if(DecrRefs(L82)<0)
XD_Minline_T8(L82);
  Mcode_P_new_LABEL(&L83);
  Minline_P_insert_function_RULENR_RULENR_LOCATION_ADDRESSES_SUCCEED_FAIL(L75,L76,L77,L78,L83,L83);
  Create(&L84,1,1);
  *(value *)(L84+1) = L83;
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L77,L84);
if(DecrRefs(L84)<0)
XD_Mcode_T14(L84);
  Mcode_P_register_label_LABEL_LOCATION(L83,L77);
  goto LAB889;
LAB933:
if(DecrRefs(L82)<0)
XD_Minline_T8(L82);
  goto LAB889;
LAB938:
  L21 = (value)(L6[1]);
  goto LAB889;
LAB941:
  Abort(320, module_name);
LAB944:
  Abort(321, module_name);
LAB956:
  L22 = (value)(L6[1]);
  L23 = (value)(L6[2]);
  goto LAB889;
LAB959:
  L24 = (value)(L6[1]);
  goto LAB889;
LAB962:
  L25 = (value)(L6[1]);
  L26 = (value)(L6[2]);
  goto LAB889;
LAB965:
  L27 = (value)(L6[1]);
  goto LAB889;
LAB968:
  L28 = (value)(L6[1]);
  L29 = (value)(L6[2]);
  goto LAB889;
LAB971:
  L30 = (value)(L6[1]);
  L31 = (value)(L6[2]);
  L32 = (value)(L6[3]);
  goto LAB889;
LAB974:
  L33 = (value)(L6[1]);
  L34 = (value)(L6[2]);
  L35 = (value)(L6[3]);
  L36 = (value)(L6[4]);
  goto LAB889;
LAB977:
  L37 = (value)(L6[1]);
  L38 = (value)(L6[2]);
  L39 = (value)(L6[3]);
  goto LAB889;
LAB980:
  L40 = (value)(L6[1]);
  L41 = (value)(L6[2]);
  L42 = (value)(L6[3]);
  goto LAB889;
LAB983:
  L43 = (value)(L6[1]);
  L44 = (value)(L6[2]);
  L45 = (value)(L6[3]);
  goto LAB889;
LAB986:
  L46 = (value)(L6[1]);
  L47 = (value)(L6[2]);
  L48 = (value)(L6[3]);
  L49 = (value)(L6[4]);
  goto LAB889;
LAB989:
  L50 = (value)(L6[1]);
  L51 = (value)(L6[2]);
  L52 = (value)(L6[3]);
  goto LAB889;
LAB992:
  L53 = (value)(L6[1]);
  L54 = (value)(L6[2]);
  L55 = (value)(L6[3]);
  L56 = (value)(L6[4]);
  goto LAB889;
LAB995:
  L57 = (value)(L6[1]);
  L58 = (value)(L6[2]);
  goto LAB889;
LAB998:
  L59 = (value)(L6[1]);
  L60 = (value)(L6[2]);
  goto LAB889;
LAB1001:
  L61 = (value)(L6[1]);
  L62 = (value)(L6[2]);
  L63 = (value)(L6[3]);
LAB889:
if(DecrRefs(L2)<0)
XD_Mcode_T14(L2);
  L3 = L1;
  if (!Mcode_P_next_LOCATION(&L3)) goto LAB111;
  L1 = L3;
  goto LAB1004;
LAB1003:
  Abort(341, module_name);
LAB109:
if(DecrRefs(L2)<0)
XD_Mcode_T14(L2);
  return 1;
LAB111:
  return 1;
  return 1;
  return 1;
}

int Minline_P_inline_instruction_RULENR_LOCATION_INSTRUCTION(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L80;
  value L79;
  value L78;
  value L77;
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L2)) {
  case 0: goto LAB113;
  case 1: goto LAB116;
  case 2: goto LAB119;
  case 3: goto LAB122;
  case 4: goto LAB125;
  case 5: goto LAB128;
  case 6: goto LAB131;
  case 7: goto LAB134;
  case 8: goto LAB137;
  case 9: goto LAB140;
  case 10: goto LAB143;
  case 11: goto LAB146;
  case 12: goto LAB149;
  case 13: goto LAB152;
  case 14: goto LAB155;
  case 15: goto LAB158;
  case 16: goto LAB161;
  case 17: goto LAB164;
  case 18: goto LAB167;
  case 19: goto LAB170;
  case 20: goto LAB173;
  case 21: goto LAB176;
  case 22: goto LAB179;
  case 23: goto LAB182;
  case 24: goto LAB185;
  case 25: goto LAB188;
  case 26: goto LAB191;
  case 27: goto LAB194;
  case 29: goto LAB197;
  case 30: goto LAB200;
  case 31: goto LAB203;
  case 32: goto LAB206;
  case 33: goto LAB209;
  case 35: goto LAB212;
  default: goto LAB214;
  };
LAB113:
  return 1;
LAB116:
  L3 = (value)(L2[1]);
  return 1;
LAB119:
  L4 = (value)(L2[1]);
  L5 = (value)(L2[2]);
  L6 = (value)(L2[3]);
  Abort(305, module_name);
LAB122:
  Abort(306, module_name);
LAB125:
  L7 = (value)(L2[1]);
  L8 = (value)(L2[2]);
  L9 = (value)(L2[3]);
  return 1;
LAB128:
  return 0;
LAB131:
  L10 = (value)(L2[1]);
  Abort(309, module_name);
LAB134:
  Abort(310, module_name);
LAB137:
  Abort(311, module_name);
LAB140:
  L11 = (value)(L2[1]);
  Abort(312, module_name);
LAB143:
  L12 = (value)(L2[1]);
  L13 = (value)(L2[2]);
  L14 = (value)(L2[3]);
  Minline_P_inline_called_functions_RULENR_RULENR(L0,L12);
  L60 = L0;
  L61 = L12;
  L62 = L1;
  L63 = L13;
  L64 = L14;
  Mrules_P_get_RULENR_MODULENR(L61,&L65);
  L66 = (value)G_inline_CURRENT_MODULE_NR8;
  if (!(L65 == L66)) goto LAB877;
  L67 = (value) Addr((value*)&G_inline_INLINABLE_NR7,Int(L61));
  L68 = *((value*)L67);
  ATTACH(L68);
  switch (Alternative(L68)) {
  case 0: goto LAB879;
  default: goto LAB880;
  };
LAB879:
if(DecrRefs(L68)<0)
XD_Minline_T8(L68);
  Mcode_P_new_LABEL(&L69);
  Minline_P_insert_function_RULENR_RULENR_LOCATION_ADDRESSES_SUCCEED_FAIL(L60,L61,L62,L63,L69,L64);
  Mcode_P_remove_goto_LABEL_LOCATION(L64,L62);
  Create(&L70,1,1);
  *(value *)(L70+1) = L69;
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L62,L70);
if(DecrRefs(L70)<0)
XD_Mcode_T14(L70);
  Mcode_P_register_label_LABEL_LOCATION(L69,L62);
  return 1;
LAB880:
if(DecrRefs(L68)<0)
XD_Minline_T8(L68);
  return 1;
LAB877:
  return 1;
LAB146:
  L15 = (value)(L2[1]);
  L16 = (value)(L2[2]);
  Minline_P_inline_called_functions_RULENR_RULENR(L0,L15);
  L71 = L0;
  L72 = L15;
  L73 = L1;
  L74 = L16;
  Mrules_P_get_RULENR_MODULENR(L72,&L75);
  L76 = (value)G_inline_CURRENT_MODULE_NR8;
  if (!(L75 == L76)) goto LAB883;
  L77 = (value) Addr((value*)&G_inline_INLINABLE_NR7,Int(L72));
  L78 = *((value*)L77);
  ATTACH(L78);
  switch (Alternative(L78)) {
  case 0: goto LAB885;
  default: goto LAB886;
  };
LAB885:
if(DecrRefs(L78)<0)
XD_Minline_T8(L78);
  Mcode_P_new_LABEL(&L79);
  Minline_P_insert_function_RULENR_RULENR_LOCATION_ADDRESSES_SUCCEED_FAIL(L71,L72,L73,L74,L79,L79);
  Create(&L80,1,1);
  *(value *)(L80+1) = L79;
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L73,L80);
if(DecrRefs(L80)<0)
XD_Mcode_T14(L80);
  Mcode_P_register_label_LABEL_LOCATION(L79,L73);
  return 1;
LAB886:
if(DecrRefs(L78)<0)
XD_Minline_T8(L78);
  return 1;
LAB883:
  return 1;
LAB149:
  L17 = (value)(L2[1]);
  return 1;
LAB152:
  Abort(320, module_name);
LAB155:
  Abort(321, module_name);
LAB158:
  return 1;
LAB161:
  return 1;
LAB164:
  return 1;
LAB167:
  L18 = (value)(L2[1]);
  L19 = (value)(L2[2]);
  return 1;
LAB170:
  L20 = (value)(L2[1]);
  return 1;
LAB173:
  L21 = (value)(L2[1]);
  L22 = (value)(L2[2]);
  return 1;
LAB176:
  L23 = (value)(L2[1]);
  return 1;
LAB179:
  L24 = (value)(L2[1]);
  L25 = (value)(L2[2]);
  return 1;
LAB182:
  L26 = (value)(L2[1]);
  L27 = (value)(L2[2]);
  L28 = (value)(L2[3]);
  return 1;
LAB185:
  L29 = (value)(L2[1]);
  L30 = (value)(L2[2]);
  L31 = (value)(L2[3]);
  L32 = (value)(L2[4]);
  return 1;
LAB188:
  L33 = (value)(L2[1]);
  L34 = (value)(L2[2]);
  L35 = (value)(L2[3]);
  return 1;
LAB191:
  L36 = (value)(L2[1]);
  L37 = (value)(L2[2]);
  L38 = (value)(L2[3]);
  return 1;
LAB194:
  L39 = (value)(L2[1]);
  L40 = (value)(L2[2]);
  L41 = (value)(L2[3]);
  return 1;
LAB197:
  L42 = (value)(L2[1]);
  L43 = (value)(L2[2]);
  L44 = (value)(L2[3]);
  L45 = (value)(L2[4]);
  return 1;
LAB200:
  L46 = (value)(L2[1]);
  L47 = (value)(L2[2]);
  L48 = (value)(L2[3]);
  return 1;
LAB203:
  L49 = (value)(L2[1]);
  L50 = (value)(L2[2]);
  L51 = (value)(L2[3]);
  L52 = (value)(L2[4]);
  return 1;
LAB206:
  L53 = (value)(L2[1]);
  L54 = (value)(L2[2]);
  return 1;
LAB209:
  L55 = (value)(L2[1]);
  L56 = (value)(L2[2]);
  return 1;
LAB212:
  L57 = (value)(L2[1]);
  L58 = (value)(L2[2]);
  L59 = (value)(L2[3]);
  return 1;
LAB214:
  Abort(341, module_name);
}

int Minline_P_inline_called_functions_RULENR_RULENR(P0,P1)
value P0;
value P1;
{
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  if (!(L0 == L1)) goto LAB216;
  return 1;
LAB216:
  L2 = (value) Addr((value*)&G_inline_INLINED_NR6,Int(L1));
  L3 = *((value*)L2);
  ATTACH(L3);
  switch (Alternative(L3)) {
  case 0: goto LAB217;
  default: goto LAB218;
  };
LAB217:
if(DecrRefs(L3)<0)
XD_Minline_T7(L3);
  return 1;
LAB218:
if(DecrRefs(L3)<0)
XD_Minline_T7(L3);
LAB219:
  Minline_P_inline_rule_RULENR(L1);
  L4 = L1;
  L5 = (value) Addr((value*)&G_inline_INLINABLE_NR7,Int(L4));
  L6 = *((value*)L5);
  ATTACH(L6);
  switch (Alternative(L6)) {
  case 2: goto LAB714;
  default: goto LAB715;
  };
LAB714:
if(DecrRefs(L6)<0)
XD_Minline_T8(L6);
  if (!Mrules_P_is_external_RULENR_EXTNR(L4,&L7)) goto LAB718;
if(DecrRefs(L7)<0)
XD_Mrules_T19(L7);
  L8 = G_inline_INLINABLE_NR2920;
  ATTACH(L8);
if(DecrRefs(*((value*)L5))<0)
XD_Minline_T8(*((value*)L5));
  *((value *)L5) = L8;
  return 1;
LAB715:
if(DecrRefs(L6)<0)
XD_Minline_T8(L6);
  return 1;
LAB718:
  L9 = (value) Addr((value*)&G_inline_RULE_CALLED_BY_NR2,Int(L4));
  L10 = *((value*)L9);
  ATTACH(L10);
  switch (Alternative(L10)) {
  case 0: goto LAB719;
  default: goto LAB720;
  };
LAB719:
  L11 = (value)(L10[1]);
  L12 = (value)(L10[2]);
  switch (Alternative(L12)) {
  case 1: goto LAB721;
  default: goto LAB722;
  };
LAB721:
if(DecrRefs(L10)<0)
XD_Mrules_T3(L10);
  L13 = G_inline_INLINABLE_NR2921;
  ATTACH(L13);
if(DecrRefs(*((value*)L5))<0)
XD_Minline_T8(*((value*)L5));
  *((value *)L5) = L13;
  return 1;
LAB720:
if(DecrRefs(L10)<0)
XD_Mrules_T3(L10);
  goto LAB723;
LAB722:
if(DecrRefs(L10)<0)
XD_Mrules_T3(L10);
LAB723:
  L16 = L4;
  L17 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L16));
  L18 = *((value*)L17);
  switch (Alternative(L18)) {
  case 0: goto LAB725;
  default: goto LAB732;
  };
LAB725:
  L19 = (value)(L18[1]);
  L20 = (value)(L18[2]);
  L21 = (value)G_inline_SMALL_LIMIT_NR11;
  if (!Minline_P_small_rule_INT_LOCATION_LOCATION_RULENR(L21,L19,L20,L16)) goto LAB732;
LAB728:
  L14 = G_inline_INLINABLE_NR2922;
  ATTACH(L14);
if(DecrRefs(*((value*)L5))<0)
XD_Minline_T8(*((value*)L5));
  *((value *)L5) = L14;
  return 1;
LAB732:
  L15 = G_inline_INLINABLE_NR2923;
  ATTACH(L15);
if(DecrRefs(*((value*)L5))<0)
XD_Minline_T8(*((value*)L5));
  *((value *)L5) = L15;
  return 1;
  return 1;
}

int Minline_P_one_caller_RULENR_RULENRS(P0,P1)
value P0;
value P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Minline_P_count_callers_RULENR_RULENRS_INT(L0,L1,&L2);
  switch (Int(L2)) {
  case 1: goto LAB233;
  default: goto LAB234;
  };
LAB233:
  return 1;
LAB234:
  return 0;
  return 0;
}

int Minline_P_count_callers_RULENR_RULENRS_INT(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  switch (Alternative(L1)) {
  case 1: goto LAB236;
  case 0: goto LAB239;
  default: goto LAB241;
  };
LAB236:
  L2 = C_INT(0);
  *P2 = L2;
  return 1;
LAB239:
  L3 = (value)(L1[1]);
  L4 = (value)(L1[2]);
  Minline_P_count_callers_RULENR_RULENRS_INT(L0,L4,&L5);
  if (!(L3 == L0)) goto LAB243;
  *P2 = L5;
  return 1;
LAB243:
  L6 = C_INT(1);
  L7 = C_INT(Int(L5) + Int(L6));
  *P2 = L7;
  return 1;
LAB241:
  Abort(377, module_name);
}

int Minline_P_small_rule_INT_LOCATION_LOCATION_RULENR(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value P3;
{
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
LAB706:
  L4 = C_INT(-1);
  if (!(L0 == L4)) goto LAB252;
  return 0;
LAB252:
  if (!(L1 == L2)) goto LAB254;
  return 1;
LAB254:
  Mcode_P_get_LOCATION_INSTRUCTION(L1,&L5);
  switch (Alternative(L5)) {
  case 11: goto LAB255;
  case 10: goto LAB264;
  default: goto LAB266;
  };
LAB255:
  L6 = (value)(L5[1]);
  L7 = (value)(L5[2]);
  if (!(L3 == L6)) goto LAB259;
if(DecrRefs(L5)<0)
XD_Mcode_T14(L5);
  return 0;
LAB259:
  L8 = L1;
  if (!Mcode_P_next_LOCATION(&L8)) goto LAB260;
  L9 = C_INT(1);
  L10 = C_INT(Int(L0) - Int(L9));
  L1 = L8;
  L0 = L10;
  goto LAB706;
LAB260:
  return 1;
  return 0;
  return 1;
LAB264:
  L11 = (value)(L5[1]);
  L12 = (value)(L5[2]);
  L13 = (value)(L5[3]);
  if (!(L3 == L11)) goto LAB268;
if(DecrRefs(L5)<0)
XD_Mcode_T14(L5);
  return 0;
LAB268:
  L14 = L1;
  if (!Mcode_P_next_LOCATION(&L14)) goto LAB269;
  L15 = C_INT(1);
  L16 = C_INT(Int(L0) - Int(L15));
  L1 = L14;
  L0 = L16;
  goto LAB706;
LAB269:
  return 1;
  return 0;
  return 1;
LAB266:
if(DecrRefs(L5)<0)
XD_Mcode_T14(L5);
  L17 = L1;
  if (!Mcode_P_next_LOCATION(&L17)) goto LAB273;
  L1 = L17;
  goto LAB706;
LAB273:
  return 1;
  return 0;
  return 1;
}

int Minline_P_insert_function_RULENR_RULENR_LOCATION_ADDRESSES_SUCCEED_FAIL(P0,P1,P2,P3,P4,P5)
value P0;
value P1;
value P2;
value P3;
value P4;
value P5;
{
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L4 = P4;
  L5 = P5;
  L6 = (value)G_inline_COUNT_NR10;
  L7 = C_INT(1);
  L8 = C_INT(Int(L6) + Int(L7));
  G_inline_COUNT_NR10 = (long)L8;
  L17 = L0;
  L18 = L1;
  L19 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L17));
  L20 = *((value*)L19);
  ATTACH(L20);
  switch (Alternative(L20)) {
  case 0: goto LAB734;
  default: goto LAB735;
  };
LAB734:
  L21 = (value)(L20[1]);
  L22 = (value)(L20[2]);
  Mcode_P_get_LOCATION_INSTRUCTION(L21,&L23);
if(DecrRefs(L20)<0)
XD_Minline_T5(L20);
  switch (Alternative(L23)) {
  case 4: goto LAB736;
  default: goto LAB740;
  };
LAB736:
  L24 = (value)(L23[1]);
  L25 = (value)(L23[2]);
  L26 = (value)(L23[3]);
  L27 = (value) Addr((value*)&G_inline_MAX_FRAME_NR5,Int(L18));
  L28 = *((value*)L27);
  L29 = C_INT(Int(L25) + Int(L28));
  L30 = (value) Addr((value*)&G_inline_MAX_FRAME_NR5,Int(L17));
  L31 = *((value*)L30);
  if (!E40_less_INT_INT(L31,L29)) goto LAB738;
  *((value *)L30) = L29;
  L9 = L25;
if(DecrRefs(L23)<0)
XD_Mcode_T14(L23);
  goto LAB733;
LAB735:
if(DecrRefs(L20)<0)
XD_Minline_T5(L20);
LAB739:
  L32 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L17));
  L33 = *((value*)L32);
  ATTACH(L33);
  switch (Alternative(L33)) {
  case 2: goto LAB742;
  default: goto LAB743;
  };
LAB738:
LAB741:
  L9 = L25;
if(DecrRefs(L23)<0)
XD_Mcode_T14(L23);
LAB733:
  L10 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L1));
  L11 = *((value*)L10);
  ATTACH(L11);
  switch (Alternative(L11)) {
  case 0: goto LAB287;
  default: goto LAB288;
  };
LAB740:
if(DecrRefs(L23)<0)
XD_Mcode_T14(L23);
  Abort(460, module_name);
LAB742:
  L34 = (value)(L33[1]);
if(DecrRefs(L33)<0)
XD_Minline_T5(L33);
  Abort(461, module_name);
LAB743:
if(DecrRefs(L33)<0)
XD_Minline_T5(L33);
  Abort(462, module_name);
  Abort(462, module_name);
LAB287:
  L12 = (value)(L11[1]);
  L13 = (value)(L11[2]);
  L14 = G_inline_NEW_LABELS_NR2924;
  Minline_P_insert_function_LOCATION_LOCATION_ADDRESSES_ADJUST_SUCCEED_FAIL_NEW_LABELS(L2,L12,L3,L9,L4,L5,L14);
if(DecrRefs(L11)<0)
XD_Minline_T5(L11);
  L35 = L0;
  L36 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L35));
  L37 = *((value*)L36);
  ATTACH(L37);
  switch (Alternative(L37)) {
  case 0: goto LAB861;
  default: goto LAB862;
  };
LAB861:
  L38 = (value)(L37[1]);
  L39 = (value)(L37[2]);
  Mcode_P_get_LOCATION_INSTRUCTION(L38,&L40);
  switch (Alternative(L40)) {
  case 4: goto LAB863;
  default: goto LAB866;
  };
LAB863:
  L41 = (value)(L40[1]);
  L42 = (value)(L40[2]);
  L43 = (value)(L40[3]);
  Create(&L44,4,3);
  *(value *)(L44+1) = L41;
  L45 = (value) Addr((value*)&G_inline_MAX_FRAME_NR5,Int(L41));
  L46 = *((value*)L45);
  *(value *)(L44+2) = L46;
  *(value *)(L44+3) = L43;
if(DecrRefs(L40)<0)
XD_Mcode_T14(L40);
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L38,L44);
if(DecrRefs(L44)<0)
XD_Mcode_T14(L44);
if(DecrRefs(L37)<0)
XD_Minline_T5(L37);
  return 1;
LAB862:
if(DecrRefs(L37)<0)
XD_Minline_T5(L37);
  Abort(470, module_name);
LAB866:
if(DecrRefs(L40)<0)
XD_Mcode_T14(L40);
if(DecrRefs(L37)<0)
XD_Minline_T5(L37);
  Abort(469, module_name);
  Abort(470, module_name);
  return 1;
LAB288:
if(DecrRefs(L11)<0)
XD_Minline_T5(L11);
LAB289:
  L15 = (value) Addr((value*)&G_inline_HEADERS_NR4,Int(L1));
  L16 = *((value*)L15);
  ATTACH(L16);
  L47 = L16;
  switch (Alternative(L47)) {
  case 1: goto LAB868;
  case 2: goto LAB871;
  case 0: goto LAB874;
  default: goto LAB876;
  };
LAB868:
  L48 = G_inline_TEXT_NR2925;
  Merrors_P_error_text_TEXT(L48);
  goto LAB867;
LAB871:
  L49 = (value)(L47[1]);
  L50 = G_inline_TEXT_NR2926;
  Merrors_P_error_text_TEXT(L50);
  Merrors_P_error_int_INT(L49);
  L51 = G_inline_TEXT_NR2927;
  Merrors_P_error_text_TEXT(L51);
  goto LAB867;
LAB874:
  L52 = (value)(L47[1]);
  L53 = (value)(L47[2]);
  L54 = G_inline_TEXT_NR2928;
  Merrors_P_error_text_TEXT(L54);
LAB867:
if(DecrRefs(L16)<0)
XD_Minline_T5(L16);
  Mrules_P_error_RULENR(L0);
  Abort(440, module_name);
LAB876:
  Abort(446, module_name);
}

int Minline_P_insert_function_LOCATION_LOCATION_ADDRESSES_ADJUST_SUCCEED_FAIL_NEW_LABELS(P0,P1,P2,P3,P4,P5,P6)
value P0;
value P1;
value P2;
value P3;
value P4;
value P5;
value P6;
{
  value L127;
  value L126;
  value L125;
  value L124;
  value L123;
  value L122;
  value L121;
  value L120;
  value L119;
  value L118;
  value L117;
  value L116;
  value L115;
  value L114;
  value L113;
  value L112;
  value L111;
  value L110;
  value L109;
  value L108;
  value L107;
  value L106;
  value L105;
  value L104;
  value L103;
  value L102;
  value L101;
  value L100;
  value L99;
  value L98;
  value L97;
  value L96;
  value L95;
  value L94;
  value L93;
  value L92;
  value L91;
  value L90;
  value L89;
  value L88;
  value L87;
  value L86;
  value L85;
  value L84;
  value L83;
  value L82;
  value L81;
  value L80;
  value L79;
  value L78;
  value L77;
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L4 = P4;
  L5 = P5;
  L6 = P6;
  Mcode_P_get_LOCATION_INSTRUCTION(L1,&L7);
  L8 = L6;
  ATTACH(L8);
  L10 = L0;
  L11 = L7;
  L12 = L2;
  L13 = L3;
  L14 = L4;
  L15 = L5;
  L16 = L8;
  switch (Alternative(L11)) {
  case 0: goto LAB755;
  case 1: goto LAB758;
  case 2: goto LAB761;
  case 3: goto LAB764;
  case 4: goto LAB767;
  case 5: goto LAB316;
  case 6: goto LAB773;
  case 7: goto LAB776;
  case 8: goto LAB779;
  case 9: goto LAB782;
  case 10: goto LAB785;
  case 11: goto LAB788;
  case 12: goto LAB791;
  case 13: goto LAB794;
  case 14: goto LAB797;
  case 15: goto LAB800;
  case 16: goto LAB803;
  case 17: goto LAB806;
  case 18: goto LAB809;
  case 19: goto LAB812;
  case 20: goto LAB815;
  case 21: goto LAB818;
  case 22: goto LAB821;
  case 23: goto LAB824;
  case 24: goto LAB827;
  case 25: goto LAB830;
  case 26: goto LAB833;
  case 27: goto LAB836;
  case 28: goto LAB839;
  case 29: goto LAB842;
  case 30: goto LAB845;
  case 31: goto LAB848;
  case 32: goto LAB851;
  case 33: goto LAB854;
  case 35: goto LAB857;
  default: goto LAB859;
  };
LAB755:
  L8 = L16;
  goto LAB754;
LAB758:
  L17 = (value)(L11[1]);
  L18 = L17;
  L19 = L16;
  Minline_P_replace_LABEL_NEW_LABELS(&L18,&L19);
  Create(&L20,1,1);
  *(value *)(L20+1) = L18;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L20);
if(DecrRefs(L20)<0)
XD_Mcode_T14(L20);
  Mcode_P_register_label_LABEL(L18);
  L8 = L19;
  goto LAB754;
LAB761:
if(DecrRefs(L16)<0)
XD_Minline_T49(L16);
  L21 = (value)(L11[1]);
  L22 = (value)(L11[2]);
  L23 = (value)(L11[3]);
  Abort(495, module_name);
LAB764:
if(DecrRefs(L16)<0)
XD_Minline_T49(L16);
  Abort(496, module_name);
LAB767:
  L24 = (value)(L11[1]);
  L25 = (value)(L11[2]);
  L26 = (value)(L11[3]);
  L8 = L16;
  goto LAB754;
LAB773:
if(DecrRefs(L16)<0)
XD_Minline_T49(L16);
  L27 = (value)(L11[1]);
  Abort(499, module_name);
LAB776:
if(DecrRefs(L16)<0)
XD_Minline_T49(L16);
  Abort(500, module_name);
LAB779:
if(DecrRefs(L16)<0)
XD_Minline_T49(L16);
  Abort(501, module_name);
LAB782:
if(DecrRefs(L16)<0)
XD_Minline_T49(L16);
  L28 = (value)(L11[1]);
  Abort(502, module_name);
LAB785:
  L29 = (value)(L11[1]);
  L30 = (value)(L11[2]);
  L31 = (value)(L11[3]);
  L32 = L31;
  L33 = L16;
  Minline_P_replace_LABEL_NEW_LABELS(&L32,&L33);
  L34 = L30;
  ATTACH(L34);
  Minline_P_replace_ADDRESSES_ADDRESSES_ADJUST(&L34,L12,L13);
  Create(&L35,10,3);
  *(value *)(L35+1) = L29;
  *(value *)(L35+2) = L34;
  *(value *)(L35+3) = L32;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L35);
if(DecrRefs(L35)<0)
XD_Mcode_T14(L35);
  Mcode_P_register_goto_LABEL(L32);
  L8 = L33;
  goto LAB754;
LAB788:
  L36 = (value)(L11[1]);
  L37 = (value)(L11[2]);
  L38 = L37;
  ATTACH(L38);
  Minline_P_replace_ADDRESSES_ADDRESSES_ADJUST(&L38,L12,L13);
  Create(&L39,11,2);
  *(value *)(L39+1) = L36;
  *(value *)(L39+2) = L38;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L39);
if(DecrRefs(L39)<0)
XD_Mcode_T14(L39);
  L8 = L16;
  goto LAB754;
LAB791:
  L40 = (value)(L11[1]);
  L41 = L40;
  L42 = L16;
  Minline_P_replace_LABEL_NEW_LABELS(&L41,&L42);
  Create(&L43,12,1);
  *(value *)(L43+1) = L41;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L43);
if(DecrRefs(L43)<0)
XD_Mcode_T14(L43);
  Mcode_P_register_goto_LABEL(L41);
  L8 = L42;
  goto LAB754;
LAB794:
if(DecrRefs(L16)<0)
XD_Minline_T49(L16);
  Abort(515, module_name);
LAB797:
if(DecrRefs(L16)<0)
XD_Minline_T49(L16);
  Abort(516, module_name);
LAB800:
  Create(&L44,12,1);
  *(value *)(L44+1) = L14;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L44);
if(DecrRefs(L44)<0)
XD_Mcode_T14(L44);
  Mcode_P_register_goto_LABEL(L14);
  L8 = L16;
  goto LAB754;
LAB803:
  Create(&L45,12,1);
  *(value *)(L45+1) = L15;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L45);
if(DecrRefs(L45)<0)
XD_Mcode_T14(L45);
  Mcode_P_register_goto_LABEL(L15);
  L8 = L16;
  goto LAB754;
LAB806:
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L11);
  L8 = L16;
  goto LAB754;
LAB809:
  L46 = (value)(L11[1]);
  L47 = (value)(L11[2]);
  L48 = L47;
  ATTACH(L48);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L48,L12,L13);
  Create(&L49,18,2);
  *(value *)(L49+1) = L46;
  ATTACH(L46);
  *(value *)(L49+2) = L48;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L49);
if(DecrRefs(L49)<0)
XD_Mcode_T14(L49);
  L8 = L16;
  goto LAB754;
LAB812:
  L50 = (value)(L11[1]);
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L11);
  L8 = L16;
  goto LAB754;
LAB815:
  L51 = (value)(L11[1]);
  L52 = (value)(L11[2]);
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L11);
  L8 = L16;
  goto LAB754;
LAB818:
  L53 = (value)(L11[1]);
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L11);
  L8 = L16;
  goto LAB754;
LAB821:
  L54 = (value)(L11[1]);
  L55 = (value)(L11[2]);
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L11);
  L8 = L16;
  goto LAB754;
LAB824:
  L56 = (value)(L11[1]);
  L57 = (value)(L11[2]);
  L58 = (value)(L11[3]);
  L59 = L56;
  ATTACH(L59);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L59,L12,L13);
  L60 = L57;
  ATTACH(L60);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L60,L12,L13);
  L61 = L58;
  ATTACH(L61);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L61,L12,L13);
  Create(&L62,23,3);
  *(value *)(L62+1) = L59;
  *(value *)(L62+2) = L60;
  *(value *)(L62+3) = L61;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L62);
if(DecrRefs(L62)<0)
XD_Mcode_T14(L62);
  L8 = L16;
  goto LAB754;
LAB827:
  L63 = (value)(L11[1]);
  L64 = (value)(L11[2]);
  L65 = (value)(L11[3]);
  L66 = (value)(L11[4]);
  L67 = L63;
  ATTACH(L67);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L67,L12,L13);
  L68 = L65;
  ATTACH(L68);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L68,L12,L13);
  L69 = L66;
  ATTACH(L69);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L69,L12,L13);
  Create(&L70,24,4);
  *(value *)(L70+1) = L67;
  *(value *)(L70+2) = L64;
  ATTACH(L64);
  *(value *)(L70+3) = L68;
  *(value *)(L70+4) = L69;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L70);
if(DecrRefs(L70)<0)
XD_Mcode_T14(L70);
  L8 = L16;
  goto LAB754;
LAB830:
  L71 = (value)(L11[1]);
  L72 = (value)(L11[2]);
  L73 = (value)(L11[3]);
  L74 = L72;
  ATTACH(L74);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L74,L12,L13);
  L75 = L73;
  ATTACH(L75);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L75,L12,L13);
  Create(&L76,25,3);
  *(value *)(L76+1) = L71;
  ATTACH(L71);
  *(value *)(L76+2) = L74;
  *(value *)(L76+3) = L75;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L76);
if(DecrRefs(L76)<0)
XD_Mcode_T14(L76);
  L8 = L16;
  goto LAB754;
LAB833:
  L77 = (value)(L11[1]);
  L78 = (value)(L11[2]);
  L79 = (value)(L11[3]);
  L80 = L77;
  ATTACH(L80);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L80,L12,L13);
  L81 = L78;
  ATTACH(L81);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L81,L12,L13);
  L82 = C_INT(Int(L79) + Int(L13));
  Create(&L83,26,3);
  *(value *)(L83+1) = L80;
  *(value *)(L83+2) = L81;
  *(value *)(L83+3) = L82;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L83);
if(DecrRefs(L83)<0)
XD_Mcode_T14(L83);
  L8 = L16;
  goto LAB754;
LAB836:
  L84 = (value)(L11[1]);
  L85 = (value)(L11[2]);
  L86 = (value)(L11[3]);
  L87 = L84;
  ATTACH(L87);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L87,L12,L13);
  L88 = L86;
  ATTACH(L88);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L88,L12,L13);
  Create(&L89,27,3);
  *(value *)(L89+1) = L87;
  *(value *)(L89+2) = L85;
  *(value *)(L89+3) = L88;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L89);
if(DecrRefs(L89)<0)
XD_Mcode_T14(L89);
  L8 = L16;
  goto LAB754;
LAB839:
  L90 = (value)(L11[1]);
  L91 = (value)(L11[2]);
  L92 = L90;
  ATTACH(L92);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L92,L12,L13);
  L93 = L91;
  ATTACH(L93);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L93,L12,L13);
  Create(&L94,28,2);
  *(value *)(L94+1) = L92;
  *(value *)(L94+2) = L93;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L94);
if(DecrRefs(L94)<0)
XD_Mcode_T14(L94);
  L8 = L16;
  goto LAB754;
LAB842:
  L95 = (value)(L11[1]);
  L96 = (value)(L11[2]);
  L97 = (value)(L11[3]);
  L98 = (value)(L11[4]);
  L99 = L95;
  ATTACH(L99);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L99,L12,L13);
  L100 = L97;
  ATTACH(L100);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L100,L12,L13);
  L101 = L98;
  L102 = L16;
  Minline_P_replace_LABEL_NEW_LABELS(&L101,&L102);
  Create(&L103,29,4);
  *(value *)(L103+1) = L99;
  *(value *)(L103+2) = L96;
  *(value *)(L103+3) = L100;
  *(value *)(L103+4) = L101;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L103);
if(DecrRefs(L103)<0)
XD_Mcode_T14(L103);
  Mcode_P_register_goto_LABEL(L101);
  L8 = L102;
  goto LAB754;
LAB845:
  L104 = (value)(L11[1]);
  L105 = (value)(L11[2]);
  L106 = (value)(L11[3]);
  L107 = L104;
  ATTACH(L107);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L107,L12,L13);
  L108 = L106;
  ATTACH(L108);
  L109 = L16;
  Minline_P_replace_LABELS_NEW_LABELS(&L108,&L109);
  Create(&L110,30,3);
  *(value *)(L110+1) = L107;
  *(value *)(L110+2) = L105;
  *(value *)(L110+3) = L108;
  ATTACH(L108);
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L110);
if(DecrRefs(L110)<0)
XD_Mcode_T14(L110);
  Mcode_P_register_goto_LABELS(L108);
if(DecrRefs(L108)<0)
XD_Mcode_T18(L108);
  L8 = L109;
  goto LAB754;
LAB848:
  L111 = (value)(L11[1]);
  L112 = (value)(L11[2]);
  L113 = (value)(L11[3]);
  L114 = (value)(L11[4]);
  L115 = L111;
  ATTACH(L115);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L115,L12,L13);
  Create(&L116,31,4);
  *(value *)(L116+1) = L115;
  *(value *)(L116+2) = L112;
  *(value *)(L116+3) = L113;
  *(value *)(L116+4) = L114;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L116);
if(DecrRefs(L116)<0)
XD_Mcode_T14(L116);
  L8 = L16;
  goto LAB754;
LAB851:
  L117 = (value)(L11[1]);
  L118 = (value)(L11[2]);
  L119 = L117;
  ATTACH(L119);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L119,L12,L13);
  Create(&L120,32,2);
  *(value *)(L120+1) = L119;
  *(value *)(L120+2) = L118;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L120);
if(DecrRefs(L120)<0)
XD_Mcode_T14(L120);
  L8 = L16;
  goto LAB754;
LAB854:
  L121 = (value)(L11[1]);
  L122 = (value)(L11[2]);
  L123 = L121;
  ATTACH(L123);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L123,L12,L13);
  Create(&L124,33,2);
  *(value *)(L124+1) = L123;
  *(value *)(L124+2) = L122;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L124);
if(DecrRefs(L124)<0)
XD_Mcode_T14(L124);
  L8 = L16;
  goto LAB754;
LAB857:
  L125 = (value)(L11[1]);
  L126 = (value)(L11[2]);
  L127 = (value)(L11[3]);
  Mcode_P_prepend_LOCATION_INSTRUCTION(L10,L11);
  L8 = L16;
LAB754:
if(DecrRefs(L7)<0)
XD_Mcode_T14(L7);
  L9 = L1;
  if (!Mcode_P_next_LOCATION(&L9)) goto LAB318;
  Minline_P_insert_function_LOCATION_LOCATION_ADDRESSES_ADJUST_SUCCEED_FAIL_NEW_LABELS(L0,L9,L2,L3,L4,L5,L8);
if(DecrRefs(L8)<0)
XD_Minline_T49(L8);
  return 1;
LAB859:
if(DecrRefs(L16)<0)
XD_Minline_T49(L16);
  Abort(585, module_name);
LAB316:
if(DecrRefs(L8)<0)
XD_Minline_T49(L8);
if(DecrRefs(L7)<0)
XD_Mcode_T14(L7);
  return 1;
LAB318:
LAB319:
if(DecrRefs(L8)<0)
XD_Minline_T49(L8);
  return 1;
  return 1;
}

int Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(P0,P1,P2)
value *P0;
value P1;
value P2;
{
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L0)) {
  case 2: goto LAB425;
  case 3: goto LAB428;
  case 4: goto LAB431;
  case 6: goto LAB434;
  case 10: goto LAB437;
  case 11: goto LAB440;
  case 13: goto LAB443;
  default: goto LAB445;
  };
LAB425:
  L3 = (value)(L0[1]);
  L4 = C_INT(Int(L3) + Int(L2));
if(DecrRefs(L0)<0)
XD_Mcode_T20(L0);
  Create(&L5,2,1);
  *(value *)(L5+1) = L4;
  *P0 = L5;
  return 1;
LAB428:
  L6 = (value)(L0[1]);
if(DecrRefs(L0)<0)
XD_Mcode_T20(L0);
  Abort(591, module_name);
LAB431:
  L7 = (value)(L0[1]);
  L20 = L1;
  L21 = L7;
LAB747:
  switch (Alternative(L20)) {
  case 0: goto LAB748;
  default: goto LAB752;
  };
LAB748:
  L22 = (value)(L20[1]);
  L23 = (value)(L20[2]);
  switch (Int(L21)) {
  case 0: goto LAB750;
  default: goto LAB753;
  };
LAB750:
  L8 = L22;
  ATTACH(L22);
LAB746:
if(DecrRefs(L0)<0)
XD_Mcode_T20(L0);
  *P0 = L8;
  return 1;
LAB753:
  L24 = C_INT(1);
  L25 = C_INT(Int(L21) - Int(L24));
  L21 = L25;
  L20 = L23;
  goto LAB747;
LAB752:
  Abort(640, module_name);
LAB434:
  L9 = (value)(L0[1]);
if(DecrRefs(L0)<0)
XD_Mcode_T20(L0);
  Abort(594, module_name);
LAB437:
  L10 = (value)(L0[1]);
  L11 = (value)(L0[2]);
  L12 = L10;
  ATTACH(L12);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L12,L1,L2);
  Create(&L13,10,2);
  *(value *)(L13+1) = L12;
  *(value *)(L13+2) = L11;
if(DecrRefs(L0)<0)
XD_Mcode_T20(L0);
  *P0 = L13;
  return 1;
LAB440:
  L14 = (value)(L0[1]);
  L15 = L14;
  ATTACH(L15);
if(DecrRefs(L0)<0)
XD_Mcode_T20(L0);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L15,L1,L2);
  Create(&L16,11,1);
  *(value *)(L16+1) = L15;
  *P0 = L16;
  return 1;
LAB443:
  L17 = (value)(L0[1]);
  L18 = C_INT(Int(L17) + Int(L2));
if(DecrRefs(L0)<0)
XD_Mcode_T20(L0);
  Create(&L19,13,1);
  *(value *)(L19+1) = L18;
  *P0 = L19;
  return 1;
LAB445:
  *P0 = L0;
  return 1;
}

int Minline_P_replace_ADDRESSES_ADDRESSES_ADJUST(P0,P1,P2)
value *P0;
value P1;
value P2;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L0)) {
  case 2: goto LAB446;
  case 0: goto LAB449;
  default: goto LAB451;
  };
LAB446:
  *P0 = L0;
  return 1;
LAB449:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  L5 = L3;
  ATTACH(L5);
  Minline_P_replace_ADDRESS_ADDRESSES_ADJUST(&L5,L1,L2);
  L6 = L4;
  ATTACH(L6);
if(DecrRefs(L0)<0)
XD_Mcode_T19(L0);
  Minline_P_replace_ADDRESSES_ADDRESSES_ADJUST(&L6,L1,L2);
  Create(&L7,0,2);
  *(value *)(L7+1) = L5;
  *(value *)(L7+2) = L6;
  *P0 = L7;
  return 1;
LAB451:
if(DecrRefs(L0)<0)
XD_Mcode_T19(L0);
  Abort(612, module_name);
}

int Minline_P_replace_LABEL_NEW_LABELS(P0,P1)
value *P0;
value *P1;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = *P1;
  switch (Alternative(L1)) {
  case 0: goto LAB452;
  case 1: goto LAB455;
  default: goto LAB457;
  };
LAB452:
if(DecrRefs(L1)<0)
XD_Minline_T49(L1);
  Mcode_P_new_LABEL(&L2);
  Create(&L3,1,3);
  *(value *)(L3+1) = L0;
  *(value *)(L3+2) = L2;
  L4 = G_inline_NEW_LABELS_NR2929;
  *(value *)(L3+3) = L4;
  ATTACH(L4);
  *P1 = L3;
  *P0 = L2;
  return 1;
LAB455:
  L5 = (value)(L1[1]);
  L6 = (value)(L1[2]);
  L7 = (value)(L1[3]);
  if (!(L5 == L0)) goto LAB459;
  *P1 = L1;
  ATTACH(L1);
  *P0 = L6;
if(DecrRefs(L1)<0)
XD_Minline_T49(L1);
  return 1;
LAB459:
  L8 = L0;
  L9 = L7;
  ATTACH(L9);
  Minline_P_replace_LABEL_NEW_LABELS(&L8,&L9);
  Create(&L10,1,3);
  *(value *)(L10+1) = L5;
  *(value *)(L10+2) = L6;
if(DecrRefs(L1)<0)
XD_Minline_T49(L1);
  *(value *)(L10+3) = L9;
  *P1 = L10;
  *P0 = L8;
  return 1;
LAB457:
if(DecrRefs(L1)<0)
XD_Minline_T49(L1);
  Abort(624, module_name);
}

int Minline_P_replace_LABELS_NEW_LABELS(P0,P1)
value *P0;
value *P1;
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = *P1;
  switch (Alternative(L0)) {
  case 1: goto LAB460;
  case 0: goto LAB463;
  default: goto LAB465;
  };
LAB460:
  L2 = (value)(L0[1]);
  L3 = L2;
if(DecrRefs(L0)<0)
XD_Mcode_T18(L0);
  L4 = L1;
  Minline_P_replace_LABEL_NEW_LABELS(&L3,&L4);
  Create(&L5,1,1);
  *(value *)(L5+1) = L3;
  *P1 = L4;
  *P0 = L5;
  return 1;
LAB463:
  L6 = (value)(L0[1]);
  L7 = (value)(L0[2]);
  L8 = (value)(L0[3]);
  L9 = L7;
  L10 = L1;
  Minline_P_replace_LABEL_NEW_LABELS(&L9,&L10);
  L11 = L8;
  ATTACH(L11);
  L12 = L10;
  Minline_P_replace_LABELS_NEW_LABELS(&L11,&L12);
  Create(&L13,0,3);
  *(value *)(L13+1) = L6;
if(DecrRefs(L0)<0)
XD_Mcode_T18(L0);
  *(value *)(L13+2) = L9;
  *(value *)(L13+3) = L11;
  *P1 = L12;
  *P0 = L13;
  return 1;
LAB465:
if(DecrRefs(L1)<0)
XD_Minline_T49(L1);
if(DecrRefs(L0)<0)
XD_Mcode_T18(L0);
  Abort(634, module_name);
}

int Minline_P_get_parameter_ADDRESSES_INT_ADDRESS(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB745:
  switch (Alternative(L0)) {
  case 0: goto LAB466;
  default: goto LAB468;
  };
LAB466:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  switch (Int(L1)) {
  case 0: goto LAB469;
  default: goto LAB471;
  };
LAB469:
  *P2 = L2;
  ATTACH(L2);
  return 1;
LAB471:
  L4 = C_INT(1);
  L5 = C_INT(Int(L1) - Int(L4));
  L1 = L5;
  L0 = L3;
  goto LAB745;
LAB468:
  Abort(640, module_name);
}

int Minline_P_resolve_recursion()
{
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L8 = (value)G_inline_INLINE_NR17;
  L0 = L8;
LAB1029:
  G_inline_SMALL_LIMIT_NR11 = (long)L0;
  L1 = G_inline_TEXT_NR2930;
  Merrors_P_error_text_TEXT(L1);
  L2 = (value)G_inline_SMALL_LIMIT_NR11;
  Merrors_P_error_int_INT(L2);
  L3 = G_inline_TEXT_NR2931;
  Merrors_P_error_text_TEXT(L3);
  if (!Mrules_P_first_rule_RULENR(&L4)) goto LAB473;
  Minline_P_initialise_recursion_check_RULENR(L4);
  Minline_P_gather_global_info_RULENR(L4);
  L5 = G_inline_DONE_NR2932;
  ATTACH(L5);
if(DecrRefs(G_inline_DONE_REC_NR14)<0)
XD_Minline_T41(G_inline_DONE_REC_NR14);
  G_inline_DONE_REC_NR14 = L5;
  L6 = G_inline_DONE_NR2933;
  ATTACH(L6);
if(DecrRefs(G_inline_DONE_GL_NR15)<0)
XD_Minline_T41(G_inline_DONE_GL_NR15);
  G_inline_DONE_GL_NR15 = L6;
  Minline_P_resolve_recursion_RULENR(L4);
  L7 = G_inline_TEXT_NR2934;
  Merrors_P_error_text_TEXT(L7);
  return 1;
LAB473:
  return 1;
}

int Minline_P_initialise_recursion_check_RULENR(P0)
value P0;
{
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1036:
  L1 = (value) Addr((value*)&G_inline_RULE_CALLS_NR0,Int(L0));
  L2 = *((value*)L1);
  ATTACH(L2);
  Minline_P_build_recursion_rule_RULENRS_BITMAP(L2,&L3);
if(DecrRefs(L2)<0)
XD_Mrules_T3(L2);
  L4 = (value) Addr((value*)&G_inline_REACHES_NR12,Int(L0));
if(DecrRefs(*((value*)L4))<0)
XD_Mbitmap_T1(*((value*)L4));
  *((value *)L4) = L3;
  L6 = L0;
  Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR(L6,&L7,&L8,&L9,&L10,&L11,&L12);
if(DecrRefs(L11)<0)
XD_Mrules_T21(L11);
if(DecrRefs(L9)<0)
XD_Mrules_T15(L9);
if(DecrRefs(L8)<0)
XD_Mrules_T20(L8);
  Minline_P_scan_globals_RULENR_NODENR(L6,L12);
LAB1035:
  L5 = L0;
  if (!Mrules_P_next_rule_RULENR(&L5)) goto LAB474;
  L0 = L5;
  goto LAB1036;
LAB474:
  return 1;
  return 1;
}

int Minline_P_resolve_recursion_RULENR(P0)
value P0;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1055:
  L1 = G_inline_DONE_REC_NR14;
  ATTACH(L1);
  L2 = G_inline_DONE_GL_NR15;
  ATTACH(L2);
  L7 = L1;
  L8 = L2;
  switch (Alternative(L7)) {
  case 1: goto LAB1039;
  default: goto LAB1043;
  };
LAB1039:
  switch (Alternative(L8)) {
  case 1: goto LAB1041;
  default: goto LAB1044;
  };
LAB1041:
  L9 = G_inline_TEXT_NR2939;
  Merrors_P_error_text_TEXT(L9);
  goto LAB1038;
LAB1044:
  L10 = G_inline_TEXT_NR2940;
  Merrors_P_error_text_TEXT(L10);
  goto LAB1038;
LAB1043:
  switch (Alternative(L8)) {
  case 1: goto LAB1045;
  default: goto LAB1038;
  };
LAB1045:
  L11 = G_inline_TEXT_NR2941;
  Merrors_P_error_text_TEXT(L11);
LAB1038:
if(DecrRefs(L2)<0)
XD_Minline_T41(L2);
if(DecrRefs(L1)<0)
XD_Minline_T41(L1);
  L3 = G_inline_DONE_NR2935;
  ATTACH(L3);
if(DecrRefs(G_inline_DONE_REC_NR14)<0)
XD_Minline_T41(G_inline_DONE_REC_NR14);
  G_inline_DONE_REC_NR14 = L3;
  L4 = G_inline_DONE_NR2936;
  ATTACH(L4);
if(DecrRefs(G_inline_DONE_GL_NR15)<0)
XD_Minline_T41(G_inline_DONE_GL_NR15);
  G_inline_DONE_GL_NR15 = L4;
  Minline_P_resolve_recursion_pass_RULENR(L0);
  L5 = G_inline_DONE_GL_NR15;
  ATTACH(L5);
  switch (Alternative(L5)) {
  case 0: goto LAB476;
  default: goto LAB477;
  };
LAB476:
if(DecrRefs(L5)<0)
XD_Minline_T41(L5);
  L6 = G_inline_DONE_REC_NR14;
  ATTACH(L6);
  switch (Alternative(L6)) {
  case 0: goto LAB479;
  default: goto LAB480;
  };
LAB479:
if(DecrRefs(L6)<0)
XD_Minline_T41(L6);
  return 1;
LAB477:
if(DecrRefs(L5)<0)
XD_Minline_T41(L5);
  goto LAB1055;
LAB480:
if(DecrRefs(L6)<0)
XD_Minline_T41(L6);
LAB481:
  Minline_P_fast_resolve_recursion_RULENR(L0);
  return 1;
}

int Minline_P_fast_resolve_recursion_RULENR(P0)
value P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1054:
  L1 = G_inline_TEXT_NR2937;
  Merrors_P_error_text_TEXT(L1);
  L2 = G_inline_DONE_NR2938;
  ATTACH(L2);
if(DecrRefs(G_inline_DONE_REC_NR14)<0)
XD_Minline_T41(G_inline_DONE_REC_NR14);
  G_inline_DONE_REC_NR14 = L2;
  Minline_P_fast_resolve_recursion_pass_RULENR(L0);
  L3 = G_inline_DONE_REC_NR14;
  ATTACH(L3);
  switch (Alternative(L3)) {
  case 0: goto LAB482;
  default: goto LAB483;
  };
LAB482:
if(DecrRefs(L3)<0)
XD_Minline_T41(L3);
  return 1;
LAB483:
if(DecrRefs(L3)<0)
XD_Minline_T41(L3);
  goto LAB1054;
}

int Minline_P_resolve_recursion_pass_RULENR(P0)
value P0;
{
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1050:
  L2 = L0;
  L3 = (value) Addr((value*)&G_inline_REACHES_NR12,Int(L2));
  L4 = *((value*)L3);
  ATTACH(L4);
  L5 = (value) Addr((value*)&G_inline_MOD_DEP_NR20,Int(L2));
  L6 = *((value*)L5);
  ATTACH(L6);
  L7 = (value) Addr((value*)&G_inline_RULE_CALLS_NR0,Int(L2));
  L8 = *((value*)L7);
  ATTACH(L8);
  L9 = L4;
  ATTACH(L9);
if(DecrRefs(L4)<0)
XD_Mbitmap_T1(L4);
  L10 = L6;
  ATTACH(L10);
if(DecrRefs(L6)<0)
XD_Mbitmap_T1(L6);
  Minline_P_resolve_recursion_rule_RULENRS_BITMAP_BITMAP(L8,&L9,&L10);
if(DecrRefs(L8)<0)
XD_Mrules_T3(L8);
  L11 = *((value*)L3);
  ATTACH(L11);
  L12 = L11;
  ATTACH(L12);
if(DecrRefs(L11)<0)
XD_Mbitmap_T1(L11);
  L13 = G_inline_DONE_REC_NR14;
  ATTACH(L13);
  L14 = L13;
  Minline_P_equal_BITMAP_BITMAP_DONE(&L12,L9,&L14);
if(DecrRefs(*((value*)L3))<0)
XD_Mbitmap_T1(*((value*)L3));
  *((value *)L3) = L12;
if(DecrRefs(L9)<0)
XD_Mbitmap_T1(L9);
if(DecrRefs(G_inline_DONE_REC_NR14)<0)
XD_Minline_T41(G_inline_DONE_REC_NR14);
  G_inline_DONE_REC_NR14 = L14;
  L15 = *((value*)L5);
  ATTACH(L15);
  L16 = L15;
  ATTACH(L16);
if(DecrRefs(L15)<0)
XD_Mbitmap_T1(L15);
  L17 = G_inline_DONE_GL_NR15;
  ATTACH(L17);
  L18 = L17;
  Minline_P_equal_BITMAP_BITMAP_DONE(&L16,L10,&L18);
if(DecrRefs(*((value*)L5))<0)
XD_Mbitmap_T1(*((value*)L5));
  *((value *)L5) = L16;
if(DecrRefs(L10)<0)
XD_Mbitmap_T1(L10);
if(DecrRefs(G_inline_DONE_GL_NR15)<0)
XD_Minline_T41(G_inline_DONE_GL_NR15);
  G_inline_DONE_GL_NR15 = L18;
LAB1049:
  L1 = L0;
  if (!Mrules_P_next_rule_RULENR(&L1)) goto LAB494;
  L0 = L1;
  goto LAB1050;
LAB494:
  return 1;
  return 1;
}

int Minline_P_fast_resolve_recursion_pass_RULENR(P0)
value P0;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1053:
  L2 = L0;
  L3 = (value) Addr((value*)&G_inline_REACHES_NR12,Int(L2));
  L4 = *((value*)L3);
  ATTACH(L4);
  L5 = (value) Addr((value*)&G_inline_RULE_CALLS_NR0,Int(L2));
  L6 = *((value*)L5);
  ATTACH(L6);
  L7 = L4;
  ATTACH(L7);
if(DecrRefs(L4)<0)
XD_Mbitmap_T1(L4);
  Minline_P_fast_resolve_recursion_rule_RULENRS_BITMAP(L6,&L7);
if(DecrRefs(L6)<0)
XD_Mrules_T3(L6);
  L8 = *((value*)L3);
  ATTACH(L8);
  L9 = L8;
  ATTACH(L9);
if(DecrRefs(L8)<0)
XD_Mbitmap_T1(L8);
  L10 = G_inline_DONE_REC_NR14;
  ATTACH(L10);
  L11 = L10;
  Minline_P_equal_BITMAP_BITMAP_DONE(&L9,L7,&L11);
if(DecrRefs(*((value*)L3))<0)
XD_Mbitmap_T1(*((value*)L3));
  *((value *)L3) = L9;
if(DecrRefs(L7)<0)
XD_Mbitmap_T1(L7);
if(DecrRefs(G_inline_DONE_REC_NR14)<0)
XD_Minline_T41(G_inline_DONE_REC_NR14);
  G_inline_DONE_REC_NR14 = L11;
LAB1052:
  L1 = L0;
  if (!Mrules_P_next_rule_RULENR(&L1)) goto LAB496;
  L0 = L1;
  goto LAB1053;
LAB496:
  return 1;
  return 1;
}

int Minline_P_equal_BITMAP_BITMAP_DONE(P0,P1,P2)
value *P0;
value P1;
value *P2;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = P1;
  L2 = *P2;
  if (!Mbitmap_P_equal_BITMAP_BITMAP(L0,L1)) goto LAB499;
  *P2 = L2;
  *P0 = L0;
  return 1;
LAB499:
if(DecrRefs(L2)<0)
XD_Minline_T41(L2);
if(DecrRefs(L0)<0)
XD_Mbitmap_T1(L0);
  L3 = G_inline_DONE_NR2942;
  *P2 = L3;
  ATTACH(L3);
  *P0 = L1;
  ATTACH(L1);
  return 1;
}

int Minline_P_resolve_recursion_rule_RULENRS_BITMAP_BITMAP(P0,P1,P2)
value P0;
value *P1;
value *P2;
{
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = *P1;
  L2 = *P2;
LAB1048:
  switch (Alternative(L0)) {
  case 1: goto LAB500;
  case 0: goto LAB503;
  default: goto LAB505;
  };
LAB500:
  *P2 = L2;
  *P1 = L1;
  return 1;
LAB503:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  L5 = (value) Addr((value*)&G_inline_REACHES_NR12,Int(L3));
  L6 = *((value*)L5);
  Mbitmap_P_or_BITMAP_BITMAP_BITMAP(L1,L6,&L7);
if(DecrRefs(L1)<0)
XD_Mbitmap_T1(L1);
  L8 = (value) Addr((value*)&G_inline_MOD_DEP_NR20,Int(L3));
  L9 = *((value*)L8);
  Mbitmap_P_or_BITMAP_BITMAP_BITMAP(L2,L9,&L10);
if(DecrRefs(L2)<0)
XD_Mbitmap_T1(L2);
  L11 = L7;
  ATTACH(L11);
if(DecrRefs(L7)<0)
XD_Mbitmap_T1(L7);
  L12 = L10;
  ATTACH(L12);
if(DecrRefs(L10)<0)
XD_Mbitmap_T1(L10);
  L2 = L12;
  L1 = L11;
  L0 = L4;
  goto LAB1048;
LAB505:
if(DecrRefs(L2)<0)
XD_Mbitmap_T1(L2);
if(DecrRefs(L1)<0)
XD_Mbitmap_T1(L1);
  Abort(723, module_name);
}

int Minline_P_fast_resolve_recursion_rule_RULENRS_BITMAP(P0,P1)
value P0;
value *P1;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = *P1;
LAB1051:
  switch (Alternative(L0)) {
  case 1: goto LAB506;
  case 0: goto LAB509;
  default: goto LAB511;
  };
LAB506:
  *P1 = L1;
  return 1;
LAB509:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  L4 = (value) Addr((value*)&G_inline_REACHES_NR12,Int(L2));
  L5 = *((value*)L4);
  Mbitmap_P_or_BITMAP_BITMAP_BITMAP(L1,L5,&L6);
if(DecrRefs(L1)<0)
XD_Mbitmap_T1(L1);
  L7 = L6;
  ATTACH(L7);
if(DecrRefs(L6)<0)
XD_Mbitmap_T1(L6);
  L1 = L7;
  L0 = L3;
  goto LAB1051;
LAB511:
if(DecrRefs(L1)<0)
XD_Mbitmap_T1(L1);
  Abort(730, module_name);
}

int Minline_P_build_recursion_rule_RULENRS_BITMAP(P0,P1)
value P0;
value *P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 1: goto LAB512;
  case 0: goto LAB515;
  default: goto LAB517;
  };
LAB512:
  Mbitmap_P_new_BITMAP(&L1);
  *P1 = L1;
  return 1;
LAB515:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  Minline_P_build_recursion_rule_RULENRS_BITMAP(L3,&L4);
  Mbitmap_P_set_bit_BITMAP_INT_BITMAP(L4,L2,&L5);
if(DecrRefs(L4)<0)
XD_Mbitmap_T1(L4);
  *P1 = L5;
  return 1;
LAB517:
  Abort(738, module_name);
}

int Minline_P_gather_global_info_RULENR(P0)
value P0;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1037:
  L1 = (value) Addr((value*)&G_inline_RULE_CALLS_NR0,Int(L0));
  L2 = *((value*)L1);
  ATTACH(L2);
  Minline_P_gather_global_info_RULENRS_BITMAP(L2,&L3);
if(DecrRefs(L2)<0)
XD_Mrules_T3(L2);
  L4 = (value) Addr((value*)&G_inline_MOD_DEP_NR20,Int(L0));
if(DecrRefs(*((value*)L4))<0)
XD_Mbitmap_T1(*((value*)L4));
  *((value *)L4) = L3;
  L5 = L0;
  if (!Mrules_P_next_rule_RULENR(&L5)) goto LAB524;
  L0 = L5;
  goto LAB1037;
LAB524:
  return 1;
  return 1;
}

int Minline_P_gather_global_info_RULENRS_BITMAP(P0,P1)
value P0;
value *P1;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 1: goto LAB526;
  case 0: goto LAB529;
  default: goto LAB531;
  };
LAB526:
  Mbitmap_P_new_BITMAP(&L1);
  *P1 = L1;
  return 1;
LAB529:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  Minline_P_gather_global_info_RULENRS_BITMAP(L3,&L4);
  L5 = (value) Addr((value*)&G_inline_MOD_GLOBAL_NR19,Int(L2));
  L6 = *((value*)L5);
  Mbitmap_P_or_BITMAP_BITMAP_BITMAP(L4,L6,&L7);
if(DecrRefs(L4)<0)
XD_Mbitmap_T1(L4);
  *P1 = L7;
  return 1;
LAB531:
  Abort(782, module_name);
}

int Minline_P_scan_globals_RULENR_NODENR(P0,P1)
value P0;
value P1;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1034:
  if (!Mnodes_P_succeed_NODENR_NODENR(L1,&L2)) goto LAB533;
  if (!Mnodes_P_fail_NODENR_NODENR(L1,&L3)) goto LAB535;
  Minline_P_scan_node_RULENR_NODENR(L0,L1);
  Minline_P_scan_globals_RULENR_NODENR(L0,L2);
  L1 = L3;
  goto LAB1034;
LAB535:
  Minline_P_scan_node_RULENR_NODENR(L0,L1);
  L1 = L2;
  goto LAB1034;
LAB533:
  if (!Mnodes_P_fail_NODENR_NODENR(L1,&L4)) goto LAB537;
  Minline_P_scan_node_RULENR_NODENR(L0,L1);
  L1 = L4;
  goto LAB1034;
LAB537:
  Minline_P_scan_node_RULENR_NODENR(L0,L1);
  return 1;
}

int Minline_P_scan_node_RULENR_NODENR(P0,P1)
value P0;
value P1;
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1033:
  Mnodes_P_get_NODENR_LINENR_NODE(L1,&L2,&L3);
  switch (Alternative(L3)) {
  case 0: goto LAB538;
  case 1: goto LAB543;
  case 2: goto LAB546;
  case 3: goto LAB549;
  case 4: goto LAB552;
  case 5: goto LAB555;
  case 6: goto LAB558;
  case 7: goto LAB561;
  case 8: goto LAB564;
  case 10: goto LAB567;
  case 9: goto LAB570;
  case 11: goto LAB573;
  default: goto LAB575;
  };
LAB538:
  L4 = (value)(L3[1]);
  L5 = (value)(L3[2]);
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  if (!Manalyzer_P_resolve_call_ahead_NODENR_RULENR(L1,&L6)) goto LAB542;
  goto LAB1033;
LAB542:
  return 1;
LAB543:
  L7 = (value)(L3[1]);
  L8 = (value)(L3[2]);
  Mrules_P_get_RULENR_PARAMETERS(L7,&L9);
  Minline_P_scan_parameters_RULENR_PARAMETERS_EXPRESSIONS(L0,L9,L8);
if(DecrRefs(L9)<0)
XD_Mrules_T21(L9);
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  return 1;
LAB546:
  L10 = (value)(L3[1]);
  L11 = (value)(L3[2]);
  Minline_P_scan_destination_RULENR_EXPRESSION(L0,L11);
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  return 1;
LAB549:
  L12 = (value)(L3[1]);
  L13 = (value)(L3[2]);
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  return 1;
LAB552:
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  return 1;
LAB555:
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  return 1;
LAB558:
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  return 1;
LAB561:
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  return 1;
LAB564:
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  return 1;
LAB567:
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  return 1;
LAB570:
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  return 1;
LAB573:
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  return 1;
LAB575:
if(DecrRefs(L3)<0)
XD_Mnodes_T12(L3);
  Abort(836, module_name);
}

int Minline_P_scan_parameters_RULENR_PARAMETERS_EXPRESSIONS(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L1)) {
  case 2: goto LAB576;
  case 0: goto LAB582;
  default: goto LAB584;
  };
LAB576:
  switch (Alternative(L2)) {
  case 2: goto LAB579;
  default: goto LAB584;
  };
LAB579:
  return 1;
LAB582:
  L3 = (value)(L1[1]);
  L4 = (value)(L1[2]);
  L5 = (value)(L1[3]);
  L6 = (value)(L1[4]);
  switch (Alternative(L2)) {
  case 0: goto LAB585;
  default: goto LAB584;
  };
LAB585:
  L7 = (value)(L2[1]);
  L8 = (value)(L2[2]);
  Minline_P_scan_parameters_RULENR_PARAMETERS_EXPRESSIONS(L0,L6,L8);
  switch (Alternative(L3)) {
  case 0: goto LAB588;
  case 2: goto LAB591;
  case 1: goto LAB594;
  default: goto LAB596;
  };
LAB588:
  return 1;
LAB591:
  Minline_P_scan_destination_RULENR_EXPRESSION(L0,L7);
  return 1;
LAB594:
  Minline_P_scan_destination_RULENR_EXPRESSION(L0,L7);
  return 1;
LAB596:
  Abort(849, module_name);
LAB584:
  Abort(850, module_name);
}

int Minline_P_scan_destination_RULENR_EXPRESSION(P0,P1)
value P0;
value P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1032:
  switch (Alternative(L1)) {
  case 0: goto LAB597;
  case 1: goto LAB600;
  case 2: goto LAB603;
  default: goto LAB605;
  };
LAB597:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  L1 = L3;
  goto LAB1032;
LAB600:
  L4 = (value)(L1[1]);
  L5 = (value)(L1[2]);
  Minline_P_scan_destination_RULENR_SUBEXPRESSION(L0,L4);
  return 1;
LAB603:
  return 1;
LAB605:
  switch (Alternative(L1)) {
  case 2: goto LAB606;
  default: goto LAB608;
  };
LAB606:
  return 1;
LAB608:
  Abort(861, module_name);
}

int Minline_P_scan_destination_RULENR_SUBEXPRESSION(P0,P1)
value P0;
value P1;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1031:
  switch (Alternative(L1)) {
  case 0: goto LAB609;
  case 1: goto LAB612;
  case 2: goto LAB615;
  case 3: goto LAB618;
  case 4: goto LAB621;
  case 5: goto LAB624;
  case 6: goto LAB627;
  default: goto LAB629;
  };
LAB609:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  L1 = L3;
  goto LAB1031;
LAB612:
  L4 = (value)(L1[1]);
  L5 = (value)(L1[2]);
  L6 = (value)(L1[3]);
  Minline_P_scan_destination_RULENR_SUBEXPRESSION(L0,L4);
  L1 = L6;
  goto LAB1031;
LAB615:
  L7 = (value)(L1[1]);
  Minline_P_scan_destination_RULENR_EXPRESSION(L0,L7);
  return 1;
LAB618:
  L8 = (value)(L1[1]);
  Minline_P_scan_destination_RULENR_VARIABLE(L0,L8);
  return 1;
LAB621:
  L9 = (value)(L1[1]);
  return 1;
LAB624:
  L10 = (value)(L1[1]);
  return 1;
LAB627:
  L11 = (value)(L1[1]);
  return 1;
LAB629:
  Abort(876, module_name);
}

int Minline_P_scan_destination_RULENR_VARIABLE(P0,P1)
value P0;
value P1;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1030:
  switch (Alternative(L1)) {
  case 0: goto LAB630;
  case 1: goto LAB633;
  case 2: goto LAB636;
  case 3: goto LAB639;
  default: goto LAB641;
  };
LAB630:
  L2 = (value)(L1[1]);
  L1 = L2;
  goto LAB1030;
LAB633:
  L3 = (value)(L1[1]);
  return 1;
LAB636:
  L4 = (value)(L1[1]);
  Minline_P_scan_destination_RULENR_VARIABLENR(L0,L4);
  return 1;
LAB639:
  L5 = (value)(L1[1]);
  L6 = (value)(L1[2]);
  Minline_P_scan_destination_RULENR_VARIABLENR(L0,L5);
  return 1;
LAB641:
  Abort(886, module_name);
}

int Minline_P_scan_destination_RULENR_VARIABLENR(P0,P1)
value P0;
value P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  if (!Mvariables_P_is_global_VARIABLENR_REFNO(L1,&L2)) goto LAB643;
  L3 = (value) Addr((value*)&G_inline_MOD_GLOBAL_NR19,Int(L0));
  L4 = *((value*)L3);
  ATTACH(L4);
  Mbitmap_P_set_bit_BITMAP_INT_BITMAP(L4,L2,&L5);
if(DecrRefs(L4)<0)
XD_Mbitmap_T1(L4);
if(DecrRefs(*((value*)L3))<0)
XD_Mbitmap_T1(*((value*)L3));
  *((value *)L3) = L5;
  return 1;
LAB643:
  return 1;
}

int Minline_P_dump_expression_EXPRESSION(P0)
value P0;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1057:
  switch (Alternative(L0)) {
  case 0: goto LAB644;
  case 1: goto LAB647;
  case 2: goto LAB650;
  default: goto LAB652;
  };
LAB644:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L3 = G_inline_TEXT_NR2943;
  E10_write_TEXT(L3);
  Minline_P_dump_expression_EXPRESSION(L0);
  L4 = G_inline_TEXT_NR2944;
  E10_write_TEXT(L4);
  Minline_P_dump_expression_EXPRESSION(L2);
  L5 = G_inline_TEXT_NR2945;
  E10_write_TEXT(L5);
  return 1;
LAB647:
  L6 = (value)(L0[1]);
  L7 = (value)(L0[2]);
  L8 = G_inline_TEXT_NR2946;
  E10_write_TEXT(L8);
  Minline_P_dump_expression_SUBEXPRESSION(L6);
  L9 = G_inline_TEXT_NR2947;
  E10_write_TEXT(L9);
  L0 = L7;
  goto LAB1057;
LAB650:
  L10 = G_inline_TEXT_NR2948;
  E10_write_TEXT(L10);
  return 1;
LAB652:
  Abort(914, module_name);
}

int Minline_P_dump_expression_SUBEXPRESSION(P0)
value P0;
{
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1056:
  switch (Alternative(L0)) {
  case 0: goto LAB653;
  case 1: goto LAB656;
  case 2: goto LAB659;
  case 3: goto LAB662;
  case 4: goto LAB665;
  case 5: goto LAB668;
  case 6: goto LAB671;
  default: goto LAB673;
  };
LAB653:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L3 = G_inline_TEXT_NR2949;
  E10_write_TEXT(L3);
  L0 = L2;
  goto LAB1056;
LAB656:
  L4 = (value)(L0[1]);
  L5 = (value)(L0[2]);
  L6 = (value)(L0[3]);
  L7 = G_inline_TEXT_NR2950;
  E10_write_TEXT(L7);
  Minline_P_dump_expression_SUBEXPRESSION(L4);
  L8 = G_inline_TEXT_NR2951;
  E10_write_TEXT(L8);
  Minline_P_dump_expression_SUBEXPRESSION(L6);
  L9 = G_inline_TEXT_NR2952;
  E10_write_TEXT(L9);
  return 1;
LAB659:
  L10 = (value)(L0[1]);
  L11 = G_inline_TEXT_NR2953;
  E10_write_TEXT(L11);
  Minline_P_dump_expression_EXPRESSION(L10);
  L12 = G_inline_TEXT_NR2954;
  E10_write_TEXT(L12);
  return 1;
LAB662:
  L13 = (value)(L0[1]);
  L14 = G_inline_TEXT_NR2955;
  E10_write_TEXT(L14);
  return 1;
LAB665:
  L15 = (value)(L0[1]);
  L16 = G_inline_TEXT_NR2956;
  E10_write_TEXT(L16);
  return 1;
LAB668:
  L17 = (value)(L0[1]);
  L18 = G_inline_TEXT_NR2957;
  E10_write_TEXT(L18);
  return 1;
LAB671:
  L19 = (value)(L0[1]);
  L20 = G_inline_TEXT_NR2958;
  E10_write_TEXT(L20);
  return 1;
LAB673:
  Abort(938, module_name);
}

