/*
 * errors.c -- part of the C sources generated from the CDL3 sources,
 *              used to bootstrap CDL3
 * Copyright (C) 2000  C.H.A. Koster
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cdl3rts.h"
#include "predef.h"


static char* module_name = "errors";

/*
** GLOBALS
*/

	static long undefined[] = {3071};
value G_errors_ERRFILE_NR0 = undefined;
value G_errors_THE_MODULE_NR1 = undefined;
long G_errors_TEXT_NR2896[] = {Tag(1,T_TEXT),1,(long)"\r"};
long G_errors_TEXT_NR2897[] = {Tag(1,T_TEXT),5,(long)"\t\t\t\t\t"};
long G_errors_TEXT_NR2898[] = {Tag(1,T_TEXT),8,(long)"CDLDEBUG"};
long G_errors_TEXT_NR2899[] = {Tag(1,T_TEXT),8,(long)"CDLDEBUG"};
long G_errors_TEXT_NR2900[] = {Tag(1,T_TEXT),8,(long)"CDLDEBUG"};

/*
** ATTACH/DETACH/EQUAL
*/
/****MESSAGE(errors)****/

int EQ_Merrors_T3(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Merrors_T3(Part(x,2),Part(y,2));
       case 1:
         return EQ_Mrules_T15(Part(x,1),Part(y,1))&&EQ_Merrors_T3(Part(x,2),Part(y,2));
       case 2:
         return (Part(x,1) == Part(y,1))&&EQ_Merrors_T3(Part(x,2),Part(y,2));
       case 3:
         return EQ_Mvariables_T8(Part(x,1),Part(y,1))&&EQ_Merrors_T3(Part(x,2),Part(y,2));
       case 4:
         return (Part(x,1) == Part(y,1))&&EQ_Merrors_T3(Part(x,2),Part(y,2));
       case 5:
         return (Part(x,1) == Part(y,1))&&EQ_Merrors_T3(Part(x,2),Part(y,2));
       case 6:
         return EQ_TEXT(Part(x,1),Part(y,1))&&EQ_Merrors_T3(Part(x,2),Part(y,2));
       case 7:
         return EQ_Mnodes_T7(Part(x,1),Part(y,1))&&EQ_Merrors_T3(Part(x,2),Part(y,2));
       case 8:
         return EQ_Mnodes_T6(Part(x,1),Part(y,1))&&EQ_Merrors_T3(Part(x,2),Part(y,2));
       case 9:
         return EQ_Mcode_T12(Part(x,1),Part(y,1))&&EQ_Merrors_T3(Part(x,2),Part(y,2));
       case 10:
         return EQ_Mcode_T13(Part(x,1),Part(y,1))&&EQ_Merrors_T3(Part(x,2),Part(y,2));
       case 11:
         return EQ_TEXT(Part(x,1),Part(y,1));
    };
  return 0;
}

int W_Merrors_T3(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_Merrors_T3(Part(x,2));
WRITE(" ");
       case 1:
W_Mrules_T15(Part(x,1));
WRITE(" ");
W_Merrors_T3(Part(x,2));
WRITE(" ");
       case 2:
W_INT(Part(x,1));
WRITE(" ");
W_Merrors_T3(Part(x,2));
WRITE(" ");
       case 3:
W_Mvariables_T8(Part(x,1));
WRITE(" ");
W_Merrors_T3(Part(x,2));
WRITE(" ");
       case 4:
W_INT(Part(x,1));
WRITE(" ");
W_Merrors_T3(Part(x,2));
WRITE(" ");
       case 5:
W_INT(Part(x,1));
WRITE(" ");
W_Merrors_T3(Part(x,2));
WRITE(" ");
       case 6:
WRITE("\"");
W_TEXT(Part(x,1));
WRITE("\"");
WRITE(" ");
W_Merrors_T3(Part(x,2));
WRITE(" ");
       case 7:
W_Mnodes_T7(Part(x,1));
WRITE(" ");
W_Merrors_T3(Part(x,2));
WRITE(" ");
       case 8:
W_Mnodes_T6(Part(x,1));
WRITE(" ");
W_Merrors_T3(Part(x,2));
WRITE(" ");
       case 9:
W_Mcode_T12(Part(x,1));
WRITE(" ");
W_Merrors_T3(Part(x,2));
WRITE(" ");
       case 10:
W_Mcode_T13(Part(x,1));
WRITE(" ");
W_Merrors_T3(Part(x,2));
WRITE(" ");
       case 11:
WRITE("\"");
W_TEXT(Part(x,1));
WRITE("\"");
WRITE(" ");
    };
  return 0;
}

int XD_Merrors_T3(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Merrors_T3(Part(x,2));
            Free(x,3);
            break;
          case 1:
D_Mrules_T15(Part(x,1));
D_Merrors_T3(Part(x,2));
            Free(x,3);
            break;
          case 2:
D_Merrors_T3(Part(x,2));
            Free(x,3);
            break;
          case 3:
D_Mvariables_T8(Part(x,1));
D_Merrors_T3(Part(x,2));
            Free(x,3);
            break;
          case 4:
D_Merrors_T3(Part(x,2));
            Free(x,3);
            break;
          case 5:
D_Merrors_T3(Part(x,2));
            Free(x,3);
            break;
          case 6:
D_TEXT(Part(x,1));
D_Merrors_T3(Part(x,2));
            Free(x,3);
            break;
          case 7:
D_Mnodes_T7(Part(x,1));
D_Merrors_T3(Part(x,2));
            Free(x,3);
            break;
          case 8:
D_Mnodes_T6(Part(x,1));
D_Merrors_T3(Part(x,2));
            Free(x,3);
            break;
          case 9:
D_Mcode_T12(Part(x,1));
D_Merrors_T3(Part(x,2));
            Free(x,3);
            break;
          case 10:
D_Mcode_T13(Part(x,1));
D_Merrors_T3(Part(x,2));
            Free(x,3);
            break;
          case 11:
D_TEXT(Part(x,1));
            Free(x,2);
            break;
    };
}

int D_Merrors_T3(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Merrors_T3(x);
}


/*
** PROTOTYPES
*/

_PROTOTYPE(int Merrors_P_status_message_TEXT,(value P0));
_PROTOTYPE(int Merrors_P_status_message_MODULENR,(value P0));
_PROTOTYPE(int Merrors_P_debug_MESSAGE,(value P0));
_PROTOTYPE(int Merrors_P_debug_text_TEXT,(value P0));
_PROTOTYPE(int Merrors_P_debug_int_INT,(value P0));
_PROTOTYPE(int Merrors_P_error_MESSAGE,(value P0));
_PROTOTYPE(int Merrors_P_error_text_TEXT,(value P0));
_PROTOTYPE(int Merrors_P_error_int_INT,(value P0));
_PROTOTYPE(int Merrors_P_open_error_file,());


/*
**EXTERNAL PROTOTYPES**
*/

_PROTOTYPE(extern int E1_open_input_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E2_open_output_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E3_open_standard_output_FILE,(value *P0));
_PROTOTYPE(extern int E4_open_standard_error_FILE,(value *P0));
_PROTOTYPE(extern int E5_open_standard_input_FILE,(value *P0));
_PROTOTYPE(extern int E8_pipe_to_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E28_pipe_from_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E9_close_pipe_FILE,(value P0));
_PROTOTYPE(extern int E6_close_FILE,(value P0));
_PROTOTYPE(extern int E7_seek_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E10_write_TEXT,(value P0));
_PROTOTYPE(extern int E11_write_INT,(value P0));
_PROTOTYPE(extern int E12_write_FILE_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E13_write_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E14_formatted_write_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E15_write_char_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E16_write_char_INT,(value P0));
_PROTOTYPE(extern int E20_trace_TEXT,(value P0));
_PROTOTYPE(extern int E21_trace_INT,(value P0));
_PROTOTYPE(extern int E22_formatted_trace_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E30_read_line_TEXT,(value *P0));
_PROTOTYPE(extern int E31_read_line_FILE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E32_read_char_FILE_INT,(value P0,value *P1));
_PROTOTYPE(extern int E33_read_char_INT,(value *P0));
_PROTOTYPE(extern int E40_less_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E41_lesseq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E42_greater_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E43_greatereq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E58_length_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E51_extract_TEXT_INT_INT_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int E52_is_subtext_TEXT_INT_TEXT,(value P0,value *P1,value P2));
_PROTOTYPE(extern int E53_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E54_not_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E55_before_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E56_is_prefix_TEXT_TEXT_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E57_prefix_TEXT_INT_TEXT_TEXT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int E59_asciicode_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E60_bindec_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E61_decbin_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E70_hash_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E80_command_arg_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E81_exit_INT,(value P0));
_PROTOTYPE(extern int E82_get_from_environment_TEXT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E83_time_INT,(value *P0));
_PROTOTYPE(extern int E85_file_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E84_execute_TEXT,(value P0));
_PROTOTYPE(extern int E200_get_key_TEXT,(value *P0));
_PROTOTYPE(extern int Mnodes_P_new_NODENR,(value *P0));
_PROTOTYPE(extern int Mnodes_P_store_NODENR_LINENR_NODE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mnodes_P_get_NODENR_LINENR_NODE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mnodes_P_append_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_append_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_pass_two_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_error_SUBEXPRESSION,(value P0));
_PROTOTYPE(extern int Mnodes_P_error_EXPRESSION,(value P0));
_PROTOTYPE(extern int Mcode_P_start_coding,());
_PROTOTYPE(extern int Mcode_P_new_LABEL,(value *P0));
_PROTOTYPE(extern int Mcode_P_error_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_error_MONADIC_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_store_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_append_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_overwrite_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_move_LOCATION_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_current_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_set_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_get_LOCATION_INSTRUCTION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_next_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_is_end_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_first_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_next_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_is_associative_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS,(value P0));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_alias_LABEL_LABEL,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int Mcode_P_called_once_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_get_label_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_no_effect_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_write_ADDRESS,(value P0));
_PROTOTYPE(extern int Mcode_P_get_ADDRESS_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_get_ADDRESSES_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_dump_code_MODULENR_TEXT,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_dump_instruction_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_dump_code_TEXT_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_make_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mcode_P_request_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mrules_P_propagate_rules,());
_PROTOTYPE(extern int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(extern int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(extern int Mrules_P_is_external_RULENR_EXTNR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_in_interface_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_is_fixed_RULENR_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR,(value P0,value *P1,value *P2,value *P3,value *P4,value *P5,value *P6));
_PROTOTYPE(extern int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULETYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_PARAMETERS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mrules_P_get_preludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_postludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_interludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_error_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_error_RULENAME,(value P0));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENAME_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_definition_errors,());
_PROTOTYPE(extern int Mrules_P_set_root_error_handler_HANDLER,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_error_handler_HANDLER,(value *P0));
_PROTOTYPE(extern int Mrules_P_set_root_rule_ROOT,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_rule_ROOT,(value *P0));
_PROTOTYPE(extern int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));
_PROTOTYPE(extern int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value *P1,value *P2,value *P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_set_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_not_local_VARIABLENR,(value P0));
_PROTOTYPE(extern int Mvariables_P_is_constant_VARIABLENR_VALUE,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_global_VARIABLENR_REFNO,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_first_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_next_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_error_INSTANCE,(value P0));
_PROTOTYPE(extern int Mvariables_P_build_instance_INSTANCE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_propagate_types,());
_PROTOTYPE(extern int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_is_imported_abstract_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_abstract_type_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_special_type_TYPENR_STYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_external_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_integer_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_undefined_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_exported_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_same_TYPE_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_same_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_integer_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_is_text_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_text_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_equal_types_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPENAME_MODULENR,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_first_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_next_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_error_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_build_type_TYPENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_type_errors,());
_PROTOTYPE(extern int Mterminals_P_convert_TERMINAL_TERMINALNR,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_get_TERMINALNR_TERMINAL,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_error_terminal_TERMINALNR,(value P0));
_PROTOTYPE(extern int Mmodules_P_init_modules,());
_PROTOTYPE(extern int Mmodules_P_is_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_set_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_new_id_MODULENR_ID,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_order_MODULENR_MODULEORDER,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_convert_MODULE_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_add_import_for_module_MODULENR_MODULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_store_versionid_MODULENR_VERSIONTEXT,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_module_exports_rule_MODULENR_RULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_MODULE,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_module_name_MODULENR_MODULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_VERSIONTEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_EXPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_IMPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_first_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_next_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_error_MODULENR,(value P0));
_PROTOTYPE(extern int Mscanner_P_syntax_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Mscanner_P_current_line_LINENR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_open_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_close,());
_PROTOTYPE(extern int Mscanner_P_end_of_file,());
_PROTOTYPE(extern int Mscanner_P_is_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_ahead_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_should_be_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME_INSTANCE,(value *P0,value *P1));
_PROTOTYPE(extern int Mscanner_P_is_placeholder_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TERMINAL,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_MODULE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_SIZE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_EXTNR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_NUMBER,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_STRING,(value *P0));
_PROTOTYPE(extern int Manalyzer_P_semantic_errors,());
_PROTOTYPE(extern int Manalyzer_P_analyse_main_MODULENR_ROOT,(value P0,value P1));
_PROTOTYPE(extern int Manalyzer_P_analyse_rules_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_resolve_call_ahead_NODENR_RULENR,(value P0,value *P1));
_PROTOTYPE(extern int Manalyzer_P_warnings_on,());
_PROTOTYPE(extern int Minline_P_declare_rule_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_register_call_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_inline_TEXT,(value P0));
_PROTOTYPE(extern int Minline_P_inline_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_disable_inlining,());
_PROTOTYPE(extern int Minline_P_ignore_unreachable_code,());
_PROTOTYPE(extern int Minline_P_rule_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_call_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_resolve_call_graph_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_is_recursive_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_rule_is_reachable_RULENR,(value P0));
_PROTOTYPE(extern int Mcoder_P_no_code,());
_PROTOTYPE(extern int Mcoder_P_no_gc,());
_PROTOTYPE(extern int Mcoder_P_trace_on,());
_PROTOTYPE(extern int Mcoder_P_produce_statistics,());
_PROTOTYPE(extern int Mcoder_P_profile_on,());
_PROTOTYPE(extern int Mcoder_P_just_compile_and_no_object,());
_PROTOTYPE(extern int Mcoder_P_extension_TEXT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_external_names_do_not_start_with_underscore,());
_PROTOTYPE(extern int Mcoder_P_optimize_array_references,());
_PROTOTYPE(extern int Mcoder_P_code_MODULENR,(value P0));
_PROTOTYPE(extern int Mfiles_P_paths_PATHS,(value *P0));
_PROTOTYPE(extern int Mfiles_P_init_files,());
_PROTOTYPE(extern int Mfiles_P_strip_path_TEXT_TEXT_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mfiles_P_set_lib_path_TEXT,(value P0));
_PROTOTYPE(extern int Mfiles_P_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mfiles_P_open_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_BITMAP,(value *P0));
_PROTOTYPE(extern int Mbitmap_P_new_INT_BITMAP,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_INT_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_exclude_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_or_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_and_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_equal_BITMAP_BITMAP,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_set_BITMAP_INT,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_empty_BITMAP,(value P0));
_PROTOTYPE(extern int Mbitmap_P_clear_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_set_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_write_BITMAP,(value P0));
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion,());
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion_RULENR_LOCATION,(value P0,value P1));

/*
** CODE
*/

int Merrors_P_status_message_TEXT(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L3 = G_errors_TEXT_NR2896;
  L4 = G_errors_THE_MODULE_NR1;
  L2 = Concat(L3,L4);
  L1 = Concat(L2,L0);
D_TEXT(L2);
  Merrors_P_error_text_TEXT(L1);
D_TEXT(L1);
  return 1;
}

int Merrors_P_status_message_MODULENR(P0)
value P0;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mmodules_P_get_MODULENR_MODULE(L0,&L1);
  E58_length_TEXT_INT(L1,&L2);
  L3 = C_INT(8);
  L4 = C_INT(Int(L2) / Int(L3));
  L5 = C_INT(5);
  L6 = C_INT(Int(L5) - Int(L4));
  L7 = G_errors_TEXT_NR2897;
  L8 = C_INT(1);
  E51_extract_TEXT_INT_INT_TEXT(L7,L8,L6,&L9);
  L10 = Concat(L1,L9);
D_TEXT(L9);
D_TEXT(L1);
D_TEXT(G_errors_THE_MODULE_NR1);
  G_errors_THE_MODULE_NR1 = L10;
  return 1;
}

int Merrors_P_debug_MESSAGE(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_errors_TEXT_NR2898;
  if (!E82_get_from_environment_TEXT_TEXT(L1,&L2)) goto LAB1;
D_TEXT(L2);
  Merrors_P_error_MESSAGE(L0);
  return 1;
LAB1:
  return 1;
}

int Merrors_P_debug_text_TEXT(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_errors_TEXT_NR2899;
  if (!E82_get_from_environment_TEXT_TEXT(L1,&L2)) goto LAB3;
D_TEXT(L2);
  Merrors_P_error_text_TEXT(L0);
  return 1;
LAB3:
  return 1;
}

int Merrors_P_debug_int_INT(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_errors_TEXT_NR2900;
  if (!E82_get_from_environment_TEXT_TEXT(L1,&L2)) goto LAB5;
D_TEXT(L2);
  Merrors_P_error_int_INT(L0);
  return 1;
LAB5:
  return 1;
}

int Merrors_P_error_MESSAGE(P0)
value P0;
{
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB44:
  switch (Alternative(L0)) {
  case 6: goto LAB6;
  case 0: goto LAB9;
  case 1: goto LAB12;
  case 2: goto LAB15;
  case 3: goto LAB18;
  case 4: goto LAB21;
  case 7: goto LAB24;
  case 8: goto LAB27;
  case 9: goto LAB30;
  case 10: goto LAB33;
  case 5: goto LAB36;
  case 11: goto LAB39;
  default: goto LAB41;
  };
LAB6:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Merrors_P_error_text_TEXT(L1);
  L0 = L2;
  goto LAB44;
LAB9:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  Mrules_P_error_RULENR(L3);
  L0 = L4;
  goto LAB44;
LAB12:
  L5 = (value)(L0[1]);
  L6 = (value)(L0[2]);
  Mrules_P_error_RULENAME(L5);
  L0 = L6;
  goto LAB44;
LAB15:
  L7 = (value)(L0[1]);
  L8 = (value)(L0[2]);
  Mtypes_P_error_TYPENR(L7);
  L0 = L8;
  goto LAB44;
LAB18:
  L9 = (value)(L0[1]);
  L10 = (value)(L0[2]);
  Mvariables_P_error_INSTANCE(L9);
  L0 = L10;
  goto LAB44;
LAB21:
  L11 = (value)(L0[1]);
  L12 = (value)(L0[2]);
  Mmodules_P_error_MODULENR(L11);
  L0 = L12;
  goto LAB44;
LAB24:
  L13 = (value)(L0[1]);
  L14 = (value)(L0[2]);
  Mnodes_P_error_SUBEXPRESSION(L13);
  L0 = L14;
  goto LAB44;
LAB27:
  L15 = (value)(L0[1]);
  L16 = (value)(L0[2]);
  Mnodes_P_error_EXPRESSION(L15);
  L0 = L16;
  goto LAB44;
LAB30:
  L17 = (value)(L0[1]);
  L18 = (value)(L0[2]);
  Mcode_P_error_OPERATOR(L17);
  L0 = L18;
  goto LAB44;
LAB33:
  L19 = (value)(L0[1]);
  L20 = (value)(L0[2]);
  Mcode_P_error_MONADIC_OPERATOR(L19);
  L0 = L20;
  goto LAB44;
LAB36:
  L21 = (value)(L0[1]);
  L22 = (value)(L0[2]);
  Merrors_P_error_int_INT(L21);
  L0 = L22;
  goto LAB44;
LAB39:
  L23 = (value)(L0[1]);
  Merrors_P_error_text_TEXT(L23);
  return 1;
LAB41:
  Abort(72, module_name);
}

int Merrors_P_error_text_TEXT(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  L1 = G_errors_ERRFILE_NR0;
  E12_write_FILE_TEXT(L1,L0);
  return 1;
}

int Merrors_P_error_int_INT(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  L1 = G_errors_ERRFILE_NR0;
  E13_write_FILE_INT(L1,L0);
  return 1;
}

int Merrors_P_open_error_file()
{
  value L0;
  if (!E4_open_standard_error_FILE(&L0)) goto LAB43;
D_FILE(G_errors_ERRFILE_NR0);
  G_errors_ERRFILE_NR0 = L0;
  return 1;
LAB43:
  Abort(34, module_name);
}

