/*
 * code.c -- part of the C sources generated from the CDL3 sources,
 *              used to bootstrap CDL3
 * Copyright (C) 2000  C.H.A. Koster
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cdl3rts.h"
#include "predef.h"


static char* module_name = "code";

/*
** GLOBALS
*/

	static long undefined[] = {2047};
long G_code_CURRENT_NR0 = 0;
long G_code_INSTRUCTIONS_NR1B = 0;
value G_code_INSTRUCTIONS_NR1 = &G_code_INSTRUCTIONS_NR1B;
long G_code_NEXT_NR2A = 1;
value G_code_NEXT_NR2 = &G_code_NEXT_NR2A;
long G_code_NR_OF_LABELS_NR3 = 0;
value G_code_DUMPS_NR4 = undefined;
long G_code_PREV_NR5A = 1;
value G_code_PREV_NR5 = &G_code_PREV_NR5A;
long G_code_NR_OF_INSTRUCTIONS_NR6 = 0;
long G_code_END_NR7 = 0;
long G_code_FREE_LOCATIONS_NR8 = 0;
long G_code_LABEL_AT_NR9A = 1;
value G_code_LABEL_AT_NR9 = &G_code_LABEL_AT_NR9A;
long G_code_GOTO_FROM_NR10B = 0;
value G_code_GOTO_FROM_NR10 = &G_code_GOTO_FROM_NR10B;
long G_code_INSTRUCTION_NR2896[] = {Tag(1,0)};
long G_code_LOCATIONS_NR2897[] = {Tag(1,1)};
long G_code_TEXT_NR2898[] = {Tag(1,T_TEXT),2,(long)"<<"};
long G_code_TEXT_NR2899[] = {Tag(1,T_TEXT),2,(long)">>"};
long G_code_TEXT_NR2900[] = {Tag(1,T_TEXT),1,(long)"&"};
long G_code_TEXT_NR2901[] = {Tag(1,T_TEXT),2,(long)"||"};
long G_code_TEXT_NR2902[] = {Tag(1,T_TEXT),1,(long)"^"};
long G_code_TEXT_NR2903[] = {Tag(1,T_TEXT),1,(long)"+"};
long G_code_TEXT_NR2904[] = {Tag(1,T_TEXT),1,(long)"-"};
long G_code_TEXT_NR2905[] = {Tag(1,T_TEXT),1,(long)"*"};
long G_code_TEXT_NR2906[] = {Tag(1,T_TEXT),1,(long)"%"};
long G_code_TEXT_NR2907[] = {Tag(1,T_TEXT),2,(long)"%%"};
long G_code_TEXT_NR2908[] = {Tag(1,T_TEXT),1,(long)"-"};
long G_code_TEXT_NR2909[] = {Tag(1,T_TEXT),1,(long)"~"};
long G_code_LOCATIONS_NR2910[] = {Tag(1,1)};
long G_code_TEXT_NR2911[] = {Tag(1,T_TEXT),4,(long)"null"};
long G_code_TEXT_NR2912[] = {Tag(1,T_TEXT),6,(long)"debug "};
long G_code_TEXT_NR2913[] = {Tag(1,T_TEXT),18,(long)"frame plus OFFSET("};
long G_code_TEXT_NR2914[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2915[] = {Tag(1,T_TEXT),17,(long)"queue plus OFFSET"};
long G_code_TEXT_NR2916[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2917[] = {Tag(1,T_TEXT),10,(long)"parameter "};
long G_code_TEXT_NR2918[] = {Tag(1,T_TEXT),10,(long)"reference "};
long G_code_TEXT_NR2919[] = {Tag(1,T_TEXT),19,(long)"pass two parameter "};
long G_code_TEXT_NR2920[] = {Tag(1,T_TEXT),9,(long)"constant "};
long G_code_TEXT_NR2921[] = {Tag(1,T_TEXT),7,(long)"global "};
long G_code_TEXT_NR2922[] = {Tag(1,T_TEXT),7,(long)"number "};
long G_code_TEXT_NR2923[] = {Tag(1,T_TEXT),12,(long)" indexed by "};
long G_code_TEXT_NR2924[] = {Tag(1,T_TEXT),15,(long)"alternative of "};
long G_code_TEXT_NR2925[] = {Tag(1,T_TEXT),11,(long)"address of "};
long G_code_TEXT_NR2926[] = {Tag(1,T_TEXT),15,(long)"element OFFSET("};
long G_code_TEXT_NR2927[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2928[] = {Tag(1,T_TEXT),5,(long)" and "};
long G_code_TEXT_NR2929[] = {Tag(1,T_TEXT),9,(long)"pass two "};
long G_code_TEXT_NR2930[] = {Tag(1,T_TEXT),4,(long)"none"};
long G_code_TEXT_NR2931[] = {Tag(1,T_TEXT),9,(long)"CDL_TRACE"};
long G_code_TEXT_NR2932[] = {Tag(1,T_TEXT),15,(long)"Dump of module "};
long G_code_TEXT_NR2933[] = {Tag(1,T_TEXT),7,(long)" Pass: "};
long G_code_TEXT_NR2934[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_code_TEXT_NR2935[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_code_TEXT_NR2936[] = {Tag(1,T_TEXT),14,(long)"Dump of range "};
long G_code_TEXT_NR2937[] = {Tag(1,T_TEXT),1,(long)"-"};
long G_code_TEXT_NR2938[] = {Tag(1,T_TEXT),7,(long)" Pass: "};
long G_code_TEXT_NR2939[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_code_DUMP_NR2940[] = {Tag(1,0)};
long G_code_TEXT_NR2941[] = {Tag(1,T_TEXT),1,(long)"."};
long G_code_TEXT_NR2942[] = {Tag(1,T_TEXT),2,(long)"->"};
long G_code_TEXT_NR2943[] = {Tag(1,T_TEXT),3,(long)": ["};
long G_code_TEXT_NR2944[] = {Tag(1,T_TEXT),1,(long)","};
long G_code_TEXT_NR2945[] = {Tag(1,T_TEXT),2,(long)"] "};
long G_code_TEXT_NR2946[] = {Tag(1,T_TEXT),3,(long)"nop"};
long G_code_TEXT_NR2947[] = {Tag(1,T_TEXT),6,(long)"label "};
long G_code_TEXT_NR2948[] = {Tag(1,T_TEXT),20,(long)"function FUNCTIONNR("};
long G_code_TEXT_NR2949[] = {Tag(1,T_TEXT),17,(long)") with FRAMESIZE("};
long G_code_TEXT_NR2950[] = {Tag(1,T_TEXT),16,(long)") and FRAMESIZE("};
long G_code_TEXT_NR2951[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2952[] = {Tag(1,T_TEXT),12,(long)"function end"};
long G_code_TEXT_NR2953[] = {Tag(1,T_TEXT),5,(long)"rule "};
long G_code_TEXT_NR2954[] = {Tag(1,T_TEXT),1,(long)"("};
long G_code_TEXT_NR2955[] = {Tag(1,T_TEXT),17,(long)") with FRAMESIZE("};
long G_code_TEXT_NR2956[] = {Tag(1,T_TEXT),16,(long)") and FRAMESIZE("};
long G_code_TEXT_NR2957[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2958[] = {Tag(1,T_TEXT),8,(long)"rule end"};
long G_code_TEXT_NR2959[] = {Tag(1,T_TEXT),10,(long)"main with "};
long G_code_TEXT_NR2960[] = {Tag(1,T_TEXT),11,(long)"do pass two"};
long G_code_TEXT_NR2961[] = {Tag(1,T_TEXT),8,(long)"main end"};
long G_code_TEXT_NR2962[] = {Tag(1,T_TEXT),7,(long)"queue ("};
long G_code_TEXT_NR2963[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2964[] = {Tag(1,T_TEXT),5,(long)"call "};
long G_code_TEXT_NR2965[] = {Tag(1,T_TEXT),1,(long)"("};
long G_code_TEXT_NR2966[] = {Tag(1,T_TEXT),17,(long)") with ADDRESSES("};
long G_code_TEXT_NR2967[] = {Tag(1,T_TEXT),20,(long)") and fail to LABEL("};
long G_code_TEXT_NR2968[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2969[] = {Tag(1,T_TEXT),5,(long)"call "};
long G_code_TEXT_NR2970[] = {Tag(1,T_TEXT),1,(long)"("};
long G_code_TEXT_NR2971[] = {Tag(1,T_TEXT),17,(long)") with ADDRESSES("};
long G_code_TEXT_NR2972[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2973[] = {Tag(1,T_TEXT),5,(long)"goto "};
long G_code_TEXT_NR2974[] = {Tag(1,T_TEXT),17,(long)"continue pass one"};
long G_code_TEXT_NR2975[] = {Tag(1,T_TEXT),17,(long)"continue pass two"};
long G_code_TEXT_NR2976[] = {Tag(1,T_TEXT),7,(long)"succeed"};
long G_code_TEXT_NR2977[] = {Tag(1,T_TEXT),4,(long)"fail"};
long G_code_TEXT_NR2978[] = {Tag(1,T_TEXT),4,(long)"exit"};
long G_code_TEXT_NR2979[] = {Tag(1,T_TEXT),11,(long)"pragma map "};
long G_code_TEXT_NR2980[] = {Tag(1,T_TEXT),12,(long)" to ADDRESS("};
long G_code_TEXT_NR2981[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2982[] = {Tag(1,T_TEXT),13,(long)"pragma unmap "};
long G_code_TEXT_NR2983[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2984[] = {Tag(1,T_TEXT),14,(long)"pragma LINENR("};
long G_code_TEXT_NR2985[] = {Tag(1,T_TEXT),11,(long)") MODULENR("};
long G_code_TEXT_NR2986[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2987[] = {Tag(1,T_TEXT),9,(long)"comment ("};
long G_code_TEXT_NR2988[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2989[] = {Tag(1,T_TEXT),16,(long)"abort at LINENR("};
long G_code_TEXT_NR2990[] = {Tag(1,T_TEXT),14,(long)") in MODULENR("};
long G_code_TEXT_NR2991[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2992[] = {Tag(1,T_TEXT),15,(long)"concat ADDRESS("};
long G_code_TEXT_NR2993[] = {Tag(1,T_TEXT),14,(long)") and ADDRESS("};
long G_code_TEXT_NR2994[] = {Tag(1,T_TEXT),15,(long)") into ADDRESS("};
long G_code_TEXT_NR2995[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR2996[] = {Tag(1,T_TEXT),15,(long)"assign ADDRESS("};
long G_code_TEXT_NR2997[] = {Tag(1,T_TEXT),11,(long)") OPERATOR("};
long G_code_TEXT_NR2998[] = {Tag(1,T_TEXT),10,(long)") ADDRESS("};
long G_code_TEXT_NR2999[] = {Tag(1,T_TEXT),13,(long)") to ADDRESS("};
long G_code_TEXT_NR3000[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR3001[] = {Tag(1,T_TEXT),15,(long)"assign ADDRESS("};
long G_code_TEXT_NR3002[] = {Tag(1,T_TEXT),19,(long)") MONADIC_OPERATOR("};
long G_code_TEXT_NR3003[] = {Tag(1,T_TEXT),13,(long)") to ADDRESS("};
long G_code_TEXT_NR3004[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR3005[] = {Tag(1,T_TEXT),20,(long)"get element ADDRESS("};
long G_code_TEXT_NR3006[] = {Tag(1,T_TEXT),13,(long)") of ADDRESS("};
long G_code_TEXT_NR3007[] = {Tag(1,T_TEXT),14,(long)") into OFFSET("};
long G_code_TEXT_NR3008[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR3009[] = {Tag(1,T_TEXT),13,(long)"copy ADDRESS("};
long G_code_TEXT_NR3010[] = {Tag(1,T_TEXT),12,(long)") of TYPENR("};
long G_code_TEXT_NR3011[] = {Tag(1,T_TEXT),13,(long)") to ADDRESS("};
long G_code_TEXT_NR3012[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR3013[] = {Tag(1,T_TEXT),13,(long)"copy ADDRESS("};
long G_code_TEXT_NR3014[] = {Tag(1,T_TEXT),13,(long)") to ADDRESS("};
long G_code_TEXT_NR3015[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR3016[] = {Tag(1,T_TEXT),11,(long)"if ADDRESS("};
long G_code_TEXT_NR3017[] = {Tag(1,T_TEXT),12,(long)") of TYPENR("};
long G_code_TEXT_NR3018[] = {Tag(1,T_TEXT),23,(long)") differs from ADDRESS("};
long G_code_TEXT_NR3019[] = {Tag(1,T_TEXT),13,(long)") goto LABEL("};
long G_code_TEXT_NR3020[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR3021[] = {Tag(1,T_TEXT),18,(long)"switch on ADDRESS("};
long G_code_TEXT_NR3022[] = {Tag(1,T_TEXT),12,(long)") of TYPENR("};
long G_code_TEXT_NR3023[] = {Tag(1,T_TEXT),12,(long)") to LABELS("};
long G_code_TEXT_NR3024[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR3025[] = {Tag(1,T_TEXT),15,(long)"create ADDRESS("};
long G_code_TEXT_NR3026[] = {Tag(1,T_TEXT),12,(long)") of TYPENR("};
long G_code_TEXT_NR3027[] = {Tag(1,T_TEXT),8,(long)") ALTNR("};
long G_code_TEXT_NR3028[] = {Tag(1,T_TEXT),9,(long)") LENGTH("};
long G_code_TEXT_NR3029[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR3030[] = {Tag(1,T_TEXT),18,(long)"attach to ADDRESS("};
long G_code_TEXT_NR3031[] = {Tag(1,T_TEXT),12,(long)") of TYPENR("};
long G_code_TEXT_NR3032[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR3033[] = {Tag(1,T_TEXT),20,(long)"detach from ADDRESS("};
long G_code_TEXT_NR3034[] = {Tag(1,T_TEXT),12,(long)") of TYPENR("};
long G_code_TEXT_NR3035[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR3036[] = {Tag(1,T_TEXT),56,(long)"header PARAMETER_MAP(...) LOCAL_MAP(...) until LOCATION("};
long G_code_TEXT_NR3037[] = {Tag(1,T_TEXT),1,(long)")"};
long G_code_TEXT_NR3038[] = {Tag(1,T_TEXT),7,(long)"deleted"};
long G_code_TEXT_NR3039[] = {Tag(1,T_TEXT),1,(long)":"};
long G_code_TEXT_NR3040[] = {Tag(1,T_TEXT),1,(long)" "};
long G_code_TEXT_NR3041[] = {Tag(1,T_TEXT),2,(long)"D:"};
long G_code_TEXT_NR3042[] = {Tag(1,T_TEXT),5,(long)"minus"};
long G_code_TEXT_NR3043[] = {Tag(1,T_TEXT),6,(long)"invert"};
long G_code_TEXT_NR3044[] = {Tag(1,T_TEXT),2,(long)"<<"};
long G_code_TEXT_NR3045[] = {Tag(1,T_TEXT),2,(long)">>"};
long G_code_TEXT_NR3046[] = {Tag(1,T_TEXT),1,(long)"&"};
long G_code_TEXT_NR3047[] = {Tag(1,T_TEXT),2,(long)"||"};
long G_code_TEXT_NR3048[] = {Tag(1,T_TEXT),1,(long)"^"};
long G_code_TEXT_NR3049[] = {Tag(1,T_TEXT),1,(long)"+"};
long G_code_TEXT_NR3050[] = {Tag(1,T_TEXT),1,(long)"-"};
long G_code_TEXT_NR3051[] = {Tag(1,T_TEXT),1,(long)"*"};
long G_code_TEXT_NR3052[] = {Tag(1,T_TEXT),1,(long)"/"};
long G_code_TEXT_NR3053[] = {Tag(1,T_TEXT),1,(long)"%"};
long G_code_TEXT_NR3054[] = {Tag(1,T_TEXT),3,(long)"All"};
long G_code_TEXT_NR3055[] = {Tag(1,T_TEXT),9,(long)"Renaming "};
long G_code_TEXT_NR3056[] = {Tag(1,T_TEXT),4,(long)" to "};
long G_code_TEXT_NR3057[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_code_TEXT_NR3058[] = {Tag(1,T_TEXT),10,(long)"LOCATION: "};
long G_code_TEXT_NR3059[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_code_TEXT_NR3060[] = {Tag(1,T_TEXT),7,(long)"LABEL: "};
long G_code_TEXT_NR3061[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_code_TEXT_NR3062[] = {Tag(1,T_TEXT),8,(long)"LABEL1: "};
long G_code_TEXT_NR3063[] = {Tag(1,T_TEXT),1,(long)"\n"};

/*
** ATTACH/DETACH/EQUAL
*/
/****OPERATOR(code)****/

int EQ_Mcode_T12(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
       case 2:
         return 1;
       case 3:
         return 1;
       case 4:
         return 1;
       case 5:
         return 1;
       case 6:
         return 1;
       case 7:
         return 1;
       case 8:
         return 1;
       case 9:
         return 1;
    };
  return 0;
}

int W_Mcode_T12(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("shift ");
WRITE("left ");
       case 1:
WRITE("shift ");
WRITE("right ");
       case 2:
WRITE("and ");
       case 3:
WRITE("or ");
       case 4:
WRITE("xor ");
       case 5:
WRITE("plus ");
       case 6:
WRITE("minus ");
       case 7:
WRITE("times ");
       case 8:
WRITE("div ");
       case 9:
WRITE("mod ");
    };
  return 0;
}

int XD_Mcode_T12(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
          case 3:
            Free(x,1);
            break;
          case 4:
            Free(x,1);
            break;
          case 5:
            Free(x,1);
            break;
          case 6:
            Free(x,1);
            break;
          case 7:
            Free(x,1);
            break;
          case 8:
            Free(x,1);
            break;
          case 9:
            Free(x,1);
            break;
    };
}

int D_Mcode_T12(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mcode_T12(x);
}

/****MONADIC_OPERATOR(code)****/

int EQ_Mcode_T13(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Mcode_T13(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("minus ");
       case 1:
WRITE("invert ");
    };
  return 0;
}

int XD_Mcode_T13(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mcode_T13(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mcode_T13(x);
}

/****INSTRUCTION(code)****/

int EQ_Mcode_T14(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return (Part(x,1) == Part(y,1));
       case 2:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2))&&(Part(x,3) == Part(y,3));
       case 3:
         return 1;
       case 4:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2))&&(Part(x,3) == Part(y,3));
       case 5:
         return 1;
       case 6:
         return (Part(x,1) == Part(y,1));
       case 7:
         return 1;
       case 8:
         return 1;
       case 9:
         return (Part(x,1) == Part(y,1));
       case 10:
         return (Part(x,1) == Part(y,1))&&EQ_Mcode_T19(Part(x,2),Part(y,2))&&(Part(x,3) == Part(y,3));
       case 11:
         return (Part(x,1) == Part(y,1))&&EQ_Mcode_T19(Part(x,2),Part(y,2));
       case 12:
         return (Part(x,1) == Part(y,1));
       case 13:
         return 1;
       case 14:
         return 1;
       case 15:
         return 1;
       case 16:
         return 1;
       case 17:
         return 1;
       case 18:
         return EQ_TEXT(Part(x,1),Part(y,1))&&EQ_Mcode_T20(Part(x,2),Part(y,2));
       case 19:
         return EQ_TEXT(Part(x,1),Part(y,1));
       case 20:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2));
       case 21:
         return EQ_TEXT(Part(x,1),Part(y,1));
       case 22:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2));
       case 23:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&EQ_Mcode_T20(Part(x,2),Part(y,2))&&EQ_Mcode_T20(Part(x,3),Part(y,3));
       case 24:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&EQ_Mcode_T12(Part(x,2),Part(y,2))&&EQ_Mcode_T20(Part(x,3),Part(y,3))&&EQ_Mcode_T20(Part(x,4),Part(y,4));
       case 25:
         return EQ_Mcode_T13(Part(x,1),Part(y,1))&&EQ_Mcode_T20(Part(x,2),Part(y,2))&&EQ_Mcode_T20(Part(x,3),Part(y,3));
       case 26:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&EQ_Mcode_T20(Part(x,2),Part(y,2))&&(Part(x,3) == Part(y,3));
       case 27:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Mcode_T20(Part(x,3),Part(y,3));
       case 28:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&EQ_Mcode_T20(Part(x,2),Part(y,2));
       case 29:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Mcode_T20(Part(x,3),Part(y,3))&&(Part(x,4) == Part(y,4));
       case 30:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Mcode_T18(Part(x,3),Part(y,3));
       case 31:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2))&&(Part(x,3) == Part(y,3))&&(Part(x,4) == Part(y,4));
       case 32:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2));
       case 33:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2));
       case 34:
         return 1;
       case 35:
         return EQ_Mcode_T29(Part(x,1),Part(y,1))&&EQ_Manalyzer_T36(Part(x,2),Part(y,2))&&(Part(x,3) == Part(y,3));
    };
  return 0;
}

int W_Mcode_T14(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("nop ");
       case 1:
WRITE("label ");
W_INT(Part(x,1));
WRITE(" ");
       case 2:
WRITE("function ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("with ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("and ");
W_INT(Part(x,3));
WRITE(" ");
       case 3:
WRITE("function ");
WRITE("end ");
       case 4:
WRITE("rule ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("with ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("and ");
W_INT(Part(x,3));
WRITE(" ");
       case 5:
WRITE("rule ");
WRITE("end ");
       case 6:
WRITE("main ");
WRITE("with ");
W_INT(Part(x,1));
WRITE(" ");
       case 7:
WRITE("do ");
WRITE("pass ");
WRITE("two ");
       case 8:
WRITE("main ");
WRITE("end ");
       case 9:
WRITE("queue ");
W_INT(Part(x,1));
WRITE(" ");
       case 10:
WRITE("call ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("with ");
W_Mcode_T19(Part(x,2));
WRITE(" ");
WRITE("and ");
WRITE("fail ");
WRITE("to ");
W_INT(Part(x,3));
WRITE(" ");
       case 11:
WRITE("call ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("with ");
W_Mcode_T19(Part(x,2));
WRITE(" ");
       case 12:
WRITE("goto ");
W_INT(Part(x,1));
WRITE(" ");
       case 13:
WRITE("continue ");
WRITE("pass ");
WRITE("one ");
       case 14:
WRITE("continue ");
WRITE("pass ");
WRITE("two ");
       case 15:
WRITE("succeed ");
       case 16:
WRITE("fail ");
       case 17:
WRITE("exit ");
       case 18:
WRITE("pragma ");
WRITE("map ");
WRITE("\"");
W_TEXT(Part(x,1));
WRITE("\"");
WRITE(" ");
WRITE("to ");
W_Mcode_T20(Part(x,2));
WRITE(" ");
       case 19:
WRITE("pragma ");
WRITE("unmap ");
WRITE("\"");
W_TEXT(Part(x,1));
WRITE("\"");
WRITE(" ");
       case 20:
WRITE("pragma ");
W_INT(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
       case 21:
WRITE("comment ");
WRITE("\"");
W_TEXT(Part(x,1));
WRITE("\"");
WRITE(" ");
       case 22:
WRITE("abort ");
WRITE("at ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("in ");
W_INT(Part(x,2));
WRITE(" ");
       case 23:
WRITE("concat ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Mcode_T20(Part(x,2));
WRITE(" ");
WRITE("into ");
W_Mcode_T20(Part(x,3));
WRITE(" ");
       case 24:
WRITE("assign ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
W_Mcode_T12(Part(x,2));
WRITE(" ");
W_Mcode_T20(Part(x,3));
WRITE(" ");
WRITE("to ");
W_Mcode_T20(Part(x,4));
WRITE(" ");
       case 25:
WRITE("assign ");
W_Mcode_T13(Part(x,1));
WRITE(" ");
W_Mcode_T20(Part(x,2));
WRITE(" ");
WRITE("to ");
W_Mcode_T20(Part(x,3));
WRITE(" ");
       case 26:
WRITE("get ");
WRITE("element ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("of ");
W_Mcode_T20(Part(x,2));
WRITE(" ");
WRITE("into ");
W_INT(Part(x,3));
WRITE(" ");
       case 27:
WRITE("copy ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("of ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("to ");
W_Mcode_T20(Part(x,3));
WRITE(" ");
       case 28:
WRITE("copy ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("to ");
W_Mcode_T20(Part(x,2));
WRITE(" ");
       case 29:
WRITE("if ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("of ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("differs ");
WRITE("from ");
W_Mcode_T20(Part(x,3));
WRITE(" ");
WRITE("goto ");
W_INT(Part(x,4));
WRITE(" ");
       case 30:
WRITE("switch ");
WRITE("on ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("of ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("to ");
W_Mcode_T18(Part(x,3));
WRITE(" ");
       case 31:
WRITE("create ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("of ");
W_INT(Part(x,2));
WRITE(" ");
W_INT(Part(x,3));
WRITE(" ");
W_INT(Part(x,4));
WRITE(" ");
       case 32:
WRITE("attach ");
WRITE("to ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("of ");
W_INT(Part(x,2));
WRITE(" ");
       case 33:
WRITE("detach ");
WRITE("from ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("of ");
W_INT(Part(x,2));
WRITE(" ");
       case 34:
WRITE("deleted ");
       case 35:
WRITE("header ");
W_Mcode_T29(Part(x,1));
WRITE(" ");
W_Manalyzer_T36(Part(x,2));
WRITE(" ");
WRITE("until ");
W_INT(Part(x,3));
WRITE(" ");
    };
  return 0;
}

int XD_Mcode_T14(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,2);
            break;
          case 2:
            Free(x,4);
            break;
          case 3:
            Free(x,1);
            break;
          case 4:
            Free(x,4);
            break;
          case 5:
            Free(x,1);
            break;
          case 6:
            Free(x,2);
            break;
          case 7:
            Free(x,1);
            break;
          case 8:
            Free(x,1);
            break;
          case 9:
            Free(x,2);
            break;
          case 10:
D_Mcode_T19(Part(x,2));
            Free(x,4);
            break;
          case 11:
D_Mcode_T19(Part(x,2));
            Free(x,3);
            break;
          case 12:
            Free(x,2);
            break;
          case 13:
            Free(x,1);
            break;
          case 14:
            Free(x,1);
            break;
          case 15:
            Free(x,1);
            break;
          case 16:
            Free(x,1);
            break;
          case 17:
            Free(x,1);
            break;
          case 18:
D_TEXT(Part(x,1));
D_Mcode_T20(Part(x,2));
            Free(x,3);
            break;
          case 19:
D_TEXT(Part(x,1));
            Free(x,2);
            break;
          case 20:
            Free(x,3);
            break;
          case 21:
D_TEXT(Part(x,1));
            Free(x,2);
            break;
          case 22:
            Free(x,3);
            break;
          case 23:
D_Mcode_T20(Part(x,1));
D_Mcode_T20(Part(x,2));
D_Mcode_T20(Part(x,3));
            Free(x,4);
            break;
          case 24:
D_Mcode_T20(Part(x,1));
D_Mcode_T12(Part(x,2));
D_Mcode_T20(Part(x,3));
D_Mcode_T20(Part(x,4));
            Free(x,5);
            break;
          case 25:
D_Mcode_T13(Part(x,1));
D_Mcode_T20(Part(x,2));
D_Mcode_T20(Part(x,3));
            Free(x,4);
            break;
          case 26:
D_Mcode_T20(Part(x,1));
D_Mcode_T20(Part(x,2));
            Free(x,4);
            break;
          case 27:
D_Mcode_T20(Part(x,1));
D_Mcode_T20(Part(x,3));
            Free(x,4);
            break;
          case 28:
D_Mcode_T20(Part(x,1));
D_Mcode_T20(Part(x,2));
            Free(x,3);
            break;
          case 29:
D_Mcode_T20(Part(x,1));
D_Mcode_T20(Part(x,3));
            Free(x,5);
            break;
          case 30:
D_Mcode_T20(Part(x,1));
D_Mcode_T18(Part(x,3));
            Free(x,4);
            break;
          case 31:
D_Mcode_T20(Part(x,1));
            Free(x,5);
            break;
          case 32:
D_Mcode_T20(Part(x,1));
            Free(x,3);
            break;
          case 33:
D_Mcode_T20(Part(x,1));
            Free(x,3);
            break;
          case 34:
            Free(x,1);
            break;
          case 35:
D_Mcode_T29(Part(x,1));
D_Manalyzer_T36(Part(x,2));
            Free(x,4);
            break;
    };
}

int D_Mcode_T14(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mcode_T14(x);
}

/****LOCATIONS(code)****/

int EQ_Mcode_T16(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Mcode_T16(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Mcode_T16(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Mcode_T16(Part(x,2));
WRITE(" ");
       case 1:
WRITE("nowhere ");
    };
  return 0;
}

int XD_Mcode_T16(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mcode_T16(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mcode_T16(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mcode_T16(x);
}

/****LABELS(code)****/

int EQ_Mcode_T18(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Mcode_T18(Part(x,3),Part(y,3));
       case 1:
         return (Part(x,1) == Part(y,1));
    };
  return 0;
}

int W_Mcode_T18(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("and ");
W_Mcode_T18(Part(x,3));
WRITE(" ");
       case 1:
WRITE("default ");
W_INT(Part(x,1));
WRITE(" ");
    };
  return 0;
}

int XD_Mcode_T18(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mcode_T18(Part(x,3));
            Free(x,4);
            break;
          case 1:
            Free(x,2);
            break;
    };
}

int D_Mcode_T18(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mcode_T18(x);
}

/****ADDRESSES(code)****/

int EQ_Mcode_T19(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&EQ_Mcode_T19(Part(x,2),Part(y,2));
       case 1:
         return EQ_Mcode_T19(Part(x,1),Part(y,1));
       case 2:
         return 1;
    };
  return 0;
}

int W_Mcode_T19(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Mcode_T19(Part(x,2));
WRITE(" ");
       case 1:
WRITE("pass ");
WRITE("two ");
W_Mcode_T19(Part(x,1));
WRITE(" ");
       case 2:
WRITE("none ");
    };
  return 0;
}

int XD_Mcode_T19(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mcode_T20(Part(x,1));
D_Mcode_T19(Part(x,2));
            Free(x,3);
            break;
          case 1:
D_Mcode_T19(Part(x,1));
            Free(x,2);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Mcode_T19(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mcode_T19(x);
}

/****ADDRESS(code)****/

int EQ_Mcode_T20(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return (Part(x,1) == Part(y,1));
       case 2:
         return (Part(x,1) == Part(y,1));
       case 3:
         return (Part(x,1) == Part(y,1));
       case 4:
         return (Part(x,1) == Part(y,1));
       case 5:
         return (Part(x,1) == Part(y,1));
       case 6:
         return (Part(x,1) == Part(y,1));
       case 7:
         return (Part(x,1) == Part(y,1));
       case 8:
         return (Part(x,1) == Part(y,1));
       case 9:
         return (Part(x,1) == Part(y,1));
       case 10:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2));
       case 11:
         return EQ_Mcode_T20(Part(x,1),Part(y,1));
       case 12:
         return (Part(x,1) == Part(y,1));
       case 13:
         return (Part(x,1) == Part(y,1));
    };
  return 0;
}

int W_Mcode_T20(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("null ");
       case 1:
WRITE("debug ");
W_INT(Part(x,1));
WRITE(" ");
       case 2:
WRITE("frame ");
WRITE("plus ");
W_INT(Part(x,1));
WRITE(" ");
       case 3:
WRITE("queue ");
WRITE("plus ");
W_INT(Part(x,1));
WRITE(" ");
       case 4:
WRITE("parameter ");
W_INT(Part(x,1));
WRITE(" ");
       case 5:
WRITE("reference ");
W_INT(Part(x,1));
WRITE(" ");
       case 6:
WRITE("pass ");
WRITE("two ");
WRITE("parameter ");
W_INT(Part(x,1));
WRITE(" ");
       case 7:
WRITE("constant ");
W_INT(Part(x,1));
WRITE(" ");
       case 8:
WRITE("global ");
W_INT(Part(x,1));
WRITE(" ");
       case 9:
WRITE("number ");
W_INT(Part(x,1));
WRITE(" ");
       case 10:
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("indexed ");
WRITE("by ");
W_INT(Part(x,2));
WRITE(" ");
       case 11:
WRITE("alternative ");
WRITE("of ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
       case 12:
WRITE("address ");
WRITE("of ");
W_INT(Part(x,1));
WRITE(" ");
       case 13:
WRITE("element ");
W_INT(Part(x,1));
WRITE(" ");
    };
  return 0;
}

int XD_Mcode_T20(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,2);
            break;
          case 2:
            Free(x,2);
            break;
          case 3:
            Free(x,2);
            break;
          case 4:
            Free(x,2);
            break;
          case 5:
            Free(x,2);
            break;
          case 6:
            Free(x,2);
            break;
          case 7:
            Free(x,2);
            break;
          case 8:
            Free(x,2);
            break;
          case 9:
            Free(x,2);
            break;
          case 10:
D_Mcode_T20(Part(x,1));
            Free(x,3);
            break;
          case 11:
D_Mcode_T20(Part(x,1));
            Free(x,2);
            break;
          case 12:
            Free(x,2);
            break;
          case 13:
            Free(x,2);
            break;
    };
}

int D_Mcode_T20(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mcode_T20(x);
}

/****PARAMETER_MAP(code)****/

int EQ_Mcode_T29(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Mcode_T29(Part(x,3),Part(y,3));
       case 1:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Mcode_T29(Part(x,3),Part(y,3));
       case 2:
         return 1;
    };
  return 0;
}

int W_Mcode_T29(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("input ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("at ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("and ");
W_Mcode_T29(Part(x,3));
WRITE(" ");
       case 1:
WRITE("trans ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("at ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("and ");
W_Mcode_T29(Part(x,3));
WRITE(" ");
       case 2:
WRITE("none ");
    };
  return 0;
}

int XD_Mcode_T29(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mcode_T29(Part(x,3));
            Free(x,4);
            break;
          case 1:
D_Mcode_T29(Part(x,3));
            Free(x,4);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Mcode_T29(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mcode_T29(x);
}

/****DUMP(code)****/

int EQ_Mcode_T82(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return EQ_TEXT(Part(x,1),Part(y,1))&&EQ_Mcode_T82(Part(x,2),Part(y,2));
    };
  return 0;
}

int W_Mcode_T82(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("none ");
       case 1:
WRITE("dump ");
WRITE("pass ");
WRITE("\"");
W_TEXT(Part(x,1));
WRITE("\"");
WRITE(" ");
WRITE("and ");
W_Mcode_T82(Part(x,2));
WRITE(" ");
    };
  return 0;
}

int XD_Mcode_T82(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
D_TEXT(Part(x,1));
D_Mcode_T82(Part(x,2));
            Free(x,3);
            break;
    };
}

int D_Mcode_T82(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mcode_T82(x);
}


/*
** PROTOTYPES
*/

_PROTOTYPE(int Mcode_P_start_coding,());
_PROTOTYPE(int Mcode_P_new_LABEL,(value *P0));
_PROTOTYPE(int Mcode_P_error_OPERATOR,(value P0));
_PROTOTYPE(int Mcode_P_error_MONADIC_OPERATOR,(value P0));
_PROTOTYPE(int Mcode_P_store_INSTRUCTION,(value P0));
_PROTOTYPE(int Mcode_P_append_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(int Mcode_P_overwrite_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(int Mcode_P_prepend_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(int Mcode_P_prepend_INSTRUCTION,(value P0));
_PROTOTYPE(int Mcode_P_delete_LOCATION,(value P0));
_PROTOTYPE(int Mcode_P_delete_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(int Mcode_P_move_LOCATION_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(int Mcode_P_current_LOCATION,(value *P0));
_PROTOTYPE(int Mcode_P_set_LOCATION,(value P0));
_PROTOTYPE(int Mcode_P_get_LOCATION_INSTRUCTION,(value P0,value *P1));
_PROTOTYPE(int Mcode_P_next_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(int Mcode_P_prev_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(int Mcode_P_is_end_LOCATION,(value P0));
_PROTOTYPE(int Mcode_P_first_LOCATION,(value *P0));
_PROTOTYPE(int Mcode_P_prev_LOCATION,(value *P0));
_PROTOTYPE(int Mcode_P_next_LOCATION,(value *P0));
_PROTOTYPE(int Mcode_P_is_associative_OPERATOR,(value P0));
_PROTOTYPE(int Mcode_P_register_label_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(int Mcode_P_register_label_LABEL,(value P0));
_PROTOTYPE(int Mcode_P_register_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(int Mcode_P_register_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(int Mcode_P_register_goto_LABEL,(value P0));
_PROTOTYPE(int Mcode_P_register_goto_LABELS,(value P0));
_PROTOTYPE(int Mcode_P_remove_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(int Mcode_P_remove_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(int Mcode_P_alias_LABEL_LABEL,(value P0,value P1));
_PROTOTYPE(int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(int Mcode_P_called_once_LABEL,(value P0));
_PROTOTYPE(int Mcode_P_get_label_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(int Mcode_P_no_effect_INSTRUCTION,(value P0));
_PROTOTYPE(int Mcode_P_write_ADDRESS,(value P0));
_PROTOTYPE(int Mcode_P_get_ADDRESS_TEXT,(value P0,value *P1));
_PROTOTYPE(int Mcode_P_get_ADDRESSES_TEXT,(value P0,value *P1));
_PROTOTYPE(int Mcode_P_dump_code_MODULENR_TEXT,(value P0,value P1));
_PROTOTYPE(int Mcode_P_dump_instruction_INSTRUCTION,(value P0));
_PROTOTYPE(int Mcode_P_dump_code_TEXT_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(int Mcode_P_make_dump_TEXT,(value P0));
_PROTOTYPE(int Mcode_P_request_dump_TEXT,(value P0));
_PROTOTYPE(int Mcode_P_init,());
_PROTOTYPE(int Mcode_P_dump_LOCATION,(value P0));
_PROTOTYPE(int Mcode_P_dump_code_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(int Mcode_P_write_LABELS,(value P0));
_PROTOTYPE(int Mcode_P_get_LABELS_TEXT,(value P0,value *P1));
_PROTOTYPE(int Mcode_P_write_ADDRESSES,(value P0));
_PROTOTYPE(int Mcode_P_make_dump_TEXT_DUMP,(value P0,value P1));
_PROTOTYPE(int Mcode_P_remove_goto_LOCATION_LOCATIONS_LOCATIONS,(value P0,value P1,value *P2));
_PROTOTYPE(int Mcode_P_alias_LABEL_LABEL_LOCATIONS,(value P0,value P1,value P2));
_PROTOTYPE(int Mcode_P_alias_LABEL_LABEL_LABELS_LABELS_LOCATION,(value P0,value P1,value P2,value *P3,value P4));
_PROTOTYPE(int Mcode_P_absorb_goto_LABEL_LOCATIONS_INT_INT_INSTRUCTION,(value P0,value *P1,value *P2,value *P3,value P4));


/*
**EXTERNAL PROTOTYPES**
*/

_PROTOTYPE(extern int E1_open_input_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E2_open_output_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E3_open_standard_output_FILE,(value *P0));
_PROTOTYPE(extern int E4_open_standard_error_FILE,(value *P0));
_PROTOTYPE(extern int E5_open_standard_input_FILE,(value *P0));
_PROTOTYPE(extern int E8_pipe_to_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E28_pipe_from_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E9_close_pipe_FILE,(value P0));
_PROTOTYPE(extern int E6_close_FILE,(value P0));
_PROTOTYPE(extern int E7_seek_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E10_write_TEXT,(value P0));
_PROTOTYPE(extern int E11_write_INT,(value P0));
_PROTOTYPE(extern int E12_write_FILE_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E13_write_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E14_formatted_write_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E15_write_char_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E16_write_char_INT,(value P0));
_PROTOTYPE(extern int E20_trace_TEXT,(value P0));
_PROTOTYPE(extern int E21_trace_INT,(value P0));
_PROTOTYPE(extern int E22_formatted_trace_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E30_read_line_TEXT,(value *P0));
_PROTOTYPE(extern int E31_read_line_FILE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E32_read_char_FILE_INT,(value P0,value *P1));
_PROTOTYPE(extern int E33_read_char_INT,(value *P0));
_PROTOTYPE(extern int E40_less_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E41_lesseq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E42_greater_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E43_greatereq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E58_length_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E51_extract_TEXT_INT_INT_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int E52_is_subtext_TEXT_INT_TEXT,(value P0,value *P1,value P2));
_PROTOTYPE(extern int E53_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E54_not_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E55_before_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E56_is_prefix_TEXT_TEXT_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E57_prefix_TEXT_INT_TEXT_TEXT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int E59_asciicode_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E60_bindec_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E61_decbin_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E70_hash_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E80_command_arg_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E81_exit_INT,(value P0));
_PROTOTYPE(extern int E82_get_from_environment_TEXT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E83_time_INT,(value *P0));
_PROTOTYPE(extern int E85_file_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E84_execute_TEXT,(value P0));
_PROTOTYPE(extern int E200_get_key_TEXT,(value *P0));
_PROTOTYPE(extern int Mrules_P_propagate_rules,());
_PROTOTYPE(extern int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(extern int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(extern int Mrules_P_is_external_RULENR_EXTNR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_in_interface_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_is_fixed_RULENR_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR,(value P0,value *P1,value *P2,value *P3,value *P4,value *P5,value *P6));
_PROTOTYPE(extern int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULETYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_PARAMETERS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mrules_P_get_preludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_postludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_interludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_error_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_error_RULENAME,(value P0));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENAME_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_definition_errors,());
_PROTOTYPE(extern int Mrules_P_set_root_error_handler_HANDLER,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_error_handler_HANDLER,(value *P0));
_PROTOTYPE(extern int Mrules_P_set_root_rule_ROOT,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_rule_ROOT,(value *P0));
_PROTOTYPE(extern int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));
_PROTOTYPE(extern int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value *P1,value *P2,value *P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_set_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_not_local_VARIABLENR,(value P0));
_PROTOTYPE(extern int Mvariables_P_is_constant_VARIABLENR_VALUE,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_global_VARIABLENR_REFNO,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_first_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_next_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_error_INSTANCE,(value P0));
_PROTOTYPE(extern int Mvariables_P_build_instance_INSTANCE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_propagate_types,());
_PROTOTYPE(extern int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_is_imported_abstract_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_abstract_type_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_special_type_TYPENR_STYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_external_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_integer_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_undefined_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_exported_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_same_TYPE_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_same_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_integer_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_is_text_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_text_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_equal_types_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPENAME_MODULENR,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_first_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_next_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_error_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_build_type_TYPENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_type_errors,());
_PROTOTYPE(extern int Mmodules_P_init_modules,());
_PROTOTYPE(extern int Mmodules_P_is_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_set_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_new_id_MODULENR_ID,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_order_MODULENR_MODULEORDER,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_convert_MODULE_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_add_import_for_module_MODULENR_MODULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_store_versionid_MODULENR_VERSIONTEXT,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_module_exports_rule_MODULENR_RULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_MODULE,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_module_name_MODULENR_MODULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_VERSIONTEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_EXPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_IMPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_first_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_next_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_error_MODULENR,(value P0));
_PROTOTYPE(extern int Mscanner_P_syntax_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Mscanner_P_current_line_LINENR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_open_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_close,());
_PROTOTYPE(extern int Mscanner_P_end_of_file,());
_PROTOTYPE(extern int Mscanner_P_is_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_ahead_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_should_be_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME_INSTANCE,(value *P0,value *P1));
_PROTOTYPE(extern int Mscanner_P_is_placeholder_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TERMINAL,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_MODULE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_SIZE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_EXTNR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_NUMBER,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_STRING,(value *P0));
_PROTOTYPE(extern int Merrors_P_status_message_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_int_INT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_error_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_int_INT,(value P0));
_PROTOTYPE(extern int Manalyzer_P_semantic_errors,());
_PROTOTYPE(extern int Manalyzer_P_analyse_main_MODULENR_ROOT,(value P0,value P1));
_PROTOTYPE(extern int Manalyzer_P_analyse_rules_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_resolve_call_ahead_NODENR_RULENR,(value P0,value *P1));
_PROTOTYPE(extern int Manalyzer_P_warnings_on,());
_PROTOTYPE(extern int Minline_P_declare_rule_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_register_call_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_inline_TEXT,(value P0));
_PROTOTYPE(extern int Minline_P_inline_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_disable_inlining,());
_PROTOTYPE(extern int Minline_P_ignore_unreachable_code,());
_PROTOTYPE(extern int Minline_P_rule_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_call_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_resolve_call_graph_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_is_recursive_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_rule_is_reachable_RULENR,(value P0));
_PROTOTYPE(extern int Mnodes_P_new_NODENR,(value *P0));
_PROTOTYPE(extern int Mnodes_P_store_NODENR_LINENR_NODE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mnodes_P_get_NODENR_LINENR_NODE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mnodes_P_append_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_append_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_pass_two_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_error_SUBEXPRESSION,(value P0));
_PROTOTYPE(extern int Mnodes_P_error_EXPRESSION,(value P0));
_PROTOTYPE(extern int Mterminals_P_convert_TERMINAL_TERMINALNR,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_get_TERMINALNR_TERMINAL,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_error_terminal_TERMINALNR,(value P0));
_PROTOTYPE(extern int Mcoder_P_no_code,());
_PROTOTYPE(extern int Mcoder_P_no_gc,());
_PROTOTYPE(extern int Mcoder_P_trace_on,());
_PROTOTYPE(extern int Mcoder_P_produce_statistics,());
_PROTOTYPE(extern int Mcoder_P_profile_on,());
_PROTOTYPE(extern int Mcoder_P_just_compile_and_no_object,());
_PROTOTYPE(extern int Mcoder_P_extension_TEXT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_external_names_do_not_start_with_underscore,());
_PROTOTYPE(extern int Mcoder_P_optimize_array_references,());
_PROTOTYPE(extern int Mcoder_P_code_MODULENR,(value P0));
_PROTOTYPE(extern int Mfiles_P_paths_PATHS,(value *P0));
_PROTOTYPE(extern int Mfiles_P_init_files,());
_PROTOTYPE(extern int Mfiles_P_strip_path_TEXT_TEXT_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mfiles_P_set_lib_path_TEXT,(value P0));
_PROTOTYPE(extern int Mfiles_P_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mfiles_P_open_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_BITMAP,(value *P0));
_PROTOTYPE(extern int Mbitmap_P_new_INT_BITMAP,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_INT_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_exclude_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_or_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_and_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_equal_BITMAP_BITMAP,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_set_BITMAP_INT,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_empty_BITMAP,(value P0));
_PROTOTYPE(extern int Mbitmap_P_clear_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_set_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_write_BITMAP,(value P0));
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion,());
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion_RULENR_LOCATION,(value P0,value P1));

/*
** CODE
*/

int Mcode_P_start_coding()
{
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = C_INT(0);
  G_code_NR_OF_INSTRUCTIONS_NR6 = (long)L0;
  L1 = C_INT(0);
  G_code_NR_OF_LABELS_NR3 = (long)L1;
  L2 = C_INT(-1);
  G_code_END_NR7 = (long)L2;
  L3 = (value)G_code_END_NR7;
  L4 = C_INT(0);
  L5 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L4));
  *((value *)L5) = L3;
  L6 = (value)G_code_END_NR7;
  L7 = C_INT(0);
  L8 = (value) Addr((value*)&G_code_PREV_NR5,Int(L7));
  *((value *)L8) = L6;
  L9 = C_INT(0);
  G_code_CURRENT_NR0 = (long)L9;
  L10 = C_INT(0);
  G_code_NR_OF_INSTRUCTIONS_NR6 = (long)L10;
  L11 = (value)G_code_END_NR7;
  G_code_FREE_LOCATIONS_NR8 = (long)L11;
  L12 = G_code_INSTRUCTION_NR2896;
  L13 = C_INT(0);
  L14 = (value) Addr((value*)&G_code_INSTRUCTIONS_NR1,Int(L13));
  ATTACH(L12);
if(DecrRefs(*((value*)L14))<0)
XD_Mcode_T14(*((value*)L14));
  *((value *)L14) = L12;
  return 1;
}

int Mcode_P_new_LABEL(P0)
value *P0;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = (value)G_code_NR_OF_LABELS_NR3;
  L1 = (value)G_code_NR_OF_LABELS_NR3;
  L2 = C_INT(1);
  L3 = C_INT(Int(L1) + Int(L2));
  G_code_NR_OF_LABELS_NR3 = (long)L3;
  L4 = G_code_LOCATIONS_NR2897;
  L5 = (value) Addr((value*)&G_code_GOTO_FROM_NR10,Int(L0));
  ATTACH(L4);
if(DecrRefs(*((value*)L5))<0)
XD_Mcode_T16(*((value*)L5));
  *((value *)L5) = L4;
  L6 = C_INT(-1);
  L7 = (value) Addr((value*)&G_code_LABEL_AT_NR9,Int(L0));
  *((value *)L7) = L6;
  *P0 = L0;
  return 1;
}

int Mcode_P_error_OPERATOR(P0)
value P0;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB0;
  case 1: goto LAB3;
  case 2: goto LAB6;
  case 3: goto LAB9;
  case 4: goto LAB12;
  case 5: goto LAB15;
  case 6: goto LAB18;
  case 7: goto LAB21;
  case 8: goto LAB24;
  case 9: goto LAB27;
  default: goto LAB29;
  };
LAB0:
  L1 = G_code_TEXT_NR2898;
  Merrors_P_error_text_TEXT(L1);
  return 1;
LAB3:
  L2 = G_code_TEXT_NR2899;
  Merrors_P_error_text_TEXT(L2);
  return 1;
LAB6:
  L3 = G_code_TEXT_NR2900;
  Merrors_P_error_text_TEXT(L3);
  return 1;
LAB9:
  L4 = G_code_TEXT_NR2901;
  Merrors_P_error_text_TEXT(L4);
  return 1;
LAB12:
  L5 = G_code_TEXT_NR2902;
  Merrors_P_error_text_TEXT(L5);
  return 1;
LAB15:
  L6 = G_code_TEXT_NR2903;
  Merrors_P_error_text_TEXT(L6);
  return 1;
LAB18:
  L7 = G_code_TEXT_NR2904;
  Merrors_P_error_text_TEXT(L7);
  return 1;
LAB21:
  L8 = G_code_TEXT_NR2905;
  Merrors_P_error_text_TEXT(L8);
  return 1;
LAB24:
  L9 = G_code_TEXT_NR2906;
  Merrors_P_error_text_TEXT(L9);
  return 1;
LAB27:
  L10 = G_code_TEXT_NR2907;
  Merrors_P_error_text_TEXT(L10);
  return 1;
LAB29:
  Abort(344, module_name);
}

int Mcode_P_error_MONADIC_OPERATOR(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB30;
  case 1: goto LAB33;
  default: goto LAB35;
  };
LAB30:
  L1 = G_code_TEXT_NR2908;
  Merrors_P_error_text_TEXT(L1);
  return 1;
LAB33:
  L2 = G_code_TEXT_NR2909;
  Merrors_P_error_text_TEXT(L2);
  return 1;
LAB35:
  Abort(351, module_name);
}

int Mcode_P_store_INSTRUCTION(P0)
value P0;
{
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_code_NR_OF_INSTRUCTIONS_NR6;
  L2 = C_INT(1);
  L3 = C_INT(Int(L1) + Int(L2));
  G_code_NR_OF_INSTRUCTIONS_NR6 = (long)L3;
  L4 = (value)G_code_NR_OF_INSTRUCTIONS_NR6;
  L5 = (value)G_code_CURRENT_NR0;
  L6 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L5));
  L7 = *((value*)L6);
  L8 = (value)G_code_CURRENT_NR0;
  L9 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L8));
  *((value *)L9) = L4;
  L10 = (value) Addr((value*)&G_code_INSTRUCTIONS_NR1,Int(L4));
  ATTACH(L0);
if(DecrRefs(*((value*)L10))<0)
XD_Mcode_T14(*((value*)L10));
  *((value *)L10) = L0;
  L11 = (value)G_code_CURRENT_NR0;
  L12 = (value) Addr((value*)&G_code_PREV_NR5,Int(L4));
  *((value *)L12) = L11;
  L13 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L4));
  *((value *)L13) = L7;
  G_code_CURRENT_NR0 = (long)L4;
  L14 = L7;
  L15 = L4;
  L16 = (value)G_code_END_NR7;
  if (!(L14 == L16)) goto LAB380;
  return 1;
LAB380:
  L17 = (value) Addr((value*)&G_code_PREV_NR5,Int(L14));
  *((value *)L17) = L15;
  return 1;
  return 1;
}

int Mcode_P_append_LOCATION_INSTRUCTION(P0,P1)
value P0;
value P1;
{
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L8 = (value)G_code_FREE_LOCATIONS_NR8;
  L9 = (value)G_code_END_NR7;
  if (!(L8 == L9)) goto LAB383;
  L10 = (value)G_code_NR_OF_INSTRUCTIONS_NR6;
  L11 = C_INT(1);
  L12 = C_INT(Int(L10) + Int(L11));
  G_code_NR_OF_INSTRUCTIONS_NR6 = (long)L12;
  L13 = (value)G_code_NR_OF_INSTRUCTIONS_NR6;
  L2 = L13;
  goto LAB381;
LAB383:
  L14 = (value)G_code_FREE_LOCATIONS_NR8;
  L15 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L14));
  L16 = *((value*)L15);
  G_code_FREE_LOCATIONS_NR8 = (long)L16;
  L2 = L14;
LAB381:
  L3 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L0));
  L4 = *((value*)L3);
  *((value *)L3) = L2;
  L5 = (value) Addr((value*)&G_code_INSTRUCTIONS_NR1,Int(L2));
  ATTACH(L1);
if(DecrRefs(*((value*)L5))<0)
XD_Mcode_T14(*((value*)L5));
  *((value *)L5) = L1;
  L6 = (value) Addr((value*)&G_code_PREV_NR5,Int(L2));
  *((value *)L6) = L0;
  L7 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L2));
  *((value *)L7) = L4;
  G_code_CURRENT_NR0 = (long)L2;
  L17 = L4;
  L18 = L2;
  L19 = (value)G_code_END_NR7;
  if (!(L17 == L19)) goto LAB386;
  return 1;
LAB386:
  L20 = (value) Addr((value*)&G_code_PREV_NR5,Int(L17));
  *((value *)L20) = L18;
  return 1;
  return 1;
}

int Mcode_P_overwrite_LOCATION_INSTRUCTION(P0,P1)
value P0;
value P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = (value) Addr((value*)&G_code_INSTRUCTIONS_NR1,Int(L0));
  ATTACH(L1);
if(DecrRefs(*((value*)L2))<0)
XD_Mcode_T14(*((value*)L2));
  *((value *)L2) = L1;
  return 1;
}

int Mcode_P_prepend_LOCATION_INSTRUCTION(P0,P1)
value P0;
value P1;
{
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L8 = (value)G_code_FREE_LOCATIONS_NR8;
  L9 = (value)G_code_END_NR7;
  if (!(L8 == L9)) goto LAB389;
  L10 = (value)G_code_NR_OF_INSTRUCTIONS_NR6;
  L11 = C_INT(1);
  L12 = C_INT(Int(L10) + Int(L11));
  G_code_NR_OF_INSTRUCTIONS_NR6 = (long)L12;
  L13 = (value)G_code_NR_OF_INSTRUCTIONS_NR6;
  L2 = L13;
  goto LAB387;
LAB389:
  L14 = (value)G_code_FREE_LOCATIONS_NR8;
  L15 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L14));
  L16 = *((value*)L15);
  G_code_FREE_LOCATIONS_NR8 = (long)L16;
  L2 = L14;
LAB387:
  L3 = (value) Addr((value*)&G_code_INSTRUCTIONS_NR1,Int(L2));
  ATTACH(L1);
if(DecrRefs(*((value*)L3))<0)
XD_Mcode_T14(*((value*)L3));
  *((value *)L3) = L1;
  L4 = (value) Addr((value*)&G_code_PREV_NR5,Int(L0));
  L5 = *((value*)L4);
  *((value *)L4) = L2;
  L6 = (value) Addr((value*)&G_code_PREV_NR5,Int(L2));
  *((value *)L6) = L5;
  L7 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L2));
  *((value *)L7) = L0;
  G_code_CURRENT_NR0 = (long)L2;
  L17 = L5;
  L18 = L2;
  L19 = (value)G_code_END_NR7;
  if (!(L17 == L19)) goto LAB392;
  return 1;
LAB392:
  L20 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L17));
  *((value *)L20) = L18;
  return 1;
  return 1;
}

int Mcode_P_prepend_INSTRUCTION(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_code_CURRENT_NR0;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L1,L0);
  return 1;
}

int Mcode_P_delete_LOCATION(P0)
value P0;
{
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_code_PREV_NR5,Int(L0));
  L2 = *((value*)L1);
  L3 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L0));
  L4 = *((value*)L3);
  L5 = L4;
  L6 = L2;
  L7 = (value)G_code_END_NR7;
  if (!(L5 == L7)) goto LAB395;
  goto LAB393;
LAB395:
  L8 = (value) Addr((value*)&G_code_PREV_NR5,Int(L5));
  *((value *)L8) = L6;
LAB393:
  L9 = L2;
  L10 = L4;
  L11 = (value)G_code_END_NR7;
  if (!(L9 == L11)) goto LAB398;
  goto LAB396;
LAB398:
  L12 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L9));
  *((value *)L12) = L10;
LAB396:
  L13 = L0;
  L14 = (value)G_code_FREE_LOCATIONS_NR8;
  L15 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L13));
  *((value *)L15) = L14;
  G_code_FREE_LOCATIONS_NR8 = (long)L13;
  return 1;
  return 1;
}

int Mcode_P_delete_LOCATION_LOCATION(P0,P1)
value P0;
value P1;
{
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = (value) Addr((value*)&G_code_PREV_NR5,Int(L0));
  L3 = *((value*)L2);
  L4 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L1));
  L5 = *((value*)L4);
  L6 = L5;
  L7 = L3;
  L8 = (value)G_code_END_NR7;
  if (!(L6 == L8)) goto LAB402;
  goto LAB400;
LAB402:
  L9 = (value) Addr((value*)&G_code_PREV_NR5,Int(L6));
  *((value *)L9) = L7;
LAB400:
  L10 = L3;
  L11 = L5;
  L12 = (value)G_code_END_NR7;
  if (!(L10 == L12)) goto LAB405;
  goto LAB403;
LAB405:
  L13 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L10));
  *((value *)L13) = L11;
LAB403:
  L14 = L0;
  L15 = L1;
  L16 = (value)G_code_FREE_LOCATIONS_NR8;
  L17 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L15));
  *((value *)L17) = L16;
  G_code_FREE_LOCATIONS_NR8 = (long)L14;
  return 1;
  return 1;
}

int Mcode_P_move_LOCATION_LOCATION_LOCATION(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = (value) Addr((value*)&G_code_PREV_NR5,Int(L0));
  L4 = *((value*)L3);
  L5 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L1));
  L6 = *((value*)L5);
  L9 = L4;
  L10 = L6;
  L11 = (value)G_code_END_NR7;
  if (!(L9 == L11)) goto LAB409;
  goto LAB407;
LAB409:
  L12 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L9));
  *((value *)L12) = L10;
LAB407:
  L13 = L6;
  L14 = L4;
  L15 = (value)G_code_END_NR7;
  if (!(L13 == L15)) goto LAB412;
  goto LAB410;
LAB412:
  L16 = (value) Addr((value*)&G_code_PREV_NR5,Int(L13));
  *((value *)L16) = L14;
LAB410:
  L7 = (value) Addr((value*)&G_code_PREV_NR5,Int(L2));
  L8 = *((value*)L7);
  *((value *)L5) = L2;
  *((value *)L7) = L1;
  *((value *)L3) = L8;
  L17 = L8;
  L18 = L0;
  L19 = (value)G_code_END_NR7;
  if (!(L17 == L19)) goto LAB415;
  return 1;
LAB415:
  L20 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L17));
  *((value *)L20) = L18;
  return 1;
  return 1;
}

int Mcode_P_current_LOCATION(P0)
value *P0;
{
  value L0;
  L0 = (value)G_code_CURRENT_NR0;
  *P0 = L0;
  return 1;
}

int Mcode_P_set_LOCATION(P0)
value P0;
{
  value L0;
  L0 = P0;
  G_code_CURRENT_NR0 = (long)L0;
  return 1;
}

int Mcode_P_get_LOCATION_INSTRUCTION(P0,P1)
value P0;
value *P1;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = C_INT(-1);
  if (!(L0 == L1)) goto LAB37;
  Abort(296, module_name);
LAB37:
  L2 = (value) Addr((value*)&G_code_INSTRUCTIONS_NR1,Int(L0));
  L3 = *((value*)L2);
  *P1 = L3;
  ATTACH(L3);
  return 1;
}

int Mcode_P_next_LOCATION_LOCATION(P0,P1)
value P0;
value *P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L0));
  L2 = *((value*)L1);
  *P1 = L2;
  return 1;
}

int Mcode_P_prev_LOCATION_LOCATION(P0,P1)
value P0;
value *P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_code_PREV_NR5,Int(L0));
  L2 = *((value*)L1);
  *P1 = L2;
  return 1;
}

int Mcode_P_is_end_LOCATION(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_code_END_NR7;
  if (!(L0 == L1)) goto LAB39;
  return 1;
LAB39:
  return 0;
}

int Mcode_P_first_LOCATION(P0)
value *P0;
{
  value L0;
  L0 = C_INT(0);
  *P0 = L0;
  return 1;
}

int Mcode_P_prev_LOCATION(P0)
value *P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = (value) Addr((value*)&G_code_PREV_NR5,Int(L0));
  L2 = *((value*)L1);
  L3 = (value)G_code_END_NR7;
  if (!(L2 == L3)) goto LAB41;
  return 0;
LAB41:
  *P0 = L2;
  return 1;
}

int Mcode_P_next_LOCATION(P0)
value *P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L0));
  L2 = *((value*)L1);
  L3 = (value)G_code_END_NR7;
  if (!(L2 == L3)) goto LAB43;
  return 0;
LAB43:
  *P0 = L2;
  return 1;
}

int Mcode_P_is_associative_OPERATOR(P0)
value P0;
{
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 3: goto LAB44;
  case 4: goto LAB47;
  case 5: goto LAB50;
  case 7: goto LAB53;
  default: goto LAB55;
  };
LAB44:
  return 1;
LAB47:
  return 1;
LAB50:
  return 1;
LAB53:
  return 1;
LAB55:
  return 0;
}

int Mcode_P_register_label_LABEL_LOCATION(P0,P1)
value P0;
value P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = (value) Addr((value*)&G_code_LABEL_AT_NR9,Int(L0));
  *((value *)L2) = L1;
  return 1;
}

int Mcode_P_register_label_LABEL(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mcode_P_current_LOCATION(&L1);
  L2 = (value) Addr((value*)&G_code_LABEL_AT_NR9,Int(L0));
  *((value *)L2) = L1;
  return 1;
}

int Mcode_P_register_goto_LABEL_LOCATION(P0,P1)
value P0;
value P1;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Create(&L2,0,2);
  *(value *)(L2+1) = L1;
  L3 = (value) Addr((value*)&G_code_GOTO_FROM_NR10,Int(L0));
  L4 = *((value*)L3);
  ATTACH(L4);
  *(value *)(L2+2) = L4;
if(DecrRefs(*((value*)L3))<0)
XD_Mcode_T16(*((value*)L3));
  *((value *)L3) = L2;
  return 1;
}

int Mcode_P_register_goto_LABELS_LOCATION(P0,P1)
value P0;
value P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB416:
  switch (Alternative(L0)) {
  case 1: goto LAB56;
  case 0: goto LAB59;
  default: goto LAB61;
  };
LAB56:
  L2 = (value)(L0[1]);
  Mcode_P_register_goto_LABEL_LOCATION(L2,L1);
  return 1;
LAB59:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  L5 = (value)(L0[3]);
  Mcode_P_register_goto_LABEL_LOCATION(L4,L1);
  L0 = L5;
  goto LAB416;
LAB61:
  Abort(692, module_name);
}

int Mcode_P_register_goto_LABEL(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mcode_P_current_LOCATION(&L1);
  Create(&L2,0,2);
  *(value *)(L2+1) = L1;
  L3 = (value) Addr((value*)&G_code_GOTO_FROM_NR10,Int(L0));
  L4 = *((value*)L3);
  ATTACH(L4);
  *(value *)(L2+2) = L4;
if(DecrRefs(*((value*)L3))<0)
XD_Mcode_T16(*((value*)L3));
  *((value *)L3) = L2;
  return 1;
}

int Mcode_P_register_goto_LABELS(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  Mcode_P_current_LOCATION(&L1);
  Mcode_P_register_goto_LABELS_LOCATION(L0,L1);
  return 1;
}

int Mcode_P_remove_goto_LABEL_LOCATION(P0,P1)
value P0;
value P1;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = (value) Addr((value*)&G_code_GOTO_FROM_NR10,Int(L0));
  L3 = *((value*)L2);
  ATTACH(L3);
  Mcode_P_remove_goto_LOCATION_LOCATIONS_LOCATIONS(L1,L3,&L4);
if(DecrRefs(L3)<0)
XD_Mcode_T16(L3);
if(DecrRefs(*((value*)L2))<0)
XD_Mcode_T16(*((value*)L2));
  *((value *)L2) = L4;
  return 1;
}

int Mcode_P_remove_goto_LABELS_LOCATION(P0,P1)
value P0;
value P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB417:
  switch (Alternative(L0)) {
  case 1: goto LAB62;
  case 0: goto LAB65;
  default: goto LAB67;
  };
LAB62:
  L2 = (value)(L0[1]);
  Mcode_P_remove_goto_LABEL_LOCATION(L2,L1);
  return 1;
LAB65:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  L5 = (value)(L0[3]);
  Mcode_P_remove_goto_LABEL_LOCATION(L4,L1);
  L0 = L5;
  goto LAB417;
LAB67:
  Abort(721, module_name);
}

int Mcode_P_alias_LABEL_LABEL(P0,P1)
value P0;
value P1;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = (value) Addr((value*)&G_code_GOTO_FROM_NR10,Int(L0));
  L3 = *((value*)L2);
  ATTACH(L3);
  Mcode_P_alias_LABEL_LABEL_LOCATIONS(L0,L1,L3);
if(DecrRefs(L3)<0)
XD_Mcode_T16(L3);
  L4 = G_code_LOCATIONS_NR2910;
  ATTACH(L4);
if(DecrRefs(*((value*)L2))<0)
XD_Mcode_T16(*((value*)L2));
  *((value *)L2) = L4;
  return 1;
}

int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT(P0,P1,P2,P3)
value P0;
value P1;
value *P2;
value *P3;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = (value) Addr((value*)&G_code_GOTO_FROM_NR10,Int(L0));
  L3 = *((value*)L2);
  ATTACH(L3);
  L4 = L3;
  Mcode_P_absorb_goto_LABEL_LOCATIONS_INT_INT_INSTRUCTION(L0,&L4,&L5,&L6,L1);
if(DecrRefs(*((value*)L2))<0)
XD_Mcode_T16(*((value*)L2));
  *((value *)L2) = L4;
  *P3 = L6;
  *P2 = L5;
  return 1;
}

int Mcode_P_called_once_LABEL(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_code_GOTO_FROM_NR10,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 0: goto LAB68;
  default: goto LAB70;
  };
LAB68:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  switch (Alternative(L4)) {
  case 1: goto LAB71;
  default: goto LAB70;
  };
LAB71:
  return 1;
LAB70:
  return 0;
}

int Mcode_P_get_label_LABEL_LOCATION(P0,P1)
value P0;
value *P1;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_code_LABEL_AT_NR9,Int(L0));
  L2 = *((value*)L1);
  L3 = C_INT(-1);
  if (!(L2 == L3)) goto LAB75;
  Abort(708, module_name);
LAB75:
  L4 = (value) Addr((value*)&G_code_LABEL_AT_NR9,Int(L0));
  L5 = *((value*)L4);
  Mcode_P_get_LOCATION_INSTRUCTION(L5,&L6);
  switch (Alternative(L6)) {
  case 1: goto LAB76;
  default: goto LAB77;
  };
LAB76:
  L7 = (value)(L6[1]);
  if (!(L0 == L7)) goto LAB78;
if(DecrRefs(L6)<0)
XD_Mcode_T14(L6);
  *P1 = L5;
  return 1;
LAB77:
if(DecrRefs(L6)<0)
XD_Mcode_T14(L6);
  Abort(713, module_name);
LAB78:
  Abort(713, module_name);
}

int Mcode_P_no_effect_INSTRUCTION(P0)
value P0;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB81;
  case 18: goto LAB84;
  case 19: goto LAB87;
  case 20: goto LAB90;
  case 21: goto LAB93;
  case 35: goto LAB96;
  default: goto LAB98;
  };
LAB81:
  return 1;
LAB84:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  return 1;
LAB87:
  L3 = (value)(L0[1]);
  return 1;
LAB90:
  L4 = (value)(L0[1]);
  L5 = (value)(L0[2]);
  return 1;
LAB93:
  L6 = (value)(L0[1]);
  return 1;
LAB96:
  L7 = (value)(L0[1]);
  L8 = (value)(L0[2]);
  L9 = (value)(L0[3]);
  return 1;
LAB98:
  return 0;
}

int Mcode_P_write_ADDRESS(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  Mcode_P_get_ADDRESS_TEXT(L0,&L1);
  E10_write_TEXT(L1);
D_TEXT(L1);
  return 1;
}

int Mcode_P_get_ADDRESS_TEXT(P0,P1)
value P0;
value *P1;
{
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB99;
  case 1: goto LAB102;
  case 2: goto LAB105;
  case 3: goto LAB108;
  case 4: goto LAB111;
  case 5: goto LAB114;
  case 6: goto LAB117;
  case 7: goto LAB120;
  case 8: goto LAB123;
  case 9: goto LAB126;
  case 10: goto LAB129;
  case 11: goto LAB132;
  case 12: goto LAB135;
  case 13: goto LAB138;
  default: goto LAB140;
  };
LAB99:
  L1 = G_code_TEXT_NR2911;
  *P1 = L1;
  ATTACH(L1);
  return 1;
LAB102:
  L2 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L2,&L3);
  L5 = G_code_TEXT_NR2912;
  L4 = Concat(L5,L3);
D_TEXT(L3);
  *P1 = L4;
  return 1;
LAB105:
  L6 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L6,&L7);
  L10 = G_code_TEXT_NR2913;
  L9 = Concat(L10,L7);
D_TEXT(L7);
  L11 = G_code_TEXT_NR2914;
  L8 = Concat(L9,L11);
D_TEXT(L9);
  *P1 = L8;
  return 1;
LAB108:
  L12 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L12,&L13);
  L16 = G_code_TEXT_NR2915;
  L15 = Concat(L16,L13);
D_TEXT(L13);
  L17 = G_code_TEXT_NR2916;
  L14 = Concat(L15,L17);
D_TEXT(L15);
  *P1 = L14;
  return 1;
LAB111:
  L18 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L18,&L19);
  L21 = G_code_TEXT_NR2917;
  L20 = Concat(L21,L19);
D_TEXT(L19);
  *P1 = L20;
  return 1;
LAB114:
  L22 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L22,&L23);
  L25 = G_code_TEXT_NR2918;
  L24 = Concat(L25,L23);
D_TEXT(L23);
  *P1 = L24;
  return 1;
LAB117:
  L26 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L26,&L27);
  L29 = G_code_TEXT_NR2919;
  L28 = Concat(L29,L27);
D_TEXT(L27);
  *P1 = L28;
  return 1;
LAB120:
  L30 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L30,&L31);
  L33 = G_code_TEXT_NR2920;
  L32 = Concat(L33,L31);
D_TEXT(L31);
  *P1 = L32;
  return 1;
LAB123:
  L34 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L34,&L35);
  L37 = G_code_TEXT_NR2921;
  L36 = Concat(L37,L35);
D_TEXT(L35);
  *P1 = L36;
  return 1;
LAB126:
  L38 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L38,&L39);
  L41 = G_code_TEXT_NR2922;
  L40 = Concat(L41,L39);
D_TEXT(L39);
  *P1 = L40;
  return 1;
LAB129:
  L42 = (value)(L0[1]);
  L43 = (value)(L0[2]);
  Mcode_P_get_ADDRESS_TEXT(L42,&L44);
  E60_bindec_INT_TEXT(L43,&L45);
  L48 = G_code_TEXT_NR2923;
  L47 = Concat(L44,L48);
D_TEXT(L44);
  L46 = Concat(L47,L45);
D_TEXT(L47);
D_TEXT(L45);
  *P1 = L46;
  return 1;
LAB132:
  L49 = (value)(L0[1]);
  Mcode_P_get_ADDRESS_TEXT(L49,&L50);
  L52 = G_code_TEXT_NR2924;
  L51 = Concat(L52,L50);
D_TEXT(L50);
  *P1 = L51;
  return 1;
LAB135:
  L53 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L53,&L54);
  L56 = G_code_TEXT_NR2925;
  L55 = Concat(L56,L54);
D_TEXT(L54);
  *P1 = L55;
  return 1;
LAB138:
  L57 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L57,&L58);
  L61 = G_code_TEXT_NR2926;
  L60 = Concat(L61,L58);
D_TEXT(L58);
  L62 = G_code_TEXT_NR2927;
  L59 = Concat(L60,L62);
D_TEXT(L60);
  *P1 = L59;
  return 1;
LAB140:
  Abort(617, module_name);
}

int Mcode_P_get_ADDRESSES_TEXT(P0,P1)
value P0;
value *P1;
{
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB141;
  case 1: goto LAB144;
  case 2: goto LAB147;
  default: goto LAB149;
  };
LAB141:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Mcode_P_get_ADDRESS_TEXT(L1,&L3);
  Mcode_P_get_ADDRESSES_TEXT(L2,&L4);
  L7 = G_code_TEXT_NR2928;
  L6 = Concat(L3,L7);
D_TEXT(L3);
  L5 = Concat(L6,L4);
D_TEXT(L6);
D_TEXT(L4);
  *P1 = L5;
  return 1;
LAB144:
  L8 = (value)(L0[1]);
  Mcode_P_get_ADDRESSES_TEXT(L8,&L9);
  L11 = G_code_TEXT_NR2929;
  L10 = Concat(L11,L9);
D_TEXT(L9);
  *P1 = L10;
  return 1;
LAB147:
  L12 = G_code_TEXT_NR2930;
  *P1 = L12;
  ATTACH(L12);
  return 1;
LAB149:
  Abort(568, module_name);
}

int Mcode_P_dump_code_MODULENR_TEXT(P0,P1)
value P0;
value P1;
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = G_code_TEXT_NR2931;
  if (!E82_get_from_environment_TEXT_TEXT(L2,&L3)) goto LAB151;
D_TEXT(L3);
  Mmodules_P_get_MODULENR_MODULE(L0,&L4);
  L9 = G_code_TEXT_NR2932;
  L8 = Concat(L9,L4);
D_TEXT(L4);
  L10 = G_code_TEXT_NR2933;
  L7 = Concat(L8,L10);
D_TEXT(L8);
  L6 = Concat(L7,L1);
D_TEXT(L7);
  L11 = G_code_TEXT_NR2934;
  L5 = Concat(L6,L11);
D_TEXT(L6);
  E10_write_TEXT(L5);
D_TEXT(L5);
  L12 = C_INT(0);
  L13 = (value)G_code_END_NR7;
  Mcode_P_dump_code_LOCATION_LOCATION(L12,L13);
  return 1;
LAB151:
  return 1;
}

int Mcode_P_dump_instruction_INSTRUCTION(P0)
value P0;
{
  value L343;
  value L342;
  value L341;
  value L340;
  value L339;
  value L338;
  value L337;
  value L336;
  value L335;
  value L334;
  value L333;
  value L332;
  value L331;
  value L330;
  value L329;
  value L328;
  value L327;
  value L326;
  value L325;
  value L324;
  value L323;
  value L322;
  value L321;
  value L320;
  value L319;
  value L318;
  value L317;
  value L316;
  value L315;
  value L314;
  value L313;
  value L312;
  value L311;
  value L310;
  value L309;
  value L308;
  value L307;
  value L306;
  value L305;
  value L304;
  value L303;
  value L302;
  value L301;
  value L300;
  value L299;
  value L298;
  value L297;
  value L296;
  value L295;
  value L294;
  value L293;
  value L292;
  value L291;
  value L290;
  value L289;
  value L288;
  value L287;
  value L286;
  value L285;
  value L284;
  value L283;
  value L282;
  value L281;
  value L280;
  value L279;
  value L278;
  value L277;
  value L276;
  value L275;
  value L274;
  value L273;
  value L272;
  value L271;
  value L270;
  value L269;
  value L268;
  value L267;
  value L266;
  value L265;
  value L264;
  value L263;
  value L262;
  value L261;
  value L260;
  value L259;
  value L258;
  value L257;
  value L256;
  value L255;
  value L254;
  value L253;
  value L252;
  value L251;
  value L250;
  value L249;
  value L248;
  value L247;
  value L246;
  value L245;
  value L244;
  value L243;
  value L242;
  value L241;
  value L240;
  value L239;
  value L238;
  value L237;
  value L236;
  value L235;
  value L234;
  value L233;
  value L232;
  value L231;
  value L230;
  value L229;
  value L228;
  value L227;
  value L226;
  value L225;
  value L224;
  value L223;
  value L222;
  value L221;
  value L220;
  value L219;
  value L218;
  value L217;
  value L216;
  value L215;
  value L214;
  value L213;
  value L212;
  value L211;
  value L210;
  value L209;
  value L208;
  value L207;
  value L206;
  value L205;
  value L204;
  value L203;
  value L202;
  value L201;
  value L200;
  value L199;
  value L198;
  value L197;
  value L196;
  value L195;
  value L194;
  value L193;
  value L192;
  value L191;
  value L190;
  value L189;
  value L188;
  value L187;
  value L186;
  value L185;
  value L184;
  value L183;
  value L182;
  value L181;
  value L180;
  value L179;
  value L178;
  value L177;
  value L176;
  value L175;
  value L174;
  value L173;
  value L172;
  value L171;
  value L170;
  value L169;
  value L168;
  value L167;
  value L166;
  value L165;
  value L164;
  value L163;
  value L162;
  value L161;
  value L160;
  value L159;
  value L158;
  value L157;
  value L156;
  value L155;
  value L154;
  value L153;
  value L152;
  value L151;
  value L150;
  value L149;
  value L148;
  value L147;
  value L146;
  value L145;
  value L144;
  value L143;
  value L142;
  value L141;
  value L140;
  value L139;
  value L138;
  value L137;
  value L136;
  value L135;
  value L134;
  value L133;
  value L132;
  value L131;
  value L130;
  value L129;
  value L128;
  value L127;
  value L126;
  value L125;
  value L124;
  value L123;
  value L122;
  value L121;
  value L120;
  value L119;
  value L118;
  value L117;
  value L116;
  value L115;
  value L114;
  value L113;
  value L112;
  value L111;
  value L110;
  value L109;
  value L108;
  value L107;
  value L106;
  value L105;
  value L104;
  value L103;
  value L102;
  value L101;
  value L100;
  value L99;
  value L98;
  value L97;
  value L96;
  value L95;
  value L94;
  value L93;
  value L92;
  value L91;
  value L90;
  value L89;
  value L88;
  value L87;
  value L86;
  value L85;
  value L84;
  value L83;
  value L82;
  value L81;
  value L80;
  value L79;
  value L78;
  value L77;
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L3 = L0;
  switch (Alternative(L3)) {
  case 0: goto LAB457;
  case 1: goto LAB460;
  case 2: goto LAB463;
  case 3: goto LAB466;
  case 4: goto LAB469;
  case 5: goto LAB472;
  case 6: goto LAB475;
  case 7: goto LAB478;
  case 8: goto LAB481;
  case 9: goto LAB484;
  case 10: goto LAB487;
  case 11: goto LAB490;
  case 12: goto LAB493;
  case 13: goto LAB496;
  case 14: goto LAB499;
  case 15: goto LAB502;
  case 16: goto LAB505;
  case 17: goto LAB508;
  case 18: goto LAB511;
  case 19: goto LAB514;
  case 20: goto LAB517;
  case 21: goto LAB520;
  case 22: goto LAB523;
  case 23: goto LAB526;
  case 24: goto LAB529;
  case 25: goto LAB563;
  case 26: goto LAB573;
  case 27: goto LAB576;
  case 28: goto LAB579;
  case 29: goto LAB582;
  case 30: goto LAB585;
  case 31: goto LAB588;
  case 32: goto LAB591;
  case 33: goto LAB594;
  case 35: goto LAB597;
  case 34: goto LAB600;
  default: goto LAB602;
  };
LAB457:
  L4 = G_code_TEXT_NR2946;
  L1 = L4;
  ATTACH(L4);
  goto LAB456;
LAB460:
  L5 = (value)(L3[1]);
  E60_bindec_INT_TEXT(L5,&L6);
  L8 = G_code_TEXT_NR2947;
  L7 = Concat(L8,L6);
D_TEXT(L6);
  L1 = L7;
  goto LAB456;
LAB463:
  L9 = (value)(L3[1]);
  L10 = (value)(L3[2]);
  L11 = (value)(L3[3]);
  E60_bindec_INT_TEXT(L9,&L12);
  E60_bindec_INT_TEXT(L10,&L13);
  E60_bindec_INT_TEXT(L11,&L14);
  L21 = G_code_TEXT_NR2948;
  L20 = Concat(L21,L12);
D_TEXT(L12);
  L22 = G_code_TEXT_NR2949;
  L19 = Concat(L20,L22);
D_TEXT(L20);
  L18 = Concat(L19,L13);
D_TEXT(L19);
D_TEXT(L13);
  L23 = G_code_TEXT_NR2950;
  L17 = Concat(L18,L23);
D_TEXT(L18);
  L16 = Concat(L17,L14);
D_TEXT(L17);
D_TEXT(L14);
  L24 = G_code_TEXT_NR2951;
  L15 = Concat(L16,L24);
D_TEXT(L16);
  L1 = L15;
  goto LAB456;
LAB466:
  L25 = G_code_TEXT_NR2952;
  L1 = L25;
  ATTACH(L25);
  goto LAB456;
LAB469:
  L26 = (value)(L3[1]);
  L27 = (value)(L3[2]);
  L28 = (value)(L3[3]);
  Mrules_P_build_rule_RULENR_TEXT(L26,&L29);
  E60_bindec_INT_TEXT(L26,&L30);
  E60_bindec_INT_TEXT(L27,&L31);
  E60_bindec_INT_TEXT(L28,&L32);
  L41 = G_code_TEXT_NR2953;
  L40 = Concat(L41,L29);
D_TEXT(L29);
  L42 = G_code_TEXT_NR2954;
  L39 = Concat(L40,L42);
D_TEXT(L40);
  L38 = Concat(L39,L30);
D_TEXT(L39);
D_TEXT(L30);
  L43 = G_code_TEXT_NR2955;
  L37 = Concat(L38,L43);
D_TEXT(L38);
  L36 = Concat(L37,L31);
D_TEXT(L37);
D_TEXT(L31);
  L44 = G_code_TEXT_NR2956;
  L35 = Concat(L36,L44);
D_TEXT(L36);
  L34 = Concat(L35,L32);
D_TEXT(L35);
D_TEXT(L32);
  L45 = G_code_TEXT_NR2957;
  L33 = Concat(L34,L45);
D_TEXT(L34);
  L1 = L33;
  goto LAB456;
LAB472:
  L46 = G_code_TEXT_NR2958;
  L1 = L46;
  ATTACH(L46);
  goto LAB456;
LAB475:
  L47 = (value)(L3[1]);
  Mrules_P_build_rule_RULENR_TEXT(L47,&L48);
  L50 = G_code_TEXT_NR2959;
  L49 = Concat(L50,L48);
D_TEXT(L48);
  L1 = L49;
  goto LAB456;
LAB478:
  L51 = G_code_TEXT_NR2960;
  L1 = L51;
  ATTACH(L51);
  goto LAB456;
LAB481:
  L52 = G_code_TEXT_NR2961;
  L1 = L52;
  ATTACH(L52);
  goto LAB456;
LAB484:
  L53 = (value)(L3[1]);
  E60_bindec_INT_TEXT(L53,&L54);
  L57 = G_code_TEXT_NR2962;
  L56 = Concat(L57,L54);
D_TEXT(L54);
  L58 = G_code_TEXT_NR2963;
  L55 = Concat(L56,L58);
D_TEXT(L56);
  L1 = L55;
  goto LAB456;
LAB487:
  L59 = (value)(L3[1]);
  L60 = (value)(L3[2]);
  L61 = (value)(L3[3]);
  Mrules_P_build_rule_RULENR_TEXT(L59,&L62);
  E60_bindec_INT_TEXT(L59,&L63);
  Mcode_P_get_ADDRESSES_TEXT(L60,&L64);
  E60_bindec_INT_TEXT(L61,&L65);
  L74 = G_code_TEXT_NR2964;
  L73 = Concat(L74,L62);
D_TEXT(L62);
  L75 = G_code_TEXT_NR2965;
  L72 = Concat(L73,L75);
D_TEXT(L73);
  L71 = Concat(L72,L63);
D_TEXT(L72);
D_TEXT(L63);
  L76 = G_code_TEXT_NR2966;
  L70 = Concat(L71,L76);
D_TEXT(L71);
  L69 = Concat(L70,L64);
D_TEXT(L70);
D_TEXT(L64);
  L77 = G_code_TEXT_NR2967;
  L68 = Concat(L69,L77);
D_TEXT(L69);
  L67 = Concat(L68,L65);
D_TEXT(L68);
D_TEXT(L65);
  L78 = G_code_TEXT_NR2968;
  L66 = Concat(L67,L78);
D_TEXT(L67);
  L1 = L66;
  goto LAB456;
LAB490:
  L79 = (value)(L3[1]);
  L80 = (value)(L3[2]);
  Mrules_P_build_rule_RULENR_TEXT(L79,&L81);
  E60_bindec_INT_TEXT(L79,&L82);
  Mcode_P_get_ADDRESSES_TEXT(L80,&L83);
  L90 = G_code_TEXT_NR2969;
  L89 = Concat(L90,L81);
D_TEXT(L81);
  L91 = G_code_TEXT_NR2970;
  L88 = Concat(L89,L91);
D_TEXT(L89);
  L87 = Concat(L88,L82);
D_TEXT(L88);
D_TEXT(L82);
  L92 = G_code_TEXT_NR2971;
  L86 = Concat(L87,L92);
D_TEXT(L87);
  L85 = Concat(L86,L83);
D_TEXT(L86);
D_TEXT(L83);
  L93 = G_code_TEXT_NR2972;
  L84 = Concat(L85,L93);
D_TEXT(L85);
  L1 = L84;
  goto LAB456;
LAB493:
  L94 = (value)(L3[1]);
  E60_bindec_INT_TEXT(L94,&L95);
  L97 = G_code_TEXT_NR2973;
  L96 = Concat(L97,L95);
D_TEXT(L95);
  L1 = L96;
  goto LAB456;
LAB496:
  L98 = G_code_TEXT_NR2974;
  L1 = L98;
  ATTACH(L98);
  goto LAB456;
LAB499:
  L99 = G_code_TEXT_NR2975;
  L1 = L99;
  ATTACH(L99);
  goto LAB456;
LAB502:
  L100 = G_code_TEXT_NR2976;
  L1 = L100;
  ATTACH(L100);
  goto LAB456;
LAB505:
  L101 = G_code_TEXT_NR2977;
  L1 = L101;
  ATTACH(L101);
  goto LAB456;
LAB508:
  L102 = G_code_TEXT_NR2978;
  L1 = L102;
  ATTACH(L102);
  goto LAB456;
LAB511:
  L103 = (value)(L3[1]);
  L104 = (value)(L3[2]);
  Mcode_P_get_ADDRESS_TEXT(L104,&L105);
  L110 = G_code_TEXT_NR2979;
  L109 = Concat(L110,L103);
  L111 = G_code_TEXT_NR2980;
  L108 = Concat(L109,L111);
D_TEXT(L109);
  L107 = Concat(L108,L105);
D_TEXT(L108);
D_TEXT(L105);
  L112 = G_code_TEXT_NR2981;
  L106 = Concat(L107,L112);
D_TEXT(L107);
  L1 = L106;
  goto LAB456;
LAB514:
  L113 = (value)(L3[1]);
  L116 = G_code_TEXT_NR2982;
  L115 = Concat(L116,L113);
  L117 = G_code_TEXT_NR2983;
  L114 = Concat(L115,L117);
D_TEXT(L115);
  L1 = L114;
  goto LAB456;
LAB517:
  L118 = (value)(L3[1]);
  L119 = (value)(L3[2]);
  E60_bindec_INT_TEXT(L118,&L120);
  E60_bindec_INT_TEXT(L119,&L121);
  L126 = G_code_TEXT_NR2984;
  L125 = Concat(L126,L120);
D_TEXT(L120);
  L127 = G_code_TEXT_NR2985;
  L124 = Concat(L125,L127);
D_TEXT(L125);
  L123 = Concat(L124,L121);
D_TEXT(L124);
D_TEXT(L121);
  L128 = G_code_TEXT_NR2986;
  L122 = Concat(L123,L128);
D_TEXT(L123);
  L1 = L122;
  goto LAB456;
LAB520:
  L129 = (value)(L3[1]);
  L132 = G_code_TEXT_NR2987;
  L131 = Concat(L132,L129);
  L133 = G_code_TEXT_NR2988;
  L130 = Concat(L131,L133);
D_TEXT(L131);
  L1 = L130;
  goto LAB456;
LAB523:
  L134 = (value)(L3[1]);
  L135 = (value)(L3[2]);
  E60_bindec_INT_TEXT(L134,&L136);
  E60_bindec_INT_TEXT(L135,&L137);
  L142 = G_code_TEXT_NR2989;
  L141 = Concat(L142,L136);
D_TEXT(L136);
  L143 = G_code_TEXT_NR2990;
  L140 = Concat(L141,L143);
D_TEXT(L141);
  L139 = Concat(L140,L137);
D_TEXT(L140);
D_TEXT(L137);
  L144 = G_code_TEXT_NR2991;
  L138 = Concat(L139,L144);
D_TEXT(L139);
  L1 = L138;
  goto LAB456;
LAB526:
  L145 = (value)(L3[1]);
  L146 = (value)(L3[2]);
  L147 = (value)(L3[3]);
  Mcode_P_get_ADDRESS_TEXT(L145,&L148);
  Mcode_P_get_ADDRESS_TEXT(L146,&L149);
  Mcode_P_get_ADDRESS_TEXT(L147,&L150);
  L157 = G_code_TEXT_NR2992;
  L156 = Concat(L157,L148);
D_TEXT(L148);
  L158 = G_code_TEXT_NR2993;
  L155 = Concat(L156,L158);
D_TEXT(L156);
  L154 = Concat(L155,L149);
D_TEXT(L155);
D_TEXT(L149);
  L159 = G_code_TEXT_NR2994;
  L153 = Concat(L154,L159);
D_TEXT(L154);
  L152 = Concat(L153,L150);
D_TEXT(L153);
D_TEXT(L150);
  L160 = G_code_TEXT_NR2995;
  L151 = Concat(L152,L160);
D_TEXT(L152);
  L1 = L151;
  goto LAB456;
LAB529:
  L161 = (value)(L3[1]);
  L162 = (value)(L3[2]);
  L163 = (value)(L3[3]);
  L164 = (value)(L3[4]);
  Mcode_P_get_ADDRESS_TEXT(L161,&L165);
  Mcode_P_get_ADDRESS_TEXT(L163,&L166);
  Mcode_P_get_ADDRESS_TEXT(L164,&L167);
  L330 = L162;
  switch (Alternative(L330)) {
  case 0: goto LAB531;
  case 1: goto LAB535;
  case 2: goto LAB538;
  case 3: goto LAB541;
  case 4: goto LAB544;
  case 5: goto LAB547;
  case 6: goto LAB550;
  case 7: goto LAB553;
  case 8: goto LAB556;
  case 9: goto LAB559;
  default: goto LAB561;
  };
LAB531:
  L331 = G_code_TEXT_NR3044;
  L168 = L331;
  ATTACH(L331);
  goto LAB533;
LAB535:
  L332 = G_code_TEXT_NR3045;
  L168 = L332;
  ATTACH(L332);
  goto LAB533;
LAB538:
  L333 = G_code_TEXT_NR3046;
  L168 = L333;
  ATTACH(L333);
  goto LAB533;
LAB541:
  L334 = G_code_TEXT_NR3047;
  L168 = L334;
  ATTACH(L334);
  goto LAB533;
LAB544:
  L335 = G_code_TEXT_NR3048;
  L168 = L335;
  ATTACH(L335);
  goto LAB533;
LAB547:
  L336 = G_code_TEXT_NR3049;
  L168 = L336;
  ATTACH(L336);
  goto LAB533;
LAB550:
  L337 = G_code_TEXT_NR3050;
  L168 = L337;
  ATTACH(L337);
  goto LAB533;
LAB553:
  L338 = G_code_TEXT_NR3051;
  L168 = L338;
  ATTACH(L338);
  goto LAB533;
LAB556:
  L339 = G_code_TEXT_NR3052;
  L168 = L339;
  ATTACH(L339);
  goto LAB533;
LAB559:
  L340 = G_code_TEXT_NR3053;
  L168 = L340;
  ATTACH(L340);
LAB533:
  L177 = G_code_TEXT_NR2996;
  L176 = Concat(L177,L165);
D_TEXT(L165);
  L178 = G_code_TEXT_NR2997;
  L175 = Concat(L176,L178);
D_TEXT(L176);
  L174 = Concat(L175,L168);
D_TEXT(L175);
D_TEXT(L168);
  L179 = G_code_TEXT_NR2998;
  L173 = Concat(L174,L179);
D_TEXT(L174);
  L172 = Concat(L173,L166);
D_TEXT(L173);
D_TEXT(L166);
  L180 = G_code_TEXT_NR2999;
  L171 = Concat(L172,L180);
D_TEXT(L172);
  L170 = Concat(L171,L167);
D_TEXT(L171);
D_TEXT(L167);
  L181 = G_code_TEXT_NR3000;
  L169 = Concat(L170,L181);
D_TEXT(L170);
  L1 = L169;
  goto LAB456;
LAB561:
  Abort(647, module_name);
LAB563:
  L182 = (value)(L3[1]);
  L183 = (value)(L3[2]);
  L184 = (value)(L3[3]);
  Mcode_P_get_ADDRESS_TEXT(L183,&L185);
  Mcode_P_get_ADDRESS_TEXT(L184,&L186);
  L341 = L182;
  switch (Alternative(L341)) {
  case 0: goto LAB565;
  case 1: goto LAB569;
  default: goto LAB571;
  };
LAB565:
  L342 = G_code_TEXT_NR3042;
  L187 = L342;
  ATTACH(L342);
  goto LAB567;
LAB569:
  L343 = G_code_TEXT_NR3043;
  L187 = L343;
  ATTACH(L343);
LAB567:
  L194 = G_code_TEXT_NR3001;
  L193 = Concat(L194,L185);
D_TEXT(L185);
  L195 = G_code_TEXT_NR3002;
  L192 = Concat(L193,L195);
D_TEXT(L193);
  L191 = Concat(L192,L187);
D_TEXT(L192);
D_TEXT(L187);
  L196 = G_code_TEXT_NR3003;
  L190 = Concat(L191,L196);
D_TEXT(L191);
  L189 = Concat(L190,L186);
D_TEXT(L190);
D_TEXT(L186);
  L197 = G_code_TEXT_NR3004;
  L188 = Concat(L189,L197);
D_TEXT(L189);
  L1 = L188;
  goto LAB456;
LAB571:
  Abort(624, module_name);
LAB573:
  L198 = (value)(L3[1]);
  L199 = (value)(L3[2]);
  L200 = (value)(L3[3]);
  Mcode_P_get_ADDRESS_TEXT(L198,&L201);
  Mcode_P_get_ADDRESS_TEXT(L199,&L202);
  E60_bindec_INT_TEXT(L200,&L203);
  L210 = G_code_TEXT_NR3005;
  L209 = Concat(L210,L201);
D_TEXT(L201);
  L211 = G_code_TEXT_NR3006;
  L208 = Concat(L209,L211);
D_TEXT(L209);
  L207 = Concat(L208,L202);
D_TEXT(L208);
D_TEXT(L202);
  L212 = G_code_TEXT_NR3007;
  L206 = Concat(L207,L212);
D_TEXT(L207);
  L205 = Concat(L206,L203);
D_TEXT(L206);
D_TEXT(L203);
  L213 = G_code_TEXT_NR3008;
  L204 = Concat(L205,L213);
D_TEXT(L205);
  L1 = L204;
  goto LAB456;
LAB576:
  L214 = (value)(L3[1]);
  L215 = (value)(L3[2]);
  L216 = (value)(L3[3]);
  Mcode_P_get_ADDRESS_TEXT(L214,&L217);
  Mcode_P_get_ADDRESS_TEXT(L216,&L218);
  E60_bindec_INT_TEXT(L215,&L219);
  L226 = G_code_TEXT_NR3009;
  L225 = Concat(L226,L217);
D_TEXT(L217);
  L227 = G_code_TEXT_NR3010;
  L224 = Concat(L225,L227);
D_TEXT(L225);
  L223 = Concat(L224,L219);
D_TEXT(L224);
D_TEXT(L219);
  L228 = G_code_TEXT_NR3011;
  L222 = Concat(L223,L228);
D_TEXT(L223);
  L221 = Concat(L222,L218);
D_TEXT(L222);
D_TEXT(L218);
  L229 = G_code_TEXT_NR3012;
  L220 = Concat(L221,L229);
D_TEXT(L221);
  L1 = L220;
  goto LAB456;
LAB579:
  L230 = (value)(L3[1]);
  L231 = (value)(L3[2]);
  Mcode_P_get_ADDRESS_TEXT(L230,&L232);
  Mcode_P_get_ADDRESS_TEXT(L231,&L233);
  L238 = G_code_TEXT_NR3013;
  L237 = Concat(L238,L232);
D_TEXT(L232);
  L239 = G_code_TEXT_NR3014;
  L236 = Concat(L237,L239);
D_TEXT(L237);
  L235 = Concat(L236,L233);
D_TEXT(L236);
D_TEXT(L233);
  L240 = G_code_TEXT_NR3015;
  L234 = Concat(L235,L240);
D_TEXT(L235);
  L1 = L234;
  goto LAB456;
LAB582:
  L241 = (value)(L3[1]);
  L242 = (value)(L3[2]);
  L243 = (value)(L3[3]);
  L244 = (value)(L3[4]);
  Mcode_P_get_ADDRESS_TEXT(L241,&L245);
  Mcode_P_get_ADDRESS_TEXT(L243,&L246);
  E60_bindec_INT_TEXT(L242,&L247);
  E60_bindec_INT_TEXT(L244,&L248);
  L257 = G_code_TEXT_NR3016;
  L256 = Concat(L257,L245);
D_TEXT(L245);
  L258 = G_code_TEXT_NR3017;
  L255 = Concat(L256,L258);
D_TEXT(L256);
  L254 = Concat(L255,L247);
D_TEXT(L255);
D_TEXT(L247);
  L259 = G_code_TEXT_NR3018;
  L253 = Concat(L254,L259);
D_TEXT(L254);
  L252 = Concat(L253,L246);
D_TEXT(L253);
D_TEXT(L246);
  L260 = G_code_TEXT_NR3019;
  L251 = Concat(L252,L260);
D_TEXT(L252);
  L250 = Concat(L251,L248);
D_TEXT(L251);
D_TEXT(L248);
  L261 = G_code_TEXT_NR3020;
  L249 = Concat(L250,L261);
D_TEXT(L250);
  L1 = L249;
  goto LAB456;
LAB585:
  L262 = (value)(L3[1]);
  L263 = (value)(L3[2]);
  L264 = (value)(L3[3]);
  Mcode_P_get_ADDRESS_TEXT(L262,&L265);
  E60_bindec_INT_TEXT(L263,&L266);
  Mcode_P_get_LABELS_TEXT(L264,&L267);
  L274 = G_code_TEXT_NR3021;
  L273 = Concat(L274,L265);
D_TEXT(L265);
  L275 = G_code_TEXT_NR3022;
  L272 = Concat(L273,L275);
D_TEXT(L273);
  L271 = Concat(L272,L266);
D_TEXT(L272);
D_TEXT(L266);
  L276 = G_code_TEXT_NR3023;
  L270 = Concat(L271,L276);
D_TEXT(L271);
  L269 = Concat(L270,L267);
D_TEXT(L270);
D_TEXT(L267);
  L277 = G_code_TEXT_NR3024;
  L268 = Concat(L269,L277);
D_TEXT(L269);
  L1 = L268;
  goto LAB456;
LAB588:
  L278 = (value)(L3[1]);
  L279 = (value)(L3[2]);
  L280 = (value)(L3[3]);
  L281 = (value)(L3[4]);
  Mcode_P_get_ADDRESS_TEXT(L278,&L282);
  E60_bindec_INT_TEXT(L279,&L283);
  E60_bindec_INT_TEXT(L280,&L284);
  E60_bindec_INT_TEXT(L281,&L285);
  L294 = G_code_TEXT_NR3025;
  L293 = Concat(L294,L282);
D_TEXT(L282);
  L295 = G_code_TEXT_NR3026;
  L292 = Concat(L293,L295);
D_TEXT(L293);
  L291 = Concat(L292,L283);
D_TEXT(L292);
D_TEXT(L283);
  L296 = G_code_TEXT_NR3027;
  L290 = Concat(L291,L296);
D_TEXT(L291);
  L289 = Concat(L290,L284);
D_TEXT(L290);
D_TEXT(L284);
  L297 = G_code_TEXT_NR3028;
  L288 = Concat(L289,L297);
D_TEXT(L289);
  L287 = Concat(L288,L285);
D_TEXT(L288);
D_TEXT(L285);
  L298 = G_code_TEXT_NR3029;
  L286 = Concat(L287,L298);
D_TEXT(L287);
  L1 = L286;
  goto LAB456;
LAB591:
  L299 = (value)(L3[1]);
  L300 = (value)(L3[2]);
  Mcode_P_get_ADDRESS_TEXT(L299,&L301);
  E60_bindec_INT_TEXT(L300,&L302);
  L307 = G_code_TEXT_NR3030;
  L306 = Concat(L307,L301);
D_TEXT(L301);
  L308 = G_code_TEXT_NR3031;
  L305 = Concat(L306,L308);
D_TEXT(L306);
  L304 = Concat(L305,L302);
D_TEXT(L305);
D_TEXT(L302);
  L309 = G_code_TEXT_NR3032;
  L303 = Concat(L304,L309);
D_TEXT(L304);
  L1 = L303;
  goto LAB456;
LAB594:
  L310 = (value)(L3[1]);
  L311 = (value)(L3[2]);
  Mcode_P_get_ADDRESS_TEXT(L310,&L312);
  E60_bindec_INT_TEXT(L311,&L313);
  L318 = G_code_TEXT_NR3033;
  L317 = Concat(L318,L312);
D_TEXT(L312);
  L319 = G_code_TEXT_NR3034;
  L316 = Concat(L317,L319);
D_TEXT(L317);
  L315 = Concat(L316,L313);
D_TEXT(L316);
D_TEXT(L313);
  L320 = G_code_TEXT_NR3035;
  L314 = Concat(L315,L320);
D_TEXT(L315);
  L1 = L314;
  goto LAB456;
LAB597:
  L321 = (value)(L3[1]);
  L322 = (value)(L3[2]);
  L323 = (value)(L3[3]);
  E60_bindec_INT_TEXT(L323,&L324);
  L327 = G_code_TEXT_NR3036;
  L326 = Concat(L327,L324);
D_TEXT(L324);
  L328 = G_code_TEXT_NR3037;
  L325 = Concat(L326,L328);
D_TEXT(L326);
  L1 = L325;
  goto LAB456;
LAB600:
  L329 = G_code_TEXT_NR3038;
  L1 = L329;
  ATTACH(L329);
LAB456:
  E10_write_TEXT(L1);
D_TEXT(L1);
  L2 = G_code_TEXT_NR2935;
  E10_write_TEXT(L2);
  return 1;
LAB602:
  Abort(537, module_name);
}

int Mcode_P_dump_code_TEXT_LOCATION_LOCATION(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = G_code_TEXT_NR2936;
  E10_write_TEXT(L3);
  E11_write_INT(L1);
  L4 = G_code_TEXT_NR2937;
  E10_write_TEXT(L4);
  E11_write_INT(L2);
  L7 = G_code_TEXT_NR2938;
  L6 = Concat(L7,L0);
  L8 = G_code_TEXT_NR2939;
  L5 = Concat(L6,L8);
D_TEXT(L6);
  E10_write_TEXT(L5);
D_TEXT(L5);
  Mcode_P_dump_code_LOCATION_LOCATION(L1,L2);
  return 1;
}

int Mcode_P_make_dump_TEXT(P0)
value P0;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_code_DUMPS_NR4;
  L2 = L0;
  L3 = L1;
LAB626:
  switch (Alternative(L3)) {
  case 1: goto LAB627;
  default: goto LAB153;
  };
LAB627:
  L4 = (value)(L3[1]);
  L5 = (value)(L3[2]);
  L6 = G_code_TEXT_NR3054;
  if (!EQ_TEXT(L4,L6)) goto LAB631;
  return 1;
LAB631:
  if (!EQ_TEXT(L4,L2)) goto LAB633;
  return 1;
LAB633:
  L3 = L5;
  goto LAB626;
  return 1;
LAB153:
  return 0;
}

int Mcode_P_request_dump_TEXT(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Create(&L1,1,2);
  *(value *)(L1+1) = L0;
  ATTACH(L0);
  L2 = G_code_DUMPS_NR4;
  ATTACH(L2);
  *(value *)(L1+2) = L2;
if(DecrRefs(G_code_DUMPS_NR4)<0)
XD_Mcode_T82(G_code_DUMPS_NR4);
  G_code_DUMPS_NR4 = L1;
  return 1;
}

int Mcode_P_init()
{
  value L0;
  L0 = G_code_DUMP_NR2940;
  ATTACH(L0);
if(DecrRefs(G_code_DUMPS_NR4)<0)
XD_Mcode_T82(G_code_DUMPS_NR4);
  G_code_DUMPS_NR4 = L0;
  Mcode_P_start_coding();
  return 1;
}

int Mcode_P_dump_LOCATION(P0)
value P0;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_code_END_NR7;
  if (!(L0 == L1)) goto LAB161;
  L2 = G_code_TEXT_NR2941;
  E10_write_TEXT(L2);
  return 1;
LAB161:
  E11_write_INT(L0);
  Mcode_P_get_LOCATION_INSTRUCTION(L0,&L3);
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  L4 = G_code_TEXT_NR2942;
  E10_write_TEXT(L4);
  L5 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L0));
  L6 = *((value*)L5);
  Mcode_P_dump_LOCATION(L6);
  return 1;
}

int Mcode_P_dump_code_LOCATION_LOCATION(P0,P1)
value P0;
value P1;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB623:
  if (!(L0 == L1)) goto LAB163;
  return 1;
LAB163:
  if (!Mcode_P_is_end_LOCATION(L0)) goto LAB165;
  return 1;
LAB165:
  Mcode_P_get_LOCATION_INSTRUCTION(L0,&L2);
  E11_write_INT(L0);
  L3 = G_code_TEXT_NR2943;
  E10_write_TEXT(L3);
  L4 = (value) Addr((value*)&G_code_PREV_NR5,Int(L0));
  L5 = *((value*)L4);
  E11_write_INT(L5);
  L6 = G_code_TEXT_NR2944;
  E10_write_TEXT(L6);
  L7 = (value) Addr((value*)&G_code_NEXT_NR2,Int(L0));
  L8 = *((value*)L7);
  E11_write_INT(L8);
  L9 = G_code_TEXT_NR2945;
  E10_write_TEXT(L9);
  Mcode_P_dump_instruction_INSTRUCTION(L2);
if(DecrRefs(L2)<0)
XD_Mcode_T14(L2);
  L10 = *((value*)L7);
  L0 = L10;
  goto LAB623;
}

int Mcode_P_write_LABELS(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  Mcode_P_get_LABELS_TEXT(L0,&L1);
  E10_write_TEXT(L1);
D_TEXT(L1);
  return 1;
}

int Mcode_P_get_LABELS_TEXT(P0,P1)
value P0;
value *P1;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB274;
  case 1: goto LAB277;
  default: goto LAB279;
  };
LAB274:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L3 = (value)(L0[3]);
  E60_bindec_INT_TEXT(L1,&L4);
  E60_bindec_INT_TEXT(L2,&L5);
  Mcode_P_get_LABELS_TEXT(L3,&L6);
  L11 = G_code_TEXT_NR3039;
  L10 = Concat(L4,L11);
D_TEXT(L4);
  L9 = Concat(L10,L5);
D_TEXT(L10);
D_TEXT(L5);
  L12 = G_code_TEXT_NR3040;
  L8 = Concat(L9,L12);
D_TEXT(L9);
  L7 = Concat(L8,L6);
D_TEXT(L8);
D_TEXT(L6);
  *P1 = L7;
  return 1;
LAB277:
  L13 = (value)(L0[1]);
  E60_bindec_INT_TEXT(L13,&L14);
  L16 = G_code_TEXT_NR3041;
  L15 = Concat(L16,L14);
D_TEXT(L14);
  *P1 = L15;
  return 1;
LAB279:
  Abort(552, module_name);
}

int Mcode_P_write_ADDRESSES(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  Mcode_P_get_ADDRESSES_TEXT(L0,&L1);
  E10_write_TEXT(L1);
D_TEXT(L1);
  return 1;
}

int Mcode_P_make_dump_TEXT_DUMP(P0,P1)
value P0;
value P1;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB624:
  switch (Alternative(L1)) {
  case 1: goto LAB316;
  default: goto LAB318;
  };
LAB316:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  L4 = G_code_TEXT_NR3054;
  if (!EQ_TEXT(L2,L4)) goto LAB320;
  return 1;
LAB320:
  if (!EQ_TEXT(L2,L0)) goto LAB322;
  return 1;
LAB322:
  L1 = L3;
  goto LAB624;
  return 0;
LAB318:
  return 0;
}

int Mcode_P_remove_goto_LOCATION_LOCATIONS_LOCATIONS(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  switch (Alternative(L1)) {
  case 1: goto LAB325;
  case 0: goto LAB328;
  default: goto LAB330;
  };
LAB325:
  Abort(727, module_name);
LAB328:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  if (!(L0 == L2)) goto LAB332;
  *P2 = L3;
  ATTACH(L3);
  return 1;
LAB332:
  Mcode_P_remove_goto_LOCATION_LOCATIONS_LOCATIONS(L0,L3,&L4);
  Create(&L5,0,2);
  *(value *)(L5+1) = L2;
  *(value *)(L5+2) = L4;
  *P2 = L5;
  return 1;
LAB330:
  Abort(733, module_name);
}

int Mcode_P_alias_LABEL_LABEL_LOCATIONS(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB622:
  switch (Alternative(L2)) {
  case 1: goto LAB333;
  case 0: goto LAB336;
  default: goto LAB338;
  };
LAB333:
  return 1;
LAB336:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = L0;
  L6 = L1;
  L7 = L3;
  Mcode_P_get_LOCATION_INSTRUCTION(L7,&L8);
  switch (Alternative(L8)) {
  case 12: goto LAB604;
  case 10: goto LAB609;
  case 29: goto LAB614;
  case 30: goto LAB619;
  default: goto LAB621;
  };
LAB604:
  L9 = (value)(L8[1]);
  if (!(L5 == L9)) goto LAB608;
if(DecrRefs(L8)<0)
XD_Mcode_T14(L8);
  Create(&L10,12,1);
  *(value *)(L10+1) = L6;
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L7,L10);
if(DecrRefs(L10)<0)
XD_Mcode_T14(L10);
  Mcode_P_register_goto_LABEL_LOCATION(L6,L7);
  goto LAB603;
LAB608:
  Abort(753, module_name);
LAB609:
  L11 = (value)(L8[1]);
  L12 = (value)(L8[2]);
  L13 = (value)(L8[3]);
  if (!(L5 == L13)) goto LAB613;
  Create(&L14,10,3);
  *(value *)(L14+1) = L11;
  *(value *)(L14+2) = L12;
  ATTACH(L12);
if(DecrRefs(L8)<0)
XD_Mcode_T14(L8);
  *(value *)(L14+3) = L6;
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L7,L14);
if(DecrRefs(L14)<0)
XD_Mcode_T14(L14);
  Mcode_P_register_goto_LABEL_LOCATION(L6,L7);
  goto LAB603;
LAB613:
if(DecrRefs(L8)<0)
XD_Mcode_T14(L8);
  Abort(758, module_name);
LAB614:
  L15 = (value)(L8[1]);
  L16 = (value)(L8[2]);
  L17 = (value)(L8[3]);
  L18 = (value)(L8[4]);
  if (!(L5 == L18)) goto LAB618;
  Create(&L19,29,4);
  *(value *)(L19+1) = L15;
  ATTACH(L15);
  *(value *)(L19+2) = L16;
  *(value *)(L19+3) = L17;
  ATTACH(L17);
if(DecrRefs(L8)<0)
XD_Mcode_T14(L8);
  *(value *)(L19+4) = L6;
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L7,L19);
if(DecrRefs(L19)<0)
XD_Mcode_T14(L19);
  Mcode_P_register_goto_LABEL_LOCATION(L6,L7);
  goto LAB603;
LAB618:
if(DecrRefs(L8)<0)
XD_Mcode_T14(L8);
  Abort(763, module_name);
LAB619:
  L20 = (value)(L8[1]);
  L21 = (value)(L8[2]);
  L22 = (value)(L8[3]);
  Mcode_P_alias_LABEL_LABEL_LABELS_LABELS_LOCATION(L5,L6,L22,&L23,L7);
  Create(&L24,30,3);
  *(value *)(L24+1) = L20;
  ATTACH(L20);
  *(value *)(L24+2) = L21;
if(DecrRefs(L8)<0)
XD_Mcode_T14(L8);
  *(value *)(L24+3) = L23;
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L7,L24);
if(DecrRefs(L24)<0)
XD_Mcode_T14(L24);
LAB603:
  L2 = L4;
  goto LAB622;
LAB621:
  L25 = G_code_TEXT_NR3055;
  Merrors_P_error_text_TEXT(L25);
  Merrors_P_error_int_INT(L5);
  L26 = G_code_TEXT_NR3056;
  Merrors_P_error_text_TEXT(L26);
  Merrors_P_error_int_INT(L6);
  L27 = G_code_TEXT_NR3057;
  Merrors_P_error_text_TEXT(L27);
  Mcode_P_dump_instruction_INSTRUCTION(L8);
if(DecrRefs(L8)<0)
XD_Mcode_T14(L8);
  Abort(770, module_name);
LAB338:
  Abort(745, module_name);
}

int Mcode_P_alias_LABEL_LABEL_LABELS_LABELS_LOCATION(P0,P1,P2,P3,P4)
value P0;
value P1;
value P2;
value *P3;
value P4;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P4;
  switch (Alternative(L2)) {
  case 1: goto LAB357;
  case 0: goto LAB362;
  default: goto LAB364;
  };
LAB357:
  L4 = (value)(L2[1]);
  if (!(L0 == L4)) goto LAB361;
  Create(&L5,1,1);
  *(value *)(L5+1) = L1;
  Mcode_P_register_goto_LABEL_LOCATION(L1,L3);
  *P3 = L5;
  return 1;
LAB361:
  *P3 = L2;
  ATTACH(L2);
  return 1;
LAB362:
  L6 = (value)(L2[1]);
  L7 = (value)(L2[2]);
  L8 = (value)(L2[3]);
  Mcode_P_alias_LABEL_LABEL_LABELS_LABELS_LOCATION(L0,L1,L8,&L9,L3);
  if (!(L0 == L7)) goto LAB366;
  Create(&L10,0,3);
  *(value *)(L10+1) = L6;
  *(value *)(L10+2) = L1;
  *(value *)(L10+3) = L9;
  Mcode_P_register_goto_LABEL_LOCATION(L1,L3);
  *P3 = L10;
  return 1;
LAB366:
  Create(&L11,0,3);
  *(value *)(L11+1) = L6;
  *(value *)(L11+2) = L7;
  *(value *)(L11+3) = L9;
  *P3 = L11;
  return 1;
LAB364:
  Abort(784, module_name);
}

int Mcode_P_absorb_goto_LABEL_LOCATIONS_INT_INT_INSTRUCTION(P0,P1,P2,P3,P4)
value P0;
value *P1;
value *P2;
value *P3;
value P4;
{
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = *P1;
  L2 = P4;
  switch (Alternative(L1)) {
  case 1: goto LAB367;
  case 0: goto LAB370;
  default: goto LAB372;
  };
LAB367:
  L3 = C_INT(0);
  L4 = C_INT(0);
  *P3 = L4;
  *P2 = L3;
  *P1 = L1;
  return 1;
LAB370:
  L5 = (value)(L1[1]);
  L6 = (value)(L1[2]);
  L7 = L6;
  ATTACH(L7);
  Mcode_P_absorb_goto_LABEL_LOCATIONS_INT_INT_INSTRUCTION(L0,&L7,&L8,&L9,L2);
  Mcode_P_get_LOCATION_INSTRUCTION(L5,&L10);
  switch (Alternative(L10)) {
  case 12: goto LAB373;
  default: goto LAB374;
  };
LAB373:
  L11 = (value)(L10[1]);
  if (!(L11 == L0)) goto LAB377;
  L12 = C_INT(1);
  L13 = C_INT(Int(L8) + Int(L12));
  Mcode_P_overwrite_LOCATION_INSTRUCTION(L5,L2);
  Mcode_P_remove_goto_LABEL_LOCATION(L11,L5);
if(DecrRefs(L10)<0)
XD_Mcode_T14(L10);
if(DecrRefs(L1)<0)
XD_Mcode_T16(L1);
  *P3 = L9;
  *P2 = L13;
  *P1 = L7;
  return 1;
LAB374:
if(DecrRefs(L10)<0)
XD_Mcode_T14(L10);
LAB375:
  Create(&L20,0,2);
  *(value *)(L20+1) = L5;
if(DecrRefs(L1)<0)
XD_Mcode_T16(L1);
  *(value *)(L20+2) = L7;
  L21 = C_INT(1);
  L22 = C_INT(Int(L9) + Int(L21));
  *P3 = L22;
  *P2 = L8;
  *P1 = L20;
  return 1;
LAB377:
if(DecrRefs(L7)<0)
XD_Mcode_T16(L7);
  L14 = G_code_TEXT_NR3058;
  Merrors_P_error_text_TEXT(L14);
  Merrors_P_error_int_INT(L5);
if(DecrRefs(L1)<0)
XD_Mcode_T16(L1);
  L15 = G_code_TEXT_NR3059;
  Merrors_P_error_text_TEXT(L15);
  L16 = G_code_TEXT_NR3060;
  Merrors_P_error_text_TEXT(L16);
  Merrors_P_error_int_INT(L0);
  L17 = G_code_TEXT_NR3061;
  Merrors_P_error_text_TEXT(L17);
  L18 = G_code_TEXT_NR3062;
  Merrors_P_error_text_TEXT(L18);
  Merrors_P_error_int_INT(L11);
if(DecrRefs(L10)<0)
XD_Mcode_T14(L10);
  L19 = G_code_TEXT_NR3063;
  Merrors_P_error_text_TEXT(L19);
  Abort(807, module_name);
LAB372:
if(DecrRefs(L1)<0)
XD_Mcode_T16(L1);
  Abort(810, module_name);
}

