/*
 * analyzer.c -- part of the C sources generated from the CDL3 sources,
 *              used to bootstrap CDL3
 * Copyright (C) 2000  C.H.A. Koster
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cdl3rts.h"
#include "predef.h"


static char* module_name = "analyzer";

/*
** GLOBALS
*/

	static long undefined[] = {11263};
value G_analyzer_HEADER_NR0 = undefined;
value G_analyzer_SUBHEADER_NR1 = undefined;
value G_analyzer_DEFINED_NR2 = undefined;
long G_analyzer_NR_RULES_NR3 = 0;
long G_analyzer_OFFSET_TYPES_NR4A = 1;
value G_analyzer_OFFSET_TYPES_NR4 = &G_analyzer_OFFSET_TYPES_NR4A;
long G_analyzer_MAX_OFFSET_NR5 = 0;
long G_analyzer_CURRENT_MODULENR_NR6 = 0;
long G_analyzer_CURRENT_RULE_NR7 = 0;
long G_analyzer_ERRORS_NR8 = 0;
long G_analyzer_LOCAL_ERRORS_NR9 = 0;
value G_analyzer_CANFAIL_NR10 = undefined;
value G_analyzer_FORCED_FAIL_NR11 = undefined;
value G_analyzer_HAS_EFFECT_NR12 = undefined;
value G_analyzer_HAS_GLOBAL_EFFECT_NR13 = undefined;
value G_analyzer_OUTPUT_VARIABLES_NR14 = undefined;
long G_analyzer_FAIL_LOCATION_NR15 = 0;
long G_analyzer_RESOLVED_CALLS_NR16B = 0;
value G_analyzer_RESOLVED_CALLS_NR16 = &G_analyzer_RESOLVED_CALLS_NR16B;
long G_analyzer_ORIGINS_NR17B = 0;
value G_analyzer_ORIGINS_NR17 = &G_analyzer_ORIGINS_NR17B;
long G_analyzer_DEPENDS_NR18B = 0;
value G_analyzer_DEPENDS_NR18 = &G_analyzer_DEPENDS_NR18B;
long G_analyzer_APPLICATIONS_NR19B = 0;
value G_analyzer_APPLICATIONS_NR19 = &G_analyzer_APPLICATIONS_NR19B;
long G_analyzer_ASSIGNMENT_NR20A = 1;
value G_analyzer_ASSIGNMENT_NR20 = &G_analyzer_ASSIGNMENT_NR20A;
long G_analyzer_AUTO_ATTACHED_NR21B = 0;
value G_analyzer_AUTO_ATTACHED_NR21 = &G_analyzer_AUTO_ATTACHED_NR21B;
value G_analyzer_THE_CODE_NR22 = undefined;
long G_analyzer_THE_LOCATION_NR23 = 0;
long G_analyzer_NR_GLOBALS_NR24 = 0;
long G_analyzer_GLOBALS_REM_NR25 = 0;
value G_analyzer_WARN_NR26 = undefined;
long G_analyzer_BIRTH_NR27A = 1;
value G_analyzer_BIRTH_NR27 = &G_analyzer_BIRTH_NR27A;
long G_analyzer_DEATH_NR28B = 0;
value G_analyzer_DEATH_NR28 = &G_analyzer_DEATH_NR28B;
long G_analyzer_ELEMENT_NR29B = 0;
value G_analyzer_ELEMENT_NR29 = &G_analyzer_ELEMENT_NR29B;
long G_analyzer_AREF_NR30 = 0;
long G_analyzer_TREF_NR31 = 0;
long G_analyzer_XYZZY_NR32 = 0;
long G_analyzer_TEXT_NR2896[] = {Tag(1,T_TEXT),2,(long)":\n"};
long G_analyzer_TEXT_NR2897[] = {Tag(1,T_TEXT),0,(long)""};
long G_analyzer_ADDRESSES_NR2898[] = {Tag(1,2)};
long G_analyzer_INSTRUCTION_NR2899[] = {Tag(1,8)};
long G_analyzer_TEXT_NR2900[] = {Tag(1,T_TEXT),10,(long)"The root `"};
long G_analyzer_TEXT_NR2901[] = {Tag(1,T_TEXT),14,(long)"' is ambiguous"};
long G_analyzer_TEXT_NR2902[] = {Tag(1,T_TEXT),36,(long)"Can't identify an appropriate root `"};
long G_analyzer_TEXT_NR2903[] = {Tag(1,T_TEXT),4,(long)"'..."};
long G_analyzer_IDENTIFIED_NR2904[] = {Tag(1,1)};
long G_analyzer_BOOLEAN_NR2905[] = {Tag(1,0)};
long G_analyzer_BOOLEAN_NR2906[] = {Tag(1,1)};
long G_analyzer_TEXT_NR2907[] = {Tag(1,T_TEXT),9,(long)"CDL3USAGE"};
long G_analyzer_TEXT_NR2908[] = {Tag(1,T_TEXT),3,(long)">>>"};
long G_analyzer_TEXT_NR2909[] = {Tag(1,T_TEXT),4,(long)"<<<\n"};
long G_analyzer_TEXT_NR2910[] = {Tag(1,T_TEXT),21,(long)"Totaal aantal rules: "};
long G_analyzer_TEXT_NR2911[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_TEXT_NR2912[] = {Tag(1,T_TEXT),21,(long)"Removed attaches for "};
long G_analyzer_TEXT_NR2913[] = {Tag(1,T_TEXT),16,(long)" globals out of "};
long G_analyzer_TEXT_NR2914[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_TEXT_NR2915[] = {Tag(1,T_TEXT),8,(long)"Removed "};
long G_analyzer_TEXT_NR2916[] = {Tag(1,T_TEXT),25,(long)" array references out of "};
long G_analyzer_TEXT_NR2917[] = {Tag(1,T_TEXT),13,(long)" references.\n"};
long G_analyzer_TEXT_NR2918[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_TEXT_NR2919[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_TEXT_NR2920[] = {Tag(1,T_TEXT),4,(long)":in "};
long G_analyzer_TEXT_NR2921[] = {Tag(1,T_TEXT),2,(long)":\n"};
long G_analyzer_TEXT_NR2922[] = {Tag(1,T_TEXT),1,(long)"*"};
long G_analyzer_TEXT_NR2923[] = {Tag(1,T_TEXT),1,(long)"*"};
long G_analyzer_DEFINED_NR2924[] = {Tag(1,2)};
long G_analyzer_BOOLEAN_NR2925[] = {Tag(1,1)};
long G_analyzer_BOOLEAN_NR2926[] = {Tag(1,1)};
long G_analyzer_BOOLEAN_NR2927[] = {Tag(1,1)};
long G_analyzer_BOOLEAN_NR2928[] = {Tag(1,1)};
long G_analyzer_OUTPUT_VARIABLES_NR2929[] = {Tag(1,2)};
long G_analyzer_INSTRUCTION_NR2930[] = {Tag(1,5)};
long G_analyzer_INSTRUCTION_NR2931[] = {Tag(1,0)};
long G_analyzer_CODE_NR2932[] = {Tag(1,2)};
long G_analyzer_TEXT_NR2933[] = {Tag(1,T_TEXT),1,(long)":"};
long G_analyzer_TEXT_NR2934[] = {Tag(1,T_TEXT),1,(long)":"};
long G_analyzer_TEXT_NR2935[] = {Tag(1,T_TEXT),1,(long)":"};
long G_analyzer_TEXT_NR2936[] = {Tag(1,T_TEXT),1,(long)":"};
long G_analyzer_TEXT_NR2937[] = {Tag(1,T_TEXT),6,(long)"Rule `"};
long G_analyzer_TEXT_NR2938[] = {Tag(1,T_TEXT),23,(long)"' defined but not used."};
long G_analyzer_TEXT_NR2939[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_TEXT_NR2940[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_TEXT_NR2941[] = {Tag(1,T_TEXT),43,(long)" is not supposed to have a global effect..."};
long G_analyzer_TEXT_NR2942[] = {Tag(1,T_TEXT),39,(long)" is supposed to have a global effect..."};
long G_analyzer_TEXT_NR2943[] = {Tag(1,T_TEXT),36,(long)" is not supposed to be able to fail!"};
long G_analyzer_TEXT_NR2944[] = {Tag(1,T_TEXT),34,(long)" is supposed to be able to fail..."};
long G_analyzer_TEXT_NR2945[] = {Tag(1,T_TEXT),6,(long)"A test"};
long G_analyzer_TEXT_NR2946[] = {Tag(1,T_TEXT),6,(long)"A test"};
long G_analyzer_TEXT_NR2947[] = {Tag(1,T_TEXT),11,(long)"A predicate"};
long G_analyzer_TEXT_NR2948[] = {Tag(1,T_TEXT),11,(long)"A predicate"};
long G_analyzer_TEXT_NR2949[] = {Tag(1,T_TEXT),10,(long)"A function"};
long G_analyzer_TEXT_NR2950[] = {Tag(1,T_TEXT),10,(long)"A function"};
long G_analyzer_TEXT_NR2951[] = {Tag(1,T_TEXT),9,(long)"An action"};
long G_analyzer_TEXT_NR2952[] = {Tag(1,T_TEXT),9,(long)"An action"};
long G_analyzer_TEXT_NR2953[] = {Tag(1,T_TEXT),9,(long)"A prelude"};
long G_analyzer_TEXT_NR2954[] = {Tag(1,T_TEXT),9,(long)"A prelude"};
long G_analyzer_TEXT_NR2955[] = {Tag(1,T_TEXT),10,(long)"A postlude"};
long G_analyzer_TEXT_NR2956[] = {Tag(1,T_TEXT),10,(long)"A postlude"};
long G_analyzer_TEXT_NR2957[] = {Tag(1,T_TEXT),12,(long)"An interlude"};
long G_analyzer_TEXT_NR2958[] = {Tag(1,T_TEXT),12,(long)"An interlude"};
long G_analyzer_USE_NR2959[] = {Tag(1,6)};
long G_analyzer_ORIGIN_NR2960[] = {Tag(1,3)};
long G_analyzer_ORIGIN_NR2961[] = {Tag(1,4)};
long G_analyzer_PARAMETER_MAP_NR2962[] = {Tag(1,2)};
long G_analyzer_TEXT_NR2963[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR2964[] = {Tag(1,T_TEXT),29,(long)"' does not receive a value..."};
long G_analyzer_TEXT_NR2965[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR2966[] = {Tag(1,T_TEXT),29,(long)"' does not receive a value..."};
long G_analyzer_TEXT_NR2967[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR2968[] = {Tag(1,T_TEXT),35,(long)"' is used before getting a value..."};
long G_analyzer_ORIGIN_NR2969[] = {Tag(1,5)};
long G_analyzer_BOOLEAN_NR2970[] = {Tag(1,1)};
long G_analyzer_BOOLEAN_NR2971[] = {Tag(1,1)};
long G_analyzer_DEFINED_NR2972[] = {Tag(1,2)};
long G_analyzer_MEM_SET_NR2973[] = {Tag(1,1)};
long G_analyzer_LEFTOVER_NR2974[] = {Tag(1,1)};
long G_analyzer_MEM_CONTEXT_NR2975[] = {Tag(1,1)};
long G_analyzer_LEFTOVER_NR2976[] = {Tag(1,1)};
long G_analyzer_APPLICATIONS_NR2977[] = {Tag(1,3)};
long G_analyzer_NUM_LEFT_NR2978[] = {Tag(1,0)};
long G_analyzer_OFFSETS_NR2979[] = {Tag(1,1)};
long G_analyzer_ELEMENT_NR2980[] = {Tag(1,0)};
long G_analyzer_BOOLEAN_NR2981[] = {Tag(1,0)};
long G_analyzer_TEXT_NR2982[] = {Tag(1,T_TEXT),47,(long)"Failure after a global effect is not allowed..."};
long G_analyzer_BOOLEAN_NR2983[] = {Tag(1,0)};
long G_analyzer_BOOLEAN_NR2984[] = {Tag(1,0)};
long G_analyzer_INSTRUCTION_NR2985[] = {Tag(1,16)};
long G_analyzer_TEXT_NR2986[] = {Tag(1,T_TEXT),40,(long)"Next alternative can never be reached..."};
long G_analyzer_CODE_NR2987[] = {Tag(1,2)};
long G_analyzer_CODE_NR2988[] = {Tag(1,2)};
long G_analyzer_TEXT_NR2989[] = {Tag(1,T_TEXT),1,(long)"*"};
long G_analyzer_TEXT_NR2990[] = {Tag(1,T_TEXT),1,(long)"*"};
long G_analyzer_IDENTIFIED_NR2991[] = {Tag(1,1)};
long G_analyzer_TEXT_NR2992[] = {Tag(1,T_TEXT),13,(long)"The call to `"};
long G_analyzer_TEXT_NR2993[] = {Tag(1,T_TEXT),17,(long)"' is ambiguous..."};
long G_analyzer_TEXT_NR2994[] = {Tag(1,T_TEXT),28,(long)"Can't identify the call to `"};
long G_analyzer_TEXT_NR2995[] = {Tag(1,T_TEXT),4,(long)"'..."};
long G_analyzer_INSTRUCTION_NR2996[] = {Tag(1,15)};
long G_analyzer_INSTRUCTION_NR2997[] = {Tag(1,15)};
long G_analyzer_BOOLEAN_NR2998[] = {Tag(1,0)};
long G_analyzer_INSTRUCTION_NR2999[] = {Tag(1,16)};
long G_analyzer_BOOLEAN_NR3000[] = {Tag(1,1)};
long G_analyzer_INSTRUCTION_NR3001[] = {Tag(1,17)};
long G_analyzer_BOOLEAN_NR3002[] = {Tag(1,1)};
long G_analyzer_DIRECTION_NR3003[] = {Tag(1,2)};
long G_analyzer_DIRECTION_NR3004[] = {Tag(1,0)};
long G_analyzer_DIRECTION_NR3005[] = {Tag(1,2)};
long G_analyzer_DIRECTION_NR3006[] = {Tag(1,1)};
long G_analyzer_DIRECTION_NR3007[] = {Tag(1,3)};
long G_analyzer_STRUCTURES_NR3008[] = {Tag(1,1)};
long G_analyzer_STRUCTURES_NR3009[] = {Tag(1,1)};
long G_analyzer_BOOLEAN_NR3010[] = {Tag(1,0)};
long G_analyzer_BOOLEAN_NR3011[] = {Tag(1,0)};
long G_analyzer_BOOLEAN_NR3012[] = {Tag(1,0)};
long G_analyzer_BOOLEAN_NR3013[] = {Tag(1,0)};
long G_analyzer_BOOLEAN_NR3014[] = {Tag(1,0)};
long G_analyzer_BOOLEAN_NR3015[] = {Tag(1,0)};
long G_analyzer_NUM_LEFT_NR3016[] = {Tag(1,0)};
long G_analyzer_ORIGIN_NR3017[] = {Tag(1,1)};
long G_analyzer_ORIGIN_NR3018[] = {Tag(1,2)};
long G_analyzer_USE_NR3019[] = {Tag(1,4)};
long G_analyzer_ADDRESSES_NR3020[] = {Tag(1,2)};
long G_analyzer_OFFSETS_NR3021[] = {Tag(1,1)};
long G_analyzer_USE_NR3022[] = {Tag(1,8)};
long G_analyzer_USE_NR3023[] = {Tag(1,8)};
long G_analyzer_STRUCTURES_NR3024[] = {Tag(1,2)};
long G_analyzer_BOOLEAN_NR3025[] = {Tag(1,0)};
long G_analyzer_USE_NR3026[] = {Tag(1,4)};
long G_analyzer_USE_NR3027[] = {Tag(1,4)};
long G_analyzer_TEXT_NR3028[] = {Tag(1,T_TEXT),47,(long)"both operands of '=' must have the same type..."};
long G_analyzer_TEXT_NR3029[] = {Tag(1,T_TEXT),43,(long)"'=' can only be applied to two variables..."};
long G_analyzer_TEXT_NR3030[] = {Tag(1,T_TEXT),28,(long)"Don't know how to evaluate ["};
long G_analyzer_TEXT_NR3031[] = {Tag(1,T_TEXT),2,(long)"->"};
long G_analyzer_TEXT_NR3032[] = {Tag(1,T_TEXT),4,(long)"]..."};
long G_analyzer_TYPEALTERNATIVE_NR3033[] = {Tag(1,2)};
long G_analyzer_OFFSETS_NR3034[] = {Tag(1,1)};
long G_analyzer_APPLICATIONS_NR3035[] = {Tag(1,3)};
long G_analyzer_DEATH_NR3036[] = {Tag(1,3)};
long G_analyzer_ELEMENT_NR3037[] = {Tag(1,0)};
long G_analyzer_USE_NR3038[] = {Tag(1,1)};
long G_analyzer_USE_NR3039[] = {Tag(1,4)};
long G_analyzer_USE_NR3040[] = {Tag(1,4)};
long G_analyzer_ORIGIN_NR3041[] = {Tag(1,5)};
long G_analyzer_TEXT_NR3042[] = {Tag(1,T_TEXT),24,(long)"Can't take the value of "};
long G_analyzer_TEXT_NR3043[] = {Tag(1,T_TEXT),1,(long)"'"};
long G_analyzer_ORIGIN_NR3044[] = {Tag(1,11)};
long G_analyzer_USE_NR3045[] = {Tag(1,4)};
long G_analyzer_BOOLEAN_NR3046[] = {Tag(1,0)};
long G_analyzer_ORIGIN_NR3047[] = {Tag(1,7)};
long G_analyzer_BOOLEAN_NR3048[] = {Tag(1,0)};
long G_analyzer_USE_NR3049[] = {Tag(1,4)};
long G_analyzer_USE_NR3050[] = {Tag(1,4)};
long G_analyzer_USE_NR3051[] = {Tag(1,4)};
long G_analyzer_USE_NR3052[] = {Tag(1,4)};
long G_analyzer_ORIGIN_NR3053[] = {Tag(1,5)};
long G_analyzer_TEXT_NR3054[] = {Tag(1,T_TEXT),24,(long)"Can't take the value of "};
long G_analyzer_TEXT_NR3055[] = {Tag(1,T_TEXT),1,(long)"'"};
long G_analyzer_ORIGIN_NR3056[] = {Tag(1,0)};
long G_analyzer_ORIGIN_NR3057[] = {Tag(1,9)};
long G_analyzer_ORIGIN_NR3058[] = {Tag(1,0)};
long G_analyzer_ORIGIN_NR3059[] = {Tag(1,0)};
long G_analyzer_USE_NR3060[] = {Tag(1,4)};
long G_analyzer_USE_NR3061[] = {Tag(1,4)};
long G_analyzer_TEXT_NR3062[] = {Tag(1,T_TEXT),32,(long)"Implicit split in function call."};
long G_analyzer_BOOLEAN_NR3063[] = {Tag(1,0)};
long G_analyzer_USE_NR3064[] = {Tag(1,4)};
long G_analyzer_BOOLEAN_NR3065[] = {Tag(1,0)};
long G_analyzer_USE_NR3066[] = {Tag(1,4)};
long G_analyzer_BOOLEAN_NR3067[] = {Tag(1,0)};
long G_analyzer_USE_NR3068[] = {Tag(1,4)};
long G_analyzer_USE_NR3069[] = {Tag(1,4)};
long G_analyzer_BOOLEAN_NR3070[] = {Tag(1,0)};
long G_analyzer_USE_NR3071[] = {Tag(1,4)};
long G_analyzer_USE_NR3072[] = {Tag(1,4)};
long G_analyzer_ORIGIN_NR3073[] = {Tag(1,10)};
long G_analyzer_ORIGIN_NR3074[] = {Tag(1,10)};
long G_analyzer_USE_NR3075[] = {Tag(1,4)};
long G_analyzer_ORIGIN_NR3076[] = {Tag(1,10)};
long G_analyzer_USE_NR3077[] = {Tag(1,4)};
long G_analyzer_USE_NR3078[] = {Tag(1,4)};
long G_analyzer_ORIGIN_NR3079[] = {Tag(1,10)};
long G_analyzer_ORIGIN_NR3080[] = {Tag(1,9)};
long G_analyzer_USE_NR3081[] = {Tag(1,2)};
long G_analyzer_ORIGIN_NR3082[] = {Tag(1,6)};
long G_analyzer_TEXT_NR3083[] = {Tag(1,T_TEXT),23,(long)"Golly we have a bug...\n"};
long G_analyzer_TEXT_NR3084[] = {Tag(1,T_TEXT),43,(long)" is only defined for integer expressions..."};
long G_analyzer_TEXT_NR3085[] = {Tag(1,T_TEXT),49,(long)" is only defined on text & integer expressions..."};
long G_analyzer_TEXT_NR3086[] = {Tag(1,T_TEXT),42,(long)" is only defined on integer expressions..."};
long G_analyzer_TEXT_NR3087[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR3088[] = {Tag(1,T_TEXT),22,(long)"' should be indexed..."};
long G_analyzer_TEXT_NR3089[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR3090[] = {Tag(1,T_TEXT),23,(long)"' may not be indexed..."};
long G_analyzer_TEXT_NR3091[] = {Tag(1,T_TEXT),18,(long)"can't concretize `"};
long G_analyzer_TEXT_NR3092[] = {Tag(1,T_TEXT),4,(long)"'..."};
long G_analyzer_TEXT_NR3093[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR3094[] = {Tag(1,T_TEXT),33,(long)"' is not an integer expression..."};
long G_analyzer_TEXT_NR3095[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR3096[] = {Tag(1,T_TEXT),33,(long)"' is not an integer expression..."};
long G_analyzer_TEXT_NR3097[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR3098[] = {Tag(1,T_TEXT),33,(long)"' is not an integer expression..."};
long G_analyzer_TEXT_NR3099[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR3100[] = {Tag(1,T_TEXT),30,(long)"' should be of integer type..."};
long G_analyzer_TEXT_NR3101[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR3102[] = {Tag(1,T_TEXT),29,(long)"' is not a text expression..."};
long G_analyzer_TEXT_NR3103[] = {Tag(1,T_TEXT),39,(long)" is not defined for text expressions..."};
long G_analyzer_TEXT_NR3104[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR3105[] = {Tag(1,T_TEXT),29,(long)"' is not a text expression..."};
long G_analyzer_TEXT_NR3106[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR3107[] = {Tag(1,T_TEXT),29,(long)"' is not a text expression..."};
long G_analyzer_TEXT_NR3108[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR3109[] = {Tag(1,T_TEXT),29,(long)"' is not a text expression..."};
long G_analyzer_TEXT_NR3110[] = {Tag(1,T_TEXT),1,(long)"`"};
long G_analyzer_TEXT_NR3111[] = {Tag(1,T_TEXT),27,(long)"' should be of text type..."};
long G_analyzer_TEXT_NR3112[] = {Tag(1,T_TEXT),39,(long)" is not defined for text expressions..."};
long G_analyzer_TYPEALTERNATIVE_NR3113[] = {Tag(1,2)};
long G_analyzer_REST_NR3114[] = {Tag(1,1)};
long G_analyzer_STRICT_NR3115[] = {Tag(1,1)};
long G_analyzer_STRUCTURE_NR3116[] = {Tag(1,0)};
long G_analyzer_STRUCTURE_NR3117[] = {Tag(1,0)};
long G_analyzer_STRICT_NR3118[] = {Tag(1,0)};
long G_analyzer_STRICT_NR3119[] = {Tag(1,0)};
long G_analyzer_STRICT_NR3120[] = {Tag(1,0)};
long G_analyzer_STRICT_NR3121[] = {Tag(1,0)};
long G_analyzer_STRICT_NR3122[] = {Tag(1,0)};
long G_analyzer_TEXT_NR3123[] = {Tag(1,T_TEXT),19,(long)"The error handler `"};
long G_analyzer_TEXT_NR3124[] = {Tag(1,T_TEXT),14,(long)"' is ambiguous"};
long G_analyzer_TEXT_NR3125[] = {Tag(1,T_TEXT),46,(long)"Can't identify an appriopriate error handler `"};
long G_analyzer_TEXT_NR3126[] = {Tag(1,T_TEXT),1,(long)" "};
long G_analyzer_ADDRESSES_NR3127[] = {Tag(1,2)};
long G_analyzer_ADDRESSES_NR3128[] = {Tag(1,2)};
long G_analyzer_TEXT_NR3129[] = {Tag(1,T_TEXT),16,(long)"Got dependancy: "};
long G_analyzer_TEXT_NR3130[] = {Tag(1,T_TEXT),12,(long)" depends on "};
long G_analyzer_TEXT_NR3131[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_OFFSETS_NR3132[] = {Tag(1,1)};
long G_analyzer_TEXT_NR3133[] = {Tag(1,T_TEXT),19,(long)"Got application of "};
long G_analyzer_TEXT_NR3134[] = {Tag(1,T_TEXT),4,(long)" at "};
long G_analyzer_TEXT_NR3135[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_TEXT_NR3136[] = {Tag(1,T_TEXT),4,(long)"TEST"};
long G_analyzer_TEXT_NR3137[] = {Tag(1,T_TEXT),8,(long)"OFFSET: "};
long G_analyzer_TEXT_NR3138[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_TEXT_NR3139[] = {Tag(1,T_TEXT),10,(long)"LOCATION: "};
long G_analyzer_TEXT_NR3140[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_NUM_LEFT_NR3141[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3142[] = {Tag(1,1)};
long G_analyzer_NUM_LEFT_NR3143[] = {Tag(1,1)};
long G_analyzer_NUM_LEFT_NR3144[] = {Tag(1,1)};
long G_analyzer_NUM_LEFT_NR3145[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3146[] = {Tag(1,1)};
long G_analyzer_NUM_LEFT_NR3147[] = {Tag(1,1)};
long G_analyzer_NUM_LEFT_NR3148[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3149[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3150[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3151[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3152[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3153[] = {Tag(1,1)};
long G_analyzer_NUM_LEFT_NR3154[] = {Tag(1,2)};
long G_analyzer_IS_ALIVE_NR3155[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3156[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3157[] = {Tag(1,2)};
long G_analyzer_FAILED_NR3158[] = {Tag(1,1)};
long G_analyzer_LEFTOVER_NR3159[] = {Tag(1,1)};
long G_analyzer_ALIVE_NR3160[] = {Tag(1,1)};
long G_analyzer_FAILED_NR3161[] = {Tag(1,1)};
long G_analyzer_LEFTOVER_NR3162[] = {Tag(1,1)};
long G_analyzer_ALIVE_NR3163[] = {Tag(1,1)};
long G_analyzer_FAILED_NR3164[] = {Tag(1,1)};
long G_analyzer_ALIVE_NR3165[] = {Tag(1,1)};
long G_analyzer_LEFTOVER_NR3166[] = {Tag(1,1)};
long G_analyzer_ALIVE_NR3167[] = {Tag(1,1)};
long G_analyzer_ALIVE_NR3168[] = {Tag(1,1)};
long G_analyzer_FAILED_NR3169[] = {Tag(1,1)};
long G_analyzer_FAILED_NR3170[] = {Tag(1,1)};
long G_analyzer_FAILED_NR3171[] = {Tag(1,1)};
long G_analyzer_ALIVE_NR3172[] = {Tag(1,1)};
long G_analyzer_FAILED_NR3173[] = {Tag(1,1)};
long G_analyzer_ALIVE_NR3174[] = {Tag(1,1)};
long G_analyzer_ALIVE_NR3175[] = {Tag(1,1)};
long G_analyzer_LEFTOVER_NR3176[] = {Tag(1,1)};
long G_analyzer_NUM_LEFT_NR3177[] = {Tag(1,0)};
long G_analyzer_NUM_LEFT_NR3178[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3179[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3180[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3181[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3182[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3183[] = {Tag(1,2)};
long G_analyzer_NUM_LEFT_NR3184[] = {Tag(1,1)};
long G_analyzer_NUM_LEFT_NR3185[] = {Tag(1,0)};
long G_analyzer_IS_ALIVE_NR3186[] = {Tag(1,0)};
long G_analyzer_IS_ALIVE_NR3187[] = {Tag(1,0)};
long G_analyzer_NUM_LEFT_NR3188[] = {Tag(1,2)};
long G_analyzer_IS_ALIVE_NR3189[] = {Tag(1,0)};
long G_analyzer_FAIL_NR3190[] = {Tag(1,0)};
long G_analyzer_FAIL_NR3191[] = {Tag(1,1)};
long G_analyzer_NUM_LEFT_NR3192[] = {Tag(1,2)};
long G_analyzer_IS_ALIVE_NR3193[] = {Tag(1,2)};
long G_analyzer_IS_ALIVE_NR3194[] = {Tag(1,0)};
long G_analyzer_IS_ALIVE_NR3195[] = {Tag(1,0)};
long G_analyzer_IS_ALIVE_NR3196[] = {Tag(1,0)};
long G_analyzer_IS_ALIVE_NR3197[] = {Tag(1,0)};
long G_analyzer_IS_ALIVE_NR3198[] = {Tag(1,0)};
long G_analyzer_IS_ALIVE_NR3199[] = {Tag(1,2)};
long G_analyzer_IS_ALIVE_NR3200[] = {Tag(1,1)};
long G_analyzer_IS_ALIVE_NR3201[] = {Tag(1,1)};
long G_analyzer_IS_ALIVE_NR3202[] = {Tag(1,0)};
long G_analyzer_IS_ALIVE_NR3203[] = {Tag(1,0)};
long G_analyzer_IS_ALIVE_NR3204[] = {Tag(1,0)};
long G_analyzer_IS_ALIVE_NR3205[] = {Tag(1,2)};
long G_analyzer_IS_ALIVE_NR3206[] = {Tag(1,2)};
long G_analyzer_IS_ALIVE_NR3207[] = {Tag(1,1)};
long G_analyzer_LOCAL_MAP_NR3208[] = {Tag(1,1)};
long G_analyzer_TEXT_NR3209[] = {Tag(1,T_TEXT),16,(long)"DUMP_ALTERNATIVE"};
long G_analyzer_TEXT_NR3210[] = {Tag(1,T_TEXT),0,(long)""};
long G_analyzer_TEXT_NR3211[] = {Tag(1,T_TEXT),34,(long)"@@@@@@@@@@ END OF DUMP @@@@@@@@@@\n"};
long G_analyzer_TEXT_NR3212[] = {Tag(1,T_TEXT),19,(long)"End of alternative\n"};
long G_analyzer_TEXT_NR3213[] = {Tag(1,T_TEXT),14,(long)"Fork -- begin\n"};
long G_analyzer_TEXT_NR3214[] = {Tag(1,T_TEXT),2,(long)"  "};
long G_analyzer_TEXT_NR3215[] = {Tag(1,T_TEXT),18,(long)"Fork -- continued\n"};
long G_analyzer_TEXT_NR3216[] = {Tag(1,T_TEXT),2,(long)"  "};
long G_analyzer_TEXT_NR3217[] = {Tag(1,T_TEXT),16,(long)"Fork -- failure\n"};
long G_analyzer_TEXT_NR3218[] = {Tag(1,T_TEXT),2,(long)"  "};
long G_analyzer_TEXT_NR3219[] = {Tag(1,T_TEXT),12,(long)"Fork -- end\n"};
long G_analyzer_TEXT_NR3220[] = {Tag(1,T_TEXT),19,(long)"End of alternative\n"};
long G_analyzer_TEXT_NR3221[] = {Tag(1,T_TEXT),21,(long)"Segment: Starting at "};
long G_analyzer_TEXT_NR3222[] = {Tag(1,T_TEXT),10,(long)" Cleanup: "};
long G_analyzer_TEXT_NR3223[] = {Tag(1,T_TEXT),11,(long)" Continue: "};
long G_analyzer_TEXT_NR3224[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_TEXT_NR3225[] = {Tag(1,T_TEXT),21,(long)"Segment: Starting at "};
long G_analyzer_TEXT_NR3226[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_TEXT_NR3227[] = {Tag(1,T_TEXT),1,(long)":"};
long G_analyzer_TEXT_NR3228[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_TEXT_NR3229[] = {Tag(1,T_TEXT),1,(long)" "};
long G_analyzer_TEXT_NR3230[] = {Tag(1,T_TEXT),1,(long)"@"};
long G_analyzer_TEXT_NR3231[] = {Tag(1,T_TEXT),2,(long)" ["};
long G_analyzer_TEXT_NR3232[] = {Tag(1,T_TEXT),1,(long)"]"};
long G_analyzer_TEXT_NR3233[] = {Tag(1,T_TEXT),2,(long)" *"};
long G_analyzer_TEXT_NR3234[] = {Tag(1,T_TEXT),5,(long)"todo["};
long G_analyzer_TEXT_NR3235[] = {Tag(1,T_TEXT),1,(long)"]"};
long G_analyzer_TEXT_NR3236[] = {Tag(1,T_TEXT),5,(long)"alias"};
long G_analyzer_TEXT_NR3237[] = {Tag(1,T_TEXT),4,(long)"join"};
long G_analyzer_TEXT_NR3238[] = {Tag(1,T_TEXT),7,(long)"2global"};
long G_analyzer_TEXT_NR3239[] = {Tag(1,T_TEXT),3,(long)"app"};
long G_analyzer_TEXT_NR3240[] = {Tag(1,T_TEXT),3,(long)"dnc"};
long G_analyzer_TEXT_NR3241[] = {Tag(1,T_TEXT),3,(long)"out"};
long G_analyzer_TEXT_NR3242[] = {Tag(1,T_TEXT),5,(long)"trans"};
long G_analyzer_TEXT_NR3243[] = {Tag(1,T_TEXT),4,(long)"call"};
long G_analyzer_TEXT_NR3244[] = {Tag(1,T_TEXT),9,(long)": Origin "};
long G_analyzer_TEXT_NR3245[] = {Tag(1,T_TEXT),8,(long)" Deaths:"};
long G_analyzer_TEXT_NR3246[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_analyzer_TEXT_NR3247[] = {Tag(1,T_TEXT),3,(long)" B:"};
long G_analyzer_TEXT_NR3248[] = {Tag(1,T_TEXT),3,(long)" A:"};
long G_analyzer_TEXT_NR3249[] = {Tag(1,T_TEXT),3,(long)" R:"};

/*
** ATTACH/DETACH/EQUAL
*/
/****DEFINED(analyzer)****/

int EQ_Manalyzer_T3(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Manalyzer_T3(Part(x,3),Part(y,3));
       case 1:
         return (Part(x,1) == Part(y,1))&&EQ_Manalyzer_T3(Part(x,2),Part(y,2));
       case 2:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T3(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
WRITE("at ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T3(Part(x,3));
WRITE(" ");
       case 1:
WRITE("temporary ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T3(Part(x,2));
WRITE(" ");
       case 2:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T3(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T3(Part(x,3));
            Free(x,4);
            break;
          case 1:
D_Manalyzer_T3(Part(x,2));
            Free(x,3);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T3(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T3(x);
}

/****OUTPUT_VARIABLES(analyzer)****/

int EQ_Manalyzer_T15(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Manalyzer_T15(Part(x,3),Part(y,3));
       case 1:
         return EQ_Manalyzer_T15(Part(x,1),Part(y,1));
       case 2:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T15(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T15(Part(x,3));
WRITE(" ");
       case 1:
WRITE("pass ");
WRITE("two ");
W_Manalyzer_T15(Part(x,1));
WRITE(" ");
       case 2:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T15(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T15(Part(x,3));
            Free(x,4);
            break;
          case 1:
D_Manalyzer_T15(Part(x,1));
            Free(x,2);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T15(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T15(x);
}

/****APPLICATIONS(analyzer)****/

int EQ_Manalyzer_T20(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Manalyzer_T67(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Manalyzer_T20(Part(x,3),Part(y,3));
       case 1:
         return (Part(x,1) == Part(y,1))&&EQ_Manalyzer_T20(Part(x,2),Part(y,2));
       case 2:
         return (Part(x,1) == Part(y,1))&&EQ_Manalyzer_T20(Part(x,2),Part(y,2));
       case 3:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T20(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("direct ");
W_Manalyzer_T67(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T20(Part(x,3));
WRITE(" ");
       case 1:
WRITE("indirect ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T20(Part(x,2));
WRITE(" ");
       case 2:
WRITE("creation ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T20(Part(x,2));
WRITE(" ");
       case 3:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T20(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T67(Part(x,1));
D_Manalyzer_T20(Part(x,3));
            Free(x,4);
            break;
          case 1:
D_Manalyzer_T20(Part(x,2));
            Free(x,3);
            break;
          case 2:
D_Manalyzer_T20(Part(x,2));
            Free(x,3);
            break;
          case 3:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T20(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T20(x);
}

/****DEATH(analyzer)****/

int EQ_Manalyzer_T29(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Manalyzer_T29(Part(x,2),Part(y,2));
       case 1:
         return (Part(x,1) == Part(y,1))&&EQ_Manalyzer_T29(Part(x,2),Part(y,2));
       case 2:
         return (Part(x,1) == Part(y,1))&&EQ_Manalyzer_T29(Part(x,2),Part(y,2));
       case 3:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T29(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("before ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T29(Part(x,2));
WRITE(" ");
       case 1:
WRITE("at ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T29(Part(x,2));
WRITE(" ");
       case 2:
WRITE("restore ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T29(Part(x,2));
WRITE(" ");
       case 3:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T29(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T29(Part(x,2));
            Free(x,3);
            break;
          case 1:
D_Manalyzer_T29(Part(x,2));
            Free(x,3);
            break;
          case 2:
D_Manalyzer_T29(Part(x,2));
            Free(x,3);
            break;
          case 3:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T29(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T29(x);
}

/****ELEMENT(analyzer)****/

int EQ_Manalyzer_T30(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Manalyzer_T30(Part(x,3),Part(y,3));
    };
  return 0;
}

int W_Manalyzer_T30(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("none ");
       case 1:
WRITE("source ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
WRITE("located ");
WRITE("at ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T30(Part(x,3));
WRITE(" ");
    };
  return 0;
}

int XD_Manalyzer_T30(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
D_Mcode_T20(Part(x,1));
D_Manalyzer_T30(Part(x,3));
            Free(x,4);
            break;
    };
}

int D_Manalyzer_T30(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T30(x);
}

/****LOCAL_MAP(analyzer)****/

int EQ_Manalyzer_T36(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Manalyzer_T29(Part(x,2),Part(y,2))&&EQ_Manalyzer_T36(Part(x,3),Part(y,3));
       case 1:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T36(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_Manalyzer_T29(Part(x,2));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T36(Part(x,3));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T36(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T29(Part(x,2));
D_Manalyzer_T36(Part(x,3));
            Free(x,4);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T36(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T36(x);
}

/****STRUCTURE(analyzer)****/

int EQ_Manalyzer_T46(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return EQ_Manalyzer_T46(Part(x,1),Part(y,1))&&EQ_Manalyzer_T46(Part(x,2),Part(y,2));
       case 2:
         return EQ_Mnodes_T7(Part(x,1),Part(y,1));
       case 3:
         return EQ_Manalyzer_T46(Part(x,1),Part(y,1))&&EQ_Manalyzer_T46(Part(x,2),Part(y,2));
       case 4:
         return EQ_Manalyzer_T46(Part(x,1),Part(y,1))&&EQ_Manalyzer_T46(Part(x,2),Part(y,2));
       case 5:
         return EQ_Manalyzer_T46(Part(x,1),Part(y,1));
       case 6:
         return (Part(x,1) == Part(y,1))&&EQ_Manalyzer_T46(Part(x,2),Part(y,2));
    };
  return 0;
}

int W_Manalyzer_T46(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("end ");
       case 1:
W_Manalyzer_T46(Part(x,1));
WRITE(" ");
WRITE("bar ");
W_Manalyzer_T46(Part(x,2));
WRITE(" ");
       case 2:
W_Mnodes_T7(Part(x,1));
WRITE(" ");
       case 3:
WRITE("concat ");
W_Manalyzer_T46(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T46(Part(x,2));
WRITE(" ");
       case 4:
W_Manalyzer_T46(Part(x,1));
WRITE(" ");
W_Manalyzer_T46(Part(x,2));
WRITE(" ");
       case 5:
WRITE("struct ");
W_Manalyzer_T46(Part(x,1));
WRITE(" ");
       case 6:
WRITE("alternative ");
W_INT(Part(x,1));
WRITE(" ");
W_Manalyzer_T46(Part(x,2));
WRITE(" ");
    };
  return 0;
}

int XD_Manalyzer_T46(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
D_Manalyzer_T46(Part(x,1));
D_Manalyzer_T46(Part(x,2));
            Free(x,3);
            break;
          case 2:
D_Mnodes_T7(Part(x,1));
            Free(x,2);
            break;
          case 3:
D_Manalyzer_T46(Part(x,1));
D_Manalyzer_T46(Part(x,2));
            Free(x,3);
            break;
          case 4:
D_Manalyzer_T46(Part(x,1));
D_Manalyzer_T46(Part(x,2));
            Free(x,3);
            break;
          case 5:
D_Manalyzer_T46(Part(x,1));
            Free(x,2);
            break;
          case 6:
D_Manalyzer_T46(Part(x,2));
            Free(x,3);
            break;
    };
}

int D_Manalyzer_T46(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T46(x);
}

/****STRUCTURES(analyzer)****/

int EQ_Manalyzer_T49(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Manalyzer_T46(Part(x,1),Part(y,1))&&EQ_Manalyzer_T49(Part(x,2),Part(y,2));
       case 1:
         return 1;
       case 2:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T49(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Manalyzer_T46(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T49(Part(x,2));
WRITE(" ");
       case 1:
WRITE("ambiguous ");
       case 2:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T49(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T46(Part(x,1));
D_Manalyzer_T49(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T49(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T49(x);
}

/****REST(analyzer)****/

int EQ_Manalyzer_T51(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Mtypes_T15(Part(x,1),Part(y,1))&&EQ_Manalyzer_T51(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T51(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Mtypes_T15(Part(x,1));
WRITE(" ");
W_Manalyzer_T51(Part(x,2));
WRITE(" ");
       case 1:
WRITE("end ");
    };
  return 0;
}

int XD_Manalyzer_T51(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mtypes_T15(Part(x,1));
D_Manalyzer_T51(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T51(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T51(x);
}

/****STRICT(analyzer)****/

int EQ_Manalyzer_T52(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T52(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("nonstrict ");
       case 1:
WRITE("strict ");
    };
  return 0;
}

int XD_Manalyzer_T52(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T52(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T52(x);
}

/****IDENTIFIED(analyzer)****/

int EQ_Manalyzer_T55(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Mrules_T21(Part(x,1),Part(y,1));
       case 1:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T55(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Mrules_T21(Part(x,1));
WRITE(" ");
       case 1:
WRITE("false ");
    };
  return 0;
}

int XD_Manalyzer_T55(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mrules_T21(Part(x,1));
            Free(x,2);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T55(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T55(x);
}

/****MEM_SET(analyzer)****/

int EQ_Manalyzer_T59(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Manalyzer_T61(Part(x,1),Part(y,1))&&EQ_Manalyzer_T68(Part(x,2),Part(y,2))&&EQ_Manalyzer_T30(Part(x,3),Part(y,3))&&EQ_Manalyzer_T59(Part(x,4),Part(y,4));
       case 1:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T59(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Manalyzer_T61(Part(x,1));
WRITE(" ");
W_Manalyzer_T68(Part(x,2));
WRITE(" ");
W_Manalyzer_T30(Part(x,3));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T59(Part(x,4));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T59(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T61(Part(x,1));
D_Manalyzer_T68(Part(x,2));
D_Manalyzer_T30(Part(x,3));
D_Manalyzer_T59(Part(x,4));
            Free(x,5);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T59(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T59(x);
}

/****CONTEXT(analyzer)****/

int EQ_Manalyzer_T60(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Manalyzer_T3(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Manalyzer_T62(Part(x,3),Part(y,3))&&EQ_Manalyzer_T62(Part(x,4),Part(y,4))&&EQ_Manalyzer_T59(Part(x,5),Part(y,5));
    };
  return 0;
}

int W_Manalyzer_T60(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Manalyzer_T3(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
W_Manalyzer_T62(Part(x,3));
WRITE(" ");
W_Manalyzer_T62(Part(x,4));
WRITE(" ");
W_Manalyzer_T59(Part(x,5));
WRITE(" ");
    };
  return 0;
}

int XD_Manalyzer_T60(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T3(Part(x,1));
D_Manalyzer_T62(Part(x,3));
D_Manalyzer_T62(Part(x,4));
D_Manalyzer_T59(Part(x,5));
            Free(x,6);
            break;
    };
}

int D_Manalyzer_T60(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T60(x);
}

/****NUM_LEFT(analyzer)****/

int EQ_Manalyzer_T61(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
       case 2:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T61(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("undefined ");
       case 1:
WRITE("attached ");
       case 2:
WRITE("detached ");
    };
  return 0;
}

int XD_Manalyzer_T61(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T61(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T61(x);
}

/****BOOLEAN(analyzer)****/

int EQ_Manalyzer_T62(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T62(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("true ");
       case 1:
WRITE("false ");
    };
  return 0;
}

int XD_Manalyzer_T62(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T62(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T62(x);
}

/****ORIGIN(analyzer)****/

int EQ_Manalyzer_T65(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
       case 2:
         return 1;
       case 3:
         return 1;
       case 4:
         return 1;
       case 5:
         return 1;
       case 6:
         return 1;
       case 7:
         return 1;
       case 8:
         return (Part(x,1) == Part(y,1));
       case 9:
         return 1;
       case 10:
         return 1;
       case 11:
         return 1;
       case 12:
         return EQ_Manalyzer_T65(Part(x,1),Part(y,1));
    };
  return 0;
}

int W_Manalyzer_T65(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("created ");
       case 1:
WRITE("return ");
WRITE("value ");
       case 2:
WRITE("transient ");
WRITE("return ");
WRITE("value ");
       case 3:
WRITE("input ");
WRITE("parameter ");
       case 4:
WRITE("transient ");
WRITE("parameter ");
       case 5:
WRITE("error ");
       case 6:
WRITE("split ");
       case 7:
WRITE("copy ");
       case 8:
WRITE("global ");
W_INT(Part(x,1));
WRITE(" ");
       case 9:
WRITE("constant ");
       case 10:
WRITE("num ");
       case 11:
WRITE("element ");
       case 12:
WRITE("joined ");
W_Manalyzer_T65(Part(x,1));
WRITE(" ");
    };
  return 0;
}

int XD_Manalyzer_T65(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
          case 3:
            Free(x,1);
            break;
          case 4:
            Free(x,1);
            break;
          case 5:
            Free(x,1);
            break;
          case 6:
            Free(x,1);
            break;
          case 7:
            Free(x,1);
            break;
          case 8:
            Free(x,2);
            break;
          case 9:
            Free(x,1);
            break;
          case 10:
            Free(x,1);
            break;
          case 11:
            Free(x,1);
            break;
          case 12:
D_Manalyzer_T65(Part(x,1));
            Free(x,2);
            break;
    };
}

int D_Manalyzer_T65(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T65(x);
}

/****USE(analyzer)****/

int EQ_Manalyzer_T67(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1));
       case 1:
         return 1;
       case 2:
         return 1;
       case 3:
         return EQ_Mcode_T20(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2));
       case 4:
         return 1;
       case 5:
         return 1;
       case 6:
         return 1;
       case 7:
         return 1;
       case 8:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T67(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("todo ");
W_INT(Part(x,1));
WRITE(" ");
       case 1:
WRITE("alias ");
       case 2:
WRITE("join ");
       case 3:
WRITE("copy ");
WRITE("to ");
WRITE("global ");
W_Mcode_T20(Part(x,1));
WRITE(" ");
W_INT(Part(x,2));
WRITE(" ");
       case 4:
WRITE("application ");
       case 5:
WRITE("do ");
WRITE("not ");
WRITE("care ");
       case 6:
WRITE("output ");
       case 7:
WRITE("transient ");
       case 8:
WRITE("call ");
    };
  return 0;
}

int XD_Manalyzer_T67(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,2);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
          case 3:
D_Mcode_T20(Part(x,1));
            Free(x,3);
            break;
          case 4:
            Free(x,1);
            break;
          case 5:
            Free(x,1);
            break;
          case 6:
            Free(x,1);
            break;
          case 7:
            Free(x,1);
            break;
          case 8:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T67(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T67(x);
}

/****OFFSETS(analyzer)****/

int EQ_Manalyzer_T68(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Manalyzer_T68(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T68(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T68(Part(x,2));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T68(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T68(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T68(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T68(x);
}

/****MEM_CONTEXT(analyzer)****/

int EQ_Manalyzer_T69(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Manalyzer_T20(Part(x,1),Part(y,1))&&EQ_Manalyzer_T69(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T69(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Manalyzer_T20(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T69(Part(x,2));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T69(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T20(Part(x,1));
D_Manalyzer_T69(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T69(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T69(x);
}

/****LEFTOVER(analyzer)****/

int EQ_Manalyzer_T70(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Manalyzer_T61(Part(x,1),Part(y,1))&&EQ_Manalyzer_T70(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T70(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Manalyzer_T61(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T70(Part(x,2));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T70(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T61(Part(x,1));
D_Manalyzer_T70(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T70(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T70(x);
}

/****CODE(analyzer)****/

int EQ_Manalyzer_T71(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Manalyzer_T69(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2))&&(Part(x,3) == Part(y,3))&&EQ_Manalyzer_T70(Part(x,4),Part(y,4))&&(Part(x,5) == Part(y,5))&&EQ_Manalyzer_T71(Part(x,6),Part(y,6));
       case 1:
         return EQ_Manalyzer_T69(Part(x,1),Part(y,1))&&(Part(x,2) == Part(y,2))&&EQ_Manalyzer_T71(Part(x,3),Part(y,3));
       case 2:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T71(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Manalyzer_T69(Part(x,1));
WRITE(" ");
WRITE("at ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("fail ");
W_INT(Part(x,3));
WRITE(" ");
W_Manalyzer_T70(Part(x,4));
WRITE(" ");
W_INT(Part(x,5));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T71(Part(x,6));
WRITE(" ");
       case 1:
W_Manalyzer_T69(Part(x,1));
WRITE(" ");
WRITE("at ");
W_INT(Part(x,2));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T71(Part(x,3));
WRITE(" ");
       case 2:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T71(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T69(Part(x,1));
D_Manalyzer_T70(Part(x,4));
D_Manalyzer_T71(Part(x,6));
            Free(x,7);
            break;
          case 1:
D_Manalyzer_T69(Part(x,1));
D_Manalyzer_T71(Part(x,3));
            Free(x,4);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T71(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T71(x);
}

/****ALTERNATIVE(analyzer)****/

int EQ_Manalyzer_T72(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Manalyzer_T71(Part(x,1),Part(y,1))&&EQ_Manalyzer_T72(Part(x,2),Part(y,2))&&EQ_Manalyzer_T72(Part(x,3),Part(y,3));
       case 1:
         return EQ_Manalyzer_T71(Part(x,1),Part(y,1))&&EQ_Manalyzer_T70(Part(x,2),Part(y,2));
       case 2:
         return EQ_Manalyzer_T70(Part(x,1),Part(y,1));
    };
  return 0;
}

int W_Manalyzer_T72(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Manalyzer_T71(Part(x,1));
WRITE(" ");
WRITE("fork ");
W_Manalyzer_T72(Part(x,2));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T72(Part(x,3));
WRITE(" ");
       case 1:
W_Manalyzer_T71(Part(x,1));
WRITE(" ");
WRITE("end ");
W_Manalyzer_T70(Part(x,2));
WRITE(" ");
       case 2:
WRITE("end ");
W_Manalyzer_T70(Part(x,1));
WRITE(" ");
    };
  return 0;
}

int XD_Manalyzer_T72(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T71(Part(x,1));
D_Manalyzer_T72(Part(x,2));
D_Manalyzer_T72(Part(x,3));
            Free(x,4);
            break;
          case 1:
D_Manalyzer_T71(Part(x,1));
D_Manalyzer_T70(Part(x,2));
            Free(x,3);
            break;
          case 2:
D_Manalyzer_T70(Part(x,1));
            Free(x,2);
            break;
    };
}

int D_Manalyzer_T72(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T72(x);
}

/****FAIL(analyzer)****/

int EQ_Manalyzer_T73(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T73(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("yes ");
       case 1:
WRITE("no ");
    };
  return 0;
}

int XD_Manalyzer_T73(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T73(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T73(x);
}

/****FAILED(analyzer)****/

int EQ_Manalyzer_T74(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Manalyzer_T73(Part(x,1),Part(y,1))&&EQ_Manalyzer_T74(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T74(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Manalyzer_T73(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T74(Part(x,2));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T74(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T73(Part(x,1));
D_Manalyzer_T74(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T74(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T74(x);
}

/****IS_ALIVE(analyzer)****/

int EQ_Manalyzer_T75(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
       case 2:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T75(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("yes ");
       case 1:
WRITE("before ");
WRITE("definition ");
       case 2:
WRITE("after ");
WRITE("application ");
    };
  return 0;
}

int XD_Manalyzer_T75(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T75(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T75(x);
}

/****ALIVE(analyzer)****/

int EQ_Manalyzer_T76(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Manalyzer_T75(Part(x,1),Part(y,1))&&EQ_Manalyzer_T76(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T76(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Manalyzer_T75(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Manalyzer_T76(Part(x,2));
WRITE(" ");
       case 1:
WRITE("none ");
    };
  return 0;
}

int XD_Manalyzer_T76(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Manalyzer_T75(Part(x,1));
D_Manalyzer_T76(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T76(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T76(x);
}

/****DIRECTION(analyzer)****/

int EQ_Manalyzer_T138(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
       case 2:
         return 1;
       case 3:
         return 1;
    };
  return 0;
}

int W_Manalyzer_T138(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("left ");
       case 1:
WRITE("right ");
       case 2:
WRITE("none ");
       case 3:
WRITE("unknown ");
    };
  return 0;
}

int XD_Manalyzer_T138(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
          case 2:
            Free(x,1);
            break;
          case 3:
            Free(x,1);
            break;
    };
}

int D_Manalyzer_T138(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Manalyzer_T138(x);
}


/*
** PROTOTYPES
*/

_PROTOTYPE(int Manalyzer_P_semantic_errors,());
_PROTOTYPE(int Manalyzer_P_analyse_main_MODULENR_ROOT,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_analyse_rules_MODULENR,(value P0));
_PROTOTYPE(int Manalyzer_P_resolve_call_ahead_NODENR_RULENR,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_warnings_on,());
_PROTOTYPE(int Manalyzer_P_init,());
_PROTOTYPE(int Manalyzer_P_exit,());
_PROTOTYPE(int Manalyzer_P_analyse_rules_RULENR,(value P0));
_PROTOTYPE(int Manalyzer_P_semantic_error_MESSAGE,(value P0));
_PROTOTYPE(int Manalyzer_P_warn_MESSAGE,(value P0));
_PROTOTYPE(int Manalyzer_P_warn_effect_TEXT,(value P0));
_PROTOTYPE(int Manalyzer_P_warn_no_effect_TEXT,(value P0));
_PROTOTYPE(int Manalyzer_P_warn_can_fail_TEXT,(value P0));
_PROTOTYPE(int Manalyzer_P_warn_can_not_fail_TEXT,(value P0));
_PROTOTYPE(int Manalyzer_P_check_rule_type_RULETYPE,(value P0));
_PROTOTYPE(int Manalyzer_P_copy_pass_two_parameter_INT_OFFSET_TYPENR,(value P0,value P1,value P2));
_PROTOTYPE(int Manalyzer_P_copy_back_pass_two_parameter_INT_OFFSET_TYPENR,(value P0,value P1,value P2));
_PROTOTYPE(int Manalyzer_P_define_RULENR_PARAMETERS_INT_PARAMETER_MAP,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Manalyzer_P_check_defined_pass_two_output_parameters_OUTPUT_VARIABLES,(value P0));
_PROTOTYPE(int Manalyzer_P_check_defined_output_parameters_OUTPUT_VARIABLES,(value P0));
_PROTOTYPE(int Manalyzer_P_apply_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_define_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_new_VARIABLENR_OFFSET_ORIGIN,(value P0,value *P1,value P2));
_PROTOTYPE(int Manalyzer_P_save_context_CONTEXT,(value *P0));
_PROTOTYPE(int Manalyzer_P_save_memory_state_OFFSET_MEM_SET,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_get_allocated_locals_OFFSET_LEFTOVER,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_save_memory_context_MEM_CONTEXT_LEFTOVER,(value *P0,value *P1));
_PROTOTYPE(int Manalyzer_P_save_memory_context_OFFSET_MEM_CONTEXT_LEFTOVER,(value P0,value *P1,value *P2));
_PROTOTYPE(int Manalyzer_P_restore_memory_context_OFFSET_MEM_SET,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_clear_memory_context_OFFSET,(value P0));
_PROTOTYPE(int Manalyzer_P_restore_DEFINED,(value P0));
_PROTOTYPE(int Manalyzer_P_code_cleanup_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_restore_context_CONTEXT_LOCATION,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_check_defect,());
_PROTOTYPE(int Manalyzer_P_continue_analyse_CONTEXT_NODENR_ALTERNATIVE,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_analyse_NODENR_ALTERNATIVE,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_save_ALTERNATIVE,(value *P0));
_PROTOTYPE(int Manalyzer_P_save_CODE_LEFTOVER,(value *P0,value *P1));
_PROTOTYPE(int Manalyzer_P_analyse_member_NODENR,(value P0));
_PROTOTYPE(int Manalyzer_P_is_more_specific_TYPENR_TYPE,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_is_more_specific_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_are_compatible_PARAMETERS_PARAMETERS_DIRECTION,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_analyse_call_RULENRS_EXPRESSIONS_IDENTIFIED_RULENR_STRUCTURES,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(int Manalyzer_P_set_effect_RULETYPE,(value P0));
_PROTOTYPE(int Manalyzer_P_code_call_RULENR_STRUCTURES,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_remove_output_parameters_LEFTOVER_OFFSETS,(value *P0,value P1));
_PROTOTYPE(int Manalyzer_P_remove_output_parameters_LEFTOVER_OFFSET_INT,(value *P0,value P1,value P2));
_PROTOTYPE(int Manalyzer_P_pre_evaluate_PARAMETERS_STRUCTURES_ADDRESSES_OFFSETS,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(int Manalyzer_P_post_evaluate_PARAMETERS_STRUCTURES_ADDRESSES,(value P0,value P1,value P2));
_PROTOTYPE(int Manalyzer_P_match_EXPRESSION_TYPENR_STRUCTURE,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_match_EXPRESSIONS_PARAMETERS_STRUCTURES,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_can_join_EXPRESSION_VARIABLE,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_length_TYPEALTERNATIVE_LENGTH,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_get_TYPE_ALTNR_TYPEALTERNATIVE,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN,(value *P0,value P1,value P2));
_PROTOTYPE(int Manalyzer_P_use_OFFSET,(value P0));
_PROTOTYPE(int Manalyzer_P_store_VARIABLE_VARIABLE_TYPENR,(value P0,value P1,value P2));
_PROTOTYPE(int Manalyzer_P_store_global_VARIABLE_VARIABLE_TYPENR,(value P0,value P1,value P2));
_PROTOTYPE(int Manalyzer_P_store_VARIABLE_OFFSET_TYPENR,(value P0,value *P1,value P2));
_PROTOTYPE(int Manalyzer_P_get_element_OFFSET_ADDRESS_OFFSET,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_get_element_OFFSET_ADDRESS_ELEMENT_OFFSET,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Manalyzer_P_store_OFFSET_VARIABLE_TYPENR,(value P0,value P1,value P2));
_PROTOTYPE(int Manalyzer_P_store_ADDRESS_VARIABLE_TYPENR,(value P0,value P1,value P2));
_PROTOTYPE(int Manalyzer_P_convert_VARIABLE_TYPENR_OFFSET,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_apply_VARIABLENR_ADDRESS,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_code_join_STRUCTURE_OFFSET_TYPENR,(value P0,value *P1,value P2));
_PROTOTYPE(int Manalyzer_P_warn_split_STRUCTURE,(value P0));
_PROTOTYPE(int Manalyzer_P_code_split_ADDRESS_TYPENR_STRUCTURE,(value P0,value P1,value P2));
_PROTOTYPE(int Manalyzer_P_code_join_expression_SUBEXPRESSION_OFFSET_TYPENR,(value P0,value *P1,value P2));
_PROTOTYPE(int Manalyzer_P_code_join_ADDRESS_INT_TYPEALTERNATIVE_STRUCTURE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(int Manalyzer_P_code_split_ADDRESS_INT_TYPEALTERNATIVE_STRUCTURE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(int Manalyzer_P_can_split_VARIABLE_EXPRESSION,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_check_EXPRESSIONS,(value P0));
_PROTOTYPE(int Manalyzer_P_check_EXPRESSION,(value P0));
_PROTOTYPE(int Manalyzer_P_check_SUBEXPRESSION,(value P0));
_PROTOTYPE(int Manalyzer_P_check_VARIABLE_TYPENR,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_is_abstract_synonym_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_should_be_integer_SUBEXPRESSION,(value P0));
_PROTOTYPE(int Manalyzer_P_base_type_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_is_integer_SUBEXPRESSION,(value P0));
_PROTOTYPE(int Manalyzer_P_should_be_text_SUBEXPRESSION,(value P0));
_PROTOTYPE(int Manalyzer_P_is_text_SUBEXPRESSION,(value P0));
_PROTOTYPE(int Manalyzer_P_length_EXPRESSION_LENGTH_LENGTH,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_length_TYPEALTERNATIVE_LENGTH_LENGTH,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_match_TYPENR_EXPRESSION_LENGTH_STRUCTURE,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Manalyzer_P_match_TYPENR_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(int Manalyzer_P_match_TYPE_ALTNR_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE,(value P0,value P1,value P2,value P3,value P4,value *P5,value *P6));
_PROTOTYPE(int Manalyzer_P_match_TYPEALTERNATIVE_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(int Manalyzer_P_match_REST_EXPRESSION_LENGTH_STRUCTURE,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Manalyzer_P_match_STRICT_TYPENR_SUBEXPRESSION_STRUCTURE,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(int Manalyzer_P_variable_type_VARIABLE_TYPENR,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_code_preludes_MODULEORDER_RULENRS,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_code_preludes_MODULENR_RULENRS,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_code_postludes_MODULEORDER_RULENRS,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_code_postludes_MODULENR_RULENRS,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_register_dependancy_OFFSET_ADDRESS,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_register_application_OFFSET_USE,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_register_application_OFFSET_LOCATION,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_register_application_ADDRESS_USE,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_register_application_ADDRESS_LOCATION,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_register_application_without_attach_ADDRESS,(value P0));
_PROTOTYPE(int Manalyzer_P_register_application_OFFSETS_LOCATION,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_register_assignment_OFFSET,(value P0));
_PROTOTYPE(int Manalyzer_P_insert_detach_OFFSET_LOCATION_NUM_LEFT_IS_ALIVE,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(int Manalyzer_P_insert_detach_OFFSET_LOCATION_IS_ALIVE,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_insert_detach_OFFSET_LOCATION_LOCATION,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_determine_creation_state_ORIGIN_NUM_LEFT,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_handle_control_blocks_OFFSET_MEM_CONTEXT_LEFTOVER_ALIVE,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(int Manalyzer_P_handle_control_block_OFFSET_APPLICATIONS_NUM_LEFT_IS_ALIVE,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(int Manalyzer_P_handle_creation_control_ORIGIN_LOCATION_OFFSET_NUM_LEFT_IS_ALIVE,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(int Manalyzer_P_insert_attach_OFFSET_LOCATION_NUM_LEFT_IS_ALIVE,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(int Manalyzer_P_split_control_flow_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_split_control_flow_CODE_LOCATION_LOCATION_LEFTOVER,(value P0,value P1,value P2,value P3));
_PROTOTYPE(int Manalyzer_P_merge_code_CODE_CODE_CODE,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_handle_memory_ALTERNATIVE_LEFTOVER_ALIVE,(value P0,value *P1,value *P2));
_PROTOTYPE(int Manalyzer_P_balance_memory_ALTERNATIVE_LEFTOVER_ALIVE_LEFTOVER_ALIVE_FAILED,(value P0,value P1,value P2,value *P3,value *P4,value *P5));
_PROTOTYPE(int Manalyzer_P_balance_alternative_OFFSET_LOCATION_LEFTOVER_ALIVE_LOCATION_LEFTOVER_ALIVE_FAILED_LEFTOVER_ALIVE,(value P0,value P1,value P2,value P3,value P4,value P5,value P6,value P7,value *P8,value *P9));
_PROTOTYPE(int Manalyzer_P_get_first_location_CODE_LOCATION_LOCATION,(value P0,value P1,value *P2));
_PROTOTYPE(int Manalyzer_P_handle_memory_CODE_LEFTOVER_ALIVE_LEFTOVER_ALIVE_FAILED,(value P0,value P1,value P2,value *P3,value *P4,value *P5));
_PROTOTYPE(int Manalyzer_P_recover_failure_OFFSET_LOCATION_LEFTOVER_LEFTOVER_FAILED_LOCATION_LEFTOVER_ALIVE,(value P0,value P1,value *P2,value P3,value *P4,value P5,value P6,value *P7));
_PROTOTYPE(int Manalyzer_P_insert_memory_ops_OFFSET_MEM_CONTEXT_LEFTOVER_ALIVE,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(int Manalyzer_P_clear_transients_OFFSET,(value P0));
_PROTOTYPE(int Manalyzer_P_need_attaches_TYPENR,(value P0));
_PROTOTYPE(int Manalyzer_P_register_death_OFFSET_IS_ALIVE,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_replace_death_DEATH_LOCATION_LOCATION,(value *P0,value P1,value P2));
_PROTOTYPE(int Manalyzer_P_recover_failure_OFFSET_ALIVE_LOCATION_ALIVE,(value P0,value *P1,value P2,value P3));
_PROTOTYPE(int Manalyzer_P_build_local_map_OFFSET_LOCAL_MAP,(value P0,value *P1));
_PROTOTYPE(int Manalyzer_P_dump_ALTERNATIVE,(value P0));
_PROTOTYPE(int Manalyzer_P_dump_ALTERNATIVE_TEXT,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_dump_CODE_TEXT,(value P0,value P1));
_PROTOTYPE(int Manalyzer_P_dump_MEM_CONTEXT_INT_TEXT,(value P0,value P1,value P2));
_PROTOTYPE(int Manalyzer_P_dump_APPLICATIONS,(value P0));
_PROTOTYPE(int Manalyzer_P_dump_USE,(value P0));
_PROTOTYPE(int Manalyzer_P_dump_mapping_OFFSET,(value P0));
_PROTOTYPE(int Manalyzer_P_dump_DEATH,(value P0));


/*
**EXTERNAL PROTOTYPES**
*/

_PROTOTYPE(extern int E1_open_input_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E2_open_output_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E3_open_standard_output_FILE,(value *P0));
_PROTOTYPE(extern int E4_open_standard_error_FILE,(value *P0));
_PROTOTYPE(extern int E5_open_standard_input_FILE,(value *P0));
_PROTOTYPE(extern int E8_pipe_to_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E28_pipe_from_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E9_close_pipe_FILE,(value P0));
_PROTOTYPE(extern int E6_close_FILE,(value P0));
_PROTOTYPE(extern int E7_seek_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E10_write_TEXT,(value P0));
_PROTOTYPE(extern int E11_write_INT,(value P0));
_PROTOTYPE(extern int E12_write_FILE_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E13_write_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E14_formatted_write_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E15_write_char_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E16_write_char_INT,(value P0));
_PROTOTYPE(extern int E20_trace_TEXT,(value P0));
_PROTOTYPE(extern int E21_trace_INT,(value P0));
_PROTOTYPE(extern int E22_formatted_trace_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E30_read_line_TEXT,(value *P0));
_PROTOTYPE(extern int E31_read_line_FILE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E32_read_char_FILE_INT,(value P0,value *P1));
_PROTOTYPE(extern int E33_read_char_INT,(value *P0));
_PROTOTYPE(extern int E40_less_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E41_lesseq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E42_greater_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E43_greatereq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E58_length_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E51_extract_TEXT_INT_INT_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int E52_is_subtext_TEXT_INT_TEXT,(value P0,value *P1,value P2));
_PROTOTYPE(extern int E53_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E54_not_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E55_before_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E56_is_prefix_TEXT_TEXT_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E57_prefix_TEXT_INT_TEXT_TEXT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int E59_asciicode_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E60_bindec_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E61_decbin_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E70_hash_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E80_command_arg_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E81_exit_INT,(value P0));
_PROTOTYPE(extern int E82_get_from_environment_TEXT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E83_time_INT,(value *P0));
_PROTOTYPE(extern int E85_file_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E84_execute_TEXT,(value P0));
_PROTOTYPE(extern int E200_get_key_TEXT,(value *P0));
_PROTOTYPE(extern int Mcode_P_start_coding,());
_PROTOTYPE(extern int Mcode_P_new_LABEL,(value *P0));
_PROTOTYPE(extern int Mcode_P_error_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_error_MONADIC_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_store_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_append_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_overwrite_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_move_LOCATION_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_current_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_set_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_get_LOCATION_INSTRUCTION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_next_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_is_end_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_first_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_next_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_is_associative_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS,(value P0));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_alias_LABEL_LABEL,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int Mcode_P_called_once_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_get_label_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_no_effect_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_write_ADDRESS,(value P0));
_PROTOTYPE(extern int Mcode_P_get_ADDRESS_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_get_ADDRESSES_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_dump_code_MODULENR_TEXT,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_dump_instruction_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_dump_code_TEXT_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_make_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mcode_P_request_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mrules_P_propagate_rules,());
_PROTOTYPE(extern int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(extern int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(extern int Mrules_P_is_external_RULENR_EXTNR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_in_interface_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_is_fixed_RULENR_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR,(value P0,value *P1,value *P2,value *P3,value *P4,value *P5,value *P6));
_PROTOTYPE(extern int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULETYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_PARAMETERS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mrules_P_get_preludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_postludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_interludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_error_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_error_RULENAME,(value P0));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENAME_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_definition_errors,());
_PROTOTYPE(extern int Mrules_P_set_root_error_handler_HANDLER,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_error_handler_HANDLER,(value *P0));
_PROTOTYPE(extern int Mrules_P_set_root_rule_ROOT,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_rule_ROOT,(value *P0));
_PROTOTYPE(extern int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));
_PROTOTYPE(extern int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value *P1,value *P2,value *P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_set_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_not_local_VARIABLENR,(value P0));
_PROTOTYPE(extern int Mvariables_P_is_constant_VARIABLENR_VALUE,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_global_VARIABLENR_REFNO,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_first_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_next_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_error_INSTANCE,(value P0));
_PROTOTYPE(extern int Mvariables_P_build_instance_INSTANCE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_propagate_types,());
_PROTOTYPE(extern int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_is_imported_abstract_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_abstract_type_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_special_type_TYPENR_STYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_external_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_integer_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_undefined_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_exported_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_same_TYPE_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_same_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_integer_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_is_text_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_text_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_equal_types_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPENAME_MODULENR,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_first_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_next_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_error_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_build_type_TYPENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_type_errors,());
_PROTOTYPE(extern int Mterminals_P_convert_TERMINAL_TERMINALNR,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_get_TERMINALNR_TERMINAL,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_error_terminal_TERMINALNR,(value P0));
_PROTOTYPE(extern int Mnodes_P_new_NODENR,(value *P0));
_PROTOTYPE(extern int Mnodes_P_store_NODENR_LINENR_NODE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mnodes_P_get_NODENR_LINENR_NODE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mnodes_P_append_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_append_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_pass_two_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_error_SUBEXPRESSION,(value P0));
_PROTOTYPE(extern int Mnodes_P_error_EXPRESSION,(value P0));
_PROTOTYPE(extern int Mmodules_P_init_modules,());
_PROTOTYPE(extern int Mmodules_P_is_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_set_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_new_id_MODULENR_ID,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_order_MODULENR_MODULEORDER,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_convert_MODULE_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_add_import_for_module_MODULENR_MODULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_store_versionid_MODULENR_VERSIONTEXT,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_module_exports_rule_MODULENR_RULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_MODULE,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_module_name_MODULENR_MODULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_VERSIONTEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_EXPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_IMPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_first_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_next_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_error_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_int_INT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_error_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_int_INT,(value P0));
_PROTOTYPE(extern int Minline_P_declare_rule_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_register_call_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_inline_TEXT,(value P0));
_PROTOTYPE(extern int Minline_P_inline_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_disable_inlining,());
_PROTOTYPE(extern int Minline_P_ignore_unreachable_code,());
_PROTOTYPE(extern int Minline_P_rule_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_call_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_resolve_call_graph_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_is_recursive_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_rule_is_reachable_RULENR,(value P0));
_PROTOTYPE(extern int Mcoder_P_no_code,());
_PROTOTYPE(extern int Mcoder_P_no_gc,());
_PROTOTYPE(extern int Mcoder_P_trace_on,());
_PROTOTYPE(extern int Mcoder_P_produce_statistics,());
_PROTOTYPE(extern int Mcoder_P_profile_on,());
_PROTOTYPE(extern int Mcoder_P_just_compile_and_no_object,());
_PROTOTYPE(extern int Mcoder_P_extension_TEXT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_external_names_do_not_start_with_underscore,());
_PROTOTYPE(extern int Mcoder_P_optimize_array_references,());
_PROTOTYPE(extern int Mcoder_P_code_MODULENR,(value P0));
_PROTOTYPE(extern int Mscanner_P_syntax_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Mscanner_P_current_line_LINENR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_open_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_close,());
_PROTOTYPE(extern int Mscanner_P_end_of_file,());
_PROTOTYPE(extern int Mscanner_P_is_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_ahead_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_should_be_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME_INSTANCE,(value *P0,value *P1));
_PROTOTYPE(extern int Mscanner_P_is_placeholder_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TERMINAL,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_MODULE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_SIZE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_EXTNR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_NUMBER,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_STRING,(value *P0));
_PROTOTYPE(extern int Mfiles_P_paths_PATHS,(value *P0));
_PROTOTYPE(extern int Mfiles_P_init_files,());
_PROTOTYPE(extern int Mfiles_P_strip_path_TEXT_TEXT_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mfiles_P_set_lib_path_TEXT,(value P0));
_PROTOTYPE(extern int Mfiles_P_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mfiles_P_open_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_BITMAP,(value *P0));
_PROTOTYPE(extern int Mbitmap_P_new_INT_BITMAP,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_INT_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_exclude_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_or_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_and_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_equal_BITMAP_BITMAP,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_set_BITMAP_INT,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_empty_BITMAP,(value P0));
_PROTOTYPE(extern int Mbitmap_P_clear_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_set_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_write_BITMAP,(value P0));
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion,());
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion_RULENR_LOCATION,(value P0,value P1));

/*
** CODE
*/

int Manalyzer_P_semantic_errors()
{
  value L0;
  L0 = (value)G_analyzer_ERRORS_NR8;
  switch (Int(L0)) {
  case 0: goto LAB0;
  default: goto LAB2;
  };
LAB0:
  return 0;
LAB2:
  return 1;
}

int Manalyzer_P_analyse_main_MODULENR_ROOT(P0,P1)
value P0;
value P1;
{
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Create(&L2,4,2);
  *(value *)(L2+1) = L0;
  Create(&L3,11,1);
  L4 = G_analyzer_TEXT_NR2896;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  *(value *)(L2+2) = L3;
if(DecrRefs(G_analyzer_HEADER_NR0)<0)
XD_Merrors_T3(G_analyzer_HEADER_NR0);
  G_analyzer_HEADER_NR0 = L2;
  Create(&L5,11,1);
  L6 = G_analyzer_TEXT_NR2897;
  *(value *)(L5+1) = L6;
  ATTACH(L6);
if(DecrRefs(G_analyzer_SUBHEADER_NR1)<0)
XD_Merrors_T3(G_analyzer_SUBHEADER_NR1);
  G_analyzer_SUBHEADER_NR1 = L5;
  Mmodules_P_order_MODULENR_MODULEORDER(L0,&L7);
  Mrules_P_get_root_error_handler_HANDLER(&L8);
  L32 = L8;
  L33 = C_INT(-1);
  if (!(L32 == L33)) goto LAB1773;
  L34 = C_INT(-1);
  L9 = L34;
  goto LAB1771;
LAB1773:
  Mrules_P_get_RULEID_RULENRS(L32,&L35);
  switch (Alternative(L35)) {
  case 0: goto LAB1774;
  default: goto LAB1778;
  };
LAB1774:
  L36 = (value)(L35[1]);
  L37 = (value)(L35[2]);
  switch (Alternative(L37)) {
  case 1: goto LAB1776;
  default: goto LAB1778;
  };
LAB1776:
  L9 = L36;
if(DecrRefs(L35)<0)
XD_Mrules_T3(L35);
  goto LAB1771;
LAB1778:
  switch (Alternative(L35)) {
  case 0: goto LAB1780;
  default: goto LAB1782;
  };
LAB1780:
  L38 = (value)(L35[1]);
  L39 = (value)(L35[2]);
if(DecrRefs(L35)<0)
XD_Mrules_T3(L35);
  Mrules_P_get_RULEID_RULENAME(L32,&L40);
  Create(&L41,6,2);
  L42 = G_analyzer_TEXT_NR3123;
  *(value *)(L41+1) = L42;
  ATTACH(L42);
  Create(&L43,1,2);
  *(value *)(L43+1) = L40;
  Create(&L44,11,1);
  L45 = G_analyzer_TEXT_NR3124;
  *(value *)(L44+1) = L45;
  ATTACH(L45);
  *(value *)(L43+2) = L44;
  *(value *)(L41+2) = L43;
  Manalyzer_P_semantic_error_MESSAGE(L41);
if(DecrRefs(L41)<0)
XD_Merrors_T3(L41);
  L46 = C_INT(-1);
  L9 = L46;
  goto LAB1771;
LAB1782:
if(DecrRefs(L35)<0)
XD_Mrules_T3(L35);
  Mrules_P_get_RULEID_RULENAME(L32,&L47);
  Create(&L48,6,2);
  L49 = G_analyzer_TEXT_NR3125;
  *(value *)(L48+1) = L49;
  ATTACH(L49);
  Create(&L50,1,2);
  *(value *)(L50+1) = L47;
  Create(&L51,11,1);
  L52 = G_analyzer_TEXT_NR3126;
  *(value *)(L51+1) = L52;
  ATTACH(L52);
  *(value *)(L50+2) = L51;
  *(value *)(L48+2) = L50;
  Manalyzer_P_semantic_error_MESSAGE(L48);
if(DecrRefs(L48)<0)
XD_Merrors_T3(L48);
  L53 = C_INT(-1);
  L9 = L53;
LAB1771:
  Mrules_P_get_RULEID_RULENRS(L1,&L10);
  Mcode_P_current_LOCATION(&L11);
  switch (Alternative(L10)) {
  case 0: goto LAB3;
  default: goto LAB5;
  };
LAB3:
  L12 = (value)(L10[1]);
  L13 = (value)(L10[2]);
  switch (Alternative(L13)) {
  case 1: goto LAB6;
  default: goto LAB5;
  };
LAB6:
  Create(&L14,6,1);
  *(value *)(L14+1) = L9;
  Mcode_P_store_INSTRUCTION(L14);
if(DecrRefs(L14)<0)
XD_Mcode_T14(L14);
  L54 = L7;
  Mrules_P_get_preludes_RULENRS(&L55);
  Manalyzer_P_code_preludes_MODULEORDER_RULENRS(L54,L55);
if(DecrRefs(L55)<0)
XD_Mrules_T3(L55);
LAB1785:
  Create(&L15,11,2);
  *(value *)(L15+1) = L12;
if(DecrRefs(L10)<0)
XD_Mrules_T3(L10);
  L16 = G_analyzer_ADDRESSES_NR2898;
  *(value *)(L15+2) = L16;
  ATTACH(L16);
  Mcode_P_store_INSTRUCTION(L15);
if(DecrRefs(L15)<0)
XD_Mcode_T14(L15);
  L56 = L7;
  Mrules_P_get_postludes_RULENRS(&L57);
  Manalyzer_P_code_postludes_MODULEORDER_RULENRS(L56,L57);
if(DecrRefs(L57)<0)
XD_Mrules_T3(L57);
LAB1788:
if(DecrRefs(L7)<0)
XD_Mmodules_T14(L7);
  L17 = G_analyzer_INSTRUCTION_NR2899;
  Mcode_P_store_INSTRUCTION(L17);
  return 1;
LAB5:
if(DecrRefs(L7)<0)
XD_Mmodules_T14(L7);
  switch (Alternative(L10)) {
  case 0: goto LAB9;
  default: goto LAB11;
  };
LAB9:
  L18 = (value)(L10[1]);
  L19 = (value)(L10[2]);
if(DecrRefs(L10)<0)
XD_Mrules_T3(L10);
  Mrules_P_get_RULEID_RULENAME(L1,&L20);
  Create(&L21,6,2);
  L22 = G_analyzer_TEXT_NR2900;
  *(value *)(L21+1) = L22;
  ATTACH(L22);
  Create(&L23,1,2);
  *(value *)(L23+1) = L20;
  Create(&L24,11,1);
  L25 = G_analyzer_TEXT_NR2901;
  *(value *)(L24+1) = L25;
  ATTACH(L25);
  *(value *)(L23+2) = L24;
  *(value *)(L21+2) = L23;
  Manalyzer_P_semantic_error_MESSAGE(L21);
if(DecrRefs(L21)<0)
XD_Merrors_T3(L21);
  return 1;
LAB11:
if(DecrRefs(L10)<0)
XD_Mrules_T3(L10);
  Mrules_P_get_RULEID_RULENAME(L1,&L26);
  Create(&L27,6,2);
  L28 = G_analyzer_TEXT_NR2902;
  *(value *)(L27+1) = L28;
  ATTACH(L28);
  Create(&L29,1,2);
  *(value *)(L29+1) = L26;
  Create(&L30,11,1);
  L31 = G_analyzer_TEXT_NR2903;
  *(value *)(L30+1) = L31;
  ATTACH(L31);
  *(value *)(L29+2) = L30;
  *(value *)(L27+2) = L29;
  Manalyzer_P_semantic_error_MESSAGE(L27);
if(DecrRefs(L27)<0)
XD_Merrors_T3(L27);
  return 1;
}

int Manalyzer_P_analyse_rules_MODULENR(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  if (!Mrules_P_first_rule_RULENR(&L1)) goto LAB13;
  Mcode_P_start_coding();
  L2 = C_INT(0);
  G_analyzer_ERRORS_NR8 = (long)L2;
  G_analyzer_CURRENT_MODULENR_NR6 = (long)L0;
  Manalyzer_P_analyse_rules_RULENR(L1);
  return 1;
LAB13:
  return 1;
}

int Manalyzer_P_resolve_call_ahead_NODENR_RULENR(P0,P1)
value P0;
value *P1;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mnodes_P_get_NODENR_LINENR_NODE(L0,&L1,&L2);
  switch (Alternative(L2)) {
  case 0: goto LAB14;
  default: goto LAB16;
  };
LAB14:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  Mrules_P_get_RULEID_RULENRS(L3,&L5);
  L6 = G_analyzer_IDENTIFIED_NR2904;
  if (!Manalyzer_P_analyse_call_RULENRS_EXPRESSIONS_IDENTIFIED_RULENR_STRUCTURES(L5,L4,L6,&L7,&L8)) goto LAB18;
if(DecrRefs(L5)<0)
XD_Mrules_T3(L5);
  switch (Alternative(L8)) {
  case 1: goto LAB19;
  default: goto LAB21;
  };
LAB19:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
if(DecrRefs(L8)<0)
XD_Manalyzer_T49(L8);
  return 0;
LAB21:
  Create(&L9,1,2);
  *(value *)(L9+1) = L7;
  *(value *)(L9+2) = L4;
  ATTACH(L4);
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  Mnodes_P_store_NODENR_LINENR_NODE(L0,L1,L9);
if(DecrRefs(L9)<0)
XD_Mnodes_T12(L9);
  L10 = (value) Addr((value*)&G_analyzer_RESOLVED_CALLS_NR16,Int(L0));
if(DecrRefs(*((value*)L10))<0)
XD_Manalyzer_T49(*((value*)L10));
  *((value *)L10) = L8;
  *P1 = L7;
  return 1;
LAB18:
if(DecrRefs(L5)<0)
XD_Mrules_T3(L5);
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  return 0;
LAB16:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  Abort(546, module_name);
}

int Manalyzer_P_warnings_on()
{
  value L0;
  L0 = G_analyzer_BOOLEAN_NR2905;
  ATTACH(L0);
if(DecrRefs(G_analyzer_WARN_NR26)<0)
XD_Manalyzer_T62(G_analyzer_WARN_NR26);
  G_analyzer_WARN_NR26 = L0;
  return 1;
}

int Manalyzer_P_init()
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = G_analyzer_BOOLEAN_NR2906;
  ATTACH(L0);
if(DecrRefs(G_analyzer_WARN_NR26)<0)
XD_Manalyzer_T62(G_analyzer_WARN_NR26);
  G_analyzer_WARN_NR26 = L0;
  L1 = C_INT(0);
  G_analyzer_NR_GLOBALS_NR24 = (long)L1;
  L2 = C_INT(0);
  G_analyzer_GLOBALS_REM_NR25 = (long)L2;
  L3 = C_INT(0);
  G_analyzer_AREF_NR30 = (long)L3;
  L4 = C_INT(0);
  G_analyzer_TREF_NR31 = (long)L4;
  L5 = C_INT(0);
  G_analyzer_XYZZY_NR32 = (long)L5;
  L6 = C_INT(0);
  G_analyzer_NR_GLOBALS_NR24 = (long)L6;
  return 1;
}

int Manalyzer_P_exit()
{
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = G_analyzer_TEXT_NR2907;
  if (!E82_get_from_environment_TEXT_TEXT(L0,&L1)) goto LAB23;
D_TEXT(L1);
  L2 = G_analyzer_TEXT_NR2908;
  Merrors_P_error_text_TEXT(L2);
  L3 = (value)G_analyzer_XYZZY_NR32;
  Merrors_P_error_int_INT(L3);
  L4 = G_analyzer_TEXT_NR2909;
  Merrors_P_error_text_TEXT(L4);
  L5 = G_analyzer_TEXT_NR2910;
  Merrors_P_error_text_TEXT(L5);
  L6 = (value)G_analyzer_NR_RULES_NR3;
  Merrors_P_error_int_INT(L6);
  L7 = G_analyzer_TEXT_NR2911;
  Merrors_P_error_text_TEXT(L7);
  L8 = G_analyzer_TEXT_NR2912;
  Merrors_P_error_text_TEXT(L8);
  L9 = (value)G_analyzer_GLOBALS_REM_NR25;
  Merrors_P_error_int_INT(L9);
  L10 = G_analyzer_TEXT_NR2913;
  Merrors_P_error_text_TEXT(L10);
  L11 = (value)G_analyzer_NR_GLOBALS_NR24;
  Merrors_P_error_int_INT(L11);
  L12 = G_analyzer_TEXT_NR2914;
  Merrors_P_error_text_TEXT(L12);
  L13 = G_analyzer_TEXT_NR2915;
  Merrors_P_error_text_TEXT(L13);
  L14 = (value)G_analyzer_AREF_NR30;
  Merrors_P_error_int_INT(L14);
  L15 = G_analyzer_TEXT_NR2916;
  Merrors_P_error_text_TEXT(L15);
  L16 = (value)G_analyzer_TREF_NR31;
  L17 = (value)G_analyzer_AREF_NR30;
  L18 = C_INT(Int(L16) + Int(L17));
  Merrors_P_error_int_INT(L18);
  L19 = G_analyzer_TEXT_NR2917;
  Merrors_P_error_text_TEXT(L19);
  return 1;
LAB23:
  return 1;
}

int Manalyzer_P_analyse_rules_RULENR(P0)
value P0;
{
  value L83;
  value L82;
  value L81;
  value L80;
  value L79;
  value L78;
  value L77;
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB2711:
  L2 = L0;
  if (!Mrules_P_is_external_RULENR_EXTNR(L2,&L3)) goto LAB2695;
if(DecrRefs(L3)<0)
XD_Mrules_T19(L3);
  goto LAB2693;
LAB2695:
  Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR(L2,&L4,&L5,&L6,&L7,&L8,&L9);
if(DecrRefs(L6)<0)
XD_Mrules_T15(L6);
  L10 = (value)G_analyzer_CURRENT_MODULENR_NR6;
  if (!(L4 == L10)) goto LAB2710;
  G_analyzer_CURRENT_RULE_NR7 = (long)L2;
  Mnodes_P_get_NODENR_LINENR_NODE(L9,&L11,&L12);
if(DecrRefs(L12)<0)
XD_Mnodes_T12(L12);
  L65 = L2;
  L66 = L11;
  if (!Minline_P_rule_is_reachable_RULENR(L65)) goto LAB2699;
  goto LAB2698;
LAB2699:
  L80 = G_analyzer_WARN_NR26;
  switch (Alternative(L80)) {
  case 0: goto LAB2702;
  default: goto LAB2698;
  };
LAB2702:
  L67 = C_INT(1);
  G_analyzer_LOCAL_ERRORS_NR9 = (long)L67;
  Create(&L68,4,2);
  L69 = (value)G_analyzer_CURRENT_MODULENR_NR6;
  *(value *)(L68+1) = L69;
  Create(&L70,6,2);
  L71 = G_analyzer_TEXT_NR2935;
  *(value *)(L70+1) = L71;
  ATTACH(L71);
  Create(&L72,5,2);
  *(value *)(L72+1) = L66;
  Create(&L73,11,1);
  L74 = G_analyzer_TEXT_NR2936;
  *(value *)(L73+1) = L74;
  ATTACH(L74);
  *(value *)(L72+2) = L73;
  *(value *)(L70+2) = L72;
  *(value *)(L68+2) = L70;
if(DecrRefs(G_analyzer_SUBHEADER_NR1)<0)
XD_Merrors_T3(G_analyzer_SUBHEADER_NR1);
  G_analyzer_SUBHEADER_NR1 = L68;
  Create(&L75,6,2);
  L76 = G_analyzer_TEXT_NR2937;
  *(value *)(L75+1) = L76;
  ATTACH(L76);
  Create(&L77,0,2);
  *(value *)(L77+1) = L65;
  Create(&L78,11,1);
  L79 = G_analyzer_TEXT_NR2938;
  *(value *)(L78+1) = L79;
  ATTACH(L79);
  *(value *)(L77+2) = L78;
  *(value *)(L75+2) = L77;
  Manalyzer_P_warn_MESSAGE(L75);
if(DecrRefs(L75)<0)
XD_Merrors_T3(L75);
LAB2698:
  Create(&L13,4,2);
  L14 = (value)G_analyzer_CURRENT_MODULENR_NR6;
  *(value *)(L13+1) = L14;
  Create(&L15,6,2);
  L16 = G_analyzer_TEXT_NR2920;
  *(value *)(L15+1) = L16;
  ATTACH(L16);
  Create(&L17,0,2);
  *(value *)(L17+1) = L2;
  Create(&L18,11,1);
  L19 = G_analyzer_TEXT_NR2921;
  *(value *)(L18+1) = L19;
  ATTACH(L19);
  *(value *)(L17+2) = L18;
  *(value *)(L15+2) = L17;
  *(value *)(L13+2) = L15;
if(DecrRefs(G_analyzer_HEADER_NR0)<0)
XD_Merrors_T3(G_analyzer_HEADER_NR0);
  G_analyzer_HEADER_NR0 = L13;
  Create(&L20,4,2);
  L21 = (value)G_analyzer_CURRENT_MODULENR_NR6;
  *(value *)(L20+1) = L21;
  Create(&L22,6,2);
  L23 = G_analyzer_TEXT_NR2922;
  *(value *)(L22+1) = L23;
  ATTACH(L23);
  Create(&L24,5,2);
  *(value *)(L24+1) = L11;
  Create(&L25,11,1);
  L26 = G_analyzer_TEXT_NR2923;
  *(value *)(L25+1) = L26;
  ATTACH(L26);
  *(value *)(L24+2) = L25;
  *(value *)(L22+2) = L24;
  *(value *)(L20+2) = L22;
if(DecrRefs(G_analyzer_SUBHEADER_NR1)<0)
XD_Merrors_T3(G_analyzer_SUBHEADER_NR1);
  G_analyzer_SUBHEADER_NR1 = L20;
  L27 = C_INT(0);
  G_analyzer_LOCAL_ERRORS_NR9 = (long)L27;
  L28 = C_INT(0);
  G_analyzer_MAX_OFFSET_NR5 = (long)L28;
  L29 = G_analyzer_DEFINED_NR2924;
  ATTACH(L29);
if(DecrRefs(G_analyzer_DEFINED_NR2)<0)
XD_Manalyzer_T3(G_analyzer_DEFINED_NR2);
  G_analyzer_DEFINED_NR2 = L29;
  L30 = G_analyzer_BOOLEAN_NR2925;
  ATTACH(L30);
if(DecrRefs(G_analyzer_HAS_GLOBAL_EFFECT_NR13)<0)
XD_Manalyzer_T62(G_analyzer_HAS_GLOBAL_EFFECT_NR13);
  G_analyzer_HAS_GLOBAL_EFFECT_NR13 = L30;
  L31 = G_analyzer_BOOLEAN_NR2926;
  ATTACH(L31);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L31;
  L32 = G_analyzer_BOOLEAN_NR2927;
  ATTACH(L32);
if(DecrRefs(G_analyzer_FORCED_FAIL_NR11)<0)
XD_Manalyzer_T62(G_analyzer_FORCED_FAIL_NR11);
  G_analyzer_FORCED_FAIL_NR11 = L32;
  L33 = G_analyzer_BOOLEAN_NR2928;
  ATTACH(L33);
if(DecrRefs(G_analyzer_CANFAIL_NR10)<0)
XD_Manalyzer_T62(G_analyzer_CANFAIL_NR10);
  G_analyzer_CANFAIL_NR10 = L33;
  L34 = G_analyzer_OUTPUT_VARIABLES_NR2929;
  ATTACH(L34);
if(DecrRefs(G_analyzer_OUTPUT_VARIABLES_NR14)<0)
XD_Manalyzer_T15(G_analyzer_OUTPUT_VARIABLES_NR14);
  G_analyzer_OUTPUT_VARIABLES_NR14 = L34;
  Mcode_P_current_LOCATION(&L35);
  L36 = G_analyzer_INSTRUCTION_NR2930;
  Mcode_P_store_INSTRUCTION(L36);
  Mcode_P_current_LOCATION(&L37);
  G_analyzer_FAIL_LOCATION_NR15 = (long)L37;
  Mcode_P_set_LOCATION(L35);
  L38 = C_INT(0);
  Manalyzer_P_define_RULENR_PARAMETERS_INT_PARAMETER_MAP(L2,L8,L38,&L39);
if(DecrRefs(L8)<0)
XD_Mrules_T21(L8);
  L40 = G_analyzer_INSTRUCTION_NR2931;
  Mcode_P_store_INSTRUCTION(L40);
  Mcode_P_current_LOCATION(&L41);
  L42 = G_analyzer_CODE_NR2932;
  ATTACH(L42);
if(DecrRefs(G_analyzer_THE_CODE_NR22)<0)
XD_Manalyzer_T71(G_analyzer_THE_CODE_NR22);
  G_analyzer_THE_CODE_NR22 = L42;
  G_analyzer_THE_LOCATION_NR23 = (long)L35;
  Manalyzer_P_analyse_NODENR_ALTERNATIVE(L9,&L43);
  Manalyzer_P_handle_memory_ALTERNATIVE_LEFTOVER_ALIVE(L43,&L44,&L45);
if(DecrRefs(L45)<0)
XD_Manalyzer_T76(L45);
if(DecrRefs(L44)<0)
XD_Manalyzer_T70(L44);
if(DecrRefs(L43)<0)
XD_Manalyzer_T72(L43);
  L46 = G_analyzer_CANFAIL_NR10;
  ATTACH(L46);
  L47 = G_analyzer_FORCED_FAIL_NR11;
  ATTACH(L47);
  L81 = L46;
  L82 = L47;
  switch (Alternative(L81)) {
  case 1: goto LAB2706;
  default: goto LAB2709;
  };
LAB2706:
  L48 = L82;
  ATTACH(L82);
  goto LAB2708;
LAB2709:
  L83 = G_analyzer_BOOLEAN_NR2981;
  L48 = L83;
  ATTACH(L83);
LAB2708:
if(DecrRefs(L47)<0)
XD_Manalyzer_T62(L47);
if(DecrRefs(L46)<0)
XD_Manalyzer_T62(L46);
if(DecrRefs(G_analyzer_CANFAIL_NR10)<0)
XD_Manalyzer_T62(G_analyzer_CANFAIL_NR10);
  G_analyzer_CANFAIL_NR10 = L48;
  Create(&L49,4,2);
  L50 = (value)G_analyzer_CURRENT_MODULENR_NR6;
  *(value *)(L49+1) = L50;
  Create(&L51,6,2);
  L52 = G_analyzer_TEXT_NR2933;
  *(value *)(L51+1) = L52;
  ATTACH(L52);
  Create(&L53,5,2);
  *(value *)(L53+1) = L11;
  Create(&L54,11,1);
  L55 = G_analyzer_TEXT_NR2934;
  *(value *)(L54+1) = L55;
  ATTACH(L55);
  *(value *)(L53+2) = L54;
  *(value *)(L51+2) = L53;
  *(value *)(L49+2) = L51;
if(DecrRefs(G_analyzer_SUBHEADER_NR1)<0)
XD_Merrors_T3(G_analyzer_SUBHEADER_NR1);
  G_analyzer_SUBHEADER_NR1 = L49;
  Manalyzer_P_check_rule_type_RULETYPE(L5);
if(DecrRefs(L5)<0)
XD_Mrules_T20(L5);
  L56 = C_INT(0);
  Manalyzer_P_build_local_map_OFFSET_LOCAL_MAP(L56,&L57);
  Create(&L58,35,3);
  *(value *)(L58+1) = L39;
  *(value *)(L58+2) = L57;
  *(value *)(L58+3) = L41;
  Mcode_P_append_LOCATION_INSTRUCTION(L35,L58);
if(DecrRefs(L58)<0)
XD_Mcode_T14(L58);
  Create(&L59,4,3);
  *(value *)(L59+1) = L2;
  L60 = (value)G_analyzer_MAX_OFFSET_NR5;
  *(value *)(L59+2) = L60;
  L61 = C_INT(0);
  *(value *)(L59+3) = L61;
  Mcode_P_append_LOCATION_INSTRUCTION(L35,L59);
if(DecrRefs(L59)<0)
XD_Mcode_T14(L59);
  L62 = (value)G_analyzer_NR_RULES_NR3;
  L63 = C_INT(1);
  L64 = C_INT(Int(L62) + Int(L63));
  G_analyzer_NR_RULES_NR3 = (long)L64;
  Mcode_P_set_LOCATION(L37);
  goto LAB2693;
LAB2710:
if(DecrRefs(L8)<0)
XD_Mrules_T21(L8);
if(DecrRefs(L5)<0)
XD_Mrules_T20(L5);
LAB2693:
  L1 = L0;
  if (!Mrules_P_next_rule_RULENR(&L1)) goto LAB24;
  L0 = L1;
  goto LAB2711;
LAB24:
  return 1;
  return 1;
}

int Manalyzer_P_semantic_error_MESSAGE(P0)
value P0;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_analyzer_LOCAL_ERRORS_NR9;
  switch (Int(L1)) {
  case 0: goto LAB26;
  default: goto LAB27;
  };
LAB26:
  L2 = G_analyzer_HEADER_NR0;
  ATTACH(L2);
  Merrors_P_error_MESSAGE(L2);
if(DecrRefs(L2)<0)
XD_Merrors_T3(L2);
  L3 = G_analyzer_SUBHEADER_NR1;
  ATTACH(L3);
  Merrors_P_error_MESSAGE(L3);
if(DecrRefs(L3)<0)
XD_Merrors_T3(L3);
  Merrors_P_error_MESSAGE(L0);
  L4 = G_analyzer_TEXT_NR2918;
  Merrors_P_error_text_TEXT(L4);
  L5 = C_INT(1);
  G_analyzer_LOCAL_ERRORS_NR9 = (long)L5;
  L6 = (value)G_analyzer_ERRORS_NR8;
  L7 = C_INT(1);
  L8 = C_INT(Int(L6) + Int(L7));
  G_analyzer_ERRORS_NR8 = (long)L8;
  return 1;
LAB27:
LAB28:
  L9 = G_analyzer_SUBHEADER_NR1;
  ATTACH(L9);
  Merrors_P_error_MESSAGE(L9);
if(DecrRefs(L9)<0)
XD_Merrors_T3(L9);
  Merrors_P_error_MESSAGE(L0);
  L10 = G_analyzer_TEXT_NR2919;
  Merrors_P_error_text_TEXT(L10);
  L11 = (value)G_analyzer_LOCAL_ERRORS_NR9;
  L12 = C_INT(1);
  L13 = C_INT(Int(L11) + Int(L12));
  G_analyzer_LOCAL_ERRORS_NR9 = (long)L13;
  L14 = (value)G_analyzer_ERRORS_NR8;
  L15 = C_INT(1);
  L16 = C_INT(Int(L14) + Int(L15));
  G_analyzer_ERRORS_NR8 = (long)L16;
  return 1;
}

int Manalyzer_P_warn_MESSAGE(P0)
value P0;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_analyzer_LOCAL_ERRORS_NR9;
  switch (Int(L1)) {
  case 0: goto LAB37;
  default: goto LAB38;
  };
LAB37:
  L2 = G_analyzer_HEADER_NR0;
  ATTACH(L2);
  Merrors_P_error_MESSAGE(L2);
if(DecrRefs(L2)<0)
XD_Merrors_T3(L2);
  L3 = G_analyzer_SUBHEADER_NR1;
  ATTACH(L3);
  Merrors_P_error_MESSAGE(L3);
if(DecrRefs(L3)<0)
XD_Merrors_T3(L3);
  Merrors_P_error_MESSAGE(L0);
  L4 = G_analyzer_TEXT_NR2939;
  Merrors_P_error_text_TEXT(L4);
  L5 = C_INT(1);
  G_analyzer_LOCAL_ERRORS_NR9 = (long)L5;
  return 1;
LAB38:
LAB39:
  L6 = G_analyzer_SUBHEADER_NR1;
  ATTACH(L6);
  Merrors_P_error_MESSAGE(L6);
if(DecrRefs(L6)<0)
XD_Merrors_T3(L6);
  Merrors_P_error_MESSAGE(L0);
  L7 = G_analyzer_TEXT_NR2940;
  Merrors_P_error_text_TEXT(L7);
  L8 = (value)G_analyzer_LOCAL_ERRORS_NR9;
  L9 = C_INT(1);
  L10 = C_INT(Int(L8) + Int(L9));
  G_analyzer_LOCAL_ERRORS_NR9 = (long)L10;
  return 1;
}

int Manalyzer_P_warn_effect_TEXT(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_analyzer_HAS_GLOBAL_EFFECT_NR13;
  ATTACH(L1);
  switch (Alternative(L1)) {
  case 0: goto LAB40;
  default: goto LAB41;
  };
LAB40:
if(DecrRefs(L1)<0)
XD_Manalyzer_T62(L1);
  Create(&L2,6,2);
  *(value *)(L2+1) = L0;
  ATTACH(L0);
  Create(&L3,11,1);
  L4 = G_analyzer_TEXT_NR2941;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  *(value *)(L2+2) = L3;
  Manalyzer_P_warn_MESSAGE(L2);
if(DecrRefs(L2)<0)
XD_Merrors_T3(L2);
  return 1;
LAB41:
if(DecrRefs(L1)<0)
XD_Manalyzer_T62(L1);
  return 1;
  return 1;
}

int Manalyzer_P_warn_no_effect_TEXT(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_analyzer_HAS_GLOBAL_EFFECT_NR13;
  ATTACH(L1);
  switch (Alternative(L1)) {
  case 1: goto LAB43;
  default: goto LAB44;
  };
LAB43:
if(DecrRefs(L1)<0)
XD_Manalyzer_T62(L1);
  Create(&L2,6,2);
  *(value *)(L2+1) = L0;
  ATTACH(L0);
  Create(&L3,11,1);
  L4 = G_analyzer_TEXT_NR2942;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  *(value *)(L2+2) = L3;
  Manalyzer_P_warn_MESSAGE(L2);
if(DecrRefs(L2)<0)
XD_Merrors_T3(L2);
  return 1;
LAB44:
if(DecrRefs(L1)<0)
XD_Manalyzer_T62(L1);
  return 1;
  return 1;
}

int Manalyzer_P_warn_can_fail_TEXT(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_analyzer_FORCED_FAIL_NR11;
  ATTACH(L1);
  switch (Alternative(L1)) {
  case 0: goto LAB46;
  default: goto LAB47;
  };
LAB46:
if(DecrRefs(L1)<0)
XD_Manalyzer_T62(L1);
  Create(&L2,6,2);
  *(value *)(L2+1) = L0;
  ATTACH(L0);
  Create(&L3,11,1);
  L4 = G_analyzer_TEXT_NR2943;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  *(value *)(L2+2) = L3;
  Manalyzer_P_warn_MESSAGE(L2);
if(DecrRefs(L2)<0)
XD_Merrors_T3(L2);
  return 1;
LAB47:
if(DecrRefs(L1)<0)
XD_Manalyzer_T62(L1);
  return 1;
  return 1;
}

int Manalyzer_P_warn_can_not_fail_TEXT(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_analyzer_FORCED_FAIL_NR11;
  ATTACH(L1);
  switch (Alternative(L1)) {
  case 1: goto LAB49;
  default: goto LAB50;
  };
LAB49:
if(DecrRefs(L1)<0)
XD_Manalyzer_T62(L1);
  Create(&L2,6,2);
  *(value *)(L2+1) = L0;
  ATTACH(L0);
  Create(&L3,11,1);
  L4 = G_analyzer_TEXT_NR2944;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  *(value *)(L2+2) = L3;
  Manalyzer_P_warn_MESSAGE(L2);
if(DecrRefs(L2)<0)
XD_Merrors_T3(L2);
  return 1;
LAB50:
if(DecrRefs(L1)<0)
XD_Manalyzer_T62(L1);
  return 1;
  return 1;
}

int Manalyzer_P_check_rule_type_RULETYPE(P0)
value P0;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB2692:
  switch (Alternative(L0)) {
  case 5: goto LAB70;
  case 4: goto LAB73;
  case 6: goto LAB76;
  case 3: goto LAB79;
  case 0: goto LAB82;
  case 1: goto LAB85;
  case 2: goto LAB88;
  case 7: goto LAB91;
  default: goto LAB93;
  };
LAB70:
  L1 = G_analyzer_TEXT_NR2945;
  Manalyzer_P_warn_effect_TEXT(L1);
  L2 = G_analyzer_TEXT_NR2946;
  Manalyzer_P_warn_can_not_fail_TEXT(L2);
  return 1;
LAB73:
  L3 = G_analyzer_TEXT_NR2947;
  Manalyzer_P_warn_no_effect_TEXT(L3);
  L4 = G_analyzer_TEXT_NR2948;
  Manalyzer_P_warn_can_not_fail_TEXT(L4);
  return 1;
LAB76:
  L5 = G_analyzer_TEXT_NR2949;
  Manalyzer_P_warn_effect_TEXT(L5);
  L6 = G_analyzer_TEXT_NR2950;
  Manalyzer_P_warn_can_fail_TEXT(L6);
  return 1;
LAB79:
  L7 = G_analyzer_TEXT_NR2951;
  Manalyzer_P_warn_no_effect_TEXT(L7);
  L8 = G_analyzer_TEXT_NR2952;
  Manalyzer_P_warn_can_fail_TEXT(L8);
  return 1;
LAB82:
  L9 = G_analyzer_TEXT_NR2953;
  Manalyzer_P_warn_no_effect_TEXT(L9);
  L10 = G_analyzer_TEXT_NR2954;
  Manalyzer_P_warn_can_fail_TEXT(L10);
  return 1;
LAB85:
  L11 = G_analyzer_TEXT_NR2955;
  Manalyzer_P_warn_no_effect_TEXT(L11);
  L12 = G_analyzer_TEXT_NR2956;
  Manalyzer_P_warn_can_fail_TEXT(L12);
  return 1;
LAB88:
  L13 = G_analyzer_TEXT_NR2957;
  Manalyzer_P_warn_no_effect_TEXT(L13);
  L14 = G_analyzer_TEXT_NR2958;
  Manalyzer_P_warn_can_fail_TEXT(L14);
  return 1;
LAB91:
  L15 = (value)(L0[1]);
  L16 = (value)(L0[2]);
  L0 = L16;
  goto LAB2692;
LAB93:
  Abort(302, module_name);
}

int Manalyzer_P_copy_pass_two_parameter_INT_OFFSET_TYPENR(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  Create(&L3,27,3);
  Create(&L4,6,1);
  *(value *)(L4+1) = L0;
  *(value *)(L3+1) = L4;
  *(value *)(L3+2) = L2;
  Create(&L5,3,1);
  *(value *)(L5+1) = L1;
  *(value *)(L3+3) = L5;
  Mcode_P_store_INSTRUCTION(L3);
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  return 1;
}

int Manalyzer_P_copy_back_pass_two_parameter_INT_OFFSET_TYPENR(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  Create(&L3,27,3);
  Create(&L4,3,1);
  *(value *)(L4+1) = L1;
  *(value *)(L3+1) = L4;
  *(value *)(L3+2) = L2;
  Create(&L5,6,1);
  *(value *)(L5+1) = L0;
  *(value *)(L3+3) = L5;
  Mcode_P_store_INSTRUCTION(L3);
if(DecrRefs(L3)<0)
XD_Mcode_T14(L3);
  return 1;
}

int Manalyzer_P_define_RULENR_PARAMETERS_INT_PARAMETER_MAP(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB1804:
  switch (Alternative(L1)) {
  case 0: goto LAB94;
  case 1: goto LAB106;
  case 2: goto LAB109;
  default: goto LAB111;
  };
LAB94:
  L3 = (value)(L1[1]);
  L4 = (value)(L1[2]);
  L5 = (value)(L1[3]);
  L6 = (value)(L1[4]);
  L7 = (value)G_analyzer_CURRENT_MODULENR_NR6;
  Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR(L7,L0,L4,L5,&L8);
  switch (Alternative(L3)) {
  case 0: goto LAB97;
  case 2: goto LAB100;
  case 1: goto LAB103;
  default: goto LAB105;
  };
LAB97:
  L10 = G_analyzer_ORIGIN_NR2960;
  Manalyzer_P_new_VARIABLENR_OFFSET_ORIGIN(L8,&L9,L10);
  L30 = L2;
  L31 = L9;
  L32 = L4;
  Create(&L33,27,3);
  Create(&L34,4,1);
  *(value *)(L34+1) = L30;
  *(value *)(L33+1) = L34;
  *(value *)(L33+2) = L32;
  Create(&L35,2,1);
  *(value *)(L35+1) = L31;
  *(value *)(L33+3) = L35;
  Mcode_P_store_INSTRUCTION(L33);
if(DecrRefs(L33)<0)
XD_Mcode_T14(L33);
  Manalyzer_P_register_assignment_OFFSET(L31);
LAB1802:
  L11 = C_INT(1);
  L12 = C_INT(Int(L2) + Int(L11));
  Manalyzer_P_define_RULENR_PARAMETERS_INT_PARAMETER_MAP(L0,L6,L12,&L13);
  Create(&L14,0,3);
  *(value *)(L14+1) = L2;
  *(value *)(L14+2) = L9;
  *(value *)(L14+3) = L13;
  *P3 = L14;
  return 1;
LAB100:
  L16 = G_analyzer_ORIGIN_NR2961;
  Manalyzer_P_new_VARIABLENR_OFFSET_ORIGIN(L8,&L15,L16);
  L36 = L2;
  L37 = L15;
  L38 = L4;
  Create(&L39,27,3);
  Create(&L40,4,1);
  *(value *)(L40+1) = L36;
  *(value *)(L39+1) = L40;
  *(value *)(L39+2) = L38;
  Create(&L41,2,1);
  *(value *)(L41+1) = L37;
  *(value *)(L39+3) = L41;
  Mcode_P_store_INSTRUCTION(L39);
if(DecrRefs(L39)<0)
XD_Mcode_T14(L39);
  Manalyzer_P_register_assignment_OFFSET(L37);
LAB1803:
  Create(&L17,0,3);
  *(value *)(L17+1) = L8;
  *(value *)(L17+2) = L2;
  L18 = G_analyzer_OUTPUT_VARIABLES_NR14;
  ATTACH(L18);
  *(value *)(L17+3) = L18;
if(DecrRefs(G_analyzer_OUTPUT_VARIABLES_NR14)<0)
XD_Manalyzer_T15(G_analyzer_OUTPUT_VARIABLES_NR14);
  G_analyzer_OUTPUT_VARIABLES_NR14 = L17;
  L19 = C_INT(1);
  L20 = C_INT(Int(L2) + Int(L19));
  Manalyzer_P_define_RULENR_PARAMETERS_INT_PARAMETER_MAP(L0,L6,L20,&L21);
  Create(&L22,1,3);
  *(value *)(L22+1) = L2;
  *(value *)(L22+2) = L15;
  *(value *)(L22+3) = L21;
  *P3 = L22;
  return 1;
LAB103:
  Create(&L23,0,3);
  *(value *)(L23+1) = L8;
  *(value *)(L23+2) = L2;
  L24 = G_analyzer_OUTPUT_VARIABLES_NR14;
  ATTACH(L24);
  *(value *)(L23+3) = L24;
if(DecrRefs(G_analyzer_OUTPUT_VARIABLES_NR14)<0)
XD_Manalyzer_T15(G_analyzer_OUTPUT_VARIABLES_NR14);
  G_analyzer_OUTPUT_VARIABLES_NR14 = L23;
  L25 = C_INT(1);
  L26 = C_INT(Int(L2) + Int(L25));
  L2 = L26;
  L1 = L6;
  goto LAB1804;
LAB105:
  Abort(339, module_name);
LAB106:
  L28 = (value)(L1[1]);
  Abort(341, module_name);
LAB109:
  L29 = G_analyzer_PARAMETER_MAP_NR2962;
  *P3 = L29;
  ATTACH(L29);
  return 1;
LAB111:
  Abort(344, module_name);
}

int Manalyzer_P_check_defined_pass_two_output_parameters_OUTPUT_VARIABLES(P0)
value P0;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB112;
  case 2: goto LAB117;
  default: goto LAB119;
  };
LAB112:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L3 = (value)(L0[3]);
  L14 = L1;
  Mvariables_P_get_VARIABLENR_OFFSET(L14,&L15);
  L16 = C_INT(-1);
  if (!(L15 == L16)) goto LAB2714;
LAB116:
  Create(&L7,6,2);
  L8 = G_analyzer_TEXT_NR2963;
  *(value *)(L7+1) = L8;
  ATTACH(L8);
  Create(&L9,7,2);
  Create(&L10,3,1);
  Create(&L11,2,1);
  *(value *)(L11+1) = L1;
  *(value *)(L10+1) = L11;
  *(value *)(L9+1) = L10;
  Create(&L12,11,1);
  L13 = G_analyzer_TEXT_NR2964;
  *(value *)(L12+1) = L13;
  ATTACH(L13);
  *(value *)(L9+2) = L12;
  *(value *)(L7+2) = L9;
  Manalyzer_P_semantic_error_MESSAGE(L7);
if(DecrRefs(L7)<0)
XD_Merrors_T3(L7);
  Manalyzer_P_check_defined_pass_two_output_parameters_OUTPUT_VARIABLES(L3);
  return 1;
LAB2714:
  L4 = L15;
LAB2712:
  Create(&L5,2,1);
  *(value *)(L5+1) = L1;
  Manalyzer_P_variable_type_VARIABLE_TYPENR(L5,&L6);
if(DecrRefs(L5)<0)
XD_Mnodes_T11(L5);
  Manalyzer_P_copy_back_pass_two_parameter_INT_OFFSET_TYPENR(L2,L4,L6);
  Manalyzer_P_check_defined_pass_two_output_parameters_OUTPUT_VARIABLES(L3);
  return 1;
LAB117:
  return 1;
LAB119:
  Abort(355, module_name);
}

int Manalyzer_P_check_defined_output_parameters_OUTPUT_VARIABLES(P0)
value P0;
{
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB2139:
  switch (Alternative(L0)) {
  case 0: goto LAB120;
  case 1: goto LAB125;
  case 2: goto LAB128;
  default: goto LAB130;
  };
LAB120:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L3 = (value)(L0[3]);
  L15 = L1;
  Mvariables_P_get_VARIABLENR_OFFSET(L15,&L16);
  L17 = C_INT(-1);
  if (!(L16 == L17)) goto LAB2137;
LAB124:
  Create(&L7,6,2);
  L8 = G_analyzer_TEXT_NR2965;
  *(value *)(L7+1) = L8;
  ATTACH(L8);
  Create(&L9,7,2);
  Create(&L10,3,1);
  Create(&L11,2,1);
  *(value *)(L11+1) = L1;
  *(value *)(L10+1) = L11;
  *(value *)(L9+1) = L10;
  Create(&L12,11,1);
  L13 = G_analyzer_TEXT_NR2966;
  *(value *)(L12+1) = L13;
  ATTACH(L13);
  *(value *)(L9+2) = L12;
  *(value *)(L7+2) = L9;
  Manalyzer_P_semantic_error_MESSAGE(L7);
if(DecrRefs(L7)<0)
XD_Merrors_T3(L7);
  L0 = L3;
  goto LAB2139;
LAB2137:
  L4 = L16;
LAB2135:
  Create(&L5,2,1);
  *(value *)(L5+1) = L1;
  Manalyzer_P_variable_type_VARIABLE_TYPENR(L5,&L6);
if(DecrRefs(L5)<0)
XD_Mnodes_T11(L5);
  L18 = L2;
  L19 = L4;
  L20 = L6;
  Create(&L21,27,3);
  Create(&L22,2,1);
  *(value *)(L22+1) = L19;
  *(value *)(L21+1) = L22;
  *(value *)(L21+2) = L20;
  Create(&L23,4,1);
  *(value *)(L23+1) = L18;
  *(value *)(L21+3) = L23;
  Mcode_P_store_INSTRUCTION(L21);
if(DecrRefs(L21)<0)
XD_Mcode_T14(L21);
  L24 = G_analyzer_USE_NR2959;
  Manalyzer_P_register_application_OFFSET_USE(L19,L24);
LAB2138:
  L0 = L3;
  goto LAB2139;
LAB125:
  L14 = (value)(L0[1]);
  Abort(366, module_name);
LAB128:
  return 1;
LAB130:
  Abort(368, module_name);
}

int Manalyzer_P_apply_VARIABLENR_OFFSET(P0,P1)
value P0;
value *P1;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mvariables_P_get_VARIABLENR_OFFSET(L0,&L1);
  L2 = C_INT(-1);
  if (!(L1 == L2)) goto LAB134;
  Create(&L3,6,2);
  L4 = G_analyzer_TEXT_NR2967;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  Create(&L5,7,2);
  Create(&L6,3,1);
  Create(&L7,2,1);
  *(value *)(L7+1) = L0;
  *(value *)(L6+1) = L7;
  *(value *)(L5+1) = L6;
  Create(&L8,11,1);
  L9 = G_analyzer_TEXT_NR2968;
  *(value *)(L8+1) = L9;
  ATTACH(L9);
  *(value *)(L5+2) = L8;
  *(value *)(L3+2) = L5;
  Manalyzer_P_semantic_error_MESSAGE(L3);
if(DecrRefs(L3)<0)
XD_Merrors_T3(L3);
  L11 = G_analyzer_ORIGIN_NR2969;
  Manalyzer_P_new_VARIABLENR_OFFSET_ORIGIN(L0,&L10,L11);
  *P1 = L10;
  return 1;
LAB134:
  *P1 = L1;
  return 1;
}

int Manalyzer_P_define_VARIABLENR_OFFSET(P0,P1)
value P0;
value P1;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Mvariables_P_get_VARIABLENR_OFFSET(L0,&L2);
  Create(&L3,0,3);
  *(value *)(L3+1) = L0;
  *(value *)(L3+2) = L2;
  L4 = G_analyzer_DEFINED_NR2;
  ATTACH(L4);
  *(value *)(L3+3) = L4;
if(DecrRefs(G_analyzer_DEFINED_NR2)<0)
XD_Manalyzer_T3(G_analyzer_DEFINED_NR2);
  G_analyzer_DEFINED_NR2 = L3;
  Mvariables_P_set_VARIABLENR_OFFSET(L0,L1);
  Manalyzer_P_use_OFFSET(L1);
  return 1;
}

int Manalyzer_P_new_VARIABLENR_OFFSET_ORIGIN(P0,P1,P2)
value P0;
value *P1;
value P2;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P2;
  Create(&L2,2,1);
  *(value *)(L2+1) = L0;
  Manalyzer_P_variable_type_VARIABLE_TYPENR(L2,&L3);
if(DecrRefs(L2)<0)
XD_Mnodes_T11(L2);
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L4,L3,L1);
  Mvariables_P_get_VARIABLENR_OFFSET(L0,&L5);
  Create(&L6,0,3);
  *(value *)(L6+1) = L0;
  *(value *)(L6+2) = L5;
  L7 = G_analyzer_DEFINED_NR2;
  ATTACH(L7);
  *(value *)(L6+3) = L7;
if(DecrRefs(G_analyzer_DEFINED_NR2)<0)
XD_Manalyzer_T3(G_analyzer_DEFINED_NR2);
  G_analyzer_DEFINED_NR2 = L6;
  Mvariables_P_set_VARIABLENR_OFFSET(L0,L4);
  *P1 = L4;
  return 1;
}

int Manalyzer_P_save_context_CONTEXT(P0)
value *P0;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = C_INT(0);
  Manalyzer_P_save_memory_state_OFFSET_MEM_SET(L0,&L1);
  Create(&L2,0,5);
  L3 = G_analyzer_DEFINED_NR2;
  ATTACH(L3);
  *(value *)(L2+1) = L3;
  L4 = (value)G_analyzer_FAIL_LOCATION_NR15;
  *(value *)(L2+2) = L4;
  L5 = G_analyzer_HAS_EFFECT_NR12;
  ATTACH(L5);
  *(value *)(L2+3) = L5;
  L6 = G_analyzer_CANFAIL_NR10;
  ATTACH(L6);
  *(value *)(L2+4) = L6;
  *(value *)(L2+5) = L1;
  L7 = G_analyzer_BOOLEAN_NR2970;
  ATTACH(L7);
if(DecrRefs(G_analyzer_CANFAIL_NR10)<0)
XD_Manalyzer_T62(G_analyzer_CANFAIL_NR10);
  G_analyzer_CANFAIL_NR10 = L7;
  L8 = G_analyzer_BOOLEAN_NR2971;
  ATTACH(L8);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L8;
  L9 = G_analyzer_DEFINED_NR2972;
  ATTACH(L9);
if(DecrRefs(G_analyzer_DEFINED_NR2)<0)
XD_Manalyzer_T3(G_analyzer_DEFINED_NR2);
  G_analyzer_DEFINED_NR2 = L9;
  *P0 = L2;
  return 1;
}

int Manalyzer_P_save_memory_state_OFFSET_MEM_SET(P0,P1)
value P0;
value *P1;
{
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_analyzer_MAX_OFFSET_NR5;
  if (!(L0 == L1)) goto LAB136;
  L2 = G_analyzer_MEM_SET_NR2973;
  *P1 = L2;
  ATTACH(L2);
  return 1;
LAB136:
  L3 = C_INT(1);
  L4 = C_INT(Int(L0) + Int(L3));
  Manalyzer_P_save_memory_state_OFFSET_MEM_SET(L4,&L5);
  Create(&L6,0,4);
  L7 = (value) Addr((value*)&G_analyzer_AUTO_ATTACHED_NR21,Int(L0));
  L8 = *((value*)L7);
  *(value *)(L6+1) = L8;
  ATTACH(L8);
  L9 = (value) Addr((value*)&G_analyzer_DEPENDS_NR18,Int(L0));
  L10 = *((value*)L9);
  *(value *)(L6+2) = L10;
  ATTACH(L10);
  L11 = (value) Addr((value*)&G_analyzer_ELEMENT_NR29,Int(L0));
  L12 = *((value*)L11);
  *(value *)(L6+3) = L12;
  ATTACH(L12);
  *(value *)(L6+4) = L5;
  *P1 = L6;
  return 1;
}

int Manalyzer_P_get_allocated_locals_OFFSET_LEFTOVER(P0,P1)
value P0;
value *P1;
{
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_analyzer_MAX_OFFSET_NR5;
  if (!(L0 == L1)) goto LAB138;
  L2 = G_analyzer_LEFTOVER_NR2974;
  *P1 = L2;
  ATTACH(L2);
  return 1;
LAB138:
  L3 = C_INT(1);
  L4 = C_INT(Int(L0) + Int(L3));
  Manalyzer_P_get_allocated_locals_OFFSET_LEFTOVER(L4,&L5);
  Create(&L6,0,2);
  L7 = (value) Addr((value*)&G_analyzer_AUTO_ATTACHED_NR21,Int(L0));
  L8 = *((value*)L7);
  *(value *)(L6+1) = L8;
  ATTACH(L8);
  *(value *)(L6+2) = L5;
  *P1 = L6;
  return 1;
}

int Manalyzer_P_save_memory_context_MEM_CONTEXT_LEFTOVER(P0,P1)
value *P0;
value *P1;
{
  value L2;
  value L1;
  value L0;
  L0 = C_INT(0);
  Manalyzer_P_save_memory_context_OFFSET_MEM_CONTEXT_LEFTOVER(L0,&L1,&L2);
  *P1 = L2;
  *P0 = L1;
  return 1;
}

int Manalyzer_P_save_memory_context_OFFSET_MEM_CONTEXT_LEFTOVER(P0,P1,P2)
value P0;
value *P1;
value *P2;
{
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_analyzer_MAX_OFFSET_NR5;
  if (!(L0 == L1)) goto LAB140;
  L2 = G_analyzer_MEM_CONTEXT_NR2975;
  L3 = G_analyzer_LEFTOVER_NR2976;
  *P2 = L3;
  ATTACH(L3);
  *P1 = L2;
  ATTACH(L2);
  return 1;
LAB140:
  L4 = C_INT(1);
  L5 = C_INT(Int(L0) + Int(L4));
  Manalyzer_P_save_memory_context_OFFSET_MEM_CONTEXT_LEFTOVER(L5,&L6,&L7);
  Create(&L8,0,2);
  L9 = (value) Addr((value*)&G_analyzer_APPLICATIONS_NR19,Int(L0));
  L10 = *((value*)L9);
  ATTACH(L10);
  *(value *)(L8+1) = L10;
  *(value *)(L8+2) = L6;
  Create(&L11,0,2);
  L12 = (value) Addr((value*)&G_analyzer_AUTO_ATTACHED_NR21,Int(L0));
  L13 = *((value*)L12);
  ATTACH(L13);
  *(value *)(L11+1) = L13;
  *(value *)(L11+2) = L7;
  L14 = G_analyzer_APPLICATIONS_NR2977;
  ATTACH(L14);
if(DecrRefs(*((value*)L9))<0)
XD_Manalyzer_T20(*((value*)L9));
  *((value *)L9) = L14;
  *P2 = L11;
  *P1 = L8;
  return 1;
}

int Manalyzer_P_restore_memory_context_OFFSET_MEM_SET(P0,P1)
value P0;
value P1;
{
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB2162:
  switch (Alternative(L1)) {
  case 1: goto LAB141;
  case 0: goto LAB144;
  default: goto LAB146;
  };
LAB141:
  L11 = L0;
LAB2159:
  L12 = (value)G_analyzer_MAX_OFFSET_NR5;
  if (!(L11 == L12)) goto LAB2161;
  return 1;
LAB2161:
  L13 = G_analyzer_NUM_LEFT_NR2978;
  L14 = (value) Addr((value*)&G_analyzer_AUTO_ATTACHED_NR21,Int(L11));
  ATTACH(L13);
if(DecrRefs(*((value*)L14))<0)
XD_Manalyzer_T61(*((value*)L14));
  *((value *)L14) = L13;
  L15 = G_analyzer_OFFSETS_NR2979;
  L16 = (value) Addr((value*)&G_analyzer_DEPENDS_NR18,Int(L11));
  ATTACH(L15);
if(DecrRefs(*((value*)L16))<0)
XD_Manalyzer_T68(*((value*)L16));
  *((value *)L16) = L15;
  L17 = G_analyzer_ELEMENT_NR2980;
  L18 = (value) Addr((value*)&G_analyzer_ELEMENT_NR29,Int(L11));
  ATTACH(L17);
if(DecrRefs(*((value*)L18))<0)
XD_Manalyzer_T30(*((value*)L18));
  *((value *)L18) = L17;
  L19 = C_INT(1);
  L20 = C_INT(Int(L11) + Int(L19));
  L11 = L20;
  goto LAB2159;
  return 1;
LAB144:
  L2 = (value)(L1[1]);
  L3 = (value) Addr((value*)&G_analyzer_AUTO_ATTACHED_NR21,Int(L0));
  ATTACH(L2);
if(DecrRefs(*((value*)L3))<0)
XD_Manalyzer_T61(*((value*)L3));
  *((value *)L3) = L2;
  L4 = (value)(L1[2]);
  L5 = (value) Addr((value*)&G_analyzer_DEPENDS_NR18,Int(L0));
  ATTACH(L4);
if(DecrRefs(*((value*)L5))<0)
XD_Manalyzer_T68(*((value*)L5));
  *((value *)L5) = L4;
  L6 = (value)(L1[3]);
  L7 = (value) Addr((value*)&G_analyzer_ELEMENT_NR29,Int(L0));
  ATTACH(L6);
if(DecrRefs(*((value*)L7))<0)
XD_Manalyzer_T30(*((value*)L7));
  *((value *)L7) = L6;
  L8 = (value)(L1[4]);
  L9 = C_INT(1);
  L10 = C_INT(Int(L0) + Int(L9));
  L1 = L8;
  L0 = L10;
  goto LAB2162;
LAB146:
  Abort(432, module_name);
}

int Manalyzer_P_clear_memory_context_OFFSET(P0)
value P0;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB2157:
  L1 = (value)G_analyzer_MAX_OFFSET_NR5;
  if (!(L0 == L1)) goto LAB148;
  return 1;
LAB148:
  L2 = G_analyzer_NUM_LEFT_NR2978;
  L3 = (value) Addr((value*)&G_analyzer_AUTO_ATTACHED_NR21,Int(L0));
  ATTACH(L2);
if(DecrRefs(*((value*)L3))<0)
XD_Manalyzer_T61(*((value*)L3));
  *((value *)L3) = L2;
  L4 = G_analyzer_OFFSETS_NR2979;
  L5 = (value) Addr((value*)&G_analyzer_DEPENDS_NR18,Int(L0));
  ATTACH(L4);
if(DecrRefs(*((value*)L5))<0)
XD_Manalyzer_T68(*((value*)L5));
  *((value *)L5) = L4;
  L6 = G_analyzer_ELEMENT_NR2980;
  L7 = (value) Addr((value*)&G_analyzer_ELEMENT_NR29,Int(L0));
  ATTACH(L6);
if(DecrRefs(*((value*)L7))<0)
XD_Manalyzer_T30(*((value*)L7));
  *((value *)L7) = L6;
  L8 = C_INT(1);
  L9 = C_INT(Int(L0) + Int(L8));
  L0 = L9;
  goto LAB2157;
}

int Manalyzer_P_restore_DEFINED(P0)
value P0;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB2156:
  switch (Alternative(L0)) {
  case 0: goto LAB149;
  case 1: goto LAB152;
  case 2: goto LAB155;
  default: goto LAB157;
  };
LAB149:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L3 = (value)(L0[3]);
  Mvariables_P_get_VARIABLENR_OFFSET(L1,&L4);
  Mvariables_P_set_VARIABLENR_OFFSET(L1,L2);
  L0 = L3;
  goto LAB2156;
LAB152:
  L5 = (value)(L0[1]);
  L6 = (value)(L0[2]);
  L0 = L6;
  goto LAB2156;
LAB155:
  return 1;
LAB157:
  Abort(449, module_name);
}

int Manalyzer_P_code_cleanup_LABEL_LOCATION(P0,P1)
value P0;
value *P1;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mcode_P_current_LOCATION(&L1);
  Mcode_P_new_LABEL(&L2);
  L3 = (value)G_analyzer_FAIL_LOCATION_NR15;
  Create(&L4,1,1);
  *(value *)(L4+1) = L0;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L3,L4);
if(DecrRefs(L4)<0)
XD_Mcode_T14(L4);
  Mcode_P_register_label_LABEL(L0);
  Mcode_P_current_LOCATION(&L5);
  Create(&L6,12,1);
  *(value *)(L6+1) = L2;
  Mcode_P_store_INSTRUCTION(L6);
if(DecrRefs(L6)<0)
XD_Mcode_T14(L6);
  Mcode_P_current_LOCATION(&L7);
  L8 = (value)G_analyzer_FAIL_LOCATION_NR15;
  Create(&L9,1,1);
  *(value *)(L9+1) = L2;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L8,L9);
if(DecrRefs(L9)<0)
XD_Mcode_T14(L9);
  Mcode_P_register_label_LABEL(L2);
  Mcode_P_register_goto_LABEL_LOCATION(L2,L7);
  Mcode_P_current_LOCATION(&L10);
  G_analyzer_FAIL_LOCATION_NR15 = (long)L10;
  Mcode_P_set_LOCATION(L1);
  *P1 = L5;
  return 1;
}

int Manalyzer_P_restore_context_CONTEXT_LOCATION(P0,P1)
value P0;
value *P1;
{
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_analyzer_DEFINED_NR2;
  ATTACH(L1);
  Manalyzer_P_restore_DEFINED(L1);
if(DecrRefs(L1)<0)
XD_Manalyzer_T3(L1);
  L2 = (value)(L0[1]);
  ATTACH(L2);
if(DecrRefs(G_analyzer_DEFINED_NR2)<0)
XD_Manalyzer_T3(G_analyzer_DEFINED_NR2);
  G_analyzer_DEFINED_NR2 = L2;
  L3 = (value)(L0[2]);
  G_analyzer_FAIL_LOCATION_NR15 = (long)L3;
  L4 = (value)(L0[3]);
  ATTACH(L4);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L4;
  L5 = (value)(L0[4]);
  ATTACH(L5);
if(DecrRefs(G_analyzer_CANFAIL_NR10)<0)
XD_Manalyzer_T62(G_analyzer_CANFAIL_NR10);
  G_analyzer_CANFAIL_NR10 = L5;
  L6 = (value)(L0[5]);
  L7 = C_INT(0);
  L10 = L7;
  L11 = L6;
LAB2164:
  switch (Alternative(L11)) {
  case 1: goto LAB2165;
  case 0: goto LAB2172;
  default: goto LAB2174;
  };
LAB2165:
  L21 = L10;
LAB2167:
  L22 = (value)G_analyzer_MAX_OFFSET_NR5;
  if (!(L21 == L22)) goto LAB2170;
LAB2163:
  L8 = (value)G_analyzer_FAIL_LOCATION_NR15;
  Mcode_P_prev_LOCATION_LOCATION(L8,&L9);
  Mcode_P_set_LOCATION(L9);
  *P1 = L9;
  return 1;
LAB2170:
  L23 = G_analyzer_NUM_LEFT_NR2978;
  L24 = (value) Addr((value*)&G_analyzer_AUTO_ATTACHED_NR21,Int(L21));
  ATTACH(L23);
if(DecrRefs(*((value*)L24))<0)
XD_Manalyzer_T61(*((value*)L24));
  *((value *)L24) = L23;
  L25 = G_analyzer_OFFSETS_NR2979;
  L26 = (value) Addr((value*)&G_analyzer_DEPENDS_NR18,Int(L21));
  ATTACH(L25);
if(DecrRefs(*((value*)L26))<0)
XD_Manalyzer_T68(*((value*)L26));
  *((value *)L26) = L25;
  L27 = G_analyzer_ELEMENT_NR2980;
  L28 = (value) Addr((value*)&G_analyzer_ELEMENT_NR29,Int(L21));
  ATTACH(L27);
if(DecrRefs(*((value*)L28))<0)
XD_Manalyzer_T30(*((value*)L28));
  *((value *)L28) = L27;
  L29 = C_INT(1);
  L30 = C_INT(Int(L21) + Int(L29));
  L21 = L30;
  goto LAB2167;
LAB2172:
  L12 = (value)(L11[1]);
  L13 = (value) Addr((value*)&G_analyzer_AUTO_ATTACHED_NR21,Int(L10));
  ATTACH(L12);
if(DecrRefs(*((value*)L13))<0)
XD_Manalyzer_T61(*((value*)L13));
  *((value *)L13) = L12;
  L14 = (value)(L11[2]);
  L15 = (value) Addr((value*)&G_analyzer_DEPENDS_NR18,Int(L10));
  ATTACH(L14);
if(DecrRefs(*((value*)L15))<0)
XD_Manalyzer_T68(*((value*)L15));
  *((value *)L15) = L14;
  L16 = (value)(L11[3]);
  L17 = (value) Addr((value*)&G_analyzer_ELEMENT_NR29,Int(L10));
  ATTACH(L16);
if(DecrRefs(*((value*)L17))<0)
XD_Manalyzer_T30(*((value*)L17));
  *((value *)L17) = L16;
  L18 = (value)(L11[4]);
  L19 = C_INT(1);
  L20 = C_INT(Int(L10) + Int(L19));
  L11 = L18;
  L10 = L20;
  goto LAB2164;
LAB2174:
  Abort(432, module_name);
}

int Manalyzer_P_check_defect()
{
  value L2;
  value L1;
  value L0;
  L0 = G_analyzer_HAS_EFFECT_NR12;
  ATTACH(L0);
  switch (Alternative(L0)) {
  case 1: goto LAB161;
  default: goto LAB162;
  };
LAB161:
if(DecrRefs(L0)<0)
XD_Manalyzer_T62(L0);
  return 1;
LAB162:
if(DecrRefs(L0)<0)
XD_Manalyzer_T62(L0);
LAB163:
  Create(&L1,11,1);
  L2 = G_analyzer_TEXT_NR2982;
  *(value *)(L1+1) = L2;
  ATTACH(L2);
  Manalyzer_P_semantic_error_MESSAGE(L1);
if(DecrRefs(L1)<0)
XD_Merrors_T3(L1);
  return 1;
}

int Manalyzer_P_continue_analyse_CONTEXT_NODENR_ALTERNATIVE(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = G_analyzer_CANFAIL_NR10;
  ATTACH(L2);
  switch (Alternative(L2)) {
  case 0: goto LAB167;
  default: goto LAB168;
  };
LAB167:
if(DecrRefs(L2)<0)
XD_Manalyzer_T62(L2);
  Manalyzer_P_restore_context_CONTEXT_LOCATION(L0,&L3);
  G_analyzer_THE_LOCATION_NR23 = (long)L3;
  Mnodes_P_get_NODENR_LINENR_NODE(L1,&L4,&L5);
  switch (Alternative(L5)) {
  case 4: goto LAB170;
  default: goto LAB171;
  };
LAB170:
if(DecrRefs(L5)<0)
XD_Mnodes_T12(L5);
  L6 = G_analyzer_BOOLEAN_NR2984;
  ATTACH(L6);
if(DecrRefs(G_analyzer_FORCED_FAIL_NR11)<0)
XD_Manalyzer_T62(G_analyzer_FORCED_FAIL_NR11);
  G_analyzer_FORCED_FAIL_NR11 = L6;
  Manalyzer_P_check_defect();
  L20 = G_analyzer_HAS_EFFECT_NR12;
  ATTACH(L20);
  switch (Alternative(L20)) {
  case 1: goto LAB2176;
  default: goto LAB2177;
  };
LAB2176:
if(DecrRefs(L20)<0)
XD_Manalyzer_T62(L20);
  goto LAB2175;
LAB2177:
if(DecrRefs(L20)<0)
XD_Manalyzer_T62(L20);
LAB2178:
  L21 = G_analyzer_BOOLEAN_NR2983;
  ATTACH(L21);
if(DecrRefs(G_analyzer_HAS_GLOBAL_EFFECT_NR13)<0)
XD_Manalyzer_T62(G_analyzer_HAS_GLOBAL_EFFECT_NR13);
  G_analyzer_HAS_GLOBAL_EFFECT_NR13 = L21;
LAB2175:
  L7 = C_INT(0);
  L22 = L7;
LAB2180:
  L23 = (value)G_analyzer_MAX_OFFSET_NR5;
  if (!(L22 == L23)) goto LAB2182;
LAB2179:
  L8 = G_analyzer_INSTRUCTION_NR2985;
  Mcode_P_store_INSTRUCTION(L8);
  Manalyzer_P_save_ALTERNATIVE(&L9);
  *P2 = L9;
  return 1;
LAB2182:
  L24 = (value) Addr((value*)&G_analyzer_ORIGINS_NR17,Int(L22));
  L25 = *((value*)L24);
  ATTACH(L25);
  switch (Alternative(L25)) {
  case 4: goto LAB2183;
  default: goto LAB2184;
  };
LAB2183:
if(DecrRefs(L25)<0)
XD_Manalyzer_T65(L25);
  L26 = G_analyzer_NUM_LEFT_NR3192;
  L27 = (value) Addr((value*)&G_analyzer_AUTO_ATTACHED_NR21,Int(L22));
  ATTACH(L26);
if(DecrRefs(*((value*)L27))<0)
XD_Manalyzer_T61(*((value*)L27));
  *((value *)L27) = L26;
  L28 = C_INT(1);
  L29 = C_INT(Int(L22) + Int(L28));
  L22 = L29;
  goto LAB2180;
LAB2184:
if(DecrRefs(L25)<0)
XD_Manalyzer_T65(L25);
LAB2185:
  L30 = C_INT(1);
  L31 = C_INT(Int(L22) + Int(L30));
  L22 = L31;
  goto LAB2180;
LAB168:
if(DecrRefs(L2)<0)
XD_Manalyzer_T62(L2);
LAB169:
  Manalyzer_P_restore_context_CONTEXT_LOCATION(L0,&L11);
  G_analyzer_THE_LOCATION_NR23 = (long)L11;
  Mnodes_P_get_NODENR_LINENR_NODE(L1,&L12,&L13);
  switch (Alternative(L13)) {
  case 4: goto LAB173;
  default: goto LAB174;
  };
LAB171:
if(DecrRefs(L5)<0)
XD_Mnodes_T12(L5);
LAB172:
  Manalyzer_P_analyse_NODENR_ALTERNATIVE(L1,&L10);
  *P2 = L10;
  return 1;
LAB173:
if(DecrRefs(L13)<0)
XD_Mnodes_T12(L13);
  L32 = G_analyzer_HAS_EFFECT_NR12;
  ATTACH(L32);
  switch (Alternative(L32)) {
  case 1: goto LAB2187;
  default: goto LAB2188;
  };
LAB2187:
if(DecrRefs(L32)<0)
XD_Manalyzer_T62(L32);
  goto LAB2186;
LAB2188:
if(DecrRefs(L32)<0)
XD_Manalyzer_T62(L32);
LAB2189:
  L33 = G_analyzer_BOOLEAN_NR2983;
  ATTACH(L33);
if(DecrRefs(G_analyzer_HAS_GLOBAL_EFFECT_NR13)<0)
XD_Manalyzer_T62(G_analyzer_HAS_GLOBAL_EFFECT_NR13);
  G_analyzer_HAS_GLOBAL_EFFECT_NR13 = L33;
LAB2186:
  L14 = C_INT(0);
  Manalyzer_P_get_allocated_locals_OFFSET_LEFTOVER(L14,&L15);
  Create(&L16,2,1);
  *(value *)(L16+1) = L15;
  *P2 = L16;
  return 1;
LAB174:
if(DecrRefs(L13)<0)
XD_Mnodes_T12(L13);
LAB175:
  Create(&L17,11,1);
  L18 = G_analyzer_TEXT_NR2986;
  *(value *)(L17+1) = L18;
  ATTACH(L18);
  Manalyzer_P_semantic_error_MESSAGE(L17);
if(DecrRefs(L17)<0)
XD_Merrors_T3(L17);
  Manalyzer_P_analyse_NODENR_ALTERNATIVE(L1,&L19);
  *P2 = L19;
  return 1;
}

int Manalyzer_P_analyse_NODENR_ALTERNATIVE(P0,P1)
value P0;
value *P1;
{
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB2190:
  if (!Mnodes_P_succeed_NODENR_NODENR(L0,&L1)) goto LAB177;
  if (!Mnodes_P_fail_NODENR_NODENR(L0,&L2)) goto LAB179;
  Manalyzer_P_save_context_CONTEXT(&L3);
  Manalyzer_P_save_CODE_LEFTOVER(&L4,&L5);
if(DecrRefs(L5)<0)
XD_Manalyzer_T70(L5);
  Manalyzer_P_analyse_member_NODENR(L0);
  Manalyzer_P_analyse_NODENR_ALTERNATIVE(L1,&L6);
  Manalyzer_P_continue_analyse_CONTEXT_NODENR_ALTERNATIVE(L3,L2,&L7);
if(DecrRefs(L3)<0)
XD_Manalyzer_T60(L3);
  Create(&L8,0,3);
  *(value *)(L8+1) = L4;
  *(value *)(L8+2) = L6;
  *(value *)(L8+3) = L7;
  *P1 = L8;
  return 1;
LAB179:
  Manalyzer_P_analyse_member_NODENR(L0);
  L0 = L1;
  goto LAB2190;
LAB177:
  if (!Mnodes_P_fail_NODENR_NODENR(L0,&L10)) goto LAB181;
  Manalyzer_P_save_context_CONTEXT(&L11);
  Manalyzer_P_save_CODE_LEFTOVER(&L12,&L13);
if(DecrRefs(L13)<0)
XD_Manalyzer_T70(L13);
  Manalyzer_P_analyse_member_NODENR(L0);
  Manalyzer_P_save_ALTERNATIVE(&L14);
  Manalyzer_P_continue_analyse_CONTEXT_NODENR_ALTERNATIVE(L11,L10,&L15);
if(DecrRefs(L11)<0)
XD_Manalyzer_T60(L11);
  Create(&L16,0,3);
  *(value *)(L16+1) = L12;
  *(value *)(L16+2) = L14;
  *(value *)(L16+3) = L15;
  *P1 = L16;
  return 1;
LAB181:
  Manalyzer_P_analyse_member_NODENR(L0);
  Manalyzer_P_save_ALTERNATIVE(&L17);
  *P1 = L17;
  return 1;
}

int Manalyzer_P_save_ALTERNATIVE(P0)
value *P0;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  Manalyzer_P_save_memory_context_MEM_CONTEXT_LEFTOVER(&L0,&L1);
  Create(&L2,1,3);
  *(value *)(L2+1) = L0;
  L3 = (value)G_analyzer_THE_LOCATION_NR23;
  *(value *)(L2+2) = L3;
  L4 = G_analyzer_THE_CODE_NR22;
  ATTACH(L4);
  *(value *)(L2+3) = L4;
  L5 = G_analyzer_CODE_NR2987;
  ATTACH(L5);
if(DecrRefs(G_analyzer_THE_CODE_NR22)<0)
XD_Manalyzer_T71(G_analyzer_THE_CODE_NR22);
  G_analyzer_THE_CODE_NR22 = L5;
  Create(&L6,1,2);
  *(value *)(L6+1) = L2;
  *(value *)(L6+2) = L1;
  *P0 = L6;
  return 1;
}

int Manalyzer_P_save_CODE_LEFTOVER(P0,P1)
value *P0;
value *P1;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  Manalyzer_P_save_memory_context_MEM_CONTEXT_LEFTOVER(&L0,&L1);
  Create(&L2,1,3);
  *(value *)(L2+1) = L0;
  L3 = (value)G_analyzer_THE_LOCATION_NR23;
  *(value *)(L2+2) = L3;
  L4 = G_analyzer_THE_CODE_NR22;
  ATTACH(L4);
  *(value *)(L2+3) = L4;
  L5 = G_analyzer_CODE_NR2988;
  ATTACH(L5);
if(DecrRefs(G_analyzer_THE_CODE_NR22)<0)
XD_Manalyzer_T71(G_analyzer_THE_CODE_NR22);
  G_analyzer_THE_CODE_NR22 = L5;
  Mcode_P_current_LOCATION(&L6);
  G_analyzer_THE_LOCATION_NR23 = (long)L6;
  *P1 = L1;
  *P0 = L2;
  return 1;
}

int Manalyzer_P_analyse_member_NODENR(P0)
value P0;
{
  value L113;
  value L112;
  value L111;
  value L110;
  value L109;
  value L108;
  value L107;
  value L106;
  value L105;
  value L104;
  value L103;
  value L102;
  value L101;
  value L100;
  value L99;
  value L98;
  value L97;
  value L96;
  value L95;
  value L94;
  value L93;
  value L92;
  value L91;
  value L90;
  value L89;
  value L88;
  value L87;
  value L86;
  value L85;
  value L84;
  value L83;
  value L82;
  value L81;
  value L80;
  value L79;
  value L78;
  value L77;
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mnodes_P_get_NODENR_LINENR_NODE(L0,&L1,&L2);
  Create(&L3,4,2);
  L4 = (value)G_analyzer_CURRENT_MODULENR_NR6;
  *(value *)(L3+1) = L4;
  Create(&L5,6,2);
  L6 = G_analyzer_TEXT_NR2989;
  *(value *)(L5+1) = L6;
  ATTACH(L6);
  Create(&L7,5,2);
  *(value *)(L7+1) = L1;
  Create(&L8,11,1);
  L9 = G_analyzer_TEXT_NR2990;
  *(value *)(L8+1) = L9;
  ATTACH(L9);
  *(value *)(L7+2) = L8;
  *(value *)(L5+2) = L7;
  *(value *)(L3+2) = L5;
if(DecrRefs(G_analyzer_SUBHEADER_NR1)<0)
XD_Merrors_T3(G_analyzer_SUBHEADER_NR1);
  G_analyzer_SUBHEADER_NR1 = L3;
  Create(&L10,20,2);
  *(value *)(L10+1) = L1;
  L11 = (value)G_analyzer_CURRENT_MODULENR_NR6;
  *(value *)(L10+2) = L11;
  Mcode_P_store_INSTRUCTION(L10);
if(DecrRefs(L10)<0)
XD_Mcode_T14(L10);
  switch (Alternative(L2)) {
  case 0: goto LAB182;
  case 1: goto LAB190;
  case 2: goto LAB193;
  case 3: goto LAB196;
  case 4: goto LAB199;
  case 6: goto LAB202;
  case 5: goto LAB205;
  case 7: goto LAB208;
  case 8: goto LAB211;
  case 9: goto LAB214;
  case 10: goto LAB217;
  case 11: goto LAB220;
  default: goto LAB222;
  };
LAB182:
  L12 = (value)(L2[1]);
  L13 = (value)(L2[2]);
  Mrules_P_get_RULEID_RULENRS(L12,&L14);
  Manalyzer_P_check_EXPRESSIONS(L13);
  L15 = G_analyzer_IDENTIFIED_NR2991;
  if (!Manalyzer_P_analyse_call_RULENRS_EXPRESSIONS_IDENTIFIED_RULENR_STRUCTURES(L14,L13,L15,&L16,&L17)) goto LAB186;
if(DecrRefs(L14)<0)
XD_Mrules_T3(L14);
  switch (Alternative(L17)) {
  case 1: goto LAB187;
  default: goto LAB189;
  };
LAB187:
if(DecrRefs(L17)<0)
XD_Manalyzer_T49(L17);
  Mrules_P_get_RULEID_RULENAME(L12,&L18);
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  Create(&L19,6,2);
  L20 = G_analyzer_TEXT_NR2992;
  *(value *)(L19+1) = L20;
  ATTACH(L20);
  Create(&L21,1,2);
  *(value *)(L21+1) = L18;
  Create(&L22,11,1);
  L23 = G_analyzer_TEXT_NR2993;
  *(value *)(L22+1) = L23;
  ATTACH(L23);
  *(value *)(L21+2) = L22;
  *(value *)(L19+2) = L21;
  Manalyzer_P_semantic_error_MESSAGE(L19);
if(DecrRefs(L19)<0)
XD_Merrors_T3(L19);
  return 1;
LAB189:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  Manalyzer_P_code_call_RULENR_STRUCTURES(L16,L17);
if(DecrRefs(L17)<0)
XD_Manalyzer_T49(L17);
  return 1;
LAB186:
if(DecrRefs(L14)<0)
XD_Mrules_T3(L14);
  Mrules_P_get_RULEID_RULENAME(L12,&L24);
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  Create(&L25,6,2);
  L26 = G_analyzer_TEXT_NR2994;
  *(value *)(L25+1) = L26;
  ATTACH(L26);
  Create(&L27,1,2);
  *(value *)(L27+1) = L24;
  Create(&L28,11,1);
  L29 = G_analyzer_TEXT_NR2995;
  *(value *)(L28+1) = L29;
  ATTACH(L29);
  *(value *)(L27+2) = L28;
  *(value *)(L25+2) = L27;
  Manalyzer_P_semantic_error_MESSAGE(L25);
if(DecrRefs(L25)<0)
XD_Merrors_T3(L25);
  return 1;
LAB190:
  L30 = (value)(L2[1]);
  L31 = (value)(L2[2]);
  Manalyzer_P_check_EXPRESSIONS(L31);
  L32 = (value) Addr((value*)&G_analyzer_RESOLVED_CALLS_NR16,Int(L0));
  L33 = *((value*)L32);
  ATTACH(L33);
  Manalyzer_P_code_call_RULENR_STRUCTURES(L30,L33);
if(DecrRefs(L33)<0)
XD_Manalyzer_T49(L33);
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  return 1;
LAB193:
  L34 = (value)(L2[1]);
  L35 = (value)(L2[2]);
  L50 = L34;
  L51 = L35;
  Manalyzer_P_check_EXPRESSION(L50);
  Manalyzer_P_check_EXPRESSION(L51);
  L60 = L50;
  L61 = L51;
  switch (Alternative(L60)) {
  case 1: goto LAB2071;
  default: goto LAB2088;
  };
LAB2071:
  L62 = (value)(L60[1]);
  switch (Alternative(L62)) {
  case 3: goto LAB2073;
  default: goto LAB2088;
  };
LAB2073:
  L63 = (value)(L62[1]);
  L64 = (value)(L60[2]);
  switch (Alternative(L64)) {
  case 2: goto LAB2075;
  default: goto LAB2088;
  };
LAB2075:
  switch (Alternative(L61)) {
  case 1: goto LAB2077;
  default: goto LAB2091;
  };
LAB2077:
  L65 = (value)(L61[1]);
  switch (Alternative(L65)) {
  case 3: goto LAB2079;
  default: goto LAB2091;
  };
LAB2079:
  L66 = (value)(L65[1]);
  L67 = (value)(L61[2]);
  switch (Alternative(L67)) {
  case 2: goto LAB2081;
  default: goto LAB2091;
  };
LAB2081:
  L71 = L63;
  L72 = L66;
  Manalyzer_P_variable_type_VARIABLE_TYPENR(L71,&L73);
  Manalyzer_P_variable_type_VARIABLE_TYPENR(L72,&L74);
  if (!Mtypes_P_equal_types_TYPENR_TYPENR(L73,L74)) goto LAB2083;
  Manalyzer_P_store_VARIABLE_VARIABLE_TYPENR(L71,L72,L73);
  goto LAB2070;
LAB2083:
LAB2094:
  if (!Manalyzer_P_can_split_VARIABLE_EXPRESSION(L63,L61)) goto LAB2096;
  goto LAB2070;
LAB2096:
  if (!Manalyzer_P_can_join_EXPRESSION_VARIABLE(L60,L66)) goto LAB2113;
  goto LAB2070;
LAB2091:
  if (!Manalyzer_P_can_split_VARIABLE_EXPRESSION(L63,L61)) goto LAB2113;
  goto LAB2070;
LAB2088:
  switch (Alternative(L61)) {
  case 1: goto LAB2102;
  default: goto LAB2113;
  };
LAB2102:
  L68 = (value)(L61[1]);
  switch (Alternative(L68)) {
  case 3: goto LAB2104;
  default: goto LAB2113;
  };
LAB2104:
  L69 = (value)(L68[1]);
  L70 = (value)(L61[2]);
  switch (Alternative(L70)) {
  case 2: goto LAB2106;
  default: goto LAB2113;
  };
LAB2106:
  if (!Manalyzer_P_can_join_EXPRESSION_VARIABLE(L60,L69)) goto LAB2113;
  goto LAB2070;
LAB2113:
  Create(&L52,6,2);
  L53 = G_analyzer_TEXT_NR3030;
  *(value *)(L52+1) = L53;
  ATTACH(L53);
  Create(&L54,8,2);
  *(value *)(L54+1) = L50;
  ATTACH(L50);
  Create(&L55,6,2);
  L56 = G_analyzer_TEXT_NR3031;
  *(value *)(L55+1) = L56;
  ATTACH(L56);
  Create(&L57,8,2);
  *(value *)(L57+1) = L51;
  ATTACH(L51);
  Create(&L58,11,1);
  L59 = G_analyzer_TEXT_NR3032;
  *(value *)(L58+1) = L59;
  ATTACH(L59);
  *(value *)(L57+2) = L58;
  *(value *)(L55+2) = L57;
  *(value *)(L54+2) = L55;
  *(value *)(L52+2) = L54;
  Manalyzer_P_semantic_error_MESSAGE(L52);
if(DecrRefs(L52)<0)
XD_Merrors_T3(L52);
LAB2070:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  return 1;
LAB196:
  L36 = (value)(L2[1]);
  L37 = (value)(L2[2]);
  L75 = L36;
  L76 = L37;
  Manalyzer_P_check_EXPRESSION(L75);
  Manalyzer_P_check_EXPRESSION(L76);
  L77 = G_analyzer_BOOLEAN_NR3025;
  ATTACH(L77);
if(DecrRefs(G_analyzer_CANFAIL_NR10)<0)
XD_Manalyzer_T62(G_analyzer_CANFAIL_NR10);
  G_analyzer_CANFAIL_NR10 = L77;
  Manalyzer_P_check_defect();
  switch (Alternative(L75)) {
  case 1: goto LAB2115;
  default: goto LAB2128;
  };
LAB2115:
  L78 = (value)(L75[1]);
  switch (Alternative(L78)) {
  case 3: goto LAB2117;
  default: goto LAB2128;
  };
LAB2117:
  L79 = (value)(L78[1]);
  L80 = (value)(L75[2]);
  switch (Alternative(L80)) {
  case 2: goto LAB2119;
  default: goto LAB2128;
  };
LAB2119:
  switch (Alternative(L76)) {
  case 1: goto LAB2121;
  default: goto LAB2128;
  };
LAB2121:
  L81 = (value)(L76[1]);
  switch (Alternative(L81)) {
  case 3: goto LAB2123;
  default: goto LAB2128;
  };
LAB2123:
  L82 = (value)(L81[1]);
  L83 = (value)(L76[2]);
  switch (Alternative(L83)) {
  case 2: goto LAB2125;
  default: goto LAB2128;
  };
LAB2125:
  Manalyzer_P_variable_type_VARIABLE_TYPENR(L79,&L84);
  Manalyzer_P_variable_type_VARIABLE_TYPENR(L82,&L85);
  if (!Mtypes_P_equal_types_TYPENR_TYPENR(L84,L85)) goto LAB2134;
  Mcode_P_new_LABEL(&L86);
  Manalyzer_P_convert_VARIABLE_TYPENR_OFFSET(L79,L84,&L87);
  Manalyzer_P_convert_VARIABLE_TYPENR_OFFSET(L82,L85,&L88);
  Create(&L89,29,4);
  Create(&L90,2,1);
  *(value *)(L90+1) = L87;
  *(value *)(L89+1) = L90;
  *(value *)(L89+2) = L84;
  Create(&L91,2,1);
  *(value *)(L91+1) = L88;
  *(value *)(L89+3) = L91;
  *(value *)(L89+4) = L86;
  Mcode_P_store_INSTRUCTION(L89);
if(DecrRefs(L89)<0)
XD_Mcode_T14(L89);
  Mcode_P_current_LOCATION(&L92);
  L93 = G_analyzer_USE_NR3026;
  Manalyzer_P_register_application_OFFSET_USE(L87,L93);
  L94 = G_analyzer_USE_NR3027;
  Manalyzer_P_register_application_OFFSET_USE(L88,L94);
  Manalyzer_P_code_cleanup_LABEL_LOCATION(L86,&L95);
  Mcode_P_register_goto_LABEL_LOCATION(L86,L92);
  Manalyzer_P_split_control_flow_LOCATION_LOCATION(L95,L92);
  goto LAB2114;
LAB2134:
  Create(&L96,11,1);
  L97 = G_analyzer_TEXT_NR3028;
  *(value *)(L96+1) = L97;
  ATTACH(L97);
  Manalyzer_P_semantic_error_MESSAGE(L96);
if(DecrRefs(L96)<0)
XD_Merrors_T3(L96);
  goto LAB2114;
LAB2128:
  Create(&L98,11,1);
  L99 = G_analyzer_TEXT_NR3029;
  *(value *)(L98+1) = L99;
  ATTACH(L99);
  Manalyzer_P_semantic_error_MESSAGE(L98);
if(DecrRefs(L98)<0)
XD_Merrors_T3(L98);
LAB2114:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  return 1;
LAB199:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  Abort(570, module_name);
LAB202:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  Abort(572, module_name);
LAB205:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  L38 = G_analyzer_OUTPUT_VARIABLES_NR14;
  ATTACH(L38);
  Manalyzer_P_check_defined_output_parameters_OUTPUT_VARIABLES(L38);
if(DecrRefs(L38)<0)
XD_Manalyzer_T15(L38);
  L39 = G_analyzer_INSTRUCTION_NR2996;
  Mcode_P_store_INSTRUCTION(L39);
  L100 = G_analyzer_HAS_EFFECT_NR12;
  ATTACH(L100);
  switch (Alternative(L100)) {
  case 1: goto LAB2141;
  default: goto LAB2142;
  };
LAB2141:
if(DecrRefs(L100)<0)
XD_Manalyzer_T62(L100);
  return 1;
LAB2142:
if(DecrRefs(L100)<0)
XD_Manalyzer_T62(L100);
LAB2143:
  L101 = G_analyzer_BOOLEAN_NR2983;
  ATTACH(L101);
if(DecrRefs(G_analyzer_HAS_GLOBAL_EFFECT_NR13)<0)
XD_Manalyzer_T62(G_analyzer_HAS_GLOBAL_EFFECT_NR13);
  G_analyzer_HAS_GLOBAL_EFFECT_NR13 = L101;
  return 1;
  return 1;
LAB208:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  L40 = G_analyzer_OUTPUT_VARIABLES_NR14;
  ATTACH(L40);
  Manalyzer_P_check_defined_output_parameters_OUTPUT_VARIABLES(L40);
if(DecrRefs(L40)<0)
XD_Manalyzer_T15(L40);
  L41 = G_analyzer_INSTRUCTION_NR2997;
  Mcode_P_store_INSTRUCTION(L41);
  L102 = G_analyzer_HAS_EFFECT_NR12;
  ATTACH(L102);
  switch (Alternative(L102)) {
  case 1: goto LAB2145;
  default: goto LAB2146;
  };
LAB2145:
if(DecrRefs(L102)<0)
XD_Manalyzer_T62(L102);
  return 1;
LAB2146:
if(DecrRefs(L102)<0)
XD_Manalyzer_T62(L102);
LAB2147:
  L103 = G_analyzer_BOOLEAN_NR2983;
  ATTACH(L103);
if(DecrRefs(G_analyzer_HAS_GLOBAL_EFFECT_NR13)<0)
XD_Manalyzer_T62(G_analyzer_HAS_GLOBAL_EFFECT_NR13);
  G_analyzer_HAS_GLOBAL_EFFECT_NR13 = L103;
  return 1;
  return 1;
LAB211:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  L42 = G_analyzer_BOOLEAN_NR2998;
  ATTACH(L42);
if(DecrRefs(G_analyzer_FORCED_FAIL_NR11)<0)
XD_Manalyzer_T62(G_analyzer_FORCED_FAIL_NR11);
  G_analyzer_FORCED_FAIL_NR11 = L42;
  Manalyzer_P_check_defect();
  L43 = C_INT(0);
  L104 = L43;
LAB2150:
  L105 = (value)G_analyzer_MAX_OFFSET_NR5;
  if (!(L104 == L105)) goto LAB2152;
LAB2149:
  L44 = G_analyzer_INSTRUCTION_NR2999;
  Mcode_P_store_INSTRUCTION(L44);
  return 1;
LAB2152:
  L106 = (value) Addr((value*)&G_analyzer_ORIGINS_NR17,Int(L104));
  L107 = *((value*)L106);
  ATTACH(L107);
  switch (Alternative(L107)) {
  case 4: goto LAB2153;
  default: goto LAB2154;
  };
LAB2153:
if(DecrRefs(L107)<0)
XD_Manalyzer_T65(L107);
  L108 = G_analyzer_NUM_LEFT_NR3192;
  L109 = (value) Addr((value*)&G_analyzer_AUTO_ATTACHED_NR21,Int(L104));
  ATTACH(L108);
if(DecrRefs(*((value*)L109))<0)
XD_Manalyzer_T61(*((value*)L109));
  *((value *)L109) = L108;
  L110 = C_INT(1);
  L111 = C_INT(Int(L104) + Int(L110));
  L104 = L111;
  goto LAB2150;
LAB2154:
if(DecrRefs(L107)<0)
XD_Manalyzer_T65(L107);
LAB2155:
  L112 = C_INT(1);
  L113 = C_INT(Int(L104) + Int(L112));
  L104 = L113;
  goto LAB2150;
LAB214:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  Create(&L45,22,2);
  *(value *)(L45+1) = L1;
  L46 = (value)G_analyzer_CURRENT_MODULENR_NR6;
  *(value *)(L45+2) = L46;
  Mcode_P_store_INSTRUCTION(L45);
if(DecrRefs(L45)<0)
XD_Mcode_T14(L45);
  L47 = G_analyzer_BOOLEAN_NR3000;
  ATTACH(L47);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L47;
  return 1;
LAB217:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  L48 = G_analyzer_INSTRUCTION_NR3001;
  Mcode_P_store_INSTRUCTION(L48);
  L49 = G_analyzer_BOOLEAN_NR3002;
  ATTACH(L49);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L49;
  return 1;
LAB220:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  return 1;
LAB222:
if(DecrRefs(L2)<0)
XD_Mnodes_T12(L2);
  Abort(593, module_name);
}

int Manalyzer_P_is_more_specific_TYPENR_TYPE(P0,P1)
value P0;
value P1;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1901:
  switch (Alternative(L1)) {
  case 0: goto LAB223;
  case 1: goto LAB236;
  default: goto LAB238;
  };
LAB223:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  switch (Alternative(L2)) {
  case 1: goto LAB226;
  default: goto LAB228;
  };
LAB226:
  L4 = (value)(L2[1]);
  L5 = (value)(L2[2]);
  switch (Alternative(L5)) {
  case 2: goto LAB229;
  default: goto LAB228;
  };
LAB229:
  if (!Manalyzer_P_is_more_specific_TYPENR_TYPENR(L0,L4)) goto LAB228;
  return 1;
LAB228:
  L1 = L3;
  goto LAB1901;
  return 0;
LAB236:
  L6 = (value)(L1[1]);
  if (!Manalyzer_P_is_more_specific_TYPENR_TYPENR(L0,L6)) goto LAB238;
  return 1;
LAB238:
  return 0;
}

int Manalyzer_P_is_more_specific_TYPENR_TYPENR(P0,P1)
value P0;
value P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  if (!Mtypes_P_equal_types_TYPENR_TYPENR(L0,L1)) goto LAB242;
  return 1;
LAB242:
  Mtypes_P_get_TYPENR_TYPE(L1,&L2);
  if (!Manalyzer_P_is_more_specific_TYPENR_TYPE(L0,L2)) goto LAB243;
if(DecrRefs(L2)<0)
XD_Mtypes_T11(L2);
  return 1;
LAB243:
if(DecrRefs(L2)<0)
XD_Mtypes_T11(L2);
  return 0;
  return 0;
}

int Manalyzer_P_are_compatible_PARAMETERS_PARAMETERS_DIRECTION(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1902:
  switch (Alternative(L0)) {
  case 0: goto LAB245;
  case 1: goto LAB271;
  case 2: goto LAB279;
  default: goto LAB281;
  };
LAB245:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  L4 = (value)(L0[3]);
  L5 = (value)(L0[4]);
  switch (Alternative(L1)) {
  case 0: goto LAB248;
  default: goto LAB281;
  };
LAB248:
  L6 = (value)(L1[1]);
  L7 = (value)(L1[2]);
  L8 = (value)(L1[3]);
  L9 = (value)(L1[4]);
  if (!Manalyzer_P_are_compatible_PARAMETERS_PARAMETERS_DIRECTION(L5,L9,&L10)) goto LAB252;
  if (!Mtypes_P_equal_types_TYPENR_TYPENR(L3,L7)) goto LAB254;
  *P2 = L10;
  return 1;
LAB254:
  if (!Manalyzer_P_is_more_specific_TYPENR_TYPENR(L3,L7)) goto LAB256;
  switch (Alternative(L10)) {
  case 1: goto LAB257;
  case 3: goto LAB260;
  default: goto LAB262;
  };
LAB257:
if(DecrRefs(L10)<0)
XD_Manalyzer_T138(L10);
  L11 = G_analyzer_DIRECTION_NR3003;
  *P2 = L11;
  ATTACH(L11);
  return 1;
LAB260:
if(DecrRefs(L10)<0)
XD_Manalyzer_T138(L10);
  L12 = G_analyzer_DIRECTION_NR3004;
  *P2 = L12;
  ATTACH(L12);
  return 1;
LAB262:
  *P2 = L10;
  return 1;
LAB256:
  if (!Manalyzer_P_is_more_specific_TYPENR_TYPENR(L7,L3)) goto LAB264;
  switch (Alternative(L10)) {
  case 0: goto LAB265;
  case 3: goto LAB268;
  default: goto LAB270;
  };
LAB265:
if(DecrRefs(L10)<0)
XD_Manalyzer_T138(L10);
  L13 = G_analyzer_DIRECTION_NR3005;
  *P2 = L13;
  ATTACH(L13);
  return 1;
LAB268:
if(DecrRefs(L10)<0)
XD_Manalyzer_T138(L10);
  L14 = G_analyzer_DIRECTION_NR3006;
  *P2 = L14;
  ATTACH(L14);
  return 1;
LAB270:
  *P2 = L10;
  return 1;
LAB264:
if(DecrRefs(L10)<0)
XD_Manalyzer_T138(L10);
  return 0;
LAB252:
  return 0;
LAB271:
  L15 = (value)(L0[1]);
  switch (Alternative(L1)) {
  case 1: goto LAB274;
  default: goto LAB281;
  };
LAB274:
  L16 = (value)(L1[1]);
  L1 = L16;
  L0 = L15;
  goto LAB1902;
  return 0;
LAB279:
  switch (Alternative(L1)) {
  case 2: goto LAB282;
  default: goto LAB281;
  };
LAB282:
  L18 = G_analyzer_DIRECTION_NR3007;
  *P2 = L18;
  ATTACH(L18);
  return 1;
LAB281:
  Abort(636, module_name);
}

int Manalyzer_P_analyse_call_RULENRS_EXPRESSIONS_IDENTIFIED_RULENR_STRUCTURES(P0,P1,P2,P3,P4)
value P0;
value P1;
value P2;
value *P3;
value *P4;
{
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB1903:
  switch (Alternative(L0)) {
  case 0: goto LAB285;
  default: goto LAB287;
  };
LAB285:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR(L3,&L5,&L6,&L7,&L8,&L9,&L10);
if(DecrRefs(L7)<0)
XD_Mrules_T15(L7);
if(DecrRefs(L6)<0)
XD_Mrules_T20(L6);
  if (!Manalyzer_P_match_EXPRESSIONS_PARAMETERS_STRUCTURES(L1,L9,&L11)) goto LAB289;
  switch (Alternative(L2)) {
  case 0: goto LAB290;
  default: goto LAB292;
  };
LAB290:
  L12 = (value)(L2[1]);
  if (!Manalyzer_P_are_compatible_PARAMETERS_PARAMETERS_DIRECTION(L9,L12,&L13)) goto LAB294;
  switch (Alternative(L13)) {
  case 0: goto LAB295;
  default: goto LAB297;
  };
LAB295:
if(DecrRefs(L13)<0)
XD_Manalyzer_T138(L13);
  Create(&L14,0,1);
  *(value *)(L14+1) = L9;
  if (!Manalyzer_P_analyse_call_RULENRS_EXPRESSIONS_IDENTIFIED_RULENR_STRUCTURES(L4,L1,L14,&L15,&L16)) goto LAB298;
if(DecrRefs(L11)<0)
XD_Manalyzer_T49(L11);
if(DecrRefs(L14)<0)
XD_Manalyzer_T55(L14);
  *P4 = L16;
  *P3 = L15;
  return 1;
LAB298:
if(DecrRefs(L14)<0)
XD_Manalyzer_T55(L14);
LAB299:
  *P4 = L11;
  *P3 = L3;
  return 1;
LAB297:
if(DecrRefs(L11)<0)
XD_Manalyzer_T49(L11);
  switch (Alternative(L13)) {
  case 1: goto LAB300;
  default: goto LAB302;
  };
LAB300:
if(DecrRefs(L9)<0)
XD_Mrules_T21(L9);
if(DecrRefs(L13)<0)
XD_Manalyzer_T138(L13);
  L0 = L4;
  goto LAB1903;
  return 0;
LAB302:
if(DecrRefs(L13)<0)
XD_Manalyzer_T138(L13);
  if (!Manalyzer_P_analyse_call_RULENRS_EXPRESSIONS_IDENTIFIED_RULENR_STRUCTURES(L4,L1,L2,&L19,&L20)) goto LAB305;
  Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR(L19,&L21,&L22,&L23,&L24,&L25,&L26);
if(DecrRefs(L23)<0)
XD_Mrules_T15(L23);
if(DecrRefs(L22)<0)
XD_Mrules_T20(L22);
if(DecrRefs(L25)<0)
XD_Mrules_T21(L25);
if(DecrRefs(L9)<0)
XD_Mrules_T21(L9);
  if (!Manalyzer_P_are_compatible_PARAMETERS_PARAMETERS_DIRECTION(L9,L25,&L27)) goto LAB307;
  switch (Alternative(L27)) {
  case 1: goto LAB308;
  default: goto LAB309;
  };
LAB308:
if(DecrRefs(L27)<0)
XD_Manalyzer_T138(L27);
  *P4 = L20;
  *P3 = L19;
  return 1;
LAB305:
if(DecrRefs(L9)<0)
XD_Mrules_T21(L9);
  goto LAB306;
LAB309:
if(DecrRefs(L27)<0)
XD_Manalyzer_T138(L27);
if(DecrRefs(L25)<0)
XD_Mrules_T21(L25);
if(DecrRefs(L23)<0)
XD_Mrules_T15(L23);
if(DecrRefs(L22)<0)
XD_Mrules_T20(L22);
if(DecrRefs(L20)<0)
XD_Manalyzer_T49(L20);
if(DecrRefs(L9)<0)
XD_Mrules_T21(L9);
  goto LAB306;
LAB307:
if(DecrRefs(L20)<0)
XD_Manalyzer_T49(L20);
LAB306:
  L28 = G_analyzer_STRUCTURES_NR3008;
  *P4 = L28;
  ATTACH(L28);
  *P3 = L3;
  return 1;
LAB294:
if(DecrRefs(L11)<0)
XD_Manalyzer_T49(L11);
if(DecrRefs(L9)<0)
XD_Mrules_T21(L9);
  L29 = G_analyzer_STRUCTURES_NR3009;
  *P4 = L29;
  ATTACH(L29);
  *P3 = L3;
  return 1;
LAB292:
  Create(&L30,0,1);
  *(value *)(L30+1) = L9;
  if (!Manalyzer_P_analyse_call_RULENRS_EXPRESSIONS_IDENTIFIED_RULENR_STRUCTURES(L4,L1,L30,&L31,&L32)) goto LAB312;
if(DecrRefs(L11)<0)
XD_Manalyzer_T49(L11);
if(DecrRefs(L30)<0)
XD_Manalyzer_T55(L30);
  *P4 = L32;
  *P3 = L31;
  return 1;
LAB312:
if(DecrRefs(L30)<0)
XD_Manalyzer_T55(L30);
LAB313:
  *P4 = L11;
  *P3 = L3;
  return 1;
LAB289:
if(DecrRefs(L9)<0)
XD_Mrules_T21(L9);
  L0 = L4;
  goto LAB1903;
  return 0;
LAB287:
  return 0;
}

int Manalyzer_P_set_effect_RULETYPE(P0)
value P0;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1945:
  switch (Alternative(L0)) {
  case 3: goto LAB316;
  case 4: goto LAB319;
  case 5: goto LAB322;
  case 6: goto LAB325;
  case 0: goto LAB328;
  case 2: goto LAB331;
  case 1: goto LAB334;
  case 7: goto LAB337;
  default: goto LAB339;
  };
LAB316:
  L1 = G_analyzer_BOOLEAN_NR3010;
  ATTACH(L1);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L1;
  return 1;
LAB319:
  L2 = G_analyzer_BOOLEAN_NR3011;
  ATTACH(L2);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L2;
  return 1;
LAB322:
  return 1;
LAB325:
  return 1;
LAB328:
  L3 = G_analyzer_BOOLEAN_NR3012;
  ATTACH(L3);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L3;
  return 1;
LAB331:
  L4 = G_analyzer_BOOLEAN_NR3013;
  ATTACH(L4);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L4;
  return 1;
LAB334:
  L5 = G_analyzer_BOOLEAN_NR3014;
  ATTACH(L5);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L5;
  return 1;
LAB337:
  L6 = (value)(L0[1]);
  L7 = (value)(L0[2]);
  L0 = L6;
  goto LAB1945;
LAB339:
  Abort(676, module_name);
}

int Manalyzer_P_code_call_RULENR_STRUCTURES(P0,P1)
value P0;
value P1;
{
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR(L0,&L2,&L3,&L4,&L5,&L6,&L7);
if(DecrRefs(L4)<0)
XD_Mrules_T15(L4);
  Manalyzer_P_pre_evaluate_PARAMETERS_STRUCTURES_ADDRESSES_OFFSETS(L6,L1,&L8,&L9);
  L19 = L3;
  switch (Alternative(L19)) {
  case 7: goto LAB1927;
  default: goto LAB1931;
  };
LAB1927:
  L20 = (value)(L19[1]);
  switch (Alternative(L20)) {
  case 5: goto LAB1929;
  default: goto LAB1931;
  };
LAB1929:
  L21 = (value)(L19[2]);
  goto LAB1926;
LAB1931:
  switch (Alternative(L19)) {
  case 7: goto LAB1933;
  case 5: goto LAB1926;
  case 4: goto LAB1926;
  default: goto LAB341;
  };
LAB1933:
  L22 = (value)(L19[1]);
  switch (Alternative(L22)) {
  case 4: goto LAB1935;
  default: goto LAB341;
  };
LAB1935:
  L23 = (value)(L19[2]);
LAB1926:
  Mcode_P_new_LABEL(&L10);
  Create(&L11,10,3);
  *(value *)(L11+1) = L0;
  *(value *)(L11+2) = L8;
  ATTACH(L8);
  *(value *)(L11+3) = L10;
  Mcode_P_store_INSTRUCTION(L11);
if(DecrRefs(L11)<0)
XD_Mcode_T14(L11);
  Mcode_P_current_LOCATION(&L12);
  L13 = G_analyzer_BOOLEAN_NR3015;
  ATTACH(L13);
if(DecrRefs(G_analyzer_CANFAIL_NR10)<0)
XD_Manalyzer_T62(G_analyzer_CANFAIL_NR10);
  G_analyzer_CANFAIL_NR10 = L13;
  Manalyzer_P_check_defect();
  L24 = L3;
LAB1947:
  switch (Alternative(L24)) {
  case 3: goto LAB1948;
  case 4: goto LAB1951;
  case 5: goto LAB1946;
  case 6: goto LAB1946;
  case 0: goto LAB1960;
  case 2: goto LAB1963;
  case 1: goto LAB1966;
  case 7: goto LAB1969;
  default: goto LAB1971;
  };
LAB1948:
  L25 = G_analyzer_BOOLEAN_NR3010;
  ATTACH(L25);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L25;
  goto LAB1946;
LAB1951:
  L26 = G_analyzer_BOOLEAN_NR3011;
  ATTACH(L26);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L26;
  goto LAB1946;
LAB1960:
  L27 = G_analyzer_BOOLEAN_NR3012;
  ATTACH(L27);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L27;
  goto LAB1946;
LAB1963:
  L28 = G_analyzer_BOOLEAN_NR3013;
  ATTACH(L28);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L28;
  goto LAB1946;
LAB1966:
  L29 = G_analyzer_BOOLEAN_NR3014;
  ATTACH(L29);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L29;
LAB1946:
if(DecrRefs(L3)<0)
XD_Mrules_T20(L3);
  Manalyzer_P_save_CODE_LEFTOVER(&L14,&L15);
  L16 = L15;
  Manalyzer_P_remove_output_parameters_LEFTOVER_OFFSETS(&L16,L9);
if(DecrRefs(L9)<0)
XD_Manalyzer_T68(L9);
  Manalyzer_P_post_evaluate_PARAMETERS_STRUCTURES_ADDRESSES(L6,L1,L8);
if(DecrRefs(L8)<0)
XD_Mcode_T19(L8);
if(DecrRefs(L6)<0)
XD_Mrules_T21(L6);
  Manalyzer_P_code_cleanup_LABEL_LOCATION(L10,&L17);
  Mcode_P_register_goto_LABEL_LOCATION(L10,L12);
  Manalyzer_P_split_control_flow_CODE_LOCATION_LOCATION_LEFTOVER(L14,L17,L12,L16);
if(DecrRefs(L16)<0)
XD_Manalyzer_T70(L16);
if(DecrRefs(L14)<0)
XD_Manalyzer_T71(L14);
  return 1;
LAB1969:
  L30 = (value)(L24[1]);
  L31 = (value)(L24[2]);
  L24 = L30;
  goto LAB1947;
LAB1971:
  Abort(676, module_name);
LAB341:
if(DecrRefs(L9)<0)
XD_Manalyzer_T68(L9);
  Create(&L18,11,2);
  *(value *)(L18+1) = L0;
  *(value *)(L18+2) = L8;
  ATTACH(L8);
  Mcode_P_store_INSTRUCTION(L18);
if(DecrRefs(L18)<0)
XD_Mcode_T14(L18);
  L32 = L3;
LAB1983:
  switch (Alternative(L32)) {
  case 3: goto LAB1984;
  case 4: goto LAB1987;
  case 5: goto LAB1982;
  case 6: goto LAB1982;
  case 0: goto LAB1996;
  case 2: goto LAB1999;
  case 1: goto LAB2002;
  case 7: goto LAB2005;
  default: goto LAB2007;
  };
LAB1984:
  L33 = G_analyzer_BOOLEAN_NR3010;
  ATTACH(L33);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L33;
  goto LAB1982;
LAB1987:
  L34 = G_analyzer_BOOLEAN_NR3011;
  ATTACH(L34);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L34;
  goto LAB1982;
LAB1996:
  L35 = G_analyzer_BOOLEAN_NR3012;
  ATTACH(L35);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L35;
  goto LAB1982;
LAB1999:
  L36 = G_analyzer_BOOLEAN_NR3013;
  ATTACH(L36);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L36;
  goto LAB1982;
LAB2002:
  L37 = G_analyzer_BOOLEAN_NR3014;
  ATTACH(L37);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L37;
LAB1982:
if(DecrRefs(L3)<0)
XD_Mrules_T20(L3);
  Manalyzer_P_post_evaluate_PARAMETERS_STRUCTURES_ADDRESSES(L6,L1,L8);
if(DecrRefs(L8)<0)
XD_Mcode_T19(L8);
if(DecrRefs(L6)<0)
XD_Mrules_T21(L6);
  return 1;
LAB2005:
  L38 = (value)(L32[1]);
  L39 = (value)(L32[2]);
  L32 = L38;
  goto LAB1983;
LAB2007:
  Abort(676, module_name);
}

int Manalyzer_P_remove_output_parameters_LEFTOVER_OFFSETS(P0,P1)
value *P0;
value P1;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = P1;
LAB1972:
  switch (Alternative(L1)) {
  case 1: goto LAB342;
  case 0: goto LAB345;
  default: goto LAB347;
  };
LAB342:
  *P0 = L0;
  return 1;
LAB345:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  L4 = L0;
  L5 = C_INT(0);
  Manalyzer_P_remove_output_parameters_LEFTOVER_OFFSET_INT(&L4,L2,L5);
  L6 = L4;
  L1 = L3;
  L0 = L6;
  goto LAB1972;
LAB347:
if(DecrRefs(L0)<0)
XD_Manalyzer_T70(L0);
  Abort(703, module_name);
}

int Manalyzer_P_remove_output_parameters_LEFTOVER_OFFSET_INT(P0,P1,P2)
value *P0;
value P1;
value P2;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L0)) {
  case 1: goto LAB348;
  case 0: goto LAB351;
  default: goto LAB353;
  };
LAB348:
  *P0 = L0;
  return 1;
LAB351:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  if (!(L2 == L1)) goto LAB355;
  Create(&L5,0,2);
  L6 = G_analyzer_NUM_LEFT_NR3016;
  *(value *)(L5+1) = L6;
  ATTACH(L6);
  *(value *)(L5+2) = L4;
  ATTACH(L4);
if(DecrRefs(L0)<0)
XD_Manalyzer_T70(L0);
  *P0 = L5;
  return 1;
LAB355:
  L7 = L4;
  ATTACH(L7);
  L8 = C_INT(1);
  L9 = C_INT(Int(L2) + Int(L8));
  Manalyzer_P_remove_output_parameters_LEFTOVER_OFFSET_INT(&L7,L1,L9);
  Create(&L10,0,2);
  *(value *)(L10+1) = L3;
  ATTACH(L3);
if(DecrRefs(L0)<0)
XD_Manalyzer_T70(L0);
  *(value *)(L10+2) = L7;
  *P0 = L10;
  return 1;
LAB353:
if(DecrRefs(L0)<0)
XD_Manalyzer_T70(L0);
  Abort(712, module_name);
}

int Manalyzer_P_pre_evaluate_PARAMETERS_STRUCTURES_ADDRESSES_OFFSETS(P0,P1,P2,P3)
value P0;
value P1;
value *P2;
value *P3;
{
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  switch (Alternative(L1)) {
  case 0: goto LAB356;
  case 2: goto LAB371;
  default: goto LAB373;
  };
LAB356:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  switch (Alternative(L0)) {
  case 0: goto LAB359;
  default: goto LAB373;
  };
LAB359:
  L4 = (value)(L0[1]);
  L5 = (value)(L0[2]);
  L6 = (value)(L0[3]);
  L7 = (value)(L0[4]);
  switch (Alternative(L4)) {
  case 0: goto LAB362;
  case 1: goto LAB365;
  case 2: goto LAB368;
  default: goto LAB370;
  };
LAB362:
  Manalyzer_P_code_join_STRUCTURE_OFFSET_TYPENR(L2,&L8,L5);
  Manalyzer_P_pre_evaluate_PARAMETERS_STRUCTURES_ADDRESSES_OFFSETS(L7,L3,&L9,&L10);
  Create(&L11,0,2);
  Create(&L12,2,1);
  *(value *)(L12+1) = L8;
  *(value *)(L11+1) = L12;
  *(value *)(L11+2) = L9;
  *P3 = L10;
  *P2 = L11;
  return 1;
LAB365:
  L14 = G_analyzer_ORIGIN_NR3017;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L13,L5,L14);
  Manalyzer_P_pre_evaluate_PARAMETERS_STRUCTURES_ADDRESSES_OFFSETS(L7,L3,&L15,&L16);
  Create(&L17,0,2);
  Create(&L18,2,1);
  *(value *)(L18+1) = L13;
  *(value *)(L17+1) = L18;
  *(value *)(L17+2) = L15;
  Create(&L19,0,2);
  *(value *)(L19+1) = L13;
  *(value *)(L19+2) = L16;
  *P3 = L19;
  *P2 = L17;
  return 1;
LAB368:
  Manalyzer_P_code_join_STRUCTURE_OFFSET_TYPENR(L2,&L20,L5);
  L22 = G_analyzer_ORIGIN_NR3018;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L21,L5,L22);
  Create(&L23,27,3);
  Create(&L24,2,1);
  *(value *)(L24+1) = L20;
  *(value *)(L23+1) = L24;
  *(value *)(L23+2) = L5;
  Create(&L25,2,1);
  *(value *)(L25+1) = L21;
  *(value *)(L23+3) = L25;
  Mcode_P_store_INSTRUCTION(L23);
if(DecrRefs(L23)<0)
XD_Mcode_T14(L23);
  Manalyzer_P_register_assignment_OFFSET(L21);
  L26 = G_analyzer_USE_NR3019;
  Manalyzer_P_register_application_OFFSET_USE(L20,L26);
  Manalyzer_P_pre_evaluate_PARAMETERS_STRUCTURES_ADDRESSES_OFFSETS(L7,L3,&L27,&L28);
  Create(&L29,0,2);
  Create(&L30,2,1);
  *(value *)(L30+1) = L21;
  *(value *)(L29+1) = L30;
  *(value *)(L29+2) = L27;
  *P3 = L28;
  *P2 = L29;
  return 1;
LAB370:
  Abort(735, module_name);
LAB371:
  L31 = G_analyzer_ADDRESSES_NR3020;
  L32 = G_analyzer_OFFSETS_NR3021;
  *P3 = L32;
  ATTACH(L32);
  *P2 = L31;
  ATTACH(L31);
  return 1;
LAB373:
  Abort(739, module_name);
}

int Manalyzer_P_post_evaluate_PARAMETERS_STRUCTURES_ADDRESSES(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB1981:
  switch (Alternative(L1)) {
  case 0: goto LAB374;
  case 2: goto LAB395;
  default: goto LAB397;
  };
LAB374:
  L3 = (value)(L1[1]);
  L4 = (value)(L1[2]);
  switch (Alternative(L0)) {
  case 0: goto LAB377;
  default: goto LAB397;
  };
LAB377:
  L5 = (value)(L0[1]);
  L6 = (value)(L0[2]);
  L7 = (value)(L0[3]);
  L8 = (value)(L0[4]);
  switch (Alternative(L2)) {
  case 0: goto LAB380;
  default: goto LAB397;
  };
LAB380:
  L9 = (value)(L2[1]);
  L10 = (value)(L2[2]);
  switch (Alternative(L9)) {
  case 2: goto LAB383;
  default: goto LAB397;
  };
LAB383:
  L11 = (value)(L9[1]);
  switch (Alternative(L5)) {
  case 0: goto LAB386;
  case 1: goto LAB389;
  case 2: goto LAB392;
  default: goto LAB394;
  };
LAB386:
  L12 = G_analyzer_USE_NR3022;
  Manalyzer_P_register_application_OFFSET_USE(L11,L12);
  L2 = L10;
  L1 = L4;
  L0 = L8;
  goto LAB1981;
LAB389:
  Manalyzer_P_register_assignment_OFFSET(L11);
  Manalyzer_P_warn_split_STRUCTURE(L3);
  Manalyzer_P_code_split_ADDRESS_TYPENR_STRUCTURE(L9,L6,L3);
  L2 = L10;
  L1 = L4;
  L0 = L8;
  goto LAB1981;
LAB392:
  L13 = G_analyzer_USE_NR3023;
  Manalyzer_P_register_application_OFFSET_USE(L11,L13);
  Manalyzer_P_warn_split_STRUCTURE(L3);
  Manalyzer_P_code_split_ADDRESS_TYPENR_STRUCTURE(L9,L6,L3);
  L2 = L10;
  L1 = L4;
  L0 = L8;
  goto LAB1981;
LAB394:
  Abort(759, module_name);
LAB395:
  return 1;
LAB397:
  Abort(761, module_name);
}

int Manalyzer_P_match_EXPRESSION_TYPENR_STRUCTURE(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = C_INT(0);
  L5 = L0;
  L6 = L2;
LAB2716:
  switch (Alternative(L5)) {
  case 1: goto LAB2717;
  case 2: goto LAB2720;
  default: goto LAB2722;
  };
LAB2717:
  L7 = (value)(L5[1]);
  L8 = (value)(L5[2]);
  L9 = C_INT(1);
  L10 = C_INT(Int(L6) + Int(L9));
  L6 = L10;
  L5 = L8;
  goto LAB2716;
LAB2720:
  L3 = L6;
LAB2715:
  if (!Manalyzer_P_match_TYPENR_EXPRESSION_LENGTH_STRUCTURE(L1,L0,L3,&L4)) goto LAB398;
  *P2 = L4;
  return 1;
LAB2722:
  Abort(1417, module_name);
LAB398:
  return 0;
  return 0;
}

int Manalyzer_P_match_EXPRESSIONS_PARAMETERS_STRUCTURES(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1900:
  switch (Alternative(L1)) {
  case 0: goto LAB400;
  case 1: goto LAB422;
  case 2: goto LAB430;
  default: goto LAB432;
  };
LAB400:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  L4 = (value)(L1[3]);
  L5 = (value)(L1[4]);
  switch (Alternative(L0)) {
  case 0: goto LAB403;
  default: goto LAB432;
  };
LAB403:
  L6 = (value)(L0[1]);
  L7 = (value)(L0[2]);
  switch (Alternative(L6)) {
  case 0: goto LAB406;
  default: goto LAB408;
  };
LAB406:
  L8 = (value)(L6[1]);
  L9 = (value)(L6[2]);
  switch (Alternative(L2)) {
  case 2: goto LAB409;
  default: goto LAB411;
  };
LAB409:
  L10 = C_INT(0);
  L28 = L8;
  L29 = L10;
LAB1845:
  switch (Alternative(L28)) {
  case 1: goto LAB1846;
  case 2: goto LAB1849;
  default: goto LAB1851;
  };
LAB1846:
  L30 = (value)(L28[1]);
  L31 = (value)(L28[2]);
  L32 = C_INT(1);
  L33 = C_INT(Int(L29) + Int(L32));
  L29 = L33;
  L28 = L31;
  goto LAB1845;
LAB1849:
  L11 = L29;
LAB1844:
  L12 = C_INT(0);
  L35 = L9;
  L36 = L12;
LAB1853:
  switch (Alternative(L35)) {
  case 1: goto LAB1854;
  case 2: goto LAB1857;
  default: goto LAB1859;
  };
LAB1851:
  Abort(1417, module_name);
LAB1854:
  L37 = (value)(L35[1]);
  L38 = (value)(L35[2]);
  L39 = C_INT(1);
  L40 = C_INT(Int(L36) + Int(L39));
  L36 = L40;
  L35 = L38;
  goto LAB1853;
LAB1857:
  L13 = L36;
LAB1852:
  if (!Manalyzer_P_match_TYPENR_EXPRESSION_LENGTH_STRUCTURE(L3,L8,L11,&L14)) goto LAB412;
  if (!Manalyzer_P_match_TYPENR_EXPRESSION_LENGTH_STRUCTURE(L3,L9,L13,&L15)) goto LAB414;
  if (!Manalyzer_P_match_EXPRESSIONS_PARAMETERS_STRUCTURES(L7,L5,&L16)) goto LAB416;
  Create(&L17,0,2);
  Create(&L18,1,2);
  *(value *)(L18+1) = L14;
  *(value *)(L18+2) = L15;
  *(value *)(L17+1) = L18;
  *(value *)(L17+2) = L16;
  *P2 = L17;
  return 1;
LAB1859:
  Abort(1417, module_name);
LAB412:
  return 0;
LAB414:
if(DecrRefs(L14)<0)
XD_Manalyzer_T46(L14);
  return 0;
LAB416:
if(DecrRefs(L15)<0)
XD_Manalyzer_T46(L15);
if(DecrRefs(L14)<0)
XD_Manalyzer_T46(L14);
  return 0;
LAB411:
  return 0;
LAB408:
  L19 = C_INT(0);
  L42 = L6;
  L43 = L19;
LAB1893:
  switch (Alternative(L42)) {
  case 1: goto LAB1894;
  case 2: goto LAB1897;
  default: goto LAB1899;
  };
LAB1894:
  L44 = (value)(L42[1]);
  L45 = (value)(L42[2]);
  L46 = C_INT(1);
  L47 = C_INT(Int(L43) + Int(L46));
  L43 = L47;
  L42 = L45;
  goto LAB1893;
LAB1897:
  L20 = L43;
LAB1892:
  if (!Manalyzer_P_match_TYPENR_EXPRESSION_LENGTH_STRUCTURE(L3,L6,L20,&L21)) goto LAB418;
  if (!Manalyzer_P_match_EXPRESSIONS_PARAMETERS_STRUCTURES(L7,L5,&L22)) goto LAB420;
  Create(&L23,0,2);
  *(value *)(L23+1) = L21;
  *(value *)(L23+2) = L22;
  *P2 = L23;
  return 1;
LAB1899:
  Abort(1417, module_name);
LAB418:
  return 0;
LAB420:
if(DecrRefs(L21)<0)
XD_Manalyzer_T46(L21);
  return 0;
  return 0;
LAB422:
  L24 = (value)(L1[1]);
  switch (Alternative(L0)) {
  case 1: goto LAB425;
  default: goto LAB432;
  };
LAB425:
  L25 = (value)(L0[1]);
  L1 = L24;
  L0 = L25;
  goto LAB1900;
  return 0;
LAB430:
  switch (Alternative(L0)) {
  case 2: goto LAB433;
  default: goto LAB432;
  };
LAB433:
  L27 = G_analyzer_STRUCTURES_NR3024;
  *P2 = L27;
  ATTACH(L27);
  return 1;
LAB432:
  Abort(791, module_name);
}

int Manalyzer_P_can_join_EXPRESSION_VARIABLE(P0,P1)
value P0;
value P1;
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Manalyzer_P_variable_type_VARIABLE_TYPENR(L1,&L2);
  L3 = C_INT(0);
  L7 = L0;
  L8 = L3;
LAB2022:
  switch (Alternative(L7)) {
  case 1: goto LAB2023;
  case 2: goto LAB2026;
  default: goto LAB2028;
  };
LAB2023:
  L9 = (value)(L7[1]);
  L10 = (value)(L7[2]);
  L11 = C_INT(1);
  L12 = C_INT(Int(L8) + Int(L11));
  L8 = L12;
  L7 = L10;
  goto LAB2022;
LAB2026:
  L4 = L8;
LAB2021:
  if (!Manalyzer_P_match_TYPENR_EXPRESSION_LENGTH_STRUCTURE(L2,L0,L4,&L5)) goto LAB495;
  Manalyzer_P_code_join_STRUCTURE_OFFSET_TYPENR(L5,&L6,L2);
if(DecrRefs(L5)<0)
XD_Manalyzer_T46(L5);
  Manalyzer_P_store_OFFSET_VARIABLE_TYPENR(L6,L1,L2);
  return 1;
LAB2028:
  Abort(1417, module_name);
LAB495:
  return 0;
  return 0;
}

int Manalyzer_P_length_TYPEALTERNATIVE_LENGTH(P0,P1)
value P0;
value *P1;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1905:
  switch (Alternative(L0)) {
  case 0: goto LAB497;
  case 1: goto LAB500;
  case 2: goto LAB503;
  default: goto LAB505;
  };
LAB497:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L0 = L2;
  goto LAB1905;
LAB500:
  L4 = (value)(L0[1]);
  L5 = (value)(L0[2]);
  Manalyzer_P_length_TYPEALTERNATIVE_LENGTH(L5,&L6);
  L7 = C_INT(1);
  L8 = C_INT(Int(L6) + Int(L7));
  *P1 = L8;
  return 1;
LAB503:
  L9 = C_INT(0);
  *P1 = L9;
  return 1;
LAB505:
  Abort(847, module_name);
}

int Manalyzer_P_get_TYPE_ALTNR_TYPEALTERNATIVE(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1904:
  switch (Alternative(L0)) {
  case 0: goto LAB506;
  case 1: goto LAB512;
  case 2: goto LAB515;
  default: goto LAB517;
  };
LAB506:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  switch (Int(L1)) {
  case 0: goto LAB509;
  default: goto LAB511;
  };
LAB509:
  *P2 = L2;
  ATTACH(L2);
  return 1;
LAB511:
  L4 = C_INT(1);
  L5 = C_INT(Int(L1) - Int(L4));
  L1 = L5;
  L0 = L3;
  goto LAB1904;
LAB512:
  L7 = (value)(L0[1]);
  Mtypes_P_get_TYPENR_TYPE(L7,&L8);
  Manalyzer_P_get_TYPE_ALTNR_TYPEALTERNATIVE(L8,L1,&L9);
if(DecrRefs(L8)<0)
XD_Mtypes_T11(L8);
  *P2 = L9;
  return 1;
LAB515:
  L10 = G_analyzer_TYPEALTERNATIVE_NR3033;
  *P2 = L10;
  ATTACH(L10);
  return 1;
LAB517:
  Abort(858, module_name);
}

int Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(P0,P1,P2)
value *P0;
value P1;
value P2;
{
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P1;
  L1 = P2;
  L2 = (value)G_analyzer_MAX_OFFSET_NR5;
  L3 = (value) Addr((value*)&G_analyzer_OFFSET_TYPES_NR4,Int(L2));
  *((value *)L3) = L0;
  L4 = (value) Addr((value*)&G_analyzer_ORIGINS_NR17,Int(L2));
  ATTACH(L1);
if(DecrRefs(*((value*)L4))<0)
XD_Manalyzer_T65(*((value*)L4));
  *((value *)L4) = L1;
  L5 = G_analyzer_OFFSETS_NR3034;
  L6 = (value) Addr((value*)&G_analyzer_DEPENDS_NR18,Int(L2));
  ATTACH(L5);
if(DecrRefs(*((value*)L6))<0)
XD_Manalyzer_T68(*((value*)L6));
  *((value *)L6) = L5;
  L7 = G_analyzer_APPLICATIONS_NR3035;
  L8 = (value) Addr((value*)&G_analyzer_APPLICATIONS_NR19,Int(L2));
  ATTACH(L7);
if(DecrRefs(*((value*)L8))<0)
XD_Manalyzer_T20(*((value*)L8));
  *((value *)L8) = L7;
  Manalyzer_P_determine_creation_state_ORIGIN_NUM_LEFT(L1,&L9);
  L10 = (value) Addr((value*)&G_analyzer_AUTO_ATTACHED_NR21,Int(L2));
if(DecrRefs(*((value*)L10))<0)
XD_Manalyzer_T61(*((value*)L10));
  *((value *)L10) = L9;
  L11 = C_INT(-1);
  L12 = (value) Addr((value*)&G_analyzer_BIRTH_NR27,Int(L2));
  *((value *)L12) = L11;
  L13 = G_analyzer_DEATH_NR3036;
  L14 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L2));
  ATTACH(L13);
if(DecrRefs(*((value*)L14))<0)
XD_Manalyzer_T29(*((value*)L14));
  *((value *)L14) = L13;
  L15 = G_analyzer_ELEMENT_NR3037;
  L16 = (value) Addr((value*)&G_analyzer_ELEMENT_NR29,Int(L2));
  ATTACH(L15);
if(DecrRefs(*((value*)L16))<0)
XD_Manalyzer_T30(*((value*)L16));
  *((value *)L16) = L15;
  L17 = (value)G_analyzer_MAX_OFFSET_NR5;
  L18 = C_INT(1);
  L19 = C_INT(Int(L17) + Int(L18));
  G_analyzer_MAX_OFFSET_NR5 = (long)L19;
  *P0 = L2;
  return 1;
}

int Manalyzer_P_use_OFFSET(P0)
value P0;
{
  value L1;
  value L0;
  L0 = P0;
  L1 = G_analyzer_USE_NR3038;
  Manalyzer_P_register_application_OFFSET_USE(L0,L1);
  return 1;
}

int Manalyzer_P_store_VARIABLE_VARIABLE_TYPENR(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB2008:
  switch (Alternative(L0)) {
  case 2: goto LAB518;
  case 0: goto LAB523;
  default: goto LAB525;
  };
LAB518:
  L3 = (value)(L0[1]);
  if (!Mvariables_P_is_not_local_VARIABLENR(L3)) goto LAB522;
  Manalyzer_P_store_global_VARIABLE_VARIABLE_TYPENR(L0,L1,L2);
  return 1;
LAB522:
  Manalyzer_P_apply_VARIABLENR_OFFSET(L3,&L4);
  Manalyzer_P_store_OFFSET_VARIABLE_TYPENR(L4,L1,L2);
  return 1;
LAB523:
  L5 = (value)(L0[1]);
  L0 = L5;
  goto LAB2008;
LAB525:
  Manalyzer_P_store_global_VARIABLE_VARIABLE_TYPENR(L0,L1,L2);
  return 1;
}

int Manalyzer_P_store_global_VARIABLE_VARIABLE_TYPENR(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L1)) {
  case 2: goto LAB526;
  case 0: goto LAB531;
  default: goto LAB533;
  };
LAB526:
  L3 = (value)(L1[1]);
  if (!Mvariables_P_is_not_local_VARIABLENR(L3)) goto LAB530;
  Manalyzer_P_store_VARIABLE_OFFSET_TYPENR(L0,&L4,L2);
  Manalyzer_P_store_OFFSET_VARIABLE_TYPENR(L4,L1,L2);
  return 1;
LAB530:
  Manalyzer_P_store_VARIABLE_OFFSET_TYPENR(L0,&L5,L2);
  Manalyzer_P_define_VARIABLENR_OFFSET(L3,L5);
  return 1;
LAB531:
  L6 = (value)(L1[1]);
  Manalyzer_P_store_VARIABLE_VARIABLE_TYPENR(L0,L6,L2);
  return 1;
LAB533:
  Manalyzer_P_store_VARIABLE_OFFSET_TYPENR(L0,&L7,L2);
  Manalyzer_P_store_OFFSET_VARIABLE_TYPENR(L7,L1,L2);
  return 1;
}

int Manalyzer_P_store_VARIABLE_OFFSET_TYPENR(P0,P1,P2)
value P0;
value *P1;
value P2;
{
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P2;
LAB1923:
  switch (Alternative(L0)) {
  case 2: goto LAB534;
  case 3: goto LAB539;
  case 0: goto LAB544;
  case 1: goto LAB547;
  default: goto LAB549;
  };
LAB534:
  L2 = (value)(L0[1]);
  if (!Mvariables_P_is_not_local_VARIABLENR(L2)) goto LAB538;
  Manalyzer_P_apply_VARIABLENR_ADDRESS(L2,&L3);
  Create(&L5,8,1);
  *(value *)(L5+1) = L2;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L4,L1,L5);
if(DecrRefs(L5)<0)
XD_Manalyzer_T65(L5);
  Create(&L6,27,3);
  *(value *)(L6+1) = L3;
  *(value *)(L6+2) = L1;
  Create(&L7,2,1);
  *(value *)(L7+1) = L4;
  *(value *)(L6+3) = L7;
  Mcode_P_store_INSTRUCTION(L6);
if(DecrRefs(L6)<0)
XD_Mcode_T14(L6);
  Manalyzer_P_register_assignment_OFFSET(L4);
  *P1 = L4;
  return 1;
LAB538:
  Manalyzer_P_apply_VARIABLENR_OFFSET(L2,&L8);
  Manalyzer_P_use_OFFSET(L8);
  *P1 = L8;
  return 1;
LAB539:
  L9 = (value)(L0[1]);
  L10 = (value)(L0[2]);
  Mtypes_P_integer_type_TYPENR(&L11);
  Manalyzer_P_code_join_expression_SUBEXPRESSION_OFFSET_TYPENR(L10,&L12,L11);
  Manalyzer_P_apply_VARIABLENR_ADDRESS(L9,&L13);
  if (!Mcoder_P_optimize_array_references()) goto LAB543;
  Manalyzer_P_get_element_OFFSET_ADDRESS_OFFSET(L12,L13,&L14);
if(DecrRefs(L13)<0)
XD_Mcode_T20(L13);
  Create(&L16,8,1);
  *(value *)(L16+1) = L9;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L15,L1,L16);
if(DecrRefs(L16)<0)
XD_Manalyzer_T65(L16);
  Create(&L17,27,3);
  Create(&L18,13,1);
  *(value *)(L18+1) = L14;
  *(value *)(L17+1) = L18;
  *(value *)(L17+2) = L1;
  Create(&L19,2,1);
  *(value *)(L19+1) = L15;
  *(value *)(L17+3) = L19;
  Mcode_P_store_INSTRUCTION(L17);
if(DecrRefs(L17)<0)
XD_Mcode_T14(L17);
  L20 = G_analyzer_USE_NR3039;
  Manalyzer_P_register_application_OFFSET_USE(L14,L20);
  Manalyzer_P_register_assignment_OFFSET(L15);
  *P1 = L15;
  return 1;
LAB543:
  Create(&L21,26,3);
  Create(&L22,2,1);
  *(value *)(L22+1) = L12;
  *(value *)(L21+1) = L22;
  *(value *)(L21+2) = L13;
  L23 = C_INT(0);
  *(value *)(L21+3) = L23;
  Mcode_P_store_INSTRUCTION(L21);
if(DecrRefs(L21)<0)
XD_Mcode_T14(L21);
  L24 = G_analyzer_USE_NR3040;
  Manalyzer_P_register_application_OFFSET_USE(L12,L24);
  Create(&L26,8,1);
  *(value *)(L26+1) = L9;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L25,L1,L26);
if(DecrRefs(L26)<0)
XD_Manalyzer_T65(L26);
  Create(&L27,27,3);
  Create(&L28,13,1);
  L29 = C_INT(0);
  *(value *)(L28+1) = L29;
  *(value *)(L27+1) = L28;
  *(value *)(L27+2) = L1;
  Create(&L30,2,1);
  *(value *)(L30+1) = L25;
  *(value *)(L27+3) = L30;
  Mcode_P_store_INSTRUCTION(L27);
if(DecrRefs(L27)<0)
XD_Mcode_T14(L27);
  Manalyzer_P_register_assignment_OFFSET(L25);
  *P1 = L25;
  return 1;
LAB544:
  L31 = (value)(L0[1]);
  L0 = L31;
  goto LAB1923;
LAB547:
  L33 = (value)(L0[1]);
  L35 = G_analyzer_ORIGIN_NR3041;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L34,L33,L35);
  Create(&L36,6,2);
  L37 = G_analyzer_TEXT_NR3042;
  *(value *)(L36+1) = L37;
  ATTACH(L37);
  Create(&L38,2,2);
  *(value *)(L38+1) = L33;
  Create(&L39,11,1);
  L40 = G_analyzer_TEXT_NR3043;
  *(value *)(L39+1) = L40;
  ATTACH(L40);
  *(value *)(L38+2) = L39;
  *(value *)(L36+2) = L38;
  Manalyzer_P_semantic_error_MESSAGE(L36);
if(DecrRefs(L36)<0)
XD_Merrors_T3(L36);
  *P1 = L34;
  return 1;
LAB549:
  Abort(926, module_name);
}

int Manalyzer_P_get_element_OFFSET_ADDRESS_OFFSET(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = (value) Addr((value*)&G_analyzer_ELEMENT_NR29,Int(L0));
  L3 = *((value*)L2);
  ATTACH(L3);
  Manalyzer_P_get_element_OFFSET_ADDRESS_ELEMENT_OFFSET(L0,L1,L3,&L4);
if(DecrRefs(L3)<0)
XD_Manalyzer_T30(L3);
  *P2 = L4;
  return 1;
}

int Manalyzer_P_get_element_OFFSET_ADDRESS_ELEMENT_OFFSET(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB1922:
  switch (Alternative(L2)) {
  case 1: goto LAB550;
  case 0: goto LAB555;
  default: goto LAB557;
  };
LAB550:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L5 = (value)(L2[3]);
  if (!EQ_Mcode_T20(L3,L1)) goto LAB554;
  L6 = (value)G_analyzer_AREF_NR30;
  L7 = C_INT(1);
  L8 = C_INT(Int(L6) + Int(L7));
  G_analyzer_AREF_NR30 = (long)L8;
  *P3 = L4;
  return 1;
LAB554:
  L2 = L5;
  goto LAB1922;
LAB555:
  Mtypes_P_integer_type_TYPENR(&L10);
  L12 = G_analyzer_ORIGIN_NR3044;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L11,L10,L12);
  Create(&L13,26,3);
  Create(&L14,2,1);
  *(value *)(L14+1) = L0;
  *(value *)(L13+1) = L14;
  *(value *)(L13+2) = L1;
  ATTACH(L1);
  *(value *)(L13+3) = L11;
  Mcode_P_store_INSTRUCTION(L13);
if(DecrRefs(L13)<0)
XD_Mcode_T14(L13);
  Create(&L15,1,3);
  *(value *)(L15+1) = L1;
  ATTACH(L1);
  *(value *)(L15+2) = L11;
  L16 = (value) Addr((value*)&G_analyzer_ELEMENT_NR29,Int(L0));
  L17 = *((value*)L16);
  ATTACH(L17);
  *(value *)(L15+3) = L17;
if(DecrRefs(*((value*)L16))<0)
XD_Manalyzer_T30(*((value*)L16));
  *((value *)L16) = L15;
  L18 = G_analyzer_USE_NR3045;
  Manalyzer_P_register_application_OFFSET_USE(L0,L18);
  Manalyzer_P_register_assignment_OFFSET(L11);
  L19 = (value)G_analyzer_TREF_NR31;
  L20 = C_INT(1);
  L21 = C_INT(Int(L19) + Int(L20));
  G_analyzer_TREF_NR31 = (long)L21;
  *P3 = L11;
  return 1;
LAB557:
  Abort(948, module_name);
}

int Manalyzer_P_store_OFFSET_VARIABLE_TYPENR(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  Create(&L3,2,1);
  *(value *)(L3+1) = L0;
  Manalyzer_P_store_ADDRESS_VARIABLE_TYPENR(L3,L1,L2);
if(DecrRefs(L3)<0)
XD_Mcode_T20(L3);
  return 1;
}

int Manalyzer_P_store_ADDRESS_VARIABLE_TYPENR(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB1979:
  switch (Alternative(L1)) {
  case 2: goto LAB558;
  case 3: goto LAB566;
  case 0: goto LAB571;
  case 1: goto LAB574;
  default: goto LAB576;
  };
LAB558:
  L3 = (value)(L1[1]);
  if (!Mvariables_P_is_not_local_VARIABLENR(L3)) goto LAB562;
  L4 = G_analyzer_BOOLEAN_NR3046;
  ATTACH(L4);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L4;
  Manalyzer_P_apply_VARIABLENR_ADDRESS(L3,&L5);
  Create(&L6,27,3);
  *(value *)(L6+1) = L0;
  ATTACH(L0);
  *(value *)(L6+2) = L2;
  *(value *)(L6+3) = L5;
  ATTACH(L5);
  Mcode_P_store_INSTRUCTION(L6);
if(DecrRefs(L6)<0)
XD_Mcode_T14(L6);
  Create(&L7,3,2);
  *(value *)(L7+1) = L5;
  *(value *)(L7+2) = L2;
  Manalyzer_P_register_application_ADDRESS_USE(L0,L7);
if(DecrRefs(L7)<0)
XD_Manalyzer_T67(L7);
  return 1;
LAB562:
  switch (Alternative(L0)) {
  case 2: goto LAB563;
  default: goto LAB565;
  };
LAB563:
  L8 = (value)(L0[1]);
  Manalyzer_P_define_VARIABLENR_OFFSET(L3,L8);
  return 1;
LAB565:
  L10 = G_analyzer_ORIGIN_NR3047;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L9,L2,L10);
  Create(&L11,27,3);
  *(value *)(L11+1) = L0;
  ATTACH(L0);
  *(value *)(L11+2) = L2;
  Create(&L12,2,1);
  *(value *)(L12+1) = L9;
  *(value *)(L11+3) = L12;
  Mcode_P_store_INSTRUCTION(L11);
if(DecrRefs(L11)<0)
XD_Mcode_T14(L11);
  Manalyzer_P_register_dependancy_OFFSET_ADDRESS(L9,L0);
  Manalyzer_P_register_assignment_OFFSET(L9);
  Create(&L13,0,1);
  L14 = C_INT(8);
  *(value *)(L13+1) = L14;
  Manalyzer_P_register_application_ADDRESS_USE(L0,L13);
if(DecrRefs(L13)<0)
XD_Manalyzer_T67(L13);
  Manalyzer_P_define_VARIABLENR_OFFSET(L3,L9);
  return 1;
LAB566:
  L15 = (value)(L1[1]);
  L16 = (value)(L1[2]);
  L17 = G_analyzer_BOOLEAN_NR3048;
  ATTACH(L17);
if(DecrRefs(G_analyzer_HAS_EFFECT_NR12)<0)
XD_Manalyzer_T62(G_analyzer_HAS_EFFECT_NR12);
  G_analyzer_HAS_EFFECT_NR12 = L17;
  Mtypes_P_integer_type_TYPENR(&L18);
  Manalyzer_P_code_join_expression_SUBEXPRESSION_OFFSET_TYPENR(L16,&L19,L18);
  Manalyzer_P_apply_VARIABLENR_ADDRESS(L15,&L20);
  if (!Mcoder_P_optimize_array_references()) goto LAB570;
  Manalyzer_P_get_element_OFFSET_ADDRESS_OFFSET(L19,L20,&L21);
if(DecrRefs(L20)<0)
XD_Mcode_T20(L20);
  Create(&L22,27,3);
  *(value *)(L22+1) = L0;
  ATTACH(L0);
  *(value *)(L22+2) = L2;
  Create(&L23,13,1);
  *(value *)(L23+1) = L21;
  *(value *)(L22+3) = L23;
  Mcode_P_store_INSTRUCTION(L22);
if(DecrRefs(L22)<0)
XD_Mcode_T14(L22);
  L24 = G_analyzer_USE_NR3049;
  Manalyzer_P_register_application_OFFSET_USE(L21,L24);
  Create(&L25,3,2);
  Create(&L26,13,1);
  *(value *)(L26+1) = L21;
  *(value *)(L25+1) = L26;
  *(value *)(L25+2) = L2;
  Manalyzer_P_register_application_ADDRESS_USE(L0,L25);
if(DecrRefs(L25)<0)
XD_Manalyzer_T67(L25);
  return 1;
LAB570:
  Create(&L27,26,3);
  Create(&L28,2,1);
  *(value *)(L28+1) = L19;
  *(value *)(L27+1) = L28;
  *(value *)(L27+2) = L20;
  L29 = C_INT(0);
  *(value *)(L27+3) = L29;
  Mcode_P_store_INSTRUCTION(L27);
if(DecrRefs(L27)<0)
XD_Mcode_T14(L27);
  L30 = G_analyzer_USE_NR3050;
  Manalyzer_P_register_application_OFFSET_USE(L19,L30);
  Create(&L31,27,3);
  *(value *)(L31+1) = L0;
  ATTACH(L0);
  *(value *)(L31+2) = L2;
  Create(&L32,13,1);
  L33 = C_INT(0);
  *(value *)(L32+1) = L33;
  *(value *)(L31+3) = L32;
  Mcode_P_store_INSTRUCTION(L31);
if(DecrRefs(L31)<0)
XD_Mcode_T14(L31);
  Create(&L34,3,2);
  Create(&L35,13,1);
  L36 = C_INT(0);
  *(value *)(L35+1) = L36;
  *(value *)(L34+1) = L35;
  *(value *)(L34+2) = L2;
  Manalyzer_P_register_application_ADDRESS_USE(L0,L34);
if(DecrRefs(L34)<0)
XD_Manalyzer_T67(L34);
  return 1;
LAB571:
  L37 = (value)(L1[1]);
  L1 = L37;
  goto LAB1979;
LAB574:
  L38 = (value)(L1[1]);
  return 1;
LAB576:
  Abort(986, module_name);
}

int Manalyzer_P_convert_VARIABLE_TYPENR_OFFSET(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB2020:
  switch (Alternative(L0)) {
  case 2: goto LAB577;
  case 3: goto LAB582;
  case 0: goto LAB587;
  case 1: goto LAB590;
  default: goto LAB592;
  };
LAB577:
  L2 = (value)(L0[1]);
  if (!Mvariables_P_is_not_local_VARIABLENR(L2)) goto LAB581;
  Manalyzer_P_apply_VARIABLENR_ADDRESS(L2,&L3);
  Create(&L5,8,1);
  *(value *)(L5+1) = L2;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L4,L1,L5);
if(DecrRefs(L5)<0)
XD_Manalyzer_T65(L5);
  Create(&L6,27,3);
  *(value *)(L6+1) = L3;
  *(value *)(L6+2) = L1;
  Create(&L7,2,1);
  *(value *)(L7+1) = L4;
  *(value *)(L6+3) = L7;
  Mcode_P_store_INSTRUCTION(L6);
if(DecrRefs(L6)<0)
XD_Mcode_T14(L6);
  Manalyzer_P_register_assignment_OFFSET(L4);
  *P2 = L4;
  return 1;
LAB581:
  Manalyzer_P_apply_VARIABLENR_OFFSET(L2,&L8);
  Manalyzer_P_use_OFFSET(L8);
  *P2 = L8;
  return 1;
LAB582:
  L9 = (value)(L0[1]);
  L10 = (value)(L0[2]);
  Mtypes_P_integer_type_TYPENR(&L11);
  Manalyzer_P_code_join_expression_SUBEXPRESSION_OFFSET_TYPENR(L10,&L12,L11);
  Manalyzer_P_apply_VARIABLENR_ADDRESS(L9,&L13);
  if (!Mcoder_P_optimize_array_references()) goto LAB586;
  Manalyzer_P_get_element_OFFSET_ADDRESS_OFFSET(L12,L13,&L14);
if(DecrRefs(L13)<0)
XD_Mcode_T20(L13);
  Create(&L16,8,1);
  *(value *)(L16+1) = L9;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L15,L1,L16);
if(DecrRefs(L16)<0)
XD_Manalyzer_T65(L16);
  Create(&L17,27,3);
  Create(&L18,13,1);
  *(value *)(L18+1) = L14;
  *(value *)(L17+1) = L18;
  *(value *)(L17+2) = L1;
  Create(&L19,2,1);
  *(value *)(L19+1) = L15;
  *(value *)(L17+3) = L19;
  Mcode_P_store_INSTRUCTION(L17);
if(DecrRefs(L17)<0)
XD_Mcode_T14(L17);
  L20 = G_analyzer_USE_NR3051;
  Manalyzer_P_register_application_OFFSET_USE(L14,L20);
  Manalyzer_P_register_assignment_OFFSET(L15);
  *P2 = L15;
  return 1;
LAB586:
  Create(&L21,26,3);
  Create(&L22,2,1);
  *(value *)(L22+1) = L12;
  *(value *)(L21+1) = L22;
  *(value *)(L21+2) = L13;
  L23 = C_INT(0);
  *(value *)(L21+3) = L23;
  Mcode_P_store_INSTRUCTION(L21);
if(DecrRefs(L21)<0)
XD_Mcode_T14(L21);
  L24 = G_analyzer_USE_NR3052;
  Manalyzer_P_register_application_OFFSET_USE(L12,L24);
  Create(&L26,8,1);
  *(value *)(L26+1) = L9;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L25,L1,L26);
if(DecrRefs(L26)<0)
XD_Manalyzer_T65(L26);
  Create(&L27,27,3);
  Create(&L28,13,1);
  L29 = C_INT(0);
  *(value *)(L28+1) = L29;
  *(value *)(L27+1) = L28;
  *(value *)(L27+2) = L1;
  Create(&L30,2,1);
  *(value *)(L30+1) = L25;
  *(value *)(L27+3) = L30;
  Mcode_P_store_INSTRUCTION(L27);
if(DecrRefs(L27)<0)
XD_Mcode_T14(L27);
  Manalyzer_P_register_assignment_OFFSET(L25);
  *P2 = L25;
  return 1;
LAB587:
  L31 = (value)(L0[1]);
  L0 = L31;
  goto LAB2020;
LAB590:
  L33 = (value)(L0[1]);
  L35 = G_analyzer_ORIGIN_NR3053;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L34,L33,L35);
  Create(&L36,6,2);
  L37 = G_analyzer_TEXT_NR3054;
  *(value *)(L36+1) = L37;
  ATTACH(L37);
  Create(&L38,2,2);
  *(value *)(L38+1) = L33;
  Create(&L39,11,1);
  L40 = G_analyzer_TEXT_NR3055;
  *(value *)(L39+1) = L40;
  ATTACH(L40);
  *(value *)(L38+2) = L39;
  *(value *)(L36+2) = L38;
  Manalyzer_P_semantic_error_MESSAGE(L36);
if(DecrRefs(L36)<0)
XD_Merrors_T3(L36);
  *P2 = L34;
  return 1;
LAB592:
  Abort(1017, module_name);
}

int Manalyzer_P_apply_VARIABLENR_ADDRESS(P0,P1)
value P0;
value *P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  if (!Mvariables_P_is_not_local_VARIABLENR(L0)) goto LAB594;
  if (!Mvariables_P_is_constant_VARIABLENR_VALUE(L0,&L1)) goto LAB596;
if(DecrRefs(L1)<0)
XD_Mvariables_T12(L1);
  Create(&L2,7,1);
  *(value *)(L2+1) = L0;
  *P1 = L2;
  return 1;
LAB596:
  Create(&L3,8,1);
  *(value *)(L3+1) = L0;
  *P1 = L3;
  return 1;
LAB594:
  Manalyzer_P_apply_VARIABLENR_OFFSET(L0,&L4);
  Create(&L5,2,1);
  *(value *)(L5+1) = L4;
  *P1 = L5;
  return 1;
}

int Manalyzer_P_code_join_STRUCTURE_OFFSET_TYPENR(P0,P1,P2)
value P0;
value *P1;
value P2;
{
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P2;
LAB1925:
  switch (Alternative(L0)) {
  case 1: goto LAB597;
  default: goto LAB599;
  };
LAB597:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  L0 = L2;
  goto LAB1925;
LAB599:
  Mtypes_P_same_TYPENR_TYPENR(L1,&L5);
  Mtypes_P_get_TYPENR_TYPE(L5,&L6);
  switch (Alternative(L0)) {
  case 5: goto LAB600;
  case 6: goto LAB603;
  default: goto LAB605;
  };
LAB600:
  L7 = (value)(L0[1]);
  L8 = C_INT(0);
  Manalyzer_P_get_TYPE_ALTNR_TYPEALTERNATIVE(L6,L8,&L9);
if(DecrRefs(L6)<0)
XD_Mtypes_T11(L6);
  Manalyzer_P_length_TYPEALTERNATIVE_LENGTH(L9,&L10);
  L12 = G_analyzer_ORIGIN_NR3056;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L11,L5,L12);
  Create(&L13,31,4);
  Create(&L14,2,1);
  *(value *)(L14+1) = L11;
  *(value *)(L13+1) = L14;
  *(value *)(L13+2) = L5;
  L15 = C_INT(0);
  *(value *)(L13+3) = L15;
  *(value *)(L13+4) = L10;
  Mcode_P_store_INSTRUCTION(L13);
if(DecrRefs(L13)<0)
XD_Mcode_T14(L13);
  Manalyzer_P_register_assignment_OFFSET(L11);
  Create(&L16,2,1);
  *(value *)(L16+1) = L11;
  L17 = C_INT(1);
  Manalyzer_P_code_join_ADDRESS_INT_TYPEALTERNATIVE_STRUCTURE(L16,L17,L9,L7);
if(DecrRefs(L16)<0)
XD_Mcode_T20(L16);
if(DecrRefs(L9)<0)
XD_Mtypes_T15(L9);
  *P1 = L11;
  return 1;
LAB603:
  L18 = (value)(L0[1]);
  L19 = (value)(L0[2]);
  switch (Alternative(L19)) {
  case 0: goto LAB606;
  default: goto LAB608;
  };
LAB606:
if(DecrRefs(L6)<0)
XD_Mtypes_T11(L6);
  L20 = (value)G_analyzer_CURRENT_MODULENR_NR6;
  Create(&L21,1,1);
  *(value *)(L21+1) = L18;
  Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR(L20,L5,L21,&L22);
if(DecrRefs(L21)<0)
XD_Mvariables_T12(L21);
  Manalyzer_P_apply_VARIABLENR_ADDRESS(L22,&L23);
  L25 = G_analyzer_ORIGIN_NR3057;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L24,L5,L25);
  Create(&L26,27,3);
  *(value *)(L26+1) = L23;
  *(value *)(L26+2) = L5;
  Create(&L27,2,1);
  *(value *)(L27+1) = L24;
  *(value *)(L26+3) = L27;
  Mcode_P_store_INSTRUCTION(L26);
if(DecrRefs(L26)<0)
XD_Mcode_T14(L26);
  Manalyzer_P_register_assignment_OFFSET(L24);
  *P1 = L24;
  return 1;
LAB608:
  Manalyzer_P_get_TYPE_ALTNR_TYPEALTERNATIVE(L6,L18,&L28);
if(DecrRefs(L6)<0)
XD_Mtypes_T11(L6);
  Manalyzer_P_length_TYPEALTERNATIVE_LENGTH(L28,&L29);
  L31 = G_analyzer_ORIGIN_NR3058;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L30,L5,L31);
  Create(&L32,31,4);
  Create(&L33,2,1);
  *(value *)(L33+1) = L30;
  *(value *)(L32+1) = L33;
  *(value *)(L32+2) = L5;
  *(value *)(L32+3) = L18;
  *(value *)(L32+4) = L29;
  Mcode_P_store_INSTRUCTION(L32);
if(DecrRefs(L32)<0)
XD_Mcode_T14(L32);
  Manalyzer_P_register_assignment_OFFSET(L30);
  Create(&L34,2,1);
  *(value *)(L34+1) = L30;
  L35 = C_INT(1);
  Manalyzer_P_code_join_ADDRESS_INT_TYPEALTERNATIVE_STRUCTURE(L34,L35,L28,L19);
if(DecrRefs(L34)<0)
XD_Mcode_T20(L34);
if(DecrRefs(L28)<0)
XD_Mtypes_T15(L28);
  *P1 = L30;
  return 1;
LAB605:
if(DecrRefs(L6)<0)
XD_Mtypes_T11(L6);
  switch (Alternative(L0)) {
  case 2: goto LAB609;
  case 3: goto LAB612;
  case 0: goto LAB615;
  case 4: goto LAB618;
  default: goto LAB620;
  };
LAB609:
  L36 = (value)(L0[1]);
  Manalyzer_P_code_join_expression_SUBEXPRESSION_OFFSET_TYPENR(L36,&L37,L5);
  *P1 = L37;
  return 1;
LAB612:
  L38 = (value)(L0[1]);
  L39 = (value)(L0[2]);
  L41 = G_analyzer_ORIGIN_NR3059;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L40,L5,L41);
  Manalyzer_P_code_join_STRUCTURE_OFFSET_TYPENR(L38,&L42,L5);
  Manalyzer_P_code_join_STRUCTURE_OFFSET_TYPENR(L39,&L43,L5);
  Create(&L44,23,3);
  Create(&L45,2,1);
  *(value *)(L45+1) = L42;
  *(value *)(L44+1) = L45;
  Create(&L46,2,1);
  *(value *)(L46+1) = L43;
  *(value *)(L44+2) = L46;
  Create(&L47,2,1);
  *(value *)(L47+1) = L40;
  *(value *)(L44+3) = L47;
  Mcode_P_store_INSTRUCTION(L44);
if(DecrRefs(L44)<0)
XD_Mcode_T14(L44);
  L48 = G_analyzer_USE_NR3060;
  Manalyzer_P_register_application_OFFSET_USE(L42,L48);
  L49 = G_analyzer_USE_NR3061;
  Manalyzer_P_register_application_OFFSET_USE(L43,L49);
  Manalyzer_P_register_assignment_OFFSET(L40);
  *P1 = L40;
  return 1;
LAB615:
  Abort(1063, module_name);
LAB618:
  L50 = (value)(L0[1]);
  L51 = (value)(L0[2]);
  switch (Alternative(L51)) {
  case 0: goto LAB621;
  default: goto LAB623;
  };
LAB621:
  L1 = L5;
  L0 = L50;
  goto LAB1925;
LAB623:
  Abort(1067, module_name);
LAB620:
  Abort(1068, module_name);
}

int Manalyzer_P_warn_split_STRUCTURE(P0)
value P0;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1977:
  switch (Alternative(L0)) {
  case 1: goto LAB624;
  case 2: goto LAB627;
  case 0: goto LAB633;
  case 4: goto LAB636;
  default: goto LAB638;
  };
LAB624:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L0 = L2;
  goto LAB1977;
LAB627:
  L3 = (value)(L0[1]);
  switch (Alternative(L3)) {
  case 3: goto LAB630;
  default: goto LAB638;
  };
LAB630:
  L4 = (value)(L3[1]);
  return 1;
LAB633:
  return 1;
LAB636:
  L5 = (value)(L0[1]);
  L6 = (value)(L0[2]);
  switch (Alternative(L6)) {
  case 0: goto LAB639;
  default: goto LAB638;
  };
LAB639:
  L0 = L5;
  goto LAB1977;
LAB638:
  L9 = G_analyzer_WARN_NR26;
  switch (Alternative(L9)) {
  case 0: goto LAB1973;
  default: goto LAB643;
  };
LAB1973:
  Create(&L7,11,1);
  L8 = G_analyzer_TEXT_NR3062;
  *(value *)(L7+1) = L8;
  ATTACH(L8);
  Manalyzer_P_warn_MESSAGE(L7);
if(DecrRefs(L7)<0)
XD_Merrors_T3(L7);
  return 1;
LAB643:
  return 1;
}

int Manalyzer_P_code_split_ADDRESS_TYPENR_STRUCTURE(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB1980:
  switch (Alternative(L2)) {
  case 1: goto LAB644;
  default: goto LAB646;
  };
LAB644:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  L2 = L4;
  goto LAB1980;
LAB646:
  Mtypes_P_same_TYPENR_TYPENR(L1,&L5);
  Mtypes_P_get_TYPENR_TYPE(L5,&L6);
  switch (Alternative(L2)) {
  case 5: goto LAB647;
  case 6: goto LAB650;
  default: goto LAB652;
  };
LAB647:
  L7 = (value)(L2[1]);
  L8 = C_INT(0);
  Manalyzer_P_get_TYPE_ALTNR_TYPEALTERNATIVE(L6,L8,&L9);
if(DecrRefs(L6)<0)
XD_Mtypes_T11(L6);
  L10 = C_INT(1);
  Manalyzer_P_code_split_ADDRESS_INT_TYPEALTERNATIVE_STRUCTURE(L0,L10,L9,L7);
if(DecrRefs(L9)<0)
XD_Mtypes_T15(L9);
  return 1;
LAB650:
  L11 = (value)(L2[1]);
  L12 = (value)(L2[2]);
  L13 = G_analyzer_BOOLEAN_NR3063;
  ATTACH(L13);
if(DecrRefs(G_analyzer_CANFAIL_NR10)<0)
XD_Manalyzer_T62(G_analyzer_CANFAIL_NR10);
  G_analyzer_CANFAIL_NR10 = L13;
  Manalyzer_P_check_defect();
  Mcode_P_new_LABEL(&L14);
  Mcode_P_new_LABEL(&L15);
  Create(&L16,0,3);
  *(value *)(L16+1) = L11;
  *(value *)(L16+2) = L14;
  Create(&L17,1,1);
  *(value *)(L17+1) = L15;
  *(value *)(L16+3) = L17;
  Create(&L18,30,3);
  Create(&L19,11,1);
  *(value *)(L19+1) = L0;
  ATTACH(L0);
  *(value *)(L18+1) = L19;
  *(value *)(L18+2) = L5;
  *(value *)(L18+3) = L16;
  Mcode_P_store_INSTRUCTION(L18);
if(DecrRefs(L18)<0)
XD_Mcode_T14(L18);
  Mcode_P_current_LOCATION(&L20);
  Create(&L21,1,1);
  *(value *)(L21+1) = L14;
  Mcode_P_store_INSTRUCTION(L21);
if(DecrRefs(L21)<0)
XD_Mcode_T14(L21);
  Mcode_P_register_label_LABEL(L14);
  Mcode_P_register_goto_LABEL_LOCATION(L14,L20);
  Mcode_P_current_LOCATION(&L22);
  Manalyzer_P_code_cleanup_LABEL_LOCATION(L15,&L23);
  Mcode_P_register_goto_LABEL_LOCATION(L15,L20);
  Manalyzer_P_split_control_flow_LOCATION_LOCATION(L23,L22);
  L24 = G_analyzer_USE_NR3064;
  Manalyzer_P_register_application_ADDRESS_USE(L0,L24);
  switch (Alternative(L12)) {
  case 0: goto LAB653;
  default: goto LAB655;
  };
LAB653:
if(DecrRefs(L6)<0)
XD_Mtypes_T11(L6);
  return 1;
LAB655:
  Manalyzer_P_get_TYPE_ALTNR_TYPEALTERNATIVE(L6,L11,&L25);
if(DecrRefs(L6)<0)
XD_Mtypes_T11(L6);
  L26 = C_INT(1);
  Manalyzer_P_code_split_ADDRESS_INT_TYPEALTERNATIVE_STRUCTURE(L0,L26,L25,L12);
if(DecrRefs(L25)<0)
XD_Mtypes_T15(L25);
  return 1;
LAB652:
if(DecrRefs(L6)<0)
XD_Mtypes_T11(L6);
  switch (Alternative(L2)) {
  case 2: goto LAB656;
  case 3: goto LAB665;
  case 0: goto LAB668;
  case 4: goto LAB671;
  default: goto LAB673;
  };
LAB656:
  L27 = (value)(L2[1]);
  switch (Alternative(L27)) {
  case 3: goto LAB659;
  case 5: goto LAB662;
  default: goto LAB664;
  };
LAB659:
  L28 = (value)(L27[1]);
  Manalyzer_P_store_ADDRESS_VARIABLE_TYPENR(L0,L28,L5);
  return 1;
LAB662:
  L29 = (value)(L27[1]);
  L30 = G_analyzer_BOOLEAN_NR3065;
  ATTACH(L30);
if(DecrRefs(G_analyzer_CANFAIL_NR10)<0)
XD_Manalyzer_T62(G_analyzer_CANFAIL_NR10);
  G_analyzer_CANFAIL_NR10 = L30;
  Manalyzer_P_check_defect();
  Mcode_P_new_LABEL(&L31);
  Mcode_P_new_LABEL(&L32);
  Create(&L33,0,3);
  *(value *)(L33+1) = L29;
  *(value *)(L33+2) = L31;
  Create(&L34,1,1);
  *(value *)(L34+1) = L32;
  *(value *)(L33+3) = L34;
  Create(&L35,30,3);
  *(value *)(L35+1) = L0;
  ATTACH(L0);
  *(value *)(L35+2) = L5;
  *(value *)(L35+3) = L33;
  Mcode_P_store_INSTRUCTION(L35);
if(DecrRefs(L35)<0)
XD_Mcode_T14(L35);
  Mcode_P_current_LOCATION(&L36);
  Create(&L37,1,1);
  *(value *)(L37+1) = L31;
  Mcode_P_store_INSTRUCTION(L37);
if(DecrRefs(L37)<0)
XD_Mcode_T14(L37);
  Mcode_P_register_label_LABEL(L31);
  Mcode_P_register_goto_LABEL_LOCATION(L31,L36);
  Mcode_P_current_LOCATION(&L38);
  Manalyzer_P_code_cleanup_LABEL_LOCATION(L32,&L39);
  Mcode_P_register_goto_LABEL_LOCATION(L32,L36);
  Manalyzer_P_split_control_flow_LOCATION_LOCATION(L39,L38);
  L40 = G_analyzer_USE_NR3066;
  Manalyzer_P_register_application_ADDRESS_USE(L0,L40);
  return 1;
LAB664:
  Manalyzer_P_code_join_expression_SUBEXPRESSION_OFFSET_TYPENR(L27,&L41,L5);
  L42 = G_analyzer_BOOLEAN_NR3067;
  ATTACH(L42);
if(DecrRefs(G_analyzer_CANFAIL_NR10)<0)
XD_Manalyzer_T62(G_analyzer_CANFAIL_NR10);
  G_analyzer_CANFAIL_NR10 = L42;
  Manalyzer_P_check_defect();
  Mcode_P_new_LABEL(&L43);
  Create(&L44,29,4);
  *(value *)(L44+1) = L0;
  ATTACH(L0);
  *(value *)(L44+2) = L5;
  Create(&L45,2,1);
  *(value *)(L45+1) = L41;
  *(value *)(L44+3) = L45;
  *(value *)(L44+4) = L43;
  Mcode_P_store_INSTRUCTION(L44);
if(DecrRefs(L44)<0)
XD_Mcode_T14(L44);
  Mcode_P_current_LOCATION(&L46);
  L47 = G_analyzer_USE_NR3068;
  Manalyzer_P_register_application_ADDRESS_USE(L0,L47);
  L48 = G_analyzer_USE_NR3069;
  Manalyzer_P_register_application_OFFSET_USE(L41,L48);
  Manalyzer_P_code_cleanup_LABEL_LOCATION(L43,&L49);
  Mcode_P_register_goto_LABEL_LOCATION(L43,L46);
  Manalyzer_P_split_control_flow_LOCATION_LOCATION(L49,L46);
  return 1;
LAB665:
  L50 = (value)(L2[1]);
  L51 = (value)(L2[2]);
  Manalyzer_P_code_join_STRUCTURE_OFFSET_TYPENR(L2,&L52,L5);
  L53 = G_analyzer_BOOLEAN_NR3070;
  ATTACH(L53);
if(DecrRefs(G_analyzer_CANFAIL_NR10)<0)
XD_Manalyzer_T62(G_analyzer_CANFAIL_NR10);
  G_analyzer_CANFAIL_NR10 = L53;
  Manalyzer_P_check_defect();
  Mcode_P_new_LABEL(&L54);
  Create(&L55,29,4);
  *(value *)(L55+1) = L0;
  ATTACH(L0);
  *(value *)(L55+2) = L5;
  Create(&L56,2,1);
  *(value *)(L56+1) = L52;
  *(value *)(L55+3) = L56;
  *(value *)(L55+4) = L54;
  Mcode_P_store_INSTRUCTION(L55);
if(DecrRefs(L55)<0)
XD_Mcode_T14(L55);
  Mcode_P_current_LOCATION(&L57);
  L58 = G_analyzer_USE_NR3071;
  Manalyzer_P_register_application_ADDRESS_USE(L0,L58);
  L59 = G_analyzer_USE_NR3072;
  Manalyzer_P_register_application_OFFSET_USE(L52,L59);
  Manalyzer_P_code_cleanup_LABEL_LOCATION(L54,&L60);
  Mcode_P_register_goto_LABEL_LOCATION(L54,L57);
  Manalyzer_P_split_control_flow_LOCATION_LOCATION(L60,L57);
  return 1;
LAB668:
  return 1;
LAB671:
  L61 = (value)(L2[1]);
  L62 = (value)(L2[2]);
  switch (Alternative(L62)) {
  case 0: goto LAB674;
  default: goto LAB673;
  };
LAB674:
  L2 = L61;
  L1 = L5;
  goto LAB1980;
LAB673:
  Abort(1155, module_name);
}

int Manalyzer_P_code_join_expression_SUBEXPRESSION_OFFSET_TYPENR(P0,P1,P2)
value P0;
value *P1;
value P2;
{
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P2;
LAB1924:
  switch (Alternative(L0)) {
  case 0: goto LAB677;
  case 1: goto LAB689;
  case 3: goto LAB692;
  case 5: goto LAB695;
  case 6: goto LAB698;
  case 2: goto LAB701;
  default: goto LAB703;
  };
LAB677:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  switch (Alternative(L3)) {
  case 5: goto LAB680;
  default: goto LAB682;
  };
LAB680:
  L4 = (value)(L3[1]);
  L6 = G_analyzer_ORIGIN_NR3073;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L5,L1,L6);
  switch (Alternative(L2)) {
  case 0: goto LAB683;
  case 1: goto LAB686;
  default: goto LAB688;
  };
LAB683:
  Create(&L7,27,3);
  Create(&L8,9,1);
  L9 = C_INT( - Int(L4));
  *(value *)(L8+1) = L9;
  *(value *)(L7+1) = L8;
  *(value *)(L7+2) = L1;
  Create(&L10,2,1);
  *(value *)(L10+1) = L5;
  *(value *)(L7+3) = L10;
  Mcode_P_store_INSTRUCTION(L7);
if(DecrRefs(L7)<0)
XD_Mcode_T14(L7);
  Manalyzer_P_register_assignment_OFFSET(L5);
  *P1 = L5;
  return 1;
LAB686:
  Create(&L11,27,3);
  Create(&L12,9,1);
  L13 = C_INT( ~ Int(L4));
  *(value *)(L12+1) = L13;
  *(value *)(L11+1) = L12;
  *(value *)(L11+2) = L1;
  Create(&L14,2,1);
  *(value *)(L14+1) = L5;
  *(value *)(L11+3) = L14;
  Mcode_P_store_INSTRUCTION(L11);
if(DecrRefs(L11)<0)
XD_Mcode_T14(L11);
  Manalyzer_P_register_assignment_OFFSET(L5);
  *P1 = L5;
  return 1;
LAB688:
  Abort(1167, module_name);
LAB682:
  Manalyzer_P_code_join_expression_SUBEXPRESSION_OFFSET_TYPENR(L3,&L15,L1);
  L17 = G_analyzer_ORIGIN_NR3074;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L16,L1,L17);
  Create(&L18,25,3);
  *(value *)(L18+1) = L2;
  ATTACH(L2);
  Create(&L19,2,1);
  *(value *)(L19+1) = L15;
  *(value *)(L18+2) = L19;
  Create(&L20,2,1);
  *(value *)(L20+1) = L16;
  *(value *)(L18+3) = L20;
  Mcode_P_store_INSTRUCTION(L18);
if(DecrRefs(L18)<0)
XD_Mcode_T14(L18);
  L21 = G_analyzer_USE_NR3075;
  Manalyzer_P_register_application_OFFSET_USE(L15,L21);
  Manalyzer_P_register_assignment_OFFSET(L16);
  *P1 = L16;
  return 1;
LAB689:
  L22 = (value)(L0[1]);
  L23 = (value)(L0[2]);
  L24 = (value)(L0[3]);
  Manalyzer_P_code_join_expression_SUBEXPRESSION_OFFSET_TYPENR(L22,&L25,L1);
  Manalyzer_P_code_join_expression_SUBEXPRESSION_OFFSET_TYPENR(L24,&L26,L1);
  L28 = G_analyzer_ORIGIN_NR3076;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L27,L1,L28);
  Create(&L29,24,4);
  Create(&L30,2,1);
  *(value *)(L30+1) = L25;
  *(value *)(L29+1) = L30;
  *(value *)(L29+2) = L23;
  ATTACH(L23);
  Create(&L31,2,1);
  *(value *)(L31+1) = L26;
  *(value *)(L29+3) = L31;
  Create(&L32,2,1);
  *(value *)(L32+1) = L27;
  *(value *)(L29+4) = L32;
  Mcode_P_store_INSTRUCTION(L29);
if(DecrRefs(L29)<0)
XD_Mcode_T14(L29);
  Manalyzer_P_register_assignment_OFFSET(L27);
  L33 = G_analyzer_USE_NR3077;
  Manalyzer_P_register_application_OFFSET_USE(L25,L33);
  L34 = G_analyzer_USE_NR3078;
  Manalyzer_P_register_application_OFFSET_USE(L26,L34);
  *P1 = L27;
  return 1;
LAB692:
  L35 = (value)(L0[1]);
  Manalyzer_P_store_VARIABLE_OFFSET_TYPENR(L35,&L36,L1);
  *P1 = L36;
  return 1;
LAB695:
  L37 = (value)(L0[1]);
  L39 = G_analyzer_ORIGIN_NR3079;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L38,L1,L39);
  Create(&L40,27,3);
  Create(&L41,9,1);
  *(value *)(L41+1) = L37;
  *(value *)(L40+1) = L41;
  *(value *)(L40+2) = L1;
  Create(&L42,2,1);
  *(value *)(L42+1) = L38;
  *(value *)(L40+3) = L42;
  Mcode_P_store_INSTRUCTION(L40);
if(DecrRefs(L40)<0)
XD_Mcode_T14(L40);
  Manalyzer_P_register_assignment_OFFSET(L38);
  *P1 = L38;
  return 1;
LAB698:
  L43 = (value)(L0[1]);
  L44 = (value)G_analyzer_CURRENT_MODULENR_NR6;
  Create(&L45,0,1);
  *(value *)(L45+1) = L43;
  ATTACH(L43);
  Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR(L44,L1,L45,&L46);
if(DecrRefs(L45)<0)
XD_Mvariables_T12(L45);
  Manalyzer_P_apply_VARIABLENR_ADDRESS(L46,&L47);
  L49 = G_analyzer_ORIGIN_NR3080;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L48,L1,L49);
  Create(&L50,27,3);
  *(value *)(L50+1) = L47;
  *(value *)(L50+2) = L1;
  Create(&L51,2,1);
  *(value *)(L51+1) = L48;
  *(value *)(L50+3) = L51;
  Mcode_P_store_INSTRUCTION(L50);
if(DecrRefs(L50)<0)
XD_Mcode_T14(L50);
  Manalyzer_P_register_assignment_OFFSET(L48);
  *P1 = L48;
  return 1;
LAB701:
  L52 = (value)(L0[1]);
  switch (Alternative(L52)) {
  case 1: goto LAB704;
  default: goto LAB703;
  };
LAB704:
  L53 = (value)(L52[1]);
  L54 = (value)(L52[2]);
  switch (Alternative(L54)) {
  case 2: goto LAB707;
  default: goto LAB703;
  };
LAB707:
  L0 = L53;
  goto LAB1924;
LAB703:
  Abort(1195, module_name);
}

int Manalyzer_P_code_join_ADDRESS_INT_TYPEALTERNATIVE_STRUCTURE(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value P3;
{
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
LAB1921:
  switch (Alternative(L2)) {
  case 0: goto LAB710;
  case 1: goto LAB713;
  case 2: goto LAB719;
  default: goto LAB721;
  };
LAB710:
  L4 = (value)(L2[1]);
  L5 = (value)(L2[2]);
  L2 = L5;
  goto LAB1921;
LAB713:
  L6 = (value)(L2[1]);
  L7 = (value)(L2[2]);
  switch (Alternative(L3)) {
  case 4: goto LAB716;
  default: goto LAB718;
  };
LAB716:
  L8 = (value)(L3[1]);
  L9 = (value)(L3[2]);
  Manalyzer_P_code_join_STRUCTURE_OFFSET_TYPENR(L8,&L10,L6);
  Create(&L11,27,3);
  Create(&L12,2,1);
  *(value *)(L12+1) = L10;
  *(value *)(L11+1) = L12;
  *(value *)(L11+2) = L6;
  Create(&L13,10,2);
  *(value *)(L13+1) = L0;
  ATTACH(L0);
  *(value *)(L13+2) = L1;
  *(value *)(L11+3) = L13;
  Mcode_P_store_INSTRUCTION(L11);
if(DecrRefs(L11)<0)
XD_Mcode_T14(L11);
  L17 = L10;
  Create(&L18,12,1);
  L19 = (value) Addr((value*)&G_analyzer_ORIGINS_NR17,Int(L17));
  L20 = *((value*)L19);
  ATTACH(L20);
  *(value *)(L18+1) = L20;
if(DecrRefs(*((value*)L19))<0)
XD_Manalyzer_T65(*((value*)L19));
  *((value *)L19) = L18;
LAB1906:
  Manalyzer_P_register_dependancy_OFFSET_ADDRESS(L10,L0);
  L14 = G_analyzer_USE_NR3081;
  Manalyzer_P_register_application_OFFSET_USE(L10,L14);
  Manalyzer_P_register_application_without_attach_ADDRESS(L0);
  L15 = C_INT(1);
  L16 = C_INT(Int(L1) + Int(L15));
  L3 = L9;
  L2 = L7;
  L1 = L16;
  goto LAB1921;
LAB718:
  Abort(1209, module_name);
LAB719:
  return 1;
LAB721:
  Abort(1211, module_name);
}

int Manalyzer_P_code_split_ADDRESS_INT_TYPEALTERNATIVE_STRUCTURE(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value P3;
{
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
LAB1978:
  switch (Alternative(L2)) {
  case 0: goto LAB722;
  case 1: goto LAB725;
  case 2: goto LAB731;
  default: goto LAB733;
  };
LAB722:
  L4 = (value)(L2[1]);
  L5 = (value)(L2[2]);
  L2 = L5;
  goto LAB1978;
LAB725:
  L6 = (value)(L2[1]);
  L7 = (value)(L2[2]);
  switch (Alternative(L3)) {
  case 4: goto LAB728;
  default: goto LAB730;
  };
LAB728:
  L8 = (value)(L3[1]);
  L9 = (value)(L3[2]);
  L11 = G_analyzer_ORIGIN_NR3082;
  Manalyzer_P_new_local_OFFSET_TYPENR_ORIGIN(&L10,L6,L11);
  Create(&L12,1,2);
  *(value *)(L12+1) = L10;
  L13 = G_analyzer_DEFINED_NR2;
  ATTACH(L13);
  *(value *)(L12+2) = L13;
if(DecrRefs(G_analyzer_DEFINED_NR2)<0)
XD_Manalyzer_T3(G_analyzer_DEFINED_NR2);
  G_analyzer_DEFINED_NR2 = L12;
  Create(&L14,27,3);
  Create(&L15,10,2);
  *(value *)(L15+1) = L0;
  ATTACH(L0);
  *(value *)(L15+2) = L1;
  *(value *)(L14+1) = L15;
  *(value *)(L14+2) = L6;
  Create(&L16,2,1);
  *(value *)(L16+1) = L10;
  *(value *)(L14+3) = L16;
  Mcode_P_store_INSTRUCTION(L14);
if(DecrRefs(L14)<0)
XD_Mcode_T14(L14);
  Manalyzer_P_register_dependancy_OFFSET_ADDRESS(L10,L0);
  Manalyzer_P_register_application_without_attach_ADDRESS(L0);
  Manalyzer_P_register_assignment_OFFSET(L10);
  Create(&L17,2,1);
  *(value *)(L17+1) = L10;
  Manalyzer_P_code_split_ADDRESS_TYPENR_STRUCTURE(L17,L6,L8);
if(DecrRefs(L17)<0)
XD_Mcode_T20(L17);
  L18 = C_INT(1);
  L19 = C_INT(Int(L1) + Int(L18));
  L3 = L9;
  L2 = L7;
  L1 = L19;
  goto LAB1978;
LAB730:
  L20 = G_analyzer_TEXT_NR3083;
  E10_write_TEXT(L20);
  Abort(1227, module_name);
LAB731:
  return 1;
LAB733:
  Abort(1229, module_name);
}

int Manalyzer_P_can_split_VARIABLE_EXPRESSION(P0,P1)
value P0;
value P1;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Manalyzer_P_variable_type_VARIABLE_TYPENR(L0,&L2);
  L3 = C_INT(0);
  L10 = L1;
  L11 = L3;
LAB2013:
  switch (Alternative(L10)) {
  case 1: goto LAB2014;
  case 2: goto LAB2017;
  default: goto LAB2019;
  };
LAB2014:
  L12 = (value)(L10[1]);
  L13 = (value)(L10[2]);
  L14 = C_INT(1);
  L15 = C_INT(Int(L11) + Int(L14));
  L11 = L15;
  L10 = L13;
  goto LAB2013;
LAB2017:
  L4 = L11;
LAB2012:
  if (!Manalyzer_P_match_TYPENR_EXPRESSION_LENGTH_STRUCTURE(L2,L1,L4,&L5)) goto LAB734;
  Manalyzer_P_convert_VARIABLE_TYPENR_OFFSET(L0,L2,&L6);
  Create(&L7,1,2);
  *(value *)(L7+1) = L6;
  L8 = G_analyzer_DEFINED_NR2;
  ATTACH(L8);
  *(value *)(L7+2) = L8;
if(DecrRefs(G_analyzer_DEFINED_NR2)<0)
XD_Manalyzer_T3(G_analyzer_DEFINED_NR2);
  G_analyzer_DEFINED_NR2 = L7;
  Create(&L9,2,1);
  *(value *)(L9+1) = L6;
  Manalyzer_P_code_split_ADDRESS_TYPENR_STRUCTURE(L9,L2,L5);
if(DecrRefs(L9)<0)
XD_Mcode_T20(L9);
if(DecrRefs(L5)<0)
XD_Manalyzer_T46(L5);
  return 1;
LAB2019:
  Abort(1417, module_name);
LAB734:
  return 0;
  return 0;
}

int Manalyzer_P_check_EXPRESSIONS(P0)
value P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1842:
  switch (Alternative(L0)) {
  case 0: goto LAB738;
  case 1: goto LAB741;
  case 2: goto LAB744;
  default: goto LAB746;
  };
LAB738:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Manalyzer_P_check_EXPRESSION(L1);
  L0 = L2;
  goto LAB1842;
LAB741:
  L3 = (value)(L0[1]);
  L0 = L3;
  goto LAB1842;
LAB744:
  return 1;
LAB746:
  Abort(1252, module_name);
}

int Manalyzer_P_check_EXPRESSION(P0)
value P0;
{
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1841:
  switch (Alternative(L0)) {
  case 0: goto LAB747;
  case 1: goto LAB750;
  case 2: goto LAB753;
  default: goto LAB755;
  };
LAB747:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Manalyzer_P_check_EXPRESSION(L1);
  L0 = L2;
  goto LAB1841;
LAB750:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  L5 = L3;
  switch (Alternative(L5)) {
  case 0: goto LAB1810;
  case 1: goto LAB1813;
  case 2: goto LAB1826;
  case 4: goto LAB1829;
  case 5: goto LAB1832;
  case 6: goto LAB1835;
  case 3: goto LAB1838;
  default: goto LAB1840;
  };
LAB1810:
  L6 = (value)(L5[1]);
  L7 = (value)(L5[2]);
  Manalyzer_P_should_be_integer_SUBEXPRESSION(L7);
  goto LAB1809;
LAB1813:
  L8 = (value)(L5[1]);
  L9 = (value)(L5[2]);
  L10 = (value)(L5[3]);
  if (!Manalyzer_P_is_integer_SUBEXPRESSION(L8)) goto LAB1817;
  Manalyzer_P_should_be_integer_SUBEXPRESSION(L10);
  goto LAB1809;
LAB1817:
  if (!Manalyzer_P_is_text_SUBEXPRESSION(L8)) goto LAB1821;
  Manalyzer_P_should_be_text_SUBEXPRESSION(L10);
  switch (Alternative(L9)) {
  case 5: goto LAB1809;
  default: goto LAB1822;
  };
LAB1822:
  Create(&L11,9,2);
  *(value *)(L11+1) = L9;
  ATTACH(L9);
  Create(&L12,11,1);
  L13 = G_analyzer_TEXT_NR3084;
  *(value *)(L12+1) = L13;
  ATTACH(L13);
  *(value *)(L11+2) = L12;
  Manalyzer_P_semantic_error_MESSAGE(L11);
if(DecrRefs(L11)<0)
XD_Merrors_T3(L11);
  goto LAB1809;
LAB1821:
  switch (Alternative(L9)) {
  case 5: goto LAB1823;
  default: goto LAB1825;
  };
LAB1823:
  Create(&L14,9,2);
  *(value *)(L14+1) = L9;
  ATTACH(L9);
  Create(&L15,11,1);
  L16 = G_analyzer_TEXT_NR3085;
  *(value *)(L15+1) = L16;
  ATTACH(L16);
  *(value *)(L14+2) = L15;
  Manalyzer_P_semantic_error_MESSAGE(L14);
if(DecrRefs(L14)<0)
XD_Merrors_T3(L14);
  goto LAB1809;
LAB1825:
  Create(&L17,9,2);
  *(value *)(L17+1) = L9;
  ATTACH(L9);
  Create(&L18,11,1);
  L19 = G_analyzer_TEXT_NR3086;
  *(value *)(L18+1) = L19;
  ATTACH(L19);
  *(value *)(L17+2) = L18;
  Manalyzer_P_semantic_error_MESSAGE(L17);
if(DecrRefs(L17)<0)
XD_Merrors_T3(L17);
  goto LAB1809;
LAB1826:
  L20 = (value)(L5[1]);
  Manalyzer_P_check_EXPRESSION(L20);
  goto LAB1809;
LAB1829:
  L21 = (value)(L5[1]);
  goto LAB1809;
LAB1832:
  L22 = (value)(L5[1]);
  goto LAB1809;
LAB1835:
  L23 = (value)(L5[1]);
  goto LAB1809;
LAB1838:
  L24 = (value)(L5[1]);
  Manalyzer_P_check_VARIABLE_TYPENR(L24,&L25);
LAB1809:
  L0 = L4;
  goto LAB1841;
LAB1840:
  Abort(1284, module_name);
LAB753:
  return 1;
LAB755:
  Abort(1262, module_name);
}

int Manalyzer_P_check_SUBEXPRESSION(P0)
value P0;
{
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB756;
  case 1: goto LAB759;
  case 2: goto LAB772;
  case 4: goto LAB775;
  case 5: goto LAB778;
  case 6: goto LAB781;
  case 3: goto LAB784;
  default: goto LAB786;
  };
LAB756:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Manalyzer_P_should_be_integer_SUBEXPRESSION(L2);
  return 1;
LAB759:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  L5 = (value)(L0[3]);
  if (!Manalyzer_P_is_integer_SUBEXPRESSION(L3)) goto LAB763;
  Manalyzer_P_should_be_integer_SUBEXPRESSION(L5);
  return 1;
LAB763:
  if (!Manalyzer_P_is_text_SUBEXPRESSION(L3)) goto LAB765;
  Manalyzer_P_should_be_text_SUBEXPRESSION(L5);
  switch (Alternative(L4)) {
  case 5: goto LAB766;
  default: goto LAB768;
  };
LAB766:
  return 1;
LAB768:
  Create(&L6,9,2);
  *(value *)(L6+1) = L4;
  ATTACH(L4);
  Create(&L7,11,1);
  L8 = G_analyzer_TEXT_NR3084;
  *(value *)(L7+1) = L8;
  ATTACH(L8);
  *(value *)(L6+2) = L7;
  Manalyzer_P_semantic_error_MESSAGE(L6);
if(DecrRefs(L6)<0)
XD_Merrors_T3(L6);
  return 1;
LAB765:
  switch (Alternative(L4)) {
  case 5: goto LAB769;
  default: goto LAB771;
  };
LAB769:
  Create(&L9,9,2);
  *(value *)(L9+1) = L4;
  ATTACH(L4);
  Create(&L10,11,1);
  L11 = G_analyzer_TEXT_NR3085;
  *(value *)(L10+1) = L11;
  ATTACH(L11);
  *(value *)(L9+2) = L10;
  Manalyzer_P_semantic_error_MESSAGE(L9);
if(DecrRefs(L9)<0)
XD_Merrors_T3(L9);
  return 1;
LAB771:
  Create(&L12,9,2);
  *(value *)(L12+1) = L4;
  ATTACH(L4);
  Create(&L13,11,1);
  L14 = G_analyzer_TEXT_NR3086;
  *(value *)(L13+1) = L14;
  ATTACH(L14);
  *(value *)(L12+2) = L13;
  Manalyzer_P_semantic_error_MESSAGE(L12);
if(DecrRefs(L12)<0)
XD_Merrors_T3(L12);
  return 1;
LAB772:
  L15 = (value)(L0[1]);
  Manalyzer_P_check_EXPRESSION(L15);
  return 1;
LAB775:
  L16 = (value)(L0[1]);
  return 1;
LAB778:
  L17 = (value)(L0[1]);
  return 1;
LAB781:
  L18 = (value)(L0[1]);
  return 1;
LAB784:
  L19 = (value)(L0[1]);
  Manalyzer_P_check_VARIABLE_TYPENR(L19,&L20);
  return 1;
LAB786:
  Abort(1284, module_name);
}

int Manalyzer_P_check_VARIABLE_TYPENR(P0,P1)
value P0;
value *P1;
{
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 2: goto LAB787;
  case 3: goto LAB802;
  case 1: goto LAB808;
  case 0: goto LAB811;
  default: goto LAB813;
  };
LAB787:
  L1 = (value)(L0[1]);
  Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE(L1,&L2,&L3,&L4,&L5);
if(DecrRefs(L4)<0)
XD_Mvariables_T8(L4);
  switch (Alternative(L5)) {
  case 1: goto LAB790;
  case 0: goto LAB793;
  case 2: goto LAB799;
  default: goto LAB801;
  };
LAB790:
if(DecrRefs(L5)<0)
XD_Mvariables_T9(L5);
  *P1 = L3;
  return 1;
LAB793:
  L6 = (value)(L5[1]);
  switch (Int(L6)) {
  case 1: goto LAB796;
  default: goto LAB801;
  };
LAB796:
if(DecrRefs(L5)<0)
XD_Mvariables_T9(L5);
  *P1 = L3;
  return 1;
LAB799:
if(DecrRefs(L5)<0)
XD_Mvariables_T9(L5);
  *P1 = L3;
  return 1;
LAB801:
if(DecrRefs(L5)<0)
XD_Mvariables_T9(L5);
  Create(&L7,6,2);
  L8 = G_analyzer_TEXT_NR3087;
  *(value *)(L7+1) = L8;
  ATTACH(L8);
  Create(&L9,7,2);
  Create(&L10,3,1);
  Create(&L11,2,1);
  *(value *)(L11+1) = L1;
  *(value *)(L10+1) = L11;
  *(value *)(L9+1) = L10;
  Create(&L12,11,1);
  L13 = G_analyzer_TEXT_NR3088;
  *(value *)(L12+1) = L13;
  ATTACH(L13);
  *(value *)(L9+2) = L12;
  *(value *)(L7+2) = L9;
  Manalyzer_P_semantic_error_MESSAGE(L7);
if(DecrRefs(L7)<0)
XD_Merrors_T3(L7);
  *P1 = L3;
  return 1;
LAB802:
  L14 = (value)(L0[1]);
  L15 = (value)(L0[2]);
  Manalyzer_P_should_be_integer_SUBEXPRESSION(L15);
  Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE(L14,&L16,&L17,&L18,&L19);
if(DecrRefs(L18)<0)
XD_Mvariables_T8(L18);
  switch (Alternative(L19)) {
  case 1: goto LAB805;
  default: goto LAB807;
  };
LAB805:
if(DecrRefs(L19)<0)
XD_Mvariables_T9(L19);
  Create(&L20,6,2);
  L21 = G_analyzer_TEXT_NR3089;
  *(value *)(L20+1) = L21;
  ATTACH(L21);
  Create(&L22,7,2);
  Create(&L23,3,1);
  Create(&L24,2,1);
  *(value *)(L24+1) = L14;
  *(value *)(L23+1) = L24;
  *(value *)(L22+1) = L23;
  Create(&L25,11,1);
  L26 = G_analyzer_TEXT_NR3090;
  *(value *)(L25+1) = L26;
  ATTACH(L26);
  *(value *)(L22+2) = L25;
  *(value *)(L20+2) = L22;
  Manalyzer_P_semantic_error_MESSAGE(L20);
if(DecrRefs(L20)<0)
XD_Merrors_T3(L20);
  *P1 = L17;
  return 1;
LAB807:
if(DecrRefs(L19)<0)
XD_Mvariables_T9(L19);
  *P1 = L17;
  return 1;
LAB808:
  L27 = (value)(L0[1]);
  *P1 = L27;
  return 1;
LAB811:
  L28 = (value)(L0[1]);
  Manalyzer_P_check_VARIABLE_TYPENR(L28,&L29);
  if (!Manalyzer_P_is_abstract_synonym_TYPENR_TYPENR(L29,&L30)) goto LAB815;
  *P1 = L30;
  return 1;
LAB815:
  Create(&L31,6,2);
  L32 = G_analyzer_TEXT_NR3091;
  *(value *)(L31+1) = L32;
  ATTACH(L32);
  Create(&L33,7,2);
  Create(&L34,3,1);
  *(value *)(L34+1) = L28;
  ATTACH(L28);
  *(value *)(L33+1) = L34;
  Create(&L35,11,1);
  L36 = G_analyzer_TEXT_NR3092;
  *(value *)(L35+1) = L36;
  ATTACH(L36);
  *(value *)(L33+2) = L35;
  *(value *)(L31+2) = L33;
  Manalyzer_P_semantic_error_MESSAGE(L31);
if(DecrRefs(L31)<0)
XD_Merrors_T3(L31);
  *P1 = L29;
  return 1;
LAB813:
  Abort(1304, module_name);
}

int Manalyzer_P_is_abstract_synonym_TYPENR_TYPENR(P0,P1)
value P0;
value *P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mtypes_P_get_TYPENR_TYPE(L0,&L1);
  switch (Alternative(L1)) {
  case 0: goto LAB816;
  default: goto LAB817;
  };
LAB816:
  L2 = (value)(L1[1]);
  switch (Alternative(L2)) {
  case 1: goto LAB819;
  default: goto LAB820;
  };
LAB819:
  L3 = (value)(L2[1]);
  L4 = (value)(L2[2]);
  switch (Alternative(L4)) {
  case 2: goto LAB822;
  default: goto LAB823;
  };
LAB822:
  L5 = (value)(L1[2]);
  switch (Alternative(L5)) {
  case 2: goto LAB825;
  default: goto LAB826;
  };
LAB825:
  *P1 = L3;
if(DecrRefs(L1)<0)
XD_Mtypes_T11(L1);
  return 1;
LAB817:
if(DecrRefs(L1)<0)
XD_Mtypes_T11(L1);
  return 0;
LAB820:
if(DecrRefs(L1)<0)
XD_Mtypes_T11(L1);
  return 0;
LAB823:
if(DecrRefs(L1)<0)
XD_Mtypes_T11(L1);
  return 0;
LAB826:
if(DecrRefs(L1)<0)
XD_Mtypes_T11(L1);
  return 0;
  return 0;
}

int Manalyzer_P_should_be_integer_SUBEXPRESSION(P0)
value P0;
{
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1805:
  switch (Alternative(L0)) {
  case 0: goto LAB828;
  case 1: goto LAB831;
  case 2: goto LAB834;
  case 4: goto LAB843;
  case 5: goto LAB846;
  case 6: goto LAB849;
  case 3: goto LAB852;
  default: goto LAB854;
  };
LAB828:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L0 = L2;
  goto LAB1805;
LAB831:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  L5 = (value)(L0[3]);
  Manalyzer_P_should_be_integer_SUBEXPRESSION(L3);
  L0 = L5;
  goto LAB1805;
LAB834:
  L6 = (value)(L0[1]);
  switch (Alternative(L6)) {
  case 1: goto LAB837;
  default: goto LAB839;
  };
LAB837:
  L7 = (value)(L6[1]);
  L8 = (value)(L6[2]);
  switch (Alternative(L8)) {
  case 2: goto LAB840;
  default: goto LAB839;
  };
LAB840:
  L0 = L7;
  goto LAB1805;
LAB839:
  Create(&L9,6,2);
  L10 = G_analyzer_TEXT_NR3093;
  *(value *)(L9+1) = L10;
  ATTACH(L10);
  Create(&L11,8,2);
  *(value *)(L11+1) = L6;
  ATTACH(L6);
  Create(&L12,11,1);
  L13 = G_analyzer_TEXT_NR3094;
  *(value *)(L12+1) = L13;
  ATTACH(L13);
  *(value *)(L11+2) = L12;
  *(value *)(L9+2) = L11;
  Manalyzer_P_semantic_error_MESSAGE(L9);
if(DecrRefs(L9)<0)
XD_Merrors_T3(L9);
  return 1;
LAB843:
  L14 = (value)(L0[1]);
  Create(&L15,6,2);
  L16 = G_analyzer_TEXT_NR3095;
  *(value *)(L15+1) = L16;
  ATTACH(L16);
  Create(&L17,7,2);
  *(value *)(L17+1) = L0;
  ATTACH(L0);
  Create(&L18,11,1);
  L19 = G_analyzer_TEXT_NR3096;
  *(value *)(L18+1) = L19;
  ATTACH(L19);
  *(value *)(L17+2) = L18;
  *(value *)(L15+2) = L17;
  Manalyzer_P_semantic_error_MESSAGE(L15);
if(DecrRefs(L15)<0)
XD_Merrors_T3(L15);
  return 1;
LAB846:
  L20 = (value)(L0[1]);
  return 1;
LAB849:
  L21 = (value)(L0[1]);
  Create(&L22,6,2);
  L23 = G_analyzer_TEXT_NR3097;
  *(value *)(L22+1) = L23;
  ATTACH(L23);
  Create(&L24,7,2);
  *(value *)(L24+1) = L0;
  ATTACH(L0);
  Create(&L25,11,1);
  L26 = G_analyzer_TEXT_NR3098;
  *(value *)(L25+1) = L26;
  ATTACH(L26);
  *(value *)(L24+2) = L25;
  *(value *)(L22+2) = L24;
  Manalyzer_P_semantic_error_MESSAGE(L22);
if(DecrRefs(L22)<0)
XD_Merrors_T3(L22);
  return 1;
LAB852:
  L27 = (value)(L0[1]);
  Manalyzer_P_check_VARIABLE_TYPENR(L27,&L28);
  Manalyzer_P_base_type_TYPENR_TYPENR(L28,&L29);
  if (!Mtypes_P_is_integer_type_TYPENR(L29)) goto LAB856;
  return 1;
LAB856:
  Create(&L30,6,2);
  L31 = G_analyzer_TEXT_NR3099;
  *(value *)(L30+1) = L31;
  ATTACH(L31);
  Create(&L32,7,2);
  *(value *)(L32+1) = L0;
  ATTACH(L0);
  Create(&L33,11,1);
  L34 = G_analyzer_TEXT_NR3100;
  *(value *)(L33+1) = L34;
  ATTACH(L34);
  *(value *)(L32+2) = L33;
  *(value *)(L30+2) = L32;
  Manalyzer_P_semantic_error_MESSAGE(L30);
if(DecrRefs(L30)<0)
XD_Merrors_T3(L30);
  return 1;
LAB854:
  Abort(1330, module_name);
}

int Manalyzer_P_base_type_TYPENR_TYPENR(P0,P1)
value P0;
value *P1;
{
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mtypes_P_get_TYPENR_TYPE(L0,&L1);
  switch (Alternative(L1)) {
  case 1: goto LAB857;
  case 0: goto LAB860;
  default: goto LAB862;
  };
LAB857:
  L2 = (value)(L1[1]);
  Manalyzer_P_base_type_TYPENR_TYPENR(L2,&L3);
if(DecrRefs(L1)<0)
XD_Mtypes_T11(L1);
  *P1 = L3;
  return 1;
LAB860:
  L4 = (value)(L1[1]);
  switch (Alternative(L4)) {
  case 1: goto LAB863;
  default: goto LAB862;
  };
LAB863:
  L5 = (value)(L4[1]);
  L6 = (value)(L4[2]);
  switch (Alternative(L6)) {
  case 2: goto LAB866;
  default: goto LAB862;
  };
LAB866:
  L7 = (value)(L1[2]);
  switch (Alternative(L7)) {
  case 2: goto LAB869;
  default: goto LAB862;
  };
LAB869:
  Manalyzer_P_base_type_TYPENR_TYPENR(L5,&L8);
if(DecrRefs(L1)<0)
XD_Mtypes_T11(L1);
  *P1 = L8;
  return 1;
LAB862:
if(DecrRefs(L1)<0)
XD_Mtypes_T11(L1);
  *P1 = L0;
  return 1;
}

int Manalyzer_P_is_integer_SUBEXPRESSION(P0)
value P0;
{
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1806:
  switch (Alternative(L0)) {
  case 0: goto LAB872;
  case 1: goto LAB875;
  case 2: goto LAB880;
  case 4: goto LAB891;
  case 5: goto LAB894;
  case 6: goto LAB897;
  case 3: goto LAB900;
  default: goto LAB902;
  };
LAB872:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Manalyzer_P_should_be_integer_SUBEXPRESSION(L2);
  return 1;
LAB875:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  L5 = (value)(L0[3]);
  if (!Manalyzer_P_is_integer_SUBEXPRESSION(L3)) goto LAB879;
  Manalyzer_P_should_be_integer_SUBEXPRESSION(L5);
  return 1;
LAB879:
  return 0;
LAB880:
  L6 = (value)(L0[1]);
  switch (Alternative(L6)) {
  case 1: goto LAB883;
  default: goto LAB885;
  };
LAB883:
  L7 = (value)(L6[1]);
  L8 = (value)(L6[2]);
  switch (Alternative(L8)) {
  case 2: goto LAB886;
  default: goto LAB885;
  };
LAB886:
  L0 = L7;
  goto LAB1806;
LAB885:
  return 0;
LAB891:
  L9 = (value)(L0[1]);
  return 0;
LAB894:
  L10 = (value)(L0[1]);
  return 1;
LAB897:
  L11 = (value)(L0[1]);
  return 0;
LAB900:
  L12 = (value)(L0[1]);
  Manalyzer_P_check_VARIABLE_TYPENR(L12,&L13);
  Manalyzer_P_base_type_TYPENR_TYPENR(L13,&L14);
  if (!Mtypes_P_is_integer_type_TYPENR(L14)) goto LAB904;
  return 1;
LAB904:
  return 0;
LAB902:
  Abort(1361, module_name);
}

int Manalyzer_P_should_be_text_SUBEXPRESSION(P0)
value P0;
{
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1807:
  switch (Alternative(L0)) {
  case 0: goto LAB905;
  case 1: goto LAB908;
  case 2: goto LAB914;
  case 4: goto LAB923;
  case 5: goto LAB926;
  case 6: goto LAB929;
  case 3: goto LAB932;
  default: goto LAB934;
  };
LAB905:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Create(&L3,6,2);
  L4 = G_analyzer_TEXT_NR3101;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  Create(&L5,7,2);
  *(value *)(L5+1) = L0;
  ATTACH(L0);
  Create(&L6,11,1);
  L7 = G_analyzer_TEXT_NR3102;
  *(value *)(L6+1) = L7;
  ATTACH(L7);
  *(value *)(L5+2) = L6;
  *(value *)(L3+2) = L5;
  Manalyzer_P_semantic_error_MESSAGE(L3);
if(DecrRefs(L3)<0)
XD_Merrors_T3(L3);
  return 1;
LAB908:
  L8 = (value)(L0[1]);
  L9 = (value)(L0[2]);
  L10 = (value)(L0[3]);
  Manalyzer_P_should_be_text_SUBEXPRESSION(L8);
  Manalyzer_P_should_be_text_SUBEXPRESSION(L10);
  switch (Alternative(L9)) {
  case 5: goto LAB911;
  default: goto LAB913;
  };
LAB911:
  return 1;
LAB913:
  Create(&L11,9,2);
  *(value *)(L11+1) = L9;
  ATTACH(L9);
  Create(&L12,11,1);
  L13 = G_analyzer_TEXT_NR3103;
  *(value *)(L12+1) = L13;
  ATTACH(L13);
  *(value *)(L11+2) = L12;
  Manalyzer_P_semantic_error_MESSAGE(L11);
if(DecrRefs(L11)<0)
XD_Merrors_T3(L11);
  return 1;
LAB914:
  L14 = (value)(L0[1]);
  switch (Alternative(L14)) {
  case 1: goto LAB917;
  default: goto LAB919;
  };
LAB917:
  L15 = (value)(L14[1]);
  L16 = (value)(L14[2]);
  switch (Alternative(L16)) {
  case 2: goto LAB920;
  default: goto LAB919;
  };
LAB920:
  L0 = L15;
  goto LAB1807;
LAB919:
  Create(&L17,6,2);
  L18 = G_analyzer_TEXT_NR3104;
  *(value *)(L17+1) = L18;
  ATTACH(L18);
  Create(&L19,8,2);
  *(value *)(L19+1) = L14;
  ATTACH(L14);
  Create(&L20,11,1);
  L21 = G_analyzer_TEXT_NR3105;
  *(value *)(L20+1) = L21;
  ATTACH(L21);
  *(value *)(L19+2) = L20;
  *(value *)(L17+2) = L19;
  Manalyzer_P_semantic_error_MESSAGE(L17);
if(DecrRefs(L17)<0)
XD_Merrors_T3(L17);
  return 1;
LAB923:
  L22 = (value)(L0[1]);
  Create(&L23,6,2);
  L24 = G_analyzer_TEXT_NR3106;
  *(value *)(L23+1) = L24;
  ATTACH(L24);
  Create(&L25,7,2);
  *(value *)(L25+1) = L0;
  ATTACH(L0);
  Create(&L26,11,1);
  L27 = G_analyzer_TEXT_NR3107;
  *(value *)(L26+1) = L27;
  ATTACH(L27);
  *(value *)(L25+2) = L26;
  *(value *)(L23+2) = L25;
  Manalyzer_P_semantic_error_MESSAGE(L23);
if(DecrRefs(L23)<0)
XD_Merrors_T3(L23);
  return 1;
LAB926:
  L28 = (value)(L0[1]);
  Create(&L29,6,2);
  L30 = G_analyzer_TEXT_NR3108;
  *(value *)(L29+1) = L30;
  ATTACH(L30);
  Create(&L31,7,2);
  *(value *)(L31+1) = L0;
  ATTACH(L0);
  Create(&L32,11,1);
  L33 = G_analyzer_TEXT_NR3109;
  *(value *)(L32+1) = L33;
  ATTACH(L33);
  *(value *)(L31+2) = L32;
  *(value *)(L29+2) = L31;
  Manalyzer_P_semantic_error_MESSAGE(L29);
if(DecrRefs(L29)<0)
XD_Merrors_T3(L29);
  return 1;
LAB929:
  L34 = (value)(L0[1]);
  return 1;
LAB932:
  L35 = (value)(L0[1]);
  Manalyzer_P_check_VARIABLE_TYPENR(L35,&L36);
  Manalyzer_P_base_type_TYPENR_TYPENR(L36,&L37);
  if (!Mtypes_P_is_text_type_TYPENR(L37)) goto LAB936;
  return 1;
LAB936:
  Create(&L38,6,2);
  L39 = G_analyzer_TEXT_NR3110;
  *(value *)(L38+1) = L39;
  ATTACH(L39);
  Create(&L40,7,2);
  *(value *)(L40+1) = L0;
  ATTACH(L0);
  Create(&L41,11,1);
  L42 = G_analyzer_TEXT_NR3111;
  *(value *)(L41+1) = L42;
  ATTACH(L42);
  *(value *)(L40+2) = L41;
  *(value *)(L38+2) = L40;
  Manalyzer_P_semantic_error_MESSAGE(L38);
if(DecrRefs(L38)<0)
XD_Merrors_T3(L38);
  return 1;
LAB934:
  Abort(1385, module_name);
}

int Manalyzer_P_is_text_SUBEXPRESSION(P0)
value P0;
{
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB1808:
  switch (Alternative(L0)) {
  case 0: goto LAB937;
  case 1: goto LAB940;
  case 2: goto LAB948;
  case 4: goto LAB959;
  case 5: goto LAB962;
  case 6: goto LAB965;
  case 3: goto LAB968;
  default: goto LAB970;
  };
LAB937:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  return 0;
LAB940:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  L5 = (value)(L0[3]);
  if (!Manalyzer_P_is_text_SUBEXPRESSION(L3)) goto LAB944;
  Manalyzer_P_should_be_text_SUBEXPRESSION(L5);
  switch (Alternative(L4)) {
  case 5: goto LAB945;
  default: goto LAB947;
  };
LAB945:
  return 1;
LAB947:
  Create(&L6,9,2);
  *(value *)(L6+1) = L4;
  ATTACH(L4);
  Create(&L7,11,1);
  L8 = G_analyzer_TEXT_NR3112;
  *(value *)(L7+1) = L8;
  ATTACH(L8);
  *(value *)(L6+2) = L7;
  Manalyzer_P_semantic_error_MESSAGE(L6);
if(DecrRefs(L6)<0)
XD_Merrors_T3(L6);
  return 1;
LAB944:
  return 0;
LAB948:
  L9 = (value)(L0[1]);
  switch (Alternative(L9)) {
  case 1: goto LAB951;
  default: goto LAB953;
  };
LAB951:
  L10 = (value)(L9[1]);
  L11 = (value)(L9[2]);
  switch (Alternative(L11)) {
  case 2: goto LAB954;
  default: goto LAB953;
  };
LAB954:
  L0 = L10;
  goto LAB1808;
LAB953:
  return 0;
LAB959:
  L12 = (value)(L0[1]);
  return 0;
LAB962:
  L13 = (value)(L0[1]);
  return 0;
LAB965:
  L14 = (value)(L0[1]);
  return 1;
LAB968:
  L15 = (value)(L0[1]);
  Manalyzer_P_check_VARIABLE_TYPENR(L15,&L16);
  Manalyzer_P_base_type_TYPENR_TYPENR(L16,&L17);
  if (!Mtypes_P_is_text_type_TYPENR(L17)) goto LAB972;
  return 1;
LAB972:
  return 0;
LAB970:
  Abort(1410, module_name);
}

int Manalyzer_P_length_EXPRESSION_LENGTH_LENGTH(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1843:
  switch (Alternative(L0)) {
  case 1: goto LAB973;
  case 2: goto LAB976;
  default: goto LAB978;
  };
LAB973:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  L4 = C_INT(1);
  L5 = C_INT(Int(L1) + Int(L4));
  L1 = L5;
  L0 = L3;
  goto LAB1843;
LAB976:
  *P2 = L1;
  return 1;
LAB978:
  Abort(1417, module_name);
}

int Manalyzer_P_length_TYPEALTERNATIVE_LENGTH_LENGTH(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1869:
  switch (Alternative(L0)) {
  case 0: goto LAB979;
  case 1: goto LAB982;
  case 2: goto LAB985;
  default: goto LAB987;
  };
LAB979:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  L4 = C_INT(1);
  L5 = C_INT(Int(L1) + Int(L4));
  L1 = L5;
  L0 = L3;
  goto LAB1869;
LAB982:
  L7 = (value)(L0[1]);
  L8 = (value)(L0[2]);
  L9 = C_INT(1);
  L10 = C_INT(Int(L1) + Int(L9));
  L1 = L10;
  L0 = L8;
  goto LAB1869;
LAB985:
  *P2 = L1;
  return 1;
LAB987:
  Abort(1426, module_name);
}

int Manalyzer_P_match_TYPENR_EXPRESSION_LENGTH_STRUCTURE(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  Create(&L3,1,2);
  *(value *)(L3+1) = L0;
  L4 = G_analyzer_TYPEALTERNATIVE_NR3113;
  *(value *)(L3+2) = L4;
  ATTACH(L4);
  L5 = G_analyzer_REST_NR3114;
  L6 = C_INT(1);
  L7 = C_INT(Int(L2) - Int(L6));
  if (!Manalyzer_P_match_TYPEALTERNATIVE_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(L3,L5,L1,L7,&L8,&L9)) goto LAB988;
if(DecrRefs(L9)<0)
XD_Manalyzer_T46(L9);
if(DecrRefs(L3)<0)
XD_Mtypes_T15(L3);
  *P3 = L8;
  return 1;
LAB988:
if(DecrRefs(L3)<0)
XD_Mtypes_T15(L3);
  return 0;
  return 0;
}

int Manalyzer_P_match_TYPENR_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(P0,P1,P2,P3,P4,P5)
value P0;
value P1;
value P2;
value P3;
value *P4;
value *P5;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  Mtypes_P_get_TYPENR_TYPE(L0,&L4);
  switch (Alternative(L4)) {
  case 0: goto LAB990;
  default: goto LAB992;
  };
LAB990:
  L5 = (value)(L4[1]);
  L6 = (value)(L4[2]);
  switch (Alternative(L6)) {
  case 2: goto LAB993;
  default: goto LAB992;
  };
LAB993:
  if (!Manalyzer_P_match_TYPEALTERNATIVE_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(L5,L1,L2,L3,&L7,&L8)) goto LAB997;
  switch (Alternative(L5)) {
  case 1: goto LAB998;
  default: goto LAB1000;
  };
LAB998:
  L9 = (value)(L5[1]);
  L10 = (value)(L5[2]);
  switch (Alternative(L10)) {
  case 2: goto LAB1001;
  default: goto LAB1000;
  };
LAB1001:
if(DecrRefs(L4)<0)
XD_Mtypes_T11(L4);
  *P5 = L8;
  *P4 = L7;
  return 1;
LAB1000:
if(DecrRefs(L4)<0)
XD_Mtypes_T11(L4);
  Create(&L11,5,1);
  *(value *)(L11+1) = L7;
  *P5 = L8;
  *P4 = L11;
  return 1;
LAB997:
if(DecrRefs(L4)<0)
XD_Mtypes_T11(L4);
  return 0;
LAB992:
  L12 = C_INT(0);
  L13 = C_INT(1);
  L14 = C_INT(Int(L3) + Int(L13));
  if (!Manalyzer_P_match_TYPE_ALTNR_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(L4,L12,L1,L2,L14,&L15,&L16)) goto LAB1005;
if(DecrRefs(L4)<0)
XD_Mtypes_T11(L4);
  *P5 = L16;
  *P4 = L15;
  return 1;
LAB1005:
if(DecrRefs(L4)<0)
XD_Mtypes_T11(L4);
  return 0;
}

int Manalyzer_P_match_TYPE_ALTNR_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(P0,P1,P2,P3,P4,P5,P6)
value P0;
value P1;
value P2;
value P3;
value P4;
value *P5;
value *P6;
{
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L4 = P4;
LAB1881:
  switch (Alternative(L0)) {
  case 0: goto LAB1006;
  case 1: goto LAB1017;
  default: goto LAB1019;
  };
LAB1006:
  L5 = (value)(L0[1]);
  L6 = (value)(L0[2]);
  L7 = C_INT(0);
  L24 = L5;
  L25 = L7;
LAB1871:
  switch (Alternative(L24)) {
  case 0: goto LAB1872;
  case 1: goto LAB1875;
  case 2: goto LAB1878;
  default: goto LAB1880;
  };
LAB1872:
  L26 = (value)(L24[1]);
  L27 = (value)(L24[2]);
  L28 = C_INT(1);
  L29 = C_INT(Int(L25) + Int(L28));
  L25 = L29;
  L24 = L27;
  goto LAB1871;
LAB1875:
  L31 = (value)(L24[1]);
  L32 = (value)(L24[2]);
  L33 = C_INT(1);
  L34 = C_INT(Int(L25) + Int(L33));
  L25 = L34;
  L24 = L32;
  goto LAB1871;
LAB1878:
  L8 = L25;
LAB1870:
  if (!E41_lesseq_INT_INT(L8,L4)) goto LAB1009;
  L9 = C_INT(Int(L4) - Int(L8));
  if (!Manalyzer_P_match_TYPEALTERNATIVE_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(L5,L2,L3,L9,&L10,&L11)) goto LAB1010;
  L12 = C_INT(1);
  L13 = C_INT(Int(L1) + Int(L12));
  if (!Manalyzer_P_match_TYPE_ALTNR_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(L6,L13,L2,L3,L4,&L14,&L15)) goto LAB1014;
if(DecrRefs(L11)<0)
XD_Manalyzer_T46(L11);
if(DecrRefs(L10)<0)
XD_Manalyzer_T46(L10);
if(DecrRefs(L15)<0)
XD_Manalyzer_T46(L15);
if(DecrRefs(L14)<0)
XD_Manalyzer_T46(L14);
  return 0;
LAB1880:
  Abort(1426, module_name);
LAB1009:
LAB1010:
  L17 = C_INT(1);
  L18 = C_INT(Int(L1) + Int(L17));
  L1 = L18;
  L0 = L6;
  goto LAB1881;
LAB1014:
  Create(&L16,6,2);
  *(value *)(L16+1) = L1;
  *(value *)(L16+2) = L10;
  *P6 = L11;
  *P5 = L16;
  return 1;
  return 0;
LAB1017:
  L21 = (value)(L0[1]);
  if (!Manalyzer_P_match_TYPENR_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(L21,L2,L3,L4,&L22,&L23)) goto LAB1019;
  *P6 = L23;
  *P5 = L22;
  return 1;
LAB1019:
  return 0;
}

int Manalyzer_P_match_TYPEALTERNATIVE_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(P0,P1,P2,P3,P4,P5)
value P0;
value P1;
value P2;
value P3;
value *P4;
value *P5;
{
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
LAB1891:
  switch (Alternative(L0)) {
  case 0: goto LAB1022;
  case 1: goto LAB1035;
  case 2: goto LAB1059;
  default: goto LAB1061;
  };
LAB1022:
  L4 = (value)(L0[1]);
  L5 = (value)(L0[2]);
  switch (Alternative(L2)) {
  case 1: goto LAB1025;
  default: goto LAB1027;
  };
LAB1025:
  L6 = (value)(L2[1]);
  switch (Alternative(L6)) {
  case 4: goto LAB1028;
  default: goto LAB1027;
  };
LAB1028:
  L7 = (value)(L6[1]);
  L8 = (value)(L2[2]);
  if (!(L4 == L7)) goto LAB1027;
  L2 = L8;
  L0 = L5;
  goto LAB1891;
LAB1027:
  return 0;
LAB1035:
  L11 = (value)(L0[1]);
  L12 = (value)(L0[2]);
  switch (Alternative(L2)) {
  case 1: goto LAB1038;
  default: goto LAB1040;
  };
LAB1038:
  L13 = (value)(L2[1]);
  L14 = (value)(L2[2]);
  switch (Alternative(L13)) {
  case 2: goto LAB1041;
  default: goto LAB1043;
  };
LAB1041:
  L15 = (value)(L13[1]);
  L16 = C_INT(0);
  L38 = L2;
  L39 = L16;
LAB1861:
  switch (Alternative(L38)) {
  case 1: goto LAB1862;
  case 2: goto LAB1865;
  default: goto LAB1867;
  };
LAB1862:
  L40 = (value)(L38[1]);
  L41 = (value)(L38[2]);
  L42 = C_INT(1);
  L43 = C_INT(Int(L39) + Int(L42));
  L39 = L43;
  L38 = L41;
  goto LAB1861;
LAB1865:
  L17 = L39;
LAB1860:
  if (!Manalyzer_P_match_TYPENR_EXPRESSION_LENGTH_STRUCTURE(L11,L15,L17,&L18)) goto LAB1045;
  if (!Manalyzer_P_match_TYPEALTERNATIVE_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(L12,L1,L14,L17,&L19,&L20)) goto LAB1046;
  Create(&L21,4,2);
  *(value *)(L21+1) = L18;
  *(value *)(L21+2) = L19;
  *P5 = L20;
  *P4 = L21;
  return 1;
LAB1867:
  Abort(1417, module_name);
LAB1046:
if(DecrRefs(L18)<0)
XD_Manalyzer_T46(L18);
  return 0;
LAB1045:
  return 0;
LAB1043:
  L22 = G_analyzer_STRICT_NR3115;
  if (!Manalyzer_P_match_STRICT_TYPENR_SUBEXPRESSION_STRUCTURE(L22,L11,L13,&L23)) goto LAB1049;
  if (!Manalyzer_P_match_TYPEALTERNATIVE_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(L12,L1,L14,L3,&L24,&L25)) goto LAB1050;
  Create(&L26,0,2);
  *(value *)(L26+1) = L12;
  ATTACH(L12);
  *(value *)(L26+2) = L1;
  ATTACH(L1);
  if (!Manalyzer_P_match_TYPENR_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(L11,L26,L2,L3,&L27,&L28)) goto LAB1052;
if(DecrRefs(L25)<0)
XD_Manalyzer_T46(L25);
if(DecrRefs(L24)<0)
XD_Manalyzer_T46(L24);
if(DecrRefs(L23)<0)
XD_Manalyzer_T46(L23);
if(DecrRefs(L28)<0)
XD_Manalyzer_T46(L28);
if(DecrRefs(L27)<0)
XD_Manalyzer_T46(L27);
if(DecrRefs(L26)<0)
XD_Manalyzer_T51(L26);
  return 0;
LAB1050:
if(DecrRefs(L23)<0)
XD_Manalyzer_T46(L23);
LAB1049:
  Create(&L30,0,2);
  *(value *)(L30+1) = L12;
  ATTACH(L12);
  *(value *)(L30+2) = L1;
  ATTACH(L1);
  if (!Manalyzer_P_match_TYPENR_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(L11,L30,L2,L3,&L31,&L32)) goto LAB1054;
if(DecrRefs(L30)<0)
XD_Manalyzer_T51(L30);
  switch (Alternative(L32)) {
  case 4: goto LAB1056;
  default: goto LAB1058;
  };
LAB1052:
if(DecrRefs(L26)<0)
XD_Manalyzer_T51(L26);
LAB1053:
  Create(&L29,4,2);
  *(value *)(L29+1) = L23;
  *(value *)(L29+2) = L24;
  *P5 = L25;
  *P4 = L29;
  return 1;
LAB1056:
  L33 = (value)(L32[1]);
  L34 = (value)(L32[2]);
  Create(&L35,4,2);
  *(value *)(L35+1) = L31;
  *(value *)(L35+2) = L33;
  ATTACH(L33);
  *P5 = L34;
  ATTACH(L34);
if(DecrRefs(L32)<0)
XD_Manalyzer_T46(L32);
  *P4 = L35;
  return 1;
LAB1054:
if(DecrRefs(L30)<0)
XD_Manalyzer_T51(L30);
  return 0;
LAB1058:
if(DecrRefs(L32)<0)
XD_Manalyzer_T46(L32);
if(DecrRefs(L31)<0)
XD_Manalyzer_T46(L31);
  Abort(1474, module_name);
  return 0;
LAB1040:
  return 0;
LAB1059:
  L45 = L1;
  L46 = L2;
  L47 = L3;
  switch (Alternative(L45)) {
  case 0: goto LAB1883;
  default: goto LAB1886;
  };
LAB1883:
  L48 = (value)(L45[1]);
  L49 = (value)(L45[2]);
  if (!Manalyzer_P_match_TYPEALTERNATIVE_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(L48,L49,L46,L47,&L50,&L51)) goto LAB1063;
  Create(&L52,4,2);
  *(value *)(L52+1) = L50;
  *(value *)(L52+2) = L51;
  L36 = L52;
  goto LAB1882;
LAB1886:
  switch (Alternative(L46)) {
  case 2: goto LAB1888;
  default: goto LAB1063;
  };
LAB1888:
  L53 = G_analyzer_STRUCTURE_NR3117;
  L36 = L53;
  ATTACH(L53);
LAB1882:
  L37 = G_analyzer_STRUCTURE_NR3116;
  *P5 = L36;
  *P4 = L37;
  ATTACH(L37);
  return 1;
LAB1063:
  return 0;
LAB1061:
  Abort(1480, module_name);
}

int Manalyzer_P_match_REST_EXPRESSION_LENGTH_STRUCTURE(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L0)) {
  case 0: goto LAB1064;
  default: goto LAB1066;
  };
LAB1064:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  if (!Manalyzer_P_match_TYPEALTERNATIVE_REST_EXPRESSION_LENGTH_STRUCTURE_STRUCTURE(L3,L4,L1,L2,&L5,&L6)) goto LAB1068;
  Create(&L7,4,2);
  *(value *)(L7+1) = L5;
  *(value *)(L7+2) = L6;
  *P3 = L7;
  return 1;
LAB1068:
  return 0;
LAB1066:
  switch (Alternative(L1)) {
  case 2: goto LAB1069;
  default: goto LAB1071;
  };
LAB1069:
  L8 = G_analyzer_STRUCTURE_NR3117;
  *P3 = L8;
  ATTACH(L8);
  return 1;
LAB1071:
  return 0;
}

int Manalyzer_P_match_STRICT_TYPENR_SUBEXPRESSION_STRUCTURE(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value *P3;
{
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
LAB1868:
  switch (Alternative(L2)) {
  case 2: goto LAB1072;
  case 4: goto LAB1083;
  case 1: goto LAB1086;
  case 0: goto LAB1104;
  case 3: goto LAB1111;
  case 5: goto LAB1124;
  case 6: goto LAB1129;
  default: goto LAB1131;
  };
LAB1072:
  L3 = (value)(L2[1]);
  switch (Alternative(L3)) {
  case 1: goto LAB1075;
  default: goto LAB1077;
  };
LAB1075:
  L4 = (value)(L3[1]);
  L5 = (value)(L3[2]);
  switch (Alternative(L5)) {
  case 2: goto LAB1078;
  default: goto LAB1077;
  };
LAB1078:
  L2 = L4;
  goto LAB1868;
LAB1077:
  return 0;
LAB1083:
  L7 = (value)(L2[1]);
  return 0;
LAB1086:
  L8 = (value)(L2[1]);
  L9 = (value)(L2[2]);
  L10 = (value)(L2[3]);
  if (!Mtypes_P_is_integer_type_TYPENR(L1)) goto LAB1090;
  Mtypes_P_integer_type_TYPENR(&L11);
  L12 = G_analyzer_STRICT_NR3118;
  if (!Manalyzer_P_match_STRICT_TYPENR_SUBEXPRESSION_STRUCTURE(L12,L11,L8,&L13)) goto LAB1092;
if(DecrRefs(L13)<0)
XD_Manalyzer_T46(L13);
  L14 = G_analyzer_STRICT_NR3119;
  if (!Manalyzer_P_match_STRICT_TYPENR_SUBEXPRESSION_STRUCTURE(L14,L11,L10,&L15)) goto LAB1092;
if(DecrRefs(L15)<0)
XD_Manalyzer_T46(L15);
  Create(&L16,2,1);
  *(value *)(L16+1) = L2;
  ATTACH(L2);
  *P3 = L16;
  return 1;
LAB1092:
  return 0;
LAB1090:
  if (!Mtypes_P_is_text_type_TYPENR(L1)) goto LAB1096;
  switch (Alternative(L9)) {
  case 5: goto LAB1097;
  default: goto LAB1099;
  };
LAB1097:
  Mtypes_P_text_type_TYPENR(&L17);
  L18 = G_analyzer_STRICT_NR3120;
  if (!Manalyzer_P_match_STRICT_TYPENR_SUBEXPRESSION_STRUCTURE(L18,L17,L8,&L19)) goto LAB1100;
  L20 = G_analyzer_STRICT_NR3121;
  if (!Manalyzer_P_match_STRICT_TYPENR_SUBEXPRESSION_STRUCTURE(L20,L17,L10,&L21)) goto LAB1102;
  Create(&L22,3,2);
  *(value *)(L22+1) = L19;
  *(value *)(L22+2) = L21;
  *P3 = L22;
  return 1;
LAB1100:
  return 0;
LAB1102:
if(DecrRefs(L19)<0)
XD_Manalyzer_T46(L19);
  return 0;
LAB1099:
  return 0;
LAB1096:
  return 0;
LAB1104:
  L23 = (value)(L2[1]);
  L24 = (value)(L2[2]);
  if (!Mtypes_P_is_integer_type_TYPENR(L1)) goto LAB1108;
  Mtypes_P_integer_type_TYPENR(&L25);
  L26 = G_analyzer_STRICT_NR3122;
  if (!Manalyzer_P_match_STRICT_TYPENR_SUBEXPRESSION_STRUCTURE(L26,L25,L24,&L27)) goto LAB1110;
if(DecrRefs(L27)<0)
XD_Manalyzer_T46(L27);
  Create(&L28,2,1);
  *(value *)(L28+1) = L2;
  ATTACH(L2);
  *P3 = L28;
  return 1;
LAB1110:
  return 0;
LAB1108:
  return 0;
LAB1111:
  L29 = (value)(L2[1]);
  Manalyzer_P_variable_type_VARIABLE_TYPENR(L29,&L30);
  switch (Alternative(L0)) {
  case 0: goto LAB1114;
  case 1: goto LAB1119;
  default: goto LAB1121;
  };
LAB1114:
  Manalyzer_P_base_type_TYPENR_TYPENR(L30,&L31);
  if (!Mtypes_P_equal_types_TYPENR_TYPENR(L1,L31)) goto LAB1118;
  Create(&L32,2,1);
  *(value *)(L32+1) = L2;
  ATTACH(L2);
  *P3 = L32;
  return 1;
LAB1118:
  return 0;
LAB1119:
  if (!Mtypes_P_equal_types_TYPENR_TYPENR(L1,L30)) goto LAB1123;
  Create(&L33,2,1);
  *(value *)(L33+1) = L2;
  ATTACH(L2);
  *P3 = L33;
  return 1;
LAB1123:
  return 0;
LAB1121:
  Abort(1530, module_name);
LAB1124:
  L34 = (value)(L2[1]);
  if (!Mtypes_P_is_integer_type_TYPENR(L1)) goto LAB1128;
  Create(&L35,2,1);
  *(value *)(L35+1) = L2;
  ATTACH(L2);
  *P3 = L35;
  return 1;
LAB1128:
  return 0;
LAB1129:
  L36 = (value)(L2[1]);
  if (!Mtypes_P_is_text_type_TYPENR(L1)) goto LAB1133;
  Create(&L37,2,1);
  *(value *)(L37+1) = L2;
  ATTACH(L2);
  *P3 = L37;
  return 1;
LAB1133:
  return 0;
LAB1131:
  Abort(1539, module_name);
}

int Manalyzer_P_variable_type_VARIABLE_TYPENR(P0,P1)
value P0;
value *P1;
{
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB1134;
  case 1: goto LAB1139;
  case 2: goto LAB1142;
  case 3: goto LAB1145;
  default: goto LAB1147;
  };
LAB1134:
  L1 = (value)(L0[1]);
  Manalyzer_P_variable_type_VARIABLE_TYPENR(L1,&L2);
  if (!Manalyzer_P_is_abstract_synonym_TYPENR_TYPENR(L2,&L3)) goto LAB1138;
  *P1 = L3;
  return 1;
LAB1138:
  *P1 = L2;
  return 1;
LAB1139:
  L4 = (value)(L0[1]);
  *P1 = L4;
  return 1;
LAB1142:
  L5 = (value)(L0[1]);
  Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE(L5,&L6,&L7,&L8,&L9);
if(DecrRefs(L9)<0)
XD_Mvariables_T9(L9);
if(DecrRefs(L8)<0)
XD_Mvariables_T8(L8);
  *P1 = L7;
  return 1;
LAB1145:
  L10 = (value)(L0[1]);
  L11 = (value)(L0[2]);
  Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE(L10,&L12,&L13,&L14,&L15);
if(DecrRefs(L15)<0)
XD_Mvariables_T9(L15);
if(DecrRefs(L14)<0)
XD_Mvariables_T8(L14);
  *P1 = L13;
  return 1;
LAB1147:
  Abort(1551, module_name);
}

int Manalyzer_P_code_preludes_MODULEORDER_RULENRS(P0,P1)
value P0;
value P1;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1784:
  switch (Alternative(L0)) {
  case 0: goto LAB1159;
  default: goto LAB1161;
  };
LAB1159:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  Manalyzer_P_code_preludes_MODULENR_RULENRS(L2,L1);
  L0 = L3;
  goto LAB1784;
LAB1161:
  return 1;
}

int Manalyzer_P_code_preludes_MODULENR_RULENRS(P0,P1)
value P0;
value P1;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1783:
  switch (Alternative(L1)) {
  case 0: goto LAB1162;
  default: goto LAB1164;
  };
LAB1162:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  Mrules_P_get_RULENR_MODULENR(L2,&L4);
  if (!(L0 == L4)) goto LAB1166;
  Create(&L5,11,2);
  *(value *)(L5+1) = L2;
  L6 = G_analyzer_ADDRESSES_NR3127;
  *(value *)(L5+2) = L6;
  ATTACH(L6);
  Mcode_P_store_INSTRUCTION(L5);
if(DecrRefs(L5)<0)
XD_Mcode_T14(L5);
  L1 = L3;
  goto LAB1783;
LAB1166:
  L1 = L3;
  goto LAB1783;
LAB1164:
  return 1;
}

int Manalyzer_P_code_postludes_MODULEORDER_RULENRS(P0,P1)
value P0;
value P1;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1787:
  switch (Alternative(L0)) {
  case 0: goto LAB1167;
  default: goto LAB1169;
  };
LAB1167:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  Manalyzer_P_code_postludes_MODULENR_RULENRS(L2,L1);
  L0 = L3;
  goto LAB1787;
LAB1169:
  return 1;
}

int Manalyzer_P_code_postludes_MODULENR_RULENRS(P0,P1)
value P0;
value P1;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1786:
  switch (Alternative(L1)) {
  case 0: goto LAB1170;
  default: goto LAB1172;
  };
LAB1170:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  Mrules_P_get_RULENR_MODULENR(L2,&L4);
  if (!(L0 == L4)) goto LAB1174;
  Manalyzer_P_code_postludes_MODULENR_RULENRS(L0,L3);
  Create(&L5,11,2);
  *(value *)(L5+1) = L2;
  L6 = G_analyzer_ADDRESSES_NR3128;
  *(value *)(L5+2) = L6;
  ATTACH(L6);
  Mcode_P_store_INSTRUCTION(L5);
if(DecrRefs(L5)<0)
XD_Mcode_T14(L5);
  return 1;
LAB1174:
  L1 = L3;
  goto LAB1786;
LAB1172:
  return 1;
}

int Manalyzer_P_register_dependancy_OFFSET_ADDRESS(P0,P1)
value P0;
value P1;
{
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  switch (Alternative(L1)) {
  case 2: goto LAB1175;
  default: goto LAB1177;
  };
LAB1175:
  L2 = (value)(L1[1]);
  Create(&L3,0,2);
  *(value *)(L3+1) = L2;
  L4 = (value) Addr((value*)&G_analyzer_DEPENDS_NR18,Int(L0));
  L5 = *((value*)L4);
  ATTACH(L5);
  *(value *)(L3+2) = L5;
if(DecrRefs(*((value*)L4))<0)
XD_Manalyzer_T68(*((value*)L4));
  *((value *)L4) = L3;
  return 1;
LAB1177:
  L6 = G_analyzer_TEXT_NR3129;
  E10_write_TEXT(L6);
  E11_write_INT(L0);
  L7 = G_analyzer_TEXT_NR3130;
  E10_write_TEXT(L7);
  Mcode_P_write_ADDRESS(L1);
  L8 = G_analyzer_TEXT_NR3131;
  E10_write_TEXT(L8);
  return 1;
}

int Manalyzer_P_register_application_OFFSET_USE(P0,P1)
value P0;
value P1;
{
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Mcode_P_current_LOCATION(&L2);
  Create(&L3,0,3);
  *(value *)(L3+1) = L1;
  ATTACH(L1);
  *(value *)(L3+2) = L2;
  L4 = (value) Addr((value*)&G_analyzer_APPLICATIONS_NR19,Int(L0));
  L5 = *((value*)L4);
  ATTACH(L5);
  *(value *)(L3+3) = L5;
if(DecrRefs(*((value*)L4))<0)
XD_Manalyzer_T20(*((value*)L4));
  *((value *)L4) = L3;
  L6 = (value) Addr((value*)&G_analyzer_DEPENDS_NR18,Int(L0));
  L7 = *((value*)L6);
  ATTACH(L7);
  Manalyzer_P_register_application_OFFSETS_LOCATION(L7,L2);
if(DecrRefs(L7)<0)
XD_Manalyzer_T68(L7);
  L12 = L1;
  switch (Alternative(L12)) {
  case 2: goto LAB1908;
  case 6: goto LAB1908;
  case 3: goto LAB1915;
  case 7: goto LAB1908;
  default: goto LAB1179;
  };
LAB1915:
  L13 = (value)(L12[1]);
  L14 = (value)(L12[2]);
LAB1908:
  L8 = (value)G_analyzer_XYZZY_NR32;
  L9 = C_INT(1);
  L10 = C_INT(Int(L8) + Int(L9));
  G_analyzer_XYZZY_NR32 = (long)L10;
  L11 = G_analyzer_OFFSETS_NR3132;
  ATTACH(L11);
if(DecrRefs(*((value*)L6))<0)
XD_Manalyzer_T68(*((value*)L6));
  *((value *)L6) = L11;
  return 1;
LAB1179:
  return 1;
}

int Manalyzer_P_register_application_OFFSET_LOCATION(P0,P1)
value P0;
value P1;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Create(&L2,1,2);
  *(value *)(L2+1) = L1;
  L3 = (value) Addr((value*)&G_analyzer_APPLICATIONS_NR19,Int(L0));
  L4 = *((value*)L3);
  ATTACH(L4);
  *(value *)(L2+2) = L4;
if(DecrRefs(*((value*)L3))<0)
XD_Manalyzer_T20(*((value*)L3));
  *((value *)L3) = L2;
  L5 = (value) Addr((value*)&G_analyzer_DEPENDS_NR18,Int(L0));
  L6 = *((value*)L5);
  ATTACH(L6);
  Manalyzer_P_register_application_OFFSETS_LOCATION(L6,L1);
if(DecrRefs(L6)<0)
XD_Manalyzer_T68(L6);
  return 1;
}

int Manalyzer_P_register_application_ADDRESS_USE(P0,P1)
value P0;
value P1;
{
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Mcode_P_current_LOCATION(&L2);
  switch (Alternative(L0)) {
  case 2: goto LAB1192;
  default: goto LAB1194;
  };
LAB1192:
  L3 = (value)(L0[1]);
  Create(&L4,0,3);
  *(value *)(L4+1) = L1;
  ATTACH(L1);
  *(value *)(L4+2) = L2;
  L5 = (value) Addr((value*)&G_analyzer_APPLICATIONS_NR19,Int(L3));
  L6 = *((value*)L5);
  ATTACH(L6);
  *(value *)(L4+3) = L6;
if(DecrRefs(*((value*)L5))<0)
XD_Manalyzer_T20(*((value*)L5));
  *((value *)L5) = L4;
  L7 = (value) Addr((value*)&G_analyzer_DEPENDS_NR18,Int(L3));
  L8 = *((value*)L7);
  ATTACH(L8);
  Manalyzer_P_register_application_OFFSETS_LOCATION(L8,L2);
if(DecrRefs(L8)<0)
XD_Manalyzer_T68(L8);
  return 1;
LAB1194:
  Manalyzer_P_register_application_ADDRESS_LOCATION(L0,L2);
  return 1;
}

int Manalyzer_P_register_application_ADDRESS_LOCATION(P0,P1)
value P0;
value P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  switch (Alternative(L0)) {
  case 2: goto LAB1195;
  default: goto LAB1197;
  };
LAB1195:
  L2 = (value)(L0[1]);
  Manalyzer_P_register_application_OFFSET_LOCATION(L2,L1);
  return 1;
LAB1197:
  L3 = G_analyzer_TEXT_NR3133;
  E10_write_TEXT(L3);
  Mcode_P_write_ADDRESS(L0);
  L4 = G_analyzer_TEXT_NR3134;
  E10_write_TEXT(L4);
  E11_write_INT(L1);
  L5 = G_analyzer_TEXT_NR3135;
  E10_write_TEXT(L5);
  return 1;
}

int Manalyzer_P_register_application_without_attach_ADDRESS(P0)
value P0;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mcode_P_current_LOCATION(&L1);
  switch (Alternative(L0)) {
  case 2: goto LAB1198;
  default: goto LAB1200;
  };
LAB1198:
  L2 = (value)(L0[1]);
  Create(&L3,1,2);
  *(value *)(L3+1) = L1;
  L4 = (value) Addr((value*)&G_analyzer_APPLICATIONS_NR19,Int(L2));
  L5 = *((value*)L4);
  ATTACH(L5);
  *(value *)(L3+2) = L5;
if(DecrRefs(*((value*)L4))<0)
XD_Manalyzer_T20(*((value*)L4));
  *((value *)L4) = L3;
  L6 = (value) Addr((value*)&G_analyzer_DEPENDS_NR18,Int(L2));
  L7 = *((value*)L6);
  ATTACH(L7);
  Manalyzer_P_register_application_OFFSETS_LOCATION(L7,L1);
if(DecrRefs(L7)<0)
XD_Manalyzer_T68(L7);
  return 1;
LAB1200:
  Manalyzer_P_register_application_ADDRESS_LOCATION(L0,L1);
  return 1;
}

int Manalyzer_P_register_application_OFFSETS_LOCATION(P0,P1)
value P0;
value P1;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB1907:
  switch (Alternative(L0)) {
  case 1: goto LAB1201;
  case 0: goto LAB1204;
  default: goto LAB1206;
  };
LAB1201:
  return 1;
LAB1204:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  Manalyzer_P_register_application_OFFSET_LOCATION(L2,L1);
  L0 = L3;
  goto LAB1907;
LAB1206:
  Abort(1685, module_name);
}

int Manalyzer_P_register_assignment_OFFSET(P0)
value P0;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mcode_P_current_LOCATION(&L1);
  L2 = (value) Addr((value*)&G_analyzer_ASSIGNMENT_NR20,Int(L0));
  *((value *)L2) = L1;
  L3 = (value) Addr((value*)&G_analyzer_APPLICATIONS_NR19,Int(L0));
  L4 = *((value*)L3);
  ATTACH(L4);
  switch (Alternative(L4)) {
  case 3: goto LAB1207;
  default: goto LAB1208;
  };
LAB1207:
if(DecrRefs(L4)<0)
XD_Manalyzer_T20(L4);
  Create(&L5,2,2);
  *(value *)(L5+1) = L1;
  L6 = *((value*)L3);
  ATTACH(L6);
  *(value *)(L5+2) = L6;
if(DecrRefs(*((value*)L3))<0)
XD_Manalyzer_T20(*((value*)L3));
  *((value *)L3) = L5;
  return 1;
LAB1208:
if(DecrRefs(L4)<0)
XD_Manalyzer_T20(L4);
  Abort(1692, module_name);
  Abort(1692, module_name);
}

int Manalyzer_P_insert_detach_OFFSET_LOCATION_NUM_LEFT_IS_ALIVE(P0,P1,P2,P3)
value P0;
value P1;
value *P2;
value *P3;
{
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = *P2;
  L3 = *P3;
  switch (Alternative(L2)) {
  case 0: goto LAB1210;
  case 2: goto LAB1213;
  default: goto LAB1215;
  };
LAB1210:
if(DecrRefs(L3)<0)
XD_Manalyzer_T75(L3);
if(DecrRefs(L2)<0)
XD_Manalyzer_T61(L2);
  L4 = C_INT(666);
  L5 = G_analyzer_TEXT_NR3136;
  Mcode_P_dump_code_MODULENR_TEXT(L4,L5);
  L6 = G_analyzer_TEXT_NR3137;
  Merrors_P_error_text_TEXT(L6);
  Merrors_P_error_int_INT(L0);
  L7 = G_analyzer_TEXT_NR3138;
  Merrors_P_error_text_TEXT(L7);
  L8 = G_analyzer_TEXT_NR3139;
  Merrors_P_error_text_TEXT(L8);
  Merrors_P_error_int_INT(L1);
  L9 = G_analyzer_TEXT_NR3140;
  Merrors_P_error_text_TEXT(L9);
  Abort(1702, module_name);
LAB1213:
  L10 = L3;
  L13 = L0;
  L14 = L1;
  L15 = L10;
  switch (Alternative(L15)) {
  case 0: goto LAB2350;
  case 1: goto LAB2353;
  case 2: goto LAB2356;
  default: goto LAB2358;
  };
LAB2350:
  L10 = L15;
  goto LAB2349;
LAB2353:
if(DecrRefs(L15)<0)
XD_Manalyzer_T75(L15);
  Abort(2192, module_name);
LAB2356:
if(DecrRefs(L15)<0)
XD_Manalyzer_T75(L15);
  L16 = G_analyzer_IS_ALIVE_NR3194;
  Create(&L17,1,2);
  *(value *)(L17+1) = L14;
  L18 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L13));
  L19 = *((value*)L18);
  ATTACH(L19);
  *(value *)(L17+2) = L19;
if(DecrRefs(*((value*)L18))<0)
XD_Manalyzer_T29(*((value*)L18));
  *((value *)L18) = L17;
  L10 = L16;
  ATTACH(L16);
LAB2349:
  *P3 = L10;
  *P2 = L2;
  return 1;
LAB2358:
if(DecrRefs(L15)<0)
XD_Manalyzer_T75(L15);
  Abort(2196, module_name);
LAB1215:
if(DecrRefs(L2)<0)
XD_Manalyzer_T61(L2);
  L11 = L3;
  Manalyzer_P_insert_detach_OFFSET_LOCATION_IS_ALIVE(L0,L1,&L11);
  L12 = G_analyzer_NUM_LEFT_NR3141;
  *P3 = L11;
  *P2 = L12;
  ATTACH(L12);
  return 1;
}

int Manalyzer_P_insert_detach_OFFSET_LOCATION_IS_ALIVE(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = *P2;
LAB2369:
  L3 = C_INT(-1);
  if (!(L1 == L3)) goto LAB1217;
if(DecrRefs(L2)<0)
XD_Manalyzer_T75(L2);
  Abort(1713, module_name);
LAB1217:
  L4 = L1;
  if (!Mcode_P_next_LOCATION(&L4)) goto LAB1218;
  Mcode_P_get_LOCATION_INSTRUCTION(L4,&L5);
  switch (Alternative(L5)) {
  case 32: goto LAB1220;
  default: goto LAB1221;
  };
LAB1220:
  L6 = (value)(L5[1]);
  L7 = (value)(L5[2]);
if(DecrRefs(L5)<0)
XD_Mcode_T14(L5);
  L8 = L2;
  L2 = L8;
  L1 = L4;
  goto LAB2369;
LAB1218:
  goto LAB1219;
LAB1221:
if(DecrRefs(L5)<0)
XD_Mcode_T14(L5);
LAB1219:
  L9 = (value) Addr((value*)&G_analyzer_OFFSET_TYPES_NR4,Int(L0));
  L10 = *((value*)L9);
  if (!Manalyzer_P_need_attaches_TYPENR(L10)) goto LAB1223;
  Create(&L11,33,2);
  Create(&L12,2,1);
  *(value *)(L12+1) = L0;
  *(value *)(L11+1) = L12;
  L13 = *((value*)L9);
  *(value *)(L11+2) = L13;
  Mcode_P_append_LOCATION_INSTRUCTION(L1,L11);
if(DecrRefs(L11)<0)
XD_Mcode_T14(L11);
  L14 = L2;
  Manalyzer_P_register_death_OFFSET_IS_ALIVE(L0,&L14);
  *P2 = L14;
  return 1;
LAB1223:
LAB1224:
  L15 = L2;
  L16 = L0;
  L17 = L1;
  L18 = L15;
  switch (Alternative(L18)) {
  case 0: goto LAB2360;
  case 1: goto LAB2363;
  case 2: goto LAB2366;
  default: goto LAB2368;
  };
LAB2360:
  L15 = L18;
  goto LAB2359;
LAB2363:
if(DecrRefs(L18)<0)
XD_Manalyzer_T75(L18);
  Abort(2192, module_name);
LAB2366:
if(DecrRefs(L18)<0)
XD_Manalyzer_T75(L18);
  L19 = G_analyzer_IS_ALIVE_NR3194;
  Create(&L20,1,2);
  *(value *)(L20+1) = L17;
  L21 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L16));
  L22 = *((value*)L21);
  ATTACH(L22);
  *(value *)(L20+2) = L22;
if(DecrRefs(*((value*)L21))<0)
XD_Manalyzer_T29(*((value*)L21));
  *((value *)L21) = L20;
  L15 = L19;
  ATTACH(L19);
LAB2359:
  *P2 = L15;
  return 1;
LAB2368:
if(DecrRefs(L18)<0)
XD_Manalyzer_T75(L18);
  Abort(2196, module_name);
}

int Manalyzer_P_insert_detach_OFFSET_LOCATION_LOCATION(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB2212:
  L2 = C_INT(-1);
  if (!(L1 == L2)) goto LAB1226;
  Abort(1725, module_name);
LAB1226:
  L3 = L1;
  if (!Mcode_P_next_LOCATION(&L3)) goto LAB1227;
  Mcode_P_get_LOCATION_INSTRUCTION(L3,&L4);
  switch (Alternative(L4)) {
  case 32: goto LAB1229;
  default: goto LAB1230;
  };
LAB1229:
  L5 = (value)(L4[1]);
  L6 = (value)(L4[2]);
if(DecrRefs(L4)<0)
XD_Mcode_T14(L4);
  L1 = L3;
  goto LAB2212;
LAB1227:
  goto LAB1228;
LAB1230:
if(DecrRefs(L4)<0)
XD_Mcode_T14(L4);
LAB1228:
  Create(&L8,33,2);
  Create(&L9,2,1);
  *(value *)(L9+1) = L0;
  *(value *)(L8+1) = L9;
  L10 = (value) Addr((value*)&G_analyzer_OFFSET_TYPES_NR4,Int(L0));
  L11 = *((value*)L10);
  *(value *)(L8+2) = L11;
  Mcode_P_append_LOCATION_INSTRUCTION(L1,L8);
if(DecrRefs(L8)<0)
XD_Mcode_T14(L8);
  Mcode_P_current_LOCATION(&L12);
  *P2 = L12;
  return 1;
}

int Manalyzer_P_determine_creation_state_ORIGIN_NUM_LEFT(P0,P1)
value P0;
value *P1;
{
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB1232;
  case 8: goto LAB1235;
  case 1: goto LAB1242;
  case 2: goto LAB1245;
  case 12: goto LAB1248;
  case 5: goto LAB1251;
  case 10: goto LAB1254;
  case 3: goto LAB1257;
  case 9: goto LAB1260;
  case 6: goto LAB1263;
  case 4: goto LAB1266;
  case 11: goto LAB1269;
  default: goto LAB1271;
  };
LAB1232:
  L1 = G_analyzer_NUM_LEFT_NR3142;
  *P1 = L1;
  ATTACH(L1);
  return 1;
LAB1235:
  L2 = (value)(L0[1]);
  L3 = (value)G_analyzer_NR_GLOBALS_NR24;
  L4 = C_INT(1);
  L5 = C_INT(Int(L3) + Int(L4));
  G_analyzer_NR_GLOBALS_NR24 = (long)L5;
  L6 = (value)G_analyzer_CURRENT_RULE_NR7;
  if (!Minline_P_rule_changes_global_RULENR_VARIABLENR(L6,L2)) goto LAB1238;
  L7 = G_analyzer_NUM_LEFT_NR3143;
  *P1 = L7;
  ATTACH(L7);
  return 1;
LAB1238:
LAB1239:
  L8 = (value)G_analyzer_CURRENT_RULE_NR7;
  if (!Minline_P_call_changes_global_RULENR_VARIABLENR(L8,L2)) goto LAB1240;
  L9 = G_analyzer_NUM_LEFT_NR3144;
  *P1 = L9;
  ATTACH(L9);
  return 1;
LAB1240:
LAB1241:
  L10 = (value)G_analyzer_GLOBALS_REM_NR25;
  L11 = C_INT(1);
  L12 = C_INT(Int(L10) + Int(L11));
  G_analyzer_GLOBALS_REM_NR25 = (long)L12;
  L13 = G_analyzer_NUM_LEFT_NR3145;
  *P1 = L13;
  ATTACH(L13);
  return 1;
LAB1242:
  L14 = G_analyzer_NUM_LEFT_NR3146;
  *P1 = L14;
  ATTACH(L14);
  return 1;
LAB1245:
  L15 = G_analyzer_NUM_LEFT_NR3147;
  *P1 = L15;
  ATTACH(L15);
  return 1;
LAB1248:
  L16 = (value)(L0[1]);
  Manalyzer_P_determine_creation_state_ORIGIN_NUM_LEFT(L16,&L17);
if(DecrRefs(L17)<0)
XD_Manalyzer_T61(L17);
  Abort(1750, module_name);
LAB1251:
  L18 = G_analyzer_NUM_LEFT_NR3148;
  *P1 = L18;
  ATTACH(L18);
  return 1;
LAB1254:
  L19 = G_analyzer_NUM_LEFT_NR3149;
  *P1 = L19;
  ATTACH(L19);
  return 1;
LAB1257:
  L20 = G_analyzer_NUM_LEFT_NR3150;
  *P1 = L20;
  ATTACH(L20);
  return 1;
LAB1260:
  L21 = G_analyzer_NUM_LEFT_NR3151;
  *P1 = L21;
  ATTACH(L21);
  return 1;
LAB1263:
  L22 = G_analyzer_NUM_LEFT_NR3152;
  *P1 = L22;
  ATTACH(L22);
  return 1;
LAB1266:
  L23 = G_analyzer_NUM_LEFT_NR3153;
  *P1 = L23;
  ATTACH(L23);
  return 1;
LAB1269:
  L24 = G_analyzer_NUM_LEFT_NR3154;
  *P1 = L24;
  ATTACH(L24);
  return 1;
LAB1271:
  Abort(1758, module_name);
}

int Manalyzer_P_handle_control_blocks_OFFSET_MEM_CONTEXT_LEFTOVER_ALIVE(P0,P1,P2,P3)
value P0;
value P1;
value *P2;
value *P3;
{
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = *P2;
  L3 = *P3;
  switch (Alternative(L1)) {
  case 1: goto LAB1272;
  case 0: goto LAB1275;
  default: goto LAB1276;
  };
LAB1272:
  *P3 = L3;
  *P2 = L2;
  return 1;
LAB1275:
  L4 = (value)(L1[1]);
  L5 = (value)(L1[2]);
  L6 = L3;
  L18 = L6;
  switch (Alternative(L18)) {
  case 1: goto LAB2304;
  case 0: goto LAB2307;
  default: goto LAB2309;
  };
LAB2304:
  L19 = G_analyzer_IS_ALIVE_NR3193;
  L7 = L19;
  ATTACH(L19);
  L6 = L18;
  goto LAB2303;
LAB2307:
  L20 = (value)(L18[1]);
  L21 = (value)(L18[2]);
  L7 = L20;
  ATTACH(L20);
  L6 = L21;
  ATTACH(L21);
if(DecrRefs(L18)<0)
XD_Manalyzer_T76(L18);
LAB2303:
  switch (Alternative(L2)) {
  case 0: goto LAB1278;
  default: goto LAB1279;
  };
LAB2309:
if(DecrRefs(L18)<0)
XD_Manalyzer_T76(L18);
  Abort(2188, module_name);
LAB1278:
  L8 = (value)(L2[1]);
  L9 = (value)(L2[2]);
  L10 = L8;
  ATTACH(L10);
  L11 = L7;
  Manalyzer_P_handle_control_block_OFFSET_APPLICATIONS_NUM_LEFT_IS_ALIVE(L0,L4,&L10,&L11);
  L12 = C_INT(1);
  L13 = C_INT(Int(L0) + Int(L12));
  L14 = L9;
  ATTACH(L14);
if(DecrRefs(L2)<0)
XD_Manalyzer_T70(L2);
  L15 = L6;
  Manalyzer_P_handle_control_blocks_OFFSET_MEM_CONTEXT_LEFTOVER_ALIVE(L13,L5,&L14,&L15);
  Create(&L16,0,2);
  *(value *)(L16+1) = L11;
  *(value *)(L16+2) = L15;
  Create(&L17,0,2);
  *(value *)(L17+1) = L10;
  *(value *)(L17+2) = L14;
  *P3 = L16;
  *P2 = L17;
  return 1;
LAB1276:
if(DecrRefs(L3)<0)
XD_Manalyzer_T76(L3);
  goto LAB1277;
LAB1279:
if(DecrRefs(L7)<0)
XD_Manalyzer_T75(L7);
if(DecrRefs(L6)<0)
XD_Manalyzer_T76(L6);
LAB1277:
if(DecrRefs(L2)<0)
XD_Manalyzer_T70(L2);
  Abort(1772, module_name);
}

int Manalyzer_P_handle_control_block_OFFSET_APPLICATIONS_NUM_LEFT_IS_ALIVE(P0,P1,P2,P3)
value P0;
value P1;
value *P2;
value *P3;
{
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = *P2;
  L3 = *P3;
LAB2434:
  switch (Alternative(L1)) {
  case 3: goto LAB1281;
  case 0: goto LAB1284;
  case 1: goto LAB1287;
  case 2: goto LAB1290;
  default: goto LAB1292;
  };
LAB1281:
  *P3 = L3;
  *P2 = L2;
  return 1;
LAB1284:
  L4 = (value)(L1[1]);
  L5 = (value)(L1[2]);
  L6 = (value)(L1[3]);
  L7 = L2;
  L8 = L3;
  L25 = L0;
  L26 = L5;
  L27 = L7;
  L28 = L4;
  L29 = L8;
  switch (Alternative(L28)) {
  case 2: goto LAB2371;
  case 6: goto LAB2374;
  case 3: goto LAB2377;
  case 7: goto LAB2401;
  case 0: goto LAB2404;
  default: goto LAB2406;
  };
LAB2371:
  L30 = L27;
  L31 = L29;
  Manalyzer_P_insert_attach_OFFSET_LOCATION_NUM_LEFT_IS_ALIVE(L25,L26,&L30,&L31);
  L8 = L31;
  L7 = L30;
  goto LAB2370;
LAB2374:
  L32 = L27;
  L33 = L29;
  Manalyzer_P_insert_attach_OFFSET_LOCATION_NUM_LEFT_IS_ALIVE(L25,L26,&L32,&L33);
  L8 = L33;
  L7 = L32;
  goto LAB2370;
LAB2377:
  L34 = (value)(L28[1]);
  L35 = (value)(L28[2]);
  if (!Manalyzer_P_need_attaches_TYPENR(L35)) goto LAB2400;
  L36 = L27;
  L46 = L25;
  L47 = L26;
  L48 = L36;
  switch (Alternative(L48)) {
  case 0: goto LAB2380;
  case 2: goto LAB2383;
  default: goto LAB2387;
  };
LAB2380:
if(DecrRefs(L48)<0)
XD_Manalyzer_T61(L48);
  Abort(1860, module_name);
LAB2383:
  L49 = (value) Addr((value*)&G_analyzer_OFFSET_TYPES_NR4,Int(L46));
  L50 = *((value*)L49);
  if (!Manalyzer_P_need_attaches_TYPENR(L50)) goto LAB2385;
  Create(&L51,32,2);
  Create(&L52,2,1);
  *(value *)(L52+1) = L46;
  *(value *)(L51+1) = L52;
  L53 = *((value*)L49);
  *(value *)(L51+2) = L53;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L47,L51);
if(DecrRefs(L51)<0)
XD_Mcode_T14(L51);
  L36 = L48;
  goto LAB2386;
LAB2385:
LAB2388:
  L36 = L48;
  goto LAB2386;
LAB2387:
if(DecrRefs(L48)<0)
XD_Manalyzer_T61(L48);
  L54 = G_analyzer_NUM_LEFT_NR3156;
  L36 = L54;
  ATTACH(L54);
LAB2386:
  Create(&L37,33,2);
  *(value *)(L37+1) = L34;
  ATTACH(L34);
  *(value *)(L37+2) = L35;
  Mcode_P_prepend_LOCATION_INSTRUCTION(L26,L37);
if(DecrRefs(L37)<0)
XD_Mcode_T14(L37);
  L38 = L29;
  L55 = L25;
  L56 = L26;
  L57 = L38;
  switch (Alternative(L57)) {
  case 0: goto LAB2389;
  case 1: goto LAB2393;
  case 2: goto LAB2396;
  default: goto LAB2398;
  };
LAB2389:
  L38 = L57;
  goto LAB2391;
LAB2393:
if(DecrRefs(L57)<0)
XD_Manalyzer_T75(L57);
  Abort(2192, module_name);
LAB2396:
if(DecrRefs(L57)<0)
XD_Manalyzer_T75(L57);
  L58 = G_analyzer_IS_ALIVE_NR3194;
  Create(&L59,1,2);
  *(value *)(L59+1) = L56;
  L60 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L55));
  L61 = *((value*)L60);
  ATTACH(L61);
  *(value *)(L59+2) = L61;
if(DecrRefs(*((value*)L60))<0)
XD_Manalyzer_T29(*((value*)L60));
  *((value *)L60) = L59;
  L38 = L58;
  ATTACH(L58);
LAB2391:
  L8 = L38;
  L7 = L36;
  goto LAB2370;
LAB2398:
if(DecrRefs(L57)<0)
XD_Manalyzer_T75(L57);
  Abort(2196, module_name);
LAB2400:
  L39 = L27;
  L40 = L29;
  Manalyzer_P_insert_attach_OFFSET_LOCATION_NUM_LEFT_IS_ALIVE(L25,L26,&L39,&L40);
  L8 = L40;
  L7 = L39;
  goto LAB2370;
LAB2401:
  L41 = L27;
  L42 = L29;
  Manalyzer_P_insert_attach_OFFSET_LOCATION_NUM_LEFT_IS_ALIVE(L25,L26,&L41,&L42);
  L8 = L42;
  L7 = L41;
  goto LAB2370;
LAB2404:
if(DecrRefs(L29)<0)
XD_Manalyzer_T75(L29);
if(DecrRefs(L27)<0)
XD_Manalyzer_T61(L27);
  L43 = (value)(L28[1]);
  Merrors_P_error_int_INT(L43);
  Abort(1856, module_name);
LAB2406:
  L44 = L27;
  L45 = L29;
  Manalyzer_P_insert_detach_OFFSET_LOCATION_NUM_LEFT_IS_ALIVE(L25,L26,&L44,&L45);
  L8 = L45;
  L7 = L44;
LAB2370:
  L9 = L7;
  L10 = L8;
  L3 = L10;
  L2 = L9;
  L1 = L6;
  goto LAB2434;
LAB1287:
  L11 = (value)(L1[1]);
  L12 = (value)(L1[2]);
  L13 = L2;
  L14 = L3;
  Manalyzer_P_insert_detach_OFFSET_LOCATION_NUM_LEFT_IS_ALIVE(L0,L11,&L13,&L14);
  L15 = L13;
  L16 = L14;
  L3 = L16;
  L2 = L15;
  L1 = L12;
  goto LAB2434;
LAB1290:
  L17 = (value)(L1[1]);
  L18 = (value)(L1[2]);
  L19 = (value) Addr((value*)&G_analyzer_ORIGINS_NR17,Int(L0));
  L20 = *((value*)L19);
  ATTACH(L20);
  L21 = L2;
  L22 = L3;
  Manalyzer_P_handle_creation_control_ORIGIN_LOCATION_OFFSET_NUM_LEFT_IS_ALIVE(L20,L17,L0,&L21,&L22);
if(DecrRefs(L20)<0)
XD_Manalyzer_T65(L20);
  L23 = L21;
  L24 = L22;
  L3 = L24;
  L2 = L23;
  L1 = L18;
  goto LAB2434;
LAB1292:
if(DecrRefs(L3)<0)
XD_Manalyzer_T75(L3);
if(DecrRefs(L2)<0)
XD_Manalyzer_T61(L2);
  Abort(1785, module_name);
}

int Manalyzer_P_handle_creation_control_ORIGIN_LOCATION_OFFSET_NUM_LEFT_IS_ALIVE(P0,P1,P2,P3,P4)
value P0;
value P1;
value P2;
value *P3;
value *P4;
{
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = *P3;
  L4 = *P4;
LAB2433:
  switch (Alternative(L0)) {
  case 12: goto LAB1293;
  default: goto LAB1295;
  };
LAB1293:
  L5 = (value)(L0[1]);
  L6 = L3;
  L7 = L4;
  L4 = L7;
  L3 = L6;
  L0 = L5;
  goto LAB2433;
LAB1295:
  switch (Alternative(L4)) {
  case 0: goto LAB1296;
  default: goto LAB1298;
  };
LAB1296:
  L8 = L3;
  L9 = L4;
  Manalyzer_P_insert_detach_OFFSET_LOCATION_NUM_LEFT_IS_ALIVE(L2,L1,&L8,&L9);
if(DecrRefs(L9)<0)
XD_Manalyzer_T75(L9);
  L10 = G_analyzer_IS_ALIVE_NR3155;
  L11 = (value) Addr((value*)&G_analyzer_BIRTH_NR27,Int(L2));
  *((value *)L11) = L1;
  switch (Alternative(L0)) {
  case 8: goto LAB1299;
  case 2: goto LAB1308;
  default: goto LAB1310;
  };
LAB1299:
  L12 = (value)(L0[1]);
  L13 = (value) Addr((value*)&G_analyzer_OFFSET_TYPES_NR4,Int(L2));
  L14 = *((value*)L13);
  if (!Manalyzer_P_need_attaches_TYPENR(L14)) goto LAB1302;
  L15 = (value)G_analyzer_CURRENT_RULE_NR7;
  if (!Minline_P_rule_changes_global_RULENR_VARIABLENR(L15,L12)) goto LAB1304;
  Create(&L16,32,2);
  Create(&L17,2,1);
  *(value *)(L17+1) = L2;
  *(value *)(L16+1) = L17;
  L18 = *((value*)L13);
  *(value *)(L16+2) = L18;
  Mcode_P_append_LOCATION_INSTRUCTION(L1,L16);
if(DecrRefs(L16)<0)
XD_Mcode_T14(L16);
  *P4 = L10;
  ATTACH(L10);
  *P3 = L8;
  return 1;
LAB1302:
LAB1303:
  *P4 = L10;
  ATTACH(L10);
  *P3 = L8;
  return 1;
LAB1304:
LAB1305:
  L19 = (value)G_analyzer_CURRENT_RULE_NR7;
  if (!Minline_P_call_changes_global_RULENR_VARIABLENR(L19,L12)) goto LAB1306;
  Create(&L20,32,2);
  Create(&L21,2,1);
  *(value *)(L21+1) = L2;
  *(value *)(L20+1) = L21;
  L22 = *((value*)L13);
  *(value *)(L20+2) = L22;
  Mcode_P_append_LOCATION_INSTRUCTION(L1,L20);
if(DecrRefs(L20)<0)
XD_Mcode_T14(L20);
  *P4 = L10;
  ATTACH(L10);
  *P3 = L8;
  return 1;
LAB1306:
LAB1307:
  *P4 = L10;
  ATTACH(L10);
  *P3 = L8;
  return 1;
LAB1308:
  L23 = (value) Addr((value*)&G_analyzer_OFFSET_TYPES_NR4,Int(L2));
  L24 = *((value*)L23);
  if (!Manalyzer_P_need_attaches_TYPENR(L24)) goto LAB1311;
  L25 = *((value*)L23);
  L29 = L1;
  L30 = L2;
  L31 = L25;
  Mcode_P_get_LOCATION_INSTRUCTION(L29,&L32);
  switch (Alternative(L32)) {
  case 27: goto LAB2409;
  default: goto LAB2410;
  };
LAB2409:
  L33 = (value)(L32[1]);
  L34 = (value)(L32[2]);
  L35 = (value)(L32[3]);
  switch (Alternative(L33)) {
  case 2: goto LAB2411;
  default: goto LAB2412;
  };
LAB2411:
  L36 = (value)(L33[1]);
  switch (Alternative(L35)) {
  case 2: goto LAB2413;
  default: goto LAB2414;
  };
LAB2413:
  L37 = (value)(L35[1]);
  if (!(L37 == L30)) goto LAB2415;
  Mcode_P_next_LOCATION_LOCATION(L29,&L38);
  Mcode_P_get_LOCATION_INSTRUCTION(L38,&L39);
  switch (Alternative(L39)) {
  case 33: goto LAB2416;
  default: goto LAB2417;
  };
LAB2416:
  L40 = (value)(L39[1]);
  L41 = (value)(L39[2]);
  switch (Alternative(L40)) {
  case 2: goto LAB2418;
  default: goto LAB2419;
  };
LAB2418:
  L42 = (value)(L40[1]);
  if (!(L36 == L42)) goto LAB2420;
  if (!(L31 == L34)) goto LAB2421;
if(DecrRefs(L32)<0)
XD_Mcode_T14(L32);
  if (!(L31 == L41)) goto LAB2422;
  L43 = L42;
  L44 = L38;
  L45 = L29;
  L46 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L43));
  L47 = *((value*)L46);
  ATTACH(L47);
  L48 = L47;
  Manalyzer_P_replace_death_DEATH_LOCATION_LOCATION(&L48,L44,L45);
if(DecrRefs(*((value*)L46))<0)
XD_Manalyzer_T29(*((value*)L46));
  *((value *)L46) = L48;
LAB2423:
if(DecrRefs(L39)<0)
XD_Mcode_T14(L39);
  Mcode_P_delete_LOCATION(L38);
LAB2408:
  *P4 = L10;
  ATTACH(L10);
  *P3 = L8;
  return 1;
LAB2410:
if(DecrRefs(L32)<0)
XD_Mcode_T14(L32);
  goto LAB1313;
LAB2412:
if(DecrRefs(L32)<0)
XD_Mcode_T14(L32);
  goto LAB1313;
LAB2414:
if(DecrRefs(L32)<0)
XD_Mcode_T14(L32);
  goto LAB1313;
LAB2415:
if(DecrRefs(L32)<0)
XD_Mcode_T14(L32);
  goto LAB1313;
LAB2417:
if(DecrRefs(L39)<0)
XD_Mcode_T14(L39);
if(DecrRefs(L32)<0)
XD_Mcode_T14(L32);
  goto LAB1313;
LAB2419:
if(DecrRefs(L39)<0)
XD_Mcode_T14(L39);
if(DecrRefs(L32)<0)
XD_Mcode_T14(L32);
  goto LAB1313;
LAB2420:
if(DecrRefs(L39)<0)
XD_Mcode_T14(L39);
if(DecrRefs(L32)<0)
XD_Mcode_T14(L32);
  goto LAB1313;
LAB2421:
if(DecrRefs(L39)<0)
XD_Mcode_T14(L39);
  goto LAB1313;
LAB2422:
if(DecrRefs(L39)<0)
XD_Mcode_T14(L39);
LAB1313:
LAB1314:
  Create(&L26,32,2);
  Create(&L27,2,1);
  *(value *)(L27+1) = L2;
  *(value *)(L26+1) = L27;
  L28 = *((value*)L23);
  *(value *)(L26+2) = L28;
  Mcode_P_append_LOCATION_INSTRUCTION(L1,L26);
if(DecrRefs(L26)<0)
XD_Mcode_T14(L26);
  *P4 = L10;
  ATTACH(L10);
  *P3 = L8;
  return 1;
LAB1311:
LAB1312:
  *P4 = L10;
  ATTACH(L10);
  *P3 = L8;
  return 1;
LAB1310:
  *P4 = L10;
  ATTACH(L10);
  *P3 = L8;
  return 1;
LAB1298:
  *P4 = L4;
  *P3 = L3;
  return 1;
}

int Manalyzer_P_insert_attach_OFFSET_LOCATION_NUM_LEFT_IS_ALIVE(P0,P1,P2,P3)
value P0;
value P1;
value *P2;
value *P3;
{
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = *P2;
  L3 = *P3;
  switch (Alternative(L2)) {
  case 0: goto LAB1363;
  case 2: goto LAB1366;
  default: goto LAB1368;
  };
LAB1363:
if(DecrRefs(L3)<0)
XD_Manalyzer_T75(L3);
if(DecrRefs(L2)<0)
XD_Manalyzer_T61(L2);
  Abort(1868, module_name);
LAB1366:
  L4 = (value) Addr((value*)&G_analyzer_OFFSET_TYPES_NR4,Int(L0));
  L5 = *((value*)L4);
  if (!Manalyzer_P_need_attaches_TYPENR(L5)) goto LAB1369;
  Create(&L6,32,2);
  Create(&L7,2,1);
  *(value *)(L7+1) = L0;
  *(value *)(L6+1) = L7;
  L8 = *((value*)L4);
  *(value *)(L6+2) = L8;
  Mcode_P_append_LOCATION_INSTRUCTION(L1,L6);
if(DecrRefs(L6)<0)
XD_Mcode_T14(L6);
  L9 = L3;
  Manalyzer_P_register_death_OFFSET_IS_ALIVE(L0,&L9);
  *P3 = L9;
  *P2 = L2;
  return 1;
LAB1369:
LAB1370:
  L10 = L3;
  L13 = L0;
  L14 = L1;
  L15 = L10;
  switch (Alternative(L15)) {
  case 0: goto LAB2311;
  case 1: goto LAB2314;
  case 2: goto LAB2317;
  default: goto LAB2319;
  };
LAB2311:
  L10 = L15;
  goto LAB2310;
LAB2314:
if(DecrRefs(L15)<0)
XD_Manalyzer_T75(L15);
  Abort(2192, module_name);
LAB2317:
if(DecrRefs(L15)<0)
XD_Manalyzer_T75(L15);
  L16 = G_analyzer_IS_ALIVE_NR3194;
  Create(&L17,1,2);
  *(value *)(L17+1) = L14;
  L18 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L13));
  L19 = *((value*)L18);
  ATTACH(L19);
  *(value *)(L17+2) = L19;
if(DecrRefs(*((value*)L18))<0)
XD_Manalyzer_T29(*((value*)L18));
  *((value *)L18) = L17;
  L10 = L16;
  ATTACH(L16);
LAB2310:
  *P3 = L10;
  *P2 = L2;
  return 1;
LAB2319:
if(DecrRefs(L15)<0)
XD_Manalyzer_T75(L15);
  Abort(2196, module_name);
LAB1368:
if(DecrRefs(L2)<0)
XD_Manalyzer_T61(L2);
  L11 = G_analyzer_NUM_LEFT_NR3157;
  L12 = L3;
  L20 = L0;
  L21 = L1;
  L22 = L12;
  switch (Alternative(L22)) {
  case 0: goto LAB2321;
  case 1: goto LAB2324;
  case 2: goto LAB2327;
  default: goto LAB2329;
  };
LAB2321:
  L12 = L22;
  goto LAB2320;
LAB2324:
if(DecrRefs(L22)<0)
XD_Manalyzer_T75(L22);
  Abort(2192, module_name);
LAB2327:
if(DecrRefs(L22)<0)
XD_Manalyzer_T75(L22);
  L23 = G_analyzer_IS_ALIVE_NR3194;
  Create(&L24,1,2);
  *(value *)(L24+1) = L21;
  L25 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L20));
  L26 = *((value*)L25);
  ATTACH(L26);
  *(value *)(L24+2) = L26;
if(DecrRefs(*((value*)L25))<0)
XD_Manalyzer_T29(*((value*)L25));
  *((value *)L25) = L24;
  L12 = L23;
  ATTACH(L23);
LAB2320:
  *P3 = L12;
  *P2 = L11;
  ATTACH(L11);
  return 1;
LAB2329:
if(DecrRefs(L22)<0)
XD_Manalyzer_T75(L22);
  Abort(2196, module_name);
}

int Manalyzer_P_split_control_flow_LOCATION_LOCATION(P0,P1)
value P0;
value P1;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  Manalyzer_P_save_CODE_LEFTOVER(&L2,&L3);
  Manalyzer_P_split_control_flow_CODE_LOCATION_LOCATION_LEFTOVER(L2,L0,L1,L3);
if(DecrRefs(L3)<0)
XD_Manalyzer_T70(L3);
if(DecrRefs(L2)<0)
XD_Manalyzer_T71(L2);
  return 1;
}

int Manalyzer_P_split_control_flow_CODE_LOCATION_LOCATION_LEFTOVER(P0,P1,P2,P3)
value P0;
value P1;
value P2;
value P3;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  switch (Alternative(L0)) {
  case 1: goto LAB1371;
  default: goto LAB1373;
  };
LAB1371:
  L4 = (value)(L0[1]);
  L5 = (value)(L0[2]);
  L6 = (value)(L0[3]);
  L7 = G_analyzer_THE_CODE_NR22;
  ATTACH(L7);
  Manalyzer_P_merge_code_CODE_CODE_CODE(L6,L7,&L8);
if(DecrRefs(L7)<0)
XD_Manalyzer_T71(L7);
  Create(&L9,0,6);
  *(value *)(L9+1) = L4;
  ATTACH(L4);
  *(value *)(L9+2) = L5;
  *(value *)(L9+3) = L1;
  *(value *)(L9+4) = L3;
  ATTACH(L3);
  *(value *)(L9+5) = L2;
  *(value *)(L9+6) = L8;
if(DecrRefs(G_analyzer_THE_CODE_NR22)<0)
XD_Manalyzer_T71(G_analyzer_THE_CODE_NR22);
  G_analyzer_THE_CODE_NR22 = L9;
  return 1;
LAB1373:
  Abort(1886, module_name);
}

int Manalyzer_P_merge_code_CODE_CODE_CODE(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  switch (Alternative(L0)) {
  case 2: goto LAB1374;
  case 0: goto LAB1377;
  case 1: goto LAB1380;
  default: goto LAB1382;
  };
LAB1374:
  *P2 = L1;
  ATTACH(L1);
  return 1;
LAB1377:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  L4 = (value)(L0[3]);
  L5 = (value)(L0[4]);
  L6 = (value)(L0[5]);
  L7 = (value)(L0[6]);
  Manalyzer_P_merge_code_CODE_CODE_CODE(L7,L1,&L8);
  Create(&L9,0,6);
  *(value *)(L9+1) = L2;
  ATTACH(L2);
  *(value *)(L9+2) = L3;
  *(value *)(L9+3) = L4;
  *(value *)(L9+4) = L5;
  ATTACH(L5);
  *(value *)(L9+5) = L6;
  *(value *)(L9+6) = L8;
  *P2 = L9;
  return 1;
LAB1380:
  L10 = (value)(L0[1]);
  L11 = (value)(L0[2]);
  L12 = (value)(L0[3]);
  Manalyzer_P_merge_code_CODE_CODE_CODE(L12,L1,&L13);
  Create(&L14,1,3);
  *(value *)(L14+1) = L10;
  ATTACH(L10);
  *(value *)(L14+2) = L11;
  *(value *)(L14+3) = L13;
  *P2 = L14;
  return 1;
LAB1382:
  Abort(1900, module_name);
}

int Manalyzer_P_handle_memory_ALTERNATIVE_LEFTOVER_ALIVE(P0,P1,P2)
value P0;
value *P1;
value *P2;
{
  value L115;
  value L114;
  value L113;
  value L112;
  value L111;
  value L110;
  value L109;
  value L108;
  value L107;
  value L106;
  value L105;
  value L104;
  value L103;
  value L102;
  value L101;
  value L100;
  value L99;
  value L98;
  value L97;
  value L96;
  value L95;
  value L94;
  value L93;
  value L92;
  value L91;
  value L90;
  value L89;
  value L88;
  value L87;
  value L86;
  value L85;
  value L84;
  value L83;
  value L82;
  value L81;
  value L80;
  value L79;
  value L78;
  value L77;
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB1383;
  case 1: goto LAB1389;
  case 2: goto LAB1392;
  default: goto LAB1394;
  };
LAB1383:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L3 = (value)(L0[3]);
  switch (Alternative(L3)) {
  case 2: goto LAB1386;
  default: goto LAB1388;
  };
LAB1386:
  L4 = (value)(L3[1]);
  Manalyzer_P_handle_memory_ALTERNATIVE_LEFTOVER_ALIVE(L2,&L5,&L6);
  L7 = G_analyzer_FAILED_NR3158;
  L8 = G_analyzer_LEFTOVER_NR3159;
  L9 = G_analyzer_ALIVE_NR3160;
  L10 = L5;
  L11 = L6;
  L12 = L7;
  ATTACH(L12);
  Manalyzer_P_handle_memory_CODE_LEFTOVER_ALIVE_LEFTOVER_ALIVE_FAILED(L1,L8,L9,&L10,&L11,&L12);
if(DecrRefs(L12)<0)
XD_Manalyzer_T74(L12);
  *P2 = L11;
  *P1 = L10;
  return 1;
LAB1388:
  Manalyzer_P_handle_memory_ALTERNATIVE_LEFTOVER_ALIVE(L3,&L13,&L14);
  Manalyzer_P_balance_memory_ALTERNATIVE_LEFTOVER_ALIVE_LEFTOVER_ALIVE_FAILED(L2,L13,L14,&L15,&L16,&L17);
  L40 = L2;
  switch (Alternative(L40)) {
  case 0: goto LAB2625;
  case 1: goto LAB2639;
  case 2: goto LAB2653;
  default: goto LAB2655;
  };
LAB2625:
  L41 = (value)(L40[1]);
  L42 = (value)(L40[2]);
  L43 = (value)(L40[3]);
  L44 = C_INT(-1);
  L52 = L41;
  L53 = L44;
LAB2627:
  switch (Alternative(L52)) {
  case 0: goto LAB2628;
  case 1: goto LAB2631;
  case 2: goto LAB2634;
  default: goto LAB2637;
  };
LAB2628:
  L54 = (value)(L52[1]);
  L55 = (value)(L52[2]);
  L56 = (value)(L52[3]);
  L57 = (value)(L52[4]);
  L58 = (value)(L52[5]);
  L59 = (value)(L52[6]);
  L53 = L55;
  L52 = L59;
  goto LAB2627;
LAB2631:
  L61 = (value)(L52[1]);
  L62 = (value)(L52[2]);
  L63 = (value)(L52[3]);
  L53 = L62;
  L52 = L63;
  goto LAB2627;
LAB2634:
  L45 = L53;
LAB2636:
  L18 = L45;
  goto LAB2624;
LAB2637:
  Abort(2064, module_name);
LAB2639:
  L46 = (value)(L40[1]);
  L47 = (value)(L40[2]);
  L48 = C_INT(-1);
  L65 = L46;
  L66 = L48;
LAB2641:
  switch (Alternative(L65)) {
  case 0: goto LAB2642;
  case 1: goto LAB2645;
  case 2: goto LAB2648;
  default: goto LAB2651;
  };
LAB2642:
  L67 = (value)(L65[1]);
  L68 = (value)(L65[2]);
  L69 = (value)(L65[3]);
  L70 = (value)(L65[4]);
  L71 = (value)(L65[5]);
  L72 = (value)(L65[6]);
  L66 = L68;
  L65 = L72;
  goto LAB2641;
LAB2645:
  L74 = (value)(L65[1]);
  L75 = (value)(L65[2]);
  L76 = (value)(L65[3]);
  L66 = L75;
  L65 = L76;
  goto LAB2641;
LAB2648:
  L49 = L66;
LAB2650:
  L18 = L49;
  goto LAB2624;
LAB2651:
  Abort(2064, module_name);
LAB2653:
  L50 = (value)(L40[1]);
  L51 = C_INT(-1);
  L18 = L51;
LAB2624:
  L78 = L3;
  switch (Alternative(L78)) {
  case 0: goto LAB2657;
  case 1: goto LAB2671;
  case 2: goto LAB2685;
  default: goto LAB2687;
  };
LAB2655:
  Abort(2055, module_name);
LAB2657:
  L79 = (value)(L78[1]);
  L80 = (value)(L78[2]);
  L81 = (value)(L78[3]);
  L82 = C_INT(-1);
  L90 = L79;
  L91 = L82;
LAB2659:
  switch (Alternative(L90)) {
  case 0: goto LAB2660;
  case 1: goto LAB2663;
  case 2: goto LAB2666;
  default: goto LAB2669;
  };
LAB2660:
  L92 = (value)(L90[1]);
  L93 = (value)(L90[2]);
  L94 = (value)(L90[3]);
  L95 = (value)(L90[4]);
  L96 = (value)(L90[5]);
  L97 = (value)(L90[6]);
  L91 = L93;
  L90 = L97;
  goto LAB2659;
LAB2663:
  L99 = (value)(L90[1]);
  L100 = (value)(L90[2]);
  L101 = (value)(L90[3]);
  L91 = L100;
  L90 = L101;
  goto LAB2659;
LAB2666:
  L83 = L91;
LAB2668:
  L19 = L83;
  goto LAB2656;
LAB2669:
  Abort(2064, module_name);
LAB2671:
  L84 = (value)(L78[1]);
  L85 = (value)(L78[2]);
  L86 = C_INT(-1);
  L103 = L84;
  L104 = L86;
LAB2673:
  switch (Alternative(L103)) {
  case 0: goto LAB2674;
  case 1: goto LAB2677;
  case 2: goto LAB2680;
  default: goto LAB2683;
  };
LAB2674:
  L105 = (value)(L103[1]);
  L106 = (value)(L103[2]);
  L107 = (value)(L103[3]);
  L108 = (value)(L103[4]);
  L109 = (value)(L103[5]);
  L110 = (value)(L103[6]);
  L104 = L106;
  L103 = L110;
  goto LAB2673;
LAB2677:
  L112 = (value)(L103[1]);
  L113 = (value)(L103[2]);
  L114 = (value)(L103[3]);
  L104 = L113;
  L103 = L114;
  goto LAB2673;
LAB2680:
  L87 = L104;
LAB2682:
  L19 = L87;
  goto LAB2656;
LAB2683:
  Abort(2064, module_name);
LAB2685:
  L88 = (value)(L78[1]);
  L89 = C_INT(-1);
  L19 = L89;
LAB2656:
  L20 = C_INT(0);
  Manalyzer_P_balance_alternative_OFFSET_LOCATION_LEFTOVER_ALIVE_LOCATION_LEFTOVER_ALIVE_FAILED_LEFTOVER_ALIVE(L20,L18,L15,L16,L19,L13,L14,L17,&L21,&L22);
if(DecrRefs(L17)<0)
XD_Manalyzer_T74(L17);
if(DecrRefs(L16)<0)
XD_Manalyzer_T76(L16);
if(DecrRefs(L15)<0)
XD_Manalyzer_T70(L15);
if(DecrRefs(L14)<0)
XD_Manalyzer_T76(L14);
if(DecrRefs(L13)<0)
XD_Manalyzer_T70(L13);
  L23 = G_analyzer_FAILED_NR3161;
  L24 = G_analyzer_LEFTOVER_NR3162;
  L25 = G_analyzer_ALIVE_NR3163;
  L26 = L21;
  L27 = L22;
  L28 = L23;
  ATTACH(L28);
  Manalyzer_P_handle_memory_CODE_LEFTOVER_ALIVE_LEFTOVER_ALIVE_FAILED(L1,L24,L25,&L26,&L27,&L28);
if(DecrRefs(L28)<0)
XD_Manalyzer_T74(L28);
  *P2 = L27;
  *P1 = L26;
  return 1;
LAB2687:
  Abort(2055, module_name);
LAB1389:
  L29 = (value)(L0[1]);
  L30 = (value)(L0[2]);
  L31 = G_analyzer_FAILED_NR3164;
  L32 = G_analyzer_ALIVE_NR3165;
  L33 = G_analyzer_LEFTOVER_NR3166;
  L34 = G_analyzer_ALIVE_NR3167;
  L35 = L30;
  ATTACH(L35);
  L36 = L32;
  ATTACH(L36);
  L37 = L31;
  ATTACH(L37);
  Manalyzer_P_handle_memory_CODE_LEFTOVER_ALIVE_LEFTOVER_ALIVE_FAILED(L29,L33,L34,&L35,&L36,&L37);
if(DecrRefs(L37)<0)
XD_Manalyzer_T74(L37);
  *P2 = L36;
  *P1 = L35;
  return 1;
LAB1392:
  L38 = (value)(L0[1]);
  L39 = G_analyzer_ALIVE_NR3168;
  *P2 = L39;
  ATTACH(L39);
  *P1 = L38;
  ATTACH(L38);
  return 1;
LAB1394:
  Abort(1936, module_name);
}

int Manalyzer_P_balance_memory_ALTERNATIVE_LEFTOVER_ALIVE_LEFTOVER_ALIVE_FAILED(P0,P1,P2,P3,P4,P5)
value P0;
value P1;
value P2;
value *P3;
value *P4;
value *P5;
{
  value L112;
  value L111;
  value L110;
  value L109;
  value L108;
  value L107;
  value L106;
  value L105;
  value L104;
  value L103;
  value L102;
  value L101;
  value L100;
  value L99;
  value L98;
  value L97;
  value L96;
  value L95;
  value L94;
  value L93;
  value L92;
  value L91;
  value L90;
  value L89;
  value L88;
  value L87;
  value L86;
  value L85;
  value L84;
  value L83;
  value L82;
  value L81;
  value L80;
  value L79;
  value L78;
  value L77;
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L0)) {
  case 0: goto LAB1395;
  case 1: goto LAB1401;
  case 2: goto LAB1404;
  default: goto LAB1406;
  };
LAB1395:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  L5 = (value)(L0[3]);
  switch (Alternative(L5)) {
  case 2: goto LAB1398;
  default: goto LAB1400;
  };
LAB1398:
  L6 = (value)(L5[1]);
  Manalyzer_P_handle_memory_ALTERNATIVE_LEFTOVER_ALIVE(L4,&L7,&L8);
  L9 = G_analyzer_FAILED_NR3169;
  L10 = L7;
  L11 = L8;
  L12 = L9;
  ATTACH(L12);
  Manalyzer_P_handle_memory_CODE_LEFTOVER_ALIVE_LEFTOVER_ALIVE_FAILED(L3,L1,L2,&L10,&L11,&L12);
  *P5 = L12;
  *P4 = L11;
  *P3 = L10;
  return 1;
LAB1400:
  Manalyzer_P_handle_memory_ALTERNATIVE_LEFTOVER_ALIVE(L5,&L13,&L14);
  Manalyzer_P_balance_memory_ALTERNATIVE_LEFTOVER_ALIVE_LEFTOVER_ALIVE_FAILED(L4,L13,L14,&L15,&L16,&L17);
  L37 = L4;
  switch (Alternative(L37)) {
  case 0: goto LAB2460;
  case 1: goto LAB2474;
  case 2: goto LAB2488;
  default: goto LAB2490;
  };
LAB2460:
  L38 = (value)(L37[1]);
  L39 = (value)(L37[2]);
  L40 = (value)(L37[3]);
  L41 = C_INT(-1);
  L49 = L38;
  L50 = L41;
LAB2462:
  switch (Alternative(L49)) {
  case 0: goto LAB2463;
  case 1: goto LAB2466;
  case 2: goto LAB2469;
  default: goto LAB2472;
  };
LAB2463:
  L51 = (value)(L49[1]);
  L52 = (value)(L49[2]);
  L53 = (value)(L49[3]);
  L54 = (value)(L49[4]);
  L55 = (value)(L49[5]);
  L56 = (value)(L49[6]);
  L50 = L52;
  L49 = L56;
  goto LAB2462;
LAB2466:
  L58 = (value)(L49[1]);
  L59 = (value)(L49[2]);
  L60 = (value)(L49[3]);
  L50 = L59;
  L49 = L60;
  goto LAB2462;
LAB2469:
  L42 = L50;
LAB2471:
  L18 = L42;
  goto LAB2459;
LAB2472:
  Abort(2064, module_name);
LAB2474:
  L43 = (value)(L37[1]);
  L44 = (value)(L37[2]);
  L45 = C_INT(-1);
  L62 = L43;
  L63 = L45;
LAB2476:
  switch (Alternative(L62)) {
  case 0: goto LAB2477;
  case 1: goto LAB2480;
  case 2: goto LAB2483;
  default: goto LAB2486;
  };
LAB2477:
  L64 = (value)(L62[1]);
  L65 = (value)(L62[2]);
  L66 = (value)(L62[3]);
  L67 = (value)(L62[4]);
  L68 = (value)(L62[5]);
  L69 = (value)(L62[6]);
  L63 = L65;
  L62 = L69;
  goto LAB2476;
LAB2480:
  L71 = (value)(L62[1]);
  L72 = (value)(L62[2]);
  L73 = (value)(L62[3]);
  L63 = L72;
  L62 = L73;
  goto LAB2476;
LAB2483:
  L46 = L63;
LAB2485:
  L18 = L46;
  goto LAB2459;
LAB2486:
  Abort(2064, module_name);
LAB2488:
  L47 = (value)(L37[1]);
  L48 = C_INT(-1);
  L18 = L48;
LAB2459:
  L75 = L5;
  switch (Alternative(L75)) {
  case 0: goto LAB2492;
  case 1: goto LAB2506;
  case 2: goto LAB2520;
  default: goto LAB2522;
  };
LAB2490:
  Abort(2055, module_name);
LAB2492:
  L76 = (value)(L75[1]);
  L77 = (value)(L75[2]);
  L78 = (value)(L75[3]);
  L79 = C_INT(-1);
  L87 = L76;
  L88 = L79;
LAB2494:
  switch (Alternative(L87)) {
  case 0: goto LAB2495;
  case 1: goto LAB2498;
  case 2: goto LAB2501;
  default: goto LAB2504;
  };
LAB2495:
  L89 = (value)(L87[1]);
  L90 = (value)(L87[2]);
  L91 = (value)(L87[3]);
  L92 = (value)(L87[4]);
  L93 = (value)(L87[5]);
  L94 = (value)(L87[6]);
  L88 = L90;
  L87 = L94;
  goto LAB2494;
LAB2498:
  L96 = (value)(L87[1]);
  L97 = (value)(L87[2]);
  L98 = (value)(L87[3]);
  L88 = L97;
  L87 = L98;
  goto LAB2494;
LAB2501:
  L80 = L88;
LAB2503:
  L19 = L80;
  goto LAB2491;
LAB2504:
  Abort(2064, module_name);
LAB2506:
  L81 = (value)(L75[1]);
  L82 = (value)(L75[2]);
  L83 = C_INT(-1);
  L100 = L81;
  L101 = L83;
LAB2508:
  switch (Alternative(L100)) {
  case 0: goto LAB2509;
  case 1: goto LAB2512;
  case 2: goto LAB2515;
  default: goto LAB2518;
  };
LAB2509:
  L102 = (value)(L100[1]);
  L103 = (value)(L100[2]);
  L104 = (value)(L100[3]);
  L105 = (value)(L100[4]);
  L106 = (value)(L100[5]);
  L107 = (value)(L100[6]);
  L101 = L103;
  L100 = L107;
  goto LAB2508;
LAB2512:
  L109 = (value)(L100[1]);
  L110 = (value)(L100[2]);
  L111 = (value)(L100[3]);
  L101 = L110;
  L100 = L111;
  goto LAB2508;
LAB2515:
  L84 = L101;
LAB2517:
  L19 = L84;
  goto LAB2491;
LAB2518:
  Abort(2064, module_name);
LAB2520:
  L85 = (value)(L75[1]);
  L86 = C_INT(-1);
  L19 = L86;
LAB2491:
  L20 = C_INT(0);
  Manalyzer_P_balance_alternative_OFFSET_LOCATION_LEFTOVER_ALIVE_LOCATION_LEFTOVER_ALIVE_FAILED_LEFTOVER_ALIVE(L20,L18,L15,L16,L19,L13,L14,L17,&L21,&L22);
if(DecrRefs(L17)<0)
XD_Manalyzer_T74(L17);
if(DecrRefs(L16)<0)
XD_Manalyzer_T76(L16);
if(DecrRefs(L15)<0)
XD_Manalyzer_T70(L15);
if(DecrRefs(L14)<0)
XD_Manalyzer_T76(L14);
if(DecrRefs(L13)<0)
XD_Manalyzer_T70(L13);
  L23 = G_analyzer_FAILED_NR3170;
  L24 = L21;
  L25 = L22;
  L26 = L23;
  ATTACH(L26);
  Manalyzer_P_handle_memory_CODE_LEFTOVER_ALIVE_LEFTOVER_ALIVE_FAILED(L3,L1,L2,&L24,&L25,&L26);
  *P5 = L26;
  *P4 = L25;
  *P3 = L24;
  return 1;
LAB2522:
  Abort(2055, module_name);
LAB1401:
  L27 = (value)(L0[1]);
  L28 = (value)(L0[2]);
  L29 = G_analyzer_FAILED_NR3171;
  L30 = G_analyzer_ALIVE_NR3172;
  L31 = L28;
  ATTACH(L31);
  L32 = L30;
  ATTACH(L32);
  L33 = L29;
  ATTACH(L33);
  Manalyzer_P_handle_memory_CODE_LEFTOVER_ALIVE_LEFTOVER_ALIVE_FAILED(L27,L1,L2,&L31,&L32,&L33);
  *P5 = L33;
  *P4 = L32;
  *P3 = L31;
  return 1;
LAB1404:
  L34 = (value)(L0[1]);
  L35 = G_analyzer_FAILED_NR3173;
  L36 = G_analyzer_ALIVE_NR3174;
  *P5 = L35;
  ATTACH(L35);
  *P4 = L36;
  ATTACH(L36);
  *P3 = L34;
  ATTACH(L34);
  return 1;
LAB1406:
  Abort(1968, module_name);
}

int Manalyzer_P_balance_alternative_OFFSET_LOCATION_LEFTOVER_ALIVE_LOCATION_LEFTOVER_ALIVE_FAILED_LEFTOVER_ALIVE(P0,P1,P2,P3,P4,P5,P6,P7,P8,P9)
value P0;
value P1;
value P2;
value P3;
value P4;
value P5;
value P6;
value P7;
value *P8;
value *P9;
{
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = P3;
  L4 = P4;
  L5 = P5;
  L6 = P6;
  L7 = P7;
  switch (Alternative(L2)) {
  case 1: goto LAB1407;
  case 0: goto LAB1410;
  default: goto LAB1412;
  };
LAB1407:
  L8 = G_analyzer_ALIVE_NR3175;
  L9 = G_analyzer_LEFTOVER_NR3176;
  *P9 = L8;
  ATTACH(L8);
  *P8 = L9;
  ATTACH(L9);
  return 1;
LAB1410:
  L10 = (value)(L2[1]);
  L11 = (value)(L2[2]);
  L12 = L7;
  ATTACH(L12);
  L30 = L12;
  switch (Alternative(L30)) {
  case 0: goto LAB2524;
  case 1: goto LAB2527;
  default: goto LAB2529;
  };
LAB2524:
  L31 = (value)(L30[1]);
  L32 = (value)(L30[2]);
  L13 = L31;
  ATTACH(L31);
  L12 = L32;
  ATTACH(L32);
if(DecrRefs(L30)<0)
XD_Manalyzer_T74(L30);
  goto LAB2523;
LAB2527:
  L33 = G_analyzer_FAIL_NR3191;
  L13 = L33;
  ATTACH(L33);
  L12 = L30;
LAB2523:
  L14 = L3;
  ATTACH(L14);
  L34 = L14;
  switch (Alternative(L34)) {
  case 1: goto LAB2531;
  case 0: goto LAB2534;
  default: goto LAB2536;
  };
LAB2529:
if(DecrRefs(L30)<0)
XD_Manalyzer_T74(L30);
  Abort(2156, module_name);
LAB2531:
  L35 = G_analyzer_IS_ALIVE_NR3193;
  L15 = L35;
  ATTACH(L35);
  L14 = L34;
  goto LAB2530;
LAB2534:
  L36 = (value)(L34[1]);
  L37 = (value)(L34[2]);
  L15 = L36;
  ATTACH(L36);
  L14 = L37;
  ATTACH(L37);
if(DecrRefs(L34)<0)
XD_Manalyzer_T76(L34);
LAB2530:
  L16 = L6;
  ATTACH(L16);
  L38 = L16;
  switch (Alternative(L38)) {
  case 1: goto LAB2538;
  case 0: goto LAB2541;
  default: goto LAB2543;
  };
LAB2536:
if(DecrRefs(L34)<0)
XD_Manalyzer_T76(L34);
  Abort(2188, module_name);
LAB2538:
  L39 = G_analyzer_IS_ALIVE_NR3193;
  L17 = L39;
  ATTACH(L39);
  L16 = L38;
  goto LAB2537;
LAB2541:
  L40 = (value)(L38[1]);
  L41 = (value)(L38[2]);
  L17 = L40;
  ATTACH(L40);
  L16 = L41;
  ATTACH(L41);
if(DecrRefs(L38)<0)
XD_Manalyzer_T76(L38);
LAB2537:
  switch (Alternative(L5)) {
  case 1: goto LAB1413;
  case 0: goto LAB1416;
  default: goto LAB1418;
  };
LAB2543:
if(DecrRefs(L38)<0)
XD_Manalyzer_T76(L38);
  Abort(2188, module_name);
LAB1413:
if(DecrRefs(L17)<0)
XD_Manalyzer_T75(L17);
if(DecrRefs(L16)<0)
XD_Manalyzer_T76(L16);
if(DecrRefs(L15)<0)
XD_Manalyzer_T75(L15);
if(DecrRefs(L14)<0)
XD_Manalyzer_T76(L14);
if(DecrRefs(L13)<0)
XD_Manalyzer_T73(L13);
if(DecrRefs(L12)<0)
XD_Manalyzer_T74(L12);
  Abort(1981, module_name);
LAB1416:
  L18 = (value)(L5[1]);
  L19 = (value)(L5[2]);
  L20 = L15;
  L21 = L17;
  L42 = L0;
  L43 = L1;
  L44 = L10;
  L45 = L20;
  L46 = L4;
  L47 = L18;
  L48 = L21;
  L49 = L13;
  switch (Alternative(L44)) {
  case 0: goto LAB2545;
  case 2: goto LAB2557;
  case 1: goto LAB2575;
  default: goto LAB2579;
  };
LAB2545:
  switch (Alternative(L47)) {
  case 0: goto LAB2547;
  case 2: goto LAB2551;
  default: goto LAB2553;
  };
LAB2547:
  L50 = G_analyzer_NUM_LEFT_NR3177;
  L22 = L50;
  ATTACH(L50);
  L21 = L48;
  L20 = L45;
  goto LAB2544;
LAB2551:
  L51 = G_analyzer_NUM_LEFT_NR3178;
  L22 = L51;
  ATTACH(L51);
  L21 = L48;
  L20 = L45;
  goto LAB2544;
LAB2553:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
if(DecrRefs(L45)<0)
XD_Manalyzer_T75(L45);
  switch (Alternative(L47)) {
  case 1: goto LAB2554;
  default: goto LAB2556;
  };
LAB2554:
  Abort(2020, module_name);
LAB2556:
  Abort(2021, module_name);
LAB2557:
  switch (Alternative(L47)) {
  case 0: goto LAB2559;
  case 2: goto LAB2563;
  case 1: goto LAB2566;
  default: goto LAB2570;
  };
LAB2559:
  L52 = G_analyzer_NUM_LEFT_NR3179;
  L22 = L52;
  ATTACH(L52);
  L21 = L48;
  L20 = L45;
  goto LAB2544;
LAB2563:
  L53 = G_analyzer_NUM_LEFT_NR3180;
  L22 = L53;
  ATTACH(L53);
  L21 = L48;
  L20 = L45;
  goto LAB2544;
LAB2566:
  switch (Alternative(L49)) {
  case 0: goto LAB2568;
  case 1: goto LAB2572;
  default: goto LAB2574;
  };
LAB2568:
  L54 = G_analyzer_NUM_LEFT_NR3181;
  L22 = L54;
  ATTACH(L54);
  L21 = L48;
  L20 = L45;
  goto LAB2544;
LAB2572:
  L55 = L48;
  Manalyzer_P_insert_detach_OFFSET_LOCATION_IS_ALIVE(L42,L46,&L55);
  L56 = G_analyzer_NUM_LEFT_NR3182;
  L22 = L56;
  ATTACH(L56);
  L21 = L55;
  L20 = L45;
  goto LAB2544;
LAB2574:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
if(DecrRefs(L45)<0)
XD_Manalyzer_T75(L45);
  Abort(2033, module_name);
LAB2570:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
if(DecrRefs(L45)<0)
XD_Manalyzer_T75(L45);
  Abort(2034, module_name);
LAB2575:
  switch (Alternative(L47)) {
  case 0: goto LAB2577;
  case 2: goto LAB2581;
  case 1: goto LAB2584;
  default: goto LAB2586;
  };
LAB2577:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
if(DecrRefs(L45)<0)
XD_Manalyzer_T75(L45);
  Abort(2036, module_name);
LAB2581:
  L57 = L45;
  Manalyzer_P_insert_detach_OFFSET_LOCATION_IS_ALIVE(L42,L43,&L57);
  L58 = G_analyzer_NUM_LEFT_NR3183;
  L22 = L58;
  ATTACH(L58);
  L21 = L48;
  L20 = L57;
  goto LAB2544;
LAB2584:
  L59 = G_analyzer_NUM_LEFT_NR3184;
  L22 = L59;
  ATTACH(L59);
  L21 = L48;
  L20 = L45;
LAB2544:
if(DecrRefs(L13)<0)
XD_Manalyzer_T73(L13);
  L60 = L20;
  L61 = L1;
  L62 = L21;
  L63 = L4;
  L64 = L0;
  switch (Alternative(L60)) {
  case 0: goto LAB2588;
  case 2: goto LAB2600;
  case 1: goto LAB2612;
  default: goto LAB2616;
  };
LAB2586:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
if(DecrRefs(L45)<0)
XD_Manalyzer_T75(L45);
  Abort(2042, module_name);
LAB2579:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
if(DecrRefs(L45)<0)
XD_Manalyzer_T75(L45);
  Abort(2043, module_name);
LAB2588:
  switch (Alternative(L62)) {
  case 0: goto LAB2590;
  case 2: goto LAB2594;
  case 1: goto LAB2597;
  default: goto LAB2599;
  };
LAB2590:
  L65 = G_analyzer_IS_ALIVE_NR3196;
  L23 = L65;
  ATTACH(L65);
  goto LAB2587;
LAB2594:
  L66 = G_analyzer_IS_ALIVE_NR3197;
  Create(&L67,0,2);
  *(value *)(L67+1) = L63;
  L68 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L64));
  L69 = *((value*)L68);
  ATTACH(L69);
  *(value *)(L67+2) = L69;
if(DecrRefs(*((value*)L68))<0)
XD_Manalyzer_T29(*((value*)L68));
  *((value *)L68) = L67;
  L23 = L66;
  ATTACH(L66);
  goto LAB2587;
LAB2597:
  Abort(2253, module_name);
LAB2599:
  Abort(2254, module_name);
LAB2600:
  switch (Alternative(L62)) {
  case 0: goto LAB2602;
  case 2: goto LAB2606;
  case 1: goto LAB2609;
  default: goto LAB2611;
  };
LAB2602:
  L70 = G_analyzer_IS_ALIVE_NR3198;
  Create(&L71,0,2);
  *(value *)(L71+1) = L61;
  L72 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L64));
  L73 = *((value*)L72);
  ATTACH(L73);
  *(value *)(L71+2) = L73;
if(DecrRefs(*((value*)L72))<0)
XD_Manalyzer_T29(*((value*)L72));
  *((value *)L72) = L71;
  L23 = L70;
  ATTACH(L70);
  goto LAB2587;
LAB2606:
  L74 = G_analyzer_IS_ALIVE_NR3199;
  L23 = L74;
  ATTACH(L74);
  goto LAB2587;
LAB2609:
  L75 = G_analyzer_IS_ALIVE_NR3200;
  L23 = L75;
  ATTACH(L75);
  goto LAB2587;
LAB2611:
  Abort(2263, module_name);
LAB2612:
  switch (Alternative(L62)) {
  case 0: goto LAB2614;
  case 2: goto LAB2618;
  case 1: goto LAB2621;
  default: goto LAB2623;
  };
LAB2614:
  Abort(2266, module_name);
LAB2618:
  L76 = G_analyzer_IS_ALIVE_NR3201;
  L23 = L76;
  ATTACH(L76);
LAB2587:
if(DecrRefs(L21)<0)
XD_Manalyzer_T75(L21);
if(DecrRefs(L20)<0)
XD_Manalyzer_T75(L20);
  L24 = C_INT(1);
  L25 = C_INT(Int(L0) + Int(L24));
  Manalyzer_P_balance_alternative_OFFSET_LOCATION_LEFTOVER_ALIVE_LOCATION_LEFTOVER_ALIVE_FAILED_LEFTOVER_ALIVE(L25,L1,L11,L14,L4,L19,L16,L12,&L26,&L27);
if(DecrRefs(L16)<0)
XD_Manalyzer_T76(L16);
if(DecrRefs(L14)<0)
XD_Manalyzer_T76(L14);
if(DecrRefs(L12)<0)
XD_Manalyzer_T74(L12);
  Create(&L28,0,2);
  *(value *)(L28+1) = L23;
  *(value *)(L28+2) = L27;
  Create(&L29,0,2);
  *(value *)(L29+1) = L22;
  *(value *)(L29+2) = L26;
  *P9 = L28;
  *P8 = L29;
  return 1;
LAB2621:
  Abort(2270, module_name);
LAB2623:
  Abort(2271, module_name);
LAB2616:
  Abort(2272, module_name);
LAB1418:
if(DecrRefs(L17)<0)
XD_Manalyzer_T75(L17);
if(DecrRefs(L16)<0)
XD_Manalyzer_T76(L16);
if(DecrRefs(L15)<0)
XD_Manalyzer_T75(L15);
if(DecrRefs(L14)<0)
XD_Manalyzer_T76(L14);
if(DecrRefs(L13)<0)
XD_Manalyzer_T73(L13);
if(DecrRefs(L12)<0)
XD_Manalyzer_T74(L12);
  Abort(1994, module_name);
LAB1412:
  Abort(1995, module_name);
}

int Manalyzer_P_get_first_location_CODE_LOCATION_LOCATION(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB2436:
  switch (Alternative(L0)) {
  case 0: goto LAB1470;
  case 1: goto LAB1473;
  case 2: goto LAB1476;
  default: goto LAB1478;
  };
LAB1470:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  L4 = (value)(L0[3]);
  L5 = (value)(L0[4]);
  L6 = (value)(L0[5]);
  L7 = (value)(L0[6]);
  L1 = L3;
  L0 = L7;
  goto LAB2436;
LAB1473:
  L9 = (value)(L0[1]);
  L10 = (value)(L0[2]);
  L11 = (value)(L0[3]);
  L1 = L10;
  L0 = L11;
  goto LAB2436;
LAB1476:
  *P2 = L1;
  return 1;
LAB1478:
  Abort(2064, module_name);
}

int Manalyzer_P_handle_memory_CODE_LEFTOVER_ALIVE_LEFTOVER_ALIVE_FAILED(P0,P1,P2,P3,P4,P5)
value P0;
value P1;
value P2;
value *P3;
value *P4;
value *P5;
{
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = *P3;
  L4 = *P4;
  L5 = *P5;
LAB2435:
  switch (Alternative(L0)) {
  case 0: goto LAB1479;
  case 1: goto LAB1482;
  case 2: goto LAB1485;
  default: goto LAB1487;
  };
LAB1479:
  L6 = (value)(L0[1]);
  L7 = (value)(L0[2]);
  L8 = (value)(L0[3]);
  L9 = (value)(L0[4]);
  L10 = (value)(L0[5]);
  L11 = (value)(L0[6]);
  L12 = C_INT(0);
  L13 = L3;
  L14 = L5;
  L15 = L4;
  Manalyzer_P_recover_failure_OFFSET_LOCATION_LEFTOVER_LEFTOVER_FAILED_LOCATION_LEFTOVER_ALIVE(L12,L8,&L13,L1,&L14,L10,L9,&L15);
  L16 = C_INT(0);
  L17 = L15;
  Manalyzer_P_recover_failure_OFFSET_ALIVE_LOCATION_ALIVE(L16,&L17,L10,L2);
  L18 = C_INT(0);
  L19 = L13;
  L20 = L17;
  Manalyzer_P_insert_memory_ops_OFFSET_MEM_CONTEXT_LEFTOVER_ALIVE(L18,L6,&L19,&L20);
  L21 = L19;
  L22 = L20;
  L23 = L14;
  L5 = L23;
  L4 = L22;
  L3 = L21;
  L0 = L11;
  goto LAB2435;
LAB1482:
  L24 = (value)(L0[1]);
  L25 = (value)(L0[2]);
  L26 = (value)(L0[3]);
  L27 = C_INT(0);
  L28 = L3;
  L29 = L4;
  Manalyzer_P_insert_memory_ops_OFFSET_MEM_CONTEXT_LEFTOVER_ALIVE(L27,L24,&L28,&L29);
  L30 = L28;
  L31 = L29;
  L32 = L5;
  L5 = L32;
  L4 = L31;
  L3 = L30;
  L0 = L26;
  goto LAB2435;
LAB1485:
  *P5 = L5;
  *P4 = L4;
  *P3 = L3;
  return 1;
LAB1487:
if(DecrRefs(L5)<0)
XD_Manalyzer_T74(L5);
if(DecrRefs(L4)<0)
XD_Manalyzer_T76(L4);
if(DecrRefs(L3)<0)
XD_Manalyzer_T70(L3);
  Abort(2079, module_name);
}

int Manalyzer_P_recover_failure_OFFSET_LOCATION_LEFTOVER_LEFTOVER_FAILED_LOCATION_LEFTOVER_ALIVE(P0,P1,P2,P3,P4,P5,P6,P7)
value P0;
value P1;
value *P2;
value P3;
value *P4;
value P5;
value P6;
value *P7;
{
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = *P2;
  L3 = P3;
  L4 = *P4;
  L5 = P5;
  L6 = P6;
  L7 = *P7;
  switch (Alternative(L2)) {
  case 1: goto LAB1488;
  case 0: goto LAB1491;
  default: goto LAB1493;
  };
LAB1488:
  *P7 = L7;
  *P4 = L4;
  *P2 = L2;
  return 1;
LAB1491:
  L8 = (value)(L2[1]);
  L9 = (value)(L2[2]);
  L10 = L6;
  ATTACH(L10);
  L29 = L10;
  switch (Alternative(L29)) {
  case 0: goto LAB2192;
  case 1: goto LAB2195;
  default: goto LAB2197;
  };
LAB2192:
  L30 = (value)(L29[1]);
  L31 = (value)(L29[2]);
  L11 = L30;
  ATTACH(L30);
  L10 = L31;
  ATTACH(L31);
if(DecrRefs(L29)<0)
XD_Manalyzer_T70(L29);
  goto LAB2191;
LAB2195:
  L32 = G_analyzer_NUM_LEFT_NR3185;
  L11 = L32;
  ATTACH(L32);
  L10 = L29;
LAB2191:
  L12 = L7;
  L33 = L12;
  switch (Alternative(L33)) {
  case 1: goto LAB2199;
  case 0: goto LAB2202;
  default: goto LAB2204;
  };
LAB2197:
if(DecrRefs(L29)<0)
XD_Manalyzer_T70(L29);
  Abort(2101, module_name);
LAB2199:
  L34 = G_analyzer_IS_ALIVE_NR3193;
  L13 = L34;
  ATTACH(L34);
  L12 = L33;
  goto LAB2198;
LAB2202:
  L35 = (value)(L33[1]);
  L36 = (value)(L33[2]);
  L13 = L35;
  ATTACH(L35);
  L12 = L36;
  ATTACH(L36);
if(DecrRefs(L33)<0)
XD_Manalyzer_T76(L33);
LAB2198:
  switch (Alternative(L3)) {
  case 1: goto LAB1494;
  case 0: goto LAB1497;
  default: goto LAB1499;
  };
LAB2204:
if(DecrRefs(L33)<0)
XD_Manalyzer_T76(L33);
  Abort(2188, module_name);
LAB1494:
if(DecrRefs(L13)<0)
XD_Manalyzer_T75(L13);
if(DecrRefs(L12)<0)
XD_Manalyzer_T76(L12);
if(DecrRefs(L11)<0)
XD_Manalyzer_T61(L11);
if(DecrRefs(L10)<0)
XD_Manalyzer_T70(L10);
if(DecrRefs(L4)<0)
XD_Manalyzer_T74(L4);
if(DecrRefs(L2)<0)
XD_Manalyzer_T70(L2);
  Abort(2086, module_name);
LAB1497:
  L14 = (value)(L3[1]);
  L15 = (value)(L3[2]);
  L16 = L4;
  L37 = L16;
  switch (Alternative(L37)) {
  case 0: goto LAB2206;
  case 1: goto LAB2209;
  default: goto LAB2211;
  };
LAB2206:
  L38 = (value)(L37[1]);
  L39 = (value)(L37[2]);
  L17 = L38;
  ATTACH(L38);
  L16 = L39;
  ATTACH(L39);
if(DecrRefs(L37)<0)
XD_Manalyzer_T74(L37);
  goto LAB2205;
LAB2209:
  L40 = G_analyzer_FAIL_NR3191;
  L17 = L40;
  ATTACH(L40);
  L16 = L37;
LAB2205:
  L18 = L8;
  ATTACH(L18);
  L19 = L17;
  L20 = L13;
  L41 = L0;
  L42 = L1;
  L43 = L18;
  L44 = L14;
  L45 = L19;
  L46 = L5;
  L47 = L11;
  L48 = L20;
  switch (Alternative(L47)) {
  case 1: goto LAB2214;
  default: goto LAB2220;
  };
LAB2211:
if(DecrRefs(L37)<0)
XD_Manalyzer_T74(L37);
  Abort(2156, module_name);
LAB2214:
  switch (Alternative(L43)) {
  case 0: goto LAB2216;
  case 2: goto LAB2229;
  case 1: goto LAB2247;
  default: goto LAB2251;
  };
LAB2216:
  switch (Alternative(L44)) {
  case 0: goto LAB2218;
  case 2: goto LAB2223;
  default: goto LAB2225;
  };
LAB2218:
  L20 = L48;
  L19 = L45;
  L18 = L43;
  goto LAB2213;
LAB2223:
  L20 = L48;
  L19 = L45;
  L18 = L43;
  goto LAB2213;
LAB2225:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
if(DecrRefs(L45)<0)
XD_Manalyzer_T73(L45);
if(DecrRefs(L43)<0)
XD_Manalyzer_T61(L43);
  switch (Alternative(L44)) {
  case 1: goto LAB2226;
  default: goto LAB2228;
  };
LAB2226:
  Abort(2123, module_name);
LAB2228:
  Abort(2124, module_name);
LAB2229:
  switch (Alternative(L44)) {
  case 0: goto LAB2231;
  case 2: goto LAB2235;
  case 1: goto LAB2238;
  default: goto LAB2242;
  };
LAB2231:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
  Manalyzer_P_insert_detach_OFFSET_LOCATION_LOCATION(L41,L42,&L49);
  L50 = G_analyzer_IS_ALIVE_NR3186;
  Create(&L51,2,2);
  *(value *)(L51+1) = L49;
  L52 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L41));
  L53 = *((value*)L52);
  ATTACH(L53);
  *(value *)(L51+2) = L53;
if(DecrRefs(*((value*)L52))<0)
XD_Manalyzer_T29(*((value*)L52));
  *((value *)L52) = L51;
  L20 = L50;
  ATTACH(L50);
  L19 = L45;
  L18 = L43;
  goto LAB2213;
LAB2235:
  L20 = L48;
  L19 = L45;
  L18 = L43;
  goto LAB2213;
LAB2238:
  switch (Alternative(L45)) {
  case 1: goto LAB2240;
  default: goto LAB2243;
  };
LAB2240:
  L20 = L48;
  L19 = L45;
  L18 = L43;
  goto LAB2213;
LAB2243:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
  switch (Alternative(L45)) {
  case 0: goto LAB2244;
  default: goto LAB2246;
  };
LAB2244:
  Manalyzer_P_insert_detach_OFFSET_LOCATION_LOCATION(L41,L42,&L54);
  L55 = G_analyzer_IS_ALIVE_NR3187;
  Create(&L56,2,2);
  *(value *)(L56+1) = L54;
  L57 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L41));
  L58 = *((value*)L57);
  ATTACH(L58);
  *(value *)(L56+2) = L58;
if(DecrRefs(*((value*)L57))<0)
XD_Manalyzer_T29(*((value*)L57));
  *((value *)L57) = L56;
  L20 = L55;
  ATTACH(L55);
  L19 = L45;
  L18 = L43;
  goto LAB2213;
LAB2246:
if(DecrRefs(L45)<0)
XD_Manalyzer_T73(L45);
if(DecrRefs(L43)<0)
XD_Manalyzer_T61(L43);
  Abort(2137, module_name);
LAB2242:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
if(DecrRefs(L45)<0)
XD_Manalyzer_T73(L45);
if(DecrRefs(L43)<0)
XD_Manalyzer_T61(L43);
  Abort(2138, module_name);
LAB2247:
  switch (Alternative(L44)) {
  case 0: goto LAB2249;
  case 2: goto LAB2253;
  default: goto LAB2255;
  };
LAB2249:
  L20 = L48;
  L19 = L45;
  L18 = L43;
  goto LAB2213;
LAB2253:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
if(DecrRefs(L43)<0)
XD_Manalyzer_T61(L43);
  L59 = G_analyzer_NUM_LEFT_NR3188;
  Manalyzer_P_insert_detach_OFFSET_LOCATION_LOCATION(L41,L46,&L60);
  L61 = G_analyzer_IS_ALIVE_NR3189;
  Create(&L62,1,2);
  *(value *)(L62+1) = L60;
  L63 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L41));
  L64 = *((value*)L63);
  ATTACH(L64);
  *(value *)(L62+2) = L64;
if(DecrRefs(*((value*)L63))<0)
XD_Manalyzer_T29(*((value*)L63));
  *((value *)L63) = L62;
  L20 = L61;
  ATTACH(L61);
  L19 = L45;
  L18 = L59;
  ATTACH(L59);
  goto LAB2213;
LAB2255:
if(DecrRefs(L45)<0)
XD_Manalyzer_T73(L45);
  switch (Alternative(L44)) {
  case 1: goto LAB2256;
  default: goto LAB2258;
  };
LAB2256:
  L65 = G_analyzer_FAIL_NR3190;
  L20 = L48;
  L19 = L65;
  ATTACH(L65);
  L18 = L43;
  goto LAB2213;
LAB2258:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
if(DecrRefs(L43)<0)
XD_Manalyzer_T61(L43);
  Abort(2148, module_name);
LAB2251:
if(DecrRefs(L48)<0)
XD_Manalyzer_T75(L48);
if(DecrRefs(L45)<0)
XD_Manalyzer_T73(L45);
if(DecrRefs(L43)<0)
XD_Manalyzer_T61(L43);
  Abort(2149, module_name);
LAB2220:
  L20 = L48;
  L19 = L45;
  L18 = L43;
LAB2213:
if(DecrRefs(L11)<0)
XD_Manalyzer_T61(L11);
  L21 = C_INT(1);
  L22 = C_INT(Int(L0) + Int(L21));
  L23 = L9;
  ATTACH(L23);
if(DecrRefs(L2)<0)
XD_Manalyzer_T70(L2);
  L24 = L16;
  L25 = L12;
  Manalyzer_P_recover_failure_OFFSET_LOCATION_LEFTOVER_LEFTOVER_FAILED_LOCATION_LEFTOVER_ALIVE(L22,L1,&L23,L15,&L24,L5,L10,&L25);
if(DecrRefs(L10)<0)
XD_Manalyzer_T70(L10);
  Create(&L26,0,2);
  *(value *)(L26+1) = L18;
  *(value *)(L26+2) = L23;
  Create(&L27,0,2);
  *(value *)(L27+1) = L20;
  *(value *)(L27+2) = L25;
  Create(&L28,0,2);
  *(value *)(L28+1) = L19;
  *(value *)(L28+2) = L24;
  *P7 = L27;
  *P4 = L28;
  *P2 = L26;
  return 1;
LAB1499:
if(DecrRefs(L13)<0)
XD_Manalyzer_T75(L13);
if(DecrRefs(L12)<0)
XD_Manalyzer_T76(L12);
if(DecrRefs(L11)<0)
XD_Manalyzer_T61(L11);
if(DecrRefs(L10)<0)
XD_Manalyzer_T70(L10);
if(DecrRefs(L4)<0)
XD_Manalyzer_T74(L4);
if(DecrRefs(L2)<0)
XD_Manalyzer_T70(L2);
  Abort(2094, module_name);
LAB1493:
if(DecrRefs(L7)<0)
XD_Manalyzer_T76(L7);
if(DecrRefs(L4)<0)
XD_Manalyzer_T74(L4);
if(DecrRefs(L2)<0)
XD_Manalyzer_T70(L2);
  Abort(2095, module_name);
}

int Manalyzer_P_insert_memory_ops_OFFSET_MEM_CONTEXT_LEFTOVER_ALIVE(P0,P1,P2,P3)
value P0;
value P1;
value *P2;
value *P3;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = *P2;
  L3 = *P3;
  L4 = L2;
  L5 = L3;
  Manalyzer_P_handle_control_blocks_OFFSET_MEM_CONTEXT_LEFTOVER_ALIVE(L0,L1,&L4,&L5);
  *P3 = L5;
  *P2 = L4;
  return 1;
}

int Manalyzer_P_clear_transients_OFFSET(P0)
value P0;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB2148:
  L1 = (value)G_analyzer_MAX_OFFSET_NR5;
  if (!(L0 == L1)) goto LAB1558;
  return 1;
LAB1558:
  L2 = (value) Addr((value*)&G_analyzer_ORIGINS_NR17,Int(L0));
  L3 = *((value*)L2);
  ATTACH(L3);
  switch (Alternative(L3)) {
  case 4: goto LAB1559;
  default: goto LAB1560;
  };
LAB1559:
if(DecrRefs(L3)<0)
XD_Manalyzer_T65(L3);
  L4 = G_analyzer_NUM_LEFT_NR3192;
  L5 = (value) Addr((value*)&G_analyzer_AUTO_ATTACHED_NR21,Int(L0));
  ATTACH(L4);
if(DecrRefs(*((value*)L5))<0)
XD_Manalyzer_T61(*((value*)L5));
  *((value *)L5) = L4;
  L6 = C_INT(1);
  L7 = C_INT(Int(L0) + Int(L6));
  L0 = L7;
  goto LAB2148;
LAB1560:
if(DecrRefs(L3)<0)
XD_Manalyzer_T65(L3);
LAB1561:
  L8 = C_INT(1);
  L9 = C_INT(Int(L0) + Int(L8));
  L0 = L9;
  goto LAB2148;
}

int Manalyzer_P_need_attaches_TYPENR(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Mtypes_P_same_TYPENR_TYPENR(L0,&L1);
  if (!Mtypes_P_is_special_type_TYPENR_STYPE(L1,&L2)) goto LAB1562;
  switch (Alternative(L2)) {
  case 0: goto LAB1564;
  default: goto LAB1565;
  };
LAB1564:
if(DecrRefs(L2)<0)
XD_Mtypes_T12(L2);
  return 0;
LAB1562:
  return 1;
LAB1565:
if(DecrRefs(L2)<0)
XD_Mtypes_T12(L2);
  return 1;
  return 1;
}

int Manalyzer_P_register_death_OFFSET_IS_ALIVE(P0,P1)
value P0;
value *P1;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = *P1;
  switch (Alternative(L1)) {
  case 2: goto LAB1585;
  case 0: goto LAB1588;
  case 1: goto LAB1591;
  default: goto LAB1593;
  };
LAB1585:
if(DecrRefs(L1)<0)
XD_Manalyzer_T75(L1);
  L2 = G_analyzer_IS_ALIVE_NR3195;
  Mcode_P_current_LOCATION(&L3);
  Create(&L4,1,2);
  *(value *)(L4+1) = L3;
  L5 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L0));
  L6 = *((value*)L5);
  ATTACH(L6);
  *(value *)(L4+2) = L6;
if(DecrRefs(*((value*)L5))<0)
XD_Manalyzer_T29(*((value*)L5));
  *((value *)L5) = L4;
  *P1 = L2;
  ATTACH(L2);
  return 1;
LAB1588:
  *P1 = L1;
  return 1;
LAB1591:
if(DecrRefs(L1)<0)
XD_Manalyzer_T75(L1);
  Abort(2204, module_name);
LAB1593:
if(DecrRefs(L1)<0)
XD_Manalyzer_T75(L1);
  Abort(2205, module_name);
}

int Manalyzer_P_replace_death_DEATH_LOCATION_LOCATION(P0,P1,P2)
value *P0;
value P1;
value P2;
{
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = *P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L0)) {
  case 3: goto LAB1594;
  case 0: goto LAB1597;
  case 1: goto LAB1602;
  case 2: goto LAB1607;
  default: goto LAB1609;
  };
LAB1594:
  *P0 = L0;
  return 1;
LAB1597:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  if (!(L1 == L3)) goto LAB1601;
  Create(&L5,0,2);
  *(value *)(L5+1) = L2;
  *(value *)(L5+2) = L4;
  ATTACH(L4);
if(DecrRefs(L0)<0)
XD_Manalyzer_T29(L0);
  *P0 = L5;
  return 1;
LAB1601:
  L6 = L4;
  ATTACH(L6);
  Manalyzer_P_replace_death_DEATH_LOCATION_LOCATION(&L6,L1,L2);
  Create(&L7,0,2);
  *(value *)(L7+1) = L3;
if(DecrRefs(L0)<0)
XD_Manalyzer_T29(L0);
  *(value *)(L7+2) = L6;
  *P0 = L7;
  return 1;
LAB1602:
  L8 = (value)(L0[1]);
  L9 = (value)(L0[2]);
  if (!(L1 == L8)) goto LAB1606;
  Create(&L10,1,2);
  *(value *)(L10+1) = L2;
  *(value *)(L10+2) = L9;
  ATTACH(L9);
if(DecrRefs(L0)<0)
XD_Manalyzer_T29(L0);
  *P0 = L10;
  return 1;
LAB1606:
  L11 = L9;
  ATTACH(L11);
  Manalyzer_P_replace_death_DEATH_LOCATION_LOCATION(&L11,L1,L2);
  Create(&L12,1,2);
  *(value *)(L12+1) = L8;
if(DecrRefs(L0)<0)
XD_Manalyzer_T29(L0);
  *(value *)(L12+2) = L11;
  *P0 = L12;
  return 1;
LAB1607:
  L13 = (value)(L0[1]);
  L14 = (value)(L0[2]);
  if (!(L1 == L13)) goto LAB1611;
  Create(&L15,2,2);
  *(value *)(L15+1) = L2;
  *(value *)(L15+2) = L14;
  ATTACH(L14);
if(DecrRefs(L0)<0)
XD_Manalyzer_T29(L0);
  *P0 = L15;
  return 1;
LAB1611:
  L16 = L14;
  ATTACH(L16);
  Manalyzer_P_replace_death_DEATH_LOCATION_LOCATION(&L16,L1,L2);
  Create(&L17,2,2);
  *(value *)(L17+1) = L13;
if(DecrRefs(L0)<0)
XD_Manalyzer_T29(L0);
  *(value *)(L17+2) = L16;
  *P0 = L17;
  return 1;
LAB1609:
if(DecrRefs(L0)<0)
XD_Manalyzer_T29(L0);
  Abort(2227, module_name);
}

int Manalyzer_P_recover_failure_OFFSET_ALIVE_LOCATION_ALIVE(P0,P1,P2,P3)
value P0;
value *P1;
value P2;
value P3;
{
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = *P1;
  L2 = P2;
  L3 = P3;
  switch (Alternative(L3)) {
  case 0: goto LAB1648;
  case 1: goto LAB1651;
  default: goto LAB1653;
  };
LAB1648:
  L4 = (value)(L3[1]);
  L5 = (value)(L3[2]);
  L6 = L1;
  L13 = L6;
  switch (Alternative(L13)) {
  case 1: goto LAB2260;
  case 0: goto LAB2263;
  default: goto LAB2265;
  };
LAB2260:
  L14 = G_analyzer_IS_ALIVE_NR3193;
  L7 = L14;
  ATTACH(L14);
  L6 = L13;
  goto LAB2259;
LAB2263:
  L15 = (value)(L13[1]);
  L16 = (value)(L13[2]);
  L7 = L15;
  ATTACH(L15);
  L6 = L16;
  ATTACH(L16);
if(DecrRefs(L13)<0)
XD_Manalyzer_T76(L13);
LAB2259:
  L17 = L0;
  L18 = L7;
  L19 = L2;
  L20 = L4;
  switch (Alternative(L18)) {
  case 0: goto LAB2267;
  case 2: goto LAB2279;
  case 1: goto LAB2291;
  default: goto LAB2295;
  };
LAB2265:
if(DecrRefs(L13)<0)
XD_Manalyzer_T76(L13);
  Abort(2188, module_name);
LAB2267:
  switch (Alternative(L20)) {
  case 0: goto LAB2269;
  case 2: goto LAB2273;
  case 1: goto LAB2276;
  default: goto LAB2278;
  };
LAB2269:
  L21 = G_analyzer_IS_ALIVE_NR3202;
  L8 = L21;
  ATTACH(L21);
  goto LAB2266;
LAB2273:
  L22 = G_analyzer_IS_ALIVE_NR3203;
  L8 = L22;
  ATTACH(L22);
  goto LAB2266;
LAB2276:
  Abort(2305, module_name);
LAB2278:
  Abort(2306, module_name);
LAB2279:
  switch (Alternative(L20)) {
  case 0: goto LAB2281;
  case 2: goto LAB2285;
  case 1: goto LAB2288;
  default: goto LAB2290;
  };
LAB2281:
  Create(&L23,0,2);
  *(value *)(L23+1) = L19;
  L24 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L17));
  L25 = *((value*)L24);
  ATTACH(L25);
  *(value *)(L23+2) = L25;
if(DecrRefs(*((value*)L24))<0)
XD_Manalyzer_T29(*((value*)L24));
  *((value *)L24) = L23;
  L26 = G_analyzer_IS_ALIVE_NR3204;
  L8 = L26;
  ATTACH(L26);
  goto LAB2266;
LAB2285:
  L27 = G_analyzer_IS_ALIVE_NR3205;
  L8 = L27;
  ATTACH(L27);
  goto LAB2266;
LAB2288:
  L28 = G_analyzer_IS_ALIVE_NR3206;
  L8 = L28;
  ATTACH(L28);
  goto LAB2266;
LAB2290:
  Abort(2315, module_name);
LAB2291:
  switch (Alternative(L20)) {
  case 0: goto LAB2293;
  case 2: goto LAB2297;
  case 1: goto LAB2300;
  default: goto LAB2302;
  };
LAB2293:
  Abort(2318, module_name);
LAB2297:
  L29 = G_analyzer_IS_ALIVE_NR3207;
  L8 = L29;
  ATTACH(L29);
LAB2266:
if(DecrRefs(L7)<0)
XD_Manalyzer_T75(L7);
  L9 = C_INT(1);
  L10 = C_INT(Int(L0) + Int(L9));
  L11 = L6;
  Manalyzer_P_recover_failure_OFFSET_ALIVE_LOCATION_ALIVE(L10,&L11,L2,L5);
  Create(&L12,0,2);
  *(value *)(L12+1) = L8;
  *(value *)(L12+2) = L11;
  *P1 = L12;
  return 1;
LAB2300:
  Abort(2322, module_name);
LAB2302:
  Abort(2323, module_name);
LAB2295:
  Abort(2324, module_name);
LAB1651:
  *P1 = L1;
  return 1;
LAB1653:
if(DecrRefs(L1)<0)
XD_Manalyzer_T76(L1);
  Abort(2296, module_name);
}

int Manalyzer_P_build_local_map_OFFSET_LOCAL_MAP(P0,P1)
value P0;
value *P1;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_analyzer_MAX_OFFSET_NR5;
  if (!(L0 == L1)) goto LAB1691;
  L2 = G_analyzer_LOCAL_MAP_NR3208;
  *P1 = L2;
  ATTACH(L2);
  return 1;
LAB1691:
  L3 = C_INT(1);
  L4 = C_INT(Int(L0) + Int(L3));
  Manalyzer_P_build_local_map_OFFSET_LOCAL_MAP(L4,&L5);
  Create(&L6,0,3);
  L7 = (value) Addr((value*)&G_analyzer_BIRTH_NR27,Int(L0));
  L8 = *((value*)L7);
  *(value *)(L6+1) = L8;
  L9 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L0));
  L10 = *((value*)L9);
  *(value *)(L6+2) = L10;
  ATTACH(L10);
  *(value *)(L6+3) = L5;
  *P1 = L6;
  return 1;
}

int Manalyzer_P_dump_ALTERNATIVE(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_analyzer_TEXT_NR3209;
  if (!E82_get_from_environment_TEXT_TEXT(L1,&L2)) goto LAB1693;
D_TEXT(L2);
  L3 = G_analyzer_TEXT_NR3210;
  Manalyzer_P_dump_ALTERNATIVE_TEXT(L0,L3);
  L4 = G_analyzer_TEXT_NR3211;
  Merrors_P_error_text_TEXT(L4);
  return 1;
LAB1693:
  return 1;
}

int Manalyzer_P_dump_ALTERNATIVE_TEXT(P0,P1)
value P0;
value P1;
{
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  switch (Alternative(L0)) {
  case 2: goto LAB1694;
  case 0: goto LAB1697;
  case 1: goto LAB1700;
  default: goto LAB1702;
  };
LAB1694:
  L2 = (value)(L0[1]);
  L4 = G_analyzer_TEXT_NR3212;
  L3 = Concat(L1,L4);
  Merrors_P_error_text_TEXT(L3);
D_TEXT(L3);
  return 1;
LAB1697:
  L5 = (value)(L0[1]);
  L6 = (value)(L0[2]);
  L7 = (value)(L0[3]);
  L9 = G_analyzer_TEXT_NR3213;
  L8 = Concat(L1,L9);
  Merrors_P_error_text_TEXT(L8);
D_TEXT(L8);
  L11 = G_analyzer_TEXT_NR3214;
  L10 = Concat(L1,L11);
  Manalyzer_P_dump_CODE_TEXT(L5,L10);
D_TEXT(L10);
  L13 = G_analyzer_TEXT_NR3215;
  L12 = Concat(L1,L13);
  Merrors_P_error_text_TEXT(L12);
D_TEXT(L12);
  L15 = G_analyzer_TEXT_NR3216;
  L14 = Concat(L1,L15);
  Manalyzer_P_dump_ALTERNATIVE_TEXT(L6,L14);
D_TEXT(L14);
  L17 = G_analyzer_TEXT_NR3217;
  L16 = Concat(L1,L17);
  Merrors_P_error_text_TEXT(L16);
D_TEXT(L16);
  L19 = G_analyzer_TEXT_NR3218;
  L18 = Concat(L1,L19);
  Manalyzer_P_dump_ALTERNATIVE_TEXT(L7,L18);
D_TEXT(L18);
  L21 = G_analyzer_TEXT_NR3219;
  L20 = Concat(L1,L21);
  Merrors_P_error_text_TEXT(L20);
D_TEXT(L20);
  return 1;
LAB1700:
  L22 = (value)(L0[1]);
  L23 = (value)(L0[2]);
  Manalyzer_P_dump_CODE_TEXT(L22,L1);
  L25 = G_analyzer_TEXT_NR3220;
  L24 = Concat(L1,L25);
  Merrors_P_error_text_TEXT(L24);
D_TEXT(L24);
  return 1;
LAB1702:
  Abort(2354, module_name);
}

int Manalyzer_P_dump_CODE_TEXT(P0,P1)
value P0;
value P1;
{
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  switch (Alternative(L0)) {
  case 2: goto LAB1703;
  case 0: goto LAB1706;
  case 1: goto LAB1709;
  default: goto LAB1711;
  };
LAB1703:
  return 1;
LAB1706:
  L2 = (value)(L0[1]);
  L3 = (value)(L0[2]);
  L4 = (value)(L0[3]);
  L5 = (value)(L0[4]);
  L6 = (value)(L0[5]);
  L7 = (value)(L0[6]);
  Manalyzer_P_dump_CODE_TEXT(L7,L1);
  L9 = G_analyzer_TEXT_NR3221;
  L8 = Concat(L1,L9);
  Merrors_P_error_text_TEXT(L8);
D_TEXT(L8);
  Merrors_P_error_int_INT(L3);
  L10 = G_analyzer_TEXT_NR3222;
  Merrors_P_error_text_TEXT(L10);
  Merrors_P_error_int_INT(L4);
  L11 = G_analyzer_TEXT_NR3223;
  Merrors_P_error_text_TEXT(L11);
  Merrors_P_error_int_INT(L6);
  L12 = G_analyzer_TEXT_NR3224;
  Merrors_P_error_text_TEXT(L12);
  L13 = C_INT(0);
  Manalyzer_P_dump_MEM_CONTEXT_INT_TEXT(L2,L13,L1);
  return 1;
LAB1709:
  L14 = (value)(L0[1]);
  L15 = (value)(L0[2]);
  L16 = (value)(L0[3]);
  Manalyzer_P_dump_CODE_TEXT(L16,L1);
  L18 = G_analyzer_TEXT_NR3225;
  L17 = Concat(L1,L18);
  Merrors_P_error_text_TEXT(L17);
D_TEXT(L17);
  Merrors_P_error_int_INT(L15);
  L19 = G_analyzer_TEXT_NR3226;
  Merrors_P_error_text_TEXT(L19);
  L20 = C_INT(0);
  Manalyzer_P_dump_MEM_CONTEXT_INT_TEXT(L14,L20,L1);
  return 1;
LAB1711:
  Abort(2368, module_name);
}

int Manalyzer_P_dump_MEM_CONTEXT_INT_TEXT(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  switch (Alternative(L0)) {
  case 1: goto LAB1712;
  case 0: goto LAB1715;
  default: goto LAB1717;
  };
LAB1712:
  return 1;
LAB1715:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  Merrors_P_error_text_TEXT(L2);
  Merrors_P_error_int_INT(L1);
  L5 = G_analyzer_TEXT_NR3227;
  Merrors_P_error_text_TEXT(L5);
  Manalyzer_P_dump_APPLICATIONS(L3);
  L6 = G_analyzer_TEXT_NR3228;
  Merrors_P_error_text_TEXT(L6);
  L7 = C_INT(1);
  L8 = C_INT(Int(L1) + Int(L7));
  Manalyzer_P_dump_MEM_CONTEXT_INT_TEXT(L4,L8,L2);
  return 1;
LAB1717:
  Abort(2377, module_name);
}

int Manalyzer_P_dump_APPLICATIONS(P0)
value P0;
{
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 3: goto LAB1718;
  case 0: goto LAB1721;
  case 1: goto LAB1724;
  case 2: goto LAB1727;
  default: goto LAB1729;
  };
LAB1718:
  return 1;
LAB1721:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L3 = (value)(L0[3]);
  Manalyzer_P_dump_APPLICATIONS(L3);
  L4 = G_analyzer_TEXT_NR3229;
  Merrors_P_error_text_TEXT(L4);
  Manalyzer_P_dump_USE(L1);
  L5 = G_analyzer_TEXT_NR3230;
  Merrors_P_error_text_TEXT(L5);
  Merrors_P_error_int_INT(L2);
  return 1;
LAB1724:
  L6 = (value)(L0[1]);
  L7 = (value)(L0[2]);
  Manalyzer_P_dump_APPLICATIONS(L7);
  L8 = G_analyzer_TEXT_NR3231;
  Merrors_P_error_text_TEXT(L8);
  Merrors_P_error_int_INT(L6);
  L9 = G_analyzer_TEXT_NR3232;
  Merrors_P_error_text_TEXT(L9);
  return 1;
LAB1727:
  L10 = (value)(L0[1]);
  L11 = (value)(L0[2]);
  Manalyzer_P_dump_APPLICATIONS(L11);
  L12 = G_analyzer_TEXT_NR3233;
  Merrors_P_error_text_TEXT(L12);
  Merrors_P_error_int_INT(L10);
  return 1;
LAB1729:
  Abort(2396, module_name);
}

int Manalyzer_P_dump_USE(P0)
value P0;
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 0: goto LAB1730;
  case 1: goto LAB1733;
  case 2: goto LAB1736;
  case 3: goto LAB1739;
  case 4: goto LAB1742;
  case 5: goto LAB1745;
  case 6: goto LAB1748;
  case 7: goto LAB1751;
  case 8: goto LAB1754;
  default: goto LAB1756;
  };
LAB1730:
  L1 = (value)(L0[1]);
  L2 = G_analyzer_TEXT_NR3234;
  Merrors_P_error_text_TEXT(L2);
  Merrors_P_error_int_INT(L1);
  L3 = G_analyzer_TEXT_NR3235;
  Merrors_P_error_text_TEXT(L3);
  return 1;
LAB1733:
  L4 = G_analyzer_TEXT_NR3236;
  Merrors_P_error_text_TEXT(L4);
  return 1;
LAB1736:
  L5 = G_analyzer_TEXT_NR3237;
  Merrors_P_error_text_TEXT(L5);
  return 1;
LAB1739:
  L6 = (value)(L0[1]);
  L7 = (value)(L0[2]);
  L8 = G_analyzer_TEXT_NR3238;
  Merrors_P_error_text_TEXT(L8);
  return 1;
LAB1742:
  L9 = G_analyzer_TEXT_NR3239;
  Merrors_P_error_text_TEXT(L9);
  return 1;
LAB1745:
  L10 = G_analyzer_TEXT_NR3240;
  Merrors_P_error_text_TEXT(L10);
  return 1;
LAB1748:
  L11 = G_analyzer_TEXT_NR3241;
  Merrors_P_error_text_TEXT(L11);
  return 1;
LAB1751:
  L12 = G_analyzer_TEXT_NR3242;
  Merrors_P_error_text_TEXT(L12);
  return 1;
LAB1754:
  L13 = G_analyzer_TEXT_NR3243;
  Merrors_P_error_text_TEXT(L13);
  return 1;
LAB1756:
  Abort(2417, module_name);
}

int Manalyzer_P_dump_mapping_OFFSET(P0)
value P0;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_analyzer_MAX_OFFSET_NR5;
  if (!(L0 == L1)) goto LAB1758;
  return 1;
LAB1758:
  Merrors_P_error_int_INT(L0);
  L2 = G_analyzer_TEXT_NR3244;
  Merrors_P_error_text_TEXT(L2);
  L3 = (value) Addr((value*)&G_analyzer_BIRTH_NR27,Int(L0));
  L4 = *((value*)L3);
  Merrors_P_error_int_INT(L4);
  L5 = G_analyzer_TEXT_NR3245;
  Merrors_P_error_text_TEXT(L5);
  L6 = (value) Addr((value*)&G_analyzer_DEATH_NR28,Int(L0));
  L7 = *((value*)L6);
  Manalyzer_P_dump_DEATH(L7);
  L8 = G_analyzer_TEXT_NR3246;
  Merrors_P_error_text_TEXT(L8);
  L9 = C_INT(1);
  L10 = C_INT(Int(L0) + Int(L9));
  Manalyzer_P_dump_mapping_OFFSET(L10);
  return 1;
}

int Manalyzer_P_dump_DEATH(P0)
value P0;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  switch (Alternative(L0)) {
  case 3: goto LAB1759;
  case 0: goto LAB1762;
  case 1: goto LAB1765;
  case 2: goto LAB1768;
  default: goto LAB1770;
  };
LAB1759:
  return 1;
LAB1762:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  L3 = G_analyzer_TEXT_NR3247;
  Merrors_P_error_text_TEXT(L3);
  Merrors_P_error_int_INT(L1);
  Manalyzer_P_dump_DEATH(L2);
  return 1;
LAB1765:
  L4 = (value)(L0[1]);
  L5 = (value)(L0[2]);
  L6 = G_analyzer_TEXT_NR3248;
  Merrors_P_error_text_TEXT(L6);
  Merrors_P_error_int_INT(L4);
  Manalyzer_P_dump_DEATH(L5);
  return 1;
LAB1768:
  L7 = (value)(L0[1]);
  L8 = (value)(L0[2]);
  L9 = G_analyzer_TEXT_NR3249;
  Merrors_P_error_text_TEXT(L9);
  Merrors_P_error_int_INT(L7);
  Manalyzer_P_dump_DEATH(L8);
  return 1;
LAB1770:
  Abort(2439, module_name);
}

