/*
 *  Copyright (C) 1999,2001,2004,2005,2007  Anders Gavare.  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *
 *
 *  $Id: hashfind.c,v 1.4 2005/02/18 08:43:46 debug Exp $
 *
 *  The function is_bufword_known() scans the functions
 *  database and returns a pointer to the (static) filename,
 *  or NULL if not found.
 */


#include "global.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>


extern char **string_hash_table;
extern int string_hash_table_size;


/*  This is set by is_bufword_known() to
    1 if the word is found in MORE than one file,
    0 if the word is only found once.  */
int found_several_definitions;



/*  Buffer for filename:  */
char known_bufword_buffer[SHORTSTR];


/*
 *  is_bufword_known():
 */
char *is_bufword_known(char *buf, int pos)
{
	int p2, len;
	char *db, *eotab;
	char word[SHORTSTR];

	if (buf == NULL || pos < 0 || isdigit(buf[pos]))
		return NULL;

	known_bufword_buffer[0] = '\0';

	/*  Is the left character okey?  */
	if (pos > 0)
		if (isalnum(buf[pos-1]) || buf[pos-1] == '_' ||
		    buf[pos-1] == '.')
			return NULL;

	/*
	 *  Note: the dot is there just to make sure we don't include function
	 *  pointers in structs etc.
	 */

	/*  Find the end of the word:  */
	p2 = pos;
	while (isalnum(buf[p2]) || buf[p2] == '_' || buf[p2] == '.')
		p2 ++;

	len = p2-pos;
	if (len < 1  || len >= SHORTSTR)
		return NULL;

	/*  Make a temporary copy of the word:  */
	strncpy(word, buf+pos, len);
	word[len] = '\0';

	/*
	 *  Find the word in the function name database:
	 */

	found_several_definitions = 0;

	/*  First, look up the hashcode:  */
	p2 = stringhash(word) & HASHMASK;

	/*  Get the address pointer to all strings having this hashcode:  */
	db = string_hash_table[p2];
	if (db == NULL)
		return NULL;

	/*  end of string hash table:  */
	eotab = ((char *) string_hash_table) +string_hash_table_size;

	while (db < eotab && db[0] != '\0') {
		/*  Is this the word?  */
		if (word[0] == db[0] && db[len] == ' ' &&
		    strncmp(word,db,len) == 0) {
			/*  Then return the filename:  */
			/*  Skip the word:  */
			while (db<eotab && db[0] != ' ')
				db++;
			db++;
			while ( (db<eotab) && (db[0]!='\n') ) {
		sprintf (known_bufword_buffer+strlen(known_bufword_buffer),
			"%c", db[0]);
		db++;
	      }
	    db++;
	    //  If we find the word again then the word was found more than once:
	    if ( (db[len]==' ') && (!strncmp(word,db,len)) )
		found_several_definitions = 1;
	    return known_bufword_buffer;
	  }
	else
	  {
	    /*  The database must be SORTED!!!  If db[0]>word[0], then we
		have not found the word and we will not find it in the rest
		of the database either!!!  */
	    if (db[0]>word[0])
		return NULL;

	    /*  Skip this database entry:  */
	    while ( (db<eotab) && (db[0]!='\n') )
		db++;
	  }
	db++;
      }

	return NULL;
}


/*
 *  get_all_known_filenames():
 *
 *  Instead of just saying that there were multiple definitions and
 *  returning one, we should be able to get the other filenames too:
 */
char *get_all_known_filenames(char *word, int filename_nr)
{
	int p2, len;
	char *db, *eotab;

	if (!word)
		return NULL;

	len = strlen(word);

	/*
	 *  Find the word in the function name database:
	 */

	/*  First, look up the hashcode:  */
	p2 = stringhash (word) & HASHMASK;

	/*  Get the address pointer to all strings having this hashcode:  */
	db = string_hash_table[p2];
	if (!db)
		return NULL;

	/*  end of string hash table:  */
	eotab = ((char *) string_hash_table) +string_hash_table_size;

	while (db < eotab && db[0] != '\0') {
		/*  printf("TRY:  =  '%s'\n", db);  */

	/*  Is this the word?  */
	if ( (word[0]==db[0]) && (db[len]==' ') && (!strncmp(word,db,len)) )
	  {
	    /*  Then return the filename:  */
	    //  Skip the word:
	    while ( (db<eotab) && (db[0]!=' ') )
		db++;
	    db++;
	    known_bufword_buffer[0]=0;
	    while ( (db<eotab) && (db[0]!='\n') )
	      {
		sprintf (known_bufword_buffer+strlen(known_bufword_buffer),
			"%c", db[0]);
		db++;
	      }

	    if (filename_nr <= 0)
		return known_bufword_buffer;

	    filename_nr --;
	  }
	else
	  {
	    /*  The database must be SORTED!!!  If db[0]>word[0], then we
		have not found the word and we will not find it in the rest
		of the database either!!!  */
	    if (db[0]>word[0])
		return NULL;

	    /*  Skip this database entry:  */
	    while ( (db<eotab) && (db[0]!='\n') )
		db++;
	  }
		db++;
	}

	return NULL;
}

