/*
 * format.c: Output format configuration stuff
 *
 * Written By Timothy Jensen
 *
 * Copyright(c) 1999 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#ifndef lint
static	char	rcsid[] = "@(#)$Id: format.c,v 1.3 1999/07/25 22:05:03 toast Exp $";
#endif

#include "irc.h"

#include "format.h"
#include "ircaux.h"
#include "parse.h"
#include "ignore.h"
#include "comstud.h"
#include "toast.h"

extern	int	from_server;
extern  char    *get_server_itsname();

int	hilite;

void	set_format(int, char *);
void	set_num_format(int, char *);
void	set_fmt(int, char *);

typedef struct
{
	char	*name;
	char	*fmt;
	char	*args;
} IrcFormat;

typedef struct numfmt
{
	int	num;
	char	*fmt;
	struct numfmt *next;
} NumFormat;

static NumFormat num_format = {-1, NULL, NULL};

static IrcFormat irc_format[] =
{
	{ "ACTION",			NULL, "FTM" },
	{ "ACTION_OTHER",		NULL, "FTM" },
	{ "DCC_CHAT",			NULL, "FM" },
	{ "DCC_CHAT_ACTION",		NULL, "FM" },
	{ "DCC_TALK",			NULL, "FM" },
	{ "GONE",			NULL, "M" },
	{ "INVITE",			NULL, "FTC" },
	{ "JOIN",			NULL, "FC" },
	{ "JOIN_SELF",			NULL, "FC" },
	{ "KICK",			NULL, "FCTM" },
	{ "KICK_SELF",			NULL, "FCTM" },
	{ "KILL",			NULL, "FHTSM" },
	{ "MODE",			NULL, "FCM" },
	{ "MSG",			NULL, "FTM" },
	{ "MSG_GROUP",			NULL, "FTM" },
	{ "NICK",			NULL, "FN" },
	{ "NOTICE",			NULL, "FTM" },
	{ "NOTIFY_SIGNOFF",		NULL, "N" },
	{ "NOTIFY_SIGNON",		NULL, "N" },
	{ "NOTIFY_SIGNON_USERHOST",	NULL, "N" },
	{ "PART",			NULL, "FC" },
	{ "PART_SELF",			NULL, "FC" },
	{ "PUBLIC",			NULL, "FTM" },
	{ "PUBLIC_ACTION",		NULL, "FTM" },
	{ "PUBLIC_MSG",			NULL, "FTM" },
	{ "PUBLIC_NOTICE",		NULL, "FTM" },
	{ "PUBLIC_OTHER",		NULL, "FTM" },
	{ "RECORDER_BODY",		NULL, "DFMN" },
	{ "RECORDER_HEAD",		NULL, "DFMN" },
	{ "SEND_ACTION",		NULL, "FTM" },
	{ "SEND_DCC_CHAT",		NULL, "TM" },
	{ "SEND_DCC_TALK",		NULL, "TM" },
	{ "SEND_LOCOPS",		NULL, "FM" },
	{ "SEND_MSG",			NULL, "FTM" },
	{ "SEND_NOTICE",		NULL, "FTM" },
	{ "SEND_OPERWALL",		NULL, "FM" },
	{ "SEND_PUBLIC",		NULL, "FTM" },
	{ "SEND_PUBLIC_ACTION",		NULL, "FTM" },
	{ "SEND_PUBLIC_MSG",		NULL, "FTM" },
	{ "SEND_PUBLIC_OTHER",		NULL, "FTM" },
	{ "SEND_WALLOPS",		NULL, "FM" },
	{ "SERVER_KILL",		NULL, "FTM" },
	{ "SERVER_NOTICE",		NULL, "M" },
	{ "SERVER_WALLOPS",		NULL, "FM" },
	{ "QUIT",			NULL, "FM" },
	{ "UMODE",			NULL, "FTM" },
	{ "WALL",			NULL, "FM" },
	{ "WALLOPS",			NULL, "FM" },
	{ (char *) NULL, (char *) NULL, (char *) NULL }
};

void
init_formats()
{
	set_fmt(ACTION_FMT, FDEF_ACTION);
	set_fmt(ACTION_OTHER_FMT, FDEF_ACTION_OTHER);
	set_fmt(DCC_CHAT_FMT, FDEF_DCC_CHAT);
	set_fmt(DCC_CHAT_ACTION_FMT, FDEF_DCC_CHAT_ACTION);
	set_fmt(DCC_TALK_FMT, FDEF_DCC_TALK);
	set_fmt(GONE_FMT, FDEF_GONE);
	set_fmt(INVITE_FMT, FDEF_INVITE);
	set_fmt(JOIN_FMT, FDEF_JOIN);
	set_fmt(JOIN_SELF_FMT, FDEF_JOIN_SELF);
	set_fmt(KICK_FMT, FDEF_KICK);
	set_fmt(KICK_SELF_FMT, FDEF_KICK_SELF);
	set_fmt(KILL_FMT, FDEF_KILL);
	set_fmt(MODE_FMT, FDEF_MODE);
	set_fmt(MSG_FMT, FDEF_MSG);
	set_fmt(MSG_GROUP_FMT, FDEF_MSG_GROUP);
	set_fmt(NICK_FMT, FDEF_NICK);
	set_fmt(NOTICE_FMT, FDEF_NOTICE);
	set_fmt(NOTIFY_SIGNOFF_FMT, FDEF_NOTIFY_SIGNOFF);
	set_fmt(NOTIFY_SIGNON_FMT, FDEF_NOTIFY_SIGNON);
	set_fmt(NOTIFY_SIGNON_USERHOST_FMT, FDEF_NOTIFY_SIGNON_USERHOST);
	set_fmt(PART_FMT, FDEF_PART);
	set_fmt(PART_SELF_FMT, FDEF_PART_SELF);
	set_fmt(PUBLIC_FMT, FDEF_PUBLIC);
	set_fmt(PUBLIC_ACTION_FMT, FDEF_PUBLIC_ACTION);
	set_fmt(PUBLIC_MSG_FMT, FDEF_PUBLIC_MSG);
	set_fmt(PUBLIC_NOTICE_FMT, FDEF_PUBLIC_NOTICE);
	set_fmt(PUBLIC_OTHER_FMT, FDEF_PUBLIC_OTHER);
	set_fmt(PUBLIC_ACTION_FMT, FDEF_PUBLIC_ACTION);
	set_fmt(RECORDER_BODY_FMT, FDEF_RECORDER_BODY);
	set_fmt(RECORDER_HEAD_FMT, FDEF_RECORDER_HEAD);
	set_fmt(SEND_ACTION_FMT, FDEF_SEND_ACTION);
	set_fmt(SEND_DCC_CHAT_FMT, FDEF_SEND_DCC_CHAT);
	set_fmt(SEND_DCC_TALK_FMT, FDEF_SEND_DCC_TALK);
	set_fmt(SEND_LOCOPS_FMT, FDEF_SEND_LOCOPS);
	set_fmt(SEND_MSG_FMT, FDEF_SEND_MSG);
	set_fmt(SEND_NOTICE_FMT, FDEF_SEND_NOTICE);
	set_fmt(SEND_OPERWALL_FMT, FDEF_SEND_OPERWALL);
	set_fmt(SEND_PUBLIC_FMT, FDEF_SEND_PUBLIC);
	set_fmt(SEND_PUBLIC_ACTION_FMT, FDEF_SEND_PUBLIC_ACTION);
	set_fmt(SEND_PUBLIC_MSG_FMT, FDEF_SEND_PUBLIC_MSG);
	set_fmt(SEND_PUBLIC_OTHER_FMT, FDEF_SEND_PUBLIC_OTHER);
	set_fmt(SEND_WALLOPS_FMT, FDEF_SEND_WALLOPS);
	set_fmt(SERVER_KILL_FMT, FDEF_SERVER_KILL);
	set_fmt(SERVER_NOTICE_FMT, FDEF_SERVER_NOTICE);
	set_fmt(SERVER_WALLOPS_FMT, FDEF_SERVER_WALLOPS);
	set_fmt(QUIT_FMT, FDEF_QUIT);
	set_fmt(UMODE_FMT, FDEF_UMODE);
	set_fmt(WALL_FMT, FDEF_WALL);
	set_fmt(WALLOPS_FMT, FDEF_WALLOPS);
}

int
find_format(org_name, cnt)
char	*org_name;
int	*cnt;
{
	IrcFormat *f,
		  *first;
	int	len,
		fmt_index;
	char	*name = (char *) 0;

	malloc_strcpy(&name, org_name);
	upper(name);
	len = strlen(name);
	fmt_index = 0;
	for (first = irc_format; first->name; first++, fmt_index++) {
		if (strncmp(name, first->name, len) == 0) {
			*cnt = 1;
			break;
		}
	}
	if (first->name) {
		if (strlen(first->name) != len) {
			f = first;
			for (f++; f->name; f++, (*cnt)++) {
				if (strncmp(name, f->name, len) != 0)
					break;
			}
		}
		new_free(&name);
		return fmt_index;
	} else {
		*cnt = 0;
		new_free(&name);
		return -1;
	}
}

void
formatcmd(command, args)
char	*command,
	*args;
{
	NumFormat *temp;
	char	*which;
	int	i, cnt;
	
	which = my_next_arg(&args);
	if (which && *which) {
		if (is_number(which))
			set_num_format(atoi(which), args);
		else {
			i = find_format(which, &cnt);
			switch (cnt) {
			case 0:
				say("No such format \"%s\"", which);
				break;
			case 1:
				set_format(i, args);
				break;
			default:
				say("%s is ambiguous", which);
				for (cnt += i; i < cnt; i++)
					set_format(i, empty_string);
			}
		}
	} else {
		temp = num_format.next;
		while (temp) {
			set_num_format(temp->num, empty_string);
			temp = temp->next;
		}
		for (i = 0; i < NUMBER_OF_FORMATS; i++)
				set_format(i, empty_string);
	}
}

char *
do_format(FormatStr, ParamStr, Args)
char	*FormatStr,
	*ParamStr,
	**Args;
{
	static char	result[1024];
	char	this;
	int	pos = 0;

	bzero(result, 1024);

	while ((pos < 1023) && ((this = *FormatStr++) != 0)) {
		if (this == '%')
			switch (this = *FormatStr++) {
			case '%':
			  result[pos++] = '%';
			  break;
			case '!':
			  if (hilite)
			    result[pos++] = highlight_char;
			  break;
			case '@':
			  {
			    char *TS;
			    TS = TimeStamp();
			    strmcat(result, TS, 1023);
			    pos += strlen(TS);
			  }
			  break;
			case 'u':
			case 'U':
			  if (FromUserHost) {
			  	strmcat(result, FromUserHost, 1023);
			  	pos += strlen(FromUserHost);
			  }
			  break;
			case '*':
			  if (FromUserHost) {
			    char *uh;
			    uh = cluster(FromUserHost);
			    strmcat(result, uh, 1023);
			    pos += strlen(uh);
			  }
			  break;
			default:
			  {
			    int i;
			    for (i = 0; ParamStr[i]; i++)
			      if ((ParamStr[i] == toupper(this)) && Args[i]) {
				strmcat(result, Args[i], 1023);
				pos += strlen(Args[i]);
				break;
			      }
			  }
			}
		else
			result[pos++] = this;
	}
	hilite = 0;
	return (char *) &result;
}

char *
parseformat(FmtNum, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10)
int	FmtNum;
char	*arg1, *arg2, *arg3, *arg4, *arg5,
	*arg6, *arg7, *arg8, *arg9, *arg10;
{
	char	*args[10];

	args[0] = arg1; args[1] = arg2; args[2] = arg3; args[3] = arg4;
	args[4] = arg5; args[5] = arg6; args[6] = arg7; args[7] = arg8;
	args[8] = arg9; args[9] = arg10;

	return do_format(irc_format[FmtNum].fmt, irc_format[FmtNum].args, args);
}

char *
numericformat(FmtNum, Server, Banner, Args)
int	FmtNum;
char	*Server,
	*Banner,
	**Args;
{
	NumFormat *temp;
	char	*srvr = (char *) 0;
	char	*args[12] =	{ empty_string, empty_string, empty_string,
				empty_string, empty_string, empty_string,
				empty_string, empty_string, empty_string,
				empty_string, empty_string, empty_string };
	int	i;

	if (Server)  {
		srvr = new_malloc(strlen(Server) + 7);
		sprintf(srvr, "(from %s)", Server);
	} else
		malloc_strcpy(&srvr, empty_string);
	if (Server && (my_strnicmp(get_server_itsname(from_server), Server,
			strlen(get_server_itsname(from_server))) == 0))
		args[0] = empty_string;
	else
		args[0] = srvr;
	args[1] = Banner;
	for (i = 0; i < 10 && Args[i]; i++)
	  args[2+i] = Args[i];

	temp = num_format.next;
	while (temp) {
		if (temp->num == FmtNum)
			return do_format(temp->fmt, "S#0123456789", args);
		temp = temp->next;
	}
	new_free(srvr);
	return (char *) 0;
}

void
set_num_format(FmtNum, Fmt)
int	FmtNum;
char	*Fmt;
{
	NumFormat *temp, *last;
	int remove = 0;

	if (FmtNum < 0) {
		FmtNum = -FmtNum;
		remove = 1;
	}

	temp = num_format.next;
	last = &num_format;
	while (temp && (temp->num <= FmtNum)) {
		if (temp->num == FmtNum) {
			if (remove) {
				last->next = temp->next;
				new_free(&temp->fmt);
				new_free(&temp);
				temp = last->next;
				say("%03d format removed.", FmtNum);
				return;
			} else if (Fmt && *Fmt) {
				malloc_strcpy(&temp->fmt, Fmt);
				say("Format of %03d set to \"%s\"", FmtNum, Fmt);
				return;
			} else {
				say("%03d = \"%s\"", FmtNum, temp->fmt);
				return;
			}
		}
		last = temp;
		temp = temp->next;
	}
	if (remove)
		say("No format for %03d has been set.", FmtNum);
	else if (Fmt && *Fmt) {
		NumFormat *new = (NumFormat *) new_malloc(sizeof(NumFormat));
		new->num = FmtNum;
		new->fmt = (char *) 0;
		malloc_strcpy(&new->fmt, Fmt);
		temp = num_format.next;
		last = &num_format;
		while (temp && (temp->num < FmtNum)) {
			last = temp;
			temp = temp->next;
		}
		new->next = temp;
		last->next = new;
		say("Format of %03d set to \"%s\"", FmtNum, Fmt);
	} else
		say("No format for %03d has been set.", FmtNum);
}

void
set_format(FmtNum, Fmt)
int	FmtNum;
char	*Fmt;
{
	if ((FmtNum < 0) || (FmtNum >= NUMBER_OF_FORMATS))
		return;
	if (Fmt && *Fmt) {
		malloc_strcpy(&irc_format[FmtNum].fmt, Fmt);
		say("Format of %s set to \"%s\"", irc_format[FmtNum].name, Fmt);
	} else {
		say("%-22s = \"%s\"", irc_format[FmtNum].name,
			irc_format[FmtNum].fmt?irc_format[FmtNum].fmt:"<empty>");
	}
}

void
set_fmt(FmtNum, Fmt)
int	FmtNum;
char	*Fmt;
{
	if ((FmtNum < 0) || (FmtNum >= NUMBER_OF_FORMATS))
		return;
	malloc_strcpy(&irc_format[FmtNum].fmt, Fmt);
}

void
save_formats(fp)
FILE	*fp;
{
	int	i;
	NumFormat *temp = num_format.next;

	for (temp = num_format.next; temp; temp = temp->next)
		if (temp->fmt)
			fprintf(fp, "FORMAT %03d %s\n", temp->num,
				temp->fmt);
	for (i = 0; i < NUMBER_OF_FORMATS; i++)
		if (irc_format[i].fmt)
			fprintf(fp, "FORMAT %s %s\n", irc_format[i].name,
				irc_format[i].fmt);
}

void
do_highlight(yesno)
int	yesno;
{
	hilite = yesno;
}

int
num_format_exists(FmtNum)
int	FmtNum;
{
	NumFormat *temp = num_format.next;
	while (temp && (temp->num <= FmtNum)) {
		if (temp->num == FmtNum)
			return 1;
		temp = temp->next;
	}
	return 0;
}
