#! /bin/sh
#=======================================================================
# Run validation tests on bibXXX (XXX = lex, parse, or unlex).
#
# Usage:
#	./docheck.sh PROGRAM test1 test2 ...
#
# The first argument is the name of the program to test; it should be
# absolute, relative, or else known to be in the search path.
#
# The second through last of the files are the basenames of test
# files.
#
# [03-Jun-1998]
#=======================================================================

# Validate the argument count
if test $# -lt 2
then
    echo Usage: ./docheck.sh PROGRAM test1 test2 ...
    exit 1
fi

# Validate the program name
PROGRAM=$1
if test -f $PROGRAM
then
    true
else
    PROGRAM=`which $PROGRAM`
fi

if test -f $PROGRAM
then
    true
else
    echo $1 not found
    exit 1
fi

# Discard the first argument; what remains are the test basenames
shift

CMP=cmp
DIFF=diff
RM="rm -f"

for f in "$@"
do
    if test -f $f.opt
    then
	echo $f: options `cat $f.opt`
	${PROGRAM} `cat $f.opt` $f.in >$f.out 2>$f.err
    else
	echo $f
	${PROGRAM} $f.in >$f.out 2>$f.err
    fi

    # The sed step is necessary to handle SGI IRIX 6 lex output, and
    # bison output, and is harmless on other systems.
    sed -e 's/Syntax error/syntax error/' \
	-e 's/parse error/syntax error/' \
	< $f.err >$f.er2
    mv $f.er2 $f.err

    if ${CMP} okay/$f.err $f.err
    then ${RM} $f.err
    else
	echo Failure on $f.err ...
	${DIFF} okay/$f.err $f.err
    fi
    if ${CMP} okay/$f.out $f.out
    then ${RM} $f.out
    else
	echo Failure on $f.out ...
	${DIFF} okay/$f.out $f.out
    fi
done
