#include <stdio.h>
#include <stdlib.h>
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# ifndef YYLMAX 
#define YYLMAX BIBYYLMAX
# endif 
#ifndef __cplusplus
# define output(c) (void)putc(c,yyout)
#else
# define lex_output(c) (void)putc(c,yyout)
#endif

#if defined(__cplusplus) || defined(__STDC__)

#if defined(__cplusplus) && defined(__EXTERN_C__)
extern "C" {
#endif
	int yyback(int *, int);
	int yyinput(void);
	int yylook(void);
	void yyoutput(int);
	int yyracc(int);
	int yyreject(void);
	void yyunput(int);
	int yylex(void);
#ifdef YYLEX_E
	void yywoutput(wchar_t);
	wchar_t yywinput(void);
#endif
#ifndef yyless
	int yyless(int);
#endif
#ifndef yywrap
	int yywrap(void);
#endif
#ifdef LEXDEBUG
	void allprint(char);
	void sprint(char *);
#endif
#if defined(__cplusplus) && defined(__EXTERN_C__)
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
	void exit(int);
#ifdef __cplusplus
}
#endif

#endif
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
#ifndef __cplusplus
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
#else
# define lex_input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
#endif
#define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng;
#define YYISARRAY
char yytext[131072];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;

# line 2 "biblex.l"
	/* bibparse - parse BibTeX file according to prototype grammar */
 /**********************************************************************
 @Lex-file{
    author              = "Nelson H. F. Beebe",
    version             = "1.04",
    date                = "07 May 1999",
    time                = "07:53:04 MDT",
    filename            = "biblex.l",
    address             = "Center for Scientific Computing
                           University of Utah
                           Department of Mathematics, 322 INSCC
                           155 S 1400 E RM 233
                           Salt Lake City, UT 84112-0090
                           USA",
    telephone           = "+1 801 581 5254",
    FAX                 = "+1 801 585 1640, +1 801 581 4148",
    URL                 = "http://www.math.utah.edu/~beebe",
    checksum            = "04346 616 1389 12897",
    email               = "beebe@math.utah.edu, beebe@acm.org,
                           beebe@ieee.org (Internet)",
    codetable           = "ISO/ASCII",
    keywords            = "BibTeX, bibliography, lexical analysis, lexer",
    supported           = "yes",
    docstring           = "This lex file defines a lexical analyzer for
                           a prototype BibTeX grammar.

                           The resulting program reads one or more
                           BibTeX files specified on the command line,
                           or standard input, and produces on the
                           standard output a stream of tokens of the
                           form

                           <small-integer><tab><name><tab><quoted string>

                           This is similar to the format produced by
                           bibclean with the -no-prettyprint option.

                           Such token lines are interspersed with
                           input line identifier lines of the form
                           used by the ANSI/ISO Standard C preprocessor

                           # line 3 <quoted filename>

                           so that the error diagnostics can identify
                           the location in the input file(s).

                           The output stream can be filtered by other
                           utilities, and reconstructed into a BibTeX
                           file with an associated software tool,
                           bibunlex.

                           The checksum field above contains a CRC-16
                           checksum as the first value, followed by the
                           equivalent of the standard UNIX wc (word
                           count) utility output of lines, words, and
                           characters.  This is produced by Robert
                           Solovay's checksum utility.",
 }
 **********************************************************************/

#include <config.h>

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#if defined(HAVE_STDLIB_H)
#include <stdlib.h>
#endif

#include "args.h"
#include "bibyydcl.h"

#include "token.h"

static void		compact_space ARGS((void));
static void		eof_error ARGS((void));
static int		next_char ARGS((void));
static token_t		out_braced_literal ARGS((void));
static token_t		out_braced_string ARGS((void));
static token_t		out_lbrace ARGS((void));
static token_t		out_lparen ARGS((void));
static token_t		out_protected_string ARGS((token_t t));
static token_t		out_rbrace ARGS((void));
static token_t		out_rparen ARGS((void));
static token_t		out_string ARGS((void));
static token_t		out_token ARGS((token_t t_));
static void		overflow ARGS((void));

static int		brace_level = 0;
int			do_lex_output = 1;
static token_t		last_object = TOKEN_UNKNOWN;
static token_t		last_token = TOKEN_UNKNOWN;
long			line_number = 1L; /* global: used in lexmain() */
static int		paren_level = 0;
const char		*the_filename = ""; /* global: used in lexmain() */

#define BYTE_VAL(c)	((unsigned int)((c) & 0xff))
#define EOFILE		0		/* end-of-file from lex input() */
#define ISPRINT(c)	isprint(BYTE_VAL(c)) /* ensure arg in 0..255 */
#define ISDIGIT(c)	isdigit(BYTE_VAL(c))
#define ISSPACE(c)	isspace(BYTE_VAL(c))
#define RETURN(n)	return (1000 + (n))	/* bibparse.y biases by 1000 */

#undef YYLMAX

#if defined(HAVE_IBMPC)
#define YYLMAX BIBYYLMAX
#else
#define YYLMAX BIBYYLMAX
#endif

			/* increase transition and output table sizes */
				/* abbrev, entry, key, field name syntax */
					/* BibTeX entry opening delimiter */
					/* one white space character */
					/* \013 == \v, but lex doesn't */
					/* recognize \v */
					/* optional `horizontal' space */
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
#ifdef __cplusplus
/* to avoid CC and lint complaining yyfussy not being used ...*/
static int __lex_hack = 0;
if (__lex_hack) goto yyfussy;
#endif
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:

# line 130 "biblex.l"
			RETURN (out_token(TOKEN_AT));
break;
case 2:

# line 132 "biblex.l"
{RETURN ((last_token == TOKEN_AT) ?
					out_token(TOKEN_COMMENT) :
					out_token(TOKEN_ABBREV)); }
break;
case 3:

# line 136 "biblex.l"
{RETURN ((last_token == TOKEN_AT) ?
					out_token(TOKEN_INCLUDE) :
					out_token(TOKEN_ABBREV)); }
break;
case 4:

# line 140 "biblex.l"
{ RETURN ((last_token == TOKEN_AT) ?
					out_token(TOKEN_PREAMBLE) :
					out_token(TOKEN_ABBREV)); }
break;
case 5:

# line 144 "biblex.l"
{ RETURN ((last_token == TOKEN_AT) ?
					out_token(TOKEN_STRING) :
					out_token(TOKEN_ABBREV)); }
break;
case 6:

# line 148 "biblex.l"
			{
				    if (last_object == TOKEN_STRING)
					RETURN(out_token(TOKEN_ABBREV));
				    switch (last_token)
				    {
				    case TOKEN_COMMA:
					RETURN(out_token(TOKEN_FIELD));
				    case TOKEN_LBRACE:
					RETURN(out_token(TOKEN_KEY));
				    case TOKEN_AT:
					RETURN(out_token(TOKEN_ENTRY));
				    default:
					RETURN(out_token(TOKEN_ABBREV));
				    }
				}
break;
case 7:

# line 164 "biblex.l"
			RETURN (out_token(TOKEN_VALUE));
break;
case 8:

# line 166 "biblex.l"
		RETURN (out_token(TOKEN_INLINE));
break;
case 9:

# line 168 "biblex.l"
			RETURN (out_token(TOKEN_SHARP));
break;
case 10:

# line 170 "biblex.l"
			RETURN (out_string());
break;
case 11:

# line 172 "biblex.l"
			RETURN (out_lbrace());
break;
case 12:

# line 174 "biblex.l"
			RETURN (out_rbrace());
break;
case 13:

# line 176 "biblex.l"
			RETURN (out_lparen());
break;
case 14:

# line 178 "biblex.l"
			RETURN (out_rparen());
break;
case 15:

# line 180 "biblex.l"
			RETURN (out_token(TOKEN_EQUALS));
break;
case 16:

# line 182 "biblex.l"
			RETURN (out_token(TOKEN_COMMA));
break;
case 17:

# line 184 "biblex.l"
			RETURN (out_token(TOKEN_NEWLINE));
break;
case 18:

# line 186 "biblex.l"
			RETURN (out_token(TOKEN_SPACE));
break;
case 19:

# line 188 "biblex.l"
			RETURN (out_token(TOKEN_LITERAL));
break;
case -1:
break;
default:
(void)fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

# line 191 "biblex.l"
static void
compact_space(VOID) /* compact runs of space to single blank */
{
    char *p;
    char *q;

    for (p = q = (char*)&yytext[0]; *p ; )
    {
	*q++ = ISSPACE(*p) ? ' ' : *p;
	if (ISSPACE(*p))
	{
	    while (ISSPACE(*p))
		++p;
	}
	else
	    ++p;
    }
    *q = '\0';
}


static void
eof_error(VOID)
{
    (void)fprintf(stderr,"End-of-file in value string\n");
    exit(EXIT_FAILURE);
}


static int
next_char(VOID)
{
    int c;

    c = input();
    if ((c == EOFILE) || (c == EOF))	/* lex uses EOFILE, flex uses EOF */
	eof_error();
    else if (c == '\n')
	line_number++;

    return (c);
}


static token_t
out_braced_literal(VOID)
{
    int c;
    int n;
    int plevel = paren_level;

    for (n = 1; brace_level > 0; )
    {
	c = next_char();
	if (c == EOF)
	    break;
	if (n > (YYLMAX - 2))
	    overflow();
	yytext[n++] = c;
	switch (c)
	{
	case '(':
	    plevel++;
	    break;
	case ')':
	    plevel--;
	    break;
	case '{':
	    brace_level++;
	    break;
	case '}':
	    brace_level--;
	    break;
	default:
	    break;
	}
	if ((paren_level > 0) && (plevel == 0))
	    break;
    }
    yytext[0] = '{';
    yytext[n-1] = '}';
    yytext[n] = '\0';
    return (out_token(TOKEN_LITERAL));
}


static token_t
out_braced_string(VOID)
{					/* convert braced to quoted string */
    int blevel;
    int c;
    int n;

    for (blevel = 1, n = 1; (blevel > 0); )
    {
	c = next_char();
	if (c == EOF)
	    break;
	if (n > (YYLMAX - 5))
	    overflow();
	yytext[n++] = c;
	switch (c)
	{
	case '{':
	    blevel++;
	    break;

	case '}':
	    blevel--;
	    break;

	case '"':
	    if (blevel == 1)
	    {
		if (yytext[n-2] == '\\')
		{
		    c = next_char();
		    if (c == EOF)
			break;
		    yytext[n-2] = '{';
		    yytext[n-1] = '\\';
		    yytext[n++] = '"';
		    yytext[n++] = c;
		    yytext[n++] = '}';
		}
		else
		{
		    yytext[n-1] = '{';
		    yytext[n++] = '"';
		    yytext[n++] = '}';
		}
	    }
	    break;

	default:
	    break;
	}
    }
    yytext[0] = '"';
    yytext[n-1] = '"';
    yytext[n] = '\0';
    return (out_token(TOKEN_VALUE));
}


static token_t
out_lbrace(VOID)
{
    if (brace_level == 0)
    {
	brace_level++;
	switch (last_object)
	{
	case TOKEN_COMMENT:
	case TOKEN_INCLUDE:
	    return (out_braced_literal());
	default:
	    return (out_token(TOKEN_LBRACE));
	}
    }
    else
	return (out_braced_string());
}


static token_t
out_lparen(VOID)
{
    switch (last_token)
    {
    case TOKEN_ENTRY:
    case TOKEN_PREAMBLE:
    case TOKEN_STRING:
	yytext[0] = '{';
	paren_level++;
	brace_level++;
	return (out_token(TOKEN_LBRACE));

    case TOKEN_COMMENT:
    case TOKEN_INCLUDE:
	yytext[0] = '{';
	paren_level++;
	brace_level++;
	return (out_braced_literal());

    default:
	return (out_token(TOKEN_LITERAL));
    }
}


#if NEW_STYLE
static token_t
out_protected_string(token_t t)
#else /* K&R style */
static token_t
out_protected_string(t)
token_t t;
#endif /* NEW_STYLE */
{
    char octal[4 + 1];
    const char *token = (const char*)&yytext[0];

    if (*token == (char)'\0')	/* ignore empty tokens */
	return (TOKEN_VALUE);
    output('"');
    if ((yytext[0] != '"') && (t == TOKEN_VALUE))
    {					/* supply missing quote delimiters */
	output('\\');
	output('\"');
    }
    for (; *token; ++token)
    {
	switch (*token)
	{
	case '"':
	case '\\':
	    output('\\');
	    output(*token);
	    break;
	case '\b':
	    output('\\');
	    output('b');
	    break;
	case '\f':
	    output('\\');
	    output('f');
	    break;
	case '\n':
	    output('\\');
	    output('n');
	    break;
	case '\r':
	    output('\\');
	    output('r');
	    break;
	case '\t':
	    output('\\');
	    output('t');
	    break;
	case '\v':
	    output('\\');
	    output('v');
	    break;
	default:
	    if (ISPRINT(*token))
		output(*token);
	    else
	    {
		(void)sprintf(octal,"\\%03o",BYTE_VAL(*token));
		output(octal[0]);
		output(octal[1]);
		output(octal[2]);
		output(octal[3]);
	    }
	    break;
	}
    }
    if ((yytext[0] != '"') && (t == TOKEN_VALUE))
    {					/* supply missing quote delimiters */
	output('\\');
	output('\"');
    }
    output('"');
    output('\n');
    return (TOKEN_VALUE);
}


static token_t
out_rbrace(VOID)
{
    if (brace_level == 1)
    {
	brace_level--;
	return (out_token(TOKEN_RBRACE));
    }
    else
	return (out_token(TOKEN_LITERAL));
}


static token_t
out_rparen(VOID)
{
    paren_level--;
    if (paren_level  == 0)
    {
	yytext[0] = '}';
	brace_level--;
	return (out_token(TOKEN_RBRACE));
    }
    else
	return (out_token(TOKEN_LITERAL));
}


static token_t
out_string(VOID)
{
    int blevel;
    int c;
    int n;

    for (blevel = 0, n = 1; ; )
    {
	c = next_char();
	if (c == EOF)
	    break;
	if (n > (YYLMAX - 2))
	    overflow();
	yytext[n++] = c;
	switch (c)
	{
	case '{':
	    blevel++;
	    break;
	case '}':
	    blevel--;
	    break;
	case '"':
	    if (blevel == 0)
		goto LOOP_EXIT;
	default:
	    break;
	}
    }
 LOOP_EXIT:
    yytext[n++] = '\0';
    return (out_token(TOKEN_VALUE));
}


#if NEW_STYLE
static token_t
out_token(token_t t)
#else /* K&R style */
static token_t
out_token(t)
token_t t;
#endif /* NEW_STYLE */
{		/* ALL token output is directed through this function */
    int n;

    if (do_lex_output)
	(void)printf("%d\t%s\t", (int)t, type_name[(int)t]);
    switch (t)
    {
    case TOKEN_AT:
	last_object = TOKEN_UNKNOWN;
	if (do_lex_output)
	    (void)printf("\"%s\"\n", yytext);
	break;

    case TOKEN_VALUE:
	if (do_lex_output)
	{
	    if (ISDIGIT(yytext[0]))
	    {				/* supply surrounding quotes */
		n = strlen((const char*)&yytext[0]);
		if ((n + 3) > YYLMAX)
		    overflow();
		yytext[n+2] = '\0';
		yytext[n+1] = '"';
		for (; n > 0; --n)
		    yytext[n] = yytext[n-1];
	    }
	    else
		compact_space();
	    out_protected_string(t);
	}
	break;

    case TOKEN_COMMENT:
    case TOKEN_INCLUDE:
	if (do_lex_output)
	    out_protected_string(t);
	last_object = t;
	break;

    case TOKEN_ENTRY:
    case TOKEN_PREAMBLE:
    case TOKEN_STRING:
	if (do_lex_output)
	    (void)printf("\"%s\"\n", yytext);
	last_object = t;
	break;

    case TOKEN_FIELD:
    case TOKEN_KEY:
	if (do_lex_output)
	    (void)printf("\"%s\"\n", yytext);
	break;

    case TOKEN_INLINE:
    case TOKEN_NEWLINE:
	line_number++;
	if (do_lex_output)
	{
	    out_protected_string(t);
	    (void)printf("# line %ld \"%s\"\n", line_number, the_filename);
	}
	break;

    case TOKEN_LITERAL:
    default:
	if (do_lex_output)
	    out_protected_string(t);
	break;
    }
    if (!((t == TOKEN_INLINE) ||
	  (t == TOKEN_SPACE) ||
	  (t == TOKEN_NEWLINE)))
	last_token = t;		/* remember last non-space token type */
    return (t);
}


static void
overflow(VOID)
{
    (void)fprintf(stderr,
	    "String too long for %ld-character buffer\n",YYLMAX);
    exit (EXIT_FAILURE);
}


#if defined(HAVE_IBMPC)
int
yywrap(VOID)
{
    return 1;
}
#endif
int yyvstop[] = {
0,

19,
0, 

18,
19,
0, 

17,
0, 

10,
19,
0, 

9,
19,
0, 

19,
0, 

13,
19,
0, 

14,
19,
0, 

16,
19,
0, 

7,
19,
0, 

15,
19,
0, 

1,
19,
0, 

6,
19,
0, 

6,
19,
0, 

6,
19,
0, 

6,
19,
0, 

6,
19,
0, 

11,
19,
0, 

12,
19,
0, 

18,
0, 

8,
0, 

7,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

6,
0, 

5,
6,
0, 

2,
6,
0, 

3,
6,
0, 

6,
0, 

4,
6,
0, 
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
0,0,	0,0,	4,22,	0,0,	
4,22,	4,22,	4,22,	0,0,	
24,24,	0,0,	24,24,	24,24,	
24,24,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,6,	
1,7,	4,22,	1,8,	0,0,	
1,3,	1,9,	1,10,	24,24,	
0,0,	1,11,	0,0,	0,0,	
0,0,	1,12,	12,25,	12,25,	
12,25,	12,25,	12,25,	12,25,	
12,25,	12,25,	12,25,	12,25,	
0,0,	0,0,	1,13,	0,0,	
0,0,	1,14,	1,15,	1,15,	
1,16,	1,15,	1,15,	1,15,	
1,15,	0,0,	1,17,	33,37,	
0,0,	1,15,	1,15,	1,15,	
1,15,	1,18,	8,23,	1,15,	
1,19,	1,15,	1,15,	27,31,	
0,0,	0,0,	8,23,	8,24,	
0,0,	0,0,	0,0,	16,27,	
17,28,	0,0,	18,29,	19,30,	
28,32,	29,33,	30,34,	31,35,	
32,36,	34,38,	35,39,	33,37,	
36,40,	37,41,	0,0,	38,42,	
39,43,	0,0,	0,0,	8,23,	
8,23,	0,0,	8,23,	27,31,	
8,23,	8,23,	8,23,	40,44,	
1,20,	8,23,	1,21,	16,27,	
17,28,	8,23,	18,29,	19,30,	
28,32,	29,33,	30,34,	31,35,	
32,36,	34,38,	35,39,	41,45,	
36,40,	37,41,	8,23,	38,42,	
39,43,	8,23,	8,23,	8,23,	
8,23,	8,23,	8,23,	8,23,	
8,23,	0,0,	8,23,	40,44,	
0,0,	8,23,	8,23,	8,23,	
8,23,	8,23,	0,0,	8,23,	
8,23,	8,23,	8,23,	0,0,	
0,0,	42,46,	43,47,	41,45,	
0,0,	44,48,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	15,26,	0,0,	0,0,	
0,0,	15,26,	0,0,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	42,46,	43,47,	45,49,	
8,23,	44,48,	8,23,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	49,50,	0,0,	45,49,	
0,0,	0,0,	0,0,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	15,26,	15,26,	15,26,	
15,26,	49,50,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+0,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+5,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+6,
yycrank+0,	0,		yyvstop+8,
yycrank+0,	0,		yyvstop+11,
yycrank+-81,	0,		yyvstop+14,
yycrank+0,	0,		yyvstop+16,
yycrank+0,	0,		yyvstop+19,
yycrank+0,	0,		yyvstop+22,
yycrank+2,	0,		yyvstop+25,
yycrank+0,	0,		yyvstop+28,
yycrank+0,	0,		yyvstop+31,
yycrank+142,	0,		yyvstop+34,
yycrank+16,	yysvec+15,	yyvstop+37,
yycrank+18,	yysvec+15,	yyvstop+40,
yycrank+16,	yysvec+15,	yyvstop+43,
yycrank+15,	yysvec+15,	yyvstop+46,
yycrank+0,	0,		yyvstop+49,
yycrank+0,	0,		yyvstop+52,
yycrank+0,	yysvec+4,	yyvstop+55,
yycrank+0,	yysvec+8,	0,	
yycrank+11,	0,		yyvstop+57,
yycrank+0,	yysvec+12,	yyvstop+59,
yycrank+0,	yysvec+15,	yyvstop+61,
yycrank+10,	yysvec+15,	yyvstop+63,
yycrank+33,	yysvec+15,	yyvstop+65,
yycrank+32,	yysvec+15,	yyvstop+67,
yycrank+20,	yysvec+15,	yyvstop+69,
yycrank+26,	yysvec+15,	yyvstop+71,
yycrank+28,	yysvec+15,	yyvstop+73,
yycrank+10,	yysvec+15,	yyvstop+75,
yycrank+32,	yysvec+15,	yyvstop+77,
yycrank+37,	yysvec+15,	yyvstop+79,
yycrank+23,	yysvec+15,	yyvstop+81,
yycrank+32,	yysvec+15,	yyvstop+83,
yycrank+33,	yysvec+15,	yyvstop+85,
yycrank+34,	yysvec+15,	yyvstop+87,
yycrank+55,	yysvec+15,	yyvstop+89,
yycrank+73,	yysvec+15,	yyvstop+91,
yycrank+98,	yysvec+15,	yyvstop+93,
yycrank+86,	yysvec+15,	yyvstop+95,
yycrank+104,	yysvec+15,	yyvstop+97,
yycrank+127,	yysvec+15,	yyvstop+99,
yycrank+0,	yysvec+15,	yyvstop+101,
yycrank+0,	yysvec+15,	yyvstop+104,
yycrank+0,	yysvec+15,	yyvstop+107,
yycrank+164,	yysvec+15,	yyvstop+110,
yycrank+0,	yysvec+15,	yyvstop+112,
0,	0,	0};
struct yywork *yytop = yycrank+265;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
  0,   1,   1,   1,   1,   1,   1,   1, 
  1,   9,  10,   9,   9,   9,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  9,   1,  34,  35,   1,  37,   1,  39, 
 40,  41,   1,  39,  44,  39,  39,  39, 
 48,  48,  48,  48,  48,  48,  48,  48, 
 48,  48,  39,   1,   1,  61,   1,   1, 
 64,  65,  66,  67,  68,  69,  70,  71, 
 70,  73,  70,  70,  76,  77,  78,  79, 
 80,  70,  82,  83,  84,  85,  70,  70, 
 70,  70,  70,   1,   1,   1,   1,   1, 
  1,  65,  66,  67,  68,  69,  70,  71, 
 70,  73,  70,  70,  76,  77,  78,  79, 
 80,  70,  82,  83,  84,  85,  70,  70, 
 70,  70,  70, 123,   1, 125,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*	Copyright (c) 1989 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#pragma ident	"@(#)ncform	6.11	97/01/06 SMI"

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
#if defined(__cplusplus) || defined(__STDC__)
int yylook(void)
#else
yylook()
#endif
{
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
#ifndef __cplusplus
			*yylastch++ = yych = input();
#else
			*yylastch++ = yych = lex_input();
#endif
#ifdef YYISARRAY
			if(yylastch > &yytext[YYLMAX]) {
				fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
				exit(1);
			}
#else
			if (yylastch >= &yytext[ yytextsz ]) {
				int	x = yylastch - yytext;

				yytextsz += YYTEXTSZINC;
				if (yytext == yy_tbuf) {
				    yytext = (char *) malloc(yytextsz);
				    memcpy(yytext, yy_tbuf, sizeof (yy_tbuf));
				}
				else
				    yytext = (char *) realloc(yytext, yytextsz);
				if (!yytext) {
				    fprintf(yyout,
					"Cannot realloc yytext\n");
				    exit(1);
				}
				yylastch = yytext + x;
			}
#endif
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
#ifndef __cplusplus
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
#else
		yyprevious = yytext[0] = lex_input();
		if (yyprevious>0)
			lex_output(yyprevious);
#endif
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
#if defined(__cplusplus) || defined(__STDC__)
int yyback(int *p, int m)
#else
yyback(p, m)
	int *p;
#endif
{
	if (p==0) return(0);
	while (*p) {
		if (*p++ == m)
			return(1);
	}
	return(0);
}
	/* the following are only used in the lex library */
#if defined(__cplusplus) || defined(__STDC__)
int yyinput(void)
#else
yyinput()
#endif
{
#ifndef __cplusplus
	return(input());
#else
	return(lex_input());
#endif
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyoutput(int c)
#else
yyoutput(c)
  int c; 
#endif
{
#ifndef __cplusplus
	output(c);
#else
	lex_output(c);
#endif
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyunput(int c)
#else
yyunput(c)
   int c; 
#endif
{
	unput(c);
	}
