#include <config.h>

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#if defined(HAVE_STDLIB_H)
#include <stdlib.h>
#endif

#include "args.h"
#include "bibyydcl.h"

#define	ERROR_PREFIX	"??"	/* this prefixes all error messages */

extern long		line_number;
extern const char	*the_filename;

static void		dolex ARGS((void));
int			main ARGS((int argc_, char *argv_[]));

#if NEW_STYLE
int
main(int argc, char *argv[])
#else /* K&R style */
int
main(argc, argv)
int argc;
char *argv[];
#endif /* NEW_STYLE */
{
    int k;
    FILE *fp;

    if (argc > 1)		/* files to lex named on command line */
    {
	for (k = 1; k < argc; ++k)
	{
	    fp = freopen(argv[k],"r",stdin);
	    if (fp == (FILE*)NULL)
	    {
		(void)fprintf(stderr,
		    "\n%s Ignoring open failure on file [%s]\n",
		    ERROR_PREFIX, argv[k]);
		(void)perror("perror() says");
	    }
	    else
	    {
		the_filename = (const char*)argv[k];
		dolex();
		(void)fclose(fp);
	    }
	}
    }
    else				/* lex stdin */
    {
	the_filename = "stdin";
	dolex();
    }
    exit (EXIT_SUCCESS);
    return (0);
}

static void
dolex(VOID)
{
    line_number = 1L;
    printf("# line %ld \"%s\"\n", line_number, the_filename);

    while (yylex() > 0)
	;
}
