#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <stddef.h>
#include "meminfo.h"

/* Code remnants from NR 2ed  */
#define ARR_END       1
#define FREE_ARG char*
#define SWAP(a,b) tempr=(a);(a)=(b);(b)=tempr

#ifndef _FCOMPLEX_DECLARE_T_
typedef struct FCOMPLEX {
    float r, i;
} fcomplex;

#define _FCOMPLEX_DECLARE_T_
#endif				/* _FCOMPLEX_DECLARE_T_ */

#ifndef _FRAWTYPE_DECLARE_T_
typedef fcomplex rawtype;
#define _FRAWTYPE_DECLARE_T_
#endif				/* _FRAWTYPE_DECLARE_T_ */


/* Function Prototypes   */

/* The FAST FFTs we will use   */
/* Note:  A standard forward transform (with negative exponent)  */
/*        is called by setting isign=-1  */
void tablesixstepfft(float *indata, long nn, int isign);
void realfft(float data[], unsigned long n, int isign);
void twopassfft_scratch(FILE * infile, FILE * scratch,\
			unsigned long nn, int isign);
void realfft_scratch_fwd(FILE * infile, FILE * scratch, unsigned long nn);
void realfft_scratch_inv(FILE * infile, FILE * scratch, unsigned long nn);

/* The following are misc FFTs and other required routines  */
void tablefft(float data[], unsigned long nn, int isign);
void tablefftraw(float data[], double table[], unsigned long n);
void tablesplitfft(float data[], unsigned long nn, int isign);
void tablesplitfftraw(float data[], double table[], unsigned long n, int isign);
double *maketable(unsigned long nn, int isign);
void cleantable(double table[], unsigned long nn);
void scramble(float data[], unsigned long nn);

/* The following are transposition routines  */
void moveblock(rawtype d[], rawtype s[], int b, int nd, int ns);
void transpose2blocks(rawtype data1[], rawtype data2[], int b, int nn);
void transposeblock(rawtype data[], int b, int nn);
void transposesquare(rawtype data[], int n1, int n2);
void permutewidetotall(rawtype data[], int n1, int n2);
void permutetalltowide(rawtype data[], int n1, int n2);
void transpose(rawtype data[], int n1, int n2);

/* The following are miscellaneous routines used in the FFTs  */
void meminit(void);
long rnd2down(long x);
long sqrt4down(long x);
void moveraw(void *d, void *s, int n);
void swapraw(void *d, void *s, int n);

/* Routines to allocate and de-allocate vectors  */
int *ivect(long nl, long nh);
float *vect(long nl, long nh);
double *dvect(long nl, long nh);
rawtype *raw_vect(long nl, long nh);
void free_ivect(int *v, long nl, long nh);
void free_vect(float *v, long nl, long nh);
void free_dvect(double *v, long nl, long nh);
void free_raw_vect(rawtype * v, long nl, long nh);
