      subroutine ksorensenffti( n, s1, c1, s3, c3 )
c
c  Table initialization routine for FFT routines 
c
c  Usage:  call ffti( n, s1, c1, s3, c3 ) 
c  Parameters:
c     n - integer length of transform (must be a power of two)
c    s1 - array of sin() table (length >= n/8-1)
c    c1 - array of cos() table (length >= n/8-1)
c    s3 - array of sin() table (length >= n/8-1)
c    c3 - array of cos() table (length >= n/8-1)
c
c  Requires standard intrinsic FORTRAN functions - sin, cos
c
c
c  Steve Kifowit, 22 June 1997
c
c
c ... Scalar arguments ...
      integer  n
c ... Array arguments ...
      double precision  s1(*), c1(*), s3(*), c3(*)
c ... Local scalars ...
      integer  i, k
      double precision  ang, t, u
c ... Parameters ...
      double precision  twopi
      parameter  ( twopi = 6.2831853071795864769D0 )
c ... Intrinsic functions ...
      intrinsic  dsin, dcos
c
c ... Exe. statements ...
c
      if ( n .le. 8 ) return
c
      ang = twopi / n
      k = n / 8 - 1
      do 10, i = 1, k
	 t = ang * i
	 c1(i) = dcos( t )
	 s1(i) = dsin( t )
	 u = 3 * t
	 c3(i) = dcos( u )
	 s3(i) = dsin( u )
 10   continue
      return
c
c ... End of subroutine ffti ...
c
      end

