      SUBROUTINE MFFTDM(C,IMSX,IVSX,IESX,NMX,NVX,NEX,TABLES,IERR)
*   PURPOSE:
*       THIS SUBROUTINE PERFORMS A DIRECT FOURIER TRANSFORM ALONG
*       THE SECOND DIMENSION OF A 3-DIMENSIONAL MATRIX, USING THE
*       GENTLEMAN-SANDE ALGORITHM.
*       THE SEQUENCE TO BE TRANSFORMED IS C[IMSX,NMX], WHOSE COMPONENTS
*       ARE THE 2-VECTORS C(M)[IVSX,NVX [IESX,NEX]].
*       SEE REF.[1] FOR NOTATIONS.
*  EXAMPLE:
*       LET C BE A 3-D MATRIX C(N1,N2,N3), DECLARED VIA
*              DIMENSION C(NN1,N2,N3)
*       WITH NN1.GE.N1
*       THEN ITS DFT ALONG THE SECOND DIMENSION IS OBTAINED BY
*              CALL MFFTDM(C,NN1,NN1*N2,1,N2,N3,N1,TABLES,IERR)
*  IMPLEMENTATION:
*       THE TRANSFORMATION IS IMPLEMENTED THROUGH REPEATED CALLS TO THE
*       "BUTTERFLY" TRANSFORMATION MFFT?6; PARAMETERS OF THE "BUTTERFLY"
*       ARE COMMUNICATED THROUGH THE COMMON BLOCK MFFTPA.
*  ARGUMENTS:
*    INPUT  :
*       C : ARRAY TO BE TRANSFORMED.
*       IMSX,IVSX,IESX,NMX,NVX,NEX: THESE ARGUMENTS DEFINE THE STRUCTURE
*           OF C ACCORDING TO THE DEFINITIONS ABOVE. THEY ARE UNCHANGED
*           ON OUTPUT
*       TABLES : ARRAY PREPARED BY MFFTP. IT  IS NOT CHANGED ON OUTPUT.
*                IT SHOULD BE DECLARED INTEGER TABLES(4*NM+14);
*                IT MUST BE INITIALIZED BY MFFTP BEFORE USAGE.
*    OUTPUT:
*       C : TRANSFORM OF THE ORIGINAL ARRAY; "BIT REVERSED" ORDER
*       IERR : ERROR CODE : =0 : SUCCESSFUL
*                         : =3 :  'TABLES' NOT CORRECTLY INITIALIZED
      COMPLEX C(*)
      INTEGER TABLES(-14:*)
      INTEGER IDERR,FACERR,TBERR
      PARAMETER (IDERR=1,FACERR=2,TBERR=3)
      COMMON /MFFTPA/  IMS,IVS,IES,NM,NV,NE,MX,LX,MLIM,MSTEP,LLIM,LSTEP,
     $ NUSTEP,IVLIM,ILIM,MD2LIM,LD2LIM
*  LOADING THE COMMON BLOCK : CONSTANTS
      IMS=IMSX
      IVS=IVSX
      IES=IESX
      NM=NMX
      NV=NVX
      NE=NEX
 
      IVLIM=(NV-1)*IVS
      ILIM=(NE-1)*IES
      MSTEP=IMS
*  LOADING THE COMMON BLOCK : ITERATION-DEPENDENT QUANTITIES: INITIALIZA
      LX=1
      MX=NM
*  SELECT THE HIGHEST FACTOR OF NM
      IFAC=TABLES(-1)
      GOTO(200,300,500)IFAC
      IERR=TBERR
      RETURN
*...  RADIX 5 LOOP
500   CONTINUE
      DO 510 IM=1,TABLES(-12)
        MX=MX/5
        NUSTEP=MX*MSTEP
        MLIM=NUSTEP-MSTEP
        LSTEP=NUSTEP*5
        LLIM=NM*MSTEP-LSTEP
        CALL MFFTC6(C,TABLES(0))
        LX=LX*5
510   CONTINUE
*..  RADIX 3 LOOP
300   CONTINUE
      DO 310 IM=1,TABLES(-13)
        MX=MX/3
        NUSTEP=MX*MSTEP
        MLIM=NUSTEP-MSTEP
        LSTEP=NUSTEP*3
        LLIM=NM*MSTEP-LSTEP
        CALL MFFTB6(C,TABLES(0))
        LX=LX*3
310   CONTINUE
*..  RADIX 2 LOOP
200   CONTINUE
      DO 210 IM=1,TABLES(-14)
        MX=MX/2
        NUSTEP=MX*MSTEP
        MLIM=NUSTEP-MSTEP
        MD2LIM=NUSTEP/2-MSTEP
        LSTEP=NUSTEP*2
        LLIM=NM*MSTEP-LSTEP
        CALL MFFTA6(C,TABLES(0))
        LX=LX+LX
210   CONTINUE
      END
