C     SUBROUTINE FOURT(X,NN,NDIM,ISIGN,IFORM,WORK)
C
C     Another version is in: http://mri.beckman.uiuc.edu/hess/software.html
C
C     THE COOLEY-TUKEY FAST FOURIER TRANSFORM
C     TRANSFORM(J1,J2,...) = SUM(X(I1,I2,...)*W1**((I1-1)*(J1-1))
C            *W2**((I2-1)*(J2-1))*...),
C     WHERE I1 AND J1 RUN FROM 1 TO NN(1) AND W1=EXP(ISIGN*2*PI*
C     SQRT(-1)/NN(1)), ETC.  THERE IS NO LIMIT ON THE DIMENSIONALITY
C     (NUMBER OF SUBSCRIPTS) OF THE DATA ARRAY.  IF AN INVERSE
C     TRANSFORM (ISIGN=+1) IS PERFORMED UPON AN ARRAY OF TRANSFORMED
C     (ISIGN=-1) X, THE ORIGINAL DATA WILL REAPPEAR,
C     MULTIPLIED BY NN(1)*NN(2)*...  THE ARRAY OF INPUT DATA MAY BE
C     REAL OR COMPLEX, AT THE PROGRAMMERS OPTION, WITH A SAVING OF
C     UP TO FORTY PER CENT IN RUNNING TIME FOR REAL OVER COMPLEX.
C     (FOR FASTEST TRANSFORM OF REAL DATA, NN(1) SHOULD BE EVEN.)
C     THE TRANSFORM VALUES ARE ALWAYS COMPLEX, AND ARE RETURNED IN THE
C     ORIGINAL ARRAY OF X, REPLACING THE INPUT DATA.THE LENGTH
C     OF EACH DIMENSION OF THE X ARRAY MAY BE ANY INTEGER.  THE
C     PROGRAM RUNS FASTER ON COMPOSITE INTEGERS THAN ON PRIMES, AND IS
C     PARTICULARLY FAST ON NUMBERS RICH IN FACTORS OF TWO.
C
C     TIMING IS IN FACT GIVEN BY THE FOLLOWING FORMULA.  LET NTOT BE THE
C     TOTAL NUMBER OF POINTS (REAL OR COMPLEX) IN THE X ARRAY, THAT
C     IS, NTOT=NN(1)*NN(2)*...   DECOMPOSE NTOT INTO ITS PRIME FACTORS,
C     SUCH AS 2**K2 * 3**K3 * 5**K5 * ...  LET SUM2 BE THE SUM OF ALL
C     THE FACTORS OF TWO IN NTOT, THAT IS, SUM2 = 2*K2.  LET SUMF BE
C     THE SUM OF ALL OTHER FACTORS OF NTOT, THAT IS, SUMF = 3*K3+5*K5+..
C     THE TIME TAKEN BY A MULTIDIMENSIONAL TRANSFORM ON THESE NTOT DATA
C     IS T = T0 + NTOT*(T1+T2*SUM2+T3*SUMF) ON COMPLEX DATA.
C
C     IMPLEMENTATION OF THE DEFINITION BY SUMMATION WILL RUN IN A TIME
C     PROPORTIONAL TO NTOT*(NN(1)+NN(2)+...).  FOR HIGHLY COMPOSITE NTOT
C     THE SAVINGS OFFERED BY THIS PROGRAM CAN BE DRAMATIC.  A ONE-DIMEN-
C     SIONAL ARRAY 4000 IN LENGTH WILL BE TRANSFORMED IN 4000*(600+
C     40*(2+2+2+2+2)+175*(5+5+5)) = 14.5 SECONDS VERSUS ABOUT 4000*
C     4000*175 = 2800 SECONDS FOR THE STRAIGHTFORWARD TECHNIQUE.
C
C     THE FAST FOURIER ALGORITHM PLACES TWO RESTRICTIONS UPON THE
C     NATURE OF THE DATA BEYOND THE USUAL RESTRICTION THAT
C     THE DATA FORM ONE CYCLE OF A PERIODIC FUNCTION.  THEY ARE--
C     1.  THE NUMBER OF INPUT DATA AND THE NUMBER OF TRANSFORM VALUES
C     MUST BE THE SAME.
C     2. CONSIDERING THE DATA TO BE IN THE TIME DOMAIN,
C     THEY MUST BE EQUI-SPACED AT INTERVALS OF DT.  FURTHER, THE TRANS-
C     FORM VALUES, CONSIDERED TO BE IN FREQUENCY SPACE, WILL BE EQUI-
C     2*PI/(NN(I)*DT) FOR EACH DIMENSION OF LENGTH NN(I).  OF COURSE,
C     DT NEED NOT BE THE SAME FOR EVERY DIMENSION.
C     
C     THE CALLING SEQUENCE IS--
C     CALL FOURT(X,NN,NDIM,ISIGN,IFORM,WORK)
C     
C     X IS THE ARRAY TO HOLD THE REAL AND IMAGINARY PARTS
C     OF THE DATA ON INPUT AND THE TRANSFORM VALUES ON OUTPUT.IT
C     IS A MULTIDIMENSIONAL FLOATING POINT ARRAY, WITH THE REAL AND
C     IMAGINARY PARTS OF A DATUM STORED IMMEDIATELY ADJACENT IN STORAGE
C     (SUCH AS FORTRAN IV PLACES THEM).  NORMAL FORTRAN ORDERING IS
C     EXPECTED, THE FIRST SUBSCRIPT CHANGING FASTEST.  THE DIMENSIONS
C     ARE GIVEN IN THE INTEGER ARRAY NN, OF LENGTH NDIM.  ISIGN IS -1
C     TO INDICATE A FORWARD TRANSFORM (EXPONENTIAL SIGN IS -) AND +1
C     FOR AN INVERSE TRANSFORM (SIGN IS +).  IFORM IS +1 IF THE DATA ARE
C     COMPLEX, 0 IF THE DATA ARE REAL.IF IT IS 0, THE IMAGINARY
C     PARTS OF THE DATA SHOULD BE SET TO ZERO.AS EXPLAINED ABOVE, THE
C     TRANSFORM VALUES ARE ALWAYS COMPLEX AND ARE STORED IN ARRAY X.
C     WORK IS AN ARRAY FOR WORKING STORAGE.  IT IS FLOATING POINT
C     REAL, ONE DIMENSIONAL OF LENGTH EQUAL TO TWICE THE LARGEST ARRAY
C     DIMENSION NN(I) THAT IS NOT A POWER OF TWO.  IF ALL NN(I) ARE
C     POWERS OF TWO, IT IS NOT NEEDED AND MAY BE REPLACED BY ZERO IN THE
C     CALLING SEQUENCE.  THUS, FOR A ONE-DIMENSIONAL ARRAY, NN(1) ODD,
C     WORK OCCUPIES AS MANY STORAGE LOCATIONS AS X.  IF SUPPLIED,
C     WORK MUST NOT BE THE SAME ARRAY AS X.  ALL SUBSCRIPTS OF ALL
C     ARRAYS BEGIN AT ONE.
C     
C     EXAMPLE 1.  THREE-DIMENSIONAL FORWARD FOURIER TRANSFORM OF A
C     COMPLEX ARRAY DIMENSIONED 32 BY 25 BY 13.
C     complex*8 x(32,25,13)
C     real work(50)
C     integer nn(3)
C     data nn/32,25,13/
C     do i=1,32
C     do j=1,25
C     do k=1,13
C     x(i,j,k)=COMPLEX VALUE
C     end do
C     end do
C     end do
C     call fourt(x,nn,3,-1,1,work)
C     
C     EXAMPLE 2.  ONE-DIMENSIONAL FORWARD TRANSFORM OF A REAL ARRAY OF
C     LENGTH 64.
C     real x(2,64)
C     do i=1,64
C     x(1,i)=REAL PART
C     x(2,i)=0.
C     end do
C     call fourt(x,64,1,-1,0,0)
C     
C     THERE ARE NO ERROR MESSAGES OR ERROR HALTS IN THIS PROGRAM.  THE
C     PROGRAM RETURNS IMMEDIATELY IF NDIM OR ANY NN(I) IS LESS THAN ONE.
C     
C     PROGRAM BY NORMAN BRENNER FROM THE BASIC PROGRAM BY CHARLES
C     RADER.JUNE 1967.  THE IDEA FOR THE DIGIT REVERSAL WAS
C     SUGGESTED BY RALPH ALTER.
C     
C     THIS IS THE FASTEST AND MOST VERSATILE VERSION OF THE FFT KNOWN
C     TO THE AUTHOR.A PROGRAM FOUR2 IS AVAILABLE THAT ALSO
C     PERFORMS THE FAST FOURIER TRANSFORM AND IS WRITTEN IN USASI BASIC
C     FORTRAN.IT IS ABOUT ONE THIRD AS LONG AND RESTRICTS THE
C     DIMENSIONS OF THE INPUT ARRAY (WHICH MUST BE COMPLEX) TO BE POWERS
C     OF TWO.  ANOTHER PROGRAM, FOUR1, IS ONE TENTH AS LONG AND
C     RUNS TWO THIRDS AS FAST ON A ONE-DIMENSIONAL COMPLEX ARRAY WHOSE
C     LENGTH IS A POWER OF TWO.
C     
C     REFERENCE--
C     IEEE AUDIO TRANSACTIONS (JUNE 1967), SPECIAL ISSUE ON THE FFT.
C     
C     
      subroutine brennerfft(x,nn,ndim,isign,iform,work)
C     
      implicit none
      double precision x
      dimension x(*)
      integer nn
      dimension nn(*)
      double precision work
      dimension work(*)
      integer ifact
      dimension ifact(32)
      double precision tempi, rthlf, oldsr, tempr, twopi, wstpi, 
     1     wstpr, twowr, wi, difi, wr, difr, sumi, t2i, u1i, t3i, 
     2     u2i, t4i, u3i, sumr, u4i, w2i, w3i, t2r, u1r, t3r, 
     3     u2r, t4r, u3r, u4r, w2r, w3r,theta, oldsi
      integer ifp1, ifp2, kstep, nprev, nwork, iquot, if, mssss, 
     1     kdif, idim, ndim, idiv, ipar, imin, irem, jmin, imax, 
     2     kmin, jmax, lmax, mmax, np0, np1, np2, ntot, ntwo, i, j, 
     3     l, m, n, np1hf, np2hf, j1min, i1max, j2min, i1rng, 
     4     i2max, j1max, j2max, j2rng, j3max, inon2, np1tw, i1, i2, 
     5     icase, j1, i3, j2, k1, j3, k2, k3, k4, nhalf, iconj, 
     6     ifmin, isign, iform
      logical doit, try
C     
      twopi=2.0D0*3.141592653589793D0
      rthlf=sqrt(0.5D0)
      if (ndim .lt. 1) return
      ntot = 2
      do idim=1,ndim
         if (nn(idim) .lt. 1) return
         ntot = ntot*nn(idim)
      end do
C     
C     MAIN LOOP FOR EACH DIMENSION
C     
      np1 = 2
      do idim=1,ndim
         n = nn(idim)
         np2 = np1*n
         if (n .gt. 1) then
C     
C     IS N A POWER OF TWO AND IF NOT, WHAT ARE ITS FACTORS
C     
            m = n
            ntwo = np1
            if = 1
            idiv = 2
            doit = .true.
            do while (doit)
               iquot = m/idiv
               irem = m-idiv*iquot
               doit = (iquot .ge. idiv) .and. (irem .eq. 0)
               if (doit) then
                  ntwo = ntwo+ntwo
                  ifact(if)= idiv
                  if = if+1
                  m = iquot
               end if
            end do
            if (iquot .ge. idiv) then
               idiv = 3
               inon2 = if
               doit = .true.
               do while (doit)
                  iquot = m/idiv
                  irem = m-idiv*iquot
                  doit = (iquot .ge. idiv)
                  if (doit) then
                     if (irem .eq. 0) then
                        ifact(if)= idiv
                        if = if+1
                        m = iquot
                     else
                        idiv = idiv+2
                     end if
                  end if
               end do
               ifact(if)= m
            else
               inon2 = if
               if (irem .eq. 0) ntwo = ntwo+ntwo
            end if
C     
C     SEPARATE FOUR CASES--
C     1. COMPLEX TRANSFORM OR REAL TRANSFORM FOR THE 4TH, 5TH, ETC.
C     DIMENSIONS.
C     2. REAL TRANSFORM FOR THE 2ND OR 3RD DIMENSION.    METHOD--
C     TRANSFORM HALF THE DATA, SUPPLYING THE OTHER HALF BY
C     CONJUGATE SYMMETRY.
C     3. REAL TRANSFORM FOR THE 1ST DIMENSION, N ODD.    METHOD--
C     SET THE IMAGINARY PARTS TO ZERO.
C     4. REAL TRANSFORM FOR THE 1ST DIMENSION, N EVEN.  METHOD--
C     TRANSFORM A COMPLEX ARRAY OF LENGTH N/2 WHOSE REAL PARTS ARE
C     THE EVEN NUMBERED REAL VALUES AND WHOSE IMAGINARY PARTS ARE
C     THE ODD NUMBERED REAL VALUES.  SEPARATE AND SUPPLY THE
C     SECOND HALF BY CONJUGATE SYMMETRY.
C     
            icase = 1
            ifmin = 1
            i1rng = np1
            if ((idim .lt. 4) .and. (iform .le. 0)) then
               icase = 2
               i1rng = np0*(1+nprev/2)
               if (idim .le. 1) then
                  icase = 3
                  i1rng = np1
                  if(ntwo .gt. np1) then
                     icase = 4
                     ifmin = 2
                     ntwo = ntwo/2
                     n = n/2
                     np2 = np2/2
                     ntot = ntot/2
                     i = 1
                     do j=1,ntot
                        x(j)=x(i)
                        i = i+2
                     end do
                  end if
               end if
            end if
C     
C     SHUFFLE X BY BIT REVERSAL, SINCE N=2**K.    AS THE SHUFFLING CAN BE
C     DONE BY SIMPLE INTERCHANGE, NO WORKING ARRAY IS NEEDED
C     
            if (ntwo .ge. np2) then
               np2hf = np2/2
               j = 1
               do i2=1,np2,np1
                  if (j .lt. i2) then
                     i1max = i2+np1-2
                     do i1=i2,i1max,2
                        do i3=i1,ntot,np2
                           j3 = j+i3-i2
                           tempr = x(i3)
                           tempi = x(i3+1)
                           x(i3)=x(j3)
                           x(i3+1)=x(j3+1)
                           x(j3)=tempr
                           x(j3+1)=tempi
                        end do
                     end do
                  end if
                  m = np2hf
                  doit = j .gt. m
                  do while (doit)
                     j = j-m
                     m = m/2
                     doit = (j .gt. m) .and. (m .ge. np1)
                  end do
                  j = j+m
               end do
            else
C     
C     SHUFFLE X BY DIGIT REVERSAL FOR GENERAL N
C     
               nwork = 2*n
               do i1=1,np1,2
                  do i3=i1,ntot,np2
                     j = i3
                     do i=1,nwork,2
                        if (icase .ne. 3) then
                           work(i) = x(j)
                           work(i+1)= x(j+1)
                        else
                           work(i) = x(j)
                           work(i+1)= 0.
                        end if
                        ifp2 = np2
                        if = ifmin
                        doit = .true.
                        do while (doit)
                           ifp1 = ifp2/ifact(if)
                           j = j+ifp1
                           if(j .lt. i3+ifp2) then
                              doit = .false.
                           else
                              j = j-ifp2
                              ifp2 = ifp1
                              if = if+1
                              doit = (ifp2 .gt. np1)
                           end if
                        end do
                     end do
                     i2max = i3+np2-np1
                     i = 1
                     do i2=i3,i2max,np1
                        x(i2)=work(i)
                        x(i2+1)=work(i+1)
                        i = i+2
                     end do
                  end do
               end do
            end if
C     
C     MAIN LOOP FOR FACTORS OF TWO.
C     W=EXP(ISIGN*2*PI*SQRT(-1)*M/(4*MMAX)).  CHECK FOR W=ISIGN*SQRT(-1)
C     AND REPEAT FOR W=W*(1+ISIGN*SQRT(-1))/SQRT(2).
C     
            if (ntwo .gt. np1) then
               np1tw = np1+np1
               ipar = ntwo/np1
               do while (ipar .gt. 2)
                  ipar = ipar/4
               end do
               if (ipar .eq. 2) then
                  do i1=1,i1rng,2
                     do k1=i1,ntot,np1tw
                        k2 = k1+np1
                        tempr = x(k2)
                        tempi = x(k2+1)
                        x(k2)=x(k1)-tempr
                        x(k2+1)=x(k1+1)-tempi
                        x(k1)=x(k1)+tempr
                        x(k1+1)=x(k1+1)+tempi
                     end do
                  end do
               end if
               mmax = np1
               do while (mmax .lt. ntwo/2)
                  mssss=mmax/2
                  if (np1tw .lt. mssss) then
                     lmax=mmax/2
                  else
                     lmax=np1tw
                  end if
                  do l=np1,lmax,np1tw
                     m = l
                     if (mmax .gt. np1) then
                        theta = -twopi*dble(l)/dble(4*mmax)
                        if (isign .ge. 0) theta = -theta
                        wr = cos(theta)
                        wi = sin(theta)
                     end if
                     doit = .true.
                     do while (doit)
                        if (mmax .gt. np1) then
                           w2r = wr*wr-wi*wi
                           w2i = 2.D0*wr*wi
                           w3r = w2r*wr-w2i*wi
                           w3i = w2r*wi+w2i*wr
                        end if
                        do i1=1,i1rng,2
                           kmin = i1+ipar*m
                           if (mmax .le. np1) kmin = i1
                           kdif = ipar*mmax
                           kstep = 4*kdif
                           do while (kstep .le. ntwo)
                              do k1=kmin,ntot,kstep
                                 k2 = k1+kdif
                                 k3 = k2+kdif
                                 k4 = k3+kdif
                                 if (mmax .le. np1) then
                                    u1r = x(k1)+x(k2)
                                    u1i = x(k1+1)+x(k2+1)
                                    u2r = x(k3)+x(k4)
                                    u2i = x(k3+1)+x(k4+1)
                                    u3r = x(k1)-x(k2)
                                    u3i = x(k1+1)-x(k2+1)
                                    if (isign .lt. 0) then
                                       u4r = x(k3+1)-x(k4+1)
                                       u4i = x(k4)-x(k3)
                                    else
                                       u4r = x(k4+1)-x(k3+1)
                                       u4i = x(k3)-x(k4)
                                    end if
                                 else
                                    t2r = w2r*x(k2)-w2i*x(k2+1)
                                    t2i = w2r*x(k2+1)+w2i*x(k2)
                                    t3r = wr*x(k3)-wi*x(k3+1)
                                    t3i = wr*x(k3+1)+wi*x(k3)
                                    t4r = w3r*x(k4)-w3i*x(k4+1)
                                    t4i = w3r*x(k4+1)+w3i*x(k4)
                                    u1r = x(k1)+t2r
                                    u1i = x(k1+1)+t2i
                                    u2r = t3r+t4r
                                    u2i = t3i+t4i
                                    u3r = x(k1)-t2r
                                    u3i = x(k1+1)-t2i
                                    if (isign .lt. 0) then
                                       u4r = t3i-t4i
                                       u4i = t4r-t3r
                                    else
                                       u4r = t4i-t3i
                                       u4i = t3r-t4r
                                    end if
                                 end if
                                 x(k1)=u1r+u2r
                                 x(k1+1)=u1i+u2i
                                 x(k2)=u3r+u4r
                                 x(k2+1)=u3i+u4i
                                 x(k3)=u1r-u2r
                                 x(k3+1)=u1i-u2i
                                 x(k4)=u3r-u4r
                                 x(k4+1)=u3i-u4i
                              end do
                              kdif = kstep
                              kmin = 4*(kmin-i1)+i1
                              kstep = 4*kdif
                           end do
                        end do
                        m = m+lmax
                        doit = (m .le. mmax)
                        if (doit) then
                           if (isign .lt. 0) then
                              tempr = wr
                              wr = (wr+wi)*rthlf
                              wi = (wi-tempr)*rthlf
                           else
                              tempr = wr
                              wr = (wr-wi)*rthlf
                              wi = (tempr+wi)*rthlf
                           end if
                        end if
                     end do
                  end do
                  ipar = 3-ipar
                  mmax = mmax+mmax
               end do
            end if
C     
C     MAIN LOOP FOR FACTORS NOT EQUAL TO TWO.  APPLY THE TWIDDLE FACTOR
C     W=EXP(ISIGN*2*PI*SQRT(-1)*(J1-1)*(J2-J1)/(IFP1*IFP2)), THEN PERFORM
C     A FOURIER TRANSFORM OF LENGTH IFACT(IF), MAKING USE OF CONJUGATE
C     SYMMETRIES.
C     
            if (ntwo .lt. np2) then
               ifp1 = ntwo
               if = inon2
               np1hf = np1/2
               doit = .true.
               do while (doit)
                  ifp2 = ifact(if)*ifp1
                  j1min = np1+1
                  if (j1min .le. ifp1) then
                     do j1=j1min,ifp1,np1
                        theta = -twopi*float(j1-1)/float(ifp2)
                        if (isign .ge. 0) theta = -theta
                        wstpr = cos(theta)
                        wstpi = sin(theta)
                        wr = wstpr
                        wi = wstpi
                        j2min = j1+ifp1
                        j2max = j1+ifp2-ifp1
                        do j2=j2min,j2max,ifp1
                           i1max = j2+i1rng-2
                           do i1=j2,i1max,2
                              do j3=i1,ntot,ifp2
                                 tempr = x(j3)
                                 x(j3)=x(j3)*wr-x(j3+1)*wi
                                 x(j3+1)=tempr*wi+x(j3+1)*wr
                              end do
                           end do
                           tempr = wr
                           wr = wr*wstpr-wi*wstpi
                           wi = tempr*wstpi+wi*wstpr
                        end do
                     end do
                  end if
                  theta = -twopi/float(ifact(if))
                  if (isign .ge. 0) theta = -theta
                  wstpr = cos(theta)
                  wstpi = sin(theta)
                  j2rng = ifp1*(1+ifact(if)/2)
                  do i1=1,i1rng,2
                     do i3=i1,ntot,np2
                        j2max = i3+j2rng-ifp1
                        do j2=i3,j2max,ifp1
                           j1max = j2+ifp1-np1
                           do j1=j2,j1max,np1
                              j3max = j1+np2-ifp2
                              do j3=j1,j3max,ifp2
                                 jmin = j3-j2+i3
                                 jmax = jmin+ifp2-ifp1
                                 i = 1+(j3-i3)/np1hf
                                 if (j2 .le. i3) then
                                    sumr = 0.
                                    sumi = 0.
                                    do j=jmin,jmax,ifp1
                                       sumr = sumr+x(j)
                                       sumi = sumi+x(j+1)
                                    end do
                                    work(i) = sumr
                                    work(i+1)= sumi
                                 else
                                    iconj = 1+(ifp2-2*j2+i3+j3)/np1hf
                                    j = jmax
                                    sumr = x(j)
                                    sumi = x(j+1)
                                    oldsr = 0.
                                    oldsi = 0.
                                    j = j-ifp1
                                    try = .true.
                                    do while (try)
                                       tempr = sumr
                                       tempi = sumi
                                       sumr = twowr*sumr-oldsr+x(j)
                                       sumi = twowr*sumi-oldsi+x(j+1)
                                       oldsr = tempr
                                       oldsi = tempi
                                       j = j-ifp1
                                       try = (j .gt. jmin)
                                    end do
                                    tempr = wr*sumr-oldsr+x(j)
                                    tempi = wi*sumi
                                    work(i) = tempr-tempi
                                    work(iconj) = tempr+tempi
                                    tempr = wr*sumi-oldsi+x(j+1)
                                    tempi = wi*sumr
                                    work(i+1)= tempr+tempi
                                    work(iconj+1) = tempr-tempi
                                 end if
                              end do
                           end do
                           if (j2 .le. i3) then
                              wr = wstpr
                              wi = wstpi
                           else
                              tempr = wr
                              wr = wr*wstpr-wi*wstpi
                              wi = tempr*wstpi+wi*wstpr
                           end if
                           twowr = wr+wr
                        end do
                        i = 1
                        i2max = i3+np2-np1
                        do i2=i3,i2max,np1
                           x(i2)=work(i)
                           x(i2+1)=work(i+1)
                           i = i+2
                        end do
                     end do
                  end do
                  if = if+1
                  ifp1 = ifp2
                  doit = (ifp1 .lt. np2)
               end do
            end if
C     
C     COMPLETE A REAL TRANSFORM IN THE 1ST DIMENSION, N EVEN, BY
C     CONJUGATE SYMMETRIES.
C     
            if (icase .eq. 4) then
               nhalf = n
               n = n+n
               theta = -twopi/float(n)
               if (isign .ge. 0) theta = -theta
               wstpr = cos(theta)
               wstpi = sin(theta)
               wr = wstpr
               wi = wstpi
               imin = 3
               jmin = 2*nhalf-1
               doit = .true.
               do while (doit)
                  j = jmin
                  do i=imin,ntot,np2
                     sumr = (x(i)+x(j))/2.D0
                     sumi = (x(i+1)+x(j+1))/2.D0
                     difr = (x(i)-x(j))/2.D0
                     difi = (x(i+1)-x(j+1))/2.D0
                     tempr = wr*sumi+wi*difr
                     tempi = wi*sumi-wr*difr
                     x(i)=sumr+tempr
                     x(i+1)=difi+tempi
                     x(j)=sumr-tempr
                     x(j+1)=-difi+tempi
                     j = j+np2
                  end do
                  imin = imin+2
                  jmin = jmin-2
                  tempr = wr
                  wr = wr*wstpr-wi*wstpi
                  wi = tempr*wstpi+wi*wstpr
                  doit = (imin .lt. jmin)
               end do
               if ((imin .eq. jmin) .and. (isign .lt. 0)) then
                  do i=imin,ntot,np2
                     x(i+1)=-x(i+1)
                  end do
               end if
               np2 = np2+np2
               ntot = ntot+ntot
               j = ntot+1
               imax = ntot/2+1
               doit = .true.
               do while (doit)
                  imin = imax-2*nhalf
                  i = imin
                  i = i+2
                  j = j-2
                  do while (i .lt. imax)
                     x(j)=x(i)
                     x(j+1)=-x(i+1)
                     i = i+2
                     j = j-2
                  end do
                  x(j)=x(imin)-x(imin+1)
                  x(j+1)=0.
                  doit = i .lt. j
                  if (doit) then
                     i = i-2
                     j = j-2
                     do while (i .gt. imin)
                        x(j)=x(i)
                        x(j+1)=x(i+1)
                        i = i-2
                        j = j-2
                     end do
                     x(j)=x(imin)+x(imin+1)
                     x(j+1)=0.
                     imax = imin
                  end if
               end do
               x(1)=x(1)+x(2)
               x(2)=0.
            else if (icase .eq. 2) then
C     
C     COMPLETE A REAL TRANSFORM FOR THE 2ND OR 3RD DIMENSION BY
C     CONJUGATE SYMMETRIES.
C     
               if (i1rng .lt. np1) then
                  do i3=1,ntot,np2
                     i2max = i3+np2-np1
                     do i2=i3,i2max,np1
                        imin = i2+i1rng
                        imax = i2+np1-2
                        jmax = 2*i3+np1-imin
                        if (i2 .gt. i3) jmax = jmax+np2
                        if (idim .gt. 2) then
                           j = jmax+np0
                           do i=imin,imax,2
                              x(i)=x(j)
                              x(i+1)=-x(j+1)
                              j = j-2
                           end do
                        end if
                        j = jmax
                        do i=imin,imax,np0
                           x(i)=x(j)
                           x(i+1)=-x(j+1)
                           j = j-np0
                        end do
                     end do
                  end do
               end if
            end if
         end if
C     
C     END OF LOOP ON EACH DIMENSION
C     
         np0 = np1
         np1 = np2
         nprev = n
      end do
      return
      end
