#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <stddef.h>

#include <fftw.h>

#include "meminfo.h"

/* Code remnants from NR 2ed  */
#define ARR_END       1
#define FREE_ARG char*
#define SWAP(a,b) tempr=(a);(a)=(b);(b)=tempr

#ifndef _FCOMPLEX_DECLARE_T_
typedef struct FCOMPLEX {
    FFTW_REAL r, i;
} fcomplex;

#define _FCOMPLEX_DECLARE_T_
#endif				/* _FCOMPLEX_DECLARE_T_ */

#ifndef _FRAWTYPE_DECLARE_T_
typedef fcomplex rawtype;
#define _FRAWTYPE_DECLARE_T_
#endif				/* _FRAWTYPE_DECLARE_T_ */


/* Function Prototypes   */

/* The FAST FFTs we will use   */
/* Note:  A standard forward transform (with negative exponent)  */
/*        is called by setting isign=-1  */
void tablesixstepfft(FFTW_REAL *indata, int nn, int isign);
void ransom_realfft(FFTW_REAL data[], unsigned int n, int isign);
void twopassfft_scratch(FILE * infile, FILE * scratch,\
			unsigned int nn, int isign);
void ransom_realfft_scratch_fwd(FILE * infile, FILE * scratch, unsigned int nn);
void ransom_realfft_scratch_inv(FILE * infile, FILE * scratch, unsigned int nn);

/* The following are misc FFTs and other required routines  */
void tablefft(FFTW_REAL data[], unsigned int nn, int isign);
void tablefftraw(FFTW_REAL data[], double table[], unsigned int n);
void tablesplitfft(FFTW_REAL data[], unsigned int nn, int isign);
void tablesplitfftraw(FFTW_REAL data[], double table[], unsigned int n, int isign);
double *maketable(unsigned int nn, int isign);
void cleantable(double table[], unsigned int nn);
void ransom_scramble(FFTW_REAL data[], unsigned int nn);

/* The following are transposition routines  */
void ransom_moveblock(rawtype d[], rawtype s[], int b, int nd, int ns);
void ransom_transpose2blocks(rawtype data1[], rawtype data2[], int b, int nn);
void ransom_transposeblock(rawtype data[], int b, int nn);
void ransom_transposesquare(rawtype data[], int n1, int n2);
void permutewidetotall(rawtype data[], int n1, int n2);
void permutetalltowide(rawtype data[], int n1, int n2);
void ransom_transpose(rawtype data[], int n1, int n2);

/* The following are miscellaneous routines used in the FFTs  */
void meminit(void);
int rnd2down(int x);
int sqrt4down(int x);
void moveraw(void *d, void *s, int n);
void swapraw(void *d, void *s, int n);

/* Routines to allocate and de-allocate vectors  */
int *ivect(int nl, int nh);
FFTW_REAL *vect(int nl, int nh);
double *dvect(int nl, int nh);
rawtype *raw_vect(int nl, int nh);
void free_ivect(int *v, int nl, int nh);
void free_vect(FFTW_REAL *v, int nl, int nh);
void free_dvect(double *v, int nl, int nh);
void free_raw_vect(rawtype * v, int nl, int nh);
