#ifndef SINCOS_H
#define SINCOS_H

/* Steven G. Johnson 7/10/97:

   If your system defines sincos, put the appropriate macro here: */

#if defined(SOLARIS)
#include <sunmath.h>
#define SINCOS(c,s,theta) sincos(theta,&(s),&(c))

#else
#define SINCOS(c,s,theta) { double theta0=theta; c = cos(theta0); s = sin(theta0); }

#endif

#endif
