/* fftpack_cffti.f -- translated by f2c (version 19941113).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

typedef int integer;
#include <fftw.h>
typedef FFTW_REAL real;


/*     SUBROUTINE FFTPACK_CFFTI(N,WSAVE) */

/*     SUBROUTINE FFTPACK_CFFTI INITIALIZES THE ARRAY WSAVE WHICH IS USED IN */
/*     BOTH FFTPACK_CFFTF AND FFTPACK_CFFTB. THE PRIME FACTORIZATION OF N TOGETHER WITH */
/*     A TABULATION OF THE TRIGONOMETRIC FUNCTIONS ARE COMPUTED AND */
/*     STORED IN WSAVE. */

/*     INPUT PARAMETER */

/*     N       THE LENGTH OF THE SEQUENCE TO BE TRANSFORMED */

/*     OUTPUT PARAMETER */

/*     WSAVE   A WORK ARRAY WHICH MUST BE DIMENSIONED AT LEAST 4*N+15 */
/*             THE SAME WORK ARRAY CAN BE USED FOR BOTH FFTPACK_CFFTF AND FFTPACK_CFFTB */
/*             AS LONG AS N REMAINS UNCHANGED. DIFFERENT WSAVE ARRAYS */
/*             ARE REQUIRED FOR DIFFERENT VALUES OF N. THE CONTENTS OF */
/*             WSAVE MUST NOT BE CHANGED BETWEEN CALLS OF FFTPACK_CFFTF OR FFTPACK_CFFTB. */

/* Subroutine */ int fftpack_cffti(integer n, real *wsave)
{
    extern /* Subroutine */ int fftpack_cffti1(integer, real *, real *);
    static integer iw1, iw2;


    /* Parameter adjustments */
    --wsave;

    /* Function Body */
    if (n == 1) {
	return 0;
    }
    iw1 = n + n + 1;
    iw2 = iw1 + n + n;
    fftpack_cffti1(n, &wsave[iw1], &wsave[iw2]);
    return 0;
} /* fftpack_cffti_ */

