
/*======================================================================
Filename:	ComplexMath.h
Language:	Think C

Header file for complex math functions

Modifications:
	02/23/90	Gerry Beauregard	Created this file
	01/27/91	Gerry Beauregard	Modified to use floats instead
									of doubles.
=======================================================================*/

#ifndef	_COMPLEXMATH_H
#define	_COMPLEXMATH_H

/*=====================================================================
Constants
=======================================================================*/

#define	MY_PI		(3.14159265358979323846)

/*====================================================================
Typedefs
======================================================================*/

#include <fftw.h>

typedef struct
{
	FFTW_REAL	Re;
	FFTW_REAL	Im;
} Complex;

typedef struct
{
	FFTW_REAL	Mag;
	FFTW_REAL	Phase;
} Polar;

/*==================================================================
Prototypes
=====================================================================*/

Complex CAdd(Complex a, Complex b);
Complex CSub(Complex a, Complex b);
Complex CMult(Complex a, Complex b);
Complex CDiv(Complex a, Complex b);
Complex	Conj(Complex a);
Polar 	ComplexToPolar(Complex x);
Complex PolarToComplex(Polar x);
FFTW_REAL	ComplexMag(Complex x);
FFTW_REAL	ComplexPhase(Complex x);
FFTW_REAL	RadToDeg(FFTW_REAL x);
FFTW_REAL	DegToRad(FFTW_REAL x);

#endif


