/*
 * Copyright (c) 1997 Massachusetts Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to use, copy, modify, and distribute the Software without
 * restriction, provided the Software, including any modified copies made
 * under this license, is not distributed for a fee, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY BE LIABLE
 * FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Except as contained in this notice, the name of the Massachusetts
 * Institute of Technology shall not be used in advertising or otherwise
 * to promote the sale, use or other dealings in this Software without
 * prior written authorization from the Massachusetts Institute of
 * Technology.
 *  
 */

typedef void do_fft_func(int rank, int *n, int *n_rev, int N, 
			 short is_power_of_two,
			 FFTW_COMPLEX *arr, FFTW_COMPLEX *work,
			 int size_arr, int size_work,
			 short compute_accuracy, factor_type allowed_factors);

typedef short do_fft_func2(int rank, int *n, int *n_rev, int N, 
			   short is_power_of_two,
			   FFTW_COMPLEX *arr, FFTW_COMPLEX *work,
			   int size_arr, int size_work,
			   short compute_accuracy,
			   factor_type allowed_factors);

do_fft_func do_arndt_ffts;
do_fft_func do_bailey_fft;
do_fft_func do_beauregard_fft;
do_fft_func do_bergland_fft;
do_fft_func do_bernstein_fft;
do_fft_func do_bloodworth_fft;
do_fft_func do_brenner_fft;
do_fft_func do_burrus_fft;
do_fft_func do_cwp_fft;
do_fft_func do_edelblute_fft;
do_fft_func do_fftpack_fft;
do_fft_func do_fftpack_f2c_fft;
do_fft_func2 do_fftw_1d_fft;
do_fft_func do_frigo_fft;
do_fft_func do_temperton_fft;
do_fft_func do_temperton_f_fft;
do_fft_func do_green_fft;
do_fft_func do_green_3d_fft;
do_fft_func do_gsl_fft;
do_fft_func do_krukar_fft;
do_fft_func do_emayer_fft;
do_fft_func do_rmayer_fft;
do_fft_func do_monro_fft;
do_fft_func do_monnier_fft;
do_fft_func do_napack_fft;
do_fft_func do_nielsen_fft;
do_fft_func do_nrc_1d_fft;
do_fft_func do_nrf_1d_fft;
do_fft_func do_ooura_fft;
do_fft_func do_ransom_fft;
do_fft_func do_qft_fft;
do_fft_func do_sciport_fft;
do_fft_func do_singleton_fft;
do_fft_func do_singleton_f2c_fft;
do_fft_func do_sorensen_ffts;
do_fft_func do_sorensen_dit_fft;
do_fft_func do_valkenburg_fft;
do_fft_func do_scilib_1d_fft;
do_fft_func do_scsl_fft;
do_fft_func do_essl_1d_fft;
do_fft_func do_sunperf_fft;
do_fft_func do_sgimath_fft;
do_fft_func do_intel_mkl_fft;
do_fft_func do_imsl_fft;
do_fft_func do_nag_fft;
do_fft_func do_dxml_fft;
do_fft_func2 do_fftwnd_fft;
do_fft_func do_temperton_3d_fft;
do_fft_func do_temperton_f_3d_fft;
do_fft_func do_harm_fft;
do_fft_func do_harm_f2c_fft;
do_fft_func do_nrc_fourn_fft;
do_fft_func do_nrf_fourn_fft;
do_fft_func do_pda_fft;
do_fft_func do_pda_f2c_fft;
do_fft_func do_mfft_3d_fft;
do_fft_func do_singleton_3d_fft;
do_fft_func do_singleton_3d_f2c_fft;
do_fft_func do_essl_3d_fft;
do_fft_func do_scilib_3d_fft;
do_fft_func do_scsl_3d_fft;
do_fft_func do_imsl_3d_fft;
do_fft_func do_nag_3d_fft;
do_fft_func do_dxml_3d_fft;
do_fft_func do_sgimath_3d_fft;
