/*
 * Copyright (c) 1997 Massachusetts Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to use, copy, modify, and distribute the Software without
 * restriction, provided the Software, including any modified copies made
 * under this license, is not distributed for a fee, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY BE LIABLE
 * FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of the Massachusetts
 * Institute of Technology shall not be used in advertising or otherwise
 * to promote the sale, use or other dealings in this Software without
 * prior written authorization from the Massachusetts Institute of
 * Technology.
 *
 */

#include "bench_utils.h"

int go_fft(FFTW_REAL *a, FFTW_REAL *b, int ntot, int n, int nspan, int isn);

extern int pda_f2c_dnfftb(int *ndim, int *dim, FFTW_REAL *x, FFTW_REAL *y, 
		      FFTW_COMPLEX *work, int *istat);
extern int pda_f2c_dnfftf(int *ndim, int *dim, FFTW_REAL *x, FFTW_REAL *y, 
		      FFTW_COMPLEX *work, int *istat);


void nrc_fourn(FFTW_REAL data[], unsigned int nn[], int ndim, int isign);
void FORTRANIZE(nrffourn,NRFFOURN)
               (FFTW_COMPLEX data[], int nn[], int *ndim, int *isign);

void harmd(FFTW_COMPLEX *a, int *m, int *inv,
           FFTW_COMPLEX *s, int *ifset, int *iferr);
void FORTRANIZE(harm,HARM)(FFTW_COMPLEX *a, int *m, int *inv,
			   FFTW_COMPLEX *s, int *ifset, int *iferr);

int gpf3d(FFTW_COMPLEX *c, int id, int *nn, int is);

void FORTRANIZE(gpfafgpf3d,GPFAFGPF3D)
(FFTW_COMPLEX *c, int *id, int *nn, int *is);

/* prototypes for Cray FFT's (should be linked with -lsci): */
/* floating point type is actually double */
void CCFFT2D(int *isign, int *n1, int *n2, FFTW_REAL *scale,
             FFTW_COMPLEX *x, int *ldx, FFTW_COMPLEX *y, int *ldy,
             FFTW_REAL *table, FFTW_REAL *work,
             int *isys);
void CCFFT3D(int *isign, int *n1, int *n2, int *n3, FFTW_REAL *scale,
	     FFTW_COMPLEX *x, int *ldx, int *ldx2, FFTW_COMPLEX *y, 
	     int *ldy, int *ldy2,
             FFTW_REAL *table, FFTW_REAL *work,
             int *isys);

/* ESSL routine.  Floating point type is actually float.  (We
   don't have the double precision version on our machine.) */
extern void scft3(FFTW_COMPLEX *x, int *inc2x, int *inc3x,
                  FFTW_COMPLEX *y, int *inc2y, int *inc3y,
                  int *n1, int *n2, int *n3, int *isign, FFTW_REAL *scale,
                  FFTW_COMPLEX *aux, int *naux);

void FORTRANIZE(mfftc3fft,MFFTC3FFT)
(FFTW_COMPLEX *c,int *id,int *nl,int *nm,int *nn,
 int *wl,int *wm,int *wn,int *iopt,int *isig,
 int *iord,int *iwork,int *ierr);

void FORTRANIZE(pdadnfftf,PDADNFFTF)(int*,int*,FFTW_REAL*,FFTW_REAL*,
				       FFTW_COMPLEX*,int*);
void FORTRANIZE(pdadnfftb,PDADNFFTB)(int*,int*,FFTW_REAL*,FFTW_REAL*,
				       FFTW_COMPLEX*,int*);
void FORTRANIZE(pdanfftf,PDANFFTF)(int*,int*,FFTW_REAL*,FFTW_REAL*,
				       FFTW_COMPLEX*,int*);
void FORTRANIZE(pdanfftb,PDANFFTB)(int*,int*,FFTW_REAL*,FFTW_REAL*,
				       FFTW_COMPLEX*,int*);
