// bbload.hh for bbsload - an tool to display the average load in X11.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//


#ifndef __MAIN_HH
#define __MAIN_HH

#include "Image.hh"
#include "Basewindow.hh"
#include "resource.hh"
#include "Timer.hh"

#define LEFT_BUTTON 1
#define MIDDLE_BUTTON 2
#define RIGHT_BUTTON 3

class Resource;
class BaseResource;
class Basewindow;
class ToolWindow;

struct PIXMAP {
    Pixmap  frame;
    Pixmap  label;
    Pixmap  loadbar_active;
    Pixmap  loadbar_inactive;
    Pixmap  loadbar_background;
};

struct LABELSIZE {
    int seperator_width;
    int space_width;
    int width[13];
    int total_width;
    int height;
};

struct FRAMESIZE {
	int x;
	int y;
    int height;
    int width;
};

struct GEOM {
    int x;
    int y;
    int width;
    int height;
    double level;
};

struct MEMORYINFO {
	unsigned long total;
	unsigned long used;
	unsigned long free;
	unsigned long shared;
	unsigned long buffers;
	unsigned long cached;
};

struct SWAPINFO {
	unsigned long total;
	unsigned long used;
	unsigned long free;
};

struct NORM {
	double total_used;
	double mem_used;
	double swap_used;
};

struct CPUINFO {
	double user;
	double nice;
	double system;
	double idle;
};

struct LOADINFO {
  float average1m;
  float average5m;
  float average15m;
};

struct TASK {
  int running;
  int total;
};

class CheckLoad : public TimeoutHandler {
  public:
    CheckLoad(ToolWindow *);

    struct LOADINFO getLoad(void) { return(load); }
    struct MEMORYINFO getMemory(void) { return(mem); }
    struct SWAPINFO getSwap(void) { return(swap); }
    struct CPUINFO getCpu(void) {return(cpu); }
    struct NORM getNorm(void) { return(norm); }
    struct TASK getTask(void) { return(task); }
    bool getBroken(void) { return(broken); }
    void Reconfigure(void);

  private:

    void timeout(void);
    struct LOADINFO load;
    struct MEMORYINFO mem;
    struct SWAPINFO swap;
    struct CPUINFO cpu;
    struct NORM norm;
    struct TASK task;
    bool broken;
    ToolWindow *bbtool;
    BTimer *timer;
};

class ToolWindow : public Basewindow 
{
public:
    ToolWindow(int argc,char **argv,struct CMDOPTIONS *);
    ~ToolWindow(void);

    Window framewin;
    Window labelwin;
    Window loadwin;


    void MakeWindow(bool);
    void ReadLoad(void);
    void Redraw(void);
    void EventLoop(void);
    void reconfigure(void);
    void CheckConfig(void);
    void RedrawGauge(double,int);
    void RedrawLabel(double,int);
    bool raised;
    Resource *getResource(void) { return(resource); }
protected:
  virtual void process_event(XEvent *);

private:

    XGCValues gcv;
    GC frameGC;
    Resource *resource;
    struct LABELSIZE label;
    struct FRAMESIZE frame;
    struct GEOM *load;
    int loadbar_height;
    int gauge_height;
    int xposition;

    bool mapped;
    XPoint points[11];
    struct PIXMAP pixmap;
    //bool broken;
    CheckLoad *check_load;


};

#endif /* __MAIN_HH */
