   /* code to write the BenAri data tables */

#include <stdio.h>
#include "../include/globdata.h"
#include "../include/pcode.h"

extern int last_infile;
extern InputFile *infile;
extern int last_predeclared;

extern int fclose(FILE*);
extern int fputc(int,FILE*);
extern int fprintf(FILE*,const char*,...);

void write_code_table(FILE *fl)
{
int   ix;
   fprintf(fl,"0  %d                 PCODE table\n",lc-1);
   fprintf(fl," lc   f      x    y\n");
   for (ix = 0; ix <= lc -1; ix++)
         fprintf(fl,"%3d %3d %4d %4d\n",ix,code[ix].f,code[ix].x,code[ix].y);
}  /* write_code_table */ 

void  write_identifier_table(FILE *f)
   /* only the non-predeclared id's are saved */
{
   int   ix, jx;
   int   link;
   int   last = last_tab - last_predeclared;
   fprintf(f,"1  %d            IDENTIFIER table\n",last);
   fprintf(f,"index   identifier    link  obj  type  ref normal   lev\
   adr   mon atomic\n");
   /* tab[0] is used as the 'sentinel' value for some searches */
   for (ix = 1; ix <= last; ix++) {
      jx = ix + last_predeclared;
      link = (tab[jx].link > 0 ? tab[jx].link - last_predeclared : 0);
      fprintf(f,"%4d  %-12s  %5d %5d %5d %5d %5d %5d %5d %5d %5d\n",
         ix,tab[jx].name,link,tab[jx].obj,tab[jx].typ,
         tab[jx].ref,tab[jx].normal,tab[jx].lev,tab[jx].adr,tab[jx].mon,
         tab[jx].atomic);
   }
}  /* write_identifier_table */ 
 
void  write_block_table(FILE *f)
{
   int   ix;
   int   last, lastpar;
   fprintf(f,"0  %d         BLOCK table\n",last_btab);
   fprintf(f,"index last lastpar psize vsize\n");
/*          1234567890123456789012345678901234567890  */
   for (ix = 0; ix <= last_btab; ix++) {
      last = (btab[ix].last > last_predeclared ? 
             btab[ix].last - last_predeclared : btab[ix].last);
      lastpar = (btab[ix].lastpar > last_predeclared ? 
             btab[ix].lastpar - last_predeclared : btab[ix].lastpar);
      fprintf(f,"%4d %4d %7d %4d %4d\n",ix,
         last,lastpar,btab[ix].psize,btab[ix].vsize);
   }
}  /* write_block_table */

void write_array_table(FILE *f)
{
int   ix;
   fprintf(f,"0  %d           ARRAY table\n",last_atab);
      /*      12345678901234567890123456789012345678901234567890123456789012345678901234567890 */
   fprintf(f,"index inxtype eltyp elref  low  high  elsize  size\n");
   for (ix = 0; ix <= last_atab; ix++)
      fprintf(f," %3d   %3d   %3d  %5d %5d %5d %5d %5d\n",
          ix,atab[ix].inxtyp,atab[ix].eltyp,atab[ix].elref,atab[ix].low,
          atab[ix].high,atab[ix].elsize,atab[ix].size);
}  /* write_array_table */
  
void write_string_table(FILE *f)
{
int start,stop;
   fprintf(f,"0 %3d %3d                  STRING table\n",stab_size,GULPSIZE);
   start = 0;
   if (stab_size > 0)
      do { 
         stop = start + GULPSIZE;
         if (stop > stab_size) stop = stab_size;
         while (start < stop)
            fputc(stab[start++],f);
         fputc('\n',f);
      } while (stop != stab_size);
}  /* write_string_table */
   
void write_debug_info(FILE *f)
{
int ix;
   fprintf(f,"0  %d           PCODE debugging information\n",last_dbg_ix);
      /*      12345678901234567890123456789012345678901234567890123456789012345678901234567890 */
   fprintf(f,"   lc findex flineno\n");
   for (ix = 0; ix <= last_dbg_ix; ix++)
      fprintf(f," %3d   %3d   %3d\n",dbg[ix].lc,dbg[ix].fix,dbg[ix].flno);
}  /* write_debug_info */


void write_file_info(FILE *f)
   /* writes the array of source file information */
{
int   ix;
   fprintf(f,"0  %d           Input File array\n",last_infile);
      /*      123456789012345678901234567890 */
   fprintf(f,"index parent      file name\n");
   for (ix = 0; ix <= last_infile; ix++)
      fprintf(f," %3d   %3d   %s\n",ix,infile[ix].parent,infile[ix].fname);
}  /* write_file_info */

void write_pcode(char *pcode_fname, char *comp_pname, char *filename_line)
   /* 
      write pcode & tables to pcode file named by 'pcode_fname'
      First line of the pcode file is the name of the compiler
      Second line is the name of the file being compiled
   */
{
FILE  *pcode;
extern void exit(int);
   if ((pcode = fopen(pcode_fname,"w")) == NULL) {
      fprintf(stderr,"Can't open pcode file %s\n",pcode_fname);
      exit(2);
   }
   fprintf(pcode,"%s\n",comp_pname);
   fprintf(pcode,"%s",filename_line); /* filename_line has an \n already */
   write_code_table(pcode);
   write_identifier_table(pcode);
   write_block_table(pcode);
   write_array_table(pcode);
   write_string_table(pcode);
   write_file_info(pcode);
   write_debug_info(pcode);
   fprintf(stderr,"Pcode and tables are stored in %s\n",pcode_fname);
   fclose(pcode);
}  /*  of write_pcode */ 

/*
 *
 *  $Log: writetab.c,v $
 * Revision 1.5  1997/07/10  17:16:45  bynum
 * switch from a to last_atab, b to last_btab, sx to stab_size, t to
 * last_tab
 *
 * Revision 1.4  1997/06/20  10:07:14  bynum
 * modify to write only the non-predeclared part of the tab[] array, add
 * last_predeclared
 *
 * Revision 1.3  1997/06/17  05:38:54  bynum
 * change code to write_string_table() to write non-ascii bytes, use
 * last_dbg_ix in write_debug_info()
 *
 * Revision 1.2  1997/03/25  14:32:42  bynum
 * incorporate name changes in the include directory, add prototypes
 * to silence gcc -Wall, switch from putc to fputc.
 *
 * Revision 1.1  1995/09/07  15:17:19  bynum
 * Initial revision
 *
 *
 */
