/*==========================================================================
 * Project: atari cross assembler
 * File: inc_path.h
 *
 * Contains prototypes for searching include paths
 *==========================================================================
 *  This program is free software; you can redistribute it and/or modify  
 *  it under the terms of the GNU General Public License as published by  
 *  the Free Software Foundation; either version 2 of the License, or     
 *  (at your option) any later version.                                   
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *==========================================================================*/
#ifndef INC_PATH_H
#define INC_PATH_H

#define MAX_PATH 1024


#ifdef DOS
#  define DIR_SEP "\\"
#endif

#ifdef MACOS
#  define DIR_SEP ":"
#endif

#ifdef UNIX
#  define DIR_SEP "/"
#endif

#ifndef DIR_SEP
#  define DIR_SEP "/"
#endif

/*==========================================================================*/
typedef struct _inc_list {
  struct _inc_list *next;
  char *path;
} inc_list;

/*==========================================================================*
 * some prototypes 
 *==========================================================================*/
inc_list *init_inc_list();

void free_inc_list();
void append_inc_path(inc_list *, char *);
FILE *fopen_include(inc_list *head, char *fname);

extern inc_list *includes;

#endif
/*==========================================================================*/






