#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "functions.h"

int db_open_oracle(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];
int paren=0;
char UID[TOKENSIZE];
char passwd[TOKENSIZE];
char database[TOKENSIZE];
char address[TOKENSIZE];
char dsn[TOKENSIZE];
char temp[LINELENGTH];

  tokentype=gettoken(token);
  if (strcmp(token,"(")==0)
  {
    paren=1;
    tokentype=gettoken(token);
  }

  if (global_uid[0]==0) { getvar(UID,token,"uid"); }
    else { strcpy(UID,global_uid); }
  if (global_passwd[0]==0) { getvar(passwd,token,"pwd"); }
    else { strcpy(passwd,global_passwd); }
  if (global_dsn[0]==0) { getvar(dsn,token,"dsn"); }
    else { strcpy(dsn,global_dsn); }
  if (global_database[0]==0) { getvar(database,token,"database"); }
    else { strcpy(database,global_database); }
  if (global_address[0]==0) { strcpy(address,"localhost"); }
    else { strcpy(address,global_address); }

  if (tokentype==TOK_DBLQT || tokentype==TOK_SNGQT)
  {
    sprintf(newtoken,"$%s_conn=OCILogon(\"%s\",\"%s\");\n",variable,UID,passwd);
  }
    else
  {
    push(token,tokentype);
    eval_molecule(temp);
    sprintf(newtoken,"$a2p_connstr=%s\n",temp);
    strcpy(temp,newtoken);

    add_indent(temp);
    strcat(temp,"$a2p_uid=strstr($a2p_connstr,'uid');\n");
    add_indent(temp);
    strcat(temp,"$a2p_uid=substr($d,strpos($d,'=')+1,strpos($d,';')-strpos($d,'=')-1);\n");
    add_indent(temp);

    strcat(temp,"$a2p_pwd=strstr($a2p_connstr,'pwd');\n");
    add_indent(temp);
    strcat(temp,"$a2p_pwd=substr($d,strpos($d,'=')+1,strpos($d,';')-strpos($d,'=')-1);\n");
    add_indent(temp);

    sprintf(newtoken,"%s$%s_conn=OCILogon($a2p_uid,$a2p_pwd);\n",
                                       temp,variable);
  }

  if (paren==1)
  { tokentype=gettoken(token); }

  return 0;
}

int db_execute_oracle(char *newtoken,char *variable)
{
char molecule1[LINELENGTH];
char temp[TOKENSIZE];
char spaces[100];
int r;

  spaces[0]=0;
  eval_molecule(molecule1);

  if (setvar==0)
  {
    sprintf(newtoken,"$%s_cursor=OCIParse($%s_conn,%s);\n",variable,variable,molecule1);
    for (r=0; r<indent; r++)
    { strcat(newtoken,"  "); }
    sprintf(temp,"$%s=OCIExecute($%s_cursor);\n",variable,variable);
    strcat(newtoken,temp);
  }
    else
  {
    for (r=0; r<indent; r++)
    { strcat(spaces,"  "); }
    sprintf(newtoken,"$%s_cursor=OCIParse($%s_conn,%s);\n",objects[setvar],variable,molecule1);
    strcat(newtoken,spaces);
    sprintf(temp,"$%s=OCIExecute($%s_cursor);\n",objects[setvar],objects[setvar]);
    strcat(newtoken,temp);

    if (BOF==1)
    {
      strcat(newtoken,"\n");
      for (r=0; r<indent; r++)
      { strcat(newtoken,"  "); }
      strcat(newtoken,"$");
      strcat(newtoken,objects[setvar]);
      strcat(newtoken,"_BOF=1;");
    }

    for (r=0; r<indent; r++)
    { strcat(newtoken,"  "); }

    strcpy(objectstype[setvar],"ADODB.Execute");

    sprintf(molecule1,"\n$%s=OCIFetch($%s_cursor);\n",objects[setvar],objects[setvar]);

    strcat(newtoken,molecule1);
  }

  return 0;
}

int parse_adodb_rs_oracle(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];
char molecule1[LINELENGTH];
char temp[512];
int r;

  /* autoindent(); */
  tokentype=gettoken(token);

  if (strcasecmp(token,"open")==0)
  {
    tokentype=gettoken(token);

    sprintf(newtoken,"$%s_cursor=OCIParse($%s_ActiveConnection,$%s_CommandText);\n",variable,variable,variable);
    for (r=0; r<indent; r++)
    { strcat(newtoken,"  "); }
    sprintf(temp,"$%s=OCIExecute($%s_cursor);\n",variable,variable);
    strcat(newtoken,temp);
  }
    else
  if (strcasecmp(token,"bof")==0)
  { sprintf(newtoken,"($%s_BOF==1)",variable); }
    else
  if (strcasecmp(token,"eof")==0)
  { sprintf(newtoken,"($%s==0)",variable); }
    else
  if (strcasecmp(token,"move")==0)
  {
    tokentype=gettoken(token);
    if (strcmp(token,"(")!=0)
    { error(token,"(","move"); }

    tokentype=gettoken(token);

    tokentype=gettoken(token);
    if (strcmp(token,")")!=0)
    { error(token,")","move"); }
  }
    else
  if (strcasecmp(token,"count")==0 || strcasecmp(token,"recordcount")==0)
  {
    sprintf(newtoken,"OCINumRows($%s)",variable);
  }
    else
  if (strcasecmp(token,"movelast")==0)
  {
    if (BOF==1)
    {
      for (r=0; r<indent; r++)
      { strcat(newtoken,"  "); }
      strcat(newtoken,"$");
      strcat(newtoken,variable);
      strcat(newtoken,"_BOF=0;\n");
    }
  }
    else
  if (strcasecmp(token,"movenext")==0)
  {
    sprintf(newtoken,"$%s=OCIFetch($%s_cursor);\n",variable,variable);

    if (BOF==1)
    {
      for (r=0; r<indent; r++)
      { strcat(newtoken,"  "); }
      strcat(newtoken,"$");
      strcat(newtoken,variable);
      strcat(newtoken,"_BOF=0;\n");
    }
  }
    else
  if (strcmp(token,"(")==0)
  {
    push("(",TOK_PAREN);
    molecule1[0]=0;
    eval_funct(molecule1);

    if (isnum(molecule1))
    { sprintf(newtoken,"OCIResult($%s_cursor,%s)",variable,molecule1); }
      else
    { sprintf(newtoken,"OCIResult($%s_cursor,strtoupper(%s))",variable,molecule1); }

    tokentype=gettoken(token);
    if (strcmp(token,"=")==0)
    {
      fprintf(out,"%s=",newtoken);
      strcpy(newtoken,"");
      eval_expression(" ");
    }
      else
    { push(token,tokentype); }
  }

  return 0;
}

int parse_adodb_connection_oracle(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];

  tokentype=gettoken(token);

  if (strcasecmp(token,"open")==0)
  { db_open_oracle(newtoken,variable); }
    else
  if (strcasecmp(token,"execute")==0)
  { db_execute_oracle(newtoken,variable); }
    else
  if (strcasecmp(token,"close")==0)
  {
    add_indent(newtoken);
    sprintf(newtoken,"OCILogOff($%s_cursor);",variable);
    /* { sprintf(newtoken,"oracle_close($%s_cursor)",variable); } */
  }

  return 0;
}

