/*
 * Copyright (c) 1995 - 2006 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#include <nnpfs/nnpfs_locl.h>
#include <nnpfs/nnpfs_message.h>
#include <nnpfs/nnpfs_msg_locl.h>
#include <nnpfs/nnpfs_fs.h>
#include <nnpfs/nnpfs_dev.h>
#include <nnpfs/nnpfs_deb.h>

RCSID("$Id: nnpfs_dev-freebsd.c,v 1.6 2006/03/28 13:26:14 tol Exp $");

#define NNPFS_FBSD_DEVLOCK

void
nnpfs_dev_lock(struct nnpfs *chan) 
{
#ifdef NNPFS_FBSD_DEVLOCK
    NNPFSDEB(XDEBDEV, ("nnpfs_dev_lock\n"));
    mtx_lock(&chan->dev_lock);
#endif
}

void
nnpfs_dev_unlock(struct nnpfs *chan)
{
#ifdef NNPFS_FBSD_DEVLOCK
    NNPFSDEB(XDEBDEV, ("nnpfs_dev_unlock\n"));
    mtx_unlock(&chan->dev_lock);
#endif
}

int
nnpfs_dev_initlock(struct nnpfs *chan)
{
#ifdef NNPFS_FBSD_DEVLOCK
    NNPFSDEB(XDEBDEV, ("nnpfs_dev_initlock\n"));
    mtx_init(&chan->dev_lock, "nnpfsdevlock", NULL, MTX_DEF);
    mtx_lock(&chan->dev_lock);
    return 0;
#endif
}

void
nnpfs_dev_uninitlock(struct nnpfs *chan)
{
#ifdef NNPFS_FBSD_DEVLOCK
    NNPFSDEB(XDEBDEV, ("nnpfs_dev_uninitlock\n"));

    /*
     * contrary to man page, it seems we need to unlock the mutex before
     * destroying it if we use spinlocks. Default mutexes are ok.
     */
    mtx_destroy(&chan->dev_lock);
#endif
}

#ifndef NNPFS_FBSD_DEVLOCK

#ifndef D_NEEDGIANT
#define D_NEEDGIANT 0
#endif

#endif

struct cdevsw nnpfs_cdev = {
#if __FreeBSD_version >= 502103
    d_version: D_VERSION,
#endif
    d_name: "nnpfs",
    d_open: nnpfs_devopen,
    d_close: nnpfs_devclose,
    d_read: nnpfs_devread,
    d_write: nnpfs_devwrite,
    d_ioctl: nnpfs_devioctl,
#ifdef HAVE_STRUCT_CDEVSW_D_MMAP
    d_mmap: nommap,
#endif
#ifdef HAVE_STRUCT_CDEVSW_D_STRATEGY
    d_strategy: nostrategy,
#endif
    /*
     * Giant is no longer needed, nnpfs_node_find & friends are locked
     * now, verify correctness before removing.
     */
#ifdef NNPFS_FBSD_DEVLOCK
    d_flags: 0,
#else
    d_flags: D_NEEDGIANT,
#endif

#ifdef HAVE_STRUCT_CDEVSW_D_STOP
    d_stop: nostop,
#endif
#ifdef HAVE_STRUCT_CDEVSW_D_RESET
    d_reset: noreset,
#endif
#ifdef HAVE_STRUCT_CDEVSW_D_BOGORESET
    d_bogoreset: noreset,
#endif
#ifdef HAVE_STRUCT_CDEVSW_D_DEVTOTTY
    d_devtotty: nodevtotty,
#endif
#if defined(HAVE_VOP_SELECT)
    d_select: nnpfs_devselect,
#elif defined(HAVE_VOP_POLL)
    d_poll: nnpfs_devpoll,
#else
#error select or poll: that is the question
#endif
#ifdef HAVE_STRUCT_CDEVSW_D_BOGOPARMS
    d_bogoparms: noparms,
#endif
#ifdef HAVE_STRUCT_CDEVSW_D_SPARE
    d_spare: NULL,
#endif
    d_maj: 128,			/* XXX */
#ifdef HAVE_STRUCT_CDEVSW_D_DUMP
    d_dump: nodump,
#endif
#ifdef HAVE_STRUCT_CDEVSW_D_PSIZE
    d_psize: nopsize,
#endif
#ifdef HAVE_STRUCT_CDEVSW_D_MAXIO
    d_maxio: 0,
#endif
#ifdef HAVE_STRUCT_CDEVSW_D_BMAJ
#ifdef NOUDEV
    d_bmaj: NOUDEV
#else
    d_bmaj: NODEV
#endif
#endif /* HAVE_STRUCT_CDEVSW_D_BMAJ */
};
